/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARD2APPLET_H
#define SKGDASHBOARD2APPLET_H
/** @file
 * Applet for generic widget
*
* @author Siddharth SHARMA
*/

#include <Plasma/Applet>
#include <QGraphicsLinearLayout>
class QGraphicsWidget;
class SKGWidget;

/**
 * Applet for generic widget
 */
class SKGDashboard2Applet : public Plasma::Applet
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    SKGDashboard2Applet(QObject *parent, const QVariantList &args);


    /**
     * Default Destructor
     */
    virtual ~SKGDashboard2Applet();

    /**
     * Set the graphical widget
     * @param iWidget the graphical widget
     */
    virtual void setGraphicsWidget(QGraphicsWidget* iWidget);

    /**
     * Get the graphical widget
     * @return a pointer to the graphical widget
     */
    virtual QGraphicsWidget *graphicsWidget() const;

    /**
     * Set the widget
     * @param iWidget the widget
     */
    virtual void setSKGWidget(SKGWidget* iWidget);

    /**
     * Get the widget
     * @return a pointer to the widget
     */
    virtual SKGWidget *getSKGWidget() const;

private:

    SKGWidget* m_widget;
    QGraphicsWidget* m_gwidget;
    QGraphicsLinearLayout* m_layout;
};

#endif // SKGDASHBOARD2APPLET_H
