/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for operation management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgsplittabledelegate.h"
#include "skgcombobox.h"
#include "skgcalculatoredit.h"
#include "skgmainpanel.h"
/**
 * Index for amount attribute
 */
static const int AMOUNTINDEX = 1;
/**
 * Index for category attribute;
 */
static const int CATEGORYINDEX = 0;
/**
 * Index for comment attribute
 */
static const int COMMENTINDEX = 2;
/**
 * Index for refund attribute
 */
static const int REFUNDINDEX = 3;

SKGSplitTableDelegate::SKGSplitTableDelegate(QObject* parent, SKGDocument* iDoc) : QItemDelegate(parent), m_document(iDoc) {}

SKGSplitTableDelegate::~SKGSplitTableDelegate()
{
    m_document = NULL;
}

QWidget *SKGSplitTableDelegate::createEditor(QWidget *parent,
        const QStyleOptionViewItem & option ,
        const QModelIndex & index) const
{
    if(index.column() == CATEGORYINDEX) {
        SKGComboBox *editor = new SKGComboBox(parent);
        editor->setEditable(true);
        if(m_document) SKGMainPanel::fillWithDistinctValue(editor, m_document, "category", "t_fullname", "");

        return editor;
    } else if(index.column() == COMMENTINDEX) {
        SKGComboBox *editor = new SKGComboBox(parent);
        editor->setEditable(true);
        if(m_document) SKGMainPanel::fillWithDistinctValue(editor, m_document, "operation", "t_comment", "");

        return editor;
    } else if(index.column() == AMOUNTINDEX) {
        SKGCalculatorEdit *editor = new SKGCalculatorEdit(parent);
        editor->setMode(SKGCalculatorEdit::EXPRESSION);
        QMapIterator<QString, double> i(m_parameters);
        while(i.hasNext()) {
            i.next();
            editor->addParameterValue(i.key(), i.value());
        }

        return editor;
    } else if(index.column() == REFUNDINDEX) {
        SKGComboBox *editor = new SKGComboBox(parent);
        editor->setEditable(true);
        if(m_document) SKGMainPanel::fillWithDistinctValue(editor, m_document, "refund", "t_name", "t_close='N'");

        return editor;
    }

    return QItemDelegate::createEditor(parent, option , index);
}

void SKGSplitTableDelegate::setEditorData(QWidget* editor, const QModelIndex& index) const
{
    if(index.column() == AMOUNTINDEX) {
        SKGCalculatorEdit *calculator = static_cast<SKGCalculatorEdit*>(editor);
        if(calculator) {
            calculator->setText(index.model()->data(index, Qt::ToolTipRole).toString());
        }
    } else {
        QItemDelegate::setEditorData(editor, index);
    }
}

void SKGSplitTableDelegate::setModelData(QWidget* editor, QAbstractItemModel* model, const QModelIndex& index) const
{

    if(index.column() == AMOUNTINDEX) {
        SKGCalculatorEdit *calculator = static_cast<SKGCalculatorEdit*>(editor);
        if(calculator && model) {
            QString f = calculator->formula();
            QString t = calculator->text();
            if(f.isEmpty()) f = t;
            model->setData(index, f, Qt::ToolTipRole);
            model->setData(index, t, Qt::DisplayRole);
        }
    } else {
        QItemDelegate::setModelData(editor, model, index);
    }
}

void SKGSplitTableDelegate::addParameterValue(const QString& iParameter, double iValue)
{
    m_parameters.insert(iParameter, iValue);
}

#include "skgsplittabledelegate.moc"
