
#define IO_START_ADDR 0xFFC00000
#define IO_END_ADDR 0xFFFFFFFF

#define DMA_IO_START_ADDR 0xFFC00B00
#define DMA_IO_END_ADDR 0xFFC00FFF

#define UART_IO_START_ADDR 0xFFC00400
#define UART_IO_END_ADDR 0xFFC004FF

#define CORETIMER_IO_START_ADDR 0xFFE03000
#define CORETIMER_IO_END_ADDR 0xFFE0300C

#define EBIU_IO_START_ADDR 0xFFC00A00
#define EBIU_IO_END_ADDR 0xFFC00AFF

#define TCNTL 0x0
#define TPERIOD 0x4
#define TSCALE 0x8
#define TCOUNT 0xc

#define CORE_INT_IO_START_ADDR 0xFFE02000
#define CORE_INT_IO_END_ADDR 0xFFE02110

#define WD_IO_START_ADDR 0xFFC00200
#define WD_IO_END_ADDR 0xFFC002FF

#define DEU_IO_START_ADDR 0xFFE05000
#define DEU_IO_END_ADDR 0xFFE05008

#define DPMC_IO_START_ADDR 0xFFC00000
#define DPMC_IO_END_ADDR 0xFFC000FF

#define SIC_IO_START_ADDR 0xFFC00100
#define SIC_IO_END_ADDR 0xFFC001FF

#define L1MEM_IO_START_ADDR 0xFFE01004
#define L1MEM_IO_END_ADDR 0xFFE01404
#define L1MEM_IO_SIZE (L1MEM_IO_END_ADDR - L1MEM_IO_START_ADDR)

#define L1DMEM_IO_START_ADDR 0xFFE00000
#define L1DMEM_IO_END_ADDR 0xFFE00404
#define L1DMEM_IO_SIZE (L1DMEM_IO_END_ADDR - L1DMEM_IO_START_ADDR)

#define RTC_IO_START_ADDR 0xFFC00300
#define RTC_IO_END_ADDR 0xFFC003FF
#define RTC_IO_SIZE (RTC_IO_END_ADDR - RTC_IO_START_ADDR)

#define CORE_TIMER_IO_START_ADDR 0xFFE03000
#define CORE_TIMER_IO_END_ADDR 0xFFE03010
#define CORE_TIMER_IO_SIZE (CORE_TIMER_IO_END_ADDR-CORE_TIMER_IO_START_ADDR)

#define PF_IO_START_ADDR 0xFFC00700
#define PF_IO_END_ADDR 0xFFC007FF
#define PF_IO_SIZE (PF_IO_END_ADDR - PF_IO_START_ADDR)

#define TBUF_IO_START_ADDR 0xFFE06000
#define TBUF_IO_END_ADDR 0xFFE06103
#define TBUF_IO_SIZE (TBUF_IO_END_ADDR - TBUF_IO_START_ADDR)

#define declare_device(name) \
static void name##_write_byte(bu32 addr, bu8 v); \
static void name##_write_word(bu32 addr, bu16 v); \
static void name##_write_long(bu32 addr, bu32 v); \
static bu8 name##_read_byte(bu32 addr); \
static bu16 name##_read_word(bu32 addr); \
static bu32 name##_read_long(bu32 addr);
