define dump_stack(func)
{
   variable x = _stkdepth();
   if (x) {
	() = fprintf(stderr,"Stack Contents After Calling <%S>:\n",func);
	_print_stack();
	_pop_n(_stkdepth());
	() = fprintf(stderr,"\n");
   }

   () = fflush(stderr);
}

define print()
{
   variable args = __pop_args(_NARGS);
   if (length(args))
	() = printf(__push_args(args));
   () = printf("\n");
   () = fflush(stdout);
}

define _try()
{
   variable args = __pop_args(_NARGS - 1);
   variable func = ();

#ifeval _slang_version < 20000
   ERROR_BLOCK { _clear_error(); print; }
   @func(__push_args(args));
#else
   variable excep;
   try (excep) { @func(__push_args(args)); }
   catch AnyError: { vmessage(excep.message); print; }
#endif

   dump_stack(func);
}

define check_ignored(thing)
{
   if (is_defined(thing))
	print("Error: %s NOT properly ignored by code generator",thing);
}
