#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "slatevm.h"
#include "image.h"
#include "file.h"

#ifdef SLATE_USE_ANSI_FILES

static FILE * files [SLATE_FILES_MAXIMUM];

void initFileModule ()
{
	memset(files, 0, sizeof(files));
}

int
allocateFile (void)
{
	int file;

	for (file = 0; file < SLATE_FILES_MAXIMUM; ++ file)
	{
		if (files [file] == NULL)
			return file;
	}

	return -1;
}

void
closeFile (int file)
{
	if (files [file] != NULL)
	{
		fclose (files [file]);

		files [file] = NULL;
	}
}

/*
int
openFile (struct ByteArray * name, char * mode)
{
        char nameString [SLATE_FILE_NAME_LENGTH];
        size_t nameLength = PSObject_payloadSize ((struct Object *) name);
        int file;
        
        if (nameLength >= sizeof (nameString))
          return -1;

        memcpy (nameString, name -> elements, nameLength);
        nameString [nameLength] = '\0';

        file = allocateFile ();
        if (file < 0)
          return -1;

        files [file] = fopen (nameString, mode);
        if (files [file] == NULL)
          return -1;

        return file;
}
*/

int
openFile (struct ByteArray * name, int flags)
{
	char nameString[SLATE_FILE_NAME_LENGTH];
	int nameLength;
	char mode[8];
	int modeIndex = 0;
	int file;

	// TODO        
	//printf("Trying to open file...");

	nameLength = extractCString (name, nameString, sizeof(nameString));

	if (nameLength <= 0)
		return -1;

	file = allocateFile ();
	if (file < 0)
		return -1;

	// (CLEAR \/ CREATE) /\ !WRITE
	if ((flags & SF_CLEAR || flags & SF_CREATE) && (! (flags & SF_WRITE)))
		error("ANSI does not support clearing or creating files that are not opened for writing");
	
	// WRITE /\ !READ
	if (flags & SF_WRITE && (! (flags & SF_READ)))
		error("ANSI does not support opening files for writing only");

	if (flags & SF_WRITE)
	{
		if (flags & SF_CLEAR)
		{
			mode[modeIndex++] = 'w';

			if (flags & SF_READ)
			{
				mode[modeIndex++] = '+';
			}
		}
		else
		{
			mode[modeIndex++] = 'r';
			mode[modeIndex++] = '+';
		}
	}
	else if (flags & SF_READ)
	{
		mode[modeIndex++] = 'r';
	}
	else
	{
		fprintf(stderr, "Slate: Unexpected mode flags for ANSI file module: %d, falling back to \"r\"", flags);
		mode[modeIndex++] = 'r';
	}

	mode[modeIndex++] = 'b';
	mode[modeIndex++] = 0;

	files [file] = fopen (nameString, mode);
	if (files [file] == NULL)
		return -1;

	// TODO 
	//printf("File '%s' successfully opened in mode %d\n", nameString, mode);

	return file;
}

int
writeFile (int file, int n, char * bytes)
{
	return fwrite (bytes, 1, n, files [file]);
}

int
readFile (int file, int n, char * bytes)
{
	return fread (bytes, 1, n, files [file]);
}

int
sizeOfFile (int file)
{
	int pos = ftell (files [file]),
		size;
	fseek (files [file], 0, SEEK_END);
	size = ftell (files [file]);
	fseek (files [file], pos, SEEK_SET);
	return size;
}

int
seekFile (int file, int offset)
{
	if (fseek (files [file], offset, SEEK_SET) == 0)
		return ftell (files [file]);
	return -1;
}

int
tellFile (int file)
{
	return ftell (files [file]);
}

//TODO: Bool, True, False
int
endOfFile (int file)
{
	int c = fgetc (files [file]);
	if (c == EOF)
		return 1;
	ungetc (c, files [file]);
	return 0;
}

#endif // SLATE_USE_ANSI_FILES
