#ifndef __SLATE_JIT_H__
#define __SLATE_JIT_H__

#include "env.h"

#define JIT_CACHE_SIZE          (1 << 20)
#define JIT_CACHE_METHODS       (1 << 10)

#define JIT_SPACE_PER_BC        64

#ifdef USE_X86_JIT

#define JIT_ACTIVATION_THRESHOLD      32
#define JIT_PROFILE(method)           ((method) -> profileCounter += 1 << 1)
#define JIT_ACTIVATE(method)          ((method) -> profileCounter = ((JIT_ACTIVATION_THRESHOLD << 1) | 1))
#define JIT_IS_ACTIVATED(method)      ((method) -> profileCounter >= ((JIT_ACTIVATION_THRESHOLD << 1) | 1))

#define JIT_RUN(interp) \
        while(JIT_IS_ACTIVATED((interp)->method) && \
              jitRun((interp), (interp)->method) >= 0);

struct Interpreter;
struct CompiledMethod;

extern void jitFlush (void);
extern int jitRun (struct Interpreter *, struct CompiledMethod *);
extern void initJitModule (void);

#else /* !USE_X86_JIT */

#define JIT_PROFILE(method)
#define JIT_RUN(interp)
#define jitFlush()
#define initJitModule()

#endif /* USE_X86_JIT */

#endif /* __SLATE_JIT_H__ */

