#include <fcntl.h>
#include <unistd.h>

#include "slatevm.h"
#include "image.h"
#include "file.h"

#ifndef SLATE_USE_ANSI_FILES

static int files [SLATE_FILES_MAXIMUM];

void initFileModule ()
{
	memset(files, 0, sizeof(files));
}

int
allocateFile (void)
{
	int file;

	for (file = 0; file < SLATE_FILES_MAXIMUM; ++ file)
	{
		if (files [file] == 0)
		return file;
	}

	return -1;
}

void
closeFile (int file)
{
	if (files [file] != 0)
	{
		close (files [file]);

		files [file] = 0;
	}
}

int
openFile (struct ByteArray * name, int flags)
{
	char nameString[SLATE_FILE_NAME_LENGTH];
	int nameLength = extractCString (name, nameString, sizeof(nameString));
	int file;
	mode_t openMode = 0;
	
	//printf("Trying to open file... ");

	if (nameLength <= 0)
		return -1;
		
	file = allocateFile ();
	if (file < 0)
		return -1;

	if ((flags & SF_READ) && (flags & SF_WRITE))
		openMode |= O_RDWR;
	else if (flags & SF_WRITE)
		openMode |= O_WRONLY;
	else
		openMode |= O_RDONLY;
	
	if (flags & SF_CREATE)
		openMode |= O_CREAT;

	if (flags & SF_CLEAR)
		openMode |= O_TRUNC;

	files[file] = open (nameString, openMode, S_IRUSR | S_IWUSR);
	
	if (files [file] < 0)
	{
		files [file] = 0;
		return -1;
	}

	//printf("File '%s' successfully opened in mode %d\n", fileName, openMode);

	return file;
}


int
writeFile (int file, int n, char * bytes)
{
	return write (files [file], bytes, n);
}

int
readFile (int file, int n, char * bytes)
{
	return read (files [file], bytes, n);
}

int
sizeOfFile (int file)
{
	off_t currentPos = lseek (files [file], 0, SEEK_CUR);
	off_t size = lseek (files [file], 0, SEEK_END);
	lseek (files[file], currentPos, SEEK_SET);

	return size;
}

int
seekFile (int file, int offset)
{
	return lseek (files [file], offset, SEEK_SET);
}

int
tellFile (int file)
{
	return lseek (files [file], 0, SEEK_CUR);
}

//TODO: should be Bool from slatevm.h, but does not compile
int
endOfFile (int file)
{
	off_t currentPos = lseek (files [file], 0, SEEK_CUR);
	off_t size = lseek (files [file], 0, SEEK_END);
	lseek (files[file], currentPos, SEEK_SET);

	return currentPos >= size;
}

#endif // !SLATE_USE_ANSI_FILES
