#include <stdlib.h>
#include <assert.h>
#include <windows.h>

#include "slatevm.h"
#include "extprim.h"

#define BYTEARRAY_LEN(x)	(PSObject_payloadSize((struct Object *) (x)))

static char *safe_string(struct ByteArray *s, char const *suffix) {
  size_t len = BYTEARRAY_LEN(s);
  char *result = malloc(strlen(suffix) + len + 1);
  if (result == NULL)
    return NULL;
  memcpy(result, s->elements, len);
  strcpy(result + len, suffix);
  return result;
}

Bool openExternalLibrary(struct ByteArray *libname,
			struct ByteArray *handle)
{
  char *fullname;
  HMODULE h;

  assert(BYTEARRAY_LEN(handle) >= sizeof(h));

  fullname = safe_string(libname, ".dll");
  if (fullname == NULL)
    return False;

  h = LoadLibrary(fullname);
  free(fullname);

  if (h == NULL) {
    return False;
  } else {
    memcpy(handle->elements, &h, sizeof(h));
    return True;
  }
}

Bool closeExternalLibrary(struct ByteArray *handle) {
  HMODULE h;

  assert(BYTEARRAY_LEN(handle) >= sizeof(h));
  memcpy(&h, handle->elements, sizeof(h));

  return FreeLibrary(h) ? True : False;
}

Bool lookupExternalLibraryPrimitive(struct ByteArray *handle,
				   struct ByteArray *symname,
				   struct ByteArray *ptr)
{
  HMODULE h;
  void * fn;
  char *symbol;

  assert(BYTEARRAY_LEN(handle) >= sizeof(h));
  assert(BYTEARRAY_LEN(ptr) >= sizeof(fn));

  symbol = safe_string(symname, "");
  if (symbol == NULL)
    return False;

  memcpy(&h, handle->elements, sizeof(h));
  fn = (void *) GetProcAddress(h, symbol);
  free(symbol);

  if (fn == NULL) {
    return False;
  } else {
    memcpy(ptr->elements, &fn, sizeof(fn));
    return True;
  }
}

