/*****************************************************************
/
/ File   :   ctapi.c
/ Author :   David Corcoran
/ Date   :   September 2, 1998
/ Purpose:   Defines CT-API functions
/ License:   See file LICENSE
/
******************************************************************/

#include <stdio.h>
#include "defines.h"
#include "ctapi.h"
#include "serial.h"

/* Initializes the port on which the reader resides */

int  CT_init ( unsigned int Ctn,  unsigned int pn ) {
  
  bool BretVal;        /* Return value from IO_InitializePort() */
  int IretVal;         /* Return for this function */  

  switch( pn ) {

  case PORT_COM1:

    #ifdef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/cua/a");
    #endif

    #ifndef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/ttyS0");
    #endif

    break;

  case PORT_COM2:

    #ifdef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/cua/b");
    #endif

    #ifndef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/ttyS1");
    #endif

    break;

  case PORT_COM3:

    #ifdef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/cua/c");
    #endif

    #ifndef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/ttyS2");
    #endif

    break;

  case PORT_COM4:

    #ifdef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/cua/d");
    #endif

    #ifndef SUN_SPARC
     BretVal = IO_InitializePort(9600,8,'E',"/dev/ttyS3");
    #endif

    break;

  case PORT_Printer:

   BretVal = IO_InitializePort(9600,8,'E',"Printer Port");
   break;

  case PORT_Modem:

   BretVal = IO_InitializePort(9600,8,'E',"Modem Port");
   break;

  default:
    BretVal = IO_InitializePort(9600,8,'E',"/dev/smartcard");
    break;
  }
  
  if (BretVal != TRUE) {
    IretVal = ERR_MEMORY;        /* Could not allocate port */
  } else {
    IretVal = OK;
  }
  
  return IretVal;  
}

/* Closes the port in which the reader resides */

int  CT_close( unsigned int Ctn ) {
  
  if (IO_Close() == TRUE) {
    return OK;
    
  } else {
    return ERR_CT;
    
  }
}            

/* Sends/Receives Data to/from the Reader */

int  CT_data( unsigned int ctn, unsigned char *dad, unsigned char *sad,
              unsigned int  lc, unsigned char *cmd, unsigned int  *lr,
              unsigned char *rsp ) {
  
  /* Reader specific CT-BCS commands */
  
  unsigned char pcSetMode[6] = {0x61, 0x00, 0x00, 0x10, 0x00, 0x00};
  unsigned char cReset       = 0x64;
  unsigned char cStatus      = 0x65;
  unsigned char cActivate    = 0x60;
  unsigned char cDeActivate  = 0x6A;

  unsigned char BoutComm[MAX_BUFFER_SIZE];    /* Command Buffer  */
  unsigned char BackByte;                     /* Ack Byte        */
  unsigned char BrdrResp[3];                  /* Reader Response */
  unsigned char cRdrIrsp[5];                  /* Ack + Size Resp */
  unsigned int  lctb;                         /* CTBCS Size      */
  int IretVal;                                /* Return Value    */
  int i;


  *lr = 0;

 if ( *dad == 1 ) {             /* This command goes to the reader */
    *sad = 1;                   /* Source Reader    */
    *dad = 2;                   /* Destination Host */

                                /* The following is NOT a CTBCS    */
  /*******************/
  /* CT-BCS Commands */
  /*******************/

  /* Request ICC  - Turns on the reader/card */

  if ( (cmd[0] = 0x20) && (cmd[1] == 0x12) ) {
    IretVal = ERR_TRANS;         /* Transmission Error by default */
    if ( IO_UpdateReturnBlock( 5 ) ) {
      if ( IO_Write( cActivate ) ) {
        if ( IO_Read( 1, &BackByte ) ) {
          if ( BackByte == 0x60 ) {
            sleep(2);            /* Wait for reader to respond    */
            IO_FlushBuffer();    /* Flush all chars on stream     */
            *lr = 0;
            IretVal = OK;
          }
        }
      }
    }
    
  /* Resets the Card/Terminal and returns Atr */

  } else if ( (cmd[0] = 0x20) && (cmd[1] == 0x11) ) {

    IretVal = ERR_TRANS;         /* Transmission Error by default */
    if ( IO_UpdateReturnBlock( 5 ) ) {
      if ( IO_Write( cReset ) ) {
        if ( IO_Read( 4, cRdrIrsp ) ) {
          if ( cRdrIrsp[0] == 0x62 ) {              /* Ack         */
            if ( IO_Read( cRdrIrsp[3], rsp ) ) {   /* Read Atr    */
              *lr = cRdrIrsp[3] + 2;               /* Size of Atr */
              rsp[cRdrIrsp[3]] = 0x90; rsp[cRdrIrsp[3]+1] = 0x00; 
              IretVal = OK;

              /*   This set's the reader mode to T=0 
                   It must be done here since no     
                   protocol has been negotiated after
                   resets                             */
   
               for (i=0; i<sizeof(pcSetMode); i++) {
                 if ( IO_Write(pcSetMode[i]) ) {
	           if ( IO_Read( 1, &BackByte ) ) {
	             if ( BackByte != 0x62 ) {
                       IretVal = ERR_TRANS;
                     }
                   }
                 }
               }
            }
          }
        }
      }
    }

  /* Get Status - Gets reader status */

  } else if ( (cmd[0] = 0x20) && (cmd[1] == 0x13) ) {
    if ( IO_UpdateReturnBlock( 5 ) ) {
      if ( IO_Write( cStatus ) ) {
        if ( IO_Read( 2, cRdrIrsp ) ) {
             IO_FlushBuffer();

          *lr = 1;                            /* CT-BCS status byte    */

          if ( cRdrIrsp[1] == 0x19 ) {
            rsp[0] = 0x04;                    /* ICC inserted/powered  */
            IretVal = OK;
          } else if ( cRdrIrsp[2] == 0x02 ) {
            rsp[0] = 0x03;                    /* ICC inserted/no power */
            IretVal = OK;
          } else if ( cRdrIrsp[1] <= 0x01 ) {
            rsp[0] = 0x00;                    /* No ICC/no power       */
            IretVal = OK;
          } else {
            *lr = 0;
            IretVal = ERR_TRANS;
          }
        }
      }
    }

  /* Eject ICC - Deactivates Reader  */

  } else if ( (cmd[0] = 0x20) && (cmd[1] == 0x15) ) {
    if ( IO_UpdateReturnBlock( 5 ) ) {
      if ( IO_Write( cDeActivate ) ) {
        IretVal = OK;
      }
    }

  } else {
      for (i=0; i < lc; i++) {
        if (IO_Write( cmd[i] )) {
          IretVal = OK;           /* Transmission OK */
        }
        else {
          IretVal = ERR_TRANS;    /* Transmission Error */
          break;
        }
      }
  }

 } else if ( *dad == 0 ) {      /* This command goes to the card */
    
    *sad = 0;  /* Source Smartcard */
    *dad = 2;  /* Destination Host */
    
    BoutComm[0] = 0x67;        /* Send Reader Block */
    BoutComm[1] = 0x00;
    BoutComm[2] = lc;          /* Length of command */
    
    memcpy( &BoutComm[3], cmd, lc );  /* Copy the command */
    
    for ( i=0; i < lc+3; i++ ) {
      if ( !IO_Write( BoutComm[i] ) ) {
	IretVal = ERR_TRANS;          /* Transmission Error */
	break;
      }
      else {
	IretVal = OK;                 /* Transmission OK */
      }
    }
    
    IO_UpdateReturnBlock(5);
    
    if ( IretVal == OK ) {                /* Transmission was OK */
      if ( IO_Read( 1, &BackByte ) ) {
	if ( BackByte ==  0x62 ) {         /* Reader Acks         */
	  if ( IO_Read( 3, BrdrResp ) ) {  /* Response Block/Size */
	    if ( BrdrResp[0] == 0x64 ) {   /* Sending Block       */
	      *lr = BrdrResp[2];           /* Length of Return    */
	      if ( IO_Read( *lr, rsp ) ) { /* Gets Response       */
		IretVal = OK;
	      } else {
		IretVal = ERR_TRANS;       /* Transmission Error */
	      }          
	    } else {
	      IretVal = ERR_INVALID;     /* Invalid Command    */
	    } 
	  } else {
	    IretVal = ERR_TRANS;         /* Transmission Error */
	  }
	} else {
	  IretVal = ERR_INVALID;         /* Invalid Command    */
	}
      } else {
	IretVal = ERR_TRANS;             /* Transmission Error */
      }
    }
  } else {
    IretVal = ERR_INVALID;              /* Invalid Destination */
  }

  if (IretVal != OK) {
    *lr = 0;
  }
  
  return IretVal;
}

