/* 
 * The Sleuth Kit
 *
 * $Date: 2005/01/17 22:40:17 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003-2005 Brian Carrier.  All rights reserved
 *
 * This file is part of mmtools
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 */
#ifndef _DOS_H
#define _DOS_H

typedef struct {
    uint8_t boot;
    uint8_t start_chs[3];
    uint8_t ptype;
    uint8_t end_chs[3];
    uint8_t start_sec[4];
    uint8_t size_sec[4];
} dos_part;

/* Boot Sector w/partition table */
typedef struct {
    uint8_t f1[3];
    /* the next three are actually part of NTFS and FAT, but
     * we use them for sanity checks in the detect code */
    char oemname[8];
    uint8_t ssize[2];		/* sector size in bytes */
    uint8_t csize;		/* cluster size in sectors */
    uint8_t filler[432];
    dos_part ptable[4];
    uint8_t magic[2];
} dos_sect;

#define DOS_MAGIC	0xaa55
#define DOS_PART_OFFSET 0

#endif
