# Script for compiling libewf
# as part of The Sleuth Kit
#
# $Date: 2006/12/06 17:32:51 $
#
cd libewf
if (test -f './Makefile') then
    true
else
    ./configure || (cd ..; exit $?)
fi

make -C src libewf.a

if (test -f 'src/libewf.a') then 
    mkdir libewf-tsk
    if (test -d 'libewf-tsk') then
	cp src/libewf.a libewf-tsk
	(cd libewf-tsk; ar x libewf.a; cd ..)
	ar rv ../../lib/libtsk.a libewf-tsk/*.o
	rm -rf libewf-tsk
    else
	echo "Error creating tmp directory in libewf"
	cd ..
	exit 1
    fi
else
    echo "Error: Missing src/libewf.a file"
    cd ..
    exit 1
fi

cd ..
