
static variable window = NULL;
static variable cursor_class = gtk_type_class(gdk_cursor_type_get_type());
static variable cursor_label;

static define set_cursor(spinb,cursor_window)
{
   variable cursor_num = gtk_spin_button_get_value_as_int(spinb);
   variable cursor = gdk_cursor_new(cursor_num);
   variable cursor_name = g_enum_get_value(cursor_class,cursor_num);

   gdk_window_set_cursor(gtk_widget_get_window(cursor_window),cursor);
   gtk_label_set_text(cursor_label,cursor_name.value_name);
}

define create_cursors (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	gtk_window_set_title(window, "Cursors");
	gtk_window_set_default_size(window, 250, 150);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable label = gtk_label_new ("\nClick on the spinbutton to\n"+
					"change the cursor type. This demo\n"+
					"also gives several examples of\n"+
					"using the GObject type system.\n\n");
	gtk_container_add(vbox,label);

	variable hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width ( hbox, 5);
	gtk_box_pack_start (vbox, hbox, FALSE, TRUE, 0);
      
	label = gtk_label_new ("Cursor Value: ");
	gtk_misc_set_alignment (label, 0, 0.5);
	gtk_box_pack_start (hbox, label, FALSE, TRUE, 0);
      
	variable adj = gtk_adjustment_new (GDK_MAN, 0, 152, 2, 10, 0);
	variable spinb = gtk_spin_button_new (adj, 0, 0);
	gtk_box_pack_start (hbox, spinb, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width (hbox, 5);
	gtk_box_pack_start (vbox, hbox, FALSE, TRUE, 0);
	label = gtk_label_new ("Cursor Name: ");
	gtk_box_pack_start (hbox, label, FALSE, TRUE, 0);
	cursor_label = gtk_label_new ("");
	gtk_box_pack_start (hbox, cursor_label, FALSE, TRUE, 0);

	() = g_signal_connect(spinb,"changed",&set_cursor,window);

	test.lower = generic_close_button(vbox,window);
  }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else {
	gtk_widget_show_all (window);
	set_cursor(spinb,window);
   }
}
