static variable window = NULL;

define reparent_label (widget, new_parent)
{
  variable label = g_object_get_data (widget,"user_data");
  gtk_widget_reparent (label, new_parent);
}

define set_parent_signal (child, old_parent, func_data)
{
  variable new_parent = gtk_widget_get_parent(child);
  variable new_parent_name = "NULL", old_parent_name = "NULL";

  if (new_parent != NULL)
     new_parent_name = g_type_name(gtk_object_type(new_parent));

  if (old_parent != NULL)
     old_parent_name = g_type_name(gtk_object_type(old_parent));
  
  () = printf("set_parent for \"%s\": new parent: \"%s\""+
  		", old parent: \"%s\", data: %S\n",
		g_type_name (gtk_object_type(child)),
  		new_parent_name, old_parent_name, func_data);
}

define create_reparent (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	() = g_signal_connect (window, "destroy",&gtk_widget_destroyed,&window);

	gtk_window_set_title (window, "Reparent");
	gtk_container_set_border_width ( window, 0);

	variable box1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add ( window, box1);

	variable box2 = gtk_hbox_new (FALSE, 5);
	gtk_container_set_border_width ( box2, 10);
	gtk_box_pack_start (box1, box2, TRUE, TRUE, 0);

	variable label = gtk_label_new ("Woof, woof!");
	variable frame = gtk_frame_new ("Frame 1");
	gtk_box_pack_start (box2, frame, TRUE, TRUE, 0);

	variable box3 = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width ( (box3), 5);
	gtk_container_add ( frame, box3);

	variable button = gtk_button_new_with_label ("Switch");
	() = g_signal_connect (button, "clicked", &reparent_label, box3);
	g_object_set_data (button, "user_data", label);
	gtk_box_pack_start (box3, button, FALSE, TRUE, 0);

	gtk_box_pack_start (box3, label, FALSE, TRUE, 0);
	() = g_signal_connect (label, "parent_set", &set_parent_signal, 42);

	frame = gtk_frame_new ("Frame 2");
	gtk_box_pack_start (box2, frame, TRUE, TRUE, 0);

	box3 = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width ( (box3), 5);
	gtk_container_add ( frame, box3);

	button = gtk_button_new_with_label ("Switch");
	() = g_signal_connect (button, "clicked", &reparent_label, box3);
	g_object_set_data (button, "user_data", label);
	gtk_box_pack_start (box3, button, FALSE, TRUE, 0);

	test.lower = generic_close_button(box1,window);
    }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
