//Slicer
#include "vtkSlicerVolumeTextureMapper3D.h"
#include "vtkSlicerGPURayCastVolumeTextureMapper3D.h"
#include "vtkSlicerFixedPointVolumeRayCastMapper.h"
#include "vtkSlicerVRGrayscaleHelper.h"
#include "vtkVolumeRenderingGUI.h"
#include "vtkSlicerApplication.h"
#include "vtkSlicerColorDisplayWidget.h"
#include "vtkSlicerVolumePropertyWidget.h"
#include "vtkMRMLTransformNode.h"
#include "vtkMRMLLinearTransformNode.h"
#include "vtkSlicerBoxWidget2.h"
#include "vtkSlicerBoxRepresentation.h"
#include "vtkSlicerVisibilityIcons.h"
#include "vtkSlicerVRMenuButtonColorMode.h"
 
//VTK
#include "vtkObjectFactory.h"
#include "vtkVolume.h"
#include "vtkTimerLog.h"
#include "vtkRenderer.h"
#include "vtkPointData.h"
#include "vtkCellArray.h"
#include "vtkFloatArray.h"
#include "vtkTexture.h"
#include "vtkImageGradientMagnitude.h"
#include "vtkInteractorStyle.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkPlanes.h"
#include "vtkProperty.h"

//KWWidgets
#include "vtkKWHistogram.h"
#include "vtkKWHistogramSet.h"
#include "vtkKWProgressGauge.h" 
#include "vtkKWEvent.h"
#include "vtkKWMenuButtonWithSpinButtonsWithLabel.h"
#include "vtkKWProgressDialog.h"
#include "vtkKWScale.h"
#include "vtkKWScaleWithLabel.h"
#include "vtkKWCheckButtonWithLabel.h"
#include "vtkKWCheckButton.h"
#include "vtkKWFrameWithLabel.h"
#include "vtkKWNotebook.h"
#include "vtkKWMenuButtonWithLabel.h"
#include "vtkKWPushButton.h"
#include "vtkKWColorTransferFunctionEditor.h"
#include "vtkKWPiecewiseFunctionEditor.h"
#include "vtkKWMultiColumnListWithScrollbars.h"
#include "vtkKWMultiColumnList.h"
#include "vtkKWPushButtonWithLabel.h"
#include "vtkKWComboBoxWithLabel.h"
#include "vtkKWComboBox.h"
#include "vtkKWEntry.h"

//Compiler
#include <math.h>

vtkCxxRevisionMacro(vtkSlicerVRGrayscaleHelper, "$Revision: 1.46 $");
vtkStandardNewMacro(vtkSlicerVRGrayscaleHelper);

vtkSlicerVRGrayscaleHelper::vtkSlicerVRGrayscaleHelper(void)
{
    //Debug
    this->DebugOff();
    this->SetTCLDebug(0);
    this->Histograms=NULL;

    this->MapperTexture=NULL;
    this->MapperGPURaycast=NULL;
    this->MapperRaycast=NULL;
    this->RenderingMethod = -1;//users are required to select a mapper
    
    //GUI:
    this->CB_GPURayCastMIP=NULL;
    this->CB_GPURayCastShading=NULL;
    this->CB_GPURayCastForceHighQuality=NULL;
    this->CB_TextureMapperForceHighQuality=NULL;
    this->CB_GPURayCastLargeVolume=NULL;
    this->CB_CPURayCastForceHighQuality=NULL;
    this->SC_ExpectedFPS=NULL;
    this->MB_Mapper= NULL;
    this->SVP_VolumeProperty=NULL;
    
    this->FrameFPS = NULL;
    this->FrameGPURayCasting = NULL;
    this->FramePolygonBlending = NULL;
    this->FrameCPURayCasting = NULL;
    this->FramePerformance = NULL;
    
    //Cropping:
    this->CB_Cropping=NULL;
    this->RA_Cropping[0]=NULL;
    this->RA_Cropping[1]=NULL;
    this->RA_Cropping[2]=NULL;
    this->CurrentTransformNodeCropping=NULL;

    //ThresholdGUI
    this->MB_ThresholdMode=NULL;
    this->VRMB_ColorMode=NULL;
    this->RA_RampRectangleScalar=NULL;
    this->RA_RampRectangleOpacity=NULL;
    this->ThresholdMode=0;
    this->PB_Reset=NULL;
    this->PB_ThresholdZoomIn=NULL;

    //Clipping
    this->BW_Clipping_Widget=NULL;
    this->BW_Clipping_Representation = NULL;
    this->AdditionalClippingTransform=NULL;
    this->InverseAdditionalClippingTransform=NULL;

    //Set Standard Clipping Colors
    ColorsClippingHandles[0][0]=1;
    ColorsClippingHandles[0][1]=0;
    ColorsClippingHandles[0][2]=1;

    ColorsClippingHandles[1][0]=1;
    ColorsClippingHandles[1][1]=0;
    ColorsClippingHandles[1][2]=0;

    ColorsClippingHandles[2][0]=1;
    ColorsClippingHandles[2][1]=1;
    ColorsClippingHandles[2][2]=1;

    ColorsClippingHandles[3][0]=.89;
    ColorsClippingHandles[3][1]=.6;
    ColorsClippingHandles[3][2]=.07;

    ColorsClippingHandles[4][0]=0;
    ColorsClippingHandles[4][1]=0;
    ColorsClippingHandles[4][2]=1;

    ColorsClippingHandles[5][0]=0;
    ColorsClippingHandles[5][1]=0;
    ColorsClippingHandles[5][2]=0;

    //PauseResume
    this->PB_PauseResume=NULL;
    this->RenderingPaused=0;
    this->VI_PauseResume=NULL;
    this->BW_Clipping_Widget = NULL;

    this->UpdateingGUI = 0;
    
    this->IsTextureMappingSupported = 0;
    this->IsGPURayCastingSupported = 0;

    this->ButtonDown = 0;
    
    this->CPURayCastingInteractionFlag = 0;
}

vtkSlicerVRGrayscaleHelper::~vtkSlicerVRGrayscaleHelper(void)
{   
    //Remove Bindings
    this->Gui->Script("bind all <Any-ButtonPress> {}",this->GetTclName());
    this->Gui->Script("bind all <Any-ButtonRelease> {}",this->GetTclName());
     
    this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->GetProgressGauge()->SetNthValue(0,0);
    this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->GetProgressGauge()->SetNthValue(1,0);
    this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->GetProgressGauge()->SetNthValue(2,0);
    
    //Remove Obersvers
    this->MapperRaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
    this->MapperRaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
    this->MapperRaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
    this->MapperRaycast->RemoveObservers(vtkCommand::ProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

    this->MapperGPURaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
    this->MapperGPURaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
    this->MapperGPURaycast->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

    this->MapperTexture->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
    this->MapperTexture->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
    this->MapperTexture->RemoveObservers(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->RemoveObservers(vtkCommand::AbortCheckEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->RemoveObservers(vtkCommand::EndEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
    
   
    //Remove Volume
    if(this->SVP_VolumeProperty!=NULL)
    {
        this->Gui->Script("pack forget %s",this->SVP_VolumeProperty->GetWidgetName());
        this->SVP_VolumeProperty->SetHistogramSet(NULL);
        this->SVP_VolumeProperty->SetVolumeProperty(NULL);
        this->SVP_VolumeProperty->SetDataSet(NULL);
        this->SVP_VolumeProperty->SetParent(NULL);
        this->SVP_VolumeProperty->RemoveObservers(vtkKWEvent::VolumePropertyChangingEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->SVP_VolumeProperty->Delete();
        this->SVP_VolumeProperty=NULL;
    }
    
    if(this->Histograms!=NULL)
    {
        this->Histograms->RemoveAllHistograms();
        this->Histograms->Delete();
        this->Histograms=NULL;
    }
    
    //Delete the rendering pipeline
    //this->volumeWillBeDeletedInSuperClass
    if(this->MapperTexture!=NULL)
    {
        this->MapperTexture->Delete();
        this->MapperTexture=NULL;
    }
    
    if(this->MapperRaycast!=NULL)
    {
        this->MapperRaycast->Delete();
        this->MapperRaycast=NULL;
    }

    if(this->MapperGPURaycast!=NULL)
    {
        this->MapperGPURaycast->Delete();
        this->MapperGPURaycast=NULL;
    }
    
    this->DestroyTreshold();
    this->DestroyPerformance();
    this->DestroyCropping();

    if(this->NB_Details)
    {
        this->Script("pack forget %s",this->NB_Details->GetWidgetName());
        this->NB_Details->SetParent(NULL);
        this->NB_Details->Delete();
        this->NB_Details=NULL;
    }

    if(this->PB_PauseResume)
    {
        this->PB_PauseResume->SetParent(NULL);
        this->PB_PauseResume->Delete();
        this->PB_PauseResume=NULL;
    }
    if(this->VI_PauseResume)
    {
        this->VI_PauseResume->Delete();
        this->VI_PauseResume=NULL;
    }

}

void vtkSlicerVRGrayscaleHelper::Init(vtkVolumeRenderingGUI *gui)
{
    if(this->SVP_VolumeProperty!=NULL)
    {
        vtkErrorMacro("Init already called!");
        this->UpdateGUIElements();
        return;
    }
    
    //Start dialog right here
    Superclass::Init(gui);

    this->Gui->Script("bind all <Any-ButtonPress> {%s SetButtonDown 1}",this->GetTclName());
    this->Gui->Script("bind all <Any-ButtonRelease> {%s SetButtonDown 0}",this->GetTclName());
    
    //TODO: Move Pause Resume Button to another Place
    //Pause Resume Button

    if (this->Gui->GetDetailsFrame())
    {
        this->VI_PauseResume=vtkSlicerVisibilityIcons::New();
        this->PB_PauseResume=vtkKWPushButtonWithLabel::New();
        this->PB_PauseResume->SetParent(this->Gui->GetDetailsFrame()->GetFrame());
        this->PB_PauseResume->Create();
        this->PB_PauseResume->SetBalloonHelpString("Toggle the visibility of volume rendering.");
        this->PB_PauseResume->SetLabelText("Visiblity of Volume Rendering: ");
        this->PB_PauseResume->GetWidget()->SetImageToIcon(this->VI_PauseResume->GetVisibleIcon());
        this->Script("pack %s -side top -anchor n -padx 2 -pady 2", this->PB_PauseResume->GetWidgetName());
        this->PB_PauseResume->GetWidget()->SetCommand(this, "ProcessPauseResume");
    }

    //Create a notebook
    this->NB_Details=vtkKWNotebook::New();
    this->NB_Details->SetParent(this->Gui->GetDetailsFrame()->GetFrame());
    this->NB_Details->SetMinimumHeight(400);
    this->NB_Details->Create();
    this->NB_Details->AddPage("Performance","Influence the performance and quality of the rendering. Settings will still be available after starting Slicer3 again.");
    this->NB_Details->AddPage("Threshold","Edit volume rendering mapping options by using a threshold mechanism.");
    this->NB_Details->AddPage("Cropping","Crop the volume.Advantages: Volume rendering is much faster. You can blank out unnecessary parts of the volume.");
    this->NB_Details->AddPage("Advanced","Change mapping functions, shading, interpolation etc.");
    this->Script("pack %s -side top -anchor nw -fill both -expand y -padx 2 -pady 2", this->NB_Details->GetWidgetName());
    
    vtkImageData *imageData = NULL;
    vtkMRMLScalarVolumeNode *volume = NULL;
    
    if (this->Gui && this->Gui->GetNS_ImageData() && this->Gui->GetNS_ImageData()->GetSelected())
    {
        volume = vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected());
    }
      
    if (volume)
    {
        imageData = volume->GetImageData();
    }
      
    this->SVP_VolumeProperty=vtkSlicerVolumePropertyWidget::New();
    this->SVP_VolumeProperty->SetParent(this->NB_Details->GetFrame("Advanced"));
    this->SVP_VolumeProperty->Create();
    this->SVP_VolumeProperty->ScalarOpacityUnitDistanceVisibilityOff ();
    this->SVP_VolumeProperty->SetDataSet(imageData);
    
    this->Histograms=vtkKWHistogramSet::New();

    //Add Histogram for image data
    if (imageData && imageData->GetPointData())
    {
        this->Histograms->AddHistograms(imageData->GetPointData()->GetScalars());
    }
    
    //Build the gradient histogram
    vtkImageGradientMagnitude *grad=vtkImageGradientMagnitude::New();
    grad->SetDimensionality(3);
    grad->SetInput(imageData);
    grad->Update();
    vtkKWHistogram *gradHisto=vtkKWHistogram::New();
    gradHisto->BuildHistogram(grad->GetOutput()->GetPointData()->GetScalars(),0);
    this->Histograms->AddHistogram(gradHisto, "0gradient");

    //Delete      
    this->SVP_VolumeProperty->SetHistogramSet(this->Histograms);

    //AddEvent for Interactive apply 
    this->SVP_VolumeProperty->AddObserver(vtkKWEvent::VolumePropertyChangingEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
    
    grad->Delete();
    gradHisto->Delete(); 
    
    this->CreatePerformance();
    this->CreateCropping();
    this->CreateThreshold();
    this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2",this->SVP_VolumeProperty->GetWidgetName());
    
    this->WithdrawProgressDialog();
    
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::InitializePipelineNewCurrentNode()
{
    std::stringstream autoname;
    autoname<<"autoVisualization";
    autoname<<this->Gui->GetNS_ImageData()->GetSelected()->GetName();
    this->Gui->GetCurrentNode()->SetName(autoname.str().c_str());
    //this->Gui->GetLogic()->GetMRMLScene()->InvokeEvent(vtkMRMLScene::NodeAddedEvent);
    vtkKWHistogram *histogram=this->Histograms->GetHistogramWithName("0");
    if(histogram==NULL)
    {
        vtkErrorMacro("Problems with HistogramSet");
        return;
    }
    double totalOccurance=histogram->GetTotalOccurence();
    double thresholdLow=totalOccurance*0.2;
    double thresholdHigh=totalOccurance*0.8;
    double range[2];

    histogram->GetRange(range);
    double thresholdLowIndex=range[0];
    double sumLowIndex=0;
    double thresholdHighIndex=range[0];
    double sumHighIndex=0;
    //calculate distance
    double bin_width = (range[1] == range[0] ? 1 : (range[1] - range[0])/(double)histogram->GetNumberOfBins());
    while (sumLowIndex<thresholdLow)
    {
        sumLowIndex+=histogram->GetOccurenceAtValue(thresholdLowIndex);
        thresholdLowIndex+=bin_width;
    }
    while(sumHighIndex<thresholdHigh)
    {
        sumHighIndex+=histogram->GetOccurenceAtValue(thresholdHighIndex);
        thresholdHighIndex+=bin_width;

    }
    this->Gui->GetCurrentNode()->GetVolumeProperty()->SetInterpolationTypeToLinear();
    vtkPiecewiseFunction *opacity=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetScalarOpacity();
    opacity->RemoveAllPoints();
    opacity->AddPoint(range[0],0.);
    opacity->AddPoint(thresholdLowIndex,0.0);
    opacity->AddPoint(thresholdHighIndex,0.2);
    opacity->AddPoint(range[1],0.2);
    vtkColorTransferFunction *colorTransfer=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetRGBTransferFunction();
    colorTransfer->RemoveAllPoints();
    colorTransfer->AddRGBPoint(range[0],.3,.3,1.);
    colorTransfer->AddRGBPoint(thresholdLowIndex,.3,.3,1.);
    colorTransfer->AddRGBPoint(thresholdLowIndex+.5*(thresholdHighIndex-thresholdLowIndex),.3,1.,.3);
    colorTransfer->AddRGBPoint(thresholdHighIndex,1.,.3,.3);
    colorTransfer->AddRGBPoint(range[1],1,.3,.3);

    //Enable shading as default
    this->Gui->GetCurrentNode()->GetVolumeProperty()->ShadeOn();
    this->Gui->GetCurrentNode()->GetVolumeProperty()->SetAmbient(.30);
    this->Gui->GetCurrentNode()->GetVolumeProperty()->SetDiffuse(.60);
    this->Gui->GetCurrentNode()->GetVolumeProperty()->SetSpecular(.50);
    this->Gui->GetCurrentNode()->GetVolumeProperty()->SetSpecularPower(40);//this is really weird

    //Set cropping
    this->Gui->GetCurrentNode()->CroppingEnabledOff();

    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    //vtkMRMLScalarVolumeNode *volumeNode=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected());
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    double pointA[4];
    double pointB[4];
    for(int i=0;i<3;i++)
    {
        pointA[i]=iData->GetOrigin()[i];
        pointB[i]=iData->GetDimensions()[i];
    }
    pointA[3]=1;
    pointB[3]=1;
    this->CalculateMatrix(matrix);
    matrix->MultiplyPoint(pointA,pointA);
    matrix->MultiplyPoint(pointB,pointB);
    
    this->Gui->GetCurrentNode()->SetCroppingRegionPlanes(pointA[0],pointB[0], pointA[1],pointB[1], pointA[2],pointB[2]);

    //Disable Gradient Opacity

    this->UpdateGUIElements();
    
    matrix->Delete();
}

void vtkSlicerVRGrayscaleHelper::Rendering(void)
{
    if(this->Volume!=NULL)
    {
        vtkErrorMacro("Rendering already called, use update Rendering instead");
        return;
    }
    
    if(this->Gui==NULL)
    {
        vtkErrorMacro("Call init before calling rendering");
        return;
    }
    
    this->EstimateSampleDistances();
    
    this->Volume = vtkVolume::New();

    //init mappers
    {
        //Init the texture mapper
        this->MapperTexture = vtkSlicerVolumeTextureMapper3D::New();
        this->MapperTexture->SetSampleDistance(this->EstimatedSampleDistance);
        this->MapperTexture->SetInput(vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData());
 
        //create the raycast mapper
        this->MapperGPURaycast = vtkSlicerGPURayCastVolumeTextureMapper3D::New();
        this->MapperGPURaycast->SetFramerate(this->SC_ExpectedFPS->GetValue());
        this->MapperGPURaycast->SetInput(vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData());

        //Also take care about Ray Cast
        this->MapperRaycast=vtkSlicerFixedPointVolumeRayCastMapper::New();
        this->MapperRaycast->SetInput(vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData());
        this->MapperRaycast->SetSampleDistance(this->EstimatedSampleDistance);
        this->MapperRaycast->ManualInteractiveOff();
        this->MapperRaycast->SetImageSampleDistance(1.0f);
        this->MapperRaycast->SetMinimumImageSampleDistance(1.0f);
        this->MapperRaycast->SetMaximumImageSampleDistance(20.0f);
        
    }
    
    // create default(safe) GUI in case user messed up parameters
    // do not save/load registration table
    
    //check if mappers are supported
    {
        this->IsTextureMappingSupported = this->MapperTexture->IsRenderSupported(this->Gui->GetCurrentNode()->GetVolumeProperty());//opengl polygon blending
        this->IsGPURayCastingSupported = this->MapperGPURaycast->IsRenderSupported(this->Gui->GetCurrentNode()->GetVolumeProperty());//gpu ray cast (glsl)
        
        if (!IsGPURayCastingSupported)
        {
            vtkKWLabel *errorText=vtkKWLabel::New();
            errorText->SetParent(this->Gui->GetDetailsFrame()->GetFrame());
            errorText->Create();
            errorText->SetText("GPU RayCasting (GLSL) is not supported");
            this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2", errorText->GetWidgetName());

            this->CB_GPURayCastMIP->EnabledOff();
            this->CB_GPURayCastShading->EnabledOff();
            this->CB_GPURayCastForceHighQuality->EnabledOff();
            this->CB_GPURayCastLargeVolume->EnabledOff();
    
            errorText->Delete();
        }
    
        if(!IsTextureMappingSupported)
        {
            vtkKWLabel *errorText=vtkKWLabel::New();
            errorText->SetParent(this->Gui->GetDetailsFrame()->GetFrame());
            errorText->Create();
            errorText->SetText("OpenGL Texture Mapping is not supported");
            this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2", errorText->GetWidgetName());
            
            this->CB_TextureMapperForceHighQuality->EnabledOff();
            errorText->Delete();
        }

    }
    
    //setup observers for mappers
    {
        //polygon blending
        this->MapperTexture->AddObserver(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->MapperTexture->AddObserver(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->MapperTexture->AddObserver(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

        //cpu ray casting
        this->MapperRaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->MapperRaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->MapperRaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->MapperRaycast->AddObserver(vtkCommand::ProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

        //hook up the gpu mapper
        this->MapperGPURaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsStartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->MapperGPURaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsProgressEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->MapperGPURaycast->AddObserver(vtkCommand::VolumeMapperComputeGradientsEndEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);

        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->AddObserver(vtkCommand::AbortCheckEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->AddObserver(vtkCommand::EndEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
    }

    //choose default mapper, set software ray mapper as default
    {
        this->Volume->SetMapper(this->MapperRaycast);
        this->MB_Mapper->GetWidget()->SetValue("Software Ray Casting");
        this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->SetStatusText("Using CPU Raycasting: High Quality");
    }
    
    //TODO This is not the right place for this
    this->Volume->SetProperty(this->Gui->GetCurrentNode()->GetVolumeProperty());
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    this->CalculateMatrix(matrix);
    this->Volume->PokeMatrix(matrix);

    //For Performance
    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->AddViewProp(this->Volume);
    matrix->Delete();
    
    //Render
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::UpdateRendering()
{
    //first check if REndering was already called
    if(this->Volume == NULL)
    {
        this->Rendering();
        return;
    }
    
    //Update mapper
    vtkImageData *input= vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
        
    if (this->MapperGPURaycast->GetInput() != input)
        this->MapperGPURaycast->SetInput(input);
   
    if (this->MapperRaycast->GetInput() != input)
        this->MapperRaycast->SetInput(input);
    
    if (this->MapperTexture->GetInput() != input)
        this->MapperTexture->SetInput(input);
    
    //Update Property
    this->Volume->SetProperty(this->Gui->GetCurrentNode()->GetVolumeProperty());
    //Update matrix
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    this->CalculateMatrix(matrix);
    this->Volume->PokeMatrix(matrix);
    matrix->Delete();
    
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::ProcessVolumeRenderingEvents(vtkObject *caller,unsigned long eid,void *callData)
{
    //clipping box widget
    {
        vtkSlicerBoxWidget2 *callerBox=vtkSlicerBoxWidget2::SafeDownCast(caller);
        if(callerBox && caller==this->BW_Clipping_Widget && eid==vtkCommand::InteractionEvent)
        {
            vtkPlanes *planes=vtkPlanes::New();
            this->BW_Clipping_Representation->GetPlanes(planes);
            this->MapperTexture->SetClippingPlanes(planes);
            this->MapperRaycast->SetClippingPlanes(planes);

            this->MapperGPURaycast->SetClippingPlanes(planes);
            this->MapperGPURaycast->ClippingOn();
        
            planes->Delete();
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
        
        if(callerBox && caller==this->BW_Clipping_Widget && eid==vtkCommand::EndInteractionEvent)
        {
            vtkPlanes *planes=vtkPlanes::New();
            this->BW_Clipping_Representation->GetPlanes(planes);
            this->MapperTexture->SetClippingPlanes(planes);
            this->MapperRaycast->SetClippingPlanes(planes);
    
            this->MapperGPURaycast->SetClippingPlanes(planes);
            this->MapperGPURaycast->ClippingOn();
            
            //Decide if this event is triggered by the vtkBoxWidget or by the sliders
            //if sliders don't trigger setRange->this would lead to an endless loop
            if(!this->NoSetRangeNeeded)
            {
                vtkPolyData *vertices=vtkPolyData::New();

                this->BW_Clipping_Representation->GetPolyData(vertices);
                double pointA[3];
                double pointB[3];
                vertices->GetPoint(0,pointA);
                vertices->GetPoint(6,pointB);
                
                //Include a possible transform in this calculation
                this->InverseAdditionalClippingTransform->TransformPoint(pointA,pointA);
                this->InverseAdditionalClippingTransform->TransformPoint(pointB,pointB);
                
                //Convert this stuff into the box coordinate system
                this->ConvertWorldToBoxCoordinates(pointA);
                this->ConvertWorldToBoxCoordinates(pointB);

                double pointSmallestValue[3];
                double pointHighestValue[3];

                for(int i = 0; i < 3; i++)
                {
                    if(pointA[i] > pointB[i])
                    {
                        pointSmallestValue[i]=pointB[i];
                        pointHighestValue[i]=pointA[i];
                    }
                    else
                    {
                        pointSmallestValue[i]=pointA[i];
                        pointHighestValue[i]=pointB[i];
                    }
    
                    double valueLeft=this->VolumeBoundariesBoxCoordinates[0][i];
                    if(pointSmallestValue[i] < this->VolumeBoundariesBoxCoordinates[0][i])
                        valueLeft=pointSmallestValue[i];
    
                    double valueRight=this->VolumeBoundariesBoxCoordinates[1][i];
                    if(pointHighestValue[i] > this->VolumeBoundariesBoxCoordinates[1][i])
                    {
                        valueRight=pointHighestValue[i];
                    }
                    
                    this->RA_Cropping[i]->SetWholeRange(valueLeft,valueRight);          
                    this->RA_Cropping[i]->SetRange(pointA[i],pointB[i]);
                }

                vertices->Delete();
            }
            
            planes->Delete();
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
    }
    
    //Check the checkbuttons
    {
        vtkKWCheckButton *callerObjectCheckButton = vtkKWCheckButton::SafeDownCast(caller);
    
        if(callerObjectCheckButton == this->CB_CPURayCastMIP->GetWidget())
        {
            if (this->CB_CPURayCastMIP->GetWidget()->GetSelectedState())
                this->MapperRaycast->SetBlendModeToMaximumIntensity();
            else
                this->MapperRaycast->SetBlendModeToComposite();

            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
        
        if(callerObjectCheckButton == this->CB_GPURayCastMIP->GetWidget())
        {
            if (this->CB_GPURayCastMIP->GetWidget()->GetSelectedState())
                this->MapperGPURaycast->MIPRenderingOn();
            else
                this->MapperGPURaycast->MIPRenderingOff();

            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }

        if(callerObjectCheckButton == this->CB_GPURayCastShading->GetWidget())
        {
            if (this->CB_GPURayCastShading->GetWidget()->GetSelectedState())
                this->MapperGPURaycast->ShadingOn();
            else
                this->MapperGPURaycast->ShadingOff();

            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }

        if(callerObjectCheckButton == this->CB_GPURayCastForceHighQuality->GetWidget())
        {
            if (this->CB_GPURayCastForceHighQuality->GetWidget()->GetSelectedState())
                this->MapperGPURaycast->AdaptiveFPSOff();
            else
                this->MapperGPURaycast->AdaptiveFPSOn();
        
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();                
            return;
        }
    
        if(callerObjectCheckButton == this->CB_TextureMapperForceHighQuality->GetWidget())
        {
            if (this->CB_TextureMapperForceHighQuality->GetWidget()->GetSelectedState())
                this->MapperTexture->AdaptiveFPSOff();
            else
                this->MapperTexture->AdaptiveFPSOn();
        
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();                
            return;
        }
        
        if(callerObjectCheckButton == this->CB_GPURayCastLargeVolume->GetWidget())
        {
            if (this->CB_GPURayCastLargeVolume->GetWidget()->GetSelectedState())
                this->MapperGPURaycast->LargeVolumeSizeOn();
            else
                this->MapperGPURaycast->LargeVolumeSizeOff();
                
 //           this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->ResetCamera();
            
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
    
        if(callerObjectCheckButton==this->CB_CPURayCastForceHighQuality->GetWidget())
        {
            if(callerObjectCheckButton->GetSelectedState())
            {
                this->MapperRaycast->ManualInteractiveOff();
                this->MapperRaycast->SetInteractiveSampleDistance(this->EstimatedInteractiveSampleDistance);
                this->MapperRaycast->SetAutoAdjustSampleDistances(1);
                this->MapperRaycast->SetSampleDistance(this->EstimatedSampleDistance);
                this->MapperRaycast->SetImageSampleDistance(1.0f);
                this->MapperRaycast->SetMinimumImageSampleDistance(1.0f);
                this->MapperRaycast->SetMaximumImageSampleDistance(2.0f);
            }
            else
            {
                this->MapperRaycast->ManualInteractiveOn();
                float desiredTime = 1.0f/this->SC_ExpectedFPS->GetValue();//expected fps will not be 0 so safe to do division here
        
                this->MapperRaycast->SetManualInteractiveRate(desiredTime);
                this->MapperRaycast->SetImageSampleDistance(2.0f);
                this->MapperRaycast->SetMinimumImageSampleDistance(2.0f);
                this->MapperRaycast->SetMaximumImageSampleDistance(16.0f);
            }
            
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
    }
    
    //framerate
    {
        vtkKWScale *callerObjectSC=vtkKWScale::SafeDownCast(caller);
        if(callerObjectSC == this->SC_ExpectedFPS)
        {
            ProcessExpectedFPS();
            return;
        }
    }
    
    //SVP
    {
        vtkSlicerVolumePropertyWidget *callerObjectSVP=vtkSlicerVolumePropertyWidget::SafeDownCast(caller);
        if(callerObjectSVP == this->SVP_VolumeProperty && eid == vtkKWEvent::VolumePropertyChangingEvent)
        {
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            return;
        }
    }
    
    //check abort
    if(caller == this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow() && eid == vtkCommand::AbortCheckEvent)
    {
        this->CheckAbort();
        return;
    }
    
    {//clipping
        vtkSlicerNodeSelectorWidget *callerNS=vtkSlicerNodeSelectorWidget::SafeDownCast(caller);
        if (eid==vtkSlicerNodeSelectorWidget::NodeSelectedEvent&&callerNS==this->NS_TransformNode)
        {
            //Remove a potential observer from the old node
            if(this->CurrentTransformNodeCropping!=NULL)
                this->CurrentTransformNodeCropping->RemoveObservers(vtkMRMLTransformableNode::TransformModifiedEvent,this->VolumeRenderingCallbackCommand);
    
            //Add an observer to the new node
            this->CurrentTransformNodeCropping=vtkMRMLLinearTransformNode::SafeDownCast(this->NS_TransformNode->GetSelected());
            if(this->CurrentTransformNodeCropping!=NULL)
                this->CurrentTransformNodeCropping->AddObserver(vtkMRMLTransformableNode::TransformModifiedEvent,this->VolumeRenderingCallbackCommand);
    
            this->ProcessClippingModified();
            return;
        }
        if(eid==vtkMRMLTransformableNode::TransformModifiedEvent)
        {
            this->ProcessClippingModified();
            return;        
        }
    }
        
    vtkSlicerVRMenuButtonColorMode *callerVRMB=vtkSlicerVRMenuButtonColorMode::SafeDownCast(caller);
    if(callerVRMB==this->VRMB_ColorMode&&eid==vtkSlicerVRMenuButtonColorMode::ColorModeChangedEvent)
    {
        this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
    }

    vtkRenderWindow *renderWindow = vtkRenderWindow::SafeDownCast(caller);
    if (renderWindow && eid==vtkCommand::EndEvent)
      {
      this->Gui->GetApplicationGUI()->SetExternalProgress("Done.", 0.);
      return;
      }     
    
    //Check if caller equals mapper
    //All other event catchers before
    {
        vtkAbstractMapper *callerMapper=vtkAbstractMapper::SafeDownCast(caller);
        if((this->Volume != NULL) && (callerMapper != this->Volume->GetMapper()))
            return;
    
        if(eid==vtkCommand::VolumeMapperComputeGradientsStartEvent)
        {
            this->DisplayProgressDialog("Please standby: Gradients are being calculated");
            return;
        }
        else if(eid==vtkCommand::VolumeMapperComputeGradientsEndEvent)
        {
            this->WithdrawProgressDialog();
            return;
        }
        else if(eid==vtkCommand::VolumeMapperComputeGradientsProgressEvent)
        {
            float *progress = (float*)callData;
            if(this->GradientDialog != NULL)
                this->GradientDialog->UpdateProgress(*progress);
    
            return;
        }
        else if (eid==vtkCommand::ProgressEvent)
          {
          float progress=*((float*)callData);
          this->Gui->GetApplicationGUI()->SetExternalProgress("Rendering...", progress);
          return;
          }     
        
    }
    
    vtkDebugMacro("observed event but didn't process it");
}

void vtkSlicerVRGrayscaleHelper::UpdateSVP(void)
{
    //TODO really dirty here
    //First check if we have a SVP
    if(this->SVP_VolumeProperty==NULL)
    {
        vtkErrorMacro("SVP does not exist");
        return;
    }
    
    //First of all set New Property, Otherwise all Histograms will be overwritten
    //First check if we really need to update
    if(this->Gui->GetCurrentNode() && this->SVP_VolumeProperty->GetVolumeProperty()==this->Gui->GetCurrentNode()->GetVolumeProperty())
    {
        this->AdjustMapping();
        this->SVP_VolumeProperty->Update();
        //Set Treshold to none
        this->MB_ThresholdMode->GetWidget()->GetMenu()->SelectItem("None");
        this->ProcessThresholdModeEvents(0);
        //Reset cropping
        //Get Cropping from node
    }
    else
    {
    
        //for(int i=0;i<3;i++)
        //{
        //    this->RA_Cropping[i]->SetRange(this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[2*i],this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[2*i+1]);
        //}
        if (this->Gui->GetCurrentNode())
          this->UpdateingGUI = 1;
          {
          double *croppingPlanes = this->Gui->GetCurrentNode()->GetCroppingRegionPlanes();
          for(int i=0;i<3;i++)
            {
            if(croppingPlanes[2*i  ]< croppingPlanes[2*i+1])
              {
              this->RA_Cropping[i]->SetRange(croppingPlanes[2*i], croppingPlanes[2*i+1]);
              }
            else
              {
              this->RA_Cropping[i]->SetRange(croppingPlanes[2*i+1], croppingPlanes[2*i]);
              }
            }
          this->UpdateingGUI = 0;
          }

        this->CB_Cropping->GetWidget()->SetSelectedState(this->Gui->GetCurrentNode()->GetCroppingEnabled());
        this->ProcessEnableDisableCropping(this->Gui->GetCurrentNode()->GetCroppingEnabled());
    }
    
    this->SVP_VolumeProperty->SetVolumeProperty(this->Gui->GetCurrentNode()->GetVolumeProperty());
    this->SVP_VolumeProperty->SetHSVColorSelectorVisibility(1);
    this->SVP_VolumeProperty->Update();
}

void vtkSlicerVRGrayscaleHelper::UpdateGUIElements(void)
{
    this->UpdateingGUI = 1;
    Superclass::UpdateGUIElements();
    
    this->UpdateSVP();
    
    double *croppingPlanes = this->Gui->GetCurrentNode()->GetCroppingRegionPlanes();
    for(int i = 0; i < 3; i++)
    {
        if(croppingPlanes[ 2*i ]< croppingPlanes[ 2*i+1 ])
        {
            this->RA_Cropping[i]->SetRange(croppingPlanes[2*i], croppingPlanes[2*i+1]);
        }
        else
        {
            this->RA_Cropping[i]->SetRange(croppingPlanes[2*i+1], croppingPlanes[2*i]);
        }
    }

    this->CB_Cropping->GetWidget()->SetSelectedState(this->Gui->GetCurrentNode()->GetCroppingEnabled());
    this->VRMB_ColorMode->SetColorTransferFunction(this->Gui->GetCurrentNode()->GetVolumeProperty()->GetRGBTransferFunction());
    this->VRMB_ColorMode->SetRange(vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetPointData()->GetScalars()->GetRange());
    //this->ColorDisplay->SetMRMLScene(this->Gui->GetMRMLScene());

    this->UpdateingGUI = 0;
    this->ProcessCropping(0,0,0);
    this->ProcessEnableDisableCropping(this->Gui->GetCurrentNode()->GetCroppingEnabled());
}

void vtkSlicerVRGrayscaleHelper::AdjustMapping()
{
    //Update Color    
    vtkColorTransferFunction *functionColor=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetRGBTransferFunction();
    double rangeNew[2];
    vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetPointData()->GetScalars()->GetRange(rangeNew);
    functionColor->AdjustRange(rangeNew);

    //Update Opacity
    vtkPiecewiseFunction *function=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetScalarOpacity();
    function->AdjustRange(rangeNew);
    
    //Update
    rangeNew[1]=(rangeNew[1]-rangeNew[0])/4;
    rangeNew[0]=0;
    function=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetGradientOpacity();
    function->RemovePoint(255);//Remove the standard value
    //this->Histograms->GetHistogramWithName("0gradient")->GetRange(rangeNew);
    function->AdjustRange(rangeNew);
}

void vtkSlicerVRGrayscaleHelper::ProcessCropping(int index, double min,double max)
{
    if (this->UpdateingGUI)
        return;

    if(this->MapperTexture==NULL||this->MapperRaycast==NULL||this->MapperGPURaycast == NULL)
        return;

    double pointA[3];
    double pointB[3];
    double croppingPlanes[6];

    for(int i = 0; i < 3; i++)
    {
        pointA[i]=this->RA_Cropping[i]->GetRange()[0];
        pointB[i]=this->RA_Cropping[i]->GetRange()[1];
        croppingPlanes[2*i  ] = this->RA_Cropping[i]->GetRange()[0];
        croppingPlanes[2*i+1] = this->RA_Cropping[i]->GetRange()[1];
    }

    this->Gui->GetCurrentNode()->SetCroppingRegionPlanes(croppingPlanes);

    this->ConvertBoxCoordinatesToWorld(pointA);
    this->ConvertBoxCoordinatesToWorld(pointB);
    if (this->BW_Clipping_Widget)
    {
        double pointPlace[6];
        pointPlace[0] = pointA[0];
        pointPlace[1] = pointB[0];
        pointPlace[2] = pointA[1];
        pointPlace[3] = pointB[1];
        pointPlace[4] = pointA[2];
        pointPlace[5] = pointB[2];
        this->BW_Clipping_Representation->PlaceWidget(pointPlace); //pointA[0],pointB[0],pointA[1],pointB[1],pointA[2],pointB[2]);
        this->BW_Clipping_Representation->SetTransform(this->AdditionalClippingTransform);
    }
    
    this->NoSetRangeNeeded = 1;
    this->ProcessVolumeRenderingEvents(this->BW_Clipping_Widget,vtkCommand::InteractionEvent,0);
    this->ProcessVolumeRenderingEvents(this->BW_Clipping_Widget,vtkCommand::EndInteractionEvent,0);
    this->NoSetRangeNeeded = 0;
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
    this->CalculateBoxCoordinatesBoundaries();
}

void vtkSlicerVRGrayscaleHelper::CreateCropping()
{
    //Create our additional transforms
    this->AdditionalClippingTransform=vtkTransform::New();
    this->AdditionalClippingTransform->Identity();
    this->InverseAdditionalClippingTransform=vtkTransform::New();
    this->InverseAdditionalClippingTransform->Identity();

    vtkKWFrameWithLabel *croppingFrame=vtkKWFrameWithLabel::New();
    croppingFrame->SetParent(this->NB_Details->GetFrame("Cropping"));
    croppingFrame->Create();
    croppingFrame->AllowFrameToCollapseOff();
    croppingFrame->SetLabelText("Cropping (Coordinates are relative to image origin)");
    this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", croppingFrame->GetWidgetName() );

    int labelwidth=20;
    
    this->CB_Cropping=vtkKWCheckButtonWithLabel::New();
    this->CB_Cropping->SetParent(croppingFrame->GetFrame());
    this->CB_Cropping->Create();
    this->CB_Cropping->GetWidget()->SetSelectedState(0);
    this->CB_Cropping->SetBalloonHelpString("Enable/ Disable the configured clipping planes.");
    this->CB_Cropping->SetLabelText("Clipping in general");
    this->CB_Cropping->SetLabelWidth(labelwidth);
    this->CB_Cropping->GetWidget()->SetCommand(this, "ProcessEnableDisableCropping");
    this->Script("pack %s -side top -anchor nw -fill x -padx 10 -pady 10", this->CB_Cropping->GetWidgetName());

    this->CB_Clipping=vtkKWCheckButtonWithLabel::New();
    this->CB_Clipping->SetParent(croppingFrame->GetFrame());
    this->CB_Clipping->Create();
    this->CB_Clipping->SetBalloonHelpString("Display or suppress the clipping box. The configured clipping planes will still be enabled");
    this->CB_Clipping->GetWidget()->SetSelectedState(0);
    this->CB_Clipping->SetLabelText("Display Clipping Box");
    this->CB_Clipping->SetLabelWidth(labelwidth);
    this->CB_Clipping->GetWidget()->SetCommand(this, "ProcessDisplayClippingBox");
    this->Script("pack %s -side top -anchor nw -fill x -padx 10 -pady 10", this->CB_Clipping->GetWidgetName());

    for(int i = 0; i < 3; i++)
    {
        this->RA_Cropping[i]=vtkKWRange::New();
        this->RA_Cropping[i]->SetParent(croppingFrame->GetFrame());
        this->RA_Cropping[i]->Create();
        this->RA_Cropping[i]->SetEnabled(0);
        this->RA_Cropping[i]->SetBalloonHelpString("Configure the clipping planes relative to the center of the volume. You can also use the clipping box to do this.");
        this->RA_Cropping[i]->SymmetricalInteractionOff();
        std::stringstream str;
        str<<"ProcessCropping "<<i;
        this->RA_Cropping[i]->SetCommand(this,str.str().c_str());
        this->Script("pack %s -side top -anchor nw -fill x -padx 10 -pady 10",this->RA_Cropping[i]->GetWidgetName());
    }

    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    this->RA_Cropping[0]->SetLabelText("I");
    this->RA_Cropping[0]->SetWholeRange(-500,500);
    this->RA_Cropping[0]->SetSlider1Color(this->ColorsClippingHandles[0]);
    this->RA_Cropping[0]->SetSlider2Color(this->ColorsClippingHandles[1]);
    this->RA_Cropping[0]->SetRange(iData->GetOrigin()[0],iData->GetDimensions()[0]);
    this->RA_Cropping[1]->SetLabelText("J");
    this->RA_Cropping[1]->SetWholeRange(-500,500);
    this->RA_Cropping[1]->SetSlider1Color(this->ColorsClippingHandles[2]);
    this->RA_Cropping[1]->SetSlider2Color(this->ColorsClippingHandles[3]);
    this->RA_Cropping[1]->SetRange(iData->GetOrigin()[1],iData->GetDimensions()[1]);
    this->RA_Cropping[2]->SetLabelText("K");
    this->RA_Cropping[2]->SetWholeRange(-500,500);
    this->RA_Cropping[2]->SetSlider1Color(this->ColorsClippingHandles[4]);
    this->RA_Cropping[2]->SetSlider2Color(this->ColorsClippingHandles[5]);
    this->RA_Cropping[2]->SetRange(iData->GetOrigin()[2],iData->GetDimensions()[2]);

    //Now we have the cropping ranges
    //Build GUI
    this->NS_TransformNode=vtkSlicerNodeSelectorWidget::New();
    this->NS_TransformNode->SetParent(croppingFrame->GetFrame());
    this->NS_TransformNode->Create();
    this->NS_TransformNode->SetLabelText("Transform Node for Clipping");
    std::stringstream ss;
    ss<<"Use a transform in addition to the clipping planes configured with the clipping box or the sliders above. ";
    ss<<"Changes made to the sliders or to the clipping box will not change the transform node.";
    this->NS_TransformNode->SetBalloonHelpString(ss.str().c_str());
    this->NS_TransformNode->SetNodeClass("vtkMRMLTransformNode",NULL,NULL,NULL);
    this->NS_TransformNode->SetMRMLScene(this->Gui->GetLogic()->GetMRMLScene());
    this->NS_TransformNode->NoneEnabledOn();
    this->NS_TransformNode->SetSelected(NULL);
    this->NS_TransformNode->AddObserver(vtkSlicerNodeSelectorWidget::NodeSelectedEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
    this->Script("pack %s -side top -anchor nw -fill x -padx 10 -pady 10",this->NS_TransformNode->GetWidgetName());
    this->ProcessEnableDisableCropping(0);
    croppingFrame->Delete();

    //TODO this should be fixed after inclusion into KWWidgets
    this->ProcessConfigureCallback();
    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->SetBinding("<Configure>", this, "ProcessConfigureCallback");
}

void vtkSlicerVRGrayscaleHelper::CreateThreshold()
{
    vtkKWFrameWithLabel *thresholdFrame=vtkKWFrameWithLabel::New();
    thresholdFrame->SetParent(this->NB_Details->GetFrame("Threshold"));
    thresholdFrame->Create();
    thresholdFrame->SetLabelText("Threshold");
    this->Script("pack %s -side top -anchor nw -fill both -expand yes -padx 0 -pady 2", thresholdFrame->GetWidgetName());

    this->MB_ThresholdMode=vtkKWMenuButtonWithLabel::New();
    this->MB_ThresholdMode->SetParent(thresholdFrame->GetFrame());
    this->MB_ThresholdMode->Create();
    std::stringstream ss;
    ss<<"Select which kind of thresholding to use for transfer functions. ";
    ss<<"\"Rectangle\" will result in sharp surface, while \"ramp\" creates a smoother result.";
    this->MB_ThresholdMode->SetBalloonHelpString(ss.str().c_str());
    this->MB_ThresholdMode->SetLabelText("Threshold:");
    this->MB_ThresholdMode->SetLabelWidth(10);
    this->MB_ThresholdMode->GetWidget()->GetMenu()->AddRadioButton("None");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->SetItemCommand(0, this,"ProcessThresholdModeEvents 0");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->AddRadioButton("Ramp");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->SetItemCommand(1, this,"ProcessThresholdModeEvents 1");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->AddRadioButton("Rectangle");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->SetItemCommand(2, this,"ProcessThresholdModeEvents 2");
    this->MB_ThresholdMode->GetWidget()->GetMenu()->SelectItem("None");
    this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->MB_ThresholdMode->GetWidgetName());

    this->VRMB_ColorMode=vtkSlicerVRMenuButtonColorMode::New();
    this->VRMB_ColorMode->SetParent(thresholdFrame->GetFrame());
    this->VRMB_ColorMode->Create();
    ss.str("");
    ss<<"Which color should the volume have, ";
    ss<<"all \"static\" colors result in a single color for every gray value while \"dynamic\" produces a color gradient.";
    this->VRMB_ColorMode->SetBalloonHelpString(ss.str().c_str());
    this->VRMB_ColorMode->SetLabelText("Color Mode:"); 
    this->VRMB_ColorMode->SetLabelWidth(10);
    this->VRMB_ColorMode->EnabledOff();
    this->VRMB_ColorMode->AddObserver(vtkSlicerVRMenuButtonColorMode::ColorModeChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
    this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->VRMB_ColorMode->GetWidgetName());

    this->RA_RampRectangleOpacity=vtkKWRange::New();
    this->RA_RampRectangleOpacity->SetParent(thresholdFrame->GetFrame());
    this->RA_RampRectangleOpacity->Create();
    ss.str("");
    ss<<"Set the lower and upper opacity levels for the ramp and the rectangle. ";
    ss<<"Lower values make the volume more translucent.";
    this->RA_RampRectangleOpacity->SetBalloonHelpString(ss.str().c_str());
    this->RA_RampRectangleOpacity->SetLabelText("Opacity");
    this->RA_RampRectangleOpacity->SetWholeRange(0,1);
    this->RA_RampRectangleOpacity->SetRange(0,1);
    this->RA_RampRectangleOpacity->EnabledOff();
    this->RA_RampRectangleOpacity->SetCommand(this, "ProcessThresholdRange");
    this->Script("pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->RA_RampRectangleOpacity->GetWidgetName());
    
    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    this->RA_RampRectangleScalar=vtkKWRange::New();
    this->RA_RampRectangleScalar->SetParent(thresholdFrame->GetFrame());
    this->RA_RampRectangleScalar->Create();
    this->RA_RampRectangleScalar->SetBalloonHelpString("Apply thresholds to the gray values of volume.");
    this->RA_RampRectangleScalar->SetLabelText("Threshold");
    this->RA_RampRectangleScalar->SetWholeRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
    this->RA_RampRectangleScalar->SetRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
    this->RA_RampRectangleScalar->SetCommand(this, "ProcessThresholdRange");
    this->RA_RampRectangleScalar->EnabledOff();
    this->Script("pack %s -side left -anchor nw -expand n -fill x -padx 2 -pady 2", this->RA_RampRectangleScalar->GetWidgetName());

    this->PB_ThresholdZoomIn=vtkKWPushButton::New();
    this->PB_ThresholdZoomIn->SetParent(thresholdFrame->GetFrame());
    this->PB_ThresholdZoomIn->Create();
    ss.str("");
    ss<<"Zoom into the threshold sliders. ";
    ss<<"Use this if you need a higher resolution for adjusting the sliders. ";
    ss<<"Use \"Reset\" to zoom out completely."; 
    this->PB_ThresholdZoomIn->SetBalloonHelpString(ss.str().c_str());
    this->PB_ThresholdZoomIn->SetText("Zoom In");
    this->PB_ThresholdZoomIn->EnabledOff();
    this->PB_ThresholdZoomIn->SetCommand(this,"ProcessThresholdZoomIn");
    this->Script("pack %s -side top -anchor nw -expand n -fill x -padx 2 -pady 2", this->PB_ThresholdZoomIn->GetWidgetName());

    this->PB_Reset=vtkKWPushButton::New();
    this->PB_Reset->SetParent(thresholdFrame->GetFrame());
    this->PB_Reset->Create();
    this->PB_Reset->SetBalloonHelpString("Cancel \"Zoom In\".");
    this->PB_Reset->SetText("Reset");
    this->PB_Reset->EnabledOff();
    this->PB_Reset->SetCommand(this,"ProcessThresholdReset");
    this->Script("pack %s -side top -anchor nw -expand n -fill x -padx 2 -pady 2", this->PB_Reset->GetWidgetName());

    thresholdFrame->Delete();
}

void vtkSlicerVRGrayscaleHelper::ProcessRenderingMethodEvents(int id)
{
    this->RenderingMethod = id;
  
    this->FrameGPURayCasting->CollapseFrame();
    this->FramePolygonBlending->CollapseFrame();
    this->FrameCPURayCasting->CollapseFrame();
    
    switch(id)
    {
    case 1://gpu ray casting
        this->FrameGPURayCasting->ExpandFrame();
        if (this->Volume && this->IsGPURayCastingSupported)
            this->Volume->SetMapper(this->MapperGPURaycast);
        else
            vtkErrorMacro("GPU ray casting is not supported by your computer.");
        break;
    case 2://old school opengl 2D polygon blending
        this->FramePolygonBlending->ExpandFrame();
        if (this->Volume && this->IsTextureMappingSupported)
            this->Volume->SetMapper(this->MapperTexture);
        else
            vtkErrorMacro("OpenGL polygon blending is not supported by your computer.");//seldom should we see this error message unless really low end graphics card...
        break;
    case 0://softwrae ray casting
        this->FrameCPURayCasting->ExpandFrame();
        if (this->Volume)
            this->Volume->SetMapper(this->MapperRaycast);
        break;
    }
    
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();//double rendering request to force mapper to adjust rendering quality for expected fps
}

void vtkSlicerVRGrayscaleHelper::ProcessThresholdModeEvents(int id)
{
    this->ThresholdMode = id;
    
    //Disable Everything and go back to standard
    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    if(id == 0)
    {
        this->VRMB_ColorMode->EnabledOff();

        this->RA_RampRectangleScalar->SetRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
        this->RA_RampRectangleScalar->EnabledOff();
        this->RA_RampRectangleOpacity->SetRange(0,1);
        this->RA_RampRectangleOpacity->EnabledOff();
        this->PB_Reset->EnabledOff();
        this->PB_ThresholdZoomIn->EnabledOff();
        return;
    }
    
    //Before we continue enabled everything
    this->VRMB_ColorMode->EnabledOn();
    this->RA_RampRectangleScalar->EnabledOn();
    this->RA_RampRectangleOpacity->EnabledOn();
    this->PB_Reset->EnabledOn();
    this->PB_ThresholdZoomIn->EnabledOn();
    this->ProcessThresholdRange(.0,.0);
}

void vtkSlicerVRGrayscaleHelper::ProcessThresholdRange(double notUsed,double notUsedA)
{
    if(this->ThresholdMode == 0)
    {
        return;
    }
    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    //Delete all old Mapping Points
    vtkPiecewiseFunction *opacity=this->Gui->GetCurrentNode()->GetVolumeProperty()->GetScalarOpacity();
    opacity->RemoveAllPoints();
    //opacity->AdjustRange(iData->GetScalarRange());

    opacity->AddPoint(iData->GetScalarRange()[0],this->RA_RampRectangleOpacity->GetRange()[0]);
    opacity->AddPoint(iData->GetScalarRange()[1],this->RA_RampRectangleOpacity->GetRange()[0]);
    if(this->ThresholdMode==1)
    {
        opacity->AddPoint(iData->GetScalarRange()[0],this->RA_RampRectangleOpacity->GetRange()[0]);
        opacity->AddPoint(iData->GetScalarRange()[1],this->RA_RampRectangleOpacity->GetRange()[1]);
        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[0],this->RA_RampRectangleOpacity->GetRange()[0]);
        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[1],this->RA_RampRectangleOpacity->GetRange()[1]);

    }
    else if(this->ThresholdMode==2)
    {

        opacity->AddPoint(iData->GetScalarRange()[0],this->RA_RampRectangleOpacity->GetRange()[0]);
        opacity->AddPoint(iData->GetScalarRange()[1],this->RA_RampRectangleOpacity->GetRange()[0]);

        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[0],this->RA_RampRectangleOpacity->GetRange()[0]);
        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[0]+0.1,this->RA_RampRectangleOpacity->GetRange()[1]);
        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[1]-0.1,this->RA_RampRectangleOpacity->GetRange()[1]);
        opacity->AddPoint(this->RA_RampRectangleScalar->GetRange()[1],this->RA_RampRectangleOpacity->GetRange()[0]);

    }
    this->SVP_VolumeProperty->Update();
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::ProcessThresholdZoomIn(void)
{
    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    double leftBorder=this->RA_RampRectangleScalar->GetRange()[0];
    double rightBorder=this->RA_RampRectangleScalar->GetRange()[1];
    double expansion=.1*(rightBorder-leftBorder);
    double leftBorderWholeRange=leftBorder-expansion;
    double rightBorderWholeRange=rightBorder+expansion;

    if(leftBorderWholeRange<iData->GetScalarRange()[0])
    {
        leftBorderWholeRange=iData->GetScalarRange()[0];
    }
    if(rightBorderWholeRange>iData->GetScalarRange()[1])
    {
        rightBorderWholeRange=iData->GetScalarRange()[1];
    }
    this->RA_RampRectangleScalar->SetWholeRange(leftBorderWholeRange,rightBorderWholeRange);
    this->SVP_VolumeProperty->GetScalarColorFunctionEditor()->SetVisibleParameterRange(leftBorderWholeRange,rightBorderWholeRange);
    this->SVP_VolumeProperty->GetScalarOpacityFunctionEditor()->SetVisibleParameterRange(leftBorderWholeRange,rightBorderWholeRange);
}

void vtkSlicerVRGrayscaleHelper::ProcessThresholdReset(void)
{
    vtkImageData *iData=vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();

    this->RA_RampRectangleScalar->SetWholeRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
    this->SVP_VolumeProperty->GetScalarColorFunctionEditor()->SetVisibleParameterRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
    this->SVP_VolumeProperty->GetScalarOpacityFunctionEditor()->SetVisibleParameterRange(iData->GetScalarRange()[0],iData->GetScalarRange()[1]);
}

void vtkSlicerVRGrayscaleHelper::ProcessEnableDisableCropping(int cbSelectedState)
{
    if(this->MapperTexture==NULL||this->MapperRaycast==NULL||this->MapperGPURaycast == NULL)
        return;
    
    for(int i = 0; i < 3; i++)
    {
        this->RA_Cropping[i]->SetEnabled(cbSelectedState);
    }
    
    this->NS_TransformNode->SetEnabled(cbSelectedState);
    //There is not automatical enabling when
    //this->ProcessDisplayClippingBox(cbSelectedState);
    this->CB_Clipping->SetEnabled(cbSelectedState);
    if(this->Gui->GetCurrentNode()!=NULL)
    {
        this->Gui->GetCurrentNode()->SetCroppingEnabled(cbSelectedState);
    }
    
    if(cbSelectedState)
    {
        //If we enable clipping we choose the current state of CB_Clipping
        this->ProcessDisplayClippingBox(this->CB_Clipping->GetWidget()->GetSelectedState());
        this->ProcessCropping(0,0,0);
        //PlaceWidget
    }
    else
    {
        this->ProcessDisplayClippingBox(0);
        this->MapperTexture->RemoveAllClippingPlanes();
        this->MapperRaycast->RemoveAllClippingPlanes();
        this->MapperGPURaycast->RemoveAllClippingPlanes();
        this->MapperGPURaycast->ClippingOff();
    }

    //Trigger a Render
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::ProcessDisplayClippingBox(int clippingEnabled)
{
    if(this->BW_Clipping_Widget == NULL)
    {
        this->Gui->GetApplicationGUI()->GetViewerWidget()->SetBoxWidgetInteractor();
        this->BW_Clipping_Widget = this->Gui->GetApplicationGUI()->GetViewerWidget()->GetBoxWidget();
        this->BW_Clipping_Representation = this->Gui->GetApplicationGUI()->GetViewerWidget()->GetBoxWidgetRepresentation();
        this->BW_Clipping_Representation->SetPlaceFactor(1);
      
        // this->BW_Clipping_Widget->SetProp3D(this->Volume);
        // get the bounding box of the volume
        double *bounds = this->Volume->GetBounds();
        if (bounds != NULL)
        {
            this->BW_Clipping_Representation->PlaceWidget(bounds);
        }
        //data is saved in IJK->Convert to ras
      
        double pointA[3];
        pointA[0]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[0];
        pointA[1]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[2];
        pointA[2]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[4];
      
        double pointB[3];
        pointB[0]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[1];
        pointB[1]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[3];
        pointB[2]=this->Gui->GetCurrentNode()->GetCroppingRegionPlanes()[5];
        this->NoSetRangeNeeded=1;
        
        for(int i = 0; i < 3; i++)
        {
            if(pointA[i] < pointB[i])
                this->RA_Cropping[i]->SetRange(pointA[i],pointB[i]);
            else
                this->RA_Cropping[i]->SetRange(pointB[i],pointA[i]);
        }

        double pointPlace[6];
        pointPlace[0] = pointA[0];
        pointPlace[1] = pointB[0];
        pointPlace[2] = pointA[0]; // is this correct?
        pointPlace[3] = pointB[1];
        pointPlace[4] = pointA[2];
        pointPlace[5] = pointB[2];
        
        this->BW_Clipping_Representation->PlaceWidget(pointPlace); //pointA[0],pointB[0],pointA[0],pointB[1],pointA[2],pointB[2]);
        this->BW_Clipping_Representation->InsideOutOn();
        this->BW_Clipping_Widget->RotationEnabledOff();
        this->BW_Clipping_Widget->TranslationEnabledOn();
        this->BW_Clipping_Representation->GetSelectedHandleProperty()->SetColor(0.2,0.6,0.15);
        this->NoSetRangeNeeded=0;

        this->BW_Clipping_Widget->AddObserver(vtkCommand::InteractionEvent,(vtkCommand*) this->VolumeRenderingCallbackCommand);
        this->BW_Clipping_Widget->AddObserver(vtkCommand::EndInteractionEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->GetInteractor()->ReInitialize();
    }
    
    if(clippingEnabled)
        this->BW_Clipping_Widget->On();
    else
        this->BW_Clipping_Widget->Off();
    
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::ProcessPauseResume(void)
{
    //Resume Rendering
    if(this->RenderingPaused)
    {
        this->RenderingPaused=0;
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->AddObserver(vtkCommand::StartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->AddObserver(vtkCommand::EndEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->Volume->VisibilityOn();
        this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
        this->PB_PauseResume->GetWidget()->SetImageToIcon(this->VI_PauseResume->GetVisibleIcon());;
    }
    //Pause Rendering
    else if (!this->RenderingPaused)
    {
        this->RenderingPaused=1;
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->RemoveObservers(vtkCommand::StartEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->RemoveObservers(vtkCommand::EndEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        //Clear ProgressGauge
 //       this->ResetRenderingAlgorithm();

        this->Volume->VisibilityOff();
        this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
        this->PB_PauseResume->GetWidget()->SetImageToIcon(this->VI_PauseResume->GetInvisibleIcon());
    }
    else
    {
        vtkErrorMacro("RenderingPaused is not a valid number");
    }
    
    this->Script("put \"ProcessPauseResume\"");
}

void vtkSlicerVRGrayscaleHelper::DestroyCropping(void)
{
    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->RemoveBinding("<Configure>", this, "ProcessConfigureCallback");
    
    if(this->BW_Clipping_Widget)
    {
        this->BW_Clipping_Widget->RemoveObservers(vtkCommand::InteractionEvent,(vtkCommand*) this->VolumeRenderingCallbackCommand);
        this->BW_Clipping_Widget->RemoveObservers(vtkCommand::EndInteractionEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->BW_Clipping_Widget->Off();
        this->BW_Clipping_Widget=NULL;
    }
    if (this->BW_Clipping_Representation)
      {
        this->BW_Clipping_Representation =  NULL;
      }
    if(this->CB_Clipping)
    {
        this->CB_Clipping->SetParent(NULL);
        this->CB_Clipping->Delete();
        this->CB_Clipping=NULL;
    }

    if(this->CB_Cropping)
    {
        this->CB_Cropping->SetParent(NULL);
        this->CB_Cropping->Delete();
        this->CB_Cropping=NULL;
    }

    for(int i=0;i<3;i++)
    {
        if(this->RA_Cropping[i])
        {
            this->RA_Cropping[i]->SetParent(NULL);
            this->RA_Cropping[i]->Delete();
            this->RA_Cropping[i]=NULL;
        }
    }
    if(this->NS_TransformNode!=NULL)
    {
        this->NS_TransformNode->RemoveObservers(vtkSlicerNodeSelectorWidget::NodeSelectedEvent,(vtkCommand *)this->VolumeRenderingCallbackCommand);
        this->NS_TransformNode->SetParent(NULL);
        this->NS_TransformNode->Delete();
        this->NS_TransformNode=NULL;
    }
    if(this->AdditionalClippingTransform!=NULL)
    {
        this->AdditionalClippingTransform->Delete();
        this->AdditionalClippingTransform=NULL;
    }
    if(this->InverseAdditionalClippingTransform!=NULL)
    {
        this->InverseAdditionalClippingTransform->Delete();
        this->InverseAdditionalClippingTransform=NULL;
    }
}
void vtkSlicerVRGrayscaleHelper::DestroyTreshold(void)
{
    //ThresholdGUI
    if(this->MB_ThresholdMode)
    {
        this->MB_ThresholdMode->SetParent(NULL);
        this->MB_ThresholdMode->Delete();
        this->MB_ThresholdMode=NULL;

    }
    if(this->VRMB_ColorMode)
    {
        this->VRMB_ColorMode->RemoveObservers(vtkSlicerVRMenuButtonColorMode::ColorModeChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->VRMB_ColorMode->SetParent(NULL);
        this->VRMB_ColorMode->Delete();
        this->VRMB_ColorMode=NULL;
    }
    if(this->RA_RampRectangleScalar)
    {
        this->RA_RampRectangleScalar->SetParent(NULL);
        this->RA_RampRectangleScalar->Delete();
        this->RA_RampRectangleScalar=NULL;
    }
    if(this->RA_RampRectangleOpacity)
    {
        this->RA_RampRectangleOpacity->SetParent(NULL);
        this->RA_RampRectangleOpacity->Delete();
        this->RA_RampRectangleOpacity=NULL;
    }
    if(this->PB_Reset)
    {
        this->PB_Reset->SetParent(NULL);
        this->PB_Reset->Delete();
        this->PB_Reset=NULL;
    }
    if(this->PB_ThresholdZoomIn)
    {
        this->PB_ThresholdZoomIn->SetParent(NULL);
        this->PB_ThresholdZoomIn->Delete();
        this->PB_ThresholdZoomIn=NULL;
    }
}

void vtkSlicerVRGrayscaleHelper::ProcessExpectedFPS(void)
{
    this->MapperTexture->SetFramerate(this->SC_ExpectedFPS->GetValue());
    this->MapperGPURaycast->SetFramerate(this->SC_ExpectedFPS->GetValue());
    
    //software raycasting
    {
        float desiredTime = 1.0f/this->SC_ExpectedFPS->GetValue();//expected fps will not be 0 so safe to do division here
        
        this->MapperRaycast->SetManualInteractiveRate(desiredTime);
        this->MapperRaycast->SetImageSampleDistance(2.0f);
        this->MapperRaycast->SetMinimumImageSampleDistance(2.0f);
        this->MapperRaycast->SetMaximumImageSampleDistance(16.0f);
    }
    
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
}

void vtkSlicerVRGrayscaleHelper::CreatePerformance(void)
{
    this->FramePerformance = vtkKWFrameWithLabel::New();
    this->FramePerformance->SetParent(this->NB_Details->GetFrame("Performance"));
    this->FramePerformance->Create();
    this->FramePerformance->AllowFrameToCollapseOff();
    this->FramePerformance->SetLabelText("Performance/Quality");
    this->Script( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->FramePerformance->GetWidgetName() );
    
    //mapper selection combobox
    {
        this->MB_Mapper = vtkKWMenuButtonWithLabel::New();
        this->MB_Mapper->SetParent(this->FramePerformance->GetFrame());
        this->MB_Mapper->SetLabelText("Rendering Method");
        this->MB_Mapper->Create();
        this->MB_Mapper->SetBalloonHelpString("Please select one rendering method");
        this->MB_Mapper->GetWidget()->GetMenu()->AddRadioButton("Software Ray Casting");
        this->MB_Mapper->GetWidget()->GetMenu()->SetItemCommand(0, this,"ProcessRenderingMethodEvents 0");
        this->MB_Mapper->GetWidget()->GetMenu()->AddRadioButton("GPU Ray Casting (GLSL)");
        this->MB_Mapper->GetWidget()->GetMenu()->SetItemCommand(1, this,"ProcessRenderingMethodEvents 1");
        this->MB_Mapper->GetWidget()->GetMenu()->AddRadioButton("OpenGL Polygon Blending");
        this->MB_Mapper->GetWidget()->GetMenu()->SetItemCommand(2, this,"ProcessRenderingMethodEvents 2");
        
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 8 -pady 8", this->MB_Mapper->GetWidgetName() );

    }
    
    //Framerate
    {
        this->FrameFPS = vtkKWFrameWithLabel::New();
        this->FrameFPS->SetParent(this->FramePerformance->GetFrame());
        this->FrameFPS->Create();
        this->FrameFPS->AllowFrameToCollapseOff();
        this->FrameFPS->SetLabelText("Exptected Interactive Framerate (FPS)");
        this->Script( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->FrameFPS->GetWidgetName() );
    
        this->SC_ExpectedFPS=vtkKWScale::New();
        this->SC_ExpectedFPS->SetParent(this->FrameFPS->GetFrame());
        this->SC_ExpectedFPS->Create();
        this->SC_ExpectedFPS->SetBalloonHelpString("Influence performance and quality of volume rendering. 20 very fast, 1 slow but higher quality.");
        this->SC_ExpectedFPS->SetRange(1,20); 
        this->SC_ExpectedFPS->SetResolution(1);
        this->SC_ExpectedFPS->SetValue(5.0);
        this->SC_ExpectedFPS->AddObserver(vtkKWScale::ScaleValueChangedEvent, (vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->SC_ExpectedFPS->GetWidgetName() );

    }
    
    int labelWidth = 26;
    
    //software ray casting
    {
        this->FrameCPURayCasting = vtkKWFrameWithLabel::New();
        this->FrameCPURayCasting->SetParent(this->FramePerformance->GetFrame());
        this->FrameCPURayCasting->Create();
        this->FrameCPURayCasting->AllowFrameToCollapseOff();
        this->FrameCPURayCasting->SetLabelText("Software Ray Casting");
        this->Script( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->FrameCPURayCasting->GetWidgetName() );

        //enable/disable cpu ray casting MIP rendering
        this->CB_CPURayCastMIP=vtkKWCheckButtonWithLabel::New();
        this->CB_CPURayCastMIP->SetParent(this->FrameCPURayCasting->GetFrame());
        this->CB_CPURayCastMIP->Create();
        this->CB_CPURayCastMIP->SetBalloonHelpString("Enable MIP rendering in CPU ray cast.");
        this->CB_CPURayCastMIP->SetLabelText("Maximum Intensity projection");
        this->CB_CPURayCastMIP->SetLabelWidth(labelWidth);
        this->CB_CPURayCastMIP->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_CPURayCastMIP->GetWidgetName() );
        this->CB_CPURayCastMIP->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);
        
        this->CB_CPURayCastForceHighQuality=vtkKWCheckButtonWithLabel::New();
        this->CB_CPURayCastForceHighQuality->SetParent(this->FrameCPURayCasting->GetFrame());
        this->CB_CPURayCastForceHighQuality->Create();
        this->CB_CPURayCastForceHighQuality->SetBalloonHelpString("Force CPU ray cast mapper to use high quality (high sampling rate). Could be show.");
        this->CB_CPURayCastForceHighQuality->SetLabelText("Force High Quality");
        this->CB_CPURayCastForceHighQuality->SetLabelWidth(labelWidth);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_CPURayCastForceHighQuality->GetWidgetName() );
        this->CB_CPURayCastForceHighQuality->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);

    }
    
    //GPU ray casting
    {
        this->FrameGPURayCasting = vtkKWFrameWithLabel::New();
        this->FrameGPURayCasting->SetParent(this->FramePerformance->GetFrame());
        this->FrameGPURayCasting->Create();
        this->FrameGPURayCasting->AllowFrameToCollapseOff();
        this->FrameGPURayCasting->SetLabelText("GPU Ray Casting");
        this->Script( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->FrameGPURayCasting->GetWidgetName() );

        //enable/disable gpu ray casting shading
        this->CB_GPURayCastShading=vtkKWCheckButtonWithLabel::New();
        this->CB_GPURayCastShading->SetParent(this->FrameGPURayCasting->GetFrame());
        this->CB_GPURayCastShading->Create();
        this->CB_GPURayCastShading->SetBalloonHelpString("Enable lighting/shading in GPU ray cast. May not supported by some video cards.");
        this->CB_GPURayCastShading->SetLabelText("Enable Lighting");
        this->CB_GPURayCastShading->SetLabelWidth(labelWidth);
        this->CB_GPURayCastShading->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_GPURayCastShading->GetWidgetName() );
        this->CB_GPURayCastShading->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);
        
        //enable/disable gpu ray casting MIP rendering
        this->CB_GPURayCastMIP=vtkKWCheckButtonWithLabel::New();
        this->CB_GPURayCastMIP->SetParent(this->FrameGPURayCasting->GetFrame());
        this->CB_GPURayCastMIP->Create();
        this->CB_GPURayCastMIP->SetBalloonHelpString("Enable MIP rendering in GPU ray cast.");
        this->CB_GPURayCastMIP->SetLabelText("Maximum Intensity projection");
        this->CB_GPURayCastMIP->SetLabelWidth(labelWidth);
        this->CB_GPURayCastMIP->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_GPURayCastMIP->GetWidgetName() );
        this->CB_GPURayCastMIP->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);
        
        //enable/disable adaptive frame rate control
        this->CB_GPURayCastForceHighQuality=vtkKWCheckButtonWithLabel::New();
        this->CB_GPURayCastForceHighQuality->SetParent(this->FrameGPURayCasting->GetFrame());
        this->CB_GPURayCastForceHighQuality->Create();
        this->CB_GPURayCastForceHighQuality->SetBalloonHelpString("Force GPU mapper to use high quality (high sampling rate) and ignore expected FPS. May overwhelm GPU when used with Use Large Volume option.");
        this->CB_GPURayCastForceHighQuality->SetLabelText("Force High Quality");
        this->CB_GPURayCastForceHighQuality->SetLabelWidth(labelWidth);
        this->CB_GPURayCastForceHighQuality->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_GPURayCastForceHighQuality->GetWidgetName() );
        this->CB_GPURayCastForceHighQuality->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);
        
        //enable/disable large volume
        this->CB_GPURayCastLargeVolume=vtkKWCheckButtonWithLabel::New();
        this->CB_GPURayCastLargeVolume->SetParent(this->FrameGPURayCasting->GetFrame());
        this->CB_GPURayCastLargeVolume->Create();
        this->CB_GPURayCastLargeVolume->SetBalloonHelpString("Increase size for internal volume for better rendering quality.");
        this->CB_GPURayCastLargeVolume->SetLabelText("Use Large Volume");
        this->CB_GPURayCastLargeVolume->SetLabelWidth(labelWidth);
        this->CB_GPURayCastLargeVolume->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_GPURayCastLargeVolume->GetWidgetName() );
        this->CB_GPURayCastLargeVolume->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);

    }
    
    //opengl 2D polygon blending
    {
        this->FramePolygonBlending = vtkKWFrameWithLabel::New();
        this->FramePolygonBlending->SetParent(this->FramePerformance->GetFrame());
        this->FramePolygonBlending->Create();
        this->FramePolygonBlending->AllowFrameToCollapseOff();
        this->FramePolygonBlending->SetLabelText("OpenGL Polygon Blending");
        this->Script( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->FramePolygonBlending->GetWidgetName() );
        
        //enable/disable adaptive frame rate control
        this->CB_TextureMapperForceHighQuality=vtkKWCheckButtonWithLabel::New();
        this->CB_TextureMapperForceHighQuality->SetParent(this->FramePolygonBlending->GetFrame());
        this->CB_TextureMapperForceHighQuality->Create();
        this->CB_TextureMapperForceHighQuality->SetBalloonHelpString("Force texture mapper to use high quality (high sampling rate) and ignore expected FPS.");
        this->CB_TextureMapperForceHighQuality->SetLabelText("Force High Quality");
        this->CB_TextureMapperForceHighQuality->SetLabelWidth(labelWidth);
        this->CB_TextureMapperForceHighQuality->GetWidget()->SetSelectedState(0);
        this->Script ( "pack %s -side top -anchor nw -fill x -padx 2 -pady 2", this->CB_TextureMapperForceHighQuality->GetWidgetName() );
        this->CB_TextureMapperForceHighQuality->GetWidget()->AddObserver(vtkKWCheckButton::SelectedStateChangedEvent, (vtkCommand*) this->VolumeRenderingCallbackCommand);   
    }
   
}

void vtkSlicerVRGrayscaleHelper::DestroyPerformance(void)
{
    //Save old values to registry
    // why we save these values? It is safer to use default value for volume rendering
//    this->Gui->GetApplication()->SetRegistryValue(2,"VolumeRendering","CB_GPURayCastShading","%d",this->CB_RayCast->GetWidget()->GetSelectedState());
//    this->Gui->GetApplication()->SetRegistryValue(2,"VolumeRendering","CB_GPURayCastLargeVolume","%d",this->CB_TextureLow->GetWidget()->GetSelectedState());
//    this->Gui->GetApplication()->SetRegistryValue(2,"VolumeRendering","CB_GPURayCastMIP","%d",this->CB_TextureHigh->GetWidget()->GetSelectedState());
//    this->Gui->GetApplication()->SetRegistryValue(2,"VolumeRendering","CB_CPURayCastForceHighQuality","%d",this->CB_CPURayCastForceHighQuality->GetWidget()->GetSelectedState());
//    this->Gui->GetApplication()->SetRegistryValue(2,"VolumeRendering","SC_ExpectedFPS","%e",this->SC_ExpectedFPS->GetValue());
    
    if(this->CB_GPURayCastShading!=NULL)
    {
        this->CB_GPURayCastShading->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_GPURayCastShading->SetParent(NULL);
        this->CB_GPURayCastShading->Delete();
        this->CB_GPURayCastShading=NULL;
    }
    
    if(this->CB_GPURayCastLargeVolume!=NULL)
    {
        this->CB_GPURayCastLargeVolume->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_GPURayCastLargeVolume->SetParent(NULL);
        this->CB_GPURayCastLargeVolume->Delete();
        this->CB_GPURayCastLargeVolume=NULL;
    }
    
    if(this->CB_GPURayCastMIP!=NULL)
    {
        this->CB_GPURayCastMIP->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_GPURayCastMIP->SetParent(NULL);
        this->CB_GPURayCastMIP->Delete();
        this->CB_GPURayCastMIP=NULL;
    }
    
    if(this->CB_GPURayCastForceHighQuality!=NULL)
    {
        this->CB_GPURayCastForceHighQuality->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_GPURayCastForceHighQuality->SetParent(NULL);
        this->CB_GPURayCastForceHighQuality->Delete();
        this->CB_GPURayCastForceHighQuality=NULL;
    }
    
    if(this->CB_TextureMapperForceHighQuality!=NULL)
    {
        this->CB_TextureMapperForceHighQuality->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_TextureMapperForceHighQuality->SetParent(NULL);
        this->CB_TextureMapperForceHighQuality->Delete();
        this->CB_TextureMapperForceHighQuality=NULL;
    }
    
    if(this->SC_ExpectedFPS!=NULL)
    {
        this->SC_ExpectedFPS->RemoveObservers(vtkKWScale::ScaleValueChangedEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->SC_ExpectedFPS->SetParent(NULL);
        this->SC_ExpectedFPS->Delete();
        this->SC_ExpectedFPS=NULL;
    }
    
    if(this->CB_CPURayCastMIP!=NULL)
    {
        this->CB_CPURayCastMIP->GetWidget()->RemoveObservers(vtkKWCheckButton::SelectedStateChangedEvent,(vtkCommand*)this->VolumeRenderingCallbackCommand);
        this->CB_CPURayCastMIP->SetParent(NULL);
        this->CB_CPURayCastMIP->Delete();
        this->CB_CPURayCastMIP=NULL;
    }
    
    if(this->CB_CPURayCastForceHighQuality!=NULL)
    {
        this->CB_CPURayCastForceHighQuality->GetWidget()->RemoveObservers(vtkKWScale::ScaleValueChangedEvent,(vtkCommand *) this->VolumeRenderingCallbackCommand);
        this->CB_CPURayCastForceHighQuality->SetParent(NULL);
        this->CB_CPURayCastForceHighQuality->Delete();
        this->CB_CPURayCastForceHighQuality=NULL;
    }
    
    if(this->MB_Mapper != NULL)
    {
        this->MB_Mapper->SetParent(NULL);
        this->MB_Mapper->Delete();
        this->MB_Mapper=NULL;
    }
    
    if (this->FramePerformance != NULL)
    {
        this->FramePerformance->SetParent(NULL);
        this->FramePerformance->Delete();
        this->FramePerformance = NULL;
    }
    
    if (this->FrameGPURayCasting != NULL)
    {
        this->FrameGPURayCasting->SetParent(NULL);
        this->FrameGPURayCasting->Delete();
        this->FrameGPURayCasting = NULL;
    }
    
    if (this->FramePolygonBlending != NULL)
    {
        this->FramePolygonBlending->SetParent(NULL);
        this->FramePolygonBlending->Delete();
        this->FramePolygonBlending = NULL;
    }
    
    if (this->FrameCPURayCasting != NULL)
    {
        this->FrameCPURayCasting->SetParent(NULL);
        this->FrameCPURayCasting->Delete();
        this->FrameCPURayCasting = NULL;
    }
    
    if (this->FrameFPS != NULL)
    {
        this->FrameFPS->SetParent(NULL);
        this->FrameFPS->Delete();
        this->FrameFPS = NULL;
    }
}


void vtkSlicerVRGrayscaleHelper::ProcessClippingModified(void)
{
    //If we have an additional Transform Node use it
    if(this->CurrentTransformNodeCropping!=NULL)
    {
        vtkMatrix4x4 *matrix=this->CurrentTransformNodeCropping->GetMatrixTransformToParent();
        this->AdditionalClippingTransform->SetMatrix(matrix);
        this->InverseAdditionalClippingTransform->SetMatrix(matrix);
        this->InverseAdditionalClippingTransform->Inverse();
        //matrix->Delete();
    }
    //Otherwise go back to Identity;
    else
    {
        this->AdditionalClippingTransform->Identity();
        this->InverseAdditionalClippingTransform->Identity();
    }
    this->BW_Clipping_Representation->SetTransform(this->AdditionalClippingTransform);
    this->BW_Clipping_Widget->InvokeEvent(vtkCommand::EndInteractionEvent);
    this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();

}
//TODO: Scaling,translation with transform (scaling part of transform or part or placewidget)->preferred: part of transform
//TODO: Adjust initial range to size of volume, reduce until old volume is reached 

//Note: we save clipping planes in ijk space, show it in ras and

void vtkSlicerVRGrayscaleHelper::EstimateSampleDistances(void)
{
    double *spacing = vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetSpacing();
    
    double minSpace = spacing[0];
    double maxSpace = spacing[0];
    
    for(int i = 1; i < 3; i++)
    {
        if (spacing[i] > maxSpace)
            maxSpace = spacing[i];
        if (spacing[i] < minSpace)
            minSpace = spacing[i];
    }
    
    vtkImageData *imageData = vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData();
    int *dims = imageData->GetDimensions();
    int minDim = dims[0];
    minDim = minDim > dims[1] ? dims[1] : minDim;
    minDim = minDim > dims[2] ? dims[2] : minDim;
    
    this->EstimatedInteractiveSampleDistance = maxSpace * 4;
    
    this->EstimatedSampleDistance = minSpace * 0.5;
    
}

void vtkSlicerVRGrayscaleHelper::ConvertWorldToBoxCoordinates(double *inputOutput)
{
    int pointAint[3];
    double pointA[4];
    vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetDimensions(pointAint);
    for(int i=0;i<3;i++)
    {
        pointA[i]=pointAint[i]/2.;
    }
    pointA[3]=1;
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    this->CalculateMatrix(matrix);
    matrix->MultiplyPoint(pointA,pointA);

    for(int i=0;i<3;i++)
    {
        inputOutput[i]=inputOutput[i]-pointA[i];
    }
    matrix->Delete();
}

void vtkSlicerVRGrayscaleHelper::ConvertBoxCoordinatesToWorld(double* inputOutput)
{
    int pointAint[3];
    double pointA[4];
    vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetDimensions(pointAint);
    for(int i=0;i<3;i++)
    {
        pointA[i]=pointAint[i]/2.;
    }
    pointA[3]=1;
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    this->CalculateMatrix(matrix);
    matrix->MultiplyPoint(pointA,pointA);
    for(int i=0;i<3;i++)
    {
        inputOutput[i]=inputOutput[i]+pointA[i];
    }
    matrix->Delete();
}

void vtkSlicerVRGrayscaleHelper::ProcessConfigureCallback(void)
{
    vtkRenderWindowInteractor *interactor=this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->GetInteractor();
    interactor->UpdateSize(this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->GetSize()[0],
    this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->GetSize()[1]);
}

void vtkSlicerVRGrayscaleHelper::CalculateBoxCoordinatesBoundaries(void)
{
    //Calculate origin in box coordinates
    //int pointAint[3];
    double pointA[4];
    //vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetOrigin(pointAint);
    for(int i=0;i<3;i++)
    {
        pointA[i]=0;
    }
    pointA[3]=1;
    vtkMatrix4x4 *matrix=vtkMatrix4x4::New();
    this->CalculateMatrix(matrix);
    matrix->MultiplyPoint(pointA,pointA);//Now we have point in world coordinates
    this->ConvertWorldToBoxCoordinates(pointA);//Now we have point in box coordinates


    //Calculate dimension in box coordinates
    int pointBint[3];
    double pointB[4];
    vtkMRMLScalarVolumeNode::SafeDownCast(this->Gui->GetNS_ImageData()->GetSelected())->GetImageData()->GetDimensions(pointBint);
    for(int i=0;i<3;i++)
    {
        pointB[i]=pointBint[i];
    }
    pointB[3]=1;
    matrix->MultiplyPoint(pointB,pointB);//Now we have point in world coordinates
    this->ConvertWorldToBoxCoordinates(pointB);//Now we have point in box coordinates

    for(int i=0;i<3;i++)
    {
        if(pointA[i]<0)
        {
            this->VolumeBoundariesBoxCoordinates[0][i]=pointA[i];
            this->VolumeBoundariesBoxCoordinates[1][i]=pointB[i];
        }
        else
        {
            this->VolumeBoundariesBoxCoordinates[0][i]=pointB[i];
            this->VolumeBoundariesBoxCoordinates[1][i]=pointA[i];
        }
    }
    matrix->Delete();
}

void vtkSlicerVRGrayscaleHelper::CheckAbort(void)
{
    int pending=this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->GetEventPending();
    if(pending!=0)
    {
        vtkSlicerVRHelperDebug("got an abort","");
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->SetAbortRender(1);
        return;
    }
    int pendingGUI=vtkKWTkUtilities::CheckForPendingInteractionEvents(this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow());
    if(pendingGUI!=0)
    {
        vtkSlicerVRHelperDebug("got an abort from gui","");
        this->Gui->GetApplicationGUI()->GetViewerWidget()->GetMainViewer()->GetRenderWindow()->SetAbortRender(1);
        return;

    }
}

void vtkSlicerVRGrayscaleHelper::SetupCPURayCastInteractive()
{
    if (this->MapperRaycast == NULL || this->Volume == NULL)
        return;
        
    if (this->Volume->GetMapper() != this->MapperRaycast)
        return;
        
    //when start (rendering??) set CPU ray casting to be interactive
    if (this->ButtonDown == 1)
    {
        float desiredTime = 1.0f/this->SC_ExpectedFPS->GetValue();//expected fps will not be 0 so safe to do division here
  
        this->MapperRaycast->SetAutoAdjustSampleDistances(1);
        this->MapperRaycast->ManualInteractiveOn();
        this->MapperRaycast->SetManualInteractiveRate(desiredTime);
        
        this->CPURayCastingInteractionFlag = 1;
        this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->SetStatusText("Using CPU Raycasting: Interactive Quality");
    }
    else
    {
        //when end (rendering??) set CPU ray casting to be non-interactive high quality
        this->MapperRaycast->SetAutoAdjustSampleDistances(0);
        this->MapperRaycast->SetSampleDistance(this->EstimatedSampleDistance);
        this->MapperRaycast->SetImageSampleDistance(1.0f);
        this->MapperRaycast->ManualInteractiveOff();
        
        if (this->CPURayCastingInteractionFlag == 1)//avoid endless loop
        {
            this->Gui->GetApplicationGUI()->GetMainSlicerWindow()->SetStatusText("Using CPU Raycasting: High Quality");
            this->Gui->GetApplicationGUI()->GetViewerWidget()->RequestRender();
            this->CPURayCastingInteractionFlag = 0;
        }
    }
}
