#ifndef __vtkLiverAblationGUI_h
#define __vtkLiverAblationGUI_h

#include "vtkSlicerModuleGUI.h"
#include "vtkLiverAblation.h"

class vtkLiverAblationLogic;
class vtkLiverAblationMRMLManager;
class vtkKWWizardWidget;
class vtkLiverAblationOptimizationStep;
class vtkLiverAblationLoadingPreoperativeDataStep;
class vtkLiverAblationPreplanningStep;
class vtkLiverAblationPlanningStep;
class vtkLiverAblationTrackingStep;
class vtkLiverAblationNavigationStep;
class vtkMRMLNode;
 
class VTK_LIVERABLATION_EXPORT vtkLiverAblationGUI : public vtkSlicerModuleGUI
{
public:
  static vtkLiverAblationGUI *New();
  vtkTypeMacro(vtkLiverAblationGUI,vtkSlicerModuleGUI);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description: 
  // Get the categorization of the module.
  const char *GetCategory() const { return "IGT"; }

  // Description: 
  // Get/Set logic node
  vtkGetObjectMacro(Logic, vtkLiverAblationLogic);
//  virtual void SetLogic(vtkLiverAblationLogic*);

  /// Implement setter for vtkLogic* pointer
//  virtual void SetModuleLogic(vtkSlicerLogic*);
  void SetModuleLogic ( vtkSlicerLogic *logic );
 
  // Get/Set mrml manager node
  vtkGetObjectMacro(MRMLManager, vtkLiverAblationMRMLManager);
  virtual void SetMRMLManager(vtkLiverAblationMRMLManager*);

  // Description: 
  // Get/Set MRML node
  vtkGetObjectMacro(Node, vtkMRMLNode);
  virtual void SetNode(vtkMRMLNode*);

  // Description: 
  // Get wizard widget
  vtkGetObjectMacro(WizardWidget, vtkKWWizardWidget);

  // Description:
  // Create widgets
  virtual void BuildGUI();

  // Description:
  // Initialize module
  virtual void Init();

  // Description:
  // Delete Widgets
  virtual void TearDownGUI();

  // Description:
  // Add observers to GUI widgets
  virtual void AddGUIObservers();
  
  // Description:
  // Remove observers to GUI widgets
  //virtual void RemoveGUIObservers();

  // Description:
  // Remove observers to MRML node
  //virtual void RemoveMRMLNodeObservers();

  // Description:
  // Remove observers to Logic
  virtual void RemoveLogicObservers();
  
  // Description:
  // Pprocess events generated by Logic
  virtual void ProcessLogicEvents( vtkObject *caller, unsigned long event,
                                   void *callData); 

  // Description:
  // Pprocess events generated by GUI widgets
  /*virtual void ProcessGUIEvents( vtkObject *caller, unsigned long event,
                                 void *callData); */
  // Description:
  // Process events generated by MRML
  virtual void ProcessMRMLEvents( vtkObject *caller, unsigned long event, 
                                  void *callData);

  // Description:
  // Describe behavior at module startup and exit.
  virtual void Enter() { };
  virtual void Exit() { };

  // Description: The name of the Module - this is used to 
  // construct the proc invocations
  vtkGetStringMacro(ModuleName);
  vtkSetStringMacro(ModuleName);

  // Description: set an observer by number (work around
  // limitation in kwwidgets tcl wrapping)
  unsigned long AddObserverByNumber(vtkObject *observee, unsigned long event);

protected:
  vtkLiverAblationGUI();
  ~vtkLiverAblationGUI();
  vtkLiverAblationGUI(const vtkLiverAblationGUI&);
  void operator=(const vtkLiverAblationGUI&);

  // Description:
  // Updates GUI widgets based on parameters values in MRML node
  void UpdateGUI();

  // Description:
  // Updates parameters values in MRML node based on GUI widgets 
  void UpdateMRML();
  
  vtkLiverAblationLogic       *Logic;
  vtkLiverAblationMRMLManager *MRMLManager;
  vtkMRMLNode       *Node;
  
  char *ModuleName;

  // Description:
  // The wizard widget and steps
  vtkKWWizardWidget                                *WizardWidget;
  vtkLiverAblationOptimizationStep                 *OptimizationStep;
  vtkLiverAblationLoadingPreoperativeDataStep      *LoadingPreoperativeDataStep;
  vtkLiverAblationPreplanningStep                  *PreplanningStep; 
  vtkLiverAblationPlanningStep                     *PlanningStep; 
  vtkLiverAblationTrackingStep                     *TrackingStep; 
  vtkLiverAblationNavigationStep                   *NavigationStep; 

};

#endif
