package SliMP3::Buttons::TrackInfo;

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use SliMP3::Buttons::Common;
use SliMP3::Buttons::Playlist;
use SliMP3::Misc;
use SliMP3::Strings qw (string);

# button functions for track info screens

my %functions = (

	'play' => sub  {
			my $client = shift;
			my $curitem = $client->trackInfoContent->[currentLine($client)];
			my ($line1, $line2);
			
			if (SliMP3::Playlist::shuffle($client)) {
				$line1 = string('PLAYING_RANDOMLY_FROM');
			} else {
				$line1 = string('NOW_PLAYING_FROM')
			}
			
			if ($curitem && $curitem eq 'GENRE') {
				$line2 = SliMP3::Info::genre(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "loadalbum", SliMP3::Info::genre(track($client)), "*", "*"]);
				SliMP3::Command::execute($client, ["playlist", "jump", "0"]);
			} elsif ($curitem && ($curitem eq 'ARTIST')) {
				$line2 = SliMP3::Info::artist(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "loadalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::artist(track($client)), "*"]);			
				SliMP3::Command::execute($client, ["playlist", "jump", "0"]);
			} elsif ($curitem && ($curitem eq 'COMPOSER')) {
				$line2 = SliMP3::Info::composer(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "loadalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::composer(track($client)), "*"]);			
				SliMP3::Command::execute($client, ["playlist", "jump", "0"]);
			} elsif ($curitem && ($curitem eq 'BAND')) {
				$line2 = SliMP3::Info::band(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "loadalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::band(track($client)), "*"]);			
				SliMP3::Command::execute($client, ["playlist", "jump", "0"]);
			} elsif ($curitem && $curitem eq 'ALBUM') {
				$line2 = SliMP3::Info::album(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "loadalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::artist(track($client)), SliMP3::Info::album(track($client))]);			
				SliMP3::Command::execute($client, ["playlist", "jump", "0"]);
			} else {
				SliMP3::Buttons::Common::popModeRight($client);
				SliMP3::IR::executeButton($client, 'play');
			}
	},
	
	'add' => sub  {
			my $client = shift;
			my $curitem = $client->trackInfoContent->[currentLine($client)];
			my ($line1, $line2);
			
			$line1 = string('ADDING_TO_PLAYLIST');
			
			if ($curitem && $curitem eq 'GENRE') {
				$line2 = SliMP3::Info::genre(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "addalbum", SliMP3::Info::genre(track($client)), "*", "*"]);
			} elsif ($curitem && $curitem eq 'ARTIST') {
				$line2 = SliMP3::Info::artist(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "addalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::artist(track($client)), "*"]);			
			} elsif ($curitem && $curitem eq 'COMPOSER') {
				$line2 = SliMP3::Info::composer(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "addalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::composer(track($client)), "*"]);			
			} elsif ($curitem && $curitem eq 'BAND') {
				$line2 = SliMP3::Info::band(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "addalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::band(track($client)), "*"]);			
			} elsif ($curitem && $curitem eq 'ALBUM') {
				$line2 = SliMP3::Info::album(track($client));
				SliMP3::Animation::showBriefly($client, SliMP3::Display::renderOverlay($line1, $line2, undef, SliMP3::VFD::symbol('notesymbol')), undef,1);
				SliMP3::Command::execute($client, ["playlist", "addalbum", SliMP3::Info::genre(track($client)), SliMP3::Info::artist(track($client)), SliMP3::Info::album(track($client))]);			
			} else {
				SliMP3::Buttons::Common::popModeRight($client);
				SliMP3::IR::executeButton($client, 'add');
			}
	},
	
	'up' => sub  {
		my $client = shift;
		currentLine($client, SliMP3::Buttons::Common::scroll($client, -1, $#{$client->trackInfoLines} + 1, currentLine($client)));
		SliMP3::Display::update($client);
	},
	'down' => sub  {
		my $client = shift;
		currentLine($client, SliMP3::Buttons::Common::scroll($client, +1, $#{$client->trackInfoLines} + 1, currentLine($client)));
		SliMP3::Display::update($client);
	},
	'left' => sub  {
		my $client = shift;
		SliMP3::Buttons::Common::popModeRight($client);
	},
	'right' => sub  {
		my $client = shift;
		my $push = 0;
		my $curitem = $client->trackInfoContent->[currentLine($client)];
		my @oldlines = SliMP3::Display::curLines($client);
		if (!defined($curitem)) {
			$curitem = "";
		}
		if ($curitem eq 'ALBUM') {
			SliMP3::Buttons::BrowseID3::setSelection($client, '*', '*', SliMP3::Info::album(track($client)), undef);
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>'*', 'artist'=>'*', 'album' => SliMP3::Info::album(track($client)) });
			$push = 1;
		} elsif ($curitem eq 'ARTIST') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>'*', 'artist' => SliMP3::Info::artist(track($client)) });
			$push = 1;
		} elsif ($curitem eq 'COMPOSER') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>'*', 'artist' => SliMP3::Info::composer(track($client)) });
			$push = 1;
		} elsif ($curitem eq 'BAND') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>'*', 'artist' => SliMP3::Info::band(track($client)) });
			$push = 1;
		} elsif ($curitem eq 'GENRE') {
			SliMP3::Buttons::Common::pushMode($client, 'browseid3', {'genre'=>SliMP3::Info::genre(track($client))});
			$push = 1;
		} else {
			SliMP3::Animation::bumpRight($client);
		}
		if ($push) {
			SliMP3::Animation::pushLeft($client, @oldlines, SliMP3::Display::curLines($client));
		}
	},
	'numberScroll' => sub  {
		my $client = shift;
		my $button = shift;
		my $digit = shift;
		currentLine($client, SliMP3::Buttons::Common::numberScroll($client, $digit, $client->trackInfoLines, 0));
		SliMP3::Display::update($client);
	}
);

sub getFunctions {
	return \%functions;
}

sub setMode {
	my $client = shift;
	my $item = shift;
	$client->lines(\&lines);
	preloadLines($client, track($client));
}

# get (and optionally set) the track URL
sub track {
	my $client = shift;
	return SliMP3::Buttons::Common::param($client, 'track', shift);
}

# get (and optionally set) the track info scroll position
sub currentLine {
	my $client = shift;
	my $line = SliMP3::Buttons::Common::param($client, 'line', shift);
	if (!defined($line)) {  $line = 0; }
	return $line
}

sub preloadLines {
	my $client = shift;
	my $url = shift;

	@{$client->trackInfoLines} = ();
	@{$client->trackInfoContent} = ();

	if (SliMP3::Info::title($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('TITLE').": ".SliMP3::Info::title($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::artist($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('ARTIST').": ".SliMP3::Info::artist($url));
		push (@{$client->trackInfoContent}, 'ARTIST');
	}

	if (SliMP3::Info::band($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('BAND').": ".SliMP3::Info::band($url));
		push (@{$client->trackInfoContent}, 'BAND');
	}

	if (SliMP3::Info::composer($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('COMPOSER').": ".SliMP3::Info::composer($url));
		push (@{$client->trackInfoContent}, 'COMPOSER');
	}

	if (SliMP3::Info::album($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('ALBUM').": ".SliMP3::Info::album($url));
		push (@{$client->trackInfoContent}, 'ALBUM');
	}

	if (SliMP3::Info::trackNumber($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('TRACK').": ".SliMP3::Info::trackNumber($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::year($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('YEAR').": ".SliMP3::Info::year($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::genre($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('GENRE').": ".SliMP3::Info::genre($url));
		push (@{$client->trackInfoContent}, 'GENRE');
	}

	if (SliMP3::Info::contentType($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('TYPE').": ". string(uc(SliMP3::Info::contentType($url))));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::comment($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('COMMENT').": ".SliMP3::Info::comment($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::duration($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('LENGTH').": ". SliMP3::Info::duration($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::bitrate($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('BITRATE').": ".SliMP3::Info::bitrate($url));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::fileLength($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('FILELENGTH').": ".SliMP3::Misc::delimitThousands(SliMP3::Info::fileLength($url)));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::age($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('MODTIME').": ".SliMP3::Misc::shortDateF(SliMP3::Info::age($url)) . ", " . SliMP3::Misc::timeF(SliMP3::Info::age($url)));
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::isURL($url)) {
		push (@{$client->trackInfoLines}, "URL: ". $url);
		push (@{$client->trackInfoContent}, undef);
	}

	if (SliMP3::Info::tagVersion($url)) {
		push (@{$client->trackInfoLines}, SliMP3::Strings::string('TAGVERSION').": ".SliMP3::Info::tagVersion($url));
		push (@{$client->trackInfoContent}, undef);
	}

}

#
# figure out the lines to be put up to display the directory
#
sub lines {
	my $client = shift;
	my ($line1, $line2);

	# Show the title of the song with a note symbol
	$line1 = SliMP3::Info::standardTitle($client, track($client));
	$line2 = $client->trackInfoLines->[currentLine($client)];
	my $overlay1 = SliMP3::VFD::symbol('notesymbol');
	my $overlay2 = defined($client->trackInfoContent->[currentLine($client)]) ? SliMP3::VFD::symbol('rightarrow') : undef;
	return ($line1, $line2, $overlay1, $overlay2);
}

1;

__END__
