-- See the Copyright notice at the end of this file.
--
class STRING_WEAK_ARRAY

insert
	PLATFORM
	WEAK_ARRAY[STRING]
		export {} item
		end

creation {ANY}
	make

feature {ANY}
	new: STRING is
		do
			Result := item
			if Result = Void then
				create Result.make(128)
			end
		ensure
			Result.is_empty
		end

	best_fit (capacity: INTEGER): STRING is
		local
			i, c, found, found_capacity: INTEGER; gc, done: BOOLEAN
		do
			if cursor /= no_item then
				gc := collecting
				collection_off
				from
					i := next(cursor)
					found := no_item
					found_capacity := Maximum_integer
				until
					done or else i = no_item
				loop
					c := item_at(i).capacity
					if c < capacity then
					elseif c <= capacity + 4 then
						done := True
						found := i
					elseif c <= found_capacity then
						found := i
						found_capacity := c
					end
					i := next(i)
				end
				if found /= no_item then
					Result := item_at(found)
					check
						Result /= Void
					end
				end
				if gc then
					collection_on
				end
			end
			if Result = Void then
				create Result.make(capacity)
			end
		ensure
			Result.is_empty
			Result.capacity >= capacity
		end

	new_twin (string: STRING): STRING is
		require
			string /= Void
		do
			Result := best_fit(string.count)
			Result.copy(string)
		ensure
			Result /= string
			Result.is_equal(string)
		end

end -- class STRING_WEAK_ARRAY
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
