-- See the Copyright notice at the end of this file.
--
deferred class RENDERER

feature {ANY}
	draw_line (d: DRAWABLE; x1, y1, x2, y2, state: INTEGER) is
		deferred
		end

	draw_rectangle (d: DRAWABLE; x, y, width, height, state: INTEGER) is
		deferred
		end

	draw_fill_rectangle (d: DRAWABLE; x, y, width, height, state: INTEGER) is
		deferred
		end

	draw_button (b: BUTTON) is
		deferred
		end

	draw_check_button (b: CHECK_SPACE) is
		deferred
		end

	draw_box (d: DRAWABLE; x, y, width, height: INTEGER; intensity: INTEGER) is
		require
			intensity.in_range(0, 16)
		deferred
		end

	draw_string (d: DRAWABLE; s: UNICODE_STRING; x, y, state: INTEGER) is
		deferred
		end

	font (state: INTEGER): BASIC_FONT is
		deferred
		end

end -- class RENDERER
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
