-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class TEST_NUMBER75

insert
	NUMBER_TOOLS

creation {ANY}
	make

feature {ANY}
	make is
		local
			n: NUMBER; r: STRING
		do
			n := from_integer(1000)
			r := n.factorial.to_string
			assert(r.is_equal(once "4023872600770937735437024339230039857193748642107146325437999%
	  %1042993851239862902059204420848696940480047998861019719605863%
	  %1666872994808558901323829669944590997424504087073759918823627%
	  %7271887325197795059509952761208749754624970436014182780946464%
	  %9629105639388743788648733711918104582578364784997701247663288%
	  %9835955735432513185323958463075557409114262417474349347553428%
	  %6465766116677973966688202912073791438537195882498081268678383%
	  %7455973174613608537953452422158659320192809087829730843139284%
	  %4403281231558611036976801357304216168747609675871348312025478%
	  %5893207671691324484262361314125087802080002616831510273418279%
	  %7770478463586817016436502415369139828126481021309276124489635%
	  %9928705114964975419909342221566832572080821333186116811553615%
	  %8365469840467089756029009505376164758477284218896796462449451%
	  %6076535340819890138544248798495995331910172335555660213945039%
	  %9736280750137837615307127761926849034352625200015888535147331%
	  %6117021039681759215109077880193931781141945452572238655414610%
	  %6289218796022383897147608850627686296714667469756291123408243%
	  %9208160153780889893964518263243671616762179168909779911903754%
	  %0312746222899880051954444142820121873617459926429565817466283%
	  %0295557029902432415318161721046583203678690611726015878352075%
	  %1516284225540265170483304226143974286933061690897968482590125%
	  %4583271682264580665267699586526822728070757813918581788896522%
	  %0816434834482599326604336766017699961283186078838615027946595%
	  %5131156552036093988180612138558600301435694527224206344631797%
	  %4605946825731037900840244324384656572450144028218852524709351%
	  %9062092902313649327349756551395872055965422874977401141334696%
	  %2715422845862377387538230483865688976461927383814900140767310%
	  %4466402598994902222217659043399018860185665264850617997023561%
	  %9389701786004081188972991831102117122984590164192106888438712%
	  %1855646124960798722908519296819372388642614839657382291123125%
	  %0241866493531439701374285319266498753372189406942814341185201%
	  %5801412334482801505139969429015348307764456909907315243327828%
	  %8269864602789864321139083506217095002597389863554277196742822%
	  %2487575867657523442202075736305694988250879689281627538488633%
	  %9690995982628095612145099487170124451646126037902930912088908%
	  %6942028510640182154399457156805941872748998094254742173582401%
	  %0636774045957417851608292301353580818400969963725242305608559%
	  %0370062427124341690900415369010593398383577793941097002775347%
	  %2000000000000000000000000000000000000000000000000000000000000%
	  %0000000000000000000000000000000000000000000000000000000000000%
	  %0000000000000000000000000000000000000000000000000000000000000%
	  %0000000000000000000000000000000000000000000000000000000000000%
	  %000000"))
		end

	count: INTEGER

	assert (b: BOOLEAN) is
		do
			count := count + 1
			if not b then
				sedb_breakpoint
				io.put_string("TEST_NUMBER75 : ERROR Test # ")
				io.put_integer(count)
				io.put_string("%N")
			end
		end

end -- class TEST_NUMBER75
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
