class NUMBERED_CAPTURE
--
-- Temporary object used only during the backend for AGENT_CREATION 
-- generation. ***** METTRE A JOUR ***
-- Such an object is used only when the captured expression is not atomic (because when the captured 
-- expression is atomic, the field name and the captured expression are identical).
--
inherit
	NON_WRITTEN_EXPRESSION

creation	{AGENT_CREATION}
	make

feature {ANY}
	captured: EXPRESSION
			-- The `captured' one.

	start_position: POSITION is
		do
			Result := captured.start_position
		end

	is_writable: BOOLEAN is True

	resolve_in (type: TYPE): TYPE is
		do
			Result := captured.resolve_in(type)
		end
	
	side_effect_free (type: TYPE): BOOLEAN is
		do
			Result := True -- already captured hence evaluated.
		end

	non_void_no_dispatch_type (type: TYPE): TYPE is
		do
			Result := captured.non_void_no_dispatch_type(type)
		end

   use_current (type: TYPE): BOOLEAN is
		do
			check
				not Result -- even Current is captured.
			end
		end

	is_static: BOOLEAN is
		do
			Result := captured.is_static
		end
	
   safety_check (type: TYPE) is
		do
			-- That check is already performed in the agent creation.
		end

   collect (type: TYPE): TYPE is
		do
			Result := captured.collect(type)
		end

   simplify (type: TYPE): EXPRESSION is
		do
			Result := Current	-- already simplified in agent creation.
		end

	adapt_for (type: TYPE): like Current is
		do
			check
				False
			end
		end

	declaration_type: TYPE is
		do
			check
				False
			end
		end
		
	compile_to_c (type: TYPE) is
		do
			cpp.pending_c_function_body.append(once "u->c")
			number.append_in(cpp.pending_c_function_body)
		end
	
	mapping_c_target (type, formal_target_type: TYPE) is
		do
			standard_mapping_c_target(type, formal_target_type)
		end

	mapping_c_arg (type: TYPE) is
		do
			compile_to_c(type)
		end

	compile_to_jvm (type: TYPE) is
		do
			not_yet_implemented
		end

	compile_target_to_jvm (type: TYPE) is
		do
			check
				False
			end
		end

	jvm_branch_if_false (type: TYPE): INTEGER is
		do
			check
				False
			end
		end

	jvm_branch_if_true (type: TYPE): INTEGER is
		do
			check
				False
			end
		end

	jvm_assign_creation (type: TYPE) is
		do
			check
				False
			end
		end

	jvm_assign (type: TYPE) is
		do
			check
				False
			end
		end
	
	accept (visitor: NUMBERED_CAPTURE_VISITOR) is
		do
			visitor.visit_numbered_capture(Current)
		end

feature {}
	number: INTEGER

	make (c: like captured; n: like number) is
		require
			c /= Void
			n >= 0
		do
			captured := c
			number := n
		ensure
			captured = c
			number = n
		end

invariant
	number >= 0
	
end
	
