-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class ADDRESS_OF_POOL
	--
	-- Unique global object in charge of $ operator calls.
	--

inherit
	ANY
insert
	GLOBALS

feature {}
	registered: FAST_ARRAY[RUN_FEATURE] is
		once
			create Result.with_capacity(64)
		end

	caller_memory: FAST_ARRAY[ADDRESS_OF] is
		once
			create Result.with_capacity(64)
		end

feature {ADDRESS_OF}
	register_for (address_of: ADDRESS_OF) is
		require
			address_of.feature_name /= Void
		local
			rf: RUN_FEATURE
		do
			rf := address_of.run_feature
			if not registered.fast_has(rf) then
				registered.add_last(rf)
				caller_memory.add_last(address_of)
			end
		ensure
			registered.fast_has(address_of.run_feature)
		end

feature {C_PRETTY_PRINTER}
	c_define is
		local
			i: INTEGER
		do
			i := registered.upper
			if i >= 0 then
				from
				until
					i < 0
				loop
					registered.item(i).address_of_c_define(caller_memory.item(i))
					i := i - 1
				end
			end
		end

end -- class ADDRESS_OF_POOL
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
