-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
expanded class SWITCH_COLLECTION
	--
	-- Unique Global Object in charge of the `switch_collection'.
	--

insert
	GLOBALS

feature {ANY}
	count: INTEGER is
		do
			Result := count_memory.value
		end

feature {}
	count_memory: COUNTER is
		once
			create Result
		end

feature {SWITCH_SITE}
	new_id: INTEGER is
		do
			Result := count_memory.value
			count_memory.increment
		end

feature {SMART_EIFFEL}
	reset is
			-- Called before a re-collect cycle.
		do
			--|*** Is there actually something to reset ?
		end

feature {C_PRETTY_PRINTER}
	initialize_switch_site_profiles is
		require
			ace.profile
			cpp.pending_c_function
		local
			switches: SWITCH_TYPE; feature_desc: SWITCH_SITE; count1, count2: INTEGER
		do
			if not dictionary.is_empty then
				from
					count1 := 1
				until
					count1 > dictionary.count
				loop
					switches := dictionary.item(count1)
					from
						count2 := 1
					until
						count2 > switches.count
					loop
						feature_desc := switches.item(count2)
						cpp.pending_c_function_body.append(once "init_profile(switch_profile+")
						feature_desc.id.append_in(cpp.pending_c_function_body)
						cpp.pending_c_function_body.append(once ", %"switch ")
						cpp.pending_c_function_body.append(feature_desc.current_type.name.to_string)
						cpp.pending_c_function_body.extend('.')
						cpp.pending_c_function_body.append(feature_desc.feature_name.name.to_string)
						cpp.pending_c_function_body.append(once "%");%N")
						count2 := count2 + 1
					end
					count1 := count1 + 1
				end
			end
		end

feature {C_PRETTY_PRINTER}
	c_define is
		local
			switches: SWITCH_TYPE; feature_desc: SWITCH_SITE; count1, count2, total: INTEGER; switch: SWITCH
		do
			echo.put_string(once "Late binding support (X* switch definition).%N")
			if not dictionary.is_empty then
				from
					count1 := 1
				until
					count1 > dictionary.count
				loop
					cpp.split_c_file_padding_here
					switches := dictionary.item(count1)
					from
						count2 := 1
					until
						count2 > switches.count
					loop
						feature_desc := switches.item(count2)
						switch.c_define(feature_desc)
						total := total + 1
						count2 := count2 + 1
					end
					count1 := count1 + 1
				end
			end
			echo.print_count(once "Defined Switche", total)
		end

feature {LIVE_TYPE}
	set_switch_for (lt: LIVE_TYPE; feature_stamp: FEATURE_STAMP; rf: RUN_FEATURE; fn: FEATURE_NAME; rt: TYPE
						 arg: FORMAL_ARG_LIST) is
			--|*** `rf' will be removed one day. *** (Dom june 9th 2004) ***
		require
			smart_eiffel.status.is_adapting
			rf.type_of_current = lt.type or else rf.type_of_current.inherits_from(lt.type)
			lt.run_time_set.count > 1
			rt = Void xor rf.result_type /= Void
		local
			switches: SWITCH_TYPE; feature_desc: SWITCH_SITE; run_time_set: RUN_TIME_SET
		do
			run_time_set := lt.run_time_set
			switches := dictionary.fast_reference_at(lt)
			if switches /= Void then
				feature_desc := switches.site(fn)
				if feature_desc = Void then
					create feature_desc.make(fn, lt.type, rt, arg)
					switches.add_site(feature_desc)
				else
					check
						feature_desc.current_type = lt.type
						feature_desc.result_type = rt
						feature_desc.arguments = arg
					end
				end
				feature_desc.add(rf)
			else
				create switches.make(lt)
				create feature_desc.make(fn, lt.type, rt, arg)
				switches.add_site(feature_desc)
				feature_desc.add(rf)
				dictionary.fast_put(switches, lt)
			end
			check
				dictionary.at(lt).site(fn).has(rf)
			end
		end

feature {JVM}
	jvm_define is
			-- Produce Java byte code for switches.
		local
			i, total: INTEGER
		do
			from
				i := 1
			until
				i > dictionary.count
			loop
				total := total + dictionary.item(i).jvm_define
				i := i + 1
			end
			echo.print_count(once "Defined Switche", total)
		end

feature {}
	dictionary: DICTIONARY[SWITCH_TYPE, LIVE_TYPE] is
			-- switching type
			-- -> name of the feature in the switching type
			--    -> [current type, result type, arguments, child run features]
		once
			create {HASHED_DICTIONARY[SWITCH_TYPE, LIVE_TYPE]} Result.with_capacity(1024)
		end

end -- class SWITCH_COLLECTION
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
