-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class CLASS_INVARIANT
	--
	-- To store a `class invariant'.
	--

inherit
	ASSERTION_LIST

insert
	ASSERTION_PRINT_TOOLS

creation {ANY}
	make

feature {ANY}
	compile_to_c (type: TYPE) is
		do
			compile_to_c_(type, True, False)
		end

	pretty is
		do
			if not pretty_printer.zen_mode then
				pretty_printer.skip_one_line
			end
			pretty_print_(0, once "invariant")
		end

	short (type: TYPE; bc: CLASS_TEXT; client: CLASS_NAME) is
			--|*** May be, bc is not useful anymore. (Dom jan 25th 2004) ***
		local
			i: INTEGER
		do
			bc.header_comment_for(Current)
			tmp_assertion_list.clear_count
			if list /= Void then
				from
					i := 0
				until
					i > list.upper
				loop
					if client = Void or else not hidden_expression_detector.visit(list.item(i), type, client, False) then
						tmp_assertion_list.add_last(list.item(i))
					end
					i := i + 1
				end
			end
			if header_comment /= Void or else not tmp_assertion_list.is_empty then
				short_printer.hook_or(once "hook811", once "invariant%N")
				if header_comment = Void then
					short_printer.hook_or(once "hook812", once "")
				else
					short_printer.hook_or(once "hook813", once "")
					header_comment.short(once "hook814", once "   --", once "hook815", once "%N")
					short_printer.hook_or(once "hook816", once "")
				end
				if tmp_assertion_list.is_empty then
					short_printer.hook_or(once "hook817", once "")
				else
					short_printer.hook_or(once "hook818", once "")
					from
						i := 0
					until
						i = tmp_assertion_list.upper
					loop
						tmp_assertion_list.item(i).short(type, once "hook819", once "   ", once "hook820" -- before each assertion
						, once "", once "hook821" -- no tag
						, once "", once "hook822" -- before tag
						, once ": ", once "hook823" -- after tag
						, once "", once "hook824" -- no expression
						, once "", once "hook825" -- before expression
						, once ";", once "hook826" -- after expression except last
						, once "%N", once "hook827" -- no comment
						, once "", once "hook828" -- before comment
						, once " --", once "hook829" -- comment begin line
						, once "%N", once "hook830" -- comment end of line
						, once "", once "hook831" -- after comment
						, once "")
						-- end of each assertion
						i := i + 1
					end
					tmp_assertion_list.item(i).short(type, once "hook819", once "   ", once "hook820" -- before each assertion
					, once "", once "hook821" -- no tag
					, once "", once "hook822" -- before tag
					, once ": ", once "hook823" -- after tag
					, once "", once "hook824" -- no expression
					, once "", once "hook832" -- before expression
					, once ";", once "hook826" -- after last expression
					, once "%N", once "hook827" -- no comment
					, once "", once "hook828" -- before comment
					, once " --", once "hook829" -- comment begin line
					, once "%N", once "hook830" -- comment end of line
					, once "", once "hook831" -- after comment
					, once "")
					short_printer.hook_or(once "hook833", once "")
				end
				short_printer.hook_or(once "hook834", once "")
			end
		end

	accept (visitor: CLASS_INVARIANT_VISITOR) is
		do
			visitor.visit_class_invariant(Current)
		end

feature {}
	check_assertion_mode: STRING is "inv"

feature {TYPE}
	add_parent_class_invariant (parent_invariant: like Current): like Current is
			-- Add `parent_invariant' to `Current' only if it is really new code (i.e. using `start_position' to
			-- decide.).
		require
			not start_position.is_unknown
			not parent_invariant.start_position.is_unknown
			--|*** Verifier que parent_invariant vient bien d'une classe au dessus ...
			-- faire pareil dans E_REQUIRE
		local
			l: like list; i: INTEGER; a: ASSERTION
		do
			Result := Current
			if start_position /= parent_invariant.start_position then
				l := parent_invariant.list
				if l /= Void then
					from
						i := l.lower
					until
						i > l.upper
					loop
						a := l.item(i)
						if not Current.has_assertion_located_at(a.start_position) then
							if Result = Current then
								Result := twin
								if list /= Void then
									Result.set_list(list.twin)
								end
							end
							if Result.list = Void then
								Result.set_list({FAST_ARRAY[ASSERTION] << a >> })
							else
								Result.list.add_last(a)
							end
						end
						i := i + 1
					end
				end
			end
		ensure
			Result.start_position = start_position
		end

feature {LIVE_TYPE}
	define_check_invariant_c_function (current_type: LIVE_TYPE) is
		require
			current_type /= Void
			current_type.at_run_time
			smart_eiffel.is_ready
		local
			id: INTEGER; profile: BOOLEAN
		do
			id := current_type.id
			profile := ace.profile -- The invariant frame descriptor :
			cpp.out_h_buffer.copy(once "se_frame_descriptor se_ifd")
			id.append_in(cpp.out_h_buffer)
			cpp.out_c_buffer.copy(once "{%"invariant ")
			cpp.out_c_buffer.append(current_type.name.to_string)
			cpp.out_c_buffer.append(once "%",1,0,%"")
			current_type.canonical_type_mark.c_frame_descriptor_in(cpp.out_c_buffer)
			cpp.out_c_buffer.append(once "%",1}")
			cpp.write_extern_2(cpp.out_h_buffer, cpp.out_c_buffer)
			-- The function itself:
			cpp.prepare_c_function
			cpp.pending_c_function_signature.extend('T')
			id.append_in(cpp.pending_c_function_signature)
			cpp.pending_c_function_signature.append(once "*se_i")
			id.append_in(cpp.pending_c_function_signature)
			cpp.pending_c_function_signature.append(once "(se_dump_stack*caller,")
			if profile then
				cpp.pending_c_function_signature.append(once "se_local_profile_t*parent_profile,")
			end
			cpp.pending_c_function_signature.extend('T')
			id.append_in(cpp.pending_c_function_signature)
			cpp.pending_c_function_signature.append(once "*C)")
			cpp.pending_c_function_body.append(once "se_dump_stack ds;%N")
			if profile then
				smart_eiffel.local_profile
			end
			cpp.pending_c_function_body.append(once "ds.fd=&se_ifd")
			id.append_in(cpp.pending_c_function_body)
			cpp.pending_c_function_body.append(once ";%Nds.current=((void*)&C);%N")
			cpp.put_position_in_ds(start_position)
			cpp.pending_c_function_body.append(once "ds.caller=caller;%Nds.exception_origin=NULL;%Nds.locals=NULL;%Nse_dst=&ds;/*link*/%N")
			if profile then
				smart_eiffel.start_profile_class_invariant(current_type)
			end
			compile_to_c(current_type.type)
			if profile then
				smart_eiffel.stop_profile
			end
			cpp.pending_c_function_body.append(once "se_dst=caller;/*unlink*/%Nreturn C;%N")
			cpp.dump_pending_c_function(True)
		end

end -- class CLASS_INVARIANT
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
