-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class NAME
	--
	-- Handling of all sort of names you can find in an Eiffel source file :
	--
	--   CLASS_NAME: a base class name.
	--   FEATURE_NAME: a feature name (not an EXPRESSION)
	--   WRITABLE_ATTRIBUTE_NAME: left-hand side or writable of create.
	--   LOCAL_ARGUMENT (deferred)
	--      LOCAL_NAME (deferred)
	--         LOCAL_NAME1: in a declaration list.
	--         LOCAL_NAME2: used in an expression.
	--      ARGUMENT_NAME (deferred)
	--         ARGUMENT_NAME1: in a declaration list.
	--         ARGUMENT_NAME2: used in an expression.
	--

inherit
	VISITABLE
insert
	GLOBALS

feature {ANY}
	extra_bracket_flag: BOOLEAN is False

	start_position: POSITION is
			-- The position of the first character of `to_string' in the text source.
		deferred
		end

	to_string: STRING is
			-- The corresponding name (alone in a STRING).
		deferred
		ensure
			not Result.is_empty
			string_aliaser.registered_one(Result)
		end

	frozen line: INTEGER is
		require
			not start_position.is_unknown
		do
			Result := start_position.line
		end

	frozen column: INTEGER is
		require
			not start_position.is_unknown
		do
			Result := start_position.column
		end

	pretty (indent_level: INTEGER) is
		deferred
		end

	frozen bracketed_pretty (indent_level: INTEGER) is
		do
			pretty(indent_level)
		end

end -- class NAME
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
