/***************************************************************************
    smb4kglobal_p  -  This is the private helper class of the Smb4KGlobal
    namespace.
                             -------------------
    begin                : Di Jul 24 2007
    copyright            : (C) 2007-2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// system includes
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

// application specific includes
#include "smb4kglobal_p.h"
#include "smb4kcoremessage.h"


Smb4KGlobalPrivate::Smb4KGlobalPrivate()
{
  m_temp_dir = QString();
}


Smb4KGlobalPrivate::~Smb4KGlobalPrivate()
{
  // Remove the temporary directory.
  rmdir( m_temp_dir.toLocal8Bit() );

  // Clear the workgroup list.
  while ( !workgroupsList.isEmpty() )
  {
    delete workgroupsList.takeFirst();
  }

  // Clear the host list.
  while ( !hostsList.isEmpty() )
  {
    delete hostsList.takeFirst();
  }

  // Clear the list of mounted shares.
  while ( !mountedSharesList.isEmpty() )
  {
    delete mountedSharesList.takeFirst();
  }
}


const QString &Smb4KGlobalPrivate::tempDir()
{
  if ( m_temp_dir.isEmpty() )
  {
    char tmpd_name[] = "/tmp/smb4k.XXXXXX";

    if ( mkdtemp( tmpd_name ) == NULL )
    {
      Smb4KCoreMessage::error( ERROR_CREATING_TEMP_DIR, tmpd_name, strerror( errno ) );

      return m_temp_dir /* is empty */;
    }

    m_temp_dir = QString( tmpd_name );
  }

  return m_temp_dir;
}
