/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimo.callegari@telsey.it                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SAMBROWSER_H
#define SAMBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <konqsidebarplugin.h>
#include <qstring.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qwidgetstack.h>
#include <kpopupmenu.h>
#include <ktoolbar.h>
#include <khtml_part.h>

#include "../smb4k/core/smb4kcore.h"
#include "../smb4k/widgets/smb4ksearchdialog.h"
#include "../smb4k/widgets/smb4kbrowseractionmenu.h"

class smb4kWidget : public QVBox
{
Q_OBJECT
public:
    smb4kWidget( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );

private:

};

class KonqSidebar_Smb4K : public KonqSidebarPlugin
{
    Q_OBJECT
public:
    /**
     * Construct a @ref KonqSidebarPlugin.
     *
     * @param inst The sidebar's kinstance class.
     * @param parent The sidebar internal button info class responsible for this plugin.
     * @param widgetParent The container which will contain the plugins widget.
     * @param desktopName The filename of the configuration file.
     * @param name A Qt object name for your plugin.
     **/
     KonqSidebar_Smb4K(KInstance *inst,QObject *parent,QWidget *widgetParent, QString &desktopName, const char* name=0);

    /** destructor */
    ~KonqSidebar_Smb4K();

    KListView *networkView() { return smb4kList; }
    Smb4KCore *core() { return m_core; }

    KHTMLPart* m_part;
    virtual QWidget *getWidget(){ return (QWidget*)widget;}
    virtual void *provides(const QString &) {return 0;}
    void emitStatusBarText (const QString &) {;}

private:
    KListView *smb4kList;
    /**
     * The KConfig object.
     */
    KConfig *m_config;
    /**
     * This value is TRUE, if the hidden shares are to be shown, otherwise
     * it is FALSE.
     */
    bool m_hidden;
    /**
     * This value is TRUE, if the IPC$ shares are to be shown, otherwise
     * it is FALSE.
     */
    bool m_ipc;
    /**
     * This value is TRUE, if the ADMIN$ shares are to be shown, otherwise
     * it is false.
     */
    bool m_admin;
    /**
     * This value is TRUE, if the printer shares are to be shown, otherwise
     * it is false.
     */
    bool m_printer;
    /**
     * Enumeration for the columns in the list view.
     */
    enum Columns{ Network = 0, Type = 1, IP = 2, Comment = 3 };
    /**
     * The core object.
     */
    Smb4KCore *m_core;
    /**
     * The search dialog instance.
     */
    Smb4KSearchDialog *m_search_dialog;
    /**
     * The action collection for the Konqueror plugin.
     */
    KActionCollection *m_collection;
    /**
     * Opens or closes an list view item.
     *
     * @param item          The list view item
     *
     * @param open          TRUE if item should be opened and FALSE otherwise.
     *
     * @param use_setOpen   TRUE if KListView::setOpen should be invoked and FALSE otherwise.
     */
    void setOpen( QListViewItem *item, bool open, bool use_setOpen );

protected:
     /**
      * The main plugin widget. Contains a klistview and a ktoolbox objects
      */
     smb4kWidget *widget;

     QString                currentKonquerorURL;

     /**
      * The action menu for the browser widget.
      */
     Smb4KBrowserActionMenu *m_menu;



    virtual void handleURL(const KURL &url);
protected slots:
    /**
     * This slot is activated when the run state of the core changed. It handles
     * the messages of the status bar and the enabling and disabling of the
     * Abort and other actions.
     */
    void slotCoreRunStateChanged();
    /**
     * Is called, when a list view item is to be mounted.
     */
    void slotItemExecuted( QListViewItem *item );
    /**
     * Is called whenever a QListViewItem is expanded or collapsed.
     */
    void slotItemExpandedCollapsed( QListViewItem *item );
    /**
     * Is called, when the selection in the list view is changed. (Is
     * connected to the selectionChanged() signal.
     */
    void slotSelectionChanged( QListViewItem *item );
    /**
     * This slot is invoked by the rightButtonPressed() signal.
     */
    void slotRightButtonPressed( QListViewItem *item, const QPoint &point, int col );
    /**
     * Takes the workgroups/masters list and puts it into the list
     * view.
     */
    void slotWorkgroups( const QValueList<Smb4KWorkgroupItem *> &list );
    /**
     * Takes a list of the members of a workgroup and inserts them into the
     * list view as children of the workgroup item.
     *
     * @param workgroup         The workgroup where the members are located
     *
     * @param list              The list of workgroup members
     */
    void slotMembers( const QString &workgroup, const QValueList<Smb4KHostItem *> &list );
    /**
     * Takes the shares of a queried host and inserts them as children of
     * the host item.
     *
     * @param host              The host where the shares are located
     *
     * @param list              The list of shares
     */
    void slotShares( const QString &host, const QValueList<Smb4KShareItem *> &list );
    /**
     * Mounts a share.
     */
    void slotMountShare();
    /**
     * Unmounts a share.
     */
    void slotUnmountShare();
    /**
     * Called from mounter when a share is mounted
     */
    void slotMountedShare( const QString & );
    /**
     * Takes an Smb4KHostItem, extracts the IP address of the host and adds
     * it to the appropriate item in the KListView.
     */
    void slotAddIPAddress( Smb4KHostItem *item );
    /**
     * This slot marks the mounted shares. It is called by the
     * Smb4KMounter::updated() signal.
     */
    void slotMarkShares();
    /**
     * Opens the askpass dialog.
     */
    void slotAskPass();
    /**
     * Opens the configuration dialog.
     */
    void slotSmb4KOptionsDlg();
    /**
     * Reads the smb4k configuration
     */
    void slotReadOptions();
    /**
     * This slot initializes a rescan of the network neighborhood.
     */
    void slotRescan();
    /**
     * This slot is connected to the activated() signal of the m_custom_action
     * KAction. It brings up the "Custom Options" dialog.
     */
    void slotCustomOptions();
    /**
     * This slot is connected to the clicked() signal of the topBar search button
     * It brings up the "Search" dialog.
     */
    void slotSearch();
signals:
    // see <konqsidebarplugin.h>
    void openURLRequest(const KURL &url,
                        const KParts::URLArgs &args = KParts::URLArgs());

};

#endif
