/***************************************************************************
    smb4kuser.h  -  This class provides a container for the user
    information that is read from /etc/passwd.
                             -------------------
    begin                : Mo Mr 1 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KUSER_H
#define SMB4KUSER_H

// Qt includes
#include <qstring.h>


/**
 * This class provides a container to store non-system users in.
 */

class Smb4KUser
{
  public:
    /**
     * The constructor
     */
    Smb4KUser( const int uid, const int gid );

    /**
     * The empty constructor.
     */
    Smb4KUser() {}

    /**
     * The destructor
     */
    ~Smb4KUser();

    /**
     * Returns the name of the user.
     */
    const QString &user() const { return m_user; }

    /**
     * Returns the group of the user.
     */
    const QString &group() const { return m_group; }
    /**
     * Returns the UID of the user.
     */
    int uid() const { return m_uid; }
    /**
     * Returns the GID of the user.
     */
    int gid() const { return m_gid; }

  private:
    /**
     * The name of the user.
     */
    QString m_user;
    /**
     * The group of the user.
     */
    QString m_group;
    /**
     * The UID of the user.
     */
    int m_uid;
    /**
     * The GID of the user.
     */
    int m_gid;
};

#endif
