/***************************************************************************
    smb4kpreviewdialog.h  -  description
                             -------------------
    begin                : Fre Jul 4 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPREVIEWDIALOG_H
#define SMB4KPREVIEWDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qvaluelist.h>

// KDE includes
#include <kdialogbase.h>
#include <kiconview.h>
#include <ktoolbar.h>
#include <kcombobox.h>

// application spcific includes
#include "../core/smb4knetworkitems.h"

/**
 * The share preview dialog of Smb4K.
 */

class Smb4KPreviewDialog : public KDialogBase
{
  Q_OBJECT

  friend class Smb4KApp;

  public:
    /**
     * This is the constructor of the preview dialog.
     *
     * @param item          The Smb4KShareItem object.
     *
     * @param parent        The parent of this widget
     *
     * @param name          The name of this widget
     */
    Smb4KPreviewDialog( Smb4KShareItem *item, QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KPreviewDialog();

    /**
     * This function returns TRUE if the preview dialog has been
     * initialized correctly and FALSE otherwise.
     *
     * @returns TRUE if the dialog was initialized correctly.
     */
    bool initialized() { return !m_share.isEmpty(); }

  protected slots:
    /**
     * Is called, when the dialog is finished.
     */
    void slotFinished();

    /**
     * Is called, if the scanner could compile the preview. The list
     * is filled with Smb4KPreviewItem objects.
     *
     * @param list        A list of Smb4KPreviewItem objects
     */
    void slotReceivedData( const QValueList<Smb4KPreviewItem *> &list );

    /**
     * Is called, if one icon view item is clicked.
     */
    void slotItemExecuted( QIconViewItem *item );

    /**
     * Is called, if a tool bar button is clicked.
     */
    void slotButtonClicked( int id );

    /**
     * Is called, if an item in the combo box is activated.
     */
    void slotItemActivated( const QString &item );

    /**
     * This slot is invoked when the user changes the icon size, etc. It is
     * connected to the signal KApplication::iconChanged().
     *
     * @param group       The icon group
     */
    void slotIconChanged( int group );

  private:
    /**
     * Enumeration for the buttons.
     */
    enum ButtonID{ Reload, Up, Back, Forward, Combo, None };

    /**
     * Set the tooltips.
     */
    void setTooltips();

    /**
     * Saves the options.
     */
    void saveOptions();

    /**
     * Reads the options.
     */
    void readOptions();

    /**
     * Sets up the file view.
     */
    void setupView();

    /**
     * The icon view.
     */
    KIconView *m_view;

    /**
     * The current path.
     */
    QString m_path;

    /**
     * The toolbar.
     */
    KToolBar *m_toolbar;

    /**
     * The combo box.
     */
    KComboBox *m_combo;

    /**
     * Holds the "address", i.e. the address of the share.
     */
    QString m_address;

    /**
     * The private Smb4KHostItem object
     */
    Smb4KShareItem *m_item;

    /**
     * The IP address
     */
    QString m_ip;

    /**
     * The name of the share. This is necessary because we
     * will deal with homes shares as well.
     */
    QString m_share;

    /**
     * This list holds the history of the session.
     */
    QStringList m_history;

    /**
     * This iterator points to the current item in the history.
     */
    QStringList::Iterator m_current_item;

    /**
     * The current button id
     */
    int m_button_id;
};
#endif
