/***************************************************************************
    smb4ksharesmenuwidget  -  description
                             -------------------
    begin                : Mi Mr 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qvaluelist.h>
#include <qobject.h>
#include <qobjectlist.h>

// KDE includes
#include <kpopupmenu.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kapplication.h>

// application specific includes
#include "smb4ksharesmenuwidget.h"
#include "smb4kshareactionmenu.h"
#include "../core/smb4kshare.h"
#include "../core/smb4kcore.h"
#include "../core/smb4kglobal.h"

using namespace Smb4KGlobal;

bool show_mountpoint_old = false;


Smb4KSharesMenuWidget::Smb4KSharesMenuWidget( QObject *parent, const char *name )
: KActionMenu( parent, name )
{
  m_collection = new KActionCollection( popupMenu(), "SharesMenu_ActionCollection", KGlobal::instance() );
  m_collection->setHighlightingEnabled( true );

  m_action = NULL;

  connect( smb4k_core->mounter(), SIGNAL( updated() ),
           this,                  SLOT( slotUpdatedShareList() ) );
  connect( m_collection,          SIGNAL( actionHighlighted( KAction * ) ),
           this,                  SLOT( slotActionHighlighted( KAction * ) ) );
}


Smb4KSharesMenuWidget::~Smb4KSharesMenuWidget()
{
  // Remove all actions from the action collection and all entries from the menu.
  QObjectList *object_list = popupMenu()->queryList( "Smb4KShareActionMenu" );
  QObjectListIt it( *object_list );
  QObject *object;

  while ( (object = it.current() ) != 0 )
  {
    ++it;

    ((Smb4KShareActionMenu *)object)->unplug( popupMenu() );
    delete object;
  }

  delete object_list;

  KActionPtrList action_list = m_collection->actions();

  for ( KActionPtrList::Iterator it = action_list.begin(); it != action_list.end(); ++it )
  {
    if ( *it )
    {
      m_collection->remove( *it );
    }
  }
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSharesMenuWidget::slotUpdatedShareList()
{
  config()->setGroup( "User Interface" );
  bool show_foreign = config()->readBoolEntry( "Show All Shares", false );
  bool show_mountpoint = config()->readBoolEntry( "Show Mount Point", false );

  QValueList<Smb4KShare *> shares_list = smb4k_core->mounter()->getShares();

  if ( shares_list.count() != 0 )
  {
    // Because we want to have the menu items ordered alphabethically,
    // we need the list of share names and the list of paths.
    QStringList shares_names, mountpoints;

    for ( QValueList<Smb4KShare *>::ConstIterator it = shares_list.begin(); it != shares_list.end(); ++it )
    {
      shares_names.append( (*it)->name() );
      mountpoints.append( (*it)->path() );
    }

    shares_names.sort();
    mountpoints.sort();

    QObjectList *object_list = popupMenu()->queryList( "Smb4KShareActionMenu" );
    QObjectListIt it( *object_list );
    QObject *object;

    while ( (object = it.current() ) != 0 )
    {
      ++it;

      QString mountpoint = QString( object->name() ).section( "[action_menu]_", 1, 1 ).stripWhiteSpace();

      if ( mountpoints.find( mountpoint ) == mountpoints.end() )
      {
        ((Smb4KShareActionMenu *)object)->unplug( popupMenu() );
        delete object;

        // Remove the actions from the action collection.
        KAction *action = NULL;

        if ( (action = m_collection->action( "[unmount]_"+mountpoint )) )
        {
          m_collection->remove( action );
        }

        if ( (action = m_collection->action( "[force]_"+mountpoint )) )
        {
          m_collection->remove( action );
        }

        if ( (action = m_collection->action( "[filemanager]_"+mountpoint )) )
        {
          m_collection->remove( action );
        }

        if ( (action = m_collection->action( "[sync]_"+mountpoint )) )
        {
          m_collection->remove( action );
        }

        delete action;

        continue;
      }
      else
      {
        Smb4KShare *share = smb4k_core->mounter()->findShareByPath( mountpoint );

        if ( !show_foreign && share->isForeign() )
        {
          ((Smb4KShareActionMenu *)object)->unplug( popupMenu() );
          delete object;

          // Remove the actions from the action collection.
          KAction *action = NULL;

          if ( (action = m_collection->action( "[unmount]_"+mountpoint )) )
          {
            m_collection->remove( action );
          }

          if ( (action = m_collection->action( "[force]_"+mountpoint )) )
          {
            m_collection->remove( action );
          }

          if ( (action = m_collection->action( "[filemanager]_"+mountpoint )) )
          {
            m_collection->remove( action );
          }

          if ( (action = m_collection->action( "[sync]_"+mountpoint )) )
          {
            m_collection->remove( action );
          }

          delete action;
        }

        if ( show_mountpoint && !show_mountpoint_old )
        {
          ((Smb4KShareActionMenu *)object)->setText( share->path() );
        }
        else if ( !show_mountpoint && show_mountpoint_old )
        {
          ((Smb4KShareActionMenu *)object)->setText( share->name() );
        }

        if ( share->isBroken() )
        {
          Smb4KShareActionMenu *menu = ((Smb4KShareActionMenu *)object);

          KIconLoader loader;
          menu->iconSet().reset( loader.loadIcon( "file_broken", KIcon::Small, 0, KIcon::DisabledState, 0L, false ), QIconSet::Automatic );

          for ( uint index = 0; index < popupMenu()->count(); index++ )
          {
            QString text = popupMenu()->text( popupMenu()->idAt( index ) );

            if ( QString::compare( text, menu->plainText() ) == 0 )
            {
              popupMenu()->changeItem( popupMenu()->idAt( index ), loader.loadIcon( "file_broken", KIcon::Small, 0, KIcon::DisabledState, 0L, false ), menu->plainText() );
            }
          }

          menu->filemanagerAction()->setEnabled( false );
          menu->syncAction()->setEnabled( false );
        }

        continue;
      }
    }

    delete object_list;

    // Now, put all new shares in the popup menu.
    for ( QValueList<Smb4KShare *>::ConstIterator it = shares_list.begin(); it != shares_list.end(); ++it )
    {
      if ( !popupMenu()->child( "[action_menu]_"+(*it)->path(), "Smb4KShareActionMenu" ) )
      {
        if ( !show_foreign && (*it)->isForeign() )
        {
          continue;
        }
        else
        {
          // Put the items in the popup menu.
          config()->setGroup( "Programs" );
          bool have_rsync = config()->readPathEntry( "rsync", QString::null ).isEmpty() ? false : true;

          QIconSet set;
          KIconLoader loader;

          if ( (*it)->isBroken() )
          {
            set.reset( loader.loadIcon( "file_broken", KIcon::Small, 0, KIcon::DisabledState, 0L, false ), QIconSet::Automatic );
          }
          else
          {
            set.reset( (*it)->isForeign() ? loader.loadIcon( "hdd_mount", KIcon::Small, 0, KIcon::DisabledState, 0L, false ) : SmallIcon( "hdd_mount" ), QIconSet::Automatic );
          }

          Smb4KShareActionMenu *menu = new Smb4KShareActionMenu( Smb4KShareActionMenu::SystemTray, m_collection, show_mountpoint ? (*it)->path() : (*it)->name(), set, popupMenu(), "[action_menu]_"+(*it)->path() );

          menu->unmountAction()->setName( "[unmount]_"+(*it)->path() );
          connect( menu->unmountAction(), SIGNAL( activated() ), this, SLOT( slotUnmount() ) );

#ifdef __linux__
          menu->forcedUnmountAction()->setName( "[force]_"+(*it)->path() );
          connect( menu->forcedUnmountAction(), SIGNAL( activated() ), this, SLOT( slotForceUnmount() ) );
#endif

          menu->filemanagerAction()->setName( "[filemanager]_"+(*it)->path() );
          menu->filemanagerAction()->setEnabled( !(*it)->isBroken() );
          connect( menu->filemanagerAction(), SIGNAL( activated() ), this, SLOT( slotFilemanager() ) );

          menu->syncAction()->setName( "[sync]_"+(*it)->path() );
          menu->syncAction()->setEnabled( (*it)->isBroken() ? false : have_rsync );
          connect( menu->syncAction(), SIGNAL( activated() ), this, SLOT( slotSynchronize() ) );

          menu->plug( popupMenu(), show_mountpoint ? mountpoints.findIndex( (*it)->path() ) : shares_names.findIndex( (*it)->name() ) );
        }
      }
    }
  }
  else
  {
    // Remove all actions from the action collection and all entries from the menu.
    QObjectList *object_list = popupMenu()->queryList( "Smb4KShareActionMenu" );
    QObjectListIt it( *object_list );
    QObject *object;

    while ( (object = it.current() ) != 0 )
    {
      ++it;

      ((Smb4KShareActionMenu *)object)->unplug( popupMenu() );
      delete object;
    }

    delete object_list;

    KActionPtrList action_list = m_collection->actions();

    for ( KActionPtrList::Iterator it = action_list.begin(); it != action_list.end(); ++it )
    {
      if ( *it )
      {
        m_collection->remove( *it );
      }
    }
  }

  show_mountpoint_old = show_mountpoint;
}



void Smb4KSharesMenuWidget::slotActionHighlighted( KAction *action )
{
  m_action = action;
}


void Smb4KSharesMenuWidget::slotUnmount()
{
  QString path = QString( m_action->name() ).section( "[unmount]_", 1, 1 ).stripWhiteSpace();

  Smb4KShare *share = smb4k_core->mounter()->findShareByPath( path );

  if ( share )
  {
    smb4k_core->mounter()->unmountShare( share, false, false );
  }
}


void Smb4KSharesMenuWidget::slotSynchronize()
{
  QString path = QString( m_action->name() ).section( "[sync]_", 1, 1 ).stripWhiteSpace();

  Smb4KShare *share = smb4k_core->mounter()->findShareByPath( path );

  if ( share )
  {
    smb4k_core->synchronizer()->synchronize( share,
                                             kapp->mainWidget() && kapp->mainWidget()->isShown() ?
                                             kapp->mainWidget() : 0 );
  }
}


void Smb4KSharesMenuWidget::slotForceUnmount()
{
  QString path = QString( m_action->name() ).section( "[force]_", 1, 1 ).stripWhiteSpace();

  Smb4KShare *share = smb4k_core->mounter()->findShareByPath( path );

  if ( share )
  {
    smb4k_core->mounter()->unmountShare( share, true, false );
  }
}


void Smb4KSharesMenuWidget::slotFilemanager()
{
  QString path = QString( m_action->name() ).section( "[filemanager]_", 1, 1 ).stripWhiteSpace();

  Smb4KShare *share = smb4k_core->mounter()->findShareByPath( path );

  if ( share )
  {
    smb4k_core->open( share );
  }
}


#include "smb4ksharesmenuwidget.moc"
