/***************************************************************************
                          smb4ksharetooltip  -  description
                             -------------------
    begin                : Fr Aug 19 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARETOOLTIP_H
#define SMB4KSHARETOOLTIP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qlabel.h>
#include <qlayout.h>
#include <qpoint.h>

class Smb4KShareWidgetItem;


/**
 * This class provides a tool tip that shows information about
 * a mounted share.
 *
 * @author Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */


class Smb4KShareTooltip : public QLabel
{
  Q_OBJECT

  public:
    /**
     * Constructor.
     *
     * @param item        The share about the info should be shown.
     *
     * @param pos         The *global* position where the tool tip should be shown.
     */
    Smb4KShareTooltip( Smb4KShareWidgetItem *item, const QPoint &pos );

    /**
     * Destructor.
     */
    ~Smb4KShareTooltip();

    /**
     * Refresh the information.
     */
    void refresh( Smb4KShareWidgetItem *item );

    /**
     * Show the tool tip.
     *
     * @param pos         The global position where the tool tip should be shown.
     */
    void showTip( const QPoint &pos );

    /**
     * This function return a pointer to the Smb4KShareWidgetItem for
     * which a tooltip should be shown.
     *
     * @returns           a pointer to a Smb4KShareWidgetItem object.
     */
    Smb4KShareWidgetItem *item() { return m_item; }

  protected:
    /**
     * Reimplemented from QLabel.
     */
    void mousePressEvent( QMouseEvent *e );

    /**
     * Reimplemented from QLabel.
     */
    void leaveEvent( QEvent *e );

  protected slots:
    /**
     * This slot hides (closes) the tool tip.
     */
    void slotHideTooltip();

  private:
    /**
     * The layout of the tool tip which is needed
     * to update information.
     */
    QGridLayout *m_layout;

    /**
     * The position where the tool tip should be displayed.
     */
    QPoint m_pos;

    /**
     * This is the Smb4KShareWidgetItem for which the tooltip
     * should be shown.
     */
    Smb4KShareWidgetItem *m_item;
};

#endif

