/*
       bookmarks.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-06-02
*/

#define _GNU_SOURCE

#include "dulist.h"
#include "headers.h"
#include "debug.h"
#include "rtypedef.h"
#include "bookmarks.h"
#include "format-string.h"

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

void RgotoFirstBookmark(TTbookmark **Rbk)
{
  if (*Rbk == NULL)
    return;
  else {
    while ((*Rbk)->previous != NULL)
      (*Rbk) = (*Rbk)->previous;
  }
}

void RgotoLastBookmark(TTbookmark **Rbk)
{
  if (*Rbk == NULL)
    return;
  else {
    while ((*Rbk)->next != NULL)
      (*Rbk) = (*Rbk)->next;
  }
}

int RgotoXBookmark(TTbookmark **Rbk, int Rnr)
{
  if (*Rbk == NULL)
    return(0);
  else {
    RgotoFirstBookmark(Rbk);
    while (((*Rbk)->next) && (Rnr-- > 0)) 
       (*Rbk) = (*Rbk)->next;
  }
  if (!Rnr)
    return(1);
  return(0); 
}

void RfreeBookmark(TTbookmark *Rbk)
{
  int RbkSize = sizeof(TTbookmark);
  TTbookmark *Rbkt;

  if (Rbk == NULL)
    return; 
  RgotoFirstBookmark(&Rbk);
  while (Rbk != NULL) {
    Rbkt = Rbk;
    Rbk = Rbk->next;
    realloc(Rbkt, RbkSize);
  }
}

int RfindInBookmark(TTbookmark **Rbk, int Riselect, char *Riagroup, char *Riahost, char *Riadir, char *Rifile, char *Riusername, char *Ripassword)
{
  TTbookmark *Rbkt = *Rbk;

  RgotoFirstBookmark(&Rbkt);
  while (Rbkt != NULL) {
    if (Rbkt->type == Riselect) {
      if (Riselect == 'R') {
        if ((RstrCmp(Rbkt->username, Riusername)) &&
            (RstrCmp(Rbkt->password, Ripassword)) &&
            (RstrCmp(Rbkt->group, Riagroup)) &&
            (RstrCmp(Rbkt->host, Riahost)) &&
            (RstrCmp(Rbkt->dir, Riadir)) &&
            (RstrCmp(Rbkt->file, Rifile))) {
           *Rbk = Rbkt;
           return(1);
        }
      }
      else {
        if ((RstrCmp(Rbkt->dir, Riadir)) &&
            (RstrCmp(Rbkt->file, Rifile))) {
           *Rbk = Rbkt;
           return(1);
        }
      }
    }
    Rbkt = Rbkt->next;
  }
  return(0);
}

void RaddToBookmark(TTbookmark **Rbk, int Riselect, char *Riagroup, char *Riahost, char *Riadir, char *Rifile, char *Riusername, char *Ripassword)
{
  if ((*Rbk) == NULL) {
    RDBG("bookmarks RaddToBookmark add first\n");
    *Rbk = malloc(sizeof(TTbookmark));
    (*Rbk)->previous = NULL;
  }
  else {
    RDBG("bookmarks RaddToBookmark add next\n");
    RgotoLastBookmark(Rbk);
    (*Rbk)->next = malloc(sizeof(TTbookmark));
    (*Rbk)->next->previous = (*Rbk);
    *Rbk = (*Rbk)->next;
  }
  (*Rbk)->next = NULL;
  (*Rbk)->type = Riselect;
  (*Rbk)->del = 'X';
  strcpy((*Rbk)->username, Riusername);
  strcpy((*Rbk)->password, Ripassword);
  strcpy((*Rbk)->group, Riagroup);
  strcpy((*Rbk)->host, Riahost);
  strcpy((*Rbk)->dir, Riadir);
  strcpy((*Rbk)->file, Rifile);
}

void RopenBookmark(TTbookmark **Rbk, char *RfileName)
{
  int Rfhandle;
  int RbkSize = sizeof(TTbookmark);
  TTbookmark Rbkt;

  RDBG("bookmarks RopenBookmark start\n");
  if (*Rbk != NULL)
    return;
 
  Rfhandle = open(RfileName, O_RDONLY, 0644);
  if (Rfhandle > 0) {
    RDBG("bookmarks RopenBookmark Rfhandle > 0\n");
    while (read(Rfhandle, &Rbkt, RbkSize) == RbkSize) {
      RDBG("bookmarks RopenBookmark readed 1\n");
      if (*Rbk) {
        (*Rbk)->next = malloc(RbkSize);
        memcpy((*Rbk)->next, &Rbkt, RbkSize);
        (*Rbk)->next->previous = (*Rbk);
        (*Rbk) = (*Rbk)->next;
      }
      else {
        (*Rbk) = malloc(RbkSize);
        memcpy(*Rbk, &Rbkt, RbkSize);
        (*Rbk)->previous = NULL;
      }
      (*Rbk)->next = NULL;
    }
    close(Rfhandle);
  }
  RDBG("bookmarks RopenBookmark end\n");
}

void RsaveBookmark(TTbookmark *Rbk, char *RfileName)
{
  int Rfhandle;
  int RbkSize = sizeof(TTbookmark);

  RDBG("bookmarks RsaveBookmark start\n");
  RgotoFirstBookmark(&Rbk);
  unlink(RfileName);
  Rfhandle = open(RfileName, O_CREAT | O_NONBLOCK | O_WRONLY | O_TRUNC, 0644);
  if (Rfhandle > 0) {
    RDBG("bookmarks RsaveBookmark Rfhandle > 0\n");
    while (Rbk) {
      if (Rbk->del == 'X') {
        if (write(Rfhandle, Rbk, RbkSize) != RbkSize) {
          printf(_("error saving bookmark list\n"));
          exit(0);
        }
      }
      RDBG("bookmarks RsaveBookmark written 1\n");
      Rbk = Rbk->next;
    }
    close(Rfhandle);
  }
  RDBG("bookmarks RsaveBookmark end\n");
}

unsigned int RgetBookmarkCount(TTbookmark *Rbk)
{
  unsigned int Ri = 1;

  RgotoFirstBookmark(&Rbk);
  if (Rbk == NULL)
    return(0);
  while (Rbk->next != NULL) {
    Ri++;
    Rbk = Rbk->next;
  }
  return(Ri);
}

