/*
       find-index-manage.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-03-10
*/
#define _GNU_SOURCE
#define READBF 1024

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include "headers.h"
#include "find-index-manage.h"
#include "format-string.h"
#include "debug.h"
#include "../config.h"

TTfind *TfindRecord = NULL;

int RmakeCopyFileWithPID(char *Rdst, char *Rsrc)
{
  int Rfdi, Rfdo;
  char Rdata[READBF];
  int Rread;

  RDBG("find-index-manage: RmakeCopyFile start\n");
  Rfdi = open(Rsrc, O_RDONLY);
  if (Rfdi <= 0) {
    RDBG("find-index-manage: can't open ");
    RDBG(Rsrc);
    RDBG(" file\n");
    return(0);
  }
  //asprintf(&RfileName, "/tmp/smbc_%i_%i",  getuid(), getpid());
  Rfdo = open(Rdst, O_CREAT | O_NONBLOCK | O_WRONLY | O_TRUNC, 0600);
  if (Rfdo <= 0) {
    if (Rfdi > 0)
      close(Rfdi);
    RDBG("find-index-manage: can't open ");
    RDBG(Rdst);
    RDBG(" file\n");
    return(0);
  }
  while ((Rread = read(Rfdi, &Rdata, READBF))) {
    write(Rfdo, &Rdata, Rread);
  }
  close(Rfdi);
  close(Rfdo);
  return(1);
}

int RindexFileUnlink(char *RpathToFile)
{
  int Ri;

  Ri = unlink(RpathToFile);
  return(1);
}

int RindexFileOpen(char *RpathToFile, int *RfileDesc)
{
  (*RfileDesc) = open(RpathToFile, O_RDONLY);
  if ((*RfileDesc) > 0) {
    RDBG("find-index-manage: RindexFileInit exit ok\n");
  }
  RDBG("find-index-manage: RindexFileInit exit fail\n");
  return(0);
}

void RindexFileClose(int *RfileDesc)
{
  if ((*RfileDesc) > 0)
    close(*RfileDesc);
  (*RfileDesc) = 0;
}

int RindexFileCreate(char *RpathToFile, int *RfileDesc)
{
  (*RfileDesc) = open(RpathToFile, O_CREAT | O_NONBLOCK | O_RDWR | O_TRUNC, 0600);
  if ((*RfileDesc) > 0)
    return(1);
  return(0);
}

int RindexFileReadOneRecord(int RfileDesc, TTfind *TfindRecord)
{
  char Rc;
  char Rstr[10240];
  int Ri = 0;
  char *IIgroup = NULL;
  char *IIhost = NULL;
  char *IIpath = NULL;

  //RDBG("find-index-manage: RindexFileReadOneRecord start\n");
  /*
  RDBG("find-index-manage: trying to read descriptor file nr ");
  RDBGi(RfileDesc);
  RDBG("\n");
  */
  //while (RDBGi(read(RfileDesc, &Rc, 1)) > 0) {
  while (read(RfileDesc, &Rc, 1) > 0) {
    //RDBG("find-index-manage: RindexFileReadOneRecord read one char: ");
    //RDBGc(Rc);
    //RDBG("\n");
    if (Rc)
      Rstr[Ri++] = Rc;
    else {
      Rstr[Ri] = 0;
      Ri = 0;
      if (IIgroup == NULL) asprintf(&IIgroup, "%s", Rstr);
      else if (IIhost == NULL) asprintf(&IIhost, "%s", Rstr);
           else if (IIpath == NULL) asprintf(&IIpath, "%s", Rstr);
                else {
                  memcpy(TfindRecord->group, IIgroup, strlen(IIgroup)+1);
                  memcpy(TfindRecord->host, IIhost, strlen(IIhost)+1);
                  memcpy(TfindRecord->dir, IIpath, strlen(IIpath)+1);
                  memcpy(TfindRecord->file, Rstr, strlen(Rstr)+1);
                  if (IIgroup) free(IIgroup);
                  if (IIhost) free(IIhost);
                  if (IIpath) free(IIpath);
                  //RDBG("find-index-manage: RindexFileReadOneRecord return success\n");
                  return(1);
                }
    }
  }
  if (IIgroup) free(IIgroup);
  if (IIhost) free(IIhost);
  if (IIpath) free(IIpath);
  //RDBG("\nfind-index-manage: RindexFileReadOneRecord return failed\n");
  return(0);
}

int RindexFileWriteOneRecord(int RfileDesc, TTfind *TfindRecord)
{
  int Ri;

  if (RfileDesc > 0) {
    Ri = strlen(TfindRecord->group)+1; 
    if (write(RfileDesc, TfindRecord->group, Ri) != Ri)
      return(0);
    Ri = strlen(TfindRecord->host)+1; 
    if (write(RfileDesc, TfindRecord->host, Ri) != Ri)
      return(0);
    Ri = strlen(TfindRecord->dir)+1; 
    if (write(RfileDesc, TfindRecord->dir, Ri) != Ri)
      return(0);
    Ri = strlen(TfindRecord->file)+1; 
    if (write(RfileDesc, TfindRecord->file, Ri) != Ri)
      return(0);
  }
  return(1);
}

int RindexFileSetSeek(int RfileDesc, long int Rnr)
{
  int Rt = 1;
  int Rcont = 1;
  off_t Rseek;
  TTfind TfindRecord;

  RDBG("find-index-manage: RindexFileSetSeek start, try set ");
  RDBGi(Rnr); RDBG("\n");
  Rseek = lseek(RfileDesc, 0, SEEK_SET);
  while (Rcont && (Rt < Rnr)) {
    if (!RindexFileReadOneRecord(RfileDesc, &TfindRecord))
      Rcont = 0;
    Rt++;
  }
  if (Rt == Rnr) 
    return(1);
  return(0);
}

int RindexFileGetCount(int RfileDesc)
{
  int Rt = 0;
  off_t Rseek;
  TTfind TfindRecord;
  
  RDBG("find-index-manage: RindexFileSetSeek start\n");

#ifdef HAVE_DEBUG
  Rseek = lseek(RfileDesc, 0, SEEK_CUR);
  RDBG("find-index-manage: RindexFileSetSeek current lseek ");
  RDBGi(Rseek);
  RDBG("\n");
#endif /* HAVE_DEBUG */

  Rseek = lseek(RfileDesc, 0, SEEK_SET);
  RDBG("find-index-manage: RindexFileSetSeek set lseek ");
  RDBGi(Rseek);
  RDBG("\n");
  while (RindexFileReadOneRecord(RfileDesc, &TfindRecord)) 
    Rt++;
  RDBG("find-index-manage: RindexFileSetSeek return ");
  RDBGi(Rt);
  RDBG(" records\n");
  return(Rt);
}

int RindexFileTruncate(int RfileDesc, long int Rnr)
{
  off_t Rseek;

  RDBG("find-index-manage: RindexFileTruncate start\n");
  if (!RindexFileSetSeek(RfileDesc, Rnr)) {
    RDBG("find-index-manage: RindexFileTruncate return failed\n");
    return(0);
  }
  Rseek = lseek(RfileDesc, 0, SEEK_CUR);
  if (ftruncate(RfileDesc, Rseek) == 0) {
    RDBG("find-index-manage: RindexFileTruncate return ok\n");
    return(1);
  }
  RDBG("find-index-manage: RindexFileTruncate return failed\n");
  return(0);
}

//--------------------------------------------------------------------------------

int RcreateNewRecordInIndexTable(TTindexTable **Ridx, int Rnr)
{
  RDBG("find-index-manage: RcreateNewRecordInIndexTable start, try mark "); 
  RDBGi(Rnr); RDBG(" record\n");
  if (*Ridx) {
    (*Ridx)->next = malloc(sizeof(TTindexTable));
    (*Ridx)->next->previous = (*Ridx);
    (*Ridx) = (*Ridx)->next;
  }
  else {
    (*Ridx) = malloc(sizeof(TTindexTable));
    (*Ridx)->previous = NULL;
  }
  (*Ridx)->next = NULL;
  (*Ridx)->number = Rnr;
  RDBG("find-index-manage: RcreateNewRecordInIndexTable finished\n");
  return(1);
}

int RfreeAllRecordFromIndexTable(TTindexTable **Ridx)
{
  TTindexTable *RidxTmp;

  if (!RgotoFirstIndexTable(Ridx))
    return(1);
  while (*Ridx) {
    RidxTmp = (*Ridx);
    (*Ridx) = (*Ridx)->next;
    free(RidxTmp);
  }
  return(1);
}

int RgotoFirstIndexTable(TTindexTable **Ridx)
{
  if (!(*Ridx))
    return(0);
  while ((*Ridx)->previous)
    (*Ridx) = (*Ridx)->previous;
  return(1);
}

int RgotoNIndextTable(TTindexTable **Ridx, int Rnr)
{
  RDBG("find-index-manage: RgotoNIndextTable start\n");
  if (Rnr < 1) {
    RDBG("find-index-manage: RgotoNIndextTable return failed : Rnr < 1\n");
    return(0);
  }
  if (!RgotoFirstIndexTable(Ridx)) {
    RDBG("find-index-manage: RgotoNIndextTable return failed : !RgotoFirstIndexTable(Ridx)\n");
    return(0);
  }
  if (RgetCountRecordIndexTable(*Ridx) < Rnr) {
    RDBG("find-index-manage: RgotoNIndextTable return failed : RgetCountRecordIndexTable(*Ridx) < Rnr\n");
    return(0);
  }
  while (--Rnr) {
    (*Ridx) = (*Ridx)->next;
  }
  RDBG("find-index-manage: RgotoNIndextTable return ok\n");
  return(1);
}

int RgetCountRecordIndexTable(TTindexTable *Ridx)
{
  int Rnr = 0;

  if (RgotoFirstIndexTable(&Ridx)) {
    while (Ridx) {
      Ridx = Ridx->next;
      Rnr++;
    }
  }
  return(Rnr);
}

int RgotoNextIndexTable(TTindexTable **Ridx)
{
  if (!(*Ridx))
    return(0);
  if (!(*Ridx)->next)
    return(0);
  (*Ridx) = (*Ridx)->next;
  return(1);
}

//--------------------------------------------------------------------------------

int RloadIndexFile(int Rfd, TTfind **RidxNet)
{
  TTfind Rfi;

  RDBG("find-index-manage: RloadIndexFile start\n");
  if (!RindexFileSetSeek(Rfd, 1)) {
    RDBG("find-index-manage: RloadIndexFile return failed\n");
    return(0);
  }
  while (RindexFileReadOneRecord(Rfd, &Rfi)) {
    if (*RidxNet) {
      (*RidxNet)->next = malloc(sizeof(TTfind));
      memcpy((*RidxNet)->next, &Rfi, sizeof(TTfind)); 
      (*RidxNet)->next->previous = (*RidxNet);
      *RidxNet = (*RidxNet)->next;
    }
    else {
      (*RidxNet) = malloc(sizeof(TTfind));
      memcpy((*RidxNet), &Rfi, sizeof(TTfind)); 
      (*RidxNet)->previous = NULL;
    }
    (*RidxNet)->next = NULL;
  }
  RDBG("find-index-manage: RloadIndexFile finished\n");
  return(1);
}

void RfreeIndexFile(TTfind **RidxNet)
{
  TTfind *Rtf;

  if (RindexNetSetSeek(RidxNet, 1)) {
    while (*RidxNet) {
      Rtf = (*RidxNet);
      (*RidxNet) = (*RidxNet)->next;
      free(Rtf);
    }
  }
}

int RindexNetSetSeek(TTfind **RidxNet, int Rnr)
{
  RDBG("find-index-manage: RindexNetSetSeek start\n");
  if (!(*RidxNet)) {
    RDBG("find-index-manage: RindexNetSetSeek return failed 1\n");
    return(0);
  }
  while ((*RidxNet)->previous) 
    (*RidxNet) = (*RidxNet)->previous;
  while (--Rnr > 0) {
    if ((*RidxNet)->next)
      (*RidxNet) = (*RidxNet)->next;
    else {
      RDBG("find-index-manage: RindexNetSetSeek return failed 2\n");
      return(0);
    }
  }
  RDBG("find-index-manage: RindexNetSetSeek return ok\n");
  return(1);
}

int RindexNetReadOneRecord(TTfind **RidxNet, TTfind *RidxNetDst)
{
  RDBG("find-index-manage: RindexNetReadOneRecord start\n");
  if (!(*RidxNet)) {
    RDBG("find-index-manage: RindexNetReadOneRecord return failed\n");
    return(0);
  }
  memcpy(RidxNetDst, (*RidxNet), sizeof(TTfind));
  (*RidxNet) = (*RidxNet)->next;
  RDBG("find-index-manage: RindexNetReadOneRecord return ok\n");
  return(1);
}

//------------------------------------------------

int RAddHostToHostsTable(TThostsTable **RhostsTable, char *Rstr)
{
  TThostsTable *RhostsTableTym;

  RDBG("find-index-manage: RAddHostToHostsTable start, try add ");
  RDBG(Rstr); RDBG("\n");
  if (!(*RhostsTable)) {
    (*RhostsTable) = malloc(sizeof(TThostsTable));
    RhostsTableTym = *RhostsTable;
  }
  else {
    RhostsTableTym = *RhostsTable;
    while (RhostsTableTym->next) 
      RhostsTableTym = RhostsTableTym->next;
    RhostsTableTym->next = malloc(sizeof(TThostsTable));
    RhostsTableTym = RhostsTableTym->next;
  }
  RhostsTableTym->next = NULL;
  RhostsTableTym->name = malloc(strlen(Rstr)+1);
  memcpy(RhostsTableTym->name, Rstr, strlen(Rstr)+1);
  RDBG("find-index-manage: RAddHostToHostsTable return\n");
  return(1);
}

int RFreeHostsTable(TThostsTable **RhostsTable)
{
   TThostsTable *RhostsTableTym;

   while (*RhostsTable) {
     RhostsTableTym = (*RhostsTable);
     (*RhostsTable) = (*RhostsTable)->next;
     free(RhostsTableTym->name);
     free(RhostsTableTym);
   }
   return(1);
}

int RFindHostInToHostsTable(TThostsTable *RhostsTable, char *Rstr)
{
  //RDBG("find-index-manage: RFindHostInToHostsTable start\n");
  while (RhostsTable) {
    //RDBG("find-index-manage: RFindHostInToHostsTable compare : ");
    //RDBG(RhostsTable->name); RDBG("  "); RDBG(Rstr); RDBG("\n");
    if (RstrCmp(RhostsTable->name, Rstr)) {
      //RDBG("find-index-manage: RFindHostInToHostsTable return 1\n");
      return(1);
    }
    else 
      RhostsTable = RhostsTable->next;
  }
  //RDBG("find-index-manage: RFindHostInToHostsTable return 0\n");
  return(0);
}

