/*
       fnet.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl

  last update: 2004-05-25
*/
// -------------------------------------------------------------------
#define _GNU_SOURCE
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include "fnet.h"
#include "inet.h"
#include "ierror.h"
#include "debug.h"
#include <libsmbclient.h>

#define MAXLINE 512
//static int smbc_compat_initialized = 0;
#ifdef SAMBA3XX
static SMBCCTX *statcont = NULL;
#endif

void reverse(char *str)
{
  int c, i, j;
  
  for (i=0, j=strlen(str)-1; i<j; i++, j--) {
    c = str[i];
    str[i] = str[j];
    str[j] = c;
  }
}

void itoa(char *str, int n)
{
  int i, sign;
  
  if ((sign = n) < 0)
     n=-n;
  i = 0;
  do {
    str[i++] = n % 10 + '0';
  } while (( n /= 10 ) > 0);
  if (sign < 0)
    str[i++] = '-';
  str[i] = '\0';
  reverse(str);  
}  

int readline(register int fd, register char *ptr, register int maxlen)
{
  int n, rc;
  char c;
  
  for (n = 1; n < maxlen; n++) {
    if ( (rc = read(fd, &c, 1)) == 1) {
      *ptr++ = c;
      if (c == '\n')
	break;
    } else if (rc == 0) {
      if (n == 1)
	return(0);
      else
	break;
    } else
      return(-1);
  }

  *ptr = 0;
  return(n);
}

int writen(register int fd, register char *ptr, register int nbytes)
{
  int nleft, nwritten;

  nleft = nbytes;
  while (nleft > 0) {
    nwritten = write(fd, ptr, nleft);
    if (nwritten <= 0)
      return(nwritten);
    
    nleft -= nwritten;
    ptr += nwritten;
  }
  return(nbytes - nleft);
}

void str_echo(int sockfd)
{
  int n;
  char line[MAXLINE];

  for (;;) {
    n = readline(sockfd, line, MAXLINE);
    if (n == 0)
      return;
    else if (n < 0)
      err_dump("str_echo: readline error");

    if (writen(sockfd, line, n) != n)
      err_dump("str_echo: writen error");
  }
}


int readlineii( int sockfd, char *buf, int size, int *linepos ) 
{
  int n;
  char c;
    
  while ( (n = read( sockfd, &c, 1)) == 1 )
    {
      buf[(*linepos)++] = c;

      if( c == '\n')
	{
	  buf[(*linepos)] = 0;
	  *linepos = 0;
	  return 1;
	}
    }
  if (!n)
    return -1;
  return(0);
}    

void refreshw(WINDOW *win, char *buf)
{
  werase(win);
  mvwprintw(win, 1, 1, buf);
}

int readlineie(WINDOW *win, char *buf, int size, int *linepos ) 
{
  int klawisz;
  //  char buft[MAXLINE], buftt[MAXLINE];

  nodelay(win, 1);
  klawisz = mvwgetch(win, 1, (*linepos)+1);

  if ((klawisz >='A' && klawisz <= 'Z') ||
      (klawisz >='a' && klawisz <= 'z') ||
      (klawisz >='0' && klawisz <= '9') ||
       klawisz == 234 || klawisz == 202 ||   // ,
       klawisz == 243 || klawisz == 211 ||   // ,
       klawisz == 177 || klawisz == 161 ||   // ,
       klawisz == 182 || klawisz == 166 ||   // ,
       klawisz == 179 || klawisz == 163 ||   // ,
       klawisz == 191 || klawisz == 175 ||   // ,
       klawisz == 188 || klawisz == 172 ||   // ,
       klawisz == 230 || klawisz == 198 ||   // ,
       klawisz == 241 || klawisz == 209 ||   // ,
      (klawisz == ' ' || klawisz == '/' || klawisz == '\\' || klawisz == '#')) {
    buf[(*linepos)++] = (char)klawisz;
    buf[*linepos] = '\0';
    refreshw(win, buf);
    return (0);
  }
  /*
  itoa(buftt, klawisz);
  strcpy(buft, buf);
  strcat(buft, "###");
  strcat(buft, buftt);
  mvwprintw(win, 1, 1, buftt);
  */
  switch(klawisz) {
  case 127: {
    if (*linepos) {
      buf[--(*linepos)] = '\0';
      refreshw(win, buf);
    }
    break;
  }
  case 10: {
    if (*linepos) {
      buf[(*linepos)++] = '\n';
      buf[*linepos] = '\0';
      *linepos = 0;
      werase(win);
      return(1);
    }
    else
      return(0);
  }
  }
  return(0);
}    

int readlineWait(WINDOW *win, int wy, int wx, char *buf, int sizebuf, int winSize, int colorPair) 
{
  int klawisz, tmp;
  int startidx = 0;
  int esc, Ri;
  int wxx = (strlen(buf) > winSize?winSize:strlen(buf));

  curs_set(1);
  keypad(win, TRUE);
  refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
  while ((klawisz = mvwgetch(win, wy, wx+wxx-startidx)) != 0) {
    //endwin(); printf(">%i|%i<\n", klawisz, KEY_LEFT); exit(0);
    esc = 1;
    switch(klawisz) {
      case 263: 
        if (strlen(buf) && wxx) {
           if (strlen(buf) == wxx) {
             buf[strlen(buf)-1] = '\0';
           }
           else {
             tmp = strlen(buf);
             for (Ri = 0; Ri < tmp-wxx; Ri++)
               buf[wxx+Ri] = buf[wxx+Ri+1]; 
           }
           if (startidx) { 
             startidx--;
             wxx--;
           } else wxx--;
           refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
        }
        esc = 0;
        break;
      case KEY_HOME:
        startidx = 0;
        wxx = 0;
        esc = 0;
        refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
        break;
      case KEY_END:
        startidx = (strlen(buf) < winSize?0:strlen(buf)-winSize+1);
        wxx = strlen(buf);
        esc = 0;
        refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
        break;
      case KEY_LEFT:
        if ((startidx) && (startidx == wxx)) {
           startidx--; wxx--;
        }
        else if (wxx) wxx--;
        refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
        esc = 0;
        break;
      case KEY_RIGHT:
        //mvwprintw(win, 0, 0, "**>%i<**", ); wrefresh(RwinMain);
        if (wxx < strlen(buf)) {
          if ((startidx+winSize <= strlen(buf)) && (startidx+winSize == wxx+1)) {
             startidx++; 
             if( wxx+1 < strlen(buf)) wxx++;
          }
          else {
            wxx++;
        //mvwprintw(win, 0, 0, "**>%i<**", wxx); wrefresh(win);
          }
          refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
          esc = 0;
        }
        break;
      case 10: 
      case 9: 
        curs_set(0);
        return(1);
    }
    RDBG("fnet.c readlineWait: klawisz = "); RDBGc(klawisz); RDBG(", esc = "); RDBGi(esc); RDBG(","); RDBGi(klawisz); RDBG("\n");
    if ((esc) && ((klawisz >='A' && klawisz <= 'Z') ||
        (klawisz >='a' && klawisz <= 'z') ||
        (klawisz >='0' && klawisz <= '9') ||
        (klawisz == ' ' || klawisz == '/' || klawisz == '-' ||
         klawisz == '\\' || klawisz == '#' || 
         klawisz == 234 || klawisz == 202 ||   // ,
         klawisz == 243 || klawisz == 211 ||   // ,
         klawisz == 177 || klawisz == 161 ||   // ,
         klawisz == 182 || klawisz == 166 ||   // ,
         klawisz == 179 || klawisz == 163 ||   // ,
         klawisz == 191 || klawisz == 175 ||   // ,
         klawisz == 188 || klawisz == 172 ||   // ,
         klawisz == 230 || klawisz == 198 ||   // ,
         klawisz == 241 || klawisz == 209 ||   // ,
         klawisz == '.' || klawisz == ',')) && 
        (strlen(buf)+1 < sizebuf)) {
        RDBG("fnet.c readlineWait: ok1\n");
      if (wxx == strlen(buf)) {
        buf[wxx] = (char)klawisz;
        buf[wxx+1] = 0;
      }
      else {
        tmp = strlen(buf);
        for (Ri = 0; Ri < tmp-wxx+1; Ri++)
          buf[tmp+1-Ri] = buf[tmp-Ri];
        buf[wxx] = (char)klawisz;
      }
      wxx++;
      if (startidx+winSize == wxx) startidx++;
      refreshTxtInWin(win,wy,wx,buf, winSize, startidx, colorPair, A_NORMAL, 0);
    }
  }
  return(0);
}    

int ssqr(int Rv, int Rpot)
{
  int Ri;
  int Rr = 1;
  for (Ri = 0; Ri < Rpot; Ri++) 
    Rr = Rv*Rr;
  return(Rr);
}

int strhextoi(char *str)
{
  int Ri;
  int Rm = strlen(str);
  int Rr = 0;
  char Rc;
  int Rci;

  for (Ri = 0; Ri < Rm; Ri++) {
    Rc = str[strlen(str)-Ri-1];
    switch (Rc) {
      case 'A' :
      case 'a' : Rci = 10; break;
      case 'B' :
      case 'b' : Rci = 11; break;
      case 'C' :
      case 'c' : Rci = 12; break;
      case 'D' : 
      case 'd' : Rci = 13; break;
      case 'E' :
      case 'e' : Rci = 14; break;
      case 'F' : 
      case 'f' : Rci = 15; break;
      default : Rci = Rc-48;
                if ((Rci < 0) | (Rci > 9)) return (-1);
    }
    Rr+= Rci*ssqr(16,Ri);
  }
  return(Rr);
}

void RmvwprintwCenter(WINDOW *win, int i, char *str)
{
  int y, x;

  getmaxyx(win, y, x);
  mvwprintw(win, i, x/2-strlen(str)/2, str);
  wrefresh(win);
}

void refreshTxtInWin(WINDOW *win, int y, int x, char *buf, int winSize, int startidx, int colorPair, int attr, int xDelta)
{
  char *str;

  str = strdup(buf);
  if (xDelta > winSize-1)
    xDelta = winSize-1;
  RDBG("fnet refreshTxtInWin xDelta = "); RDBGi(xDelta); RDBG(", winSize = "); RDBGi(winSize); RDBG(",   startidx = "); RDBGi(startidx); RDBG("\n");

  if (strlen(str+startidx) > winSize-1) str[startidx+winSize-1] = 0;
  if (colorPair != -1) wattron(win, COLOR_PAIR(colorPair));
  mvwhline(win, y, x+xDelta, ' ', winSize-xDelta);
  wattron(win, attr);
  mvwprintw(win, y, x+xDelta, str+startidx);
  wattroff(win, attr);
  if (colorPair != -1) wattroff(win, COLOR_PAIR(colorPair));
  free(str);
}

//  0 <= xCursor <= strlen(buf)
// startidx - start index for printing buf

void refreshTxtInWinCursor(WINDOW *win, int y, int x, char *buf, int winSize, int startidx, int colorPair, int xCursor, int RpassMode)
{
  char *Rstr;
  int Rprinted = 0;
  int Rstrl = strlen(buf);
  char *Rbuf;
  int Ri = 0;

  if (startidx > Rstrl)
    return;
  if ((xCursor < 0) || (xCursor > Rstrl))
    return;
  if (xCursor < startidx)
    return;

  Rbuf = strdup(buf);

  if (RpassMode) {
    while (Rbuf[Ri])
      Rbuf[Ri++] = '*';
  }

  RDBG("fnet refreshTxtInWinCursor xCursor = "); RDBGi(xCursor); RDBG(", Rstrl = "); RDBGi(Rstrl); 
  RDBG(", winSize = "); RDBGi(winSize); RDBG("\n");

  if (colorPair != -1) 
    wattron(win, COLOR_PAIR(colorPair));
  
  // clear line
  mvwhline(win, y, x, ' ', winSize); 

  // some string before cursor
  Rstr = strdup(Rbuf+startidx);
  Rstr[xCursor-startidx] = 0;
  RDBG("fnet refreshTxtInWinCursor 1: Rstr = \""); RDBG(Rstr); RDBG("\"\n");
  mvwprintw(win, y, x, Rstr);
  Rprinted = strlen(Rstr);
  free(Rstr);
   
  // char in curor position
  wattron(win, A_REVERSE);
  RDBG("fnet refreshTxtInWinCursor Rprinted = "); RDBGi(Rprinted); RDBG("\n");
  if (Rprinted < winSize-1) {
    if (Rprinted < Rstrl) {
      asprintf(&Rstr, "%c", Rbuf[xCursor]);
      RDBG("fnet refreshTxtInWinCursor 21\n");
    }
    else {
      asprintf(&Rstr, " ");
      RDBG("fnet refreshTxtInWinCursor 22\n");
    }
  }
  else {
    asprintf(&Rstr, " ");
    RDBG("fnet refreshTxtInWinCursor 23\n");
  }
  RDBG("fnet refreshTxtInWinCursor 29: Rstr = \""); RDBG(Rstr); RDBG("\"\n");
  mvwprintw(win, y, x+Rprinted, Rstr);
  free(Rstr);
  wattroff(win, A_REVERSE);
  Rprinted++;

  // some string after cursor

  if ((Rprinted < winSize-1) && 
      (Rprinted+startidx < Rstrl)) {
    Rstr = strdup(Rbuf+startidx+Rprinted);
    if (winSize-Rprinted < strlen(Rstr))
       Rstr[winSize-Rprinted] = 0;
    RDBG("fnet refreshTxtInWinCursor 3: Rstr = \""); RDBG(Rstr); RDBG("\"\n");
    mvwprintw(win, y, x+Rprinted, Rstr);
    free(Rstr);
  }

  if (colorPair != -1) 
    wattroff(win, COLOR_PAIR(colorPair));
  free(Rbuf);
}

int readlineWaitForOneChar(WINDOW *win, int wy, int wx, char *buf, int sizebuf, int winSize, int colorPair, int *ctrlp, int *startidx, int *wxx) 
{
  int Rfirst = 1;
  int Rt = 0;

  while (!(Rt = readlineOneCharNoDelay(win, wy, wx, buf, sizebuf, winSize, colorPair, ctrlp, 0, startidx, wxx, &Rfirst)))
  {}
  return(Rt);
}

// if first = 2 readlineOneCharNoDelay is in password mode
int readlineOneCharNoDelay(WINDOW *win, int wy, int wx, char *buf, int sizebuf, int winSize, int colorPair, int *ctrlp, int Rnodelay, int *startidx, int *wxx, int *first)
{
  int klawisz;
  int esc, Ri;
  int Rbufl;
  int RpassMode = 0;

  if (!Rnodelay)
    curs_set(1);
  
  keypad(win, TRUE);
  if (((*first) - 2) >= 0) {
    RpassMode = 1;
    (*first) = (*first) -2;
  }
  if (*first) {
    refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
    *first = 0;
  }
  if (RpassMode)
    (*first) = 2;

  while ((klawisz = mvwgetch(win, wy, wx+(*wxx)-(*startidx))) != 0) {
    //RDBG("fnet: readlineWaitForOneChar klawisz = "); RDBGi(klawisz); RDBG("\n");
    Rbufl = strlen(buf);
    esc = 1;
    switch(klawisz) {
      case 263: // backspace 
        if (Rbufl && (*wxx)) {
           if (Rbufl == *wxx) {
             buf[Rbufl-1] = '\0';
             Rbufl = strlen(buf);
           }
           else {
             for (Ri = 0; Ri < Rbufl-(*wxx); Ri++)
               buf[(*wxx)+Ri] = buf[(*wxx)+Ri+1]; 
               Rbufl = strlen(buf);
           }
           if (*startidx) { 
             (*startidx)--;
             (*wxx)--;
           } else (*wxx)--;
           refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
        }
        esc = 0;
        curs_set(0);
        return(0);
        break;
      case KEY_HOME:
        *startidx = 0;
        (*wxx) = 0;
        esc = 0;
        refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
        break;
      case KEY_END:
        *startidx = (strlen(buf) < winSize?0:strlen(buf)-winSize+1);
        (*wxx) = Rbufl;
        esc = 0;
        refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
        break;
      case KEY_LEFT:
        if ((*startidx) && (*startidx == *wxx)) {
           (*startidx)--; (*wxx)--;
        }
        else if (*wxx) (*wxx)--;
        refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
        esc = 0;
        break;
      case KEY_RIGHT:
        if ((*wxx) < Rbufl) {
          if (((*startidx)+winSize <= Rbufl) && ((*startidx)+winSize == (*wxx)+1)) {
             (*startidx)++; 
             if( (*wxx)+1 < Rbufl) (*wxx)++;
          }
          else {
            (*wxx)++;
          }
          refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
          esc = 0;
        }
        break;
      case 10:          // Enter
        curs_set(0);
        return(2);
      case 16:          // CTRL-p
        if (*ctrlp) (*ctrlp) = 0;
        else (*ctrlp) = 1;
        return(0);
      case 11:          // CTRL-k
        (*ctrlp) = 2;
        return(2);
      case 9:          // TAB
        curs_set(0);
        return(1);
    }
    //RDBG("fnet.c: klawisz = "); RDBGc(klawisz); RDBG("\n");
    if ((esc) && ((klawisz >='A' && klawisz <= 'Z') ||
        (klawisz >='a' && klawisz <= 'z') ||
        (klawisz >='0' && klawisz <= '9') ||
        (klawisz == ' ' || klawisz == '/' || 
         klawisz == '\\' || klawisz == '#' || 
         klawisz == 234 || klawisz == 202 ||   // ,
         klawisz == 243 || klawisz == 211 ||   // ,
         klawisz == 177 || klawisz == 161 ||   // ,
         klawisz == 182 || klawisz == 166 ||   // ,
         klawisz == 179 || klawisz == 163 ||   // ,
         klawisz == 191 || klawisz == 175 ||   // ,
         klawisz == 188 || klawisz == 172 ||   // ,
         klawisz == 230 || klawisz == 198 ||   // ,
         klawisz == 241 || klawisz == 209 ||   // ,
         klawisz == '.' || klawisz == ',')) && 
        (Rbufl+1 < sizebuf)) {
      if ((*wxx) == Rbufl) {
        buf[*wxx] = (char)klawisz;
        buf[(*wxx)+1] = 0;
      }
      else {
        for (Ri = 0; Ri < Rbufl-(*wxx)+1; Ri++)
          buf[Rbufl+1-Ri] = buf[Rbufl-Ri];
        buf[(*wxx)] = (char)klawisz;
      }
      (*wxx)++;

      if ((*startidx)+winSize == (*wxx)) 
        (*startidx)++;

      RDBG("fnetc: readlineOneCharNoDelay startidx = "); RDBGi(*startidx); RDBG(", winSize = "); RDBGi(winSize); RDBG(", wxx = "); RDBGi(*wxx); RDBG("\n");

      refreshTxtInWinCursor(win,wy,wx,buf, winSize, *startidx, colorPair, *wxx, RpassMode);
      RDBG("fnet readlineOneCharNoDelay exit 10\n");
      return(0);
    }
    if (Rnodelay)
      return(-1);
  }
  return(0);
}    

void RstrToUpper(char *str)
{
  int i;
  int k = strlen(str);

  for (i = 0; i < k; i++)
    str[i] = toupper(str[i]);
}

void RstrToUpperCopy(char *Dstr, char *Sstr)
{
  memcpy(Dstr, Sstr, strlen(Sstr)+1);
  RstrToUpper(Dstr);
}

void RgetFileFromTwoDirs(char **RfileName, char *RdirBig, char *RdirSmall)
{
  char *Rstr;
  int Rlen, RlB, RlS, Rlo;
  int Rs = 0;

  RDBG("fnet: RgetFileFromTwoDirs start: RdirBig = "); RDBG(RdirBig); 
  RDBG("     RdirSmall = "); RDBG(RdirSmall); RDBG("\n");
  RlB = strlen(RdirBig);
  RlS = strlen(RdirSmall);
  if ((RdirBig != NULL) &&
      (RdirSmall != NULL) &&
      (RlB > RlS)) {
    Rlen = RlB - RlS + 1;
    Rstr = malloc(Rlen);
    memcpy(Rstr, RdirBig+RlS, Rlen);
    if (Rstr[0] == '/') Rs = 1;
    if (Rstr[Rlen-2] == '/') Rstr[Rlen-2] = 0;
    Rlo = strlen(Rstr+Rs)+1;
    *RfileName = malloc(Rlo);
    memcpy(*RfileName, Rstr+Rs, Rlo);
    RDBG("fnet: RgetFileFromTwoDirs return : "); RDBG(*RfileName); RDBG("\n");
  }
  else
    *RfileName = NULL;
}

