/*
       format-string.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-03-08
*/
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include "format-string.h"
#include "debug.h"

char *RfsStr;
int RfsStrLen;
int RChange; 

/*   0 - ASCII
     1 - UTF8
*/
int RtSource;
int RtDestination;

unsigned char RUTF_8toISO8859_2[] = 
 { 
   0xc4, 0x85, 0xb1,   // 
   0xc4, 0x84, 0xa1,   // 
   0xc4, 0x87, 0xe6,   // 
   0xc4, 0x86, 0xc6,   // 
   0xc4, 0x99, 0xea,   // 
   0xc4, 0x98, 0xca,   // 
   0xc3, 0xb3, 0xf3,   // 
   0xc3, 0x93, 0xd3,   // 
   0xc5, 0x9b, 0xb6,   // 
   0xc5, 0x9a, 0xa6,   // 
   0xc5, 0x82, 0xb3,   // 
   0xc5, 0x81, 0xa3,   // 
   0xc5, 0xbc, 0xbf,   // 
   0xc5, 0xbb, 0xaf,   // 
   0xc5, 0xba, 0xbc,   // 
   0xc5, 0xb9, 0xac,   // 
   0xc5, 0x84, 0xf1,   // 
   0xc5, 0x83, 0xd1,   // 
   0x00
 };

unsigned char RISO8859_2[] = 
 { 
   0xb1,   // 
   0xa1,   // 
   0xe6,   // 
   0xc6,   // 
   0xea,   // 
   0xca,   // 
   0xf3,   // 
   0xd3,   // 
   0xb6,   // 
   0xa6,   // 
   0xb3,   // 
   0xa3,   // 
   0xbf,   // 
   0xaf,   // 
   0xbc,   // 
   0xac,   // 
   0xf1,   // 
   0xd1,   // 
   0x00
 };

void RFSinit(int Rit)  // Rit = 1 - change
{
  RfsStr = NULL;
  RfsStrLen = 0;
  RChange = Rit;
}

void RFStype(int RdestType, int RsrcType)
{
  RtDestination = RdestType;
  RtSource = RsrcType;
}

int RtranslateOneCharFromUTFtoISO8859_2(char *Rds, int *RdsL, char *Rsr, int *RsrL)
{
  int Ri = 0;
  char Rtr = 1;
  int RstrLen = strlen(Rsr);
  int Rchange = 0;

  if ((*RsrL) > strlen(Rsr)) {
    RDBG("format-string.c: RsrL > strlen(Rstr)\n");
    return(0);
  }

  if (((unsigned char)Rsr[*RsrL] >= 0x01) && 
      ((unsigned char)Rsr[*RsrL] <= 0x7f)) {         // U-00000000 - U-0000007F
    Rds[(*RdsL)++] = Rsr[(*RsrL)++]; 
    Rchange = 1;
    //RDBG(">translateFromUTFtoISO8859_2< >2");
  } 
  else 
  if (((*RsrL)+1 <= RstrLen) && 
        ((unsigned char)Rsr[*RsrL] >= 0xc0) && 
        ((unsigned char)Rsr[*RsrL] <= 0xdf)) {       // U-00000080 - U-000007FF
      //RDBG(">translateFromUTFtoISO8859_2< >4");
      while (Rtr) {
        if (RUTF_8toISO8859_2[Ri] == 0x00) {
          (*RsrL) = (*RsrL)+3;
          Rtr = 0;
        }
        else {
          if ((RUTF_8toISO8859_2[Ri++] == (unsigned char)Rsr[*RsrL]) &&
              (RUTF_8toISO8859_2[Ri++] == (unsigned char)Rsr[(*RsrL)+1])) {
            //RDBG(">translateFromUTFtoISO8859_2< >5");
            Rds[(*RdsL)++] = RUTF_8toISO8859_2[Ri];
            (*RsrL) = (*RsrL)+2;
            Rtr = 0;
            Rchange = 1;
          }
          else 
            Ri++;
        }
      }
  }
  else 
    (*RsrL)++;
  return(Rchange);
}

int RtranslateOneCharFromISO8859_2toISO8859_2(char *Rds, int *RdsL, char *Rsr, int *RsrL)
{
  int Ri = 0;
  char Rtr = 1;
  int RstrLen = strlen(Rsr);
  int Rchange = 0;

  //RDBG("format-string.c: RtranslateOneCharFromISO8859_2toISO8859_2 start\n");
  if ((*RsrL) > strlen(Rsr)) {
    RDBG("format-string.c: RsrL > strlen(Rstr)\n");
    return(0);
  }

  if ((*RsrL)+1 <= RstrLen) {
    while (Rtr) {
      if (RISO8859_2[Ri] == 0x00) {
        (*RsrL)++;
        Rtr = 0;
      }
      else {
        //RDBG("format-string.c: RtranslateOneCharFromISO8859_2toISO8859_2 RISO8859_2[Ri++] = "); RDBGc(RISO8859_2[Ri]); RDBGc((unsigned char)Rsr[*RsrL]); RDBG("\n");
        if (RISO8859_2[Ri] == (unsigned char)Rsr[*RsrL]) {
          //RDBG("format-string.c: RtranslateOneCharFromISO8859_2toISO8859_2 ok\n");
          Rds[(*RdsL)++] = RISO8859_2[Ri];
          (*RsrL)++;
          Rtr = 0;
          Rchange = 1;
        }
        else 
           Ri++;
      }
    }
  }
  else 
    (*RsrL)++;
  return(Rchange);
}

char *RFS(char *Rstr)
{
  char *RstrT;
  int Ri;
  int RstrTlen = 0;
  int RstrL = strlen(Rstr)+1;

  //RDBG("format-string.c: RFS function start\n");

  RFSfree();
  //RDBG("format-string.c: RFS after RFSfree\n");
  if (RChange) {
    RstrT = malloc(RstrL+1);
    switch(RtSource) {
      case 0:
        switch(RtDestination) {
          case 0:
            Ri = 0;
            while (Ri < RstrL-1) {
              if (!RtranslateOneCharFromUTFtoISO8859_2(RstrT, &RstrTlen, Rstr, &Ri)) {
                Ri--;
                RtranslateOneCharFromISO8859_2toISO8859_2(RstrT, &RstrTlen, Rstr, &Ri);
              }
            }
          break;
        }
        break;
    }
    RstrT[RstrTlen++] = 0;
    RfsStr = malloc(RstrTlen);
    RfsStrLen = RstrTlen;
    memcpy(RfsStr, RstrT, RstrTlen);
    realloc(RstrT, RstrL+1);
    //RDBG("format-string.c: RFS !!! 8 !!!\n");
  }
  else {
    RfsStr = malloc(RstrL); 
    memcpy(RfsStr, Rstr, RstrL);
    RfsStrLen = RstrL;
  }
  //RDBG("format-string.c: RFS function stop\n");
  return(RfsStr);
}

void RFSfree()
{
  if (RfsStrLen) {
    realloc(RfsStr, RfsStrLen);
    RfsStr = NULL;
    RfsStrLen = 0;
  } 
}

int RstrCmp(const char *src, const char *dst)
{
  int RsrcL, RsrcD, Ri;
  RsrcL = strlen(src);
  RsrcD = strlen(dst);
  if (RsrcL != RsrcD) return 0;
  for (Ri =0; Ri<RsrcL; Ri++) { 
    if (src[Ri] != dst[Ri]) return 0;
  } 
  return 1;
}

