/*
       smb-pack.c
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
  
    last update: 2004-01-25
*/

#include "smb-pack.h"
#include "headers.h"
#include "debug.h"

#ifdef HAVE_SMBCCTX

#ifdef HAVE_SET_CONTEXT
SMBCCTX * Rsmbc_set_context(SMBCCTX * new_context)
{
  SMBCCTX *Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_set_context(new_context);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}
#endif /* HAVE_SET_CONTEXT */

int Rsmbc_free_context(SMBCCTX * context, int shutdown_ctx)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_free_context(context, shutdown_ctx);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

SMBCCTX * Rsmbc_init_context(SMBCCTX * context)
{
  SMBCCTX *Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_init_context(context);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

SMBCCTX * Rsmbc_new_context(void)
{
  SMBCCTX *Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_new_context();

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}
#endif

int Rsmbc_init(smbc_get_auth_data_fn fn, int debug)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_init(fn, debug);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_rmdir(const char *durl)
{
  ssize_t Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_rmdir(durl);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

ssize_t Rsmbc_write(int fd, void *buf, size_t bufsize)
{
  ssize_t Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_write(fd, buf, bufsize);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_unlink(const char *furl)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_unlink(furl);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

ssize_t Rsmbc_read(int fd, void *buf, size_t bufsize)
{
  ssize_t Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_read(fd, buf, bufsize);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

off_t Rsmbc_lseek(int fd, off_t offset, int whence)
{
  off_t Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_lseek(fd, offset, whence);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_mkdir(const char *durl, mode_t mode)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_mkdir(durl, mode);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}


int Rsmbc_fstat(int fd, struct stat *st)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_fstat(fd, st);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_open(const char *furl, int flags, mode_t mode)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_open(furl, flags, mode);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_closedir(int Rfd)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_closedir(Rfd);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_close(int Rfd)
{
  int Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_close(Rfd);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

int Rsmbc_opendir(char *Rstr)
{
  int Rfd;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RDBG("smb-pack: Rsmbc_opendir start\n");
  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);
  RDBG("smb-pack: Rsmbc_opendir !!! 1 !!!\n");

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     RDBG("smb-pack: Rsmbc_opendir !!! 2 !!!\n");
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  RDBG("smb-pack: Rsmbc_opendir !!! 5 !!!\n");
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  RDBG("smb-pack: Rsmbc_opendir !!! 7 !!! try open >"); 
  RDBG(Rstr); RDBG("< = "); RDBGi(strlen(Rstr)); RDBG(" chars\n");

  Rfd = smbc_opendir(Rstr);

  RDBG("smb-pack: Rsmbc_opendir !!! 8 !!!\n");
  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  RDBG("smb-pack: Rsmbc_opendir !!! 9 !!!\n");
  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  RDBG("smb-pack: Rsmbc_opendir return\n");
  return(Rfd);
}

struct smbc_dirent *Rsmbc_readdir(int Rfd)
{
  struct smbc_dirent *Rre;
  int RfdNull;
  int RfdOut;
  int RfdErr;

  RfdErr = dup(STDERR_FILENO);
  RfdOut = dup(STDOUT_FILENO);

  if ((RfdNull = open("/dev/null", O_WRONLY)) < 0) {
     endwin();
     printf("Can't open /dev/null\n");
     exit(0);
  };
  dup2(RfdNull, STDERR_FILENO);
  dup2(RfdNull, STDOUT_FILENO);

  Rre = smbc_readdir(Rfd);

  dup2(RfdErr, STDERR_FILENO);
  dup2(RfdOut, STDOUT_FILENO);

  close(RfdErr);
  close(RfdOut);

  close(RfdNull);
  return(Rre);
}

