/*
       Simple Samba Commander 
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://www.air.rzeszow.pl/smbc
*/
// -------------------------------------------------------------------
// if you have other GUEST accunt change this line
#define RGUEST "guest"
// -------------------------------------------------------------------
#define _GNU_SOURCE

#define NO_SYSLOG
#define MAX_DEBUG_LEVEL 0

#include "../config.h"
#include "headers.h"
#include "fnet.h"
#include "smb-pack.h"
#include "format-string.h"
#include "find-index-manage.h"
#include "debug.h"
#include "dulist.h"
#include "rtypedef.h"
#include "winpopup.h"
#include "bookmarks.h"

#define RMAXGROUPS 1000
#define RMAXHOSTS 1000
#define RMAXLIST 1000
#define RTFILE 0
#define RTDIR 1

typedef enum {
  RLLOCAL =  0, 
  RLREMOTE = 1
} RLTYPE;

#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

WINDOW *RwinMain, *RwinLeft, *RwinRight, *RwinHead, *RwinStatus;
WINDOW *RwinLeftList, *RwinRightList, *RwinLeftHead, *RwinRightHead;
WINDOW *RwinLeftTop, *RwinRightTop;
WINDOW *RwinLeftCol1, *RwinLeftCol2, *RwinLeftCol3;
WINDOW *RwinRightCol1, *RwinRightCol2, *RwinRightCol3;
WINDOW *RwinLeftHeadCol1, *RwinLeftHeadCol2, *RwinLeftHeadCol3;
WINDOW *RwinRightHeadCol1, *RwinRightHeadCol2, *RwinRightHeadCol3;

char Ragroup[RMAXGHLEN];
char Rahost[RMAXGHLEN];
char Radir[RMAXDIRLEN];
char RadirTmp[RMAXDIRLEN];
char RadirL[RMAXDIRLEN];
char RadirLtmp[RMAXDIRLEN];
char RadirOld[RMAXDIRLEN];
char *RfileNamePos;
char Rusername[RMAXGHLEN];
char Rpassword[RMAXGHLEN];
char Rsmbclient[RMAXPATHTOSMBCLIENT];

typedef struct Tgroups {
  char groupname[RMAXGHLEN];
  char mastername[RMAXGHLEN];
  char masterip[16];
} TTgroups;

typedef struct Thosts {
  char hostname[RMAXGHLEN];
  char comment[RMAXGHLEN];
  char ip[16];
} TThosts;

typedef struct Tshares {
  char sharename[RMAXGHLEN];
  char comment[RMAXGHLEN];
} TTshares;

typedef struct Tfiles {
  char filename[RMAXGHLEN];
  int type;     
  char sizeShow[10];
  int size;
} TTfiles;

typedef struct Tlist {
  char col1[200];
  char col2[200];
  char col3[200];
  char col4[200];
  unsigned char select;
  int size;
} TTlist;

typedef struct Tcolor {
  short red;
  short green;
  short blue;
  char realnumber;
} TTcolor;

typedef struct Text {
  char ext[11];
  int colornr;
  struct Text *Text;
} TText;

typedef struct Tposition {
  int Pos;
  int First;
  struct Tposition *Tposition;
} TTposition;

int Ry, Rx, Rdx;
int RgroupsCount = -1;
int RhostsCount = -1;
int RsharesCount = -1;
int RfilesCount = -1;
int RfilesCountL = -1;
int RgrpAct;
int RhostAct;
int RshareAct;
int RfilesAct;
int RlistLeftPos, RlistRightPos;
int RlistLeftMax = -1;
int RlistRightMax = -1;
int RxHalf;
int RleftPos = 0;
int RrightPos = 0;
int RleftFirst = 0;
int RrightFirst = 0;
RLTYPE Rselected = RLREMOTE;
int RremoteLevel = 0;
int RdownloadHandleR = -1;
int RdownloadHandleL = -1;
#ifdef HAVE_SMBCCTX
SMBCCTX *Rstatcont = NULL;
#endif
int Rtimeout = 3000;
time_t RavrTime = 0;
unsigned int RavrSize = 0;
unsigned int RavrSizeDisplay = 0;
long int RtimeR = 0;
int RindexFileFd = 0;
char *RfileNameForFindList;
char *RfileNameForFindListPrim;
char *RfileNameMessage;
char *RfileNameMessagePrim;
int RindexTime = 300;
int RchildId = 0;
int RlockFile = 0;
int RlockFileFlag = 0;
int RstatusBarStatus = 1;
time_t RlastTimeFileMessage = 1;
int RaskRetry = 1;
int RaskRetryDiskFull = 1;
int RrunFirst = 1;
char *RsmbcLockFile;
int RcancelFinding = 0;
int RdoResize = 0;
int RdoResizeFind = 0;
int RdoResizeDownload = 0;
int RdoResizeBookmark = 0;
int RDoCharConvert = 0;
char RdontDownload = 0;
int Raskquit = 1;

int RsortReverseR = 0;  
int RgroupFilesDirectoriesR = 1;
int RsortMethodR = 1;   // 1 - name
                       // 2 - ext
                       // 3 - size

int RsortReverseL = 0;  
int RgroupFilesDirectoriesL = 1;
int RsortMethodL = 1;   // 1 - name
                       // 2 - ext
                       // 3 - size

TTgroups *Rgroups[RMAXGROUPS];
TThosts *Rhosts[RMAXHOSTS];
TTshares *Rshares[RMAXHOSTS];
TTfiles *Rfiles[RMAXHOSTS];
TTfiles *RfilesL[RMAXHOSTS];
TTlist *RlistLeft[RMAXLIST];
TTlist *RlistRight[RMAXLIST];
TTdownload *RdownloadList = NULL;
//int RdownloadListAct = -1;
TTdownload *RdownloadListAct = NULL;
TTcolor Rcolor[3];
TText *Rext = NULL; 
TTposition *RpositionLeft = NULL;
TTposition *RpositionRight = NULL;

void RwinRedraw();
void RwriteMenuTxt(int Rfirst, int Rwhat, RLTYPE Rcol, int Rselect);
void RstatusBar(int Rnr);
void RopenSaveDowloadList(int Rnr);
void RcreateFindListIndex(int Isave, char *Igroup, char *Ihost, char *Ipath, char *Idir, WINDOW *RwinI, int RfileFd);
void RdoWindowResize();
void RwinRedrawWithData();
void RcompareTwoIndexFile(int RfdNew, int RfdOld, int RfdMessage);
void RtryDownloadUpload();

//-------------------------------------------------------------
int RdetectScreenToSmall()
{
  int Rys, Rxs;
  WINDOW *RwinMsg;

  if ((Rx < 80) || (Ry < 25)) {
     Rys = 4; Rxs = 30;
     RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
     RmvwprintwCenter(RwinMsg, 1, _("Please change screen"));
     RmvwprintwCenter(RwinMsg, 2, _("size to minimum 80x25"));
     box(RwinMsg,0,0);
     wrefresh(RwinMsg);
     keypad(RwinMsg, TRUE);  
     wgetch(RwinMsg);
     delwin(RwinMsg);
     return(1);
  }
  return(0);
}

int RshowMessage(int RnrMsg, int Rselect, char *Rmsg, char *Rmsg2, TTdownload *RTd)
{
  int Rii, Rys, Rxs;
  WINDOW *RwinMsg;
  WINDOW *RwinMsg2;
  char RmsgTmp[1000];
  int Rt1, Rt2, Rkey;
  char Rmsg1[20];
  char *Rmsg22 = _("[ OK ]");
  char *Rmsg23 = _(" is empty.");
  char *Rmsg24 = _("[ Cancel ]");
  char *Rmsg25 = _("[ Retry ]");
  char *Rmsg26 = _("[ Wait ]");
  char *Rmsg27 = _("[ Overwrite ]");
  char *Rmsg28 = _("[ Retry without asking ]");
  char *Rmsg29 = _("[ Delete ]");
  
  char *Rmsg40 = _("Download list is empty.");
  char *Rmsg41 = _("I can't enter to");
  char *Rmsg42 = _("Do you want delete");
  char *Rmsg43 = _("Group ");
  char *Rmsg44 = _("Host ");
  char *Rmsg45 = _("Access denied.");
  char *Rmsg46 = _("Do you want copy");
  char *Rmsg47 = _("to");
  char *Rmsg48 = _("Index for find file now is empty, try letter.");
  char *Rmsg49 = _("Loading find index file from disk to memory, please wait..."); 
  char *Rmsg50 = _("New message"); 
  char *Rmsg51 = _("Do you want quit from smbc?"); 
  
  int Rxm, Rym;
  char *Rstmp; 
  char *Rms; 
  int Rtt, Rtt2;
  int Rt = 2;

  void Rpaint(int Ri, int Rnr, int Ry) {
   int Rall;
   if (Rnr == 0) { 
     Rall = strlen(Rmsg22)+strlen(Rmsg24);
     switch (Ri) {
       case 1 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg22); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg22)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                break;
       case 0 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg22);
                Rii = (Rxs-Rall)/2+strlen(Rmsg22)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
     }
   } else 
   if (Rnr == 1) {
     Rt = 3;
     Rall = strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+strlen(Rmsg24)+3;
     switch (Ri) {
       case 4 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg27); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24); 
                Rii = (Rxs)/2-strlen(Rmsg28)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rmsg28); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
       case 3 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25); wattroff(RwinMsg, COLOR_PAIR(1));
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg27);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                Rii = (Rxs)/2-strlen(Rmsg28)/2; mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rmsg28);
                break;
       case 2 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg27);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                Rii = (Rxs)/2-strlen(Rmsg28)/2; mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rmsg28);
                break;
       case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg27); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                Rii = (Rxs)/2-strlen(Rmsg28)/2; mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rmsg28);
                break;
       case 0 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg27); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg27)+3; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs)/2-strlen(Rmsg28)/2; mvwprintw(RwinMsg, Ry+1, 1+Rii, "%s", Rmsg28);
                break;
     }
   } 
   if (Rnr == 2) {
     Rt = 2;
     Rall = strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg29)+strlen(Rmsg24);
     switch (Ri) {
       case 3 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2;  mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg29);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg29)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                break;
       case 2 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg29);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg29)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                break;
       case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg29); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg29)+3; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24);
                break;
       case 0 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg25);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+1; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg26);
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+2; mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg29); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg25)+strlen(Rmsg26)+strlen(Rmsg29)+3; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Ry, 1+Rii, "%s", Rmsg24); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
     }
   } 
  }

  if (!Rselect) {
    switch(RnrMsg) {
       case 0: Rys = 8; Rxs = 40;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg41)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg41);
               Rii = Rxs/2-strlen(Rmsg)/2; mvwprintw(RwinMsg, 3, 1+Rii, "%s",RFS(Rmsg));
               Rii = Rxs/2-strlen(Rmsg22)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, 5, 1+Rii, "%s", Rmsg22); wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               keypad(RwinMsg, TRUE); 
               wgetch(RwinMsg);
               delwin(RwinMsg);
               break;
       case 1: if (!RdetectScreenToSmall()) {
                 Rys = 25; Rxs = 60;
                 Rtt = 1; Rtt2 = 2;
                 RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
                 RmvwprintwCenter(RwinMsg, Rtt++, "Simple Samba Commander");
                 RmvwprintwCenter(RwinMsg, Rtt++, "http://www.air.rzeszow.pl/smbc");
                 Rtt+=1;
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("o,arrow down - down              u,end - tail off list"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("p,arrow up   - up               y,home - head off list"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("i,tab        - change column      d,F5 - download/upload"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("t            - group/ungroup         w - reverse sorting"));
                 Rtt+=1;
                 Rtt2 = 7;
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("x,Enter           - execute a directory"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("a,insert          - select/unselect one file"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("l,page up         - one screen up"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("k,page down       - one screen down"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("CTRL-d,F8         - delete file or directory"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("shift-/shift=     - select/unselect all files"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("numeric *,shift-8 - reverse select"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("c,F7              - create directory"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("v,F3              - view text file"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("g                 - go to group/host/share/dir"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("e                 - change type of sorting"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("s                 - download list status"));
                 Rtt+=1;
                 Rtt2 = 2;
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("f - search file     r - reload     q - quit     h - help"));
                 mvwprintw(RwinMsg, Rtt++, Rtt2, _("              More details in README file."));
                 box(RwinMsg,0,0);
                 wrefresh(RwinMsg);
                 keypad(RwinMsg, TRUE); 
                 nodelay(RwinMsg,1);
                 while (wgetch(RwinMsg) == -1) {
                   RtryDownloadUpload();
                 }
                 delwin(RwinMsg);
               }
               break;
       case 2: Rys = 10; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg42)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg42);
               Rii = Rxs/2-strlen(Rmsg)/2; mvwprintw(RwinMsg, 3, Rii, "%s",RFS(Rmsg));
               Rt1 = 0; Rpaint(Rt1,0,7);
               nodelay(RwinMsg, 1);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                  RtryDownloadUpload();
                  if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) { Rt1 = !Rt1; Rpaint(Rt1,0,7); }
                  if (Rkey == 10 || Rkey == 'x') {
                    wrefresh(RwinMsg);
                    delwin(RwinMsg);
                    RwinRedrawWithData();
                    if (Rt1) return(1);
                    else return(0);
                  }
               }
       case 3: Rys = 8; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg51)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg51);
               Rt1 = 1; Rpaint(Rt1,0,5);
               nodelay(RwinMsg, 1);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                  RtryDownloadUpload();
                  if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) { Rt1 = !Rt1; Rpaint(Rt1,0,5); }
                  if (Rkey == 10 || Rkey == 'x') {
                    wrefresh(RwinMsg);
                    delwin(RwinMsg);
                    RwinRedrawWithData();
                    if (Rt1) return(1);
                    else return(0);
                  }
               }
    }
  } 
  else {
    if ((RnrMsg == 0) || (RnrMsg == 1)) {
               Rys = 8; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               if (RnrMsg == 0) memcpy(Rmsg1,Rmsg43,strlen(Rmsg43)+1);
                           else memcpy(Rmsg1,Rmsg44,strlen(Rmsg44)+1);
               Rt2 = strlen(Rmsg1); Rt1 = Rt2;
               memcpy(RmsgTmp, Rmsg1,Rt2);
               Rt2 = strlen(Rmsg);
               memcpy(RmsgTmp+Rt1,Rmsg, Rt2); Rt1 += Rt2;
               memcpy(RmsgTmp+Rt1, Rmsg23, strlen(Rmsg23)+1);
               Rii = Rxs/2-strlen(RmsgTmp)/2;
               mvwprintw(RwinMsg, 2, 1+Rii, "%s",RFS(RmsgTmp));
               Rii = Rxs/2-strlen(Rmsg22)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 5, 1+Rii, "%s", Rmsg22);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               wgetch(RwinMsg);
               delwin(RwinMsg);
    }
    if (RnrMsg == 2) {
               Rys = 9; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg41)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg41);
               Rii = Rxs/2-strlen(Rmsg)/2; mvwprintw(RwinMsg, 3, 1+Rii, "%s",RFS(Rmsg));
               Rii = Rxs/2-strlen(Rmsg45)/2; mvwprintw(RwinMsg, 4, 1+Rii, "%s",Rmsg45);
               Rii = Rxs/2-strlen(Rmsg22)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, 6, 1+Rii, "%s", Rmsg22); wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               wgetch(RwinMsg);
               delwin(RwinMsg);
    }
    if (RnrMsg == 3) {
               Rys = 10; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg46)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg46);
               Rii = Rxs/2-strlen(Rmsg)/2; mvwprintw(RwinMsg, 3, 1+Rii, "%s",RFS(Rmsg));
               Rii = Rxs/2-strlen(Rmsg47)/2; mvwprintw(RwinMsg, 4, 1+Rii, "%s",Rmsg47);
               Rii = Rxs/2-strlen(Rmsg2)/2; mvwprintw(RwinMsg, 5, 1+Rii, "%s",RFS(Rmsg2));
               Rt1 = 1; Rpaint(Rt1,0,7);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                  if (Rkey == 'i' || Rkey == 9 || Rkey == 67 || Rkey == 68) { Rt1 = !Rt1; Rpaint(Rt1,0,7); }
                  if (Rkey == 10 || Rkey == 'x') {
                    wrefresh(RwinMsg);
                    delwin(RwinMsg);
                    RwinRedrawWithData();
                    if (Rt1) return(1);
                    else return(0);
                  }
               }
    }
    if (RnrMsg == 4) {
               Rys = 7; Rxs = 60;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg40)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg40);
               Rii = Rxs/2-strlen(Rmsg22)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rmsg22);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               wgetch(RwinMsg);
               delwin(RwinMsg);
    }
    if (RnrMsg == 5) {
               Rys = 16; Rxs = 0; 
               getmaxyx(RwinMain,Rym,Rxm); 
               Rt = strlen(RTd->filename)+6; if (Rt > Rxm) Rxs = Rxm; else Rxs = Rt;
               Rt = strlen(RTd->pathR)+6; if (Rt > Rxs) {
                 if (Rt > Rxm) Rxs = Rxm;
                 else Rxs = Rt;
               }
               Rt = strlen(RTd->pathL)+6; if (Rt > Rxs) {
                 if (Rt > Rxm) Rxs = Rxm;
                 else Rxs = Rt;
               }
               if (Rxs < 50) Rxs = 50;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               keypad(RwinMsg, TRUE); 
               box(RwinMsg,0,0);
               asprintf(&Rstmp, _("Warning")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 2, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, _("Files")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 4, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, "%s",RTd->filename); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 5, Rii, "%s", RFS(Rstmp)); free(Rstmp);
               asprintf(&Rstmp, _("from")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 6, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, "%s",RTd->pathR); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 7, Rii, "%s", RFS(Rstmp)); free(Rstmp);
               asprintf(&Rstmp, _("to")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 8, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, "%s",RTd->pathL); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 9, Rii, "%s", RFS(Rstmp)); free(Rstmp);
               asprintf(&Rstmp, _("are different or connection broken.")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 10, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, _("Click on Wait to download letter.")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 11, Rii, "%s", Rstmp); free(Rstmp);
               Rt1 = 0; Rpaint(Rt1,1,Rys-3);
               wrefresh(RwinMsg);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                 if (Rkey == 260) {
                   if (Rt1 < 3) Rt1++; 
                   else Rt1 = 0;
                   Rpaint(Rt1,1,Rys-3); 
                 } 
                 if (Rkey == 'i' || Rkey == 261 || Rkey == 9) { 
                   if (Rt1 > 0) Rt1--;
                   else (Rt1 = 3);
                   Rpaint(Rt1,1,Rys-3); 
                 }
                 if (Rkey == 10 || Rkey == 'x') {
                   wrefresh(RwinMsg);
                   delwin(RwinMsg);
                   RwinRedrawWithData();
                   return(Rt1);
                 }
               }
    }
    if (RnrMsg == 6) {
               Rys = 14; Rxs = 0; 
               getmaxyx(RwinMain,Rym,Rxm); 
               Rt = strlen(RTd->filename)+6; if (Rt > Rxm) Rxs = Rxm; else Rxs = Rt;
               Rt = strlen(RTd->pathR)+6; if (Rt > Rxs) {
                 if (Rt > Rxm) Rxs = Rxm;
                 else Rxs = Rt;
               }
               Rt = strlen(RTd->pathL)+6; if (Rt > Rxs) {
                 if (Rt > Rxm) Rxs = Rxm;
                 else Rxs = Rt;
               }
               if (Rxs < 50) Rxs = 50;
               
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               keypad(RwinMsg, TRUE);
               box(RwinMsg,0,0);
               asprintf(&Rstmp, _("Warning")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 2, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, _("Can't %s"),Rmsg); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 4, Rii, "%s", Rstmp); free(Rstmp);
               asprintf(&Rstmp, "%s",RTd->filename); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 5, Rii, "%s", RFS(Rstmp)); free(Rstmp);
               asprintf(&Rstmp, _("Connection broken.")); Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 6, Rii, "%s", Rstmp); free(Rstmp);
               Rt1 = 0; Rpaint(Rt1,1,Rys-4);
               wrefresh(RwinMsg);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                 if (Rkey == 260) { 
                   if (Rt1 < 4) Rt1++; 
                   else Rt1 = 0;
                   Rpaint(Rt1,1,Rys-4); 
                 } 
                 if (Rkey == 261 || Rkey == 'i' || Rkey == 9) {
                   if (Rt1 > 0) Rt1--;
                   else (Rt1 = 4);
                   Rpaint(Rt1,1,Rys-4); 
                 }
                 if (Rkey == 10 || Rkey == 'x') {
                   wrefresh(RwinMsg);
                   delwin(RwinMsg);
                   RwinRedrawWithData();
                   return(Rt1);
                 }
               }
    }
    if (RnrMsg == 7) {
               Rys = 9; Rxs = 40;
               if (strlen(Rmsg)+2 > Rxs) Rxs = strlen(Rmsg)+4;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               asprintf(&Rms, _("Permission denied to")); Rii = Rxs/2-strlen(Rms)/2; mvwprintw(RwinMsg, 2, Rii, "%s",Rms); free(Rms);
               asprintf(&Rms, "%s", Rmsg+4); Rii = Rxs/2-strlen(Rms)/2; mvwprintw(RwinMsg, 3, Rii, "%s",RFS(Rms)); free(Rms);
               asprintf(&Rms, _("[ OK ]")); Rii = Rxs/2-strlen(Rms)/2; 
               wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, 6, Rii, "%s", Rms); wattroff(RwinMsg, COLOR_PAIR(1)); 
               free(Rms);
               wrefresh(RwinMsg);
               wgetch(RwinMsg);
               delwin(RwinMsg);
    }
    if (RnrMsg == 8) {
               Rys = 7; Rxs = 62;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg48)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg48);
               Rii = Rxs/2-strlen(Rmsg22)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rmsg22);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               nodelay(RwinMsg, 1);
               while (wgetch(RwinMsg) == -1) {
                 RtryDownloadUpload();
               };
               delwin(RwinMsg);
    }
    if (RnrMsg == 9) {
               Rys = 9; Rxs = 60; 
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               keypad(RwinMsg, TRUE);
               box(RwinMsg,0,0);
               asprintf(&Rstmp, _("Probably %s disk is full or quota exceeded."), Rmsg); 
                 Rii = Rxs/2-strlen(Rstmp)/2; mvwprintw(RwinMsg, 2, Rii, "%s", RFS(Rstmp)); free(Rstmp);
               Rt1 = 3; Rpaint(Rt1,1,Rys-4);
               wrefresh(RwinMsg);
               while ((Rkey = mvwgetch(RwinMsg, 1,1))) {
                 if (Rkey == 260) { 
                   if (Rt1 < 4) Rt1++; 
                   else Rt1 = 0;
                   Rpaint(Rt1,1,Rys-4); 
                 } 
                 if (Rkey == 261 || Rkey == 'i' || Rkey == 9) {
                   if (Rt1 > 0) Rt1--;
                   else (Rt1 = 4);
                   Rpaint(Rt1,1,Rys-4); 
                 }
                 if (Rkey == 10 || Rkey == 'x') {
                   wrefresh(RwinMsg);
                   delwin(RwinMsg);
                   RwinRedrawWithData();
                   return(Rt1);
                 }
               }
    }
    if (RnrMsg == 10) {
               Rys = 5; Rxs = strlen(Rmsg49)+6; 
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               keypad(RwinMsg, TRUE);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg49)/2; mvwprintw(RwinMsg, 2, Rii, "%s", RFS(Rmsg49));
               wrefresh(RwinMsg);
               delwin(RwinMsg);
    }
    if (RnrMsg == 11) {
               Rys = 21; Rxs = 72;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               RwinMsg2 = newwin(Rys-4,Rxs-2,(Ry/2-Rys/2)+1,(Rx/2-Rxs/2)+1);
               keypad(RwinMsg, TRUE);
               box(RwinMsg,0,0);

               Rii = Rxs/2-strlen(Rmsg50)/2; mvwprintw(RwinMsg2, 1, Rii, "%s", Rmsg50);

               Rt2 = strlen(Rmsg);
               Rms = RFS(Rmsg);
               Rym = 4; Rxm = 2;
               for (Rt1 = 0; Rt1 < Rt2; Rt1++) {
                 mvwprintw(RwinMsg2, Rym, Rxm++, "%c", Rms[Rt1]);
                 if (Rxm == Rxs-2) {
                   Rxm = 2;
                   Rym++;
                 }
               }

               Rt2 = strlen(Rmsg2);
               Rms = RFS(Rmsg2);
               Rym = Rym+3; Rxm = 2;
               for (Rt1 = 0; Rt1 < Rt2; Rt1++) {
                 mvwprintw(RwinMsg2, Rym, Rxm++, "%c", Rms[Rt1]);
                 if (Rxm == Rxs-2) {
                   Rxm = 2;
                   Rym++;
                 }
                 if (Rym == Rys-5)
                   break;
               }

               wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-3, Rxs/2-3, "%s", Rmsg22); wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               wrefresh(RwinMsg2);
               wgetch(RwinMsg);
               delwin(RwinMsg2);
               delwin(RwinMsg);
    }
    if (RnrMsg == 12) {
               Rys = 7; Rxs = 62;
               RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
               box(RwinMsg,0,0);
               Rii = Rxs/2-strlen(Rmsg)/2; mvwprintw(RwinMsg, 2, 1+Rii, "%s",Rmsg);
               Rii = Rxs/2-strlen(Rmsg22)/2;
               wattron(RwinMsg, COLOR_PAIR(1)); 
               mvwprintw(RwinMsg, 4, 1+Rii, "%s", Rmsg22);
               wattroff(RwinMsg, COLOR_PAIR(1)); 
               wrefresh(RwinMsg);
               nodelay(RwinMsg, 1);
               while (wgetch(RwinMsg) == -1) {
                 RtryDownloadUpload();
               };
               delwin(RwinMsg);
    }
  }
  RwinRedrawWithData();
  return(0);
}


void RwinRedrawWithData()
{
  RwinRedraw();
  RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
  RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
}

TTdownload *RgetdownloadListNr(int Rnr)
{
  TTdownload *RdownloadListTmp = RdownloadList;
  while (Rnr-- > 0) RdownloadListTmp = RdownloadListTmp->RdownloadList;
  return(RdownloadListTmp);
}

TTdownload *RgetdownloadListLast()
{
  TTdownload *RdownloadListTmp = RdownloadList;
  if (RdownloadListTmp == NULL) return(NULL);
  while (RdownloadListTmp->RdownloadList != NULL) RdownloadListTmp = RdownloadListTmp->RdownloadList;
  return(RdownloadListTmp);
}

TTdownload *RgetdownloadListFirst()
{
  TTdownload *RdownloadListTmp = RdownloadList;
  if (RdownloadListTmp == NULL) return(NULL);
  while (RdownloadListTmp->RdownloadListP != NULL) RdownloadListTmp = RdownloadListTmp->RdownloadListP;
  return(RdownloadListTmp);
}

int RgetdownloadListCount()
{
  int Rc = 1;
  TTdownload *RdownloadListTmp = RdownloadList;
  if (RdownloadListTmp == NULL) return(0);
  while (RdownloadListTmp->RdownloadList != NULL) {
     RdownloadListTmp = RdownloadListTmp->RdownloadList;
     Rc++;
  }
  return(Rc);
}

int RmanageList()
{
  WINDOW *RwinList, 
         *RwinCol1, *RwinCol2, *RwinCol3, *RwinCol4, 
         *RwinCol5, *RwinCol6, *RwinCol7;
  int Rkey, Rsel, RmaxY, Rx6, Ri, RlFirst, RlSelect;
  TTdownload *RdownloadListTmp, *RdownloadListTmp2;

  void RpaintList(int Rfirst, int Rselect)
  {
    int Rlast, Ri;
    int Rk = -1;

    RdownloadListTmp = RgetdownloadListNr(Rfirst); 

    if ((Rfirst == 0) & (RgetdownloadListCount() <= RmaxY)) Rlast = RgetdownloadListCount();
    else Rlast = Rfirst + RmaxY;
    for (Ri = Rfirst; Ri < Rlast; Ri++) {
      mvwhline(RwinCol1, ++Rk, 0, 32, 1);
      mvwhline(RwinCol2, Rk, 0, 32, 1);
      mvwhline(RwinCol3, Rk, 0, 32, 5);
      mvwhline(RwinCol4, Rk, 0, 32, 5);
      mvwhline(RwinCol5, Rk, 0, 32, 3);
      mvwhline(RwinCol6, Rk, 0, 32, Rx6);
      mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
      if (Ri == Rselect) {
          wattron(RwinCol1, COLOR_PAIR(1)); 
          wattron(RwinCol2, COLOR_PAIR(1)); 
          wattron(RwinCol3, COLOR_PAIR(1)); 
          wattron(RwinCol4, COLOR_PAIR(1)); 
          wattron(RwinCol5, COLOR_PAIR(1)); 
          wattron(RwinCol6, COLOR_PAIR(1)); 
          wattron(RwinCol7, COLOR_PAIR(1)); 
          mvwhline(RwinCol1, Rk, 0, 32, 1);
          mvwhline(RwinCol2, Rk, 0, 32, 1);
          mvwhline(RwinCol3, Rk, 0, 32, 5);
          mvwhline(RwinCol4, Rk, 0, 32, 5);
          mvwhline(RwinCol5, Rk, 0, 32, 3);
          mvwhline(RwinCol6, Rk, 0, 32, Rx6);
          mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
      }
      mvwprintw(RwinCol1, Rk, 0, "%c", RdownloadListTmp->active); 
      mvwprintw(RwinCol2, Rk, 0, "%c", RdownloadListTmp->upload); 
      mvwprintw(RwinCol3, Rk, 0, "%s", RdownloadListTmp->sizeDisplayR); 
      mvwprintw(RwinCol4, Rk, 0, "%s", RdownloadListTmp->sizeDisplayDownR); 
      mvwprintw(RwinCol5, Rk, 0, "%s%%", RdownloadListTmp->percent); 
      mvwprintw(RwinCol6, Rk, 0, "%s", RFS(RdownloadListTmp->filename));
      if (RdownloadListTmp->upload == 'D') 
        mvwprintw(RwinCol7, Rk, 0, "%s | %s | %s", 
          RFS(RdownloadListTmp->pathR+4),
          RFS(RdownloadListTmp->pathL), RFS(RdownloadListTmp->groupnameR)); 
      else 
        mvwprintw(RwinCol7, Rk, 0, "%s | %s | %s", 
          RFS(RdownloadListTmp->pathR), 
          RFS(RdownloadListTmp->pathL+4), RFS(RdownloadListTmp->groupnameR)); 
      if (Ri == Rselect) {
          wattroff(RwinCol1, COLOR_PAIR(1)); 
          wattroff(RwinCol2, COLOR_PAIR(1)); 
          wattroff(RwinCol3, COLOR_PAIR(1)); 
          wattroff(RwinCol4, COLOR_PAIR(1)); 
          wattroff(RwinCol5, COLOR_PAIR(1)); 
          wattroff(RwinCol6, COLOR_PAIR(1)); 
          wattroff(RwinCol7, COLOR_PAIR(1)); 
      }
      RdownloadListTmp = RdownloadListTmp->RdownloadList;
    }
    for (Ri = Rlast+1; Ri < Rfirst+RmaxY+1; Ri++) {
      mvwhline(RwinCol1, ++Rk, 0, 32, 1);
      mvwhline(RwinCol2, Rk, 0, 32, 1);
      mvwhline(RwinCol3, Rk, 0, 32, 5);
      mvwhline(RwinCol4, Rk, 0, 32, 5);
      mvwhline(RwinCol5, Rk, 0, 32, 3);
      mvwhline(RwinCol6, Rk, 0, 32, Rx6);
      mvwhline(RwinCol7, Rk, 0, 32, Rx-21-Rx6);
    }
    wrefresh(RwinCol1);
    wrefresh(RwinCol2);
    wrefresh(RwinCol3);
    wrefresh(RwinCol4);
    wrefresh(RwinCol5);
    wrefresh(RwinCol6);
    wrefresh(RwinCol7);
  }

  void RmanageListCreateWindow()
  {
    Rx6 = 0;
    RdownloadListTmp = RdownloadList;
    for (Ri = 0; Ri < RgetdownloadListCount(); Ri++) {
      if (strlen(RdownloadListTmp->filename) > Rx6)
        Rx6 = strlen(RdownloadListTmp->filename);
      RdownloadListTmp = RdownloadListTmp->RdownloadList;
    }
    getmaxyx(RwinMain, RmaxY, Rsel);
    if (Rx6 > Rsel-18) Rx6 = Rsel-18-10;
    RstatusBar(1);
    RwinList = newwin(Ry-2, Rx, 1, 0);
    RwinCol1 = newwin(Ry-6, 1, 4, 1);
    RwinCol2 = newwin(Ry-6, 1, 4, 3);
    RwinCol3 = newwin(Ry-6, 5, 4, 5);
    RwinCol4 = newwin(Ry-6, 5, 4, 11);
    RwinCol5 = newwin(Ry-6, 3, 4, 17);
    RwinCol6 = newwin(Ry-6, Rx6, 4, 21);
    RwinCol7 = newwin(Ry-6, Rx-Rx6-23, 4, 22+Rx6);
    getmaxyx(RwinCol1, RmaxY, Rsel);
    Rsel = 0;
    mvwprintw(RwinList, 1,1, _("S D size  remai per file/directory"));
    mvwprintw(RwinList, 1,1+21+Rx6, _("from | to | group"));
    box(RwinList,0,0);
    mvwvline(RwinList, 1, 2, 0, Ry-4);
    mvwvline(RwinList, 1, 4, 0, Ry-4);
    mvwvline(RwinList, 1, 10, 0, Ry-4);
    mvwvline(RwinList, 1, 16, 0, Ry-4);
    mvwvline(RwinList, 1, 20, 0, Ry-4);
    mvwvline(RwinList, 1, 20+Rx6+1, 0, Ry-4);
    mvwhline(RwinList, 2, 1, 0, Rx-2);
    wrefresh(RwinList);
    keypad(RwinList, TRUE); 
    nodelay(RwinList,1);
  }

  void RdoWindowResizeDownloadList()
  {
    if (RdoResizeDownload) {
      RdoResizeDownload = 0;
      RdoWindowResize();
      RmanageListCreateWindow();
      RpaintList(RlFirst,RlSelect);
    }
  }

  RmanageListCreateWindow();
  RlFirst = 0; RlSelect = 0;
  RpaintList(RlFirst,RlSelect);
  while ((Rkey = mvwgetch(RwinList, 1,1))) {
    if (Rkey != -1) { RDBG("smbc: RmanageList Rkey = "); RDBGi(Rkey); RDBG("\n"); }
    RdoWindowResizeDownloadList();
    if (Rkey == 32) {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       if(RdownloadListTmp->active == 'X') RdownloadListTmp->active = ' ';
       else RdownloadListTmp->active = 'X';
       Rkey = KEY_DOWN;
    }
    if (Rkey == 'd' || Rkey == KEY_DC) {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       RdownloadListTmp->active = 'D';
       Rkey = KEY_DOWN;
    }
    if (Rkey == 4) {             // CTRL-d
       RdownloadListTmp = RgetdownloadListNr(RlSelect+1);
       RdownloadListTmp2 = RgetdownloadListFirst();
       while (RdownloadListTmp2 != NULL) {
         if (RstrCmp(RdownloadListTmp2->pathR,RdownloadListTmp->pathR) == 1)  
            RdownloadListTmp2->active = 'D';
         RdownloadListTmp2 = RdownloadListTmp2->RdownloadList;
       }
       RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == 6) {             // CTRL-f
       RdownloadListTmp = RgetdownloadListNr(RlSelect+1);
       RdownloadListTmp2 = RgetdownloadListFirst();
       while (RdownloadListTmp2 != NULL) {
         RdownloadListTmp2->active = 'D';
         RdownloadListTmp2 = RdownloadListTmp2->RdownloadList;
       }
       RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == 'u') {
       RdownloadListTmp = RgetdownloadListNr(RlSelect);
       RdownloadListTmp->active = 'X';
       Rkey = KEY_DOWN;
    }
    if (Rkey == KEY_DOWN || Rkey == 'o') {
      if ((RlSelect+1 == RlFirst+RmaxY) & (RlFirst+RmaxY < RgetdownloadListCount())) {
        RlFirst++; RlSelect++;
      }
      else if (RlSelect < RgetdownloadListCount()-1) RlSelect++;
      RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == KEY_UP || Rkey == 'p') {
      if (RlSelect > 0) {
         if ((RlFirst > 0) && (RlSelect == RlFirst)) { RlFirst--; RlSelect--; } 
         else RlSelect--;
         RpaintList(RlFirst,RlSelect);
      }
    }
    if (Rkey == KEY_NPAGE || Rkey == 'k') {
      if (RlFirst+RmaxY <= RgetdownloadListCount()) {
        if (RlSelect+1 == RlFirst+RmaxY) {
           if (RlSelect+RmaxY < RgetdownloadListCount()) {
              RlFirst = RlSelect;
              RlSelect = RlFirst+RmaxY-1;
            }
            else {
              RlFirst = RgetdownloadListCount()-RmaxY;
              RlSelect = RgetdownloadListCount()-1;
            }
        }
        else {
           if (RlSelect+RmaxY <= RgetdownloadListCount()) 
             RlSelect = RlFirst+RmaxY-1;
           else
             RlSelect = RgetdownloadListCount()-1;
        }
      }
      RpaintList(RlFirst,RlSelect);
    }
    if (Rkey == KEY_PPAGE || Rkey == 'l') {
      if (RlSelect > 1) {
        if (RlFirst == RlSelect) {
          if (RlFirst - RmaxY < 1) {
            RlFirst = 1;
            RlSelect = 1;
          }
          else {
            RlFirst = RlFirst - RmaxY + 1;
            RlSelect = RlFirst;
          }
        }
        else RlSelect = RlFirst;
        RpaintList(RlFirst,RlSelect);
      }
    }
    if (Rkey == 'q') {
       if (RdownloadListAct != NULL)
         if (RdownloadListAct->active == ' ') {
           Rsmbc_close(RdownloadHandleR);
           close(RdownloadHandleL);
           RdownloadHandleL = -1;
           RdownloadHandleR = -1;
           RdownloadListAct = NULL;
         }
       Ri = 1;
       while (Ri) {
         Ri = 0;
         RdownloadListTmp = RdownloadList;
         if (RgetdownloadListCount() == 1 ) {
           if (RdownloadListTmp->active == 'D') {
             free(RdownloadListTmp);
             RdownloadList = NULL;
             Rsmbc_close(RdownloadHandleR);
             close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         else while ((RdownloadListTmp != NULL) & (Ri == 0)) {
                if (RdownloadListTmp->active == 'D') {
                  if (RdownloadListTmp == RdownloadListAct) {
                    Rsmbc_close(RdownloadHandleR);
                    close(RdownloadHandleL);
                    RdownloadHandleL = -1;
                    RdownloadHandleR = -1;
                  }
                  if (RdownloadListTmp->RdownloadListP != NULL) 
                    RdownloadListTmp->RdownloadListP->RdownloadList = RdownloadListTmp->RdownloadList;
                  if (RdownloadListTmp->RdownloadList != NULL)
                    RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp->RdownloadListP;
                  if (RdownloadList == RdownloadListTmp) {
                      if (RdownloadList->RdownloadList == NULL)
                      RdownloadList = RdownloadListTmp->RdownloadListP;  
                      else RdownloadList = RdownloadListTmp->RdownloadList;  
                  }
                  free(RdownloadListTmp);
                  RdownloadList = RgetdownloadListFirst();
                  Ri = 1;
                }
                RdownloadListTmp = RdownloadListTmp->RdownloadList;
              }
       }
       //RdownloadList = RgetdownloadListFirst();
       delwin(RwinList);
       delwin(RwinCol1);
       delwin(RwinCol3);
       delwin(RwinCol4);
       delwin(RwinCol5);
       delwin(RwinCol6);
       delwin(RwinCol7);
       RwinRedrawWithData();
       return (0);
    }
    Rkey = 0; 
  }
  return(0);
}

void Rget_auth_data(const char *srv, const char *shr, char *wg, int wglen, char *un, int unlen, char *pw, int pwlen)
{
  strncpy(wg, Ragroup, strlen(Ragroup)+1);
  strncpy(un, Rusername, strlen(Rusername)+1);
  strncpy(pw, Rpassword, strlen(Rpassword)+1);
}

int RfreeMasterList()
{
  int i;

  for (i=0;i<RgroupsCount;i++) {
    realloc(Rgroups[i], sizeof(TTgroups));
  }
  RgroupsCount = -1;
  return (RgroupsCount);
}

int RgetMasterList()
{
  int Rfd;
  struct smbc_dirent *Rdirent;

  RfreeMasterList();
  RgroupsCount = -1;
  if ((Rfd = Rsmbc_opendir("smb://")) < 0) 
    return(-1);
  while((Rdirent = Rsmbc_readdir(Rfd))) {
    if (Rdirent->smbc_type == SMBC_WORKGROUP) { 
      Rgroups[++RgroupsCount] = malloc(sizeof(TTgroups));
      memcpy(Rgroups[RgroupsCount]->groupname,Rdirent->name,strlen(Rdirent->name)+1);
      memcpy(Rgroups[RgroupsCount]->mastername,"",1);
      memcpy(Rgroups[RgroupsCount]->masterip,"",1);
    }
  }
  Rsmbc_closedir(Rfd);
  RgroupsCount++;
  return(RgroupsCount);
}

int RfreeHostsList()
{
  int i;

  for (i=0;i<RhostsCount;i++) {
    realloc(Rhosts[i], sizeof(TThosts));
  }
  RhostsCount = -1;
  return (RhostsCount);
}

int RgetHostsFromGroup(char *group)
{
  int Rfd;
  struct smbc_dirent *Rdirent;
  char *Rstr;

  RfreeHostsList();
  RhostsCount = -1;
  asprintf(&Rstr, "smb://%s/", group);
  if ((Rfd = Rsmbc_opendir(Rstr)) > 0) {
   while((Rdirent = Rsmbc_readdir(Rfd))) {
    if (Rdirent->smbc_type == SMBC_SERVER) { 
      Rhosts[++RhostsCount] = malloc(sizeof(TThosts));
      memcpy(Rhosts[RhostsCount]->hostname,Rdirent->name,strlen(Rdirent->name)+1);
      memcpy(Rhosts[RhostsCount]->comment,Rdirent->comment,strlen(Rdirent->comment)+1);
    }
   }
  }
  Rsmbc_closedir(Rfd);
  free(Rstr);
  RhostsCount++;
  return(RhostsCount);
}

int RfreeSharesList()
{
  int i;

  for (i=0;i<RsharesCount;i++) {
    realloc(Rshares[i], sizeof(TTshares));
  }
  RsharesCount = -1;
  return (RsharesCount);
}

int RgetSharesFromHost(char *host)
{
  int Rfd;
  struct smbc_dirent *Rdirent;
  char *Rstr;

  RfreeSharesList();
  RsharesCount = -1;
  asprintf(&Rstr, "smb://%s/", host);
  if ((Rfd = Rsmbc_opendir(Rstr)) > 0) {
   while((Rdirent = Rsmbc_readdir(Rfd))) {
    if (Rdirent->smbc_type == SMBC_FILE_SHARE) 
     if (strlen(Rdirent->name) > 0) 
       if (Rdirent->name[strlen(Rdirent->name)-1] != '$') { 
         Rshares[++RsharesCount] = malloc(sizeof(TTshares));
         memcpy(Rshares[RsharesCount]->sharename,Rdirent->name,strlen(Rdirent->name)+1);
         memcpy(Rshares[RsharesCount]->comment,Rdirent->comment,strlen(Rdirent->comment)+1);
       }
   }
   Rsmbc_closedir(Rfd);
   RsharesCount++;
  }
  else {
   RshowMessage(7, 1, Rstr, "", NULL);
   RsharesCount = -1;
  }  
 free(Rstr);
 return(RsharesCount);
}

int getHumanSize(char *Rdst, unsigned int Rsrc)
{
  char Rj[2] = "B\0";
  char Rjtmp[5];
  int Rs,Rtmp, Rdx;

  Rs = 0;
  if ((Rsrc/1024) > 0) { Rs = (Rsrc % 1024)*1000; Rsrc = Rsrc/1024; memcpy(Rj,"K",2); }
  if ((Rsrc/1024) > 0) { Rs = (Rsrc % 1024)*1000; Rsrc = Rsrc/1024; memcpy(Rj,"M",2); }
  if ((Rsrc/1024) > 0) { Rs = (Rsrc % 1024)*1000; Rsrc = Rsrc/1024; memcpy(Rj,"G",2); }
  if ((Rsrc/1024) > 0) { Rs = (Rsrc % 1024)*1000; Rsrc = Rsrc/1024; memcpy(Rj,"T",2); }
  itoa(Rdst, Rsrc);
  Rtmp = 3-strlen(Rdst);
  if ((Rtmp > 0) & (Rj[0] != 'B')) { 
    itoa(Rjtmp, Rs);
    Rdx = strlen(Rdst);
    memcpy(Rdst+Rdx, ".", 1); Rdx += 1;
    memcpy(Rdst+Rdx, Rjtmp, Rtmp); Rdx += Rtmp;
    memcpy(Rdst+Rdx, "\0", 1); 
  }
  memcpy(Rdst+strlen(Rdst), Rj, 2); 
  Rtmp = strlen(Rdst);
  memcpy(Rjtmp, "     ", 6);
  memcpy(Rjtmp+5-Rtmp, Rdst, Rtmp+1);
  memcpy(Rdst, Rjtmp, 6);
  return(1);
}

int RfreeFilesList()
{
  int i;

  for (i=0;i<RfilesCount;i++) {
    realloc(Rfiles[i], sizeof(TTfiles));
  }
  RfilesCount = -1;
  return (RfilesCount);
}

int RgetFileFromDirR(char *dir)
{
  int Rtym;
  int dirhandle, filehandle;
  struct smbc_dirent *Rdirent;
  char Rfn[1000];
  int Rfnl = 0;
  int Rfnll;
  struct stat remotestat;
  int Rsize;

  RfreeFilesList();
  dirhandle = Rsmbc_opendir(dir);
  if(dirhandle < 1) { 
    return -1;
  }
  RfilesCount = 0;
  while((Rdirent = Rsmbc_readdir(dirhandle))) {
    if (!RstrCmp(Rdirent->name,".") && !RstrCmp(Rdirent->name,"..")) {
     Rfiles[RfilesCount] = malloc(sizeof(TTfiles)); 
     Rtym = strlen(Rdirent->name);
     memcpy(Rfiles[RfilesCount]->filename, Rdirent->name, Rtym);
     memcpy(Rfiles[RfilesCount]->filename+Rtym,"\0",1);
     Rfnl = strlen(dir); memcpy(Rfn, dir, Rfnl);
     Rfnll = strlen(Rdirent->name); memcpy(Rfn+Rfnl, Rdirent->name, Rfnll);
     Rfnl += Rfnll; strncpy(Rfn+Rfnl, "\0", 1);
     filehandle = Rsmbc_open(Rfn, O_RDONLY, 0755);
     if (Rsmbc_fstat(filehandle, &remotestat) < 0) {
        Rsize = 0;
        Rfiles[RfilesCount]->type = RTDIR;
        getHumanSize(Rfiles[RfilesCount]->sizeShow,0);
     }
     else {
       Rsize = remotestat.st_size;
       Rfiles[RfilesCount]->type = RTFILE;
       getHumanSize(Rfiles[RfilesCount]->sizeShow,Rsize);
     }
     Rfiles[RfilesCount]->size = Rsize;
     Rsmbc_close(filehandle);
     RfilesCount++;
    }
  }
  Rsmbc_closedir(dirhandle);
  return(RfilesCount);
}

 
int RgetFileFromDirL(char *dir)
{
  DIR *dirhandle;
  struct dirent *Rdirent;
  char Rfn[1000];
  struct stat localstat;
  int Rsize;

  RfreeFilesList();
  dirhandle = opendir(dir);
  if(dirhandle == NULL) { 
    RshowMessage(0,0,dir,"",NULL);
    return -1;
  }
  RfilesCountL = 0;
  while((Rdirent =  readdir(dirhandle))) {
    if (!RstrCmp(Rdirent->d_name,".") && !RstrCmp(Rdirent->d_name,"..")) {
     memcpy(Rfn, dir, strlen(dir)+1);
     memcpy(Rfn+strlen(Rfn), Rdirent->d_name, strlen(Rdirent->d_name)+1);
     stat(Rfn, &localstat);
     RfilesL[RfilesCountL] = malloc(sizeof(TTfiles)); 
     memcpy(RfilesL[RfilesCountL]->filename, Rdirent->d_name, strlen(Rdirent->d_name)+1);
     getHumanSize(RfilesL[RfilesCountL]->sizeShow,localstat.st_size);
     RfilesL[RfilesCountL]->size = localstat.st_size;
     if (localstat.st_mode & S_IFDIR) {
        Rsize = 0;
        RfilesL[RfilesCountL]->type = RTDIR;
     }
     else {
       Rsize = Rdirent->d_reclen;
       RfilesL[RfilesCountL]->type = RTFILE;
     }
     RfilesCountL++;
    }
  }
  closedir(dirhandle);
  return RfilesCountL;
}

void RstatusBar(int Rnr)
{
  mvwhline(RwinStatus, 0, 0, ' ', Rx);
  switch(Rnr) {
    case -1: break;
    case 0: mvwprintw(RwinStatus,0,0,_("q-quit | h-help | (d)F5-copy | s-download list | f - search remote file")); break;
    case 1: mvwprintw(RwinStatus,0,0,_("q - exit | d(DEL) - delete | u - undelete | space - pause/resume | CTRL-d - delete dir | CTRL-f - flush list")); break;
    case 2: mvwprintw(RwinStatus,0,0,_("Enter workgroup name, keys Enter,TAB - next field, Ctrl+I enable/disable interactive filtering, Ctrl+k - quit")); break;
    case 3: mvwprintw(RwinStatus,0,0,_("Enter hostname name, Enter,TAB - next field, Ctrl+I enable/disable interactive filtering, Ctrl+k - quit")); break;
    case 4: mvwprintw(RwinStatus,0,0,_("Enter dir name, Enter,TAB - next field, Ctrl+I enable/disable interactive filtering, Ctrl+k - quit")); break;
    case 5: mvwprintw(RwinStatus,0,0,_("Enter file name, Enter,TAB - next field, Ctrl+I enable/disable interactive filtering, Ctrl+k - quit")); break;
    case 6: mvwprintw(RwinStatus,0,0,_("q - quit | Enter - go to file | TAB - next field | PageUp,PageDown,Up,Down - manage to list")); break;
    case 7: mvwprintw(RwinStatus,0,0,_("New find index is ready. You can use quick find file.")); break;
    case 8: mvwprintw(RwinStatus,0,0,_("Preparing find index.")); break;
    case 9: mvwprintw(RwinStatus,0,0,_("Sort %s panel by filename."), Rselected?_("right"):_("left")); break;
    case 10: mvwprintw(RwinStatus,0,0,_("Sort %s panel by extension."), Rselected?_("right"):_("left")); break;
    case 11: mvwprintw(RwinStatus,0,0,_("Sort %s panel by size."), Rselected?_("right"):_("left")); break;
    case 12: mvwprintw(RwinStatus,0,0,_("%s panel without sorting."), Rselected?_("right"):_("left")); break;
    case 13: mvwprintw(RwinStatus,0,0,_("Reverse sorting in %s panel."), Rselected?_("right"):_("left")); break;
    case 14: mvwprintw(RwinStatus,0,0,_("Ungroup files and directories in %s panel."), Rselected?_("right"):_("left")); break;
    case 15: mvwprintw(RwinStatus,0,0,_("Group files and directories in %s panel."), Rselected?_("right"):_("left")); break;
    case 16: mvwprintw(RwinStatus,0,0,_("Warning. Can't copy %s workgroup."), Rselected?_("from"):_("to")); break;
    case 17: mvwprintw(RwinStatus,0,0,_("Warning. Can't copy %s host."), Rselected?_("from"):_("to")); break;
    case 18: mvwprintw(RwinStatus,0,0,_("Warning. Can't copy from share.")); break;
    case 19: mvwprintw(RwinStatus,0,0,_("Warning. Can't copy to network.")); break;
    case 20: mvwprintw(RwinStatus,0,0,_("(q)F3-quit | (w)F8-wrap/unwrap")); break;
    case 21: mvwprintw(RwinStatus,0,0,_("Interactive filtering is off.")); break;
    case 22: mvwprintw(RwinStatus,0,0,_("Interactive filtering is on.")); break;
    case 23: mvwprintw(RwinStatus,0,0,_("q - quit | b - add bookmark and quit | d(DEL)/u - delete/undelete | x(Enter) - go to item")); break;
    case 24: mvwprintw(RwinStatus,0,0,_("MOVE q - quit | b - add bookmark and quit | d(DEL)/u - delete/undelete | x(Enter) - go to item")); break;
  }
  wrefresh(RwinStatus);
}

void RwinRedraw()
{
  char *RstrT = _("Inspiration is my wife Magda (Arida)");

  box(RwinLeft,0,0);
  box(RwinRight,0,0);
  mvwhline(RwinLeftTop, 0, 0, 0, RxHalf-2);
  mvwhline(RwinRightTop, 0, 0, 0, RxHalf-2);
  mvwprintw(RwinHead,0,0,"Simple Samba Commander %s", VERSION);
  mvwprintw(RwinHead,0,Rx-strlen(RstrT), RFS(RstrT));
  mvwhline(RwinLeft, 2, 1, 0, RxHalf-2);
  mvwhline(RwinLeft, 2, 1, 0, RxHalf-2);
  mvwvline(RwinLeftList, 0, 1, 0, Ry-6);
  mvwvline(RwinLeftList, 0, RxHalf-8, 0, Ry-6);
  mvwhline(RwinRight, 2, 1, 0, RxHalf-2+Rdx);
  mvwvline(RwinRightList, 0, 1, 0, Ry-6);
  mvwvline(RwinRightList, 0, RxHalf-8+Rdx, 0, Ry-6);
  mvwvline(RwinLeftHead, 0, 1, 0, 1);
  mvwvline(RwinLeftHead, 0, RxHalf-8, 0, 1);
  mvwvline(RwinRightHead, 0, 1, 0, 1);
  mvwvline(RwinRightHead, 0, RxHalf-8+Rdx, 0, 1);
  mvwprintw(RwinLeftTop,0,0,"/");
  mvwprintw(RwinRightTop,0,0,"//");
  mvwprintw(RwinLeftHeadCol1,0,0,_("T"));
  mvwprintw(RwinLeftHeadCol2,0,0,_("file or directory name"));
  mvwprintw(RwinLeftHeadCol3,0,0,_("size"));
  mvwprintw(RwinRightHeadCol1,0,0,_("T"));
  mvwprintw(RwinRightHeadCol2,0,0,_("workgroup, share, file or directory name"));
  mvwprintw(RwinRightHeadCol3,0,0,_("size"));
  wrefresh(RwinMain);
  wrefresh(RwinLeft);
  wrefresh(RwinRight);
  wrefresh(RwinHead);
  wrefresh(RwinLeftHead);
  wrefresh(RwinRightHead);
  wrefresh(RwinLeftList);
  wrefresh(RwinRightList);
  wrefresh(RwinLeftTop);
  wrefresh(RwinRightTop);
  wrefresh(RwinLeftCol1);
  wrefresh(RwinLeftCol2);
  wrefresh(RwinLeftCol3);
  wrefresh(RwinRightCol1);
  wrefresh(RwinRightCol2);
  wrefresh(RwinRightCol3);
  wrefresh(RwinLeftHeadCol1);
  wrefresh(RwinLeftHeadCol2);
  wrefresh(RwinLeftHeadCol3);
  wrefresh(RwinRightHeadCol1);
  wrefresh(RwinRightHeadCol2);
  wrefresh(RwinRightHeadCol3);
  RstatusBar(0);
}

void RwriteMenu(int Rredraw)
{
  int Rnr;

  if (RwinMain) delwin(RwinMain);
  if (RwinLeft) delwin(RwinLeft);
  if (RwinRight) delwin(RwinRight);
  if (RwinHead) delwin(RwinHead);
  if (RwinStatus) delwin(RwinStatus);
  if (RwinLeftHead) delwin(RwinLeftHead);
  if (RwinLeftList) delwin(RwinLeftList);
  if (RwinRightHead) delwin(RwinRightHead);
  if (RwinRightList) delwin(RwinRightList);
  if (RwinLeftCol1) delwin(RwinLeftCol1);
  if (RwinLeftCol2) delwin(RwinLeftCol2);
  if (RwinLeftCol3) delwin(RwinLeftCol3);
  if (RwinRightCol1) delwin(RwinRightCol1);
  if (RwinRightCol2) delwin(RwinRightCol2);
  if (RwinRightCol3) delwin(RwinRightCol3);
  if (RwinLeftHeadCol1) delwin(RwinLeftHeadCol1);
  if (RwinLeftHeadCol2) delwin(RwinLeftHeadCol2);
  if (RwinLeftHeadCol3) delwin(RwinLeftHeadCol3);
  if (RwinRightHeadCol1) delwin(RwinRightHeadCol1);
  if (RwinRightHeadCol2) delwin(RwinRightHeadCol2);
  if (RwinRightHeadCol3) delwin(RwinRightHeadCol3);
  endwin();
  initscr();

  start_color();
  init_pair(1, COLOR_BLACK, COLOR_CYAN);
  init_pair(2, COLOR_BLACK, COLOR_YELLOW);
  init_pair(3, COLOR_BLACK, COLOR_GREEN);
  init_pair(9, COLOR_BLACK, COLOR_GREEN);

  for (Rnr = 0; Rnr < 3; Rnr++) {
    init_color(Rcolor[Rnr].realnumber, Rcolor[Rnr].red, Rcolor[Rnr].green, Rcolor[Rnr].blue);
    init_pair(10+Rnr, Rcolor[Rnr].realnumber,COLOR_BLACK);
  }

  curs_set(0);
  noecho();
  start_color();
  RwinMain = newwin(0,0,0,0); 
  getmaxyx(RwinMain, Ry, Rx);
  RxHalf = Rx/2;
  if ((RxHalf * 2) != Rx) { Rdx = 1; }
  else { Rdx = 0; };
  RwinLeft = newwin(Ry-2,RxHalf,1,0); 
  RwinRight = newwin(Ry-2,RxHalf+Rdx,1,RxHalf);
  RwinHead = newwin(1,Rx,0,0);
  RwinStatus = newwin(1,Rx,Ry-1,0);
  RwinLeftHead = newwin(1,RxHalf-2,2,1);
  RwinRightHead = newwin(1,RxHalf-2+Rdx,2,RxHalf+1);
  RwinLeftList = newwin(Ry-6,RxHalf-2,4,1);
  RwinRightList = newwin(Ry-6,RxHalf-2+Rdx,4,RxHalf+1);
  RwinLeftTop = newwin(1,RxHalf-2,1,1);
  RwinRightTop = newwin(1,RxHalf-2,1,RxHalf+1);
  RwinLeftHeadCol1 = newwin(1,1,2,1);
  RwinLeftHeadCol2 = newwin(1,RxHalf-10,2,3);
  RwinLeftHeadCol3 = newwin(1,5,2,RxHalf-6);
  RwinLeftCol1 = newwin(Ry-6,1,4,1);
  RwinLeftCol2 = newwin(Ry-6,RxHalf-10,4,3);
  RwinLeftCol3 = newwin(Ry-6,5,4,RxHalf-6);
  RwinRightHeadCol1 = newwin(1,1,2,RxHalf+1);
  RwinRightHeadCol2 = newwin(1,RxHalf-10+Rdx,2,RxHalf+3);
  RwinRightHeadCol3 = newwin(1,5,2,Rx-6);
  RwinRightCol1 = newwin(Ry-6,1,4,RxHalf+1);
  RwinRightCol2 = newwin(Ry-6,RxHalf-10+Rdx,4,RxHalf+3);
  RwinRightCol3 = newwin(Ry-6,5,4,Rx-6);
  if (Rredraw) RwinRedraw();
}

void RsortList(RLTYPE Rcol)
{
  TTlist *Rtlist;
  int Rr, Ri;
  char *Ridx1, *Ridx2;

  char RgetVar(char *Rstr1, char *Rstr2, int Rsize1, int Rsize2, int RsortMethodI)
  {
    int Rti;
    char Rc1, Rc2;
    int Rii;

    switch (RsortMethodI) {
     case 1:
       Rii = strlen(Rstr1);
       if (Rii > strlen(Rstr2)) 
         Rii = strlen(Rstr2);
       for (Rti = 0; Rti < Rii; Rti++) {
         Rc1 = tolower(Rstr1[Rti]);
         Rc2 = tolower(Rstr2[Rti]);
         if (Rc1 > Rc2) return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
         if (Rc1 < Rc2) return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       }
       return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
     case 2:
       Ridx1 = rindex(Rstr1, '.');
       Ridx2 = rindex(Rstr2, '.');

       if (Ridx1 == NULL) return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       if (Ridx2 == NULL) return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));

       Rii = strlen(Ridx1);
       if (Rii > strlen(Ridx2)) 
         Rii = strlen(Ridx2);
       for (Rti = 0; Rti < Rii; Rti++) {
         Rc1 = tolower(Ridx1[Rti]);
         Rc2 = tolower(Ridx2[Rti]);
         if (Rc1 > Rc2) return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
         if (Rc1 < Rc2) return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       }
       return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
     case 3:
       if (Rsize1 > Rsize2) return(Rselected?(RsortReverseR?1:0):(RsortReverseL?1:0));
       else return(Rselected?(RsortReverseR?0:1):(RsortReverseL?0:1));
    }
    return(-1);
  }

  void RrecSortLeft(int Rfirst, int Rlast)
  {
    TTlist *Rtlist;
    int Ri, Rii;

    for (Ri = Rfirst; Ri < Rlast; Ri++)
      for (Rii = Ri; Rii < Rlast; Rii++)
        if (RgetVar(RlistLeft[Ri]->col2, RlistLeft[Rii]->col2, RlistLeft[Ri]->size, RlistLeft[Rii]->size, RsortMethodL)) {
          Rtlist = RlistLeft[Ri];
          RlistLeft[Ri] = RlistLeft[Rii];
          RlistLeft[Rii] = Rtlist;
        }
  }

  void RrecSortRight(int Rfirst, int Rlast)
  {
    TTlist *Rtlist;
    int Ri, Rii;

    for (Ri = Rfirst; Ri < Rlast; Ri++)
      for (Rii = Ri; Rii < Rlast; Rii++)
        if (RgetVar(RlistRight[Ri]->col2, RlistRight[Rii]->col2, RlistRight[Ri]->size, RlistRight[Rii]->size, RsortMethodR)) {
          Rtlist = RlistRight[Ri];
          RlistRight[Ri] = RlistRight[Rii];
          RlistRight[Rii] = Rtlist;
        }
  }

  if (Rcol == RLREMOTE) {      // right
    RDBG("smbc: RsortList RLREMOTE start\n");
    if (RlistRightMax < 1) return;
//    if (RremoteLevel == 3)
     if (RgroupFilesDirectoriesR) {
      RDBG("smbc: RsortList 1\n");
      for (Rr = 1; Rr < RlistRightMax; Rr++) 
       for (Ri = Rr; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Rr]->col1[0] == 'F' && RlistRight[Ri]->col1[0] == 'D') {
           RDBG("smbc: RsortList 2\n");
           Rtlist = RlistRight[Rr];
           RlistRight[Rr] = RlistRight[Ri];
           RlistRight[Ri] = Rtlist;
         }
      Rr = 1; 
      RDBG("smbc: RsortList 3\n");
      if (RlistRightMax > Rr)
      while (RlistRight[Rr]->col1[0] == 'D') {
        RDBG("smbc: RsortList 3.1\n");
        RDBG(RlistRight[Rr]->col1);
        RDBG("smbc: RsortList 3.2\n");
        if (Rr+1 <= RlistRightMax-1) Rr++;
        else break;
      }
      RDBG("smbc: RsortList 4\n");
      RrecSortRight(1, Rr); 
      RDBG("smbc: RsortList 5\n");
      RrecSortRight(Rr, RlistRightMax); 
      RDBG("smbc: RsortList 6\n");
    }
    else RrecSortRight(1, RlistRightMax);
    RDBG("smbc: RsortList RLREMOTE stop\n");
  }
  else {           // left
    RDBG("smbc: RsortList RLLOCAL start\n");
    if (RlistLeftMax < 2) return;
    if (RgroupFilesDirectoriesL) {
      for (Rr = 1; Rr < RlistLeftMax; Rr++) 
        for (Ri = Rr; Ri < RlistLeftMax; Ri++) 
          if (RlistLeft[Rr]->col1[0] == 'F' && RlistLeft[Ri]->col1[0] == 'D') {
            Rtlist = RlistLeft[Rr];
            RlistLeft[Rr] = RlistLeft[Ri];
            RlistLeft[Ri] = Rtlist;
          }
      Rr = 1; 
      while (RlistLeft[Rr]->col1[0] == 'D') 
        if (Rr+1 <= RlistLeftMax-1) Rr++;
        else break;
      RrecSortLeft(1, Rr); 
      RrecSortLeft(Rr, RlistLeftMax); 
    }
    else RrecSortLeft(1, RlistLeftMax); 
    RDBG("smbc: RsortList RLLOCAL stop\n");
  }
}

void RinitList(int Rnr, int Rwhat, RLTYPE Rcol)   // Rcol 0 - left(local)     1 - right(remote)
                                                  // Rwat 0 - groups   1 - hosts   2 - shares  3 - dirs
{
  int Ri, Rtmp, Rtmp1;

  if (Rcol == RLLOCAL) { for (Ri = 0; Ri < RlistLeftMax; Ri++) realloc(RlistLeft[Ri], sizeof(TTlist)); RlistLeftMax = -1; }
  else { for (Ri = 0; Ri < RlistRightMax; Ri++) realloc(RlistRight[Ri], sizeof(TTlist)); RlistRightMax = -1; }
  if (Rcol == RLLOCAL) { 
    for (Ri = 0; Ri < RlistLeftMax; Ri++)
      realloc(RlistLeft[Ri], sizeof(TTlist));
    RlistLeftMax = 0;
    RlistLeft[RlistLeftMax] = malloc(sizeof(TTlist)); 
    memcpy(RlistLeft[RlistLeftMax]->col1, "D", 2);
    memcpy(RlistLeft[RlistLeftMax]->col2, "..", 3);
    memcpy(RlistLeft[RlistLeftMax]->col3, "", 1);
    RlistLeft[RlistLeftMax]->select = 0;
    for (Ri = 0; Ri < Rnr; Ri++) {
      RlistLeft[++RlistLeftMax] = malloc(sizeof(TTlist)); 
      switch (Rwhat) {
        case 0: if (RfilesL[Ri]->type == RTFILE) memcpy(RlistLeft[RlistLeftMax]->col1, "F", 2); 
                else memcpy(RlistLeft[RlistLeftMax]->col1, "D", 2); 
                memcpy(RlistLeft[RlistLeftMax]->col3, RfilesL[Ri]->sizeShow, strlen(RfilesL[Ri]->sizeShow)); 
                Rtmp = strlen(RfilesL[Ri]->filename); Rtmp1 = Rtmp;
                memcpy(RlistLeft[RlistLeftMax]->col2, RfilesL[Ri]->filename, Rtmp+1);
                RlistLeft[RlistLeftMax]->size = RfilesL[Ri]->size;
                RlistLeft[RlistLeftMax]->select = 0;
                if (Ri+1 == Rnr) RlistLeftMax++;
                break;
      }
    }
  }
  else {
    RDBG("smbc: RinitList REMOTE start\n");
    for (Ri = 0; Ri < RlistRightMax; Ri++)
       realloc(RlistRight[Ri], sizeof(TTlist));
      RlistRightMax = 0;
      RlistRight[RlistRightMax] = malloc(sizeof(TTlist)); 
      memcpy(RlistRight[RlistRightMax]->col1, "D", 2);
      memcpy(RlistRight[RlistRightMax]->col2, "..", 3);
      memcpy(RlistRight[RlistRightMax]->col3, "", 1);
      RlistRight[RlistRightMax]->select = 0;
      for (Ri = 0; Ri < Rnr; Ri++) {
      RlistRight[++RlistRightMax] = malloc(sizeof(TTlist)); 
      RlistRight[RlistRightMax]->select = 0;
      switch (Rwhat) {
        case 0: memcpy(RlistRight[RlistRightMax]->col1, "W", 2); 
                memcpy(RlistRight[RlistRightMax]->col2, Rgroups[Ri]->groupname, strlen(Rgroups[Ri]->groupname)+1);
                memcpy(RlistRight[RlistRightMax]->col3, "\0", 1);
                RlistRight[RlistRightMax]->size = 0;
                break;
        case 1: memcpy(RlistRight[RlistRightMax]->col1, "H", 2); 
                memcpy(RlistRight[RlistRightMax]->col3, "", 1); 
                Rtmp = strlen(Rhosts[Ri]->hostname); Rtmp1 = Rtmp;
                memcpy(RlistRight[RlistRightMax]->col2, Rhosts[Ri]->hostname, Rtmp+1);
                memcpy(RlistRight[RlistRightMax]->col4, Rhosts[Ri]->hostname, Rtmp+1);
                RlistRight[RlistRightMax]->size = 0;
                Rtmp = strlen(Rhosts[Ri]->comment); 
                if (Rtmp > 0) {
                  memcpy(RlistRight[RlistRightMax]->col2+Rtmp1, " | ", 3);
                  Rtmp1 += 3;
                  memcpy(RlistRight[RlistRightMax]->col2+Rtmp1, Rhosts[Ri]->comment, Rtmp+1);
                }
                break;
        case 2: memcpy(RlistRight[RlistRightMax]->col1, "S", 2); 
                memcpy(RlistRight[RlistRightMax]->col3, "", 1); 
                Rtmp = strlen(Rshares[Ri]->sharename); Rtmp1 = Rtmp;
                memcpy(RlistRight[RlistRightMax]->col2, Rshares[Ri]->sharename, Rtmp);
                memcpy(RlistRight[RlistRightMax]->col4, Rshares[Ri]->sharename, Rtmp+1);
                RlistRight[RlistRightMax]->size = 0;
                Rtmp = strlen(Rshares[Ri]->comment); 
                if (Rtmp > 0) {
                  memcpy(RlistRight[RlistRightMax]->col2+Rtmp1, " | ", 3);
                  Rtmp1 += 3;
                  memcpy(RlistRight[RlistRightMax]->col2+Rtmp1, Rshares[Ri]->comment, Rtmp);
                }
                memcpy(RlistRight[RlistRightMax]->col2+Rtmp1+Rtmp, "\0", 1);
                break;
        case 3: if (Rfiles[Ri]->type == RTFILE) memcpy(RlistRight[RlistRightMax]->col1, "F", 2); 
                else memcpy(RlistRight[RlistRightMax]->col1, "D", 2); 
                memcpy(RlistRight[RlistRightMax]->col3, Rfiles[Ri]->sizeShow, strlen(Rfiles[Ri]->sizeShow)+1); 
                Rtmp = strlen(Rfiles[Ri]->filename); Rtmp1 = Rtmp;
                memcpy(RlistRight[RlistRightMax]->col2, Rfiles[Ri]->filename, Rtmp+1);
                RlistRight[RlistRightMax]->size = Rfiles[Ri]->size;
                break;
      }
      }
      RlistRightMax++;
    RDBG("smbc: RinitList REMOTE stop\n");
  }
  RDBG("smbc: RinitList before RsortList(Rcol);\n");
  RsortList(Rcol);
  RDBG("smbc: RinitList after RsortList(Rcol);\n");
}

void RsetColorExt(WINDOW *Rwin, char *Rstr, char Rset)
{
  int Ri, Rmax, Rfind;
  char Rextm[10];
  int Rt = strlen(Rstr);
  TText *RextT = Rext;

  Rextm[0] = 0;
  if (Rt > 10) Rmax = 10;
  else Rmax = Rt;

  Ri = 0; 
  Rfind = 1;
  while ((Ri < Rmax) & Rfind) {
    if ((Ri > 0) && (Rstr[Rt-Ri-1] == '.')) {
      memcpy(Rextm, Rstr+Rt-Ri, Ri+2);
      Rfind = 0;
    }
    Ri++;
  }

  if (strlen(Rextm)) {
    while (RextT) {
      if (RstrCmp(RextT->ext,Rextm)) {
        if (Rset) { 
           wattron(Rwin, COLOR_PAIR(10+RextT->colornr));
        }
        else wattroff(Rwin, COLOR_PAIR(10+RextT->colornr));
      }
      RextT = RextT->Text;
    } 
  }
}

void RwriteMenuTxt(int Rfirst, int Rwhat, RLTYPE Rcol, int Rselect)  // Rcol = 0  left
{
  int Ry, Rx, Ri, Rk;
  char Rinfo[1000];
  int Ridx = 0;
  int Rnr, Dnr;
  
  RDBG("smbc: RwriteMenuTxt start\n");
  if (Rcol == RLLOCAL) Rnr = RlistLeftMax;
  else Rnr = RlistRightMax;
  mvwhline(RwinLeftTop, 0, 0, 0, RxHalf-2);
  mvwhline(RwinRightTop, 0, 0, 0, RxHalf-2);
  getmaxyx(RwinLeftCol2, Ry, Rx); Rk = Ry;
  if ((Rnr-Rfirst) < Ry) Ry = Rnr-Rfirst;
  if (RlistLeftMax == 0) Dnr = 1;
  else Dnr = 0;
  if (Rcol == RLLOCAL) { 
    for (Ri = 0; Ri < Ry+Dnr; Ri++) {
      if (RlistLeft[Ri+Rfirst]->select) { 
        wattron(RwinLeftCol1, COLOR_PAIR(2)); 
        wattron(RwinLeftCol2, COLOR_PAIR(2)); 
        wattron(RwinLeftCol3, COLOR_PAIR(2)); 
      }
      if (Rselected == RLLOCAL) {
        if (Ri == Rselect) { 
          wattron(RwinLeftCol1, COLOR_PAIR(1)); 
          wattron(RwinLeftCol2, COLOR_PAIR(1)); 
          wattron(RwinLeftCol3, COLOR_PAIR(1)); 
        }
        if ((RlistLeft[Ri+Rfirst]->select) && (Ri == Rselect)) { 
          wattron(RwinLeftCol1, COLOR_PAIR(3)); 
          wattron(RwinLeftCol2, COLOR_PAIR(3)); 
          wattron(RwinLeftCol3, COLOR_PAIR(3)); 
        }
      }
      mvwhline(RwinLeftCol1, Ri, 0, 32, 1);
      mvwhline(RwinLeftCol2, Ri, 0, 32, RxHalf-10);
      mvwhline(RwinLeftCol3, Ri, 0, 32, 5);
      mvwprintw(RwinLeftCol1,Ri,0,RlistLeft[Ri+Rfirst]->col1); 

      if ((Ri != Rselect) & (!RlistLeft[Ri+Rfirst]->select)) RsetColorExt(RwinLeftCol2, RlistLeft[Ri+Rfirst]->col2, 1);
      mvwprintw(RwinLeftCol2,Ri,0,RFS(RlistLeft[Ri+Rfirst]->col2)); 
      if ((Ri != Rselect) & (!RlistLeft[Ri+Rfirst]->select)) RsetColorExt(RwinLeftCol2, RlistLeft[Ri+Rfirst]->col2, 0);

      mvwprintw(RwinLeftCol3,Ri,0,RlistLeft[Ri+Rfirst]->col3); 
      if (RlistLeft[Ri+Rfirst]->select) { 
        wattroff(RwinLeftCol1, COLOR_PAIR(2)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(2)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(2)); 
      }
      if (Ri == Rselect) { 
        wattroff(RwinLeftCol1, COLOR_PAIR(1)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(1)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(1)); 
      }
      if ((RlistLeft[Ri+Rfirst]->select) && (Ri == Rselect)) { 
        wattroff(RwinLeftCol1, COLOR_PAIR(3)); 
        wattroff(RwinLeftCol2, COLOR_PAIR(3)); 
        wattroff(RwinLeftCol3, COLOR_PAIR(3)); 
      }
    }
    switch (Rwhat) {
      case 0: memcpy(Rinfo, RadirL, strlen(RadirL)+1);
              mvwprintw(RwinLeftTop,0,0,RFS(Rinfo)); 
              break;
    }
    getmaxyx(RwinLeftCol2, Ry, Rx);
    for (Ri = Rnr-Rfirst+Dnr; Ri < Ry; Ri++) {
      mvwhline(RwinLeftCol1, Ri, 0, 32, 1);
      mvwhline(RwinLeftCol2, Ri, 0, 32, RxHalf-10);
      mvwhline(RwinLeftCol3, Ri, 0, 32, 5);
    }
    wrefresh(RwinLeftTop);
    wrefresh(RwinLeftCol1);
    wrefresh(RwinLeftCol2);
    wrefresh(RwinLeftCol3);
  }
  else {
    RDBG("smbc: RwriteMenuTxt remote start paint\n");
    if (RlistRightMax == 0) Dnr = 1;
    else Dnr = 0;
    for (Ri = 0; Ri < Rk; Ri++) {
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf+Rdx-10);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5);
    }
    RDBG("smbc: RwriteMenuTxt remote, berofe main for\n");
    for (Ri = 0; Ri < Ry+Dnr; Ri++) {
      RDBG("smbc: RwriteMenuTxt remote, berofe if (RlistRight[Ri+Rfirst]->select)\n");
      if (RlistRight[Ri+Rfirst]->select) { 
        wattron(RwinRightCol1, COLOR_PAIR(2)); 
        wattron(RwinRightCol2, COLOR_PAIR(2)); 
        wattron(RwinRightCol3, COLOR_PAIR(2)); 
      }
      RDBG("smbc: RwriteMenuTxt remote, after if (RlistRight[Ri+Rfirst]->select)\n");
      if (Rselected == RLREMOTE) {
        if (Ri == Rselect) { 
          wattron(RwinRightCol1, COLOR_PAIR(1)); 
          wattron(RwinRightCol2, COLOR_PAIR(1)); 
          wattron(RwinRightCol3, COLOR_PAIR(1)); 
        }
        RDBG("smbc: RwriteMenuTxt remote, before if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect))\n");
        if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect)) {
          wattron(RwinRightCol1, COLOR_PAIR(3)); 
          wattron(RwinRightCol2, COLOR_PAIR(3)); 
          wattron(RwinRightCol3, COLOR_PAIR(3)); 
        }
        RDBG("smbc: RwriteMenuTxt remote, after if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect))\n");
      }
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);                     // make line
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf-10+Rdx);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5); 

      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol1,Ri,0,RlistRight[Ri+Rfirst]->col1)\n");
      mvwprintw(RwinRightCol1,Ri,0,RlistRight[Ri+Rfirst]->col1); 
      RDBG("smbc: RwriteMenuTxt remote, after mvwprintw(RwinRightCol1,Ri,0,RlistRight[Ri+Rfirst]->col1)\n");

      if ((Ri != Rselect) & (!RlistRight[Ri+Rfirst]->select)) RsetColorExt(RwinRightCol2, RlistRight[Ri+Rfirst]->col2, 1);
      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol2,Ri,0,RFS(RlistRight[Ri+Rfirst]->col2))\n");
      mvwprintw(RwinRightCol2,Ri,0,RFS(RlistRight[Ri+Rfirst]->col2)); 
      RDBG("smbc: RwriteMenuTxt remote, after mvwprintw(RwinRightCol2,Ri,0,RFS(RlistRight[Ri+Rfirst]->col2))\n");
      if ((Ri != Rselect) & (!RlistRight[Ri+Rfirst]->select)) RsetColorExt(RwinRightCol2, RlistRight[Ri+Rfirst]->col2, 0);

      RDBG("smbc: RwriteMenuTxt remote, before mvwprintw(RwinRightCol3,Ri,0,RlistRight[Ri+Rfirst]->col3)\n");
      mvwprintw(RwinRightCol3,Ri,0,RlistRight[Ri+Rfirst]->col3); 
      if (RlistRight[Ri+Rfirst]->select) { 
        wattroff(RwinRightCol1, COLOR_PAIR(2)); 
        wattroff(RwinRightCol2, COLOR_PAIR(2)); 
        wattroff(RwinRightCol3, COLOR_PAIR(2)); 
      }
      if (Ri == Rselect) { 
        wattroff(RwinRightCol1, COLOR_PAIR(1)); 
        wattroff(RwinRightCol2, COLOR_PAIR(1)); 
        wattroff(RwinRightCol3, COLOR_PAIR(1)); 
      }
      if ((RlistRight[Ri+Rfirst]->select) && (Ri == Rselect)) { 
        wattroff(RwinRightCol1, COLOR_PAIR(3)); 
        wattroff(RwinRightCol2, COLOR_PAIR(3)); 
        wattroff(RwinRightCol3, COLOR_PAIR(3)); 
      }
    }
    switch (Rwhat) {
      case 0: mvwprintw(RwinRightTop,0,0,"//"); 
              break;
      case 1: memcpy(Rinfo, "//", 2); Ridx = 2;
              memcpy(Rinfo+Ridx, Ragroup, strlen(Ragroup)); Ridx += strlen(Ragroup);
              memcpy(Rinfo+Ridx, "/\0", 2);
              mvwprintw(RwinRightTop,0,0,RFS(Rinfo)); 
              break;
      case 2: memcpy(Rinfo, "//", 2); Ridx = 2;
              memcpy(Rinfo+Ridx, Ragroup, strlen(Ragroup)); Ridx += strlen(Ragroup);
              memcpy(Rinfo+Ridx, "/", 1); Ridx += 1;
              memcpy(Rinfo+Ridx, Rahost, strlen(Rahost)); Ridx += strlen(Rahost);
              memcpy(Rinfo+Ridx, "/\0", 2);
              mvwprintw(RwinRightTop,0,0,RFS(Rinfo)); 
              break;
      case 3: memcpy(Rinfo, "//", 2); Ridx = 2;
              memcpy(Rinfo+Ridx, Ragroup, strlen(Ragroup)); Ridx += strlen(Ragroup);
              memcpy(Rinfo+Ridx, "/", 1); Ridx += 1;
              memcpy(Rinfo+Ridx, Radir+6, strlen(Radir)-6); Ridx += strlen(Radir)-6;
              memcpy(Rinfo+Ridx, "\0", 1); 
              mvwprintw(RwinRightTop,0,0,RFS(Rinfo));
              break; 
    }
    getmaxyx(RwinLeftCol2, Ry, Rx);
    for (Ri = Rnr-Rfirst+Dnr; Ri < Ry; Ri++) {
      mvwhline(RwinRightCol1, Ri, 0, 32, 1);
      mvwhline(RwinRightCol2, Ri, 0, 32, RxHalf+Rdx-10);
      mvwhline(RwinRightCol3, Ri, 0, 32, 5);
    }
    wrefresh(RwinRightTop);
    wrefresh(RwinRightCol1);
    wrefresh(RwinRightCol2);
    wrefresh(RwinRightCol3);
  }
  curs_set(0);
  RDBG("smbc: RwriteMenuTxt finished\n");
}

int RchdirL(char *Rstr, char *Rdir)
{
  int Ri, Rtmp;

  if (RstrCmp(Rdir, "..")) {
    Rtmp = strlen(Rstr)-2;
    if (Rtmp > 0) {
      for (Ri = 0; Ri < Rtmp+1; Ri++) {
        if (Rstr[Rtmp-Ri] == '/') {
          Rstr[Rtmp-Ri+1] = 0;
          return (0);
        }
      } 
    }
  } 
  else {
     Ri = strlen(Rdir);
     Rstr += strlen(Rstr);
     memcpy(Rstr, Rdir, Ri); Rstr += Ri;
     memcpy(Rstr, "/\0", 2);
  }
  return (0);
}

void RgetSmallPath(char *Rdst)
{
  int Rtmp = 6;
  
  memcpy(Rdst, "smb://", Rtmp); Rdst += Rtmp;
  Rtmp = strlen(Rahost);
  memcpy(Rdst, Rahost, Rtmp); Rdst += Rtmp;
  memcpy(Rdst, "/", 2);
}

void RdoWindowResize()
{
  if (RdoResize) {
    RdoResize = 0;

    RleftPos = 0;
    RrightPos = 0;
    RleftFirst = 0;
    RrightFirst = 0;

    RwriteMenu(1);
    RwriteMenu(1);
    RwriteMenuTxt(RleftFirst,RremoteLevel,RLLOCAL,RleftPos);
    RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
    keypad(RwinMain, TRUE);
    nodelay(RwinMain,1);
  }
}

void resizeHandler(int sig) 
{
  RdoResize = 1;
  RdoResizeFind = 1;
  RdoResizeDownload = 1;
  RdoResizeBookmark = 1;
}

int RdownloadUpload()
{
  int Ri, Rii;
  TTdownload *RdownloadListTmp = RdownloadList;
  char *Rstr, *Rstr2, *Rbuf;
  struct stat Rlocalstat, Rremotestat;
  char RstrS[1000];
  off_t R2, R1;
  ssize_t Rbread21, Rbread22;
  int RbufSize;
  char *Rbuf21;
  char *Rbuf22;
  char *Rtstr;
  int Rerr;
  ssize_t Rbread;
  time_t Rtt;
  long int RtimeRt;
  int Rbwrite;
  char *Rmsg31 = _(" complete file ");

  RDBG("smbc: RdownloadUpload start\n");
  void RremoveActFromListAndCloseFiles()
  {
    if (RdownloadListAct->RdownloadListP != NULL)
       RdownloadListAct->RdownloadListP->RdownloadList = RdownloadListAct->RdownloadList;
    if (RdownloadListAct->RdownloadList != NULL)
       RdownloadListAct->RdownloadList->RdownloadListP = RdownloadListAct->RdownloadListP;
    if (RdownloadListAct == RdownloadList) 
       RdownloadList = RdownloadList->RdownloadList;

    if (RdownloadListAct->upload == 'D') {
      Rsmbc_close(RdownloadHandleR);
      close(RdownloadHandleL);
    }
    else {
      Rsmbc_close(RdownloadHandleL);
      close(RdownloadHandleR);
    }

    free(RdownloadListAct);
    RdownloadHandleL = -1;
    RdownloadHandleR = -1;
    RdownloadListAct = NULL;
  }

  int Rchoice(int Rin, int *Rch) 
  {
    switch (Rin) {
      case 0 : RremoveActFromListAndCloseFiles();    // cancel
               return(0);
      case 1 : if (RdownloadListAct->upload == 'D') {   // overwrite
                 close(RdownloadHandleL);              
                 remove(RdownloadListAct->fullfilename);
                 RdownloadHandleL = open(RdownloadListAct->fullfilename, O_CREAT | O_NONBLOCK | O_RDWR, 0755);
               }
               else {
                 Rsmbc_close(RdownloadHandleL);              
                 Rsmbc_unlink(RdownloadListAct->fullfilename);
                 RdownloadHandleL = Rsmbc_open(RdownloadListAct->fullfilename, O_CREAT | O_NONBLOCK | O_RDWR, 0755);
               }
               if ((fstat(RdownloadHandleL,&Rlocalstat) < 0) && (RdownloadListAct->upload == 'D')) {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               if ((Rsmbc_fstat(RdownloadHandleL,&Rlocalstat) < 0) && (RdownloadListAct->upload == 'U')) { 
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
                 RdownloadHandleL = -1;
                 RdownloadHandleR = -1;
               break;
               return(1);
      case 2 : RdownloadListAct->active = 'W';            // wait
               if (RdownloadListAct->upload == 'U') {
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               else {
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
               RdownloadHandleL = -1;
               RdownloadHandleR = -1;
               RdownloadListAct = NULL;
               return(0);
      case 4 : *Rch = 0;        // retry without asking
      case 3 : if (RdownloadListAct->upload == 'U') {   // cancel
                 Rsmbc_close(RdownloadHandleR);
                 close(RdownloadHandleL);
               }
               else {
                 Rsmbc_close(RdownloadHandleL);
                 close(RdownloadHandleR);
               }
                 RdownloadHandleL = -1;
                 RdownloadHandleR = -1;
                 RdownloadListAct = NULL;
                 return(0);
     }
    return(1);
  }
 
  if (RdownloadListTmp == NULL) {
     RopenSaveDowloadList(1);
     if (RdownloadList == NULL) {
       RstatusBar(0);
       return(0);
     } else RdownloadListTmp = RdownloadList;
  }
  else {
    if (RdownloadHandleR == -1) {
      RdownloadListAct = NULL; 
      while ((RdownloadHandleR < 0) & (RdownloadListTmp != NULL)) {
        if (RdownloadListTmp->active == 'X') {
          if (RdownloadListTmp->upload == 'D') {
            asprintf(&Rstr, "%s/%s", RdownloadListTmp->pathR, RdownloadListTmp->filename);
            RdownloadHandleR = Rsmbc_open(Rstr, O_RDONLY, 0755);
          }
          else {
            asprintf(&Rstr, "%s/%s", RdownloadListTmp->pathR, RdownloadListTmp->filename);
            RdownloadHandleR = open(Rstr, O_RDONLY, 0755);
          }
          if(RdownloadHandleR < 0) {
             if (RdownloadListTmp->RdownloadList == NULL) {
               RdownloadListAct = NULL;
               RstatusBar(0);
             }
             RdownloadListTmp = RdownloadListTmp->RdownloadList;
          }
          free(Rstr);
        }
        else RdownloadListTmp = RdownloadListTmp->RdownloadList;
      }
      if (RdownloadHandleR > 0) 
        RdownloadListAct = RdownloadListTmp;
    }
    else {
       if ((RdownloadHandleL == -1) &
           (RdownloadHandleR != -1)) {
         if (RdownloadListAct->upload == 'D') {
           if (strlen(RdownloadListAct->pathRbase) != strlen(RdownloadListAct->pathR)) 
             asprintf(&Rstr, "%s%s/%s", RdownloadListAct->pathL,RdownloadListAct->pathR+strlen(RdownloadListAct->pathRbase),RdownloadListAct->filename);
           else asprintf(&Rstr, "%s%s", RdownloadListAct->pathL,RdownloadListAct->filename);
           for (Ri = 0; Ri < strlen(Rstr); Ri++) {
             if (Rstr[Ri] == '/') {
               Rstr2 = strdup(Rstr); 
               Rstr2[Ri+1] = 0;
               mkdir(Rstr2, 0755);
               free(Rstr2);
             }
           }
           RdownloadHandleL = open(Rstr,O_CREAT | O_NONBLOCK | O_RDWR, 0755);
           memcpy(RdownloadListAct->fullfilename, Rstr, strlen(Rstr)+1);
         }
         else {
            asprintf(&Rstr, "%s/%s/%s", RdownloadListAct->pathL,RdownloadListAct->pathR+strlen(RdownloadListAct->pathRbase),RdownloadListAct->filename);
            for (Ri = 0; Ri < strlen(Rstr); Ri++) {
              if (Rstr[Ri] == '/') {
                Rstr2 = strdup(Rstr); 
                Rstr2[Ri+1] = 0;
                Rsmbc_mkdir(Rstr2, 0755);
                free(Rstr2);
              }
            }
            RdownloadHandleL = Rsmbc_open(Rstr,O_CREAT | O_NONBLOCK | O_RDWR, 0755);
         }
         free(Rstr);
         if (RdownloadHandleL < 0) {
           RdownloadHandleL = -1;
           return(0);
         }
       }
       else {
         if (RdownloadListAct->upload == 'D') {
           if ((Rsmbc_fstat(RdownloadHandleR,&Rremotestat) < 0) || (fstat(RdownloadHandleL,&Rlocalstat) < 0)) {  
             Rsmbc_close(RdownloadHandleR);
             close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         else {
           if ((fstat(RdownloadHandleR,&Rremotestat) < 0) || (Rsmbc_fstat(RdownloadHandleL,&Rlocalstat) < 0)) {  
             close(RdownloadHandleR);
             Rsmbc_close(RdownloadHandleL);
             RdownloadHandleL = -1;
             RdownloadHandleR = -1;
           }
         }
         if ((int)Rlocalstat.st_size < (int)Rremotestat.st_size) {
           getHumanSize(RdownloadListAct->sizeDisplayDownR, (int)Rremotestat.st_size-Rlocalstat.st_size);
           if ((int)(Rremotestat.st_size)/1024 > 0) itoa(RdownloadListAct->percent,(int)100*(Rlocalstat.st_size/1024)/(Rremotestat.st_size/1024));
           else memcpy(RdownloadListAct->percent,"0",2);
           RdownloadListAct->percent[4] = 0;
           itoa(RstrS, RgetdownloadListCount());

           // X, downloading(uploading) xx/s, remaing
           asprintf(&Rtstr, ", %s ", (RdownloadListAct->upload == 'D'?_("downloading"):_("uploading")));

           memcpy(RstrS+strlen(RstrS), Rtstr, strlen(Rtstr)+1);
           getHumanSize(RstrS+strlen(RstrS), RavrSizeDisplay);
           asprintf(&Rtstr, _("/s, remaing "));
           memcpy(RstrS+strlen(RstrS), Rtstr, strlen(Rtstr)+1);
           free(Rtstr);

           // xxs,
           memcpy(RstrS+strlen(RstrS), RdownloadListAct->sizeDisplayDownR, strlen(RdownloadListAct->sizeDisplayDownR)+1);
           memcpy(RstrS+strlen(RstrS), ", ", 3);
          
           // time
           if (RavrSizeDisplay > 0)
             RtimeRt = (Rremotestat.st_size-Rlocalstat.st_size)/(RavrSizeDisplay);
           else RtimeRt = 0;
           RtimeR = (RtimeR+RtimeRt)/2;
             RtimeRt = RtimeR % 60;
             RtimeR = RtimeR/60;
             itoa(RstrS+strlen(RstrS), RtimeR);
             memcpy(RstrS+strlen(RstrS), ".", 2);
             itoa(RstrS+strlen(RstrS), RtimeRt);
             memcpy(RstrS+strlen(RstrS), _("m, "), 4);

           // percent
           memcpy(RstrS+strlen(RstrS), RdownloadListAct->percent, strlen(RdownloadListAct->percent)+1);
           memcpy(RstrS+strlen(RstrS), "%%", 3);
           memcpy(RstrS+strlen(RstrS), Rmsg31, strlen(Rmsg31)+1);
           memcpy(RstrS+strlen(RstrS), RdownloadListAct->filename, strlen(RdownloadListAct->filename)+1);
           //RstatusBar(-1);
           Ri = Rx - strlen(RstrS);
           if (Ri > 0) {
             for (Rii = 0; Rii < Ri; Rii++) 
               memcpy(RstrS+strlen(RstrS), " ", 2);
           }
           mvwprintw(RwinStatus,0,0,RFS(RstrS)); wrefresh(RwinStatus);

           if ((int)Rlocalstat.st_size > 0) {
             if ((int)Rlocalstat.st_size > 1024) RbufSize = 1024; 
             else RbufSize = (int)Rlocalstat.st_size;
             Rbuf21 = malloc(RbufSize);
             Rbuf22 = malloc(RbufSize);
             Ri = (int)Rlocalstat.st_size-RbufSize;
             if (RdownloadListAct->upload == 'D') {
               R2 = lseek(RdownloadHandleL, Ri, SEEK_SET);
               R1 = Rsmbc_lseek(RdownloadHandleR, Ri, SEEK_SET);
               Rbread21 = Rsmbc_read(RdownloadHandleR, Rbuf21, RbufSize);
               Rbread22 = read(RdownloadHandleL, Rbuf22, RbufSize);
             }
             else {
               R2 = lseek(RdownloadHandleR, Ri, SEEK_SET);
               R1 = Rsmbc_lseek(RdownloadHandleL, Ri, SEEK_SET);
               Rbread21 = read(RdownloadHandleR, Rbuf22, RbufSize);
               Rbread22 = Rsmbc_read(RdownloadHandleL, Rbuf21, RbufSize);
             }
             Rerr = 0;
             if ((Rbread21 == Rbread22) && (Rbread21 >= 0) && (Rbread21 >= 0)) {
               if (memcmp(Rbuf21,Rbuf22,Rbread21) != 0) Rerr = 1;
             }
             else {
               if (Rbread21 != RbufSize) Rerr = 2;
               else Rerr = 3;
             }
             if (R1 != R2) Rerr = 2;
             free(Rbuf21);
             free(Rbuf22);
             if (Rerr) 
               if (!Rchoice(RaskRetry == 1?RshowMessage((Rerr == 1?5:6),1,(Rerr == 2?_("read"):_("write")),"",RdownloadListAct):4, &RaskRetry)) {
                 RDBG("smbc: RdownloadUpload return 1\n");
                 return(0);
               }
           } 
           Rbuf = malloc(64000);
           if (RdownloadListAct->upload == 'D') {
             lseek(RdownloadHandleL, Rlocalstat.st_size, SEEK_SET);
             Rsmbc_lseek(RdownloadHandleR, Rlocalstat.st_size, SEEK_SET);
             Rbread = Rsmbc_read(RdownloadHandleR, Rbuf, 64000);
             Rbwrite = write(RdownloadHandleL, Rbuf, Rbread);
             if (Rbwrite != Rbread) 
               if (!Rchoice(RaskRetryDiskFull == 1?Rerr = RshowMessage(9,1,_("local"), NULL, NULL):4, &RaskRetryDiskFull)) {
                 free(Rbuf);
                 RDBG("smbc: RdownloadUpload return 2\n");
                 return(0);
               }
           }
           else {
             lseek(RdownloadHandleR, Rlocalstat.st_size, SEEK_SET);
             Rsmbc_lseek(RdownloadHandleL, Rlocalstat.st_size, SEEK_SET);
             Rbread = read(RdownloadHandleR, Rbuf, 64000);
             Rbwrite = Rsmbc_write(RdownloadHandleL, Rbuf, Rbread);
             if (Rbwrite != Rbread) 
               if (!Rchoice(RaskRetryDiskFull == 1?Rerr = RshowMessage(9,1,_("remote"), NULL, NULL):4, &RaskRetryDiskFull)) {
                 free(Rbuf);
                 RDBG("smbc: RdownloadUpload return 3\n");
                 return(0);
               }
           }

           Rtt = time(NULL);
           if (RavrTime != Rtt) {
             RavrTime = Rtt;
             RavrSizeDisplay = (10*RavrSizeDisplay+RavrSize)/11;
             RavrSize = Rbread;
           } 
           else RavrSize+= Rbread;

           free(Rbuf);
         } 
         else RremoveActFromListAndCloseFiles();
       }
    }
  }
  RDBG("smbc: RdownloadUpload return last\n");
  return(0);
}

int RcreateFileFromDirR(char *RadirL, char *RadirRbase, char *Rfilename, char *Rworkgroup, char Rtype)
{
  char *RnewNameR;
  int Rys = 6;
  int Rxs = 78;
  WINDOW *RwinAdd = NULL;
  char *Rstr1 = _("Adding files to download list...");

  void RsmbDownloadFile(char *RadirR, char *Rfilename)
  {
    int Rfilehandle;
    struct stat Rremotestat;
    TTdownload *RdownloadListTmp;
    char *Rname;

    asprintf(&Rname, "%s%s", RadirR, Rfilename);
    Rfilehandle = Rsmbc_open(Rname, O_RDONLY, 0755);
    if (Rsmbc_fstat(Rfilehandle, &Rremotestat) >= 0) {
         RdownloadListTmp = RgetdownloadListLast();
         if (RdownloadListTmp == NULL) {
           RdownloadListTmp = malloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadListP = NULL;
           RdownloadListTmp->RdownloadList = NULL;
           RdownloadList = RdownloadListTmp;
         }
         else {
           RdownloadListTmp->RdownloadList = malloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
           RdownloadListTmp = RdownloadListTmp->RdownloadList;
           RdownloadListTmp->RdownloadList = NULL;
         }
         memcpy(RdownloadListTmp->groupnameR, Rworkgroup, strlen(Rworkgroup)+1);
         memcpy(RdownloadListTmp->pathL, RadirL, strlen(RadirL)+1);
         memcpy(RdownloadListTmp->pathR, RadirR, strlen(RadirR)+1);
         RdownloadListTmp->upload = 'D';
         memcpy(RdownloadListTmp->pathRbase, RadirRbase, strlen(RadirRbase)+1);
         memcpy(RdownloadListTmp->filename, Rfilename, strlen(Rfilename)+1);
         RdownloadListTmp->sizeR = Rremotestat.st_size;
         getHumanSize(RdownloadListTmp->sizeDisplayR, Rremotestat.st_size);
         getHumanSize(RdownloadListTmp->sizeDisplayDownR, Rremotestat.st_size);
         memcpy(RdownloadListTmp->percent, "0",2);
         RdownloadListTmp->active = 'X';
    }
    free(Rname);
    Rsmbc_close(Rfilehandle);
  }

  int RsmbDownloadDir(char *Rname)
  {
    struct smbc_dirent *Rdirent;
    int Rdirhandle, Rfilehandle;
    char *RnewName;
    struct stat Rremotestat;
    TTdownload *RdownloadListTmp;
    char *RnameShort;
    int RnameL, Rtym;
    
    Rdirhandle = Rsmbc_opendir(Rname);
    if(Rdirhandle < 1) return(-1);
    while((Rdirent = Rsmbc_readdir(Rdirhandle))) {
      if(RstrCmp(Rdirent->name, ".") || RstrCmp(Rdirent->name, "..")) continue;
      asprintf(&RnewName, "%s/%s", Rname, Rdirent->name); 
      switch(Rdirent->smbc_type) {
        case SMBC_DIR:
             RsmbDownloadDir(RnewName);
             break;
        case SMBC_FILE:

             asprintf(&RnameShort, "%s", RnewName);
             RnameL = strlen(RnameShort)+1;
             Rtym = RnameL-1;
             if (Rtym > Rxs-4) Rtym = Rxs-4;
             RnameShort[Rtym] = 0;
             mvwhline(RwinAdd, 3, 1, ' ', Rxs-2);
             mvwprintw(RwinAdd, 3, Rxs/2-strlen(RnameShort)/2, RnameShort);
             wrefresh(RwinAdd);
             realloc(RnameShort, RnameL);

             Rfilehandle = Rsmbc_open(RnewName, O_RDONLY, 0755);
             if (Rsmbc_fstat(Rfilehandle, &Rremotestat) >= 0) {
               RdownloadListTmp = RgetdownloadListLast();
               if (RdownloadListTmp == NULL) {
                 RdownloadListTmp = malloc(sizeof(TTdownload));
                 RdownloadList = RdownloadListTmp;
                 RdownloadListTmp->RdownloadList = NULL; 
                 RdownloadListTmp->RdownloadListP = NULL; 
               }
               else {
                 RdownloadListTmp->RdownloadList = malloc(sizeof(TTdownload));
                 RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
                 RdownloadListTmp = RdownloadListTmp->RdownloadList;
                 RdownloadListTmp->RdownloadList = NULL;
               }
               memcpy(RdownloadListTmp->groupnameR, Rworkgroup, strlen(Rworkgroup)+1);
               memcpy(RdownloadListTmp->pathL, RadirL, strlen(RadirL)+1);
               memcpy(RdownloadListTmp->pathR, Rname, strlen(Rname)+1);
               RdownloadListTmp->upload = 'D';
               memcpy(RdownloadListTmp->pathRbase, RadirRbase, strlen(RadirRbase)+1);
               memcpy(RdownloadListTmp->filename, Rdirent->name, strlen(Rdirent->name)+1);
               RdownloadListTmp->sizeR = Rremotestat.st_size;
               getHumanSize(RdownloadListTmp->sizeDisplayR, Rremotestat.st_size);
               getHumanSize(RdownloadListTmp->sizeDisplayDownR, Rremotestat.st_size);
               memcpy(RdownloadListTmp->percent, "0",2);
               RdownloadListTmp->active = 'X';
               Rsmbc_close(Rfilehandle);
             }
             break;
      }
      free(RnewName);
    }
    Rsmbc_closedir(Rdirhandle);
    return 1;
  } 

  RwinAdd = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinAdd, 0, 0);
  mvwprintw(RwinAdd, 1, Rxs/2-strlen(Rstr1)/2, Rstr1);
  wrefresh(RwinAdd);

  if (Rtype == 'D') {
    asprintf(&RnewNameR, "%s%s/", RadirRbase, Rfilename);
    RsmbDownloadDir(RnewNameR);
    free(RnewNameR);
  }
  else RsmbDownloadFile(RadirRbase,Rfilename); 

  delwin(RwinAdd);
  return(0);
}

int RcreateFileFromDirL(char *RadirL, char *RadirR, char *Rfilename, char *Rworkgroup, char Rtype)
{
  char *RnewNameR;
  int Rys = 6;
  int Rxs = 78;
  WINDOW *RwinAdd = NULL;
  char *Rstr1 = _("Adding files to upload list...");

  void RsmbDownloadFile(char *RadirL, char *Rfilename)
  {
    int Rfilehandle;
    struct stat Rlocalstat;
    TTdownload *RdownloadListTmp;
    char *Rname;

    asprintf(&Rname, "%s%s", RadirL, Rfilename);
    Rfilehandle = open(Rname, O_RDONLY, 0755);
    if (fstat(Rfilehandle, &Rlocalstat) >= 0) {
         RdownloadListTmp = RgetdownloadListLast();
         if (RdownloadListTmp == NULL) {
           RdownloadListTmp = malloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadListP = NULL;
           RdownloadListTmp->RdownloadList = NULL;
           RdownloadList = RdownloadListTmp;
         }
         else {
           RdownloadListTmp->RdownloadList = malloc(sizeof(TTdownload));
           RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
           RdownloadListTmp = RdownloadListTmp->RdownloadList;
           RdownloadListTmp->RdownloadList = NULL;
         }
         memcpy(RdownloadListTmp->groupnameR, Rworkgroup, strlen(Rworkgroup)+1);
         memcpy(RdownloadListTmp->pathL, RadirR, strlen(RadirR)+1);
         memcpy(RdownloadListTmp->pathR, RadirL, strlen(RadirL)+1);
         RdownloadListTmp->upload = 'U';
         memcpy(RdownloadListTmp->pathRbase, RadirL, strlen(RadirL)+1);
         memcpy(RdownloadListTmp->filename, Rfilename, strlen(Rfilename)+1);
         RdownloadListTmp->sizeR = Rlocalstat.st_size;
         getHumanSize(RdownloadListTmp->sizeDisplayR, Rlocalstat.st_size);
         getHumanSize(RdownloadListTmp->sizeDisplayDownR, Rlocalstat.st_size);
         memcpy(RdownloadListTmp->percent, "0",2);
         RdownloadListTmp->active = 'X';
    }
    free(Rname);
    close(Rfilehandle);
  }

  int RsmbDownloadDir(char *Rname)
  {
    struct dirent *Rdirent;
    int Rfilehandle;
    DIR *Rdirhandle;
    char *RnewName;
    struct stat Rlocalstat;
    TTdownload *RdownloadListTmp;
    char *RnameShort;
    int RnameL, Rtym;
    
    Rdirhandle = opendir(Rname);
    if(Rdirhandle == NULL) return(-1);
    while((Rdirent = readdir(Rdirhandle))) {
      if(RstrCmp(Rdirent->d_name, ".") || RstrCmp(Rdirent->d_name, "..")) continue;
      asprintf(&RnewName, "%s/%s", Rname, Rdirent->d_name); 
      switch(Rdirent->d_type) {
        case DT_DIR:
             RsmbDownloadDir(RnewName);
             break;
        default:
        
             asprintf(&RnameShort, "%s", RnewName);
             RnameL = strlen(RnameShort)+1;
             Rtym = RnameL-1;
             if (Rtym > Rxs-4) Rtym = Rxs-4;
             RnameShort[Rtym] = 0;
             mvwhline(RwinAdd, 3, 1, ' ', Rxs-2); 
             mvwprintw(RwinAdd, 3, Rxs/2-strlen(RnameShort)/2, RnameShort);
             wrefresh(RwinAdd);
             realloc(RnameShort, RnameL);
             
             Rfilehandle = open(RnewName, O_RDONLY, 0755);
             if (fstat(Rfilehandle, &Rlocalstat) >= 0) {
               RdownloadListTmp = RgetdownloadListLast();
               if (RdownloadListTmp == NULL) {
                 RdownloadListTmp = malloc(sizeof(TTdownload));
                 RdownloadList = RdownloadListTmp;
                 RdownloadListTmp->RdownloadList = NULL; 
                 RdownloadListTmp->RdownloadListP = NULL; 
               }
               else {
                 RdownloadListTmp->RdownloadList = malloc(sizeof(TTdownload));
                 RdownloadListTmp->RdownloadList->RdownloadListP = RdownloadListTmp;
                 RdownloadListTmp = RdownloadListTmp->RdownloadList;
                 RdownloadListTmp->RdownloadList = NULL;
               }
               memcpy(RdownloadListTmp->groupnameR, Rworkgroup, strlen(Rworkgroup)+1);
               memcpy(RdownloadListTmp->pathL, Radir, strlen(Radir)+1);
               memcpy(RdownloadListTmp->pathR, Rname, strlen(Rname)+1);
               RdownloadListTmp->upload = 'U';
               memcpy(RdownloadListTmp->pathRbase, RadirL, strlen(RadirL)+1);
               memcpy(RdownloadListTmp->filename, Rdirent->d_name, strlen(Rdirent->d_name)+1);
               RdownloadListTmp->sizeR = Rlocalstat.st_size;
               getHumanSize(RdownloadListTmp->sizeDisplayR, Rlocalstat.st_size);
               getHumanSize(RdownloadListTmp->sizeDisplayDownR, Rlocalstat.st_size);
               memcpy(RdownloadListTmp->percent, "0",2);
               RdownloadListTmp->active = 'X';
               Rsmbc_close(Rfilehandle);
             }
             break;
      }
      free(RnewName);
    }
    closedir(Rdirhandle);
    return 1;
  } 

  RwinAdd = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinAdd, 0, 0);
  mvwprintw(RwinAdd, 1, Rxs/2-strlen(Rstr1)/2, Rstr1);
  wrefresh(RwinAdd);

  if (Rtype == 'D') {
    asprintf(&RnewNameR, "%s%s/", RadirL, Rfilename);
    RsmbDownloadDir(RnewNameR);
    free(RnewNameR);
  }
  else RsmbDownloadFile(RadirL,Rfilename); 

  delwin(RwinAdd);
  return(0);
}

int Rreadline(register int fd, register char *ptr, register int maxlen) 
{
  int n, rc;
  char c; 
  
  for (n = 1; n < maxlen; n++) {
    if ( (rc = read(fd, &c, 1)) == 1) { 
      *ptr++ = c;
      if (c == '\n')
        break;
    } else if (rc == 0) { 
      if (n == 1)
        return(0);
      else    
        break;
    } else  
      return(-1);
  }

  *ptr = 0;
  return(n);
}

void RreadRcfile()
{
  char *Rfile = NULL;
  int Rfd;
  char Rva[200], Rvl[200];
  char *Rvlp = NULL;
  char Rstr[1000];
  int RstrP;
  char Rtc[20];
  int RstrRvlp, RstrRva;
  int Rline = -1;
  TText *RextT = NULL;
  char Rclr[5];
  int Rwar;

  asprintf(&Rfile, "%s/.smbc/smbcrc", getenv("HOME"));
  if (access(Rfile, F_OK) != 0) {
    printf(_("Can't open config file: %s\n"), Rfile);
    printf(_("More functions and parameters you can set up in this configuration file.\n"));
    printf(_("Example smbcrc file you can find in `docs` directory.\n"));
    return;
  }
  Rfd = open(Rfile, O_RDONLY);
  if (!Rfd) {
    printf(_("Can't open RC file %s, probably access denied.\n"), Rfile);
    exit(0);
  }
  while (Rreadline(Rfd, Rstr, sizeof(Rstr))) {
    Rline++;
    RstrP = -1;
    Rva[0] = 0; Rvl[0] = 0;
    while (Rstr[++RstrP]) {
       if (Rstr[RstrP] == ' ') {
         memcpy(Rva, Rstr, RstrP); memcpy(Rva+RstrP, "\0", 1);
         memcpy(Rvl, Rstr+RstrP+1, strlen(Rstr)-RstrP-1);
         if (Rstr[strlen(Rstr)] == '\n') 
            memcpy(Rvl+strlen(Rstr)-RstrP-3, "\0", 1);
         else memcpy(Rvl+strlen(Rstr)-RstrP-2, "\0", 1);
         if ((Rvl[0] == '"') && (Rvl[strlen(Rvl)-1] == '"')) {
           Rvl[strlen(Rvl)-1] = 0;
           Rvlp = Rvl+1;
         }
         else Rvlp = Rvl;
         break;
       }
    } 
    RstrRvlp = strlen(Rvlp);
    RstrRva = strlen(Rva);
    if ((RstrRva > 0) & (RstrRvlp > 0) & (Rva[0] != '#')) {
      if (RstrCmp(Rva, "username")) memcpy(Rusername, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "password")) memcpy(Rpassword, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "localdir")) memcpy(RadirL, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "workgroup")) memcpy(Ragroup, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "host")) memcpy(Rahost, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "smbclient")) memcpy(Rsmbclient, Rvlp, strlen(Rvlp)+1); 
      if (RstrCmp(Rva, "share")) {
        if (Rvlp[0] == '/') memcpy(Radir, Rvlp+1, strlen(Rvlp)); 
        else  memcpy(Radir, Rvlp, strlen(Rvlp)+1); 
      }
      if (RstrCmp(Rva, "timeout")) Rtimeout = atoi(Rvlp)*1000; 
      if (RstrCmp(Rva, "indextime")) RindexTime = atoi(Rvlp); 
      if (RstrCmp(Rva, "typeofsort-left")) RsortMethodL = atoi(Rvlp); 
      if (RstrCmp(Rva, "typeofsort-right")) RsortMethodR = atoi(Rvlp); 
      if (RstrCmp(Rva, "reversesort-left")) RsortMethodL = atoi(Rvlp); 
      if (RstrCmp(Rva, "reversesort-right")) RsortMethodR = atoi(Rvlp); 
      if (RstrCmp(Rva, "group-left")) RgroupFilesDirectoriesL = atoi(Rvlp); 
      if (RstrCmp(Rva, "group-right")) RgroupFilesDirectoriesR = atoi(Rvlp); 
      if (RstrCmp(Rva, "char-convert")) RDoCharConvert = atoi(Rvlp); 
      if (RstrCmp(Rva, "askquit")) Raskquit = atoi(Rvlp); 
      if (RstrCmp(Rva, "autoresume")) {
        if (RstrCmp(Rvlp, "enable")) RaskRetry = 0; 
        if (RstrCmp(Rvlp, "disable")) RaskRetry = 1; 
      }
      if (RstrCmp(Rva, "warningdiskisfull")) {
        if (RstrCmp(Rvlp, "enable")) RaskRetryDiskFull = 1; 
        if (RstrCmp(Rvlp, "disable")) RaskRetryDiskFull = 0; 
      }

      if ((RstrRva == 6) & (RstrRvlp == 14)) {
        memcpy(Rtc, Rva, 5); Rtc[5] = 0;
        if ((RstrCmp(Rtc, "color")) & (isdigit(Rva[5]) > 0)) {
           Rwar = Rva[5]-48;
           if ((Rwar >= 0) & (Rwar <= 2)) {
             Rclr[4] = 0;
             switch(Rwar) {
               case 0 : Rcolor[Rwar].realnumber = 1;
                        break;
               case 1 : Rcolor[Rwar].realnumber = 4;
                        break;
               case 2 : Rcolor[Rwar].realnumber = 5;
                        break;
             }
             memcpy(Rclr, Rvlp, 4); Rcolor[Rwar].red = atoi(Rclr);
             memcpy(Rclr, Rvlp+5, 4); Rcolor[Rwar].green = atoi(Rclr);
             memcpy(Rclr, Rvlp+10, 4); Rcolor[Rwar].blue = atoi(Rclr);
           }
        }
      }
      if ((RstrRva == 9) & (RstrRvlp > 0) & (RstrRvlp <= 10)) {
        memcpy(Rtc, Rva, 8); Rtc[8] = 0;
        if ((RstrCmp(Rtc, "extcolor")) & (isdigit(Rva[8]) > 0)) {
           Rwar = Rva[8]-48;
           if ((Rwar >= 0) & (Rwar <= 2)) {
            if (Rext == NULL) {
              Rext = malloc(sizeof(TText));
              memcpy(Rext->ext, Rvlp, strlen(Rvlp)+1);
              Rext->colornr = Rwar;
              Rext->Text = NULL; 
              RextT = Rext;
            }
            else {
              RextT->Text = malloc(sizeof(TText));
              RextT = RextT->Text;
              memcpy(RextT->ext, Rvlp, strlen(Rvlp)+1);
              RextT->colornr = Rwar;
              RextT->Text = NULL;
            }
           }
        }
      }
   
    }
  }
  close(Rfd);
  free(Rfile);
}

void RremoveDir(char *Rdir)
{
  DIR *Rdirhandle;
  struct dirent *Rdirent;
  char *RnewName;
  char *Rstr;
  WINDOW *Rdwin;
  int Rys = 7;
  int Rxs = 60;
  int RstrS = 0;

  Rdwin = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(Rdwin,0,0);
  asprintf(&Rstr, _("deleting")); mvwprintw(Rdwin, 2, Rxs/2-strlen(Rstr)/2, RFS(Rstr)); free(Rstr);
  wrefresh(Rdwin);
  Rdirhandle = opendir(Rdir);
  while ((Rdirent = readdir(Rdirhandle))) {
     if(RstrCmp(Rdirent->d_name, ".") || RstrCmp(Rdirent->d_name, "..")) continue;
     asprintf(&RnewName, "%s/%s", Rdir, Rdirent->d_name);
     mvwhline(Rdwin, 4, 1, ' ', Rxs-2);
     if (strlen(RnewName) > Rxs-2) RstrS = strlen(RnewName)-(Rxs-2);
     mvwprintw(Rdwin, 4, Rxs/2-strlen(RnewName+RstrS)/2, RFS(RnewName+RstrS)); wrefresh(Rdwin);
     switch(Rdirent->d_type) {
       case DT_DIR : RremoveDir(RnewName);
                     break;
       default     : unlink(RnewName);
                     break;
     }
     free(RnewName);
  }
  closedir(Rdirhandle);
  rmdir(Rdir);
}

int RremoveDirR(char *Rdir)
{
  int Rdirhandle;
  struct smbc_dirent *Rdirent;
  char *RnewName, *Rstr;
  int Rstat = 0;
  WINDOW *Rdwin;
  int Rys = 7;
  int Rxs = 60;
  int RstrS = 0;

  Rdwin = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(Rdwin,0,0);
  asprintf(&Rstr, _("deleting")); mvwprintw(Rdwin, 2, Rxs/2-strlen(Rstr)/2, RFS(Rstr)); free(Rstr);
  wrefresh(Rdwin);
  if (Rdir[strlen(Rdir)-1] == '/') asprintf(&Rstr, "%s", Rdir);
  else asprintf(&Rstr, "%s/", Rdir);
  Rdirhandle = Rsmbc_opendir(Rstr);
  while ((Rdirent = Rsmbc_readdir(Rdirhandle))) {
    if(RstrCmp(Rdirent->name, ".") || RstrCmp(Rdirent->name, "..")) continue;
    asprintf(&RnewName, "%s%s", Rstr, Rdirent->name);
    mvwhline(Rdwin, 4, 1, ' ', Rxs-2);
    if (strlen(RnewName+4) > Rxs-2) RstrS = strlen(RnewName+4)-(Rxs-2);
    mvwprintw(Rdwin, 4, Rxs/2-strlen(RnewName+RstrS+4)/2, RFS(RnewName+RstrS+4)); wrefresh(Rdwin);
    switch(Rdirent->smbc_type) {
       case SMBC_DIR : Rstat = RremoveDirR(RnewName);
                     break;
       default     : Rstat = Rsmbc_unlink(RnewName);
                     break;
     }
     free(RnewName);
  
  }
  Rsmbc_closedir(Rdirhandle);
  Rstat = Rsmbc_rmdir(Rdir);
  free(Rstr);
  return(Rstat);
}

void RopenSaveDowloadList(int Rnr)  
{
  char *Rfile = NULL;
  char *Rdir = NULL;
  int Rfhandle;
  TTdownload *Rdls;
  int RdlsSize = sizeof(TTdownload);
  DIR *Rdhandle;
  struct dirent *Rsdirent;
  int RdufileNr = 0;
  int RfindF = 1;
  int RfindF2 = 1;
  char RdufileName[1000];
  char RdufileName2[1000];

  RDBG("smbc: RopenSaveDowloadList start\n");
  asprintf(&Rdir, "%s/.smbc/", getenv("HOME"));
  mkdir(Rdir, 0755);
  if (Rnr) {         // read
    printf(_("start reading download/upload list...\n"));
    Rdhandle = opendir(Rdir);
    if (Rdhandle != NULL) {
      RfindF = 1;
      while (RfindF) {
        Rsdirent = readdir(Rdhandle);
        if (Rsdirent > 0) {
          if (strlen(Rsdirent->d_name) >= 6) 
            if (RstrCmpIncludeFirst(Rsdirent->d_name, "dulist")) {
              sprintf(RdufileName, "%s/.smbc/%s", getenv("HOME"),Rsdirent->d_name);
              RfindF = 0;
            }
        }
        else RfindF = 0; 
      }
      closedir(Rdhandle);
    }
    RdownloadList = NULL;
    if (RdufileName != NULL) {
      Rfhandle = open(RdufileName, O_NONBLOCK | O_RDONLY, 0755);
      Rdls = malloc(RdlsSize); 
      while (read(Rfhandle, Rdls, RdlsSize) == RdlsSize) {
        if (RdownloadList == NULL) {
          RdownloadList = malloc(RdlsSize);
          memcpy(RdownloadList, Rdls, RdlsSize);
          RdownloadList->RdownloadList = NULL;
          RdownloadList->RdownloadListP = NULL;
        } else {
          RdownloadList->RdownloadList = malloc(RdlsSize);
          memcpy(RdownloadList->RdownloadList, Rdls, RdlsSize);
          RdownloadList->RdownloadList->RdownloadListP = RdownloadList;
          RdownloadList->RdownloadList->RdownloadList = NULL;
          RdownloadList = RdownloadList->RdownloadList;
        }
      }
      RdownloadList = RgetdownloadListFirst();
      close(Rfhandle);
      unlink(RdufileName);
      free(Rdls);
      free(Rfile);
      printf(_("reading finished\n"));
    }
  } else {           // write
    printf(_("start saving download/upload list...\n"));
    Rdls = RgetdownloadListFirst();
    if (Rdls != NULL) {
      RfindF = 1;
      RdufileNr = 0;
      while (RfindF) {
         memcpy(RdufileName, getenv("HOME"), strlen(getenv("HOME"))+1);
         memcpy(RdufileName+strlen(RdufileName), "/.smbc/", 8);
         memcpy(RdufileName2, "dulist", 7);
         itoa(RdufileName2+strlen(RdufileName2), RdufileNr);
         memcpy(RdufileName+strlen(RdufileName), RdufileName2, strlen(RdufileName2)+1);
         RfindF2 = 1;
         Rdhandle = opendir(Rdir);
         while (RfindF2) {
           Rsdirent = readdir(Rdhandle);
           if (Rsdirent > 0) {
             if (RstrCmp(Rsdirent->d_name, RdufileName2)) {
                RfindF2 = 0;
                RfindF = 1;
             }
           } else {
             RfindF2 = 0;
             RfindF = 0;
           }
         }
         closedir(Rdhandle);
         RdufileNr++;
      }
      Rfhandle = open(RdufileName, O_CREAT | O_NONBLOCK | O_WRONLY | O_TRUNC, 0644);
      while (Rdls) {
        if (write(Rfhandle, Rdls, RdlsSize) != RdlsSize) {
           printf(_("error saving download/upload list\n"));
           exit(0);
        };
        Rdls = Rdls->RdownloadList;
      }
      close(Rfhandle);
    }
    printf(_("saving finished\n"));
  }
  free(Rdir);
  RDBG("smbc: RopenSaveDowloadList finished\n");
}

int RsetManualyLocation(int Rsel,char *group, char *host, char *dir, char *user, char *pass)
{
  WINDOW *RwinMsg;
  int Rys, Rxs;
  int Rkey, Rii;
  char *Rmsg1;
  char *Rstrt; 
  int Rrol = 3;
  int Rxb = 0;
  char Rtgroup[RMAXGHLEN], Rthost[RMAXGHLEN], Rtdir[RMAXDIRLEN], Rtuser[RMAXGHLEN], Rtpass[RMAXGHLEN];
  char Rttgroup[RMAXGHLEN], Rtthost[RMAXGHLEN], Rttdir[RMAXDIRLEN], Rttuser[RMAXGHLEN], Rttpass[RMAXGHLEN];
  char *Rmsg51 = _("workgroup:");
  char *Rmsg52 = _("host:");
  char *Rmsg53 = _("path:");
  char *Rmsg54 = _("username:");
  char *Rmsg55 = _("password:");
  int Rdx = 0;
  int Rctrlp, Rin1, Rin2, Rfirst;
  int RmaxX;

  void Rrefresh(int Rmax, int Rsel)
  {
    int Ri;
    char *Rmsg41 = _("[ OK ]");
    char *Rmsg42 = _("[ Cancel ]");
    int Rall = strlen(Rmsg41)+strlen(Rmsg42);

    memcpy(Rttgroup,Rtgroup, sizeof(Rtgroup)); if (strlen(Rttgroup) > Rmax) Rttgroup[Rmax] = 0;
    memcpy(Rtthost, Rthost, sizeof(Rtthost)); if (strlen(Rtthost) > Rmax) Rtthost[Rmax] = 0;
    memcpy(Rttdir, Rtdir, sizeof(Rtdir)); if (strlen(Rttdir) > Rmax) Rttdir[Rmax] = 0;
    memcpy(Rttuser, Rtuser, sizeof(Rtuser)); if (strlen(Rttuser) > Rmax) Rttuser[Rmax] = 0;
    for (Ri = 0; Ri<strlen(Rtpass); Ri++) Rttpass[Ri] = '*'; Rttpass[Ri] = 0;
    if (strlen(Rttpass) > Rmax) Rttpass[Rmax] = 0;
    wattron(RwinMsg, COLOR_PAIR(2)); 
    mvwhline(RwinMsg, 3, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 3, Rdx+1, RFS(Rttgroup));
    mvwhline(RwinMsg, 4, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 4, Rdx+1, RFS(Rtthost));
    mvwhline(RwinMsg, 5, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 5, Rdx+1, RFS(Rttdir));
    mvwhline(RwinMsg, 6, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 6, Rdx+1, RFS(Rttuser));
    mvwhline(RwinMsg, 7, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 7, Rdx+1, RFS(Rttpass));
    wattroff(RwinMsg, COLOR_PAIR(2)); 
    switch (Rsel) {
       case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg41);
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42)); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
       case 2 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg41)); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42));
                break;
       case 3 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg41));
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42));
                break;
    } 
  }

  //RwinRedrawWithData(); return(0);

  if (Rdx < strlen(Rmsg51)) Rdx = strlen(Rmsg51)+2;
  if (Rdx < strlen(Rmsg52)) Rdx = strlen(Rmsg52)+2;
  if (Rdx < strlen(Rmsg53)) Rdx = strlen(Rmsg53)+2;
  if (Rdx < strlen(Rmsg54)) Rdx = strlen(Rmsg54)+2;
  if (Rdx < strlen(Rmsg55)) Rdx = strlen(Rmsg55)+2;
  memcpy(Rtgroup,group,strlen(group)+1); 
  memcpy(Rthost,host,strlen(host)+1); 
  if (strlen(dir) > 6) memcpy(Rtdir, dir+strlen(Rthost)+6,strlen(dir)-strlen(Rthost)-5); 
  else Rtdir[0] = 0;
  memcpy(Rtuser, user,strlen(user)+1); 
  memcpy(Rtpass, pass,strlen(pass)+1); 

  Rys = 12; Rxs = 60;
  Rxb = Rxs/2+Rdx-3;
  RwinMsg = newwin(Rys,Rxs,Ry/2-Rys/2,Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  asprintf(&Rmsg1, _("Go to")); Rii = Rxs/2-strlen(Rmsg51)/2; mvwprintw(RwinMsg, 1, Rii, "%s",RFS(Rmsg1)); free(Rmsg1);
  Rii = Rdx-strlen(Rmsg51); mvwprintw(RwinMsg, 3, Rii, "%s",RFS(Rmsg51));
  Rii = Rdx-strlen(Rmsg52); mvwprintw(RwinMsg, 4, Rii, "%s",RFS(Rmsg52));
  Rii = Rdx-strlen(Rmsg53); mvwprintw(RwinMsg, 5, Rii, "%s",RFS(Rmsg53));
  Rii = Rdx-strlen(Rmsg54); mvwprintw(RwinMsg, 6, Rii, "%s",RFS(Rmsg54));
  Rii = Rdx-strlen(Rmsg55); mvwprintw(RwinMsg, 7, Rii, "%s",RFS(Rmsg55));
  Rii = 0; Rrefresh(Rxb, Rrol);
  RmaxX = Rxs-Rdx-3;
  wrefresh(RwinMsg);
  nodelay(RwinMsg, 1);
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 3) {
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 3, Rdx+1, Rtgroup, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 5, Rdx+1, Rtdir, RMAXDIRLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 6, Rdx+1, Rtuser, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(RmaxX, Rrol);
      Rin1 = 0; Rin2 = 0; 
      Rfirst = 3; // first and password mode
      while (readlineOneCharNoDelay(RwinMsg, 7, Rdx+1, Rtpass, RMAXGHLEN, RmaxX, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      //readlineWait(RwinMsg, 3, Rdx+1, Rtgroup, RMAXGHLEN, Rxs-Rdx-3,3); Rrefresh(Rxb, Rrol);
      //readlineWait(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, Rxs-Rdx-3,3); Rrefresh(Rxb, Rrol);
      //readlineWait(RwinMsg, 5, Rdx+1, Rtdir, RMAXDIRLEN, Rxs-Rdx-3,3); Rrefresh(Rxb, Rrol);
      //readlineWait(RwinMsg, 6, Rdx+1, Rtuser, RMAXGHLEN, Rxs-Rdx-3,3); Rrefresh(Rxb, Rrol);
      //readlineWait(RwinMsg, 7, Rdx+1, Rtpass, RMAXGHLEN, Rxs-Rdx-3,3); Rrefresh(Rxb, Rrol);

      Rrefresh(RmaxX, --Rrol);
    } else {
      Rkey = mvwgetch(RwinMsg, 1,1);
      if (Rkey == 9) {
        if ((--Rrol) == 0) Rrol = 3;
        Rrefresh(RmaxX, Rrol);
      }
      if (Rkey == 10) {
        if (Rrol == 2) {
          memcpy(group, Rtgroup, strlen(Rtgroup)+1);
          memcpy(host, Rthost, strlen(Rthost)+1);
            if (Rtdir[0] == '/') asprintf(&Rstrt, "smb://%s%s", Rahost, Rtdir);
            else asprintf(&Rstrt, "smb://%s/%s", Rahost, Rtdir);
            memcpy(dir, Rstrt, strlen(Rstrt)+1);
            if (dir[strlen(dir)-1] != '/') { dir[strlen(dir)] = '/'; dir[strlen(dir)+1] = 0; }
            free(Rstrt);
          memcpy(user, Rtuser, strlen(Rtuser)+1);
          memcpy(pass, Rtpass, strlen(Rtpass)+1);
          delwin(RwinMsg);
          RwinRedrawWithData();
          return(1);
        }
        else Rrol = 0;
      }
      if (Rkey == 'q') Rrol = 0;
    }
  } 
  delwin(RwinMsg); 
  RwinRedrawWithData();
  return(0);
}

int RcreateDir(int select, char *Rpath)
{
  int Rys, Rxs;
  WINDOW *RwinMsg;
  const int MAXSTR = 100;
  char RdirT[MAXSTR];
  int Rrol = 3;
  char *Rstr;
  char Rkey;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;
  int Rctrlp;

  void Rrefresh(int Rsel)
  {
    char *Rmsg11 = _("[ OK ]");
    char *Rmsg12 = _("[ Cancel ]");
    int Rall = strlen(Rmsg11)+strlen(Rmsg12);
    int Rii;
    char *RdirTt;

    wattron(RwinMsg, COLOR_PAIR(2));
    mvwhline(RwinMsg, 3, 3, ' ', Rxs-6); 

    RdirTt = strdup(RdirT);
    if (strlen(RdirTt) > Rxs-6) 
      RdirTt[Rxs-6] = 0;
    mvwprintw(RwinMsg, 3, 3, RFS(RdirTt));

    free(RdirTt);
    wattroff(RwinMsg, COLOR_PAIR(2));
    switch(Rsel) {
      case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg11));
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg12)); wattroff(RwinMsg, COLOR_PAIR(1)); 
               break;
      case 2 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg11)); wattroff(RwinMsg, COLOR_PAIR(1)); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg12));
               break;
      case 3 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg11));
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg12));
               break;
    }
  }

  RdirT[0] = 0;
  Rys = 8; Rxs = 50;
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  asprintf(&Rstr, _("Create directory")); mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rstr)/2, RFS(Rstr)); free(Rstr);
  Rrefresh(Rrol);
  nodelay(RwinMsg, 1);
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 3) {
      Rfirst = 1;
      Rin1 = 0;
      Rin2 = 0;
      while (readlineOneCharNoDelay(RwinMsg, 3, 3, RdirT, MAXSTR, Rxs-6, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      //readlineWait(RwinMsg, 3, 3, RdirT, MAXSTR, Rxs-6,3); 
      Rrefresh(--Rrol);
    }
    Rkey = mvwgetch(RwinMsg,1,1);
    if (Rkey == 9) {
      if ((--Rrol) == 0) Rrol = 3;
      Rrefresh(Rrol);
    }
    if (Rkey == 10) {
      if (Rrol == 2) {
        asprintf(&Rstr, "%s/%s", Rpath, RdirT);
        if (select) {
          Rsmbc_mkdir(Rstr, 0755);
        }
        else {
          mkdir(Rstr, 0755);
        }
        free(Rstr);
        delwin(RwinMsg);
        RwinRedrawWithData();
        return(0);
      } else Rrol = 0;
    }
    if (Rkey == 'q') Rrol = 0;
  }
  delwin(RwinMsg);
  RwinRedrawWithData();
  return(0);
}

//
// ------------------- RmanageFindFile START ------------------------
//
int RmanageFindFile(char *RfindStr, char *group, char *host, char *dir, char *SelectFile, TTfind *RidxNet, int Rcount)
{
  WINDOW *RwinList = NULL;
  WINDOW *RwinTop = NULL;
  WINDOW *RwinWorkgroup = NULL;
  WINDOW *RwinHost = NULL;
  WINDOW *RwinDir = NULL;
  WINDOW *RwinFilename = NULL;
  WINDOW *RwinStatus = NULL;

  int Rkey, Rsel, RmaxY, Rx6, Rii;
  int RxWorkgroup, RxHostname, RxDir, RxFilename;
  int RxFilenameLen = 0;
  int RlFirst = 1;
  int RlSelect = 1;
  TTfind RfindIndex;
  char *Rmsg1;
  int RtxtStartX = 10;
  char Rttgroup[RMAXGHLEN], Rtthost[RMAXGHLEN], Rttdir[2000], Rttfilename[RMAXGHLEN];
  char Rtgroup[RMAXGHLEN], Rthost[RMAXGHLEN], Rtdir[2000], Rtfilename[RMAXGHLEN];
  int Rrol = 1;
  int FindListCount;
  int ret = 0;
  int Rt = 0;
  int Rctrlp = 1;
  TTindexTable *Ridx = NULL;
  int Rin11  = 0;
  int Rin12  = 0;
  int Rin21  = 0;
  int Rin22  = 0;
  int Rin31  = 0;
  int Rin32  = 0;
  int Rin41  = 0;
  int Rin42  = 0;
  int Rfirst = 1;

  void RpaintTop()
  {
    int RmaxT = Rx-RtxtStartX-4;

    wattron(RwinTop, COLOR_PAIR(2));
    mvwhline(RwinTop, 0, RtxtStartX+1, 32, RmaxT);
    mvwhline(RwinTop, 1, RtxtStartX+1, 32, RmaxT);
    mvwhline(RwinTop, 2, RtxtStartX+1, 32, RmaxT);
    mvwhline(RwinTop, 3, RtxtStartX+1, 32, RmaxT);

    memcpy(Rttgroup, Rtgroup, strlen(Rtgroup)+1); if (strlen(Rttgroup) > RmaxT) Rttgroup[RmaxT] = 0;
    memcpy(Rtthost, Rthost, strlen(Rthost)+1); if (strlen(Rtthost) > RmaxT) Rtthost[RmaxT] = 0;
    memcpy(Rttdir, Rtdir, strlen(Rtdir)+1); if (strlen(Rttdir) > RmaxT) Rttdir[RmaxT] = 0;
    memcpy(Rttfilename, Rtfilename, strlen(Rtfilename)+1); if (strlen(Rttfilename) > RmaxT) Rttfilename[RmaxT] = 0;
    mvwprintw(RwinTop, 0, RtxtStartX+1, RFS(Rttgroup));
    mvwprintw(RwinTop, 1, RtxtStartX+1, RFS(Rtthost));
    mvwprintw(RwinTop, 2, RtxtStartX+1, RFS(Rttdir));
    mvwprintw(RwinTop, 3, RtxtStartX+1, RFS(Rttfilename));
    wattroff(RwinTop, COLOR_PAIR(2));
    wrefresh(RwinTop);
  }

  void RpaintList(int Rfirst, int Rselect)    // Rfirst and Rselect - position in IDX not on to index file
  {
    int Rlast, Ri, Rii;
    int Rk = 0;
    TTfind RfindIndex;
    char *Rstr;
    int Ritmp;
    int RfilePos;
    TTfind *RidxWork = RidxNet;
    TTindexTable *RidxSmallWork = Ridx;

    RDBG("smbc: RpaintList start\n");
    Ritmp = RgetCountRecordIndexTable(RidxSmallWork);
    RDBG("smbc: RpaintList Ritmp = "); RDBGi(Ritmp); RDBG("\n");
    if ((Rfirst == 1) & (Ritmp <= Ry-13)) 
      Rlast = Ritmp;
    else Rlast = Rfirst + Ry-13;

    RDBG("smbc: RpaintList Rfirst = "); RDBGi(Rfirst);
    RDBG(" Rlast = "); RDBGi(Rlast); RDBG("\n");
    if (RgotoNIndextTable(&RidxSmallWork,Rfirst)) {
      RindexNetSetSeek(&RidxWork, RidxSmallWork->number);
      RfilePos = RidxSmallWork->number;

      mvwhline(RwinStatus, 0, 0, 32, Rx-2);
      wrefresh(RwinStatus);

      RDBG("smbc: RpaintList Rfirst: "); RDBGi(Rfirst);
      RDBG(" Rlast: "); RDBGi(Rlast); 
      RDBG(" Rselected: "); RDBGi(Rselected); 
      RDBG("\n");
      for (Ri = Rfirst; Ri <= Rlast;) {
  
        RindexNetReadOneRecord(&RidxWork, &RfindIndex); RfilePos++;
        RDBG("smbc: RpaintList RfilePos = "); RDBGi(RfilePos);
        RDBG(" Ridx->number = "); RDBGi(RidxSmallWork->number); RDBG("\n");
        for (Rii = RfilePos; Rii <= RidxSmallWork->number; Rii++) {
          RDBG("smbc: RpaintList must read one record : ");
          RDBGi(Rii); RDBG("\n");
          RindexNetReadOneRecord(&RidxWork, &RfindIndex);
          RfilePos++;
        }
        RgotoNextIndexTable(&RidxSmallWork);

        mvwhline(RwinWorkgroup, Rk, 0, 32, RxHostname-1);
        mvwhline(RwinHost, Rk, 0, 32, RxDir-RxHostname-1);
        mvwhline(RwinDir, Rk, 0, 32, RxFilename-RxDir-1);
        mvwhline(RwinFilename, Rk, 0, 32, Rx-RxFilename-2);

        if ((Ri == Rselect)) {
          asprintf(&Rstr, "//%s/%s/%s", RfindIndex.host, RfindIndex.dir, RfindIndex.file);
          if (strlen(Rstr) > Rx-2) Rstr[Rx-2] = 0;
          if (strlen(Rstr) > 4) mvwprintw(RwinStatus, 0, 0, RFS(Rstr));
          wrefresh(RwinStatus);
          free(Rstr);
        }
  
        if ((Ri == Rselect) && (Rrol == 2)) {

          wattron(RwinWorkgroup, COLOR_PAIR(1));
          wattron(RwinHost, COLOR_PAIR(1));
          wattron(RwinDir, COLOR_PAIR(1));
          wattron(RwinFilename, COLOR_PAIR(1));
        
          mvwhline(RwinWorkgroup, Rk, 0, 32, RxHostname-1);
          mvwhline(RwinHost, Rk, 0, 32, RxDir-RxHostname-1);
          mvwhline(RwinDir, Rk, 0, 32, RxFilename-RxDir-1);
          mvwhline(RwinFilename, Rk, 0, 32, Rx-RxFilename-2);
        }
 
        if (strlen(RfindIndex.group) > RxHostname-1) RfindIndex.group[RxHostname-1] = 0;
        if (strlen(RfindIndex.host) > RxDir-RxHostname-1) RfindIndex.host[RxDir-RxHostname-1] = 0;
        if (strlen(RfindIndex.dir) > RxFilename-RxDir-1) RfindIndex.dir[RxFilename-RxDir-1] = 0;
        if (strlen(RfindIndex.file) > Rx-RxFilename-2) RfindIndex.file[Rx-RxFilename-2] = 0;

        mvwprintw(RwinWorkgroup, Rk, 0, RFS(RfindIndex.group));
        mvwprintw(RwinHost, Rk, 0, RFS(RfindIndex.host));
        mvwprintw(RwinDir, Rk, 0, RFS(RfindIndex.dir));
        mvwprintw(RwinFilename, Rk, 0, RFS(RfindIndex.file));

        if ((Ri == Rselect) && (Rrol == 2)) {
          wattroff(RwinWorkgroup, COLOR_PAIR(1));
          wattroff(RwinHost, COLOR_PAIR(1));
          wattroff(RwinDir, COLOR_PAIR(1));
          wattroff(RwinFilename, COLOR_PAIR(1));
        }
        Ri++;
        Rk++;
      }
    }
    for (Ri = Rk; Ri < Ry-11; Ri++) {
      mvwhline(RwinWorkgroup, Ri, 0, 32, RxHostname-1);
      mvwhline(RwinHost, Ri, 0, 32, RxDir-RxHostname-1);
      mvwhline(RwinDir, Ri, 0, 32, RxFilename-RxDir-1);
      mvwhline(RwinFilename, Ri, 0, 32, Rx-RxFilename-2);
    }
    wrefresh(RwinWorkgroup);
    wrefresh(RwinHost);
    wrefresh(RwinDir);
    wrefresh(RwinFilename);
    RDBG("\nsmbc: RpaintList finished\n");
  }

  void RfindFileFromIndex()
  {
    int RidxNr = 1;
    TTfind *RidxNetWork = RidxNet;

    char Rtttgroup[RMAXGHLEN], Rttthost[RMAXGHLEN], Rtttdir[2000], Rtttfilename[RMAXGHLEN];
    char Rttttgroup[RMAXGHLEN], Rtttthost[RMAXGHLEN], Rttttdir[2000], Rttttfilename[RMAXGHLEN];
    int Rfind;

    RDBG("smbc: RfindFileFromIndex start\n");
    RlFirst = 1;
    RlSelect = 1;
    RstrToUpperCopy(Rttttgroup, Rtgroup);
    RstrToUpperCopy(Rtttthost, Rthost);
    RstrToUpperCopy(Rttttdir, Rtdir);
    RstrToUpperCopy(Rttttfilename, Rtfilename);

    RindexNetSetSeek(&RidxNetWork, 1);
    RfreeAllRecordFromIndexTable(&Ridx);
    while (RindexNetReadOneRecord(&RidxNetWork, &RfindIndex)) {
      
      RstrToUpperCopy(Rtttgroup, RfindIndex.group); 
      RstrToUpperCopy(Rttthost, RfindIndex.host); 
      RstrToUpperCopy(Rtttdir, RfindIndex.dir); 
      RstrToUpperCopy(Rtttfilename, RfindIndex.file); 

      Rfind = 1;
      if (strlen(Rttttgroup))    if (!strstr(Rtttgroup, Rttttgroup)) Rfind = 0;
      if (strlen(Rtttthost))     if (!strstr(Rttthost, Rtttthost)) Rfind = 0;
      if (strlen(Rttttdir))      if (!strstr(Rtttdir, Rttttdir)) Rfind = 0;
      if (strlen(Rttttfilename)) if (!strstr(Rtttfilename, Rttttfilename)) Rfind = 0; 
     
      if (Rfind) 
        RcreateNewRecordInIndexTable(&Ridx, RidxNr);
      RidxNr++;
    }
    RDBG("smbc: RfindFileFromIndex finished\n");
  }

  void RrefreshR()
  {
     RpaintTop();
     if ((Rt != 2) && (Rctrlp))
       RfindFileFromIndex();
     RpaintList(RlFirst, RlSelect);
  }

  void RcreateFindFileWindow()
  {
    TTfind *RidxNetWork = RidxNet;

    if (RwinList) delwin(RwinList);
    if (RwinTop) delwin(RwinTop);
    if (RwinWorkgroup) delwin(RwinWorkgroup);
    if (RwinHost) delwin(RwinHost);
    if (RwinDir) delwin(RwinDir);
    if (RwinFilename) delwin(RwinFilename);
    if (RwinStatus) delwin(RwinStatus);
    
    RwinList = newwin(Ry-2, Rx, 1, 0);
    RwinTop = newwin(4, Rx-2, 2, 1);
    getmaxyx(RwinMain, RmaxY, Rsel);
    if (Rx6 > Rsel-18) Rx6 = Rsel-10;
    
    box(RwinList,0,0);
    RxWorkgroup = 1;
    RxHostname = 15;
    RxDir = 30;
    RindexNetSetSeek(&RidxNetWork, 1);
    while (RindexNetReadOneRecord(&RidxNetWork, &RfindIndex)) {
      if ((RxFilenameLen < strlen(RfindIndex.file)) & (RxFilenameLen < 20))
        RxFilenameLen = strlen(RfindIndex.file);
    }
    RxFilename = Rx-2-RxFilenameLen;

    RwinWorkgroup = newwin(Ry-13, RxHostname-1 , 9 , 1);
    RwinHost = newwin(Ry-13, RxDir-RxHostname-1, 9, RxHostname+1);
    RwinDir = newwin(Ry-13, RxFilename-RxDir-1, 9, RxDir+1);
    RwinFilename = newwin(Ry-13, Rx-RxFilename-2, 9, RxFilename+1);
    RwinStatus = newwin(1, Rx-2, Ry-3, 1);

    mvwprintw(RwinList, 6, RxWorkgroup, _("workgroup"));
    mvwprintw(RwinList, 6, RxHostname+1, _("hostname"));
    mvwprintw(RwinList, 6, RxDir+1, _("dir"));
    mvwprintw(RwinList, 6, RxFilename+1, _("filename"));
    mvwvline(RwinList, 6, RxHostname, 0, Ry-11);
    mvwvline(RwinList, 6, RxDir, 0, Ry-11);
    mvwvline(RwinList, 6, RxFilename, 0, Ry-11);
    mvwhline(RwinList, 5, 1, 0, Rx-2);
    mvwhline(RwinList, 7, 1, 0, Rx-2);
    mvwhline(RwinList, Ry-5, 1, 0, Rx-2);
    wrefresh(RwinList);
    asprintf(&Rmsg1, _("Workgroup:")); Rii = RtxtStartX-strlen(Rmsg1); mvwprintw(RwinTop, 0, Rii, "%s",Rmsg1); free(Rmsg1); 
    asprintf(&Rmsg1, _("Hostname:")); Rii = RtxtStartX-strlen(Rmsg1); mvwprintw(RwinTop, 1, Rii, "%s",Rmsg1); free(Rmsg1); 
    asprintf(&Rmsg1, _("Dir:")); Rii = RtxtStartX-strlen(Rmsg1); mvwprintw(RwinTop, 2, Rii, "%s",Rmsg1); free(Rmsg1); 
    asprintf(&Rmsg1, _("Filename:")); Rii = RtxtStartX-strlen(Rmsg1); mvwprintw(RwinTop, 3, Rii, "%s",Rmsg1); free(Rmsg1); 
    wrefresh(RwinTop);
  
    keypad(RwinList, TRUE);
    nodelay(RwinList, 1);
  }

  void RresizeFindFile()
  {
    if (RdoResizeFind) {
      RdoResizeFind = 0;
      RdoWindowResize();
      RcreateFindFileWindow();
      RrefreshR();
    }
  }

  int RdetectAndPaintStatusCtrlp()
  {
    if (Rctrlp == 2) {
      delwin(RwinList);
      delwin(RwinTop);
      delwin(RwinWorkgroup);
      delwin(RwinHost);
      delwin(RwinDir);
      delwin(RwinFilename);
      delwin(RwinStatus);
      return(1);
    }
    RstatusBar(21+Rctrlp);
    return(0);
  }

  RDBG("smbc: RmanageFindFile start\n");
  Rttgroup[0] = 0;
  Rtthost[0] = 0;
  Rttdir[0] = 0;
  memcpy(Rttfilename, RfindStr, strlen(RfindStr)+1);
  Rtgroup[0] = 0;
  Rthost[0] = 0;
  Rtdir[0] = 0;
  memcpy(Rtfilename, RfindStr, strlen(RfindStr)+1);

  RcreateFindFileWindow();
  RlFirst = 1; RlSelect = 1;
  nodelay(RwinTop, 1);
  while (Rrol) {
    RstatusBar(2);
    RrefreshR();
    Rt = 0;
    while (Rt <= 0) {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 0, RtxtStartX+1, Rtgroup, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin11, &Rin12, &Rfirst)) <= 0) {
        RtryDownloadUpload();
      };
      if (RdetectAndPaintStatusCtrlp()) return(ret);
      RrefreshR();
      RresizeFindFile();
    }
    RstatusBar(3);
    RresizeFindFile();
    RrefreshR();
    Rt = 0;
    while (Rt <= 0) {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 1, RtxtStartX+1, Rthost, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin21, &Rin22, &Rfirst)) <= 0) {
        RtryDownloadUpload();
      }
      if (RdetectAndPaintStatusCtrlp()) return(ret);
      RrefreshR();
      RresizeFindFile();
    }
    RstatusBar(4);
    RresizeFindFile();
    RrefreshR();
    Rt = 0;
    while (Rt <= 0) {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 2, RtxtStartX+1, Rtdir, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin31, &Rin32, &Rfirst)) <= 0) {
        RtryDownloadUpload();
      }
      if (RdetectAndPaintStatusCtrlp()) return(ret);
      RrefreshR();
      RresizeFindFile();
    }
    RstatusBar(5);
    RresizeFindFile();
    RrefreshR();
    Rt = 0;
    while (Rt <= 0) {
      Rfirst = 1;
      while ((Rt = readlineOneCharNoDelay(RwinTop, 3, RtxtStartX+1, Rtfilename, RMAXGHLEN, Rx-RtxtStartX-4, 3, &Rctrlp, 1, &Rin41, &Rin42, &Rfirst)) <= 0) {
        RtryDownloadUpload();
      }
      if (RdetectAndPaintStatusCtrlp()) return(ret);
      RrefreshR();
      RresizeFindFile();
    }
    RstatusBar(6);
    Rrol = 2;
    RresizeFindFile();
    RrefreshR();
    RlFirst = 1; RlSelect = 1;
    Rt = 2;
    FindListCount = RgetCountRecordIndexTable(Ridx);
    while (Rrol == 2) {
      while ((Rkey = mvwgetch(RwinList, 1,1)) == -1) {
        RtryDownloadUpload();
      }
        RresizeFindFile();
        if ((Rkey == 9) || (Rkey == 'i')) {   // tab
          Rrol = 1;
          break;
        }
        if (Rkey == KEY_DOWN || Rkey == 'o') {
          if ((RlSelect+1 == RlFirst+Ry-13) && (RlFirst+Ry-13 < FindListCount+1)) {
            RlFirst++;
            RlSelect++;
          }
          else if (RlSelect < FindListCount) {
                 RlSelect++;
               }
          RpaintList(RlFirst, RlSelect);
        }
        if (Rkey == KEY_UP || Rkey == 'p') {
          if (RlSelect > 1) {
            if ((RlFirst > 1) && (RlSelect == RlFirst)) { 
              RlSelect--; 
              RlFirst--;
            }
            else {
              RlSelect--;
            }
            RpaintList(RlFirst, RlSelect);
          }
        }
        if (Rkey == KEY_NPAGE || Rkey == 'k') {
          if (RlFirst+Ry-13 <= FindListCount) {
            if (RlSelect+1 == RlFirst+Ry-13) {
              if (RlSelect+Ry-13 < FindListCount) {
                 RlFirst = RlSelect;
                 RlSelect = RlFirst+Ry-13-1;
               }
               else {
                 RlFirst = FindListCount-(Ry-13);
                 RlSelect = FindListCount-1;
               }
           }
           else {
              if (RlSelect+Ry-13 <= FindListCount) 
                RlSelect = RlFirst+Ry-13-1;
              else
                RlSelect = FindListCount-1;
           }
         }
         RpaintList(RlFirst,RlSelect);
        }
        if (Rkey == KEY_PPAGE || Rkey == 'l') {
          if (RlSelect > 1) {
            if (RlFirst == RlSelect) {
              if (RlFirst-(Ry-13) < 1) {
                RlFirst = 1;
                RlSelect = 1;
              }
              else {
                RlFirst = RlFirst-(Ry-13)+1;
                RlSelect = RlFirst;
              }
            }
            else RlSelect = RlFirst;
            RpaintList(RlFirst,RlSelect);
          }
        }
        if (Rkey == 10) {    // enter
          RgotoNIndextTable(&Ridx, RlSelect);
          RindexNetSetSeek(&RidxNet, Ridx->number);
          RindexNetReadOneRecord(&RidxNet, &RfindIndex);
          memcpy(group, RfindIndex.group, strlen(RfindIndex.group)+1);
          memcpy(host, RfindIndex.host, strlen(RfindIndex.host)+1);
          asprintf(&Rmsg1, "smb://%s/%s/", RfindIndex.host, RfindIndex.dir);
          memcpy(dir, Rmsg1, strlen(Rmsg1)+1);
          memcpy(SelectFile, RfindIndex.file, strlen(RfindIndex.file)+1);
          free(Rmsg1);
          ret = 1;
          Rkey = 'q';
        }
        if (Rkey == 'q') {
          delwin(RwinList);
          delwin(RwinTop);
          delwin(RwinWorkgroup);
          delwin(RwinHost);
          delwin(RwinDir);
          delwin(RwinFilename);
          delwin(RwinStatus);
          return(ret);
        }
    } 
  }
  return(ret);
}
//
// ------------------- RmanageFindFile END ------------------------
//

void RcreateIndexFileOnline(int RfileFd)
{
  int Rys = 10;
  int Rxs = 76;
  WINDOW *RwinMsg, *RwinMsg2;
  char *Rstr = NULL;
  char *RstrW = NULL;
  char *RstrShare = NULL;
  char *RstrDir = NULL;
  char *RstrDir2 = NULL;
  int Rii, Rk, Rkk;
  
  RDBG("smbc: RcreateIndexFileOnline start\n");
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  RwinMsg2 = newwin(3, Rxs-15, Ry/2-Rys/2+2, Rx/2-Rxs/2+13);
  box(RwinMsg,0,0);
  asprintf(&Rstr, _("Finding files on the network")); Rii = Rxs/2-strlen(Rstr)/2; mvwprintw(RwinMsg, 1, Rii, Rstr); free(Rstr);
  mvwprintw(RwinMsg, 3, 1, _("Workgroup :"));
  mvwprintw(RwinMsg, 4, 1, _("     Host :"));
  mvwprintw(RwinMsg, 5, 1, _("      Dir :"));

  wattron(RwinMsg, COLOR_PAIR(1));
     asprintf(&Rstr, _("[ Cancel ]")); Rii = Rxs/2-strlen(Rstr)/2; mvwprintw(RwinMsg, 7, Rii, Rstr); free(Rstr);
  wattroff(RwinMsg, COLOR_PAIR(1));

  wrefresh(RwinMsg);
  asprintf(&Rstr, "smb//%s/", Rahost);
  Rkk = 1;
  if (strlen(Radir) > strlen(Rstr)) {
    RstrW = Radir+strlen(Rstr)+1;
    if (strlen(RstrW) > 0) {
      if (RstrW[0] == '/') RstrW++;
      Rk = strlen(RstrW) - strlen(strstr(RstrW, "/"));
      RstrShare = malloc(strlen(RstrW)+1);
      memcpy(RstrShare, RstrW, Rk);
      RstrShare[Rk] = 0;
      
      RstrDir = malloc(strlen(RstrW)+1);
      memcpy(RstrDir, RstrW+Rk, strlen(RstrW)-Rk+1);
      if (RstrDir[0] == '/') RstrDir2 = RstrDir+1;
      Rkk = 0;
    }
  } 
  if (Rkk) {
      RstrShare = malloc(1);
      RstrDir = malloc(1);
      RstrShare[0] = 0;
      RstrDir[0] = 0;
      RstrDir2 = RstrDir;
  }
  RDBG("smbc: RcreateIndexFileOnline before RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd)\n");
  RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd);
  RDBG("smbc: RcreateIndexFileOnline after RcreateFindListIndex(0, Ragroup, Rahost, RstrShare, RstrDir2, RwinMsg2, RfileFd)\n");
  free(Rstr);
  free(RstrShare);
  free(RstrDir);

  delwin(RwinMsg2);
  delwin(RwinMsg);
  RDBG("smbc: RcreateIndexFileOnline stop\n");
}

int RfindFileSmb(char *dir, char *SelectFile)
{
  int RmaxX;
  int Rys, Rxs;
  WINDOW *RwinMsg;
  const int MAXSTR = 100;
  char RdirT[MAXSTR];
  int Rrol = 4;
  char *Rstr;
  char Rkey;
  int ret = 0;
  int RfileFd = 0;
  char *RfileName;
  int Rcount;
  TTfind *RidxNet = NULL;
  int RdirTpos = 0;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;

  void Rrefresh(int Rsel)
  {
    int Rii;
    char *RdirTt;
    char *Rmsg11 = _("[ Quick find (with index) ]");
    char *Rmsg12 = _("[ Slow find (without index) ]");
    char *Rmsg13 = _("[ Cancel ]");
    int Rall = strlen(Rmsg11)+strlen(Rmsg12)+strlen(Rmsg13)+2;

    wattron(RwinMsg, COLOR_PAIR(2));
    mvwhline(RwinMsg, 3, 3, ' ', Rxs-6); 

    RdirTt = strdup(RdirT);
    if (strlen(RdirTt) > RmaxX)
      RdirTt[RmaxX] = 0;
    mvwprintw(RwinMsg, 3, 3, RFS(RdirTt)); 
    free(RdirTt);
    
    wattroff(RwinMsg, COLOR_PAIR(2));
    switch(Rsel) {
      case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg11); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg12); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+strlen(Rmsg12)+2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg13); wattroff(RwinMsg, COLOR_PAIR(1));
               break;  
      case 2 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg11); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg12); wattroff(RwinMsg, COLOR_PAIR(1));
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+strlen(Rmsg12)+2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg13); 
               break;
      case 3 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg11); wattroff(RwinMsg, COLOR_PAIR(1));
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg12); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+strlen(Rmsg12)+2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg13); 
               break;
      case 4 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg11); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg12); 
               Rii = (Rxs-Rall)/2+strlen(Rmsg11)+strlen(Rmsg12)+2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg13); 
               break;
    }
  }

  RdirT[0] = 0;
  Rys = 8; Rxs = 76;
  RmaxX = Rxs-6; 
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  asprintf(&Rstr, _("Find files")); mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rstr)/2, Rstr); free(Rstr);
  Rrefresh(Rrol);
  RcancelFinding = 0;

  nodelay(RwinMsg,1);
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 4) { 
      Rfirst = 1;
      Rin1 = 0;
      Rin2 = 0;
      while (readlineOneCharNoDelay(RwinMsg, 3, 3, RdirT, MAXSTR, RmaxX,3, &RdirTpos, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(--Rrol);
    }
    Rkey = mvwgetch(RwinMsg,1,1);
    if (Rkey == 9) { 
      if ((--Rrol) == 0) Rrol = 4;
      Rrefresh(Rrol);
    }
    if (Rkey == 10) {
      asprintf(&RfileName, "/tmp/smbc_%i_%i",  getuid(), getpid());
      if (Rrol == 2) {    // slow find
        RindexFileCreate(RfileName, &RfileFd);                         // create file descriptor and remove file to other use
        RindexFileUnlink(RfileName);
        RcreateIndexFileOnline(RfileFd);
      } 
      else 
      if (Rrol == 3) {    // quick find
         if (!RmakeCopyFileWithPID(RfileName, RfileNameForFindList)) {
            RshowMessage(8,1,NULL,NULL,NULL);
            RcancelFinding = 1;
            ret = 0;
         }
         else {
           RindexFileOpen(RfileName, &RfileFd);
           RindexFileUnlink(RfileName);
         }
      }
      else Rrol = 0;
      free(RfileName);
      if (RcancelFinding)
        Rrol = 0;

      if (Rrol) {
       RDBG("smbc: RfindFileSmb before Rrol\n");
       Rcount = RindexFileGetCount(RfileFd);
       if (Rcount) {
        RshowMessage(10, 1, NULL, NULL, NULL);
        RloadIndexFile(RfileFd, &RidxNet);
        ret = RmanageFindFile(RdirT, Ragroup, Rahost, Radir, SelectFile, RidxNet, Rcount);
        RfreeIndexFile(&RidxNet);
        if (ret == 1) {
          if (strlen(Ragroup) > 0) RremoteLevel = 1;
          else RremoteLevel = 0;
          if (strlen(Rahost) > 0) {
            RremoteLevel = 2;
            if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1)
              RremoteLevel = 3;
          }
          ret = 1;
        };
        RwinRedrawWithData();
        Rrol = 0;
       } else {
        RshowMessage(8, 1, "", "", NULL); 
        Rrol = 0;
       }
      }
    }
    if (Rkey == 'q') Rrol = 0;
  }
  RindexFileClose(&RfileFd);
  delwin(RwinMsg);
  RwinRedrawWithData();
  RDBG("smbc: RfindFileSmb exit with result ");
  RDBGi(ret);
  RDBG("\n");
  return(ret);
}

void RcreateFindListIndex(int Isave, char *Igroup, char *Ihost, char *Ipath, char *Idir, WINDOW *RwinI, int RfileFd)
{
  int Rfd;
  int RxT, RyT;
  struct smbc_dirent *Rdirent;
  char *Rstr, *Rstr2;
  int Rstr2Len;
  char *IIgroup, *IIhost, *IIpath, *IIdir, *IItmp;
    
  void RcancelCheck()
  {
    char Rch = 0;

    while (Rch != ERR) {
      Rch = wgetch(RwinI);
      if (Rch == 10) 
        RcancelFinding = 1;
    }
  }

  if (!Isave) {
    keypad(RwinI, TRUE);
    nodelay(RwinI, 1);
    RcancelCheck();
    if (RcancelFinding) return;
  }

  RDBG("smbc: RcreateFindListIndex start\n");

  asprintf(&IIgroup, "%s", Igroup);
  RDBG("smbc: RcreateFindListIndex s1\n");
  asprintf(&IIhost, "%s", Ihost);
  RDBG("smbc: RcreateFindListIndex s2\n");
  asprintf(&IIdir, "%s", Idir);
  RDBG("smbc: RcreateFindListIndex s3\n");
  asprintf(&IIpath, "%s", Ipath);
  RDBG("smbc: RcreateFindListIndex s4\n");
  getmaxyx(RwinI, RyT, RxT);

  RDBG("smbc: RcreateFindListIndex s5\n");

  if (!Isave) {

    RDBG("smbc: RcreateFindListIndex a1\n");
    asprintf(&Rstr2, "%s", IIgroup); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) Rstr2[RxT] = 0;
    mvwhline(RwinI, 1, 0, 32, RxT); 
    mvwprintw(RwinI, 1, 0, 
    RFS(Rstr2)); 
    realloc(Rstr2, Rstr2Len);

    RDBG("smbc: RcreateFindListIndex a3\n");
    asprintf(&Rstr2, "%s", IIhost); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) Rstr2[RxT] = 0;
    mvwhline(RwinI, 2, 0, 32, RxT); 
    mvwprintw(RwinI, 2, 0, 
    RFS(Rstr2)); 
    realloc(Rstr2, Rstr2Len);
  
    RDBG("smbc: RcreateFindListIndex a5\n");
    asprintf(&Rstr2, "%s", IIdir); 
    Rstr2Len = strlen(Rstr2)+1;
    if (strlen(Rstr2) > RxT) Rstr2[RxT] = 0;
    mvwhline(RwinI, 3, 0, 32, RxT); 
    mvwprintw(RwinI, 3, 0, 
    RFS(Rstr2)); 
    realloc(Rstr2, Rstr2Len);

    RDBG("smbc: RcreateFindListIndex a7\n");
    wrefresh(RwinI);
    
  }

  RDBG("smbc: RcreateFindListIndex !!! 1 !!!\n");
  if (strlen(IIgroup) == 0) asprintf(&Rstr, "smb://");
  else if (strlen(IIhost) == 0) asprintf(&Rstr, "smb://%s/", IIgroup);
       else if (strlen(Ipath) == 0) asprintf(&Rstr, "smb://%s/", IIhost);
            else if (strlen(IIdir) == 0) asprintf(&Rstr, "smb://%s/%s/", IIhost, IIpath);
                 else {
                   asprintf(&Rstr, "smb://%s/%s/%s/", IIhost, Ipath, IIdir);
                   free(IIpath);
                   asprintf(&IIpath, "%s/%s", Ipath, Idir);
                 }

  RDBG("smbc: RcreateFindListIndex try open : "); RDBG(Rstr); RDBG("\n");
  Rfd = Rsmbc_opendir(Rstr);
  RDBG("smbc: RcreateFindListIndex after try open\n");

  if (Rfd > 0) {
    while((Rdirent = Rsmbc_readdir(Rfd))) {
      if (Rdirent != NULL)  {
       if ((strlen(Rdirent->name) > 0) && (!RcancelFinding)) {
          if (!Isave) RcancelCheck();
          if (Rdirent->name[strlen(Rdirent->name)-1] != '$') {
            RDBG("smbc: RcreateFindListIndex !!! 3 !!!\n");
            asprintf(&IItmp, Rdirent->name);
            RDBG("smbc: RcreateFindListIndex !!! 4 !!! : "); RDBG(Rdirent->name); RDBG("\n");
            switch (Rdirent->smbc_type) {
              case SMBC_WORKGROUP:  RDBG("smbc: RcreateFindListIndex !!! 4 - 1 !!!\n");
                                    RcreateFindListIndex(Isave, IItmp, "", "", "", RwinI, RfileFd);
                                    break;
              case SMBC_SERVER:     RDBG("smbc: RcreateFindListIndex !!! 4 - 2 !!!\n");
                                    RcreateFindListIndex(Isave, IIgroup, IItmp, "", "", RwinI, RfileFd);
                                    break;
              case SMBC_FILE_SHARE: RDBG("smbc: RcreateFindListIndex !!! 4 - 3 !!!\n");
                                    RcreateFindListIndex(Isave, IIgroup, IIhost, IItmp, "", RwinI, RfileFd);
                                    break;
              case SMBC_COMMS_SHARE:RDBG("smbc: RcreateFindListIndex !!! 4 - 4 !!!\n"); 
                                    break;
              case SMBC_DIR:        RDBG("smbc: RcreateFindListIndex !!! 4 - 5 !!!\n");
                                    if ((!RstrCmp(IItmp,".")) & (!RstrCmp(IItmp,".."))) {
                                       RDBG("smbc: RcreateFindListIndex !!! 4 - 6 !!!\n");
                                       RcreateFindListIndex(Isave, IIgroup, IIhost, IIpath, IItmp, RwinI, RfileFd);
                                    }
                                    break;
              case SMBC_FILE:       RDBG("smbc: RcreateFindListIndex !!! 4 - 7 !!!\n");
                                    write(RfileFd, IIgroup, strlen(IIgroup)+1);
                                    write(RfileFd, IIhost, strlen(IIhost)+1);
                                    write(RfileFd, IIpath, strlen(IIpath)+1);
                                    write(RfileFd, IItmp, strlen(IItmp)+1);
                                    RDBG("smbc: RcreateFindListIndex !!! 6 !!!\n");
                                    if (!Isave) {
                                       RDBG("smbc: RcreateFindListIndex !!! 6-1 !!!\n");
                                       asprintf(&Rstr2, IItmp); if (strlen(Rstr2) > RxT) Rstr2[RxT] = 0;
                                       free(Rstr2);
                                    }
                                    RDBG("smbc: RcreateFindListIndex !!! 7 !!!\n");
                                    break;
              case SMBC_LINK: 
                                    break;
            }
            RDBG("smbc: RcreateFindListIndex !!! 8 !!!\n");
            free(IItmp);
            RDBG("smbc: RcreateFindListIndex !!! 9 !!!\n");
          }
       }
      } 
    }
    smbc_closedir(Rfd);
  }
  RDBG("smbc: RcreateFindListIndex !!! 10 !!!\n");
  free(Rstr);
  free(IIgroup);
  free(IIhost);
  if (IIpath) free(IIpath);
  free(IIdir);
  RDBG("smbc: RcreateFindListIndex !!! 11 !!!\n");
  return;
}

void RsigTerm()
{
  int Ri;

  Ri = can_change_color();
  endwin();
  printf(_("stoping...\n"));
  kill(RchildId, SIGHUP);
  if (!Ri) {
    printf(_("Your terminal cannot change defined color.\n"));
    printf(_("Any color definition from ~/.smbc/smbcrc was ignored.\n"));
  }
  if ((Rx < 80) || (Ry < 25)) 
    printf(_("Minimum recommended screen size is 80x25, now is %ix%i.\n"), Rx, Ry);
  RopenSaveDowloadList(0);
  if (RlockFile > 0) 
    close(RlockFile);
  exit(0);
}

void RsigCHLD()
{
  waitpid(RchildId, NULL, WNOHANG);
}

void RcreateFindIndex(int Rl, int Rlock, char *Rstr)
{
  int RlockL;
  int RindexFileOld;
  int RmessageFilePrim;
  char *Rstr5 = _("Preparing find index.");

  if ((RchildId = fork()) == 0) {
    if (RindexTime == 0) exit(0);         // child
    if (Rl) {

      if (Rlock) 
        close(Rlock);

      RlockL = open(Rstr, O_RDWR | O_CREAT, 0600);

      RmessageFilePrim = open(RfileNameMessagePrim, O_RDWR | O_CREAT, 0600);
      if (RmessageFilePrim > 0) {
        write(RmessageFilePrim, Rstr5, strlen(Rstr5));
        close(RmessageFilePrim);
        rename(RfileNameMessagePrim, RfileNameMessage);
      }

      while (1) {
        if (RlockL > 0) 
          if (!flock(RlockL, LOCK_EX | LOCK_NB)) 
             exit(0);                                // kill smbc-child when parent was killed SIGKILL

        if (RindexFileFd == 0) 
          if (RindexFileCreate(RfileNameForFindListPrim, &RindexFileFd)) {
             RcreateFindListIndex(1, "","","","", NULL, RindexFileFd);

             unlink(RfileNameMessagePrim);
             RmessageFilePrim = open(RfileNameMessagePrim, O_RDWR | O_CREAT, 0600);

             RindexFileOld = open(RfileNameForFindList, O_RDONLY);
             RcompareTwoIndexFile(RindexFileFd, RindexFileOld, RmessageFilePrim);
             if (RindexFileOld > 0)
               close(RindexFileOld);
             close(RindexFileFd); 
             close(RmessageFilePrim);
             rename(RfileNameMessagePrim, RfileNameMessage);
             RindexFileFd = 0;
          }
        rename(RfileNameForFindListPrim, RfileNameForFindList);
        if (RindexTime > 1) sleep(RindexTime); 
        else exit(0); 
      }
    } else exit(0);
  }
}

/*     output:  RrightFirstI
                RrightPosI
        input:  RstrTmpI    - file name
                Rselected
*/
void RsetSelect(int *RFirstI, int *RPosI, char *RstrTmpI, RLTYPE Rselected)
{
  int Ri = 0;
  char *Rcmp;

  RDBG("smbc: RsetSelect start: RstrTmpI = "); RDBG(RstrTmpI); RDBG("\n");
  if (RstrTmpI == NULL) {
    RDBG("smbc: RsetSelect return 0\n");
    *RFirstI = 0;
    *RPosI = 0;
    return;
  }
  if (Rselected == RLREMOTE) {
    RDBG("smbc: RsetSelect : RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
    while (1) {
      RDBG("smbc: RsetSelect : RlistRight[Ri]->col = "); RDBG(RremoteLevel == 1?RlistRight[Ri]->col4:RlistRight[Ri]->col2); RDBG("\n");

      switch (RremoteLevel) {
        case (1) : 
        case (2) : Rcmp = RlistRight[Ri]->col4;
                   break;
        default  : Rcmp = RlistRight[Ri]->col2;
      }

      if (RstrCmp(Rcmp, RstrTmpI)) {
        if (Ri > Ry-6) {
          if (RlistRightMax-Ri < Ry-6) {
            *RFirstI = RlistRightMax - (Ry-6);
            *RPosI = Ri-(*RFirstI);
          }
          else {
            *RFirstI = Ri-1;
            *RPosI = 1;
          }
          RDBG("smbc: RsetSelect return 1\n");
          return; 
        }
        else {
          *RPosI = Ri;
          *RFirstI = 0;
          RDBG("smbc: RsetSelect return 2\n");
          return;
        }
      }
      if (Ri+1 < RlistRightMax) Ri++;
      else {
        RDBG("smbc: RsetSelect return 3\n");
        return;
      }
    }
  }
  else {
    while (1) {
      if (RstrCmp(RlistLeft[Ri]->col2, RstrTmpI)) {
        if (Ri > Ry-6) {
          if (RlistLeftMax-Ri < Ry-6) {
            *RFirstI = RlistLeftMax - (Ry-6);
            *RPosI = Ri-(*RFirstI);
          }
          else {
            *RFirstI = Ri-1;
            *RPosI = 1;
          }
          RDBG("smbc: RsetSelect return 4\n");
          return; 
        }
        else {
          *RPosI = Ri;
          *RFirstI = 0;
          RDBG("smbc: RsetSelect return 5\n");
          return;
        }
      }
      if (Ri+1 < RlistLeftMax) Ri++;
      else {
        RDBG("smbc: RsetSelect return 6\n");
        return;
      }
    }
  }
}

void RcompareTwoIndexFile(int RfdNew, int RfdOld, int RfdMessage)
{
  TTfind RfindIndexNew;
  TTfind RfindIndexOld;
  int Rfound;
  int RnewAdd = 0;
  int RnewDel = 0;
  char *RnewHosts = NULL;
  char *RoldHosts = NULL;
  char *RstrT;
  char *RstrT2;
  char *Rmsg1 = _("New find index is ready. You can use quick find file.");
  TThostsTable *RhostsTableNew = NULL;
  TThostsTable *RhostsTableOld = NULL;
  TThostsTable *RhostsTableNewTmp;
  TThostsTable *RhostsTableOldTmp;
  
  RDBG("smbc: RcompareTwoIndexFile start\n");
  if (RfdOld < 0) {
    write(RfdMessage, Rmsg1, strlen(Rmsg1)+1);
    RDBG("smbc: RcompareTwoIndexFile return short\n");
    return;
  }
  else {
    RDBG("smbc: RcompareTwoIndexFile seek files\n");
    RindexFileSetSeek(RfdNew, 1);
    RindexFileSetSeek(RfdOld, 1);

    //RDBG("smbc: RcompareTwoIndexFile while 1\n");
    while (RindexFileReadOneRecord(RfdNew, &RfindIndexNew)) {
       //RDBG("smbc: RcompareTwoIndexFile while 1 - 2\n");
       if (!(RFindHostInToHostsTable(RhostsTableNew, RfindIndexNew.host)))
         RAddHostToHostsTable(&RhostsTableNew, RfindIndexNew.host);
    }

#ifdef HAVE_DEBUG
    RDBG("smbc: RcompareTwoIndexFile RhostsTableNew = ");
    RhostsTableNewTmp = RhostsTableNew;
    while (RhostsTableNewTmp) {
      RDBG(RhostsTableNewTmp->name); RDBG(" ");
      RhostsTableNewTmp = RhostsTableNewTmp->next;
    }
    RDBG("\n");
#endif /* HAVE_DEBUG */    

    //RDBG("smbc: RcompareTwoIndexFile while 2\n");
    while (RindexFileReadOneRecord(RfdOld, &RfindIndexOld)) {
       //RDBG("smbc: RcompareTwoIndexFile while 2 - 2\n");
       if (!(RFindHostInToHostsTable(RhostsTableOld, RfindIndexOld.host)))
         RAddHostToHostsTable(&RhostsTableOld, RfindIndexOld.host);
    }

#ifdef HAVE_DEBUG
    RDBG("smbc: RcompareTwoIndexFile RhostsTableOld = ");
    RhostsTableOldTmp = RhostsTableOld;
    while (RhostsTableOldTmp) {
      RDBG(RhostsTableOldTmp->name); RDBG(" ");
      RhostsTableOldTmp = RhostsTableOldTmp->next;
    }
    RDBG("\n");
#endif /* HAVE_DEBUG */    

    /* find diference - add */
    RDBG("smbc: RcompareTwoIndexFile seek before add while\n");
    RhostsTableNewTmp = RhostsTableNew;
    while (RhostsTableNewTmp) {
      //RDBG("smbc: RcompareTwoIndexFile while 1 - 1\n");
      RhostsTableOldTmp = RhostsTableOld;
      Rfound = 0;
      while (RhostsTableOldTmp && !Rfound) {
        RDBG("smbc: RcompareTwoIndexFile : "); 
        RDBG(RhostsTableNewTmp->name); 
        RDBG(RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)?" == ":" != "); 
        RDBG(RhostsTableOldTmp->name);
        RDBG("\n");
        if (RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)) 
          Rfound = 1;
        else
          RhostsTableOldTmp = RhostsTableOldTmp->next;
      }
      RDBG("smbc: RcompareTwoIndexFile while after\n");
      if (!Rfound) {
        //RDBG("smbc: RcompareTwoIndexFile add to RnewHosts : ");
        //RDBG(RfindIndexNewTmp.host); RDBG("\n");
        asprintf(&RstrT, "%s%s%s", RnewHosts?RnewHosts:"", RnewHosts?",":"", RhostsTableNewTmp->name);
        RnewAdd++;
        if (RnewHosts)
          free(RnewHosts);
        RnewHosts = RstrT;
      }
      RhostsTableNewTmp = RhostsTableNewTmp->next;
    } 
    RDBG("smbc: RcompareTwoIndexFile while 1, result : ");
    RDBG(RnewHosts); RDBG("\n");
    /* find diference - del */
    RDBG("smbc: RcompareTwoIndexFile seek before del while\n");
    RhostsTableOldTmp = RhostsTableOld;
    while(RhostsTableOldTmp) {
      RhostsTableNewTmp = RhostsTableNew;
      Rfound = 0;
      while (RhostsTableNewTmp && !Rfound) {
        if (RstrCmp(RhostsTableNewTmp->name, RhostsTableOldTmp->name)) 
          Rfound = 1;
        else
          RhostsTableNewTmp = RhostsTableNewTmp->next;
      }
      if (!Rfound) {
        asprintf(&RstrT, "%s%s%s", RoldHosts?RoldHosts:"", RoldHosts?",":"", RhostsTableOldTmp->name);
        RnewDel++;
        if (RoldHosts)
          free(RoldHosts);
        RoldHosts = RstrT;
      }
      RhostsTableOldTmp = RhostsTableOldTmp->next;
    }
    RDBG("smbc: RcompareTwoIndexFile while 2, result : ");
    RDBG(RoldHosts); RDBG("\n");

    RDBG("smbc: RcompareTwoIndexFile seek before making return\n");
    if ((RnewAdd == 0) && (RnewDel == 0)) {
      write(RfdMessage, Rmsg1, strlen(Rmsg1)+1);
    }
    else {
      asprintf(&RstrT, "hosts: ");
      if (RnewAdd > 0) {
        asprintf(&RstrT2, _("%s%i new, "), RstrT, RnewAdd); free(RstrT); RstrT = RstrT2;
      }
      if (RnewDel > 0) {
        asprintf(&RstrT2, _("%s%i offline, "), RstrT, RnewDel); free(RstrT); RstrT = RstrT2;
      }
     if (RnewAdd > 0) {
        asprintf(&RstrT2, _("%s new: %s%s"), RstrT, RnewHosts, RoldHosts?",":""); free(RstrT); RstrT = RstrT2;
      }
      if (RnewDel > 0) {
        asprintf(&RstrT2, _("%s offline: %s"), RstrT, RoldHosts); free(RstrT); RstrT = RstrT2;
      }
      write(RfdMessage, RstrT, strlen(RstrT)+1);
    }
    if (RstrT) free(RstrT);
    if (RnewHosts) free(RnewHosts);
    if (RoldHosts) free(RoldHosts);
    RFreeHostsTable(&RhostsTableNew);
    RFreeHostsTable(&RhostsTableOld);
  }
  RDBG("smbc: RcompareTwoIndexFile finished\n");
}

void RcheckNewIndexFile(char *RfileName)
{
  int Rfd;
  char *Rstr = NULL;
  char *RstrT;
  char Rchar;
  struct stat Rfstat;
  int Rlen;

  Rfd = stat(RfileName, &Rfstat);
  if (Rfd == 0) {
    if (RlastTimeFileMessage != Rfstat.st_ctime) {
      RlastTimeFileMessage = Rfstat.st_ctime;
      Rfd = open(RfileName, O_RDONLY);
      if (Rfd > 0) {
        while (read(Rfd, &Rchar, 1) == 1) {
           asprintf(&RstrT, "%s%c", Rstr?Rstr:"", Rchar);
           free(Rstr);
           Rstr = RstrT;
        }
      }
      Rlen = (strlen(Rstr)+1>Rx)?Rx:strlen(Rstr)+1;
      RstrT = malloc(Rlen);
      memcpy(RstrT, Rstr, Rlen-1);
      RstrT[Rlen] = 0;

      mvwhline(RwinStatus, 0, 0, ' ', Rx);
      mvwprintw(RwinStatus,0,0, RstrT);
      wrefresh(RwinStatus);

      free(Rstr);
      free(RstrT);
      close(Rfd);
    }
  }
}

void RviewFile(RLTYPE Rsel, char *Rstr)
{
  WINDOW *WinView, *WinViewScroll;
  int Rkey = 0;
  int Rfilehandle = 0;
  struct stat remotestat;
  int Rsize = 0;
  off_t Rseek = 0;
  off_t RseekTmp = 0;
  int RwSize, RwReaded;
  int Rtx, Rty;
  char *Rbuf;
  int RfirstLineLen = 0;
  int RPageLen = 0;
  char RwrapView = 0;
  char Rloop;
  int Rtyt, Rtxt;

  void RreadAndPaint(WINDOW *RWin, RLTYPE Rsel, int Rhandle, off_t Rseek, int Rsize, int Rwrap)
  {
    int Rt;
    int Rix = 0;
    int Riy = 0;
    char *RbufT;

    memset(Rbuf, 0, RwSize);
    if (Rsel == RLLOCAL) {
      lseek(Rhandle, Rseek, SEEK_SET);
      RwReaded = read(Rhandle, Rbuf, RwSize);
    }
    else {
      Rsmbc_lseek(Rhandle, Rseek, SEEK_SET);
      RwReaded = Rsmbc_read(Rhandle, Rbuf, RwSize);
    }
    RDBG("smbc: RbufT = RFS(Rbuf);\n");
    RbufT = RFS(Rbuf);
    RwReaded = strlen(RbufT);
    memcpy(Rbuf, RbufT, RwReaded+1);
    RDBG("smbc: memcpy(Rbuf, RbufT, RwReaded+1);\n");
    
    werase(RWin);
    RPageLen = 0;
    if (RwReaded > 0) 
      for (Rt = 0; Rt < RwReaded; Rt++) {
        if (Rwrap) { 
          if (Riy == 0) {
            if (Rix == Rtx)
              RfirstLineLen = Rix;
            else 
              RfirstLineLen = Rix+1;
          }
          if (Rix == Rtx) {
            Rix = 0;
            Riy++;
          }
        } 
        if (Riy < Rty)
          RPageLen++;
        if (Rbuf[Rt] == 10) {
          if ((!Rwrap) && (Riy == 0))
              RfirstLineLen = Rix+1;
          Rix = 0;
          Riy++;
        }
        else {
          mvwprintw(RWin, Riy, Rix++, "%c", Rbuf[Rt]);
        }
      }
    wrefresh(RWin);
  }

  if (Rsel == RLLOCAL) {
    Rfilehandle = open(Rstr, O_RDONLY, 0755);
    if (Rfilehandle < 1) {
      RshowMessage(7, 0, Rstr, NULL, NULL);
      return;
    }
    fstat(Rfilehandle, &remotestat);
    Rsize = remotestat.st_size;
  } 
  else {
    Rfilehandle = Rsmbc_open(Rstr, O_RDONLY, 0755);
    if (Rfilehandle < 1) {
      RshowMessage(7, 0, Rstr, NULL, NULL);
      return;
    }
    Rsmbc_fstat(Rfilehandle, &remotestat);
    Rsize = remotestat.st_size;
  }

  WinView = newwin(Ry-2,Rx,1,0);  
  WinViewScroll = newwin(Ry-4, Rx-2, 2, 1);
  getmaxyx(WinViewScroll, Rty, Rtx);
  RwSize = Rtx*Rty;
  Rbuf = malloc(RwSize);
  
  box(WinView,0,0);
  RstatusBar(20);
  wrefresh(WinView);

  RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
  nodelay(RwinMain, 1);
  while ((Rkey = mvwgetch(RwinMain, 1,1))) {
    RtryDownloadUpload();
    if ((Rkey == 267) || (Rkey == 'q'))    // F3
      break;
    if ((Rkey == 272) || (Rkey == 'w')) {   // F8
      if (RwrapView) 
        RwrapView = 0;
      else 
        RwrapView = 1;
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_DOWN || Rkey == 'o')) {
      if (Rseek < Rsize) {
        Rseek = Rseek+RfirstLineLen;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if (Rkey == KEY_UP || Rkey == 'p') {
      if (Rseek > 0) {
        Rloop = 1;
        RseekTmp = Rseek;
        while (Rloop) {
          RseekTmp--;
          if (Rseek - RseekTmp == 1) RseekTmp--; 
          if (RseekTmp <= 0) Rloop = 0;
          if (Rsel == RLLOCAL) {
            lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = read(Rfilehandle, Rbuf, 1);
          }
          else {
            Rsmbc_lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = Rsmbc_read(Rfilehandle, Rbuf, 1);
          }
          if (Rbuf[0] == 10) {
            Rloop = 0;
            RseekTmp++;
          }
          if (Rseek - RseekTmp > Rtx)
            Rloop = 0;
        }
        Rseek = RseekTmp;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_NPAGE || Rkey == 'k')) {
      if ((Rseek < Rsize) && (Rseek + RPageLen < Rsize)) {
        Rseek = Rseek+RPageLen;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
    if ((Rkey == KEY_PPAGE || Rkey == 'l')) {
      if (Rseek > 0) {
        Rloop = 1;
        Rtyt = 0;
        Rtxt = 0;
        RseekTmp = Rseek;
        while (Rloop) {
          RseekTmp--;
          if (RseekTmp <= 0) Rloop = 0;
          if (Rsel == RLLOCAL) {
            lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = read(Rfilehandle, Rbuf, 1);
          }
          else {
            Rsmbc_lseek(Rfilehandle, RseekTmp, SEEK_SET);
            RwReaded = Rsmbc_read(Rfilehandle, Rbuf, 1);
          }
          if ((Rbuf[0] == 10) || (Rtxt >= Rtx)) {
            Rtyt++;
            Rtxt = 0;
          }
          if (Rtyt >= Rty)
             Rloop = 0;
          Rtxt++;
        }
        Rseek = RseekTmp;
      }
      RreadAndPaint(WinViewScroll, Rsel, Rfilehandle, Rseek, RwSize, RwrapView);
    }
  }
  delwin(WinView);
  delwin(WinViewScroll);
  if (Rfilehandle) {
    if (Rsel == RLLOCAL) 
      close(Rfilehandle);
    else
      Rsmbc_close(Rfilehandle);
  }
}

void RtryReadMessage()
{
  DIR *Rdirh;
  struct dirent *Rsdirent;
  char *RfileName;
  int Rfh;
  char Rch;
  char *Rl = NULL;
  char *Rll = NULL;
  char *Rl1 = NULL;
  char *Rl2 = NULL;
  int Rfound = 1;

  while (Rfound) {
    Rfound = 0;
    if ((Rdirh = opendir(RMESSAGEDIR)) > 0) {
      while ((Rsdirent = readdir(Rdirh)) > 0) {
        //RDBG("smbc: RtryReadMessage 1:"); RDBG(Rsdirent->d_name); RDBG(":"); RDBG(RMESSAGEFILE); RDBG("\n");
        if (RstrCmpIncludeFirst(Rsdirent->d_name, RMESSAGEFILE)) {
          Rfound = 1;
          asprintf(&RfileName, "%s/%s", RMESSAGEDIR, Rsdirent->d_name);
          RDBG("smbc: RtryReadMessage found:"); RDBG(RfileName); RDBG("\n");
          if ((Rfh = open(RfileName, O_RDONLY)) > 0) {
            while (read(Rfh, &Rch, 1) == 1) {
              if ((Rch == 10) && (!Rl1)) {
                Rl1 = Rll;
                RDBG("smbc: RtryReadMessage Rll = "); RDBG(Rll); RDBG("\n");
                Rll = NULL;
              }
              else {
                if (Rll) 
                  asprintf(&Rl, "%s%c", Rll, Rch);
                else
                  asprintf(&Rl, "%c", Rch);
                free(Rll);
                Rll = Rl;
              }
            }
            Rl2 = Rll;
            close(Rfh);
            RDBG("smbc: RtryReadMessage Rl1 = "); RDBG(Rl1); RDBG("\n");
            RDBG("smbc: RtryReadMessage Rl2 = "); RDBG(Rl2); RDBG("\n");
            RshowMessage(11, 1, Rl1, Rl2, NULL);
            free(Rl1);
            free(Rl2);
          }
          unlink(RfileName);
          free(RfileName);
        }
      }
      closedir(Rdirh);
    }
  }
}

void RsendWinpopupInput(char *RgroupInput)
{
  WINDOW *RwinMsg;
  int Rys, Rxs;
  char *Rstr;
  int Rrol = 3;
  int Rii;
  int Rxb = 0;
  char Rthost[RMAXGHLEN], Rtthost[RMAXGHLEN];
  char Rtmessage[RWINPOPUPMAXLEN], Rttmessage[RWINPOPUPMAXLEN];
  char *Rmsg52 = _("host:");
  char *Rmsg53 = _("message:");
  int Rdx = 12;
  int Rkey;
  int Rin1 = 0;
  int Rin2 = 0;
  int Rfirst = 1;
  int Rctrlp;
  
  void Rrefresh(int Rmax, int Rsel)
  {
    char *Rmsg41 = _("[ OK ]");
    char *Rmsg42 = _("[ Cancel ]");
    int Rall = strlen(Rmsg41)+strlen(Rmsg42);

    memcpy(Rtthost, Rthost, sizeof(Rtthost)); if (strlen(Rtthost) > Rmax) Rtthost[Rmax] = 0;
    memcpy(Rttmessage, Rtmessage, sizeof(Rttmessage)); if (strlen(Rttmessage) > Rmax) Rttmessage[Rmax] = 0;
    wattron(RwinMsg, COLOR_PAIR(2));
    mvwhline(RwinMsg, 4, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 4, Rdx+1, RFS(Rtthost));
    mvwhline(RwinMsg, 6, Rdx+1, 32, Rxs-Rdx-3); mvwprintw(RwinMsg, 6, Rdx+1, RFS(Rttmessage));
    wattroff(RwinMsg, COLOR_PAIR(2));
    switch (Rsel) {
       case 1 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", Rmsg41);
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42)); wattroff(RwinMsg, COLOR_PAIR(1)); 
                break;
       case 2 : Rii = (Rxs-Rall)/2; wattron(RwinMsg, COLOR_PAIR(1)); mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg41)); wattroff(RwinMsg, COLOR_PAIR(1)); 
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42));
                break;
       case 3 : Rii = (Rxs-Rall)/2; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg41));
                Rii = (Rxs-Rall)/2+strlen(Rmsg41)+1; mvwprintw(RwinMsg, Rys-2, Rii, "%s", RFS(Rmsg42));
                break;
    }
  }
 
  memcpy(Rthost, RgroupInput, strlen(RgroupInput)+1);
  Rtmessage[0] = 0;

  Rys = 11; Rxs = 70;
  Rxb = Rxs-Rdx-3;
  RwinMsg = newwin(Rys, Rxs, Ry/2-Rys/2, Rx/2-Rxs/2);
  box(RwinMsg,0,0);
  asprintf(&Rstr, _("Send message")); mvwprintw(RwinMsg, 1, Rxs/2-strlen(Rstr)/2, Rstr); free(Rstr);
  Rii = Rdx-strlen(Rmsg52); mvwprintw(RwinMsg, 4, Rii, "%s",Rmsg52);
  Rii = Rdx-strlen(Rmsg53); mvwprintw(RwinMsg, 6, Rii, "%s",Rmsg53);
  Rrefresh(Rxb, Rrol);
  nodelay(RwinMsg, 1);
  while (Rrol) {
    RtryDownloadUpload();
    if (Rrol == 3) {
      Rin1 = 0;
      Rin2 = 0;
      Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, Rxb, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      Rrefresh(Rxb, Rrol);
      Rin1 = 0;
      Rin2 = 0;
      Rfirst = 1;
      while (readlineOneCharNoDelay(RwinMsg, 6, Rdx+1, Rtmessage, RWINPOPUPMAXLEN, Rxb, 3, &Rctrlp, 1, &Rin1, &Rin2, &Rfirst) <= 0) {
        RtryDownloadUpload();
      }
      //readlineWait(RwinMsg, 4, Rdx+1, Rthost, RMAXGHLEN, Rxb,3); Rrefresh(Rxb, Rrol);
      //readlineWait(RwinMsg, 6, Rdx+1, Rtmessage, RWINPOPUPMAXLEN, Rxb,3); Rrefresh(Rxb, Rrol);

      Rrefresh(Rxb, --Rrol);
    }
    else {
      Rkey = mvwgetch(RwinMsg, 1,1);
      if (Rkey == 9) { 
        if ((--Rrol) == 0) Rrol = 3;
        Rrefresh(Rxb, Rrol);
      }
      if (Rkey == 10) { 
        if (Rrol == 2) {
          RsendWinpopup(Rsmbclient, Rthost, Rtmessage);
        }
        Rrol = 0;
      }
      if (Rkey == 'q') Rrol = 0;
    }
  }
  delwin(RwinMsg);
}

void RsigSEGV()
{
  int Rres = errno;

  RDBG("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
  RDBG("Fatal error, errno = ");
  RDBGi(Rres);
  RDBG(Rres == EILSEQ?" EILSEQ - Illegal byte sequence":"");
  RDBG("\n");
  RDBG("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
  RsigTerm();
  exit(1);
}

void RtryDownloadUpload() 
{
  if (RdownloadList != NULL) {
    if (!RdontDownload)
      RdownloadUpload();  
      RstatusBarStatus = 1;
    }
    else 
      if (RstatusBarStatus) {
        RstatusBar(0);
        RstatusBarStatus = 0;
      }
}


//
// ------------------- Rbookmark START ------------------------
//
int Rbookmark(RLTYPE *Riselect, char *Riagroup, char *Riahost, char *Riadir, char *RiadirL, char *Rifile, char *Riusername, char *Ripassword, char *RfileOutput)
{
  WINDOW *Rwin = NULL;
  WINDOW *RwinDel = NULL;
  WINDOW *RwinRL = NULL;
  WINDOW *RwinPath = NULL;
  int Rkey;
  TTbookmark *Rbookmarks = NULL;
  TTbookmark *RbookmarksTmp = NULL;
  int Rfirst = 0;
  int Rselect = 0;
  char *RbookmarkFileName;
  int RmaxY;
  unsigned int RcountBookmark;
  int RchangeBookmark = 0;
  int Raction = 0;
  int Riy, Rix;
  int Rcut = 0;
  
  void RpaintList(int Rifirst, int Riselect)
  {
    int Rilast, Ri, Rt;
    int Rk = 0;
    TTbookmark *RbookmarksTmp = Rbookmarks;
    char *RstrTmp;
    
    RgotoXBookmark(&RbookmarksTmp, Rifirst);
    RDBG("smbc Rbookmark_RpaintList RcountBookmark = "); RDBGi(RcountBookmark); RDBG("\n");
    if ((Rifirst == 0) & (RcountBookmark <= RmaxY)) Rilast = RcountBookmark;
    else Rilast = Rifirst + RmaxY;

    for (Ri = Rfirst; Ri < Rilast; Ri++) {
      mvwhline(RwinDel, Rk, 0, 32, 1);
      mvwhline(RwinRL, Rk, 0, 32, 1);
      mvwhline(RwinPath, Rk, 0, 32, Rix-6);
      if (Ri == Rselect) {
        wattron(RwinDel, COLOR_PAIR(1));
        wattron(RwinRL, COLOR_PAIR(1));
        wattron(RwinPath, COLOR_PAIR(1));

        mvwhline(RwinDel, Rk, 0, 32, 1);
        mvwhline(RwinRL, Rk, 0, 32, 1);
        mvwhline(RwinPath, Rk, 0, 32, Rix-6);
      }
      mvwprintw(RwinDel, Rk, 0, "%c", RbookmarksTmp->del);
      mvwprintw(RwinRL, Rk, 0, "%c", RbookmarksTmp->type);

      if (RbookmarksTmp->type == 'R')
        asprintf(&RstrTmp, "%s %s%s", RbookmarksTmp->group, RbookmarksTmp->dir, RbookmarksTmp->file);
      else
        asprintf(&RstrTmp, "%s%s", RbookmarksTmp->dir, RbookmarksTmp->file);
      Rt = strlen(RstrTmp);
      if (Rt > Rix-6)
        RstrTmp[Rix-6] = 0;
      mvwprintw(RwinPath, Rk, 0, "%s", RFS(RstrTmp));
      free(RstrTmp);

      if (Ri == Rselect) {
        wattroff(RwinDel, COLOR_PAIR(1));
        wattroff(RwinRL, COLOR_PAIR(1));
        wattroff(RwinPath, COLOR_PAIR(1));
      }
      RbookmarksTmp = RbookmarksTmp->next;
      Rk++;
    }
    for (Ri = Rilast+1; Ri < Rifirst+RmaxY+1; Ri++) {
      mvwhline(RwinDel, ++Rk, 0, 32, 1);
      mvwhline(RwinRL, Rk, 0, 32, 1);
      mvwhline(RwinPath, Rk, 0, 32, Rix-6);
    }
    wrefresh(RwinPath);
    wrefresh(RwinDel);
    wrefresh(RwinRL);
  }

  void RcreateBookmarkWindow()
  {
    if (Rwin) delwin(Rwin);
    if (RwinDel) delwin(RwinDel);
    if (RwinRL) delwin(RwinRL);
    if (RwinPath) delwin(RwinPath);

    getmaxyx(RwinMain, Riy, Rix);
    RmaxY = Riy-6;
    Rwin = newwin(Riy-2, Rix, 1, 0);
    RwinDel = newwin(Riy-6, 1, 4, 1);
    RwinRL = newwin(Riy-6, 1, 4, 3);
    RwinPath = newwin(Riy-6, Rix-6, 4, 5);
    mvwprintw(Rwin, 1,1, _("S R path to remote and local files"));
    mvwvline(Rwin, 1, 2, 0, Riy-4);
    mvwvline(Rwin, 1, 4, 0, Riy-4);
    mvwhline(Rwin, 2, 1, 0, Rix-2);
    box(Rwin, 0, 0);
    wrefresh(Rwin);
    wrefresh(RwinDel);
    wrefresh(RwinRL);
    wrefresh(RwinPath);
    keypad(Rwin, TRUE);
    nodelay(Rwin, 1);
    RstatusBar(23);
    RpaintList(Rfirst, Rselect);
  }

  void RresizeBookmark()
  {
    if (RdoResizeBookmark) {
      RdoResizeBookmark = 0;
      RdoWindowResize();
      RcreateBookmarkWindow();
    }
  }

  asprintf(&RbookmarkFileName, "%s/.smbc/bookmark", getenv("HOME"));
  RopenBookmark(&Rbookmarks, RbookmarkFileName);
  RcountBookmark = RgetBookmarkCount(Rbookmarks);

  RcreateBookmarkWindow();

  while (1) {
    Rkey = mvwgetch(Rwin, 1, 1);
    RtryDownloadUpload();
    RresizeBookmark();
    if (Rkey == 'q') {
      break;
    }
    if (Rkey == 'm') {
      if (Rcut) {
        Rcut = 0;
        RstatusBar(23);
      }
      else {
        Rcut = 1;
        RstatusBar(24);
      }
    }
    if (Rkey == 'b') {
      if (!RfindInBookmark(&Rbookmarks, *Riselect == RLREMOTE?'R':'L', Riagroup, Riahost, *Riselect == RLREMOTE?Riadir:RiadirL, Rifile, Riusername, Ripassword)) {
        RaddToBookmark(&Rbookmarks, *Riselect == RLREMOTE?'R':'L', Riagroup, Riahost, *Riselect == RLREMOTE?Riadir:RiadirL, Rifile, Riusername, Ripassword);
        RchangeBookmark = 1;
      }
      else {
        RshowMessage(12,1,_("This bookmark already exists."),NULL,NULL);
      }
      break;
    }
    if (Rkey == 'd' || Rkey == KEY_DC) {
       RgotoXBookmark(&Rbookmarks, Rselect);
       Rbookmarks->del = 'D';
       RchangeBookmark = 1;
       Rkey = KEY_DOWN;
    }
    if (Rkey == 'u') {
       RgotoXBookmark(&Rbookmarks, Rselect);
       Rbookmarks->del = 'X';
       RchangeBookmark = 1;
       Rkey = KEY_DOWN;
    }
    if (Rkey == KEY_DOWN || Rkey == 'o') {
      RgotoXBookmark(&Rbookmarks, Rselect);
      if ((Rcut) && (Rbookmarks->next)) {
        RchangeBookmark = 1;
        RbookmarksTmp = Rbookmarks;
        if (Rbookmarks->previous)
          Rbookmarks->previous->next = Rbookmarks->next;
        Rbookmarks->next->previous = Rbookmarks->previous;

        Rbookmarks = Rbookmarks->next;

        RbookmarksTmp->previous = Rbookmarks;
        RbookmarksTmp->next = Rbookmarks->next;
        
        if (Rbookmarks->next)
          Rbookmarks->next->previous = RbookmarksTmp;
        Rbookmarks->next = RbookmarksTmp;
      }
      if ((Rselect+1 == Rfirst+RmaxY) & (Rfirst+RmaxY < RcountBookmark)) {
        Rfirst++; Rselect++;
      }
      else if (Rselect < RcountBookmark-1) Rselect++;
      RDBG("smbc Rbookmark Rfirst = "); RDBGi(Rfirst); RDBG(", Rselect = "); RDBGi(Rselect); RDBG("\n");
      RpaintList(Rfirst,Rselect);
    }
    if (Rkey == KEY_UP || Rkey == 'p') {
      RgotoXBookmark(&Rbookmarks, Rselect);
      if ((Rcut) && (Rbookmarks->previous)) {
        RchangeBookmark = 1;
        RbookmarksTmp = Rbookmarks;
        if (Rbookmarks->next)
          Rbookmarks->next->previous = Rbookmarks->previous;
        Rbookmarks->previous->next = Rbookmarks->next;

        Rbookmarks = Rbookmarks->previous;

        RbookmarksTmp->next = Rbookmarks;
        RbookmarksTmp->previous = Rbookmarks->previous;
        
        if (Rbookmarks->previous)
          Rbookmarks->previous->next = RbookmarksTmp;
        Rbookmarks->previous = RbookmarksTmp;
      }
      if (Rselect > 0) {
         if ((Rfirst > 0) && (Rselect == Rfirst)) { Rfirst--; Rselect--; } 
         else Rselect--;
         RpaintList(Rfirst,Rselect);
      }
    }
    if (Rkey == KEY_NPAGE || Rkey == 'k') {
      if (Rfirst+RmaxY <= RcountBookmark) {
        if (Rselect+1 == Rfirst+RmaxY) {
           if (Rselect+RmaxY < RcountBookmark) {
              Rfirst = Rselect;
              Rselect = Rfirst+RmaxY-1;
            }
            else {
              Rfirst = RcountBookmark-RmaxY;
              Rselect = RcountBookmark-1;
            }
        }
        else {
           if (Rselect+RmaxY <= RcountBookmark) 
             Rselect = Rfirst+RmaxY-1;
           else
             Rselect = RcountBookmark-1;
        }
      }
      RpaintList(Rfirst,Rselect);
    }
    if (Rkey == KEY_PPAGE || Rkey == 'l') {
      if (Rselect > 1) {
        if (Rfirst == Rselect) {
          if (Rfirst - RmaxY < 1) {
            Rfirst = 1;
            Rselect = 1;
          }
          else {
            Rfirst = Rfirst - RmaxY + 1;
            Rselect = Rfirst;
          }
        }
        else Rselect = Rfirst;
        RpaintList(Rfirst,Rselect);
      }
    }
    if (Rkey == 10 || Rkey == 'x') {
      Raction = 1;
      RgotoXBookmark(&Rbookmarks, Rselect);
      if (Rbookmarks->type == 'L') {
        *Riselect = RLLOCAL;
        memcpy(RiadirL, Rbookmarks->dir, strlen(Rbookmarks->dir)+1);
        memcpy(RfileOutput, Rbookmarks->file, strlen(Rbookmarks->file)+1);
      }
      else {
        *Riselect = RLREMOTE;
        memcpy(Riagroup, Rbookmarks->group, strlen(Rbookmarks->group)+1);
        memcpy(Riahost, Rbookmarks->host, strlen(Rbookmarks->host)+1);
        memcpy(Riadir, Rbookmarks->dir, strlen(Rbookmarks->dir)+1);
        memcpy(RfileOutput, Rbookmarks->file, strlen(Rbookmarks->file)+1);
        memcpy(Riusername, Rbookmarks->username, strlen(Rbookmarks->username)+1);
        memcpy(Ripassword, Rbookmarks->password, strlen(Rbookmarks->password)+1);
      }
      break;
    }
  };
  if (RchangeBookmark)
    RsaveBookmark(Rbookmarks, RbookmarkFileName);
  delwin(Rwin);
  delwin(RwinDel);
  delwin(RwinRL);
  delwin(RwinPath);
  RfreeBookmark(Rbookmarks);
  free(RbookmarkFileName);
  return(Raction);
}
//
// ------------------- Rbookmark END ------------------------
//

int main(int argc,char *argv[])
{
 int Rnr;
 int Rkey;
 int Rx, Ry, Rtmp, Rtmp1;
 char *RagroupT;
 char *RadirTmpPr;
 char RstrTmp[1000];
 int Ri, Rwhat;
 char *Rstr, *RstrT;
 char Ropt;
 poptContext Rpopt;
 int RnrDulist;
 char *RargMessageIn;
 char *RargFileNameIn;
 char *RargMessage = NULL;
 char *RargFileName = NULL;
 int RchangePos;

 setlocale(LC_ALL, "");
 bindtextdomain("smbc", LOCALEDIR);
 textdomain("smbc");

 struct poptOption Roptions[] = {
   { "help", 'h', POPT_ARG_NONE, NULL, 'h', _("Displays this help message"), 0 },
   { "flush", 'f', POPT_ARG_NONE, NULL, 'f', _("Flush all download lists"), 0 },
   { "list", 'l', POPT_ARG_NONE, NULL, 'l', _("Show all download lists"), 0 },
   { "show", 's', POPT_ARG_INT, &RnrDulist, 's', _("Displays all items form dulistX"), 0 },
   { "sleep", 'p', POPT_ARG_NONE, NULL, 'p', _("Sleep, don't download/upload any files"), 0 },
   { "message", 'm', POPT_ARG_STRING, &RargMessageIn, 'm', _("Receive message from samba."), 0 },
   { "file", 'i', POPT_ARG_STRING, &RargFileNameIn, 'i', _("File with samba message, usage only with -m."), 0 },
   { "version", 'V', POPT_ARG_NONE, NULL, 'V', _("Displays the current version"), 0 },
   { NULL, 0, 0, NULL, 0, NULL, NULL }
 };

 Rpopt = poptGetContext("smbc", argc, (const char **) argv, Roptions, POPT_CONTEXT_KEEP_FIRST);
 poptSetOtherOptionHelp(Rpopt, _("smbc [OPTIONS]*"));

 while ((Ropt = poptGetNextOpt(Rpopt)) >= 0) {
   if (Ropt == POPT_ERROR_BADNUMBER) {
     exit(0);
   }
   switch (Ropt) {
     case 'h': poptPrintHelp(Rpopt, stderr, 0);
               exit(0);
     case 'f': RflushAllDownloadLists();
               exit(0);
     case 'l': RlistAllDownloadLists();
               exit(0);
     case 's': RShowAllItemsFromDUlist(RnrDulist);
               exit(0);
     case 'p': RdontDownload = 1;
               break;
     case 'm': asprintf(&RargMessage, "%s", RargMessageIn);
               if (RsaveMessage(RargMessage, RargFileName))
                 exit(0);
               break;
     case 'i': asprintf(&RargFileName, "%s", RargFileNameIn);
               if (RsaveMessage(RargMessage, RargFileName))
                 exit(0);
               break;
     case 'V': RdisplayVersion();
               exit(0);
   }
 }
 if (Ropt < -1) {
   fprintf(stderr, "%s: %s\n", poptBadOption(Rpopt, POPT_BADOPTION_NOALIAS), poptStrerror(Ropt));
   exit(0);
 }
 poptFreeContext(Rpopt);

 void RtryLockFileAndCreateIndexFile()  // detect smbc find index process and run them if not exist
 {
   if (!RlockFileFlag) {
     RlockFile = open(RsmbcLockFile, O_RDWR | O_CREAT, 0700);
     if (RlockFile > 0) {
       if (!flock(RlockFile, LOCK_EX | LOCK_NB)) {
         RlockFileFlag = 1;
         unlink(RfileNameForFindList);
         unlink(RfileNameMessage);
         RcreateFindIndex(RlockFileFlag, RlockFile, RsmbcLockFile);
       }
       else close(RlockFile);
     }
     if (RrunFirst) {
       signal(SIGCHLD, RsigCHLD);
       signal(SIGSEGV, RsigSEGV);
       signal(SIGTERM, RsigTerm);
       signal(SIGINT, RsigTerm);
       RrunFirst = 0;
     }
   }
 }

 void RrefreshR()
 {
   if (Rselected == RLLOCAL) {
     Rnr = RgetFileFromDirL(RadirL);
     RinitList(Rnr,0,0);
     RleftFirst = 0;
     RleftPos = 0;
     RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos); 
   }
   else {
     switch (RremoteLevel) {
        case 0: Rnr = RgetMasterList(); break;
        case 1: Rnr = RgetHostsFromGroup(Ragroup); break;
        case 2: Rnr = RgetSharesFromHost(Rahost); break;
        case 3: Rnr = RgetFileFromDirR(Radir); break;
     }
     RinitList(Rnr,RremoteLevel,1); 
     RrightFirst = 0;
     RrightPos = 0;
     RDBG("smbc: RrefreshR !!! 1 !!!\n");
     RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
   }
 }

 printf(_("runing...\n"));
 Ragroup[0] = 0;
 Rahost[0] = 0;
 Radir[0] = 0;


 asprintf(&RsmbcLockFile, "%s/.smbc/debug", getenv("HOME"));
 RinitDebug(RsmbcLockFile);
 free(RsmbcLockFile);
 RDBG("----start----\n");

 asprintf(&RsmbcLockFile, "%s/.smbc/smbc.lock", getenv("HOME"));

 memcpy(RadirL, getenv("HOME"),strlen(getenv("HOME"))+1);
 memcpy(Rusername, RGUEST, strlen(RGUEST));
 memcpy(Rpassword, "", 1);

 RreadRcfile(); 

 RFSinit(RDoCharConvert); 
 //RFSinit(FALSE); 
 RFStype(0,0);

 if (RDoCharConvert) 
   fprintf(stderr, _("Enable convert UTF-8 to ISO8859-2\n"));

 RopenSaveDowloadList(1);
 if (strlen(RadirL) > 0) if (RadirL[strlen(RadirL)-1] != '/') memcpy(RadirL+strlen(RadirL), "/", 2); 
 signal(SIGWINCH, resizeHandler);

 if(Rsmbc_init(Rget_auth_data, 0) < 0) {
    fprintf(stderr, _("Unable to initialize libsmbclient, error numer %i\n"), errno);
    if (errno == 2) fprintf(stderr, _("Probably you don't have a smb config file in ~/smb/smb.conf or ~/etc/samba/smb.conf\n"));
    exit(0);
 }

#ifdef HAVE_SMBCCTX
 Rstatcont = Rsmbc_new_context();
 if (!Rstatcont)
     return -1;
 Rstatcont->debug = 0;
 Rstatcont->callbacks.auth_fn = Rget_auth_data;
 if (!Rsmbc_init_context(Rstatcont)) {
   Rsmbc_free_context(Rstatcont, 0);
   return -1;
 }
 Rstatcont->timeout = Rtimeout;
#endif

 asprintf(&RfileNameForFindList, "%s/.smbc/findfile", getenv("HOME"));
 asprintf(&RfileNameForFindListPrim, "%s/.smbc/findfileprim", getenv("HOME"));
 asprintf(&RfileNameMessage, "%s/.smbc/message", getenv("HOME"));
 asprintf(&RfileNameMessagePrim, "%s/.smbc/messageprim", getenv("HOME"));

#ifdef HAVE_SET_CONTEXT
   Rsmbc_set_context(Rstatcont);
#else
   printf(_("samba without smbc_set_context function, better is samba 3.0.1 or letter\n"));
#endif

 RtryLockFileAndCreateIndexFile();
 
 RwriteMenu(1);
 RDBG("smbc: after RwriteMenu(1)\n");
 Rnr = RgetFileFromDirL(RadirL);
 RDBG("smbc: after Rnr = RgetFileFromDirL(RadirL);\n");
 RinitList(Rnr,0,0);
 RDBG("smbc: after RinitList(Rnr,0,0);\n");
 if ((strlen(Radir) > 0) & (strlen(Rahost) > 0) & (strlen(Ragroup) > 0)) {
   RDBG("smbc: after RremoteLevel = 3\n");
   asprintf(&RagroupT, "smb://%s/%s", Rahost, Radir);
   memcpy(Radir, RagroupT, strlen(RagroupT)+1);
   RDBG("smbc: after memcpy(Radir, RagroupT, strlen(RagroupT)+1);\n");
   free(RagroupT);
   if (Radir[strlen(Radir)-1] != '/') 
     memcpy(Radir+strlen(Radir), "/", 2);
   Rnr = RgetFileFromDirR(Radir);
   RremoteLevel = 3;
 } else
 if ((strlen(Rahost) > 0) & (strlen(Ragroup) > 0)) {
   RDBG("smbc: after RremoteLevel = 2\n");
   Rnr = RgetSharesFromHost(Rahost);
   RremoteLevel = 2;
 } else
 if (strlen(Ragroup) > 0) {
   RDBG("smbc: after RremoteLevel = 1\n");
   Rnr = RgetHostsFromGroup(Ragroup);
   RremoteLevel = 1;
 }
 else {
   RDBG("smbc: before Rnr = RgetMasterList();\n");
   Rnr = RgetMasterList();
   RDBG("smbc: after Rnr = RgetMasterList();\n");
 };
 RinitList(Rnr,RremoteLevel,1);
 RDBG("smbc: after RinitList(Rnr,RremoteLevel,1);\n");
 RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
 getmaxyx(RwinRightCol2, Ry, Rx);

 keypad(RwinMain, TRUE); 
 nodelay(RwinMain,1);
 RDBG("smbc: before main while\n");
 while ((Rkey = mvwgetch(RwinMain, 1,1))) {
   RdoWindowResize();
   getmaxyx(RwinRightCol2, Ry, Rx);
   if ((Rkey == 'v') || (Rkey == 267)) {           // view file, execude directory
     if (Rselected == RLLOCAL) { 
       if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'F') {
         asprintf(&Rstr, "%s/%s", RadirL, RlistLeft[RleftFirst+RleftPos]->col2);
         RviewFile(Rselected, Rstr);
         free(Rstr);
         wclear(RwinMain);
         RwinRedrawWithData(); 
       } 
       else 
         Rkey = 10;
     } else {
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'F') {
         asprintf(&Rstr, "%s\%s", Radir, RlistRight[RrightFirst+RrightPos]->col2);
         RviewFile(Rselected, Rstr);
         free(Rstr);
         wclear(RwinMain);
         RwinRedrawWithData(); 
       } 
       else 
         Rkey = 10;
     }
   }
   if (Rkey == 10 || Rkey == 'x') {
     if (Rselected == RLLOCAL) { 
       if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'D') {
          memcpy(RadirLtmp, RadirL, strlen(RadirL)+1);
          RchdirL(RadirLtmp, RlistLeft[RleftFirst+RleftPos]->col2);
          Rnr = RgetFileFromDirL(RadirLtmp);
          if (Rnr != -1) {
            memcpy(RadirOld, RadirL, strlen(RadirL)+1); 
            memcpy(RadirL, RadirLtmp, strlen(RadirLtmp)+1);
            RinitList(Rnr,0,0);

            RgetFileFromTwoDirs(&RfileNamePos, RadirOld, RadirL);
            RsetSelect(&RleftFirst, &RleftPos, RfileNamePos , RLLOCAL);
            free(RfileNamePos);

            RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
          }
       }
     }
     else {
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'D') {
          if (RstrCmp(RlistRight[RrightFirst+RrightPos]->col2, "..")) {
            if (RremoteLevel == 1) {
               Rnr = RgetMasterList();
               RremoteLevel = 0;
               RDBG("smbc: main !!! 1-1 !!!\n");
               RinitList(Rnr,RremoteLevel,1);

               RsetSelect(&RrightFirst, &RrightPos, Ragroup , RLREMOTE);
               Ragroup[0] = 0;

               RDBG("smbc: main !!! 1-1 !!!\n");
               RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
            } else
            if (RremoteLevel == 2) {
               RDBG("smbc: main !!! 2-1 !!!->"); RDBG(Rahost); RDBG("\n");
               Rnr = RgetHostsFromGroup(Ragroup);
               RremoteLevel = 1;
               RDBG("smbc: main !!! 2-1 !!!\n");
               RinitList(Rnr,RremoteLevel,1);

               RsetSelect(&RrightFirst, &RrightPos, Rahost , RLREMOTE);
               Rahost[0] = 0;

               RDBG("smbc: main !!! 2-1 !!!\n");
               RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
            } 
            if (RremoteLevel == 3) {
               asprintf(&RadirTmpPr, "%s", Radir);
               memcpy(RadirTmp, Radir, strlen(Radir)+1);
               memcpy(RadirOld, Radir, strlen(Radir)+1);
               RchdirL(Radir, RlistRight[RrightFirst+RrightPos]->col2);
               RgetSmallPath(RadirTmp); 
               if (RstrCmp(Radir, RadirTmp)) {
                 Rnr = RgetSharesFromHost(Rahost);
                 RremoteLevel = 2;
                 RDBG("smbc: main !!! 3-1 !!!\n");
                 RinitList(Rnr,RremoteLevel,1);

                 RgetFileFromTwoDirs(&RfileNamePos, RadirOld, Radir);
                 RsetSelect(&RrightFirst, &RrightPos, RfileNamePos, RLREMOTE);
                 free(RfileNamePos);
                 Radir[0] = 0;

                 RDBG("smbc: main !!! 3-2 !!!\n");
                 RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
               }
               else {
                 Rnr = RgetFileFromDirR(Radir);
                 if (Rnr != -1) {
                   RDBG("smbc: main !!! 4-1 !!!\n");
                   RinitList(Rnr,RremoteLevel,1);

                   RgetFileFromTwoDirs(&RfileNamePos, RadirOld, Radir);
                   RsetSelect(&RrightFirst, &RrightPos, RfileNamePos , RLREMOTE);
                   free(RfileNamePos);

                   RDBG("smbc: main !!! 4-2 !!!\n");
                   RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
                 } else {
                     memcpy(Radir, RadirTmp, strlen(RadirTmp));
                     RshowMessage(2,1,RlistRight[RrightFirst+RrightPos]->col2,"",NULL);
                 }
               }
               free(RadirTmpPr);
            } 
          } else {
              memcpy(RadirTmp, Radir, strlen(Radir)+1);
              Rtmp1 = strlen(Radir);
              Rtmp = strlen(RlistRight[RrightFirst+RrightPos]->col2);
              memcpy(Radir+Rtmp1, RlistRight[RrightFirst+RrightPos]->col2, Rtmp); Rtmp1 += Rtmp;
              memcpy(Radir+Rtmp1, "/\0", 2);
              Rnr = RgetFileFromDirR(Radir);
              if (Rnr != -1) {
                RDBG("smbc: main !!! 5-1 !!!\n");
                RinitList(Rnr,RremoteLevel,1);

                RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);

                RDBG("smbc: main !!! 5-2 !!!\n");
                RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
                RDBG("smbc: main !!! 5-3 !!!\n");
              } else {
                memcpy(Radir, RadirTmp, strlen(RadirTmp)+1);
                RshowMessage(2,1,RlistRight[RrightFirst+RrightPos]->col2,"",NULL);
              }
          }
       }
       else
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'W') {
         memcpy(Ragroup, RlistRight[RrightFirst+RrightPos]->col2, strlen(RlistRight[RrightFirst+RrightPos]->col2)+1);
         memcpy(RadirLtmp, Ragroup, strlen(Ragroup)+1);
         Rnr = RgetHostsFromGroup(Ragroup);
         if (Rnr > 0) {
           RremoteLevel = 1;
           RinitList(Rnr,RremoteLevel,1);

           RgetFileFromTwoDirs(&RfileNamePos, RadirOld, RadirL);
           RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);
           free(RfileNamePos);

           RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos); 
         } else {
           memcpy(Ragroup, "\0", 1);
           RshowMessage(0, 1, RadirLtmp,"",NULL);
         }
       }
       else
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'H') {
         memcpy(Rahost, RlistRight[RrightFirst+RrightPos]->col4, strlen(RlistRight[RrightFirst+RrightPos]->col4)+1);
         memcpy(RadirLtmp, Rahost, strlen(Rahost)+1);
         Rnr = RgetSharesFromHost(Rahost);
         if (Rnr > 0) {
           RremoteLevel = 2;
           RinitList(Rnr,RremoteLevel,1);

           RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);

           RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
         } else if (Rnr == 0) {
             memcpy(Rahost, "\0", 1);
             RshowMessage(1, 1, RadirLtmp,"",NULL);
         }
       } else
       if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'S') {
         RgetSmallPath(Radir); Rtmp = strlen(Radir);
         Rtmp1 = strlen(RlistRight[RrightFirst+RrightPos]->col4);
         memcpy(Radir+Rtmp, RlistRight[RrightFirst+RrightPos]->col4, Rtmp1); Rtmp += Rtmp1;
         memcpy(Radir+Rtmp, "/\0", 2);
         RremoteLevel = 3;
         Rnr = RgetFileFromDirR(Radir);
         RinitList(Rnr,RremoteLevel,1);

         RsetSelect(&RrightFirst, &RrightPos, NULL , RLREMOTE);

         RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
       } 
     }
   }
   if (Rkey == 4 || Rkey == 272) {    // CTRL-d or F8
    if (!RdetectScreenToSmall()) {
     Rwhat = 0;
     if (Rselected == RLREMOTE) {
       for (Ri = 0; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Ri]->select) { Rwhat = 1; break; }
       if (Rwhat) {
         if (RshowMessage(2,0,_("selected files/directories"),"",NULL)) {
           for (Ri = 0; Ri < RlistRightMax; Ri++) 
            if (RlistRight[Ri]->select) { 
               char *Rstr;
               asprintf(&Rstr, "%s%s", Radir, RlistRight[Ri]->col2);
               if (RlistRight[Ri]->col1[0] == 'F') {
                 if(Rsmbc_unlink(Rstr)) RshowMessage(7,1,Rstr,"",NULL);
               }
               else {
                 if (RremoveDirR(Rstr)) RshowMessage(7,1,Rstr,"",NULL);
                 RwinRedrawWithData();
               }
               free(Rstr);
               Rkey = 'r';
            }
         }
       } 
       else {
         if (!RstrCmp(RlistRight[RrightFirst+RrightPos]->col2,"..")) 
          if (RshowMessage(2,0,RlistRight[RrightFirst+RrightPos]->col2,"",NULL)) {
            char *Rstr;
            asprintf(&Rstr, "%s%s", Radir, RlistRight[RrightFirst+RrightPos]->col2);
            if (RlistRight[RrightFirst+RrightPos]->col1[0] == 'F') {
               if(Rsmbc_unlink(Rstr)) RshowMessage(7,1,Rstr,"",NULL);
            }
            else {
              if (RremoveDirR(Rstr)) RshowMessage(7,1,Rstr,"",NULL);
              RwinRedrawWithData();
            }
            free(Rstr);
            Rkey = 'r';
          }
       }
     } 
     else {
       for (Ri = 0; Ri < RlistLeftMax; Ri++) 
         if (RlistLeft[Ri]->select) { Rwhat = 1; break; }
       if (Rwhat) {
         if (RshowMessage(2,0,_("selected files/directories"),"",NULL)) {
           for (Ri = 0; Ri < RlistLeftMax; Ri++) 
            if (RlistLeft[Ri]->select) { 
               char *Rtmps;
               asprintf(&Rtmps, "%s%s", RadirL, RlistLeft[Ri]->col2);
               if (RlistLeft[Ri]->col1[0] == 'F') unlink(Rtmps);
               else {
                 RremoveDir(Rtmps);
                 RwinRedrawWithData();
               }
               free(Rtmps);
               Rkey = 'r';
            }
         }
       } 
       else {
         if (!RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2,"..")) 
          if (RshowMessage(2,0,RlistLeft[RleftFirst+RleftPos]->col2,"",NULL)) {
            char *Rtmps;
            asprintf(&Rtmps, "%s%s", RadirL, RlistLeft[RleftFirst+RleftPos]->col2);
            if (RlistLeft[RleftFirst+RleftPos]->col1[0] == 'F') unlink(Rtmps);
            else { 
              RremoveDir(Rtmps);
              RwinRedrawWithData();
            }
            free(Rtmps);
            Rkey = 'r';
          }
       }
     }
    }
    else RwinRedrawWithData();
   }
   if (Rkey == 'm') {
     if (!RdetectScreenToSmall()) {
       if (RremoteLevel == 1)
         RsendWinpopupInput(RlistRight[RrightFirst+RrightPos]->col4);
       else 
         if (RremoteLevel > 1)
           RsendWinpopupInput(Rahost);
         else 
           RsendWinpopupInput("");
       Rkey = 'r';
     }
     RwinRedrawWithData();
   }
   if (Rkey == 'g') {
     if (Rselected == RLREMOTE) {
       if (RsetManualyLocation(1,Ragroup, Rahost, Radir,Rusername,Rpassword) == 1) {
         if (strlen(Ragroup) > 0) RremoteLevel = 1;
         else RremoteLevel = 0;
         if (strlen(Rahost) > 0) {
           RremoteLevel = 2;
           if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1) 
             RremoteLevel = 3;
         }
         Rkey = 'r';
       }
     }
   }
   if (Rkey == 'c' || Rkey == 271) {    // F7
    if (!RdetectScreenToSmall()) {
     if (Rselected == RLREMOTE) {
        if (RremoteLevel == 3) {
          RcreateDir(Rselected,Radir);
          Rkey = 'r';  
        }
     }
     else {
       RcreateDir(Rselected,RadirL);
       Rkey = 'r';
     }
    }
    else RwinRedrawWithData();
   }
   if (Rkey == 'f') {
     if (!RdetectScreenToSmall()) {
       if(Rselected == RLREMOTE) {
         if (RfindFileSmb(Radir, RstrTmp)) {
           RrefreshR();
           RsetSelect(&RrightFirst, &RrightPos, RstrTmp, Rselected);
         }
         RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
       }
       else {
       }
     } else RwinRedrawWithData();
   }
   if (Rkey == 'e') {
     if (Rselected == RLREMOTE) {
       RsortMethodR++;
       if (RsortMethodR > 4) RsortMethodR = 1;
       RstatusBar(8+RsortMethodR);
     }
     else {
       RsortMethodL++;
       if (RsortMethodL > 4) RsortMethodL = 1;
       RstatusBar(8+RsortMethodL);
     }
     Rkey = 'r';
   }
   if (Rkey == 'w') {
     if (Rselected == RLREMOTE) {
       if (RsortReverseR) RsortReverseR = 0;
       else RsortReverseR = 1;
       RstatusBar(13);
     }
     else {
       if (RsortReverseL) RsortReverseL = 0;
       else RsortReverseL = 1;
       RstatusBar(13);
     }
     Rkey = 'r';
   }
   if (Rkey == 't') {
     if (Rselected == RLREMOTE) {
       if (RgroupFilesDirectoriesR) RgroupFilesDirectoriesR = 0;
       else RgroupFilesDirectoriesR = 1;
       RstatusBar(14+RgroupFilesDirectoriesR);
     }
     else {
       if (RgroupFilesDirectoriesL) RgroupFilesDirectoriesL = 0;
       else RgroupFilesDirectoriesL = 1;
       RstatusBar(14+RgroupFilesDirectoriesL);
     }
     Rkey = 'r';
   }
   if (Rkey == 'b') {
     RstrT = NULL;
     RchangePos = 0;
     if (!RdetectScreenToSmall()) {
       if (Rselected == RLREMOTE) {
         if (Rbookmark(&Rselected, Ragroup, Rahost, Radir, RadirL, RlistRight[RrightFirst+RrightPos]->col2, Rusername, Rpassword, RstrTmp))
           RchangePos = 1;
       }
       else {
         if (Rbookmark(&Rselected, Ragroup, Rahost, Radir, RadirL, RlistLeft[RleftFirst+RleftPos]->col2, Rusername, Rpassword, RstrTmp)) 
           RchangePos = 1;
       }
       if (RchangePos) {
         RDBG("smbc main_Rbookmark : 1RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
         if (Rselected == RLLOCAL) {
           RstrT = strdup(RstrTmp);
           Rnr = RgetFileFromDirL(RadirL);
           if (Rnr != -1) {
             RinitList(Rnr,0,0);
             RsetSelect(&RleftFirst, &RleftPos, RstrT , RLLOCAL);
           }
         }
         else {
           RDBG("smbc main_Rbookmark : 2RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
           if (strlen(Ragroup) > 0) RremoteLevel = 1;
           else RremoteLevel = 0;
           if (strlen(Rahost) > 0) {
             RremoteLevel = 2;
             if (strlen(index(Radir+6+strlen(Rahost),'/')) > 1) 
               RremoteLevel = 3;
           }
           RDBG("smbc main_Rbookmark : 3RremoteLevel = "); RDBGi(RremoteLevel); RDBG("\n");
           switch (RremoteLevel) {
             case 0: RstrT = strdup(Ragroup);
                     Rnr = RgetMasterList();
                     break;
             case 1: RstrT = strdup(Rahost);
                     Rnr = RgetHostsFromGroup(Ragroup);
                     break;
             case 2: RstrT = strdup(Radir);
                     Rnr = RgetSharesFromHost(Rahost);
                     break;
             case 3: RstrT = strdup(RstrTmp);
                     Rnr = RgetFileFromDirR(Radir);
                     break;
           } 
           if (Rnr != -1) {
             RinitList(Rnr,RremoteLevel,1);
             RsetSelect(&RrightFirst, &RrightPos, RstrT , RLREMOTE);
           }
         }
         free(RstrT);
       }
     }
     RwinRedrawWithData();
   }
   if (Rkey == 'r') {
     RrefreshR();
   }
   if ((Rkey == 331) || (Rkey == 'a')) {   // Insert or 't'
     if (Rselected == RLREMOTE) {
       if (!RstrCmp(RlistRight[RrightFirst+RrightPos]->col2, "..")) {
         if (RlistRight[RrightFirst+RrightPos]->select) 
            RlistRight[RrightFirst+RrightPos]->select = 0;
         else RlistRight[RrightFirst+RrightPos]->select = 1;
       }
     } else {
       if (!RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2, "..")) {
         if (RlistLeft[RleftFirst+RleftPos]->select) 
            RlistLeft[RleftFirst+RleftPos]->select = 0;
         else RlistLeft[RleftFirst+RleftPos]->select = 1;
       }
     }
     Rkey = 'o';
   }
   if ((Rkey == 106) || (Rkey == 42)) {   // numeric keys * or shift+8
     int Ri;
     if (Rselected == RLREMOTE) {
       for (Ri = 1; Ri < RlistRightMax; Ri++) {
         if (RlistRight[Ri]->select) 
            RlistRight[Ri]->select = 0;
         else RlistRight[Ri]->select = 1;
       }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } else {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) {
         if (RlistLeft[Ri]->select) 
            RlistLeft[Ri]->select = 0;
         else RlistLeft[Ri]->select = 1;
       }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   if (Rkey == 95) {   // numeric shift -
     int Ri;
     if (Rselected == RLREMOTE) {
       for (Ri = 1; Ri < RlistRightMax; Ri++) RlistRight[Ri]->select = 0;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } else {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) RlistLeft[Ri]->select = 0;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   if (Rkey == 43) {   // numeric shift =
     int Ri;
     if (Rselected == RLREMOTE) {
       for (Ri = 1; Ri < RlistRightMax; Ri++) RlistRight[Ri]->select = 1;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     } else {
       for (Ri = 1; Ri < RlistLeftMax; Ri++) RlistLeft[Ri]->select = 1;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
   }
   if (Rkey == KEY_DOWN || Rkey == 'o') {
     if (Rselected == RLLOCAL) {
       if (RleftPos+1 < Ry) {
         if (RleftPos+1 < RlistLeftMax) RleftPos++;
       }
       else { if (RleftFirst+RleftPos+1 < RlistLeftMax) RleftFirst++; }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else {
       if (RrightPos+1 < Ry) {
         if (RrightPos+1 < RlistRightMax) RrightPos++;
       }
       else { if (RrightFirst+RrightPos+1 < RlistRightMax) RrightFirst++; }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   if (Rkey == KEY_UP || Rkey == 'p') {
     if (Rselected == RLLOCAL) {
       if (RleftPos > 0) RleftPos--;
       else { if (RleftFirst+RleftPos > 0) RleftFirst--; }
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else {
       if (RrightPos > 0) RrightPos--;
       else { if (RrightFirst+RrightPos > 0) RrightFirst--; }
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   if (Rkey == KEY_END || Rkey == 'u') {
     if (Rselected == RLLOCAL) {
       if (RlistLeftMax+1 > Ry) { RleftFirst = RlistLeftMax-Ry; RleftPos = Ry-1; }
       else RleftPos = RlistLeftMax-1;
       RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else {
       if (RlistRightMax+1 > Ry) { RrightFirst = RlistRightMax-Ry; RrightPos = Ry-1; }
       else RrightPos = RlistRightMax-1;
       RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   if (Rkey == KEY_HOME || Rkey == 'y') {
     if (Rselected == RLLOCAL) {
        if ((RleftFirst != 0) || (RleftPos != 0)) {
           RleftFirst = 0;
           RleftPos = 0;
           RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
         }
     }
     else {
        if ((RrightFirst != 0) || (RrightPos != 0)) {
           RrightFirst = 0;
           RrightPos = 0;
           RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
         }
     }
   }
   if (Rkey == KEY_PPAGE || Rkey == 'l') {
     if (Rselected == RLLOCAL) {
        if (RleftFirst-Ry >= 0) RleftFirst = RleftFirst-Ry;
        else { 
          RleftFirst = 0; 
          RleftPos = 0; 
        }
        RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else {
        if (RrightFirst-Ry >= 0) RrightFirst = RrightFirst-Ry;
        else { 
          RrightFirst = 0; 
          RrightPos = 0; 
        }
        RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   if (Rkey == KEY_NPAGE || Rkey == 'k') {
     if (Rselected == RLLOCAL) {
        if (RleftFirst+RleftPos+1 < RlistLeftMax) { 
          if (RlistLeftMax < Ry) RleftPos = RlistLeftMax-1;
          else { if (RleftFirst+Ry+Ry > RlistLeftMax) { 
                    RleftFirst = RlistLeftMax-Ry;
                    RleftPos = Ry-1;
                 }
                 else RleftFirst = RleftFirst+Ry; 
          }
        }
        RwriteMenuTxt(RleftFirst,0,RLLOCAL,RleftPos);
     }
     else {
        if (RrightFirst+RrightPos+1 < RlistRightMax) { 
          if (RlistRightMax < Ry) RrightPos = RlistRightMax-1;
          else { if (RrightFirst+Ry+Ry > RlistRightMax) { 
                    RrightFirst = RlistRightMax-Ry;
                    RrightPos = Ry-1;
                 }
                 else RrightFirst = RrightFirst+Ry; 
          }
        }
        RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
     }
   }
   if (Rkey == 9 || Rkey == 'i') {
     if(Rselected == RLREMOTE) Rselected = RLLOCAL;
     else Rselected = RLREMOTE;
     RwriteMenuTxt(RleftFirst,RLLOCAL,RLLOCAL,RleftPos);
     RwriteMenuTxt(RrightFirst,RremoteLevel,RLREMOTE,RrightPos);
   }
   if (Rkey == 'd' || Rkey == 269) {               // F5 - download/upload
    if (!RdetectScreenToSmall()) { 
     Rwhat = 0;
     if (Rselected == RLREMOTE) {
       for (Ri = 0; Ri < RlistRightMax; Ri++) 
         if (RlistRight[Ri]->select) { Rwhat = 1; break; }
       if (Rwhat) {
         if (RshowMessage(3,1,_("selected files/directories"),RadirL,NULL)) {
           for (Ri = 0; Ri < RlistRightMax; Ri++) 
            if (RlistRight[Ri]->select) { 
               RcreateFileFromDirR(RadirL, Radir, RlistRight[Ri]->col2, Ragroup, RlistRight[Ri]->col1[0]);
               RwinRedrawWithData();
               nodelay(RwinMain,1);
            }
         }
       } 
       else {
         switch(RremoteLevel) {
          case 0: RstatusBar(16);
                  break;
          case 1: RstatusBar(17);
                  break;
          case 2: RstatusBar(18);
                  break;
          case 3: if (RstrCmp(RlistRight[RrightFirst+RrightPos]->col2,"..") == 0) {
                   if (RshowMessage(3,1,RlistRight[RrightFirst+RrightPos]->col2,RadirL,NULL)) {
                     RcreateFileFromDirR(RadirL, Radir, RlistRight[RrightFirst+RrightPos]->col2, Ragroup, RlistRight[RrightFirst+RrightPos]->col1[0]);
                     RwinRedrawWithData();
                     nodelay(RwinMain,1);
                   }
                  }
                  break;
         }
       }
     }
     else {
       for (Ri = 0; Ri < RlistLeftMax; Ri++) 
         if (RlistLeft[Ri]->select) { Rwhat = 1; break; }
       if (Rwhat) {
         if (RshowMessage(3,1,_("selected files/directories"),Radir+4,NULL)) {
           for (Ri = 0; Ri < RlistLeftMax; Ri++) 
            if (RlistLeft[Ri]->select) { 
               RcreateFileFromDirL(RadirL, Radir, RlistLeft[Ri]->col2, Ragroup, RlistLeft[Ri]->col1[0]);
               RwinRedrawWithData();
               nodelay(RwinMain,1);
            }
         }
       }
       else {
         switch(RremoteLevel) {
          case 0: RstatusBar(19);
                  break;
          case 1: RstatusBar(16);
                  break;
          case 2: RstatusBar(17);
                  break;
          case 3: if (RstrCmp(RlistLeft[RleftFirst+RleftPos]->col2,"..") == 0) {
                   if (RshowMessage(3,1,RlistLeft[RleftFirst+RleftPos]->col2,Radir+4,NULL)) {
                     RcreateFileFromDirL(RadirL, Radir, RlistLeft[RleftFirst+RleftPos]->col2, Ragroup, RlistLeft[RleftFirst+RleftPos]->col1[0]);
                     RwinRedrawWithData();
                     nodelay(RwinMain,1);
                   }
                  }
                  break;
        }
      }
     }
    } else RwinRedrawWithData();
   } 
   if (Rkey == 's') {
     if (!RdetectScreenToSmall()) {
       if (!RgetdownloadListCount()) RshowMessage(4,1,"","",NULL);
       else RmanageList();
       nodelay(RwinMain,1);
     }
     else
       RwinRedrawWithData();
   }
   if (Rkey == 'q') {
     if (Raskquit?RshowMessage(3,0,"aa",NULL,NULL):1) {
       getmaxyx(RwinMain, Ry, Rx);
       endwin();
       break;
     }
   }
   RtryDownloadUpload();
   if (Rkey == 'h') {
     RshowMessage(1,0,"","",NULL);
   }
   if (RindexTime != -1) 
     RcheckNewIndexFile(RfileNameMessage);
   
   RtryLockFileAndCreateIndexFile();
   RtryReadMessage();
    
   Rkey = 0;
 };
 RfreeMasterList(); 
 RfreeSharesList(); 
 RfreeHostsList(); 
 RfreeFilesList(); 
 free(RfileNameForFindList);
 free(RfileNameForFindListPrim);
 free(RfileNameMessage);
 free(RfileNameMessagePrim);
 free(RsmbcLockFile);
 RFSfree();
 RDBG("----stop----\n");
 RfreeDebug();
 RsigTerm();
 return(0);
}
