
#ifndef _KINO_PPM_READER_
#define _KINO_PPM_READER_

#include "DVScalingParams.h"
#include "PixbufUtils.h"
#include <stdio.h>

class PPMReader : virtual public DVScalingParams, public PixbufUtils
{
	private:
		int dropper;
		int count;
	public:
		GdkInterpType scaler;
		PPMReader( ) : dropper( 1 ), count( 0 ), scaler( GDK_INTERP_HYPER ) { }
		bool ReadPPM( uint8_t *, int, int );
		void SetDropper( int _dropper ) { dropper = _dropper; }
	protected:
		void Composite( uint8_t *, int, int, uint8_t *, int, int, int );
		int ReadNumber( );
		bool ReadHeader( int &, int & );
		bool ReadScaledFrame( uint8_t *, int, int );
		bool ReadAspectFrame( uint8_t *, int, int );
		bool ReadCroppedFrame( uint8_t *, int, int );
		virtual FILE *GetFile( ) = 0;
};

#endif
