/*
 * EffecTV - Realtime Digital Video Effector
 * Copyright (C) 2001-2002 FUKUCHI Kentaro
 *
 * DumbTV - no effect.
 * Copyright (C) 2001-2002 FUKUCHI Kentaro
 *
 */

#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include "EffecTV.h"
#include "utils.h"

static int effectStart();
static int effectStop();
static int effectDraw();

static char *effectname = "SepiaTV";
static int state = 0;

effect *sepiaRegister()
{
	effect *entry;

	entry = (effect *)malloc(sizeof(effect));
	if(entry == NULL) return NULL;
	
	entry->name = effectname;
	entry->start = effectStart;
	entry->stop = effectStop;
	entry->draw = effectDraw;
	entry->event = NULL;

	return entry;
}

int effectStart()
{
	if(video_grabstart())
		return -1;
	state = 1;
	return 0;
}

int effectStop()
{
	if(state) {
		video_grabstop();
		state = 0;
	}

	return 0;
}

int effectDraw()
{
	if(video_syncframe())
		return -1;
	if(screen_mustlock()) {
		if(screen_lock() < 0) {
			return video_grabframe();
		}
	}
	if(stretch) {
		image_stretch((RGB32 *)video_getaddress(), video_width, video_height,
		              (RGB32 *)screen_getaddress(),
					  screen_width, screen_height);
	} else {
		uint8_t r, g, b;
		uint8_t *p = video_getaddress();
		uint8_t *q = screen_getaddress();
		uint8_t *end = p + ( video_width * video_height ) * sizeof( RGB32 );
		while ( p < end )
		{
       		r = *p ++;
			g = *p ++;
			b = *p ++;
			*p ++;
			r = (uint8_t)( 0.299 * r + 0.587 * g + 0.114 * b );
			*q ++ = r + 30 < 255 ? r + 30 : 255;
			*q ++ = r;
			*q ++ = r - 30 >= 0 ? r - 30 : 0;
			*q ++ = 0;
		}
	}
	if(screen_mustlock()) {
		screen_unlock();
	}

	if(video_grabframe())
		return -1;

	return 0;
}
