/*
 * RawDVFileInput.h -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_RAW_DV_FILE_INPUT_
#define _KINO_RAW_DV_FILE_INPUT_

#include <string>
using std::string;

#include "DVPumpProvider.h"
#include <stdio.h>

class Frame;

/** This implementation can be used to read DV frames out of an open C FILE 
	stream such as stdin. Note that the provider threaded implementation is 
	provided here, essentially providing a read ahead - this allows a raw DV 
	provider connected via a pipe to avoid unecessary io related blocks.
*/

class RawDVFileInput : public DVPumpProvider
{
	private:
		FILE *file;
		int index;
	public:
		RawDVFileInput( ) : file( NULL ), index( 0 ) { }
		RawDVFileInput( FILE *_file ) : file( _file ), index( 0 ) { }
		virtual string LogId( ) { return "RawDVFileInput"; }
		void SetFile( FILE * );
	protected:
		bool ReadFrame( Frame & );
		FILE *GetFile( );
};

#endif

