#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <errno.h>
#include "socket.h"
#include "vsprintf.h"

Socket::Socket(const char *_hostname, int _port)
{
    sock = 0;
    hostname = strdup(_hostname);
    port = _port;
    status = connect_socket();
}

Socket::~Socket()
{
    if (sock) close(sock);
    if (hostname) free(hostname);
    hostname = NULL;
}

int Socket::Ok()
{
    struct stat stat_buf;

    return (status && !fstat(sock, &stat_buf));
}

int Socket::connect_socket()
{
    struct hostent *he;
    struct sockaddr_in sa;

    if (!(he = gethostbyname(hostname))) return 0;

    if ((sock = socket(he->h_addrtype, SOCK_STREAM, 0)) < 0) return 0;

    memset(&sa, 0, sizeof(sa));
    memcpy(&sa.sin_addr, he->h_addr, he->h_length);
    sa.sin_family = he->h_addrtype;
    sa.sin_port = htons(port);

    return connect(sock, (struct sockaddr*)&sa, sizeof(sa)) >= 0;
}

int Socket::bind_socket()
{
    struct hostent *he;
    struct sockaddr_in sa;

    if (!(he = gethostbyname(hostname))) return 0;

    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) return 0;

    memset(&sa, 0, sizeof(sa));
    sa.sin_family = he->h_addrtype;
    sa.sin_port = htons(port);

    if (bind(sock, (sockaddr*)&sa, sizeof(sa))) return 0;
    if (listen(sock, 5)) return 0;
    return 1;
}

int Socket::MsgAvail(AvailType mode)
{
    fd_set fd;
    struct timeval tv = {0,0};

    FD_ZERO(&fd);
    FD_SET(sock, &fd);
    switch (mode)
    {
        case SCK_READ:
             return select(sock+1, &fd, NULL, NULL, &tv) > 0;
             break;
        case SCK_WRITE:
             return select(sock+1, NULL, &fd, NULL, &tv) > 0;
             break;
        case SCK_EXC:
             return select(sock+1, NULL, NULL, &fd, &tv) > 0;
        default:
             return 0;
    }
    return 0;
}

int Socket::WriteMsg(const char *fmt, ...)
{
    char buf[MAX_MSG_LEN];
    va_list args;

    va_start(args, fmt);
    VSPRINTF(buf, sizeof(buf)-1, fmt, args);
    va_end(args);
    return WriteMsg((void*)buf, strlen(buf));
}

int Socket::WriteMsg(const void *buf, int buf_len)
{
    return write(sock, buf, buf_len);
}

char *Socket::ReadMsg(int max_len)
{
    char *buf = (char*)ReadMsg(NULL, max_len), *ret;
    if (max_len > 0)
    {
        char *eol = strstr(buf, "\n");
        if (eol) *eol = 0;
        ret = strdup(buf);
    }
    if (buf) delete buf;
    return ret;
}

void *Socket::ReadMsg(void *buf, int &buf_len)
{
    void *alloc_buf;
    int bytes_read = 0, flag;

    if (buf_len <= 0) buf_len = MAX_MSG_LEN;
    alloc_buf = (buf) ? buf : (void*)malloc(buf_len);
    if (!alloc_buf)
    {
        buf_len = -1;
        return NULL;
    }
    if (!buf) memset(alloc_buf, 0, buf_len);
    while (bytes_read < buf_len) {
        flag = read(sock, (char*)alloc_buf + bytes_read, buf_len);
        if (!flag || flag == -1) break;
        bytes_read += flag;
    }
//    if ((buf_len = read(sock, alloc_buf, buf_len)) <= 0)
//    {
//        if (!buf) delete alloc_buf;
//        return NULL;
//    }

    return alloc_buf;
}

char *Socket::ReadAll(int &buf_len)
{
    char *tmp_buf, *return_buf = NULL, *buf2;
    int bytes_read = 0, flag, finish = 0, tmp_buf_size = MAX_MSG_LEN;

    // pomocniczny bufor tylko do czytania z socketu
    tmp_buf = (char*)malloc(tmp_buf_size);

    while (!finish) {
        flag = read(sock, (char*)tmp_buf, tmp_buf_size);
        if (!flag || flag == -1) {
		finish = 1;
		break;
	}
        bytes_read += flag;

        // teraz zaalokujemy pamiec na pobrane dane
        return_buf = (char*)realloc(return_buf, bytes_read);
        memmove(return_buf + bytes_read - flag, tmp_buf, flag);
    }

    // usuwamy tymczasowy bufor
    free(tmp_buf);

    buf_len = bytes_read;
    buf2 = (char*)malloc(buf_len+1);
    memmove(buf2, return_buf, buf_len);
    buf2[buf_len] = 0;
    free(return_buf);
    return buf2;
}

int Socket::ReadMsg(int buf_len, void *buf)
{
    if (!buf || buf_len<=0) return -1;

    if ((buf_len = read(sock, buf, buf_len)) <= 0) return -1;

    return buf_len;
}


#ifndef NO_ANYIP

int AnyIPSocket::connect_socket() {
    struct addrinfo * ai_cptr = NULL, * ai_bptr = NULL,* ai_ptr = NULL,ai_hints;
    char ai_port[65]; /* XXX: tymczasowa proteza */
    int err = 0;

    memset (ai_port,0,sizeof (char)*65);
    memset (&ai_hints,0,sizeof (ai_hints));
    ai_hints.ai_family = PF_INET;
    ai_hints.ai_socktype = SOCK_STREAM;
    snprintf (ai_port,64,"%u",port);

    if ((err = getaddrinfo (hostname,ai_port,&ai_hints,&ai_cptr))){
#ifdef DEBUG
	fprintf (stderr,"getaddrinfo: connect: %s:%s: %s !\n",hostname,
		ai_port,gai_strerror (err));
#endif /* DEBUG */
	return (0);
    }

    if (srcip){
	memset (&ai_hints,0,sizeof (ai_hints));
	ai_hints.ai_family = PF_INET;
	ai_hints.ai_socktype = SOCK_STREAM;
	if ((err = getaddrinfo (srcip,NULL,&ai_hints,&ai_bptr))){
#ifdef DEBUG
	    fprintf (stderr,"getaddrinfo: bind: %s: %s !\n",srcip,
		gai_strerror (err));
#endif /* DEBUG */
	    return (0);
	}
    }

    for (ai_ptr = ai_cptr;ai_ptr;ai_ptr = ai_ptr->ai_next){
	if ((sock = socket (ai_ptr->ai_family,ai_ptr->ai_socktype,
	    ai_ptr->ai_protocol)) < 0){
#ifdef DEBUG
	    fprintf (stderr,"socket: %s !\n",strerror (errno));
#endif /* NS88_DEBUG */
	    errno = 0;
	    continue;
	}
	if (srcip){
	    if (!bindaddr_socket (ai_bptr)){
#ifdef DEBUG
		fprintf (stderr,"bindaddr_socket: %s !\n",strerror (errno));
#endif /* DEBUG */
		if (close (sock) < 0){
#ifdef DEBUG
		    fprintf (stderr,"close: %s !\n",strerror (errno));
#endif /* DEBUG */
		}
		sock = -1;
		errno = 0;
		continue;
	    }
	}
	if (connect (sock,ai_ptr->ai_addr,ai_ptr->ai_addrlen) < 0){
#ifdef DEBUG
	    fprintf (stderr,"bind: %s !\n",strerror (errno));
#endif /* DEBUG */
	    if (close (sock) < 0){
#ifdef DEBUG
		fprintf (stderr,"close: %s !\n",strerror (errno));
#endif /* DEBUG */
	    }
	    sock = -1;
	    errno = 0;
	    continue;
	}
	break;
    }

    if (ai_ptr)
	err = 1;
    else
	err = 0;

    freeaddrinfo (ai_bptr);
    freeaddrinfo (ai_cptr);

return (err);
}

int AnyIPSocket::bindaddr_socket (struct addrinfo * ai_bptr) {
    for (;ai_bptr;ai_bptr = ai_bptr->ai_next){
	if (bind (sock,ai_bptr->ai_addr,ai_bptr->ai_addrlen)  < 0)
	    continue;
	break;
    }
	return (ai_bptr ? 1 : 0);
}

AnyIPSocket::AnyIPSocket(const char *_hostname, int _port,char * _srcip)
{
    sock = -1;
    hostname = strdup(_hostname);
    port = _port;
    srcip = _srcip;
    status = connect_socket();
}

#endif // NO_ANYIP
