/*==================================================================
 * midi.h - Header file for midi input routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __MIDI_H__
#define __MIDI_H__

#include <glib.h>

#include "config.h"

enum
{ MIDI_NONE,
#ifdef ALSA_SUPPORT
  MIDI_ALSA_SEQ,
  MIDI_ALSA_RAW,
#endif
#ifdef OSS_SUPPORT
  MIDI_OSS,
#endif
  MIDI_COUNT
}
MidiType;

typedef struct _MidiDriverInfo
{
  gchar *name;			/* textual name of driver */
  void (*config) (void);	/* Load smurfcfg vars for driver */
  gint (*init) (void);		/* Initialize driver */
  void (*close) (void);		/* Close driver */
  gint (*read) (guint8 * buf, guint size); /* Read midi data */
}
MidiDriverInfo;

/* data */

extern MidiDriverInfo midi_drivers[];

gint midi_driver;
gint midi_active;

gint midi_bank;
gint midi_preset;
gint midi_bend;

/* function prototypes */

gint midi_init_from_config (void);
gint midi_auto_init (void);
gint midi_locate_byname (gchar * name);
void midi_set_driver (gint driver);
gint midi_init (void);
gint midi_close (void);
void midi_read (void);


#endif /* __MIDI_H__ */
