/*==================================================================
 * sfdofunc.h - Header file for Sound font undo/redo item functions
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SFDOFUNC_H__
#define __SFDOFUNC_H__

#include <glib.h>
#include "sfont.h"
#include "sfundo.h"

typedef struct _SFDoFuncInfo
{
  gchar *descr;                         /* description */
  gint (*restore) (SFDoItem * item);	/* restore state from doitem */
  gint (*restate) (SFDoItem * refitem,  /* - save redo data for refitem */
		   SFDoItem * newitem); /* - store in newitem */
  void (*free) (SFDoItem * item);	/* free state data */
}
SFDoFuncInfo;

enum
{
  DOFUNC_INVALID,

  DOFUNC_NOITEM,		/* save undo state for new item (item ID) */
  DOFUNC_SFITEM,		/* save a sound font item */
  DOFUNC_SFINFO,		/* single sfont info item */

  DOFUNC_LAST
};

extern SFDoFuncInfo sfdofuncs[];

void dofunc_noitem_save (SFItemID itemid);
void dofunc_sfitem_save (SFItemID itemid);
void dofunc_sfinfo_save (SFItemID sfitemid, guint8 id);

#endif
