/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __HSTACK_H__
#define __HSTACK_H__


#include <gtk/gtk.h>

/*
 * ag_history_stack_init
 * initialize the history stack (puts a NULL item at the begining), 
 * this is for the stack to work smoothlier. To find out if
 * there is another item on the stack, we perform the test
 * if(hstack->next != NULL) { there is another item }, the init
 * makes this work. 
 */
void
ag_history_stack_init();



/*
 * ag_history_stack_rewind
 * point the history stack, to the first item.
 */
void
ag_history_stack_rewind();



/*
 * ag_history_stack_push_item
 * pushes a new item to the stack
 * after the null item.
 */
void
ag_history_stack_push_item(gchar *str);



/*
 * ag_history_stack_up
 * write to the text the next item in the stack.
 */
void
ag_history_stack_up();


/*
 * ag_history_stack_down
 * write to the text the previous item in the stack.
 */
void
ag_history_stack_down();




#endif /* __HSTACK_H__ */
