/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "keytable.h"
#include "ag_defs.h"

/******************************************************************************/
/* ag_make_keytable                                                           */
/* creates a key table with the specified number of rows and columns, label,  */
/* data and a function that is connected to the button's clicked signal       */
/******************************************************************************/

GtkWidget *
ag_make_keytable (gint        rows,
		  gint        columns,
		  gchar      *label[],
		  gchar      *data[],
		  gint	     *map,
		  void      (*func)(gpointer))
{
  
	GtkWidget *table;
	GtkWidget *button;
	gint button_i, active_row = 1, active_column = 1;
	
	
	table = gtk_table_new (rows, columns, TRUE);
	
	for(button_i = 1; button_i <= rows * columns ; button_i++ ){
		
		button = gtk_button_new_with_label(label[button_i-1]);
		
		gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
					  GTK_SIGNAL_FUNC(func), 
					  (gpointer) data[button_i-1]);
		
		gtk_table_attach_defaults(GTK_TABLE(table), button, 
					  active_column-1, active_column,
					  active_row-1, active_row);
		
		gtk_widget_show (button);
		
		if (map != NULL)
			ag_set_button_map(map[button_i-1], button);
		
                /* When we finished with a row, 
		 * jump to the next column */
		if(active_row == rows){

			active_row=1;
			active_column++;
		} else 
			active_row++;
	}
	
	return table;
}
