/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __PREFERENCES_H__
#define __PREFERENCES_H__


#include <gnome.h>


/* Forward decalration of the function that
 * pops up the preferences editor */
void 
ag_edit_preferences(GtkWidget        *widget, 
		    gpointer          data);


/* Forward decalration of the function that
 * gets the preferences from the config file */
void 
ag_get_preferences();
     


/* Forward declaration of the function that
 * creates the colorpicker with a label */
GtkWidget *
ag_color_picker_new(gchar         *label,
		    GdkColor      *colordata);


/* Forward declaration of the function that
 * creates the fontpicker with a label */
GtkWidget *
ag_font_picker_new(gchar        *label,
		   gchar        *font);


/* Forward declaration of the function that
 * sets the preferences active */
void 
ag_set_preferences(GtkWidget      *widget,
		   gint            page,
		   gpointer        data);


/* Forward declaration of the function that
 * sets the new color in the temporary
 * preferences */
void 
ag_color_set(GtkWidget        *cp,
	     guint             red,
	     guint             green,
	     guint             blue,
	     guint             alpha,
	     gpointer          data);


/* Forward declaration of the function that
 * sets the new font in the temporary
 * preferences */
void 
ag_font_set(GtkWidget        *fp,
	    gchar            *string,
	    gpointer          data);




/*
 * ag_set_text_style
 */
void
ag_set_text_style();

#endif /* __PREFERENCES_H__ */
