(provide 'snd-peak-phases.scm)
(load "primes.scm")

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

#(1  1.0    #(0))
#(2  1.76   #(0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots (vct -2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the 1st min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
#(3  2.1949383250709 #(0 0 1)

     1.9798054823226 #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 #(0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 #(0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 #(0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall '#(0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for #(0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall #(0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 #(0.0 0.41022177723939 1.6832780274654)
     1.979716725384 #(0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 #(0.0 1.4102202429311 1.6832728267862)
     )


;;; 4 all --------------------------------------------------------------------------------
#(4  2.2962718935302 #(0 1 1 1)

     2.040  #(0 33/35 67/50 10/9)               ;#(0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 #(0.000 0.072 0.674 1.912)
     2.04012799263 #(0.000 0.928 1.326 1.088)
     2.04012799263 #(0.000 1.072 0.674 0.912)
     2.04012799263 #(0.000 1.928 1.326 0.088)

     2.0392323180235 #(0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 #(0.000000 0.944585 1.341508 1.115059)
     2.038954 #(0.000000 1.055406 0.658486 0.884929)
     2.038954 #(0.000000 0.055405 0.658485 1.884926)
     2.038954 #(0.000000 1.944593 1.341515 0.115071)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
#(5  2.5405211753511 #(0 1 0 0 0)

     2.3434929847717 #(0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 #(0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 #(0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 #(0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 #(0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 #(0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 #(0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 #(0.000000 1.845332 1.664532 0.420369 1.593338)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
#(6  2.8200183503167 #(0 0 0 0 1 0) 

     2.5598928928375 #(0.0 0.91140931844711 0.34124284982681 1.3568490743637 1.4451304674149 1.2563138008118)
     2.5509102344513 #(0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 #(0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 #(0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 #(0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 #(0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 #(0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 #(0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
#(7  3.072141248417 #(0 0 0 1 1 0 1)

     2.639426 #(0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 #(0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 #(0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 #(0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
#(8  3.5725696916739 #(0 1 0 0 0 0 1 1)
     3.4905790371793 #(0 1 0 0 1 1 1 0)

     2.795099 #(0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794973 #(0.000000 0.666912 0.808057 1.605873 0.837778 0.045418 0.145384 -0.125627)
     2.794748 #(0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 #(0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 #(0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     )

;;; 9 all --------------------------------------------------------------------------------
#(9  3.7118878501776 #(0 0 0 0 1 0 0 0 1)
     3.5954569026984 #(0 1 1 0 1 0 1 1 1)

     2.962087 #(0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 #(0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 #(0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 #(0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 #(0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
#(10 3.8132503352626 #(0 1 0 1 0 0 0 0 0 1)
     3.7726427002737 #(0 1 1 0 0 0 0 1 0 1)
     3.7587492407668 #(0 1 1 0 1 1 1 0 0 0)
     3.7587492407668 #(0 0 1 1 1 0 1 1 0 1)

     3.102964 #(0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 #(0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 #(0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 #(0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102729 #(0.000000 -0.072172 1.602638 1.494434 -0.054524 1.785698 0.940876 0.169981 0.895530 1.495531)
     3.102679 #(0.000000 -0.071505 1.603768 1.495148 -0.052966 1.786780 0.942656 0.171631 0.897221 1.498092)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
#(11 4.0969838225299 #(0 0 1 1 0 0 0 0 1 0 1)
     4.0506916989601 #(0 0 0 1 1 1 1 0 1 1 0)
     3.8018732822274 #(0 1 0 0 1 0 0 0 1 1 1)
     3.8018732822274 #(0 0 0 1 1 1 0 1 1 0 1)

     3.218779 #(0.000000 1.481192 0.090871 1.382649 0.458289 0.338680 0.056042 0.328676 0.834049 1.786486 1.800056)
     3.218745  #(0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 #(0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 #(0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 #(0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
#(12 3.761           #(0 0 1 1 0 0 0 0 0 1 0 1)
     3.7616552322386 #(0 1 1 0 0 1 0 1 0 0 0 0)

     3.390214 #(0.000000 1.090729 0.365806 1.643109 0.802167 1.224244 0.152508 0.190760 1.518783 1.662203 1.561813 -0.056814)
     3.389584 #(0.000000 0.081158 0.353056 0.623087 0.775861 0.199327 0.127597 1.160276 1.479330 0.612404 1.515935 0.889377)
     3.389586 #(0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 #(0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 #(0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 #(0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
#(13 4.2969298731102 #(0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.1211657406183 #(0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 #(0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 #(0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 #(0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 #(0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 #(0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 #(0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
#(14 4.3488449994701 #(0 0 1 1 0 1 0 1 1 0 0 0 0 0)
     4.1603193984251 #(0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.615056 #(0.000000 -0.014234 1.497005 1.525139 0.510798 0.632906 1.943720 0.571193 0.639383 0.229407 1.337049 0.146893 1.848962 0.407090)
     3.613339 #(0.000000 1.024769 1.581138 0.589649 0.616118 1.792590 0.082043 1.743552 0.858157 1.441060 1.566137 1.409695 0.151752 1.740508)
     3.613280 #(0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 #(0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
#(15 4.4060654286219 #(0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.769174 #(0.000000 0.861484 1.066267 1.645788 0.266828 0.280266 1.728769 1.041069 0.986580 -0.030711 1.080503 1.645587 1.174768 1.625077 1.375877)
     3.768991 #(0.000000 0.863434 1.069349 1.651266 0.272078 0.287377 1.735528 1.050008 0.997192 -0.020076 1.092043 1.658049 1.188297 1.641481 1.391589)
     )

;;; 16 all --------------------------------------------------------------------------------
#(16 4.6832396970099 #(0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)
     4.5445760745314 #(0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.880044 #(0.000000 1.305525 1.470275 0.177035 0.840097 1.175803 -0.045240 1.607574 1.078362 0.676837 1.296177 0.358482 1.543390 0.161953 0.029701 -1.946850)
     3.875293 #(0.000000 0.731415 0.678125 1.193317 1.630455 1.274923 -0.010275 1.463125 0.520861 0.201904 -0.170540 -0.119593 1.314021 1.618273 0.238721 1.406287)
     3.875080 #(0.000000 0.730612 0.678979 1.195144 1.632126 1.276744 -0.008560 1.467028 0.525375 0.204869 -0.166129 -0.115302 1.317856 1.622654 0.244306 1.412402)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
#(17 4.7478643837553 #(0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1)
     4.7478643837553 #(0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1)
     4.7654988506492 #(0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)
     4.7654988506492 #(0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1)

     4.014837 #(0.000000 1.466046 1.041812 -0.108499 1.356223 0.981589 1.262667 0.715209 0.388569 1.081759 1.825430 0.656039 1.178209 0.785251 1.435495 -0.342701 -0.159210)
     4.009869 #(0.000000 1.659692 0.153864 0.208373 0.465377 0.801497 0.333865 -0.306619 0.133983 0.553164 0.090623 1.393118 -0.083771 1.035016 -1.047840 0.020577 0.849233)
     3.981459 #(0.000000 0.520484 1.429480 0.505816 -0.891395 0.114390 0.146335 0.416197 0.938893 0.898753 0.507264 0.650687 -0.081499 -0.607990 0.213218 -0.096782 -0.652476)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
#(18 4.9109328272248 #(0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0)
     4.8247395547715 #(0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0)
     4.795  #(0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.160068 #(0.000000 1.247966 0.634845 0.085105 1.281747 1.591288 0.560708 1.554818 0.532041 1.253325 0.973787 0.305025 0.369962 0.426191 -0.060193 0.478556 0.689072 1.025864)
     4.149424 #(0.000000 0.783719 1.424772 -0.028969 0.797469 0.495441 1.555906 0.574291 1.602121 0.919568 1.186181 1.878000 1.832983 1.781966 0.287268 1.741363 1.571076 1.265215)
     4.145376 #(0.000000 0.815970 1.442468 0.022437 0.838057 0.561089 1.647234 0.678944 1.711039 1.021597 1.327383 0.016884 -0.030470 1.937927 0.480054 1.947188 1.779952 1.482341)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
#(19 5.0964118877766 #(0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 0 0 0 1)
     5.0269187181249 #(0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0)
     5.0140104455275 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0)
     4.957  #(0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.256823 #(0.000000 0.950552 1.078946 1.827333 0.322429 0.515165 1.448194 1.262486 0.963019 0.265994 0.371763 0.920917 0.630954 0.586208 1.035067 0.365945 1.213903 0.045859 1.507359)
     4.236757 #(0.000000 1.035424 1.317375 0.882321 0.748630 1.392844 1.209695 0.917957 1.063517 0.320073 1.579879 0.456384 1.606003 -0.204593 -1.100470 0.700110 1.199787 1.220259 -0.044138)
     4.223666 #(0.000000 0.962025 0.721631 1.138738 1.342295 0.675056 0.848936 1.157044 1.060853 -0.213787 0.531124 1.684505 0.561245 0.375645 1.309393 -0.531388 0.959835 0.983902 0.285296)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
#(20 5.2602326468873 #(0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1)
     5.2536671092168 #(0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1) 
     5.2516581503036 #(0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1)
     5.2027356749364 #(0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0) 
     5.202707605727 #(0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.290058 #(0.000000 1.287568 1.468290 -0.170532 1.858695 0.280488 0.217365 -0.031942 0.876344 1.219692 0.026561 0.381289 1.735799 1.508060 1.291588 0.006572 1.225731 0.645841 1.236621 0.419452)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
#(21 5.3651112556805 #(0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1)
     5.3503630356826 #(0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1)
     5.3430035169068 #(0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1)
     5.3468859417495 #(0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1)
     5.3164971341632 #(0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 0) 
     5.3164971341632 #(0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.484397 #(0.000000 1.399581 1.230490 1.289720 -0.005391 1.417174 -0.222099 1.544621 0.160786 1.057475 0.320522 1.788712 1.040114 0.988797 1.529192 0.536731 0.600787 0.298519 0.720851 1.592406 -0.083584)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
#(22 5.3384906472168 #(0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     5.3118962410791 #(0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0)
     5.29249935509144 #(0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1) 
     5.292244006282 #(0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.622803 #(0.000000 1.340373 0.970954 1.002159 0.880275 1.416080 1.819200 1.007752 0.255081 0.347189 0.600359 0.574629 0.015990 0.999438 1.635477 0.619917 0.631959 1.121023 0.599154 1.883352 0.740818 1.129065)
     4.588140 #(0.000000 -0.096778 1.080722 0.593207 -0.254680 1.023732 0.716557 1.901465 -0.019583 0.278478 1.160188 0.996330 1.054608 1.061984 1.434750 0.905801 0.882108 1.425520 0.362314 1.555862 0.347441 1.064021)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
#(23 5.5572876930237 #(0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0)
     5.35928895203514 #(0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1) 
     5.3592889520338 #(0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.607681 #(0.000000 0.689399 -0.223358 0.265838 1.213936 0.913933 0.191373 1.489050 1.370717 0.847890 0.362722 0.592331 0.586381 0.000455 1.084840 1.698411 1.578127 0.043618 0.291463 1.342365 0.078224 -0.076344 0.195753)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
#(24 5.7082858085632 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0)
     5.6697635650635 #(0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     5.6446962356567 #(0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0)
     5.635  #(0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1) 
     5.6358969066981 #(0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.730847 #(0.000000 1.860054 1.365565 1.300661 0.304467 0.364421 -0.013175 0.287107 1.148150 1.732528 0.305694 1.054141 0.959139 0.689514 0.150812 0.767232 0.724213 0.359240 1.442900 0.475499 1.678401 0.330818 0.144568 0.751992)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
#(25 5.7284736633301 #(0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0)
     5.7190117835999 #(0 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1)
     5.6488965032573 #(0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0) 
     5.6488965032573 #(0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.855641 #(0.000000 0.229926 1.726904 0.449778 0.015484 0.016859 0.462379 0.871412 0.609322 0.654662 0.062760 0.825989 0.576895 -0.081196 -0.112104 1.739215 0.575276 0.891044 1.388407 0.667892 1.843741 1.342090 1.776343 0.652054 1.004535)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8922033309937 #(0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0)
     5.8206262588501 #(0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0)
     5.78661186695166 #(0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1) 
     5.7865648269653 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.023346 #(0.000000 0.471497 0.419434 0.860585 1.369474 -0.146335 1.642121 0.161223 1.825222 0.594228 1.689539 0.413066 1.098262 1.472516 1.249094 1.170567 0.839656 0.942436 0.149512 -0.243079 1.269486 1.068124 -0.150509 1.648862 0.945727 1.703664)
     5.008256 #(0.000000 0.356007 0.611393 0.800030 0.608139 -0.552559 0.276762 0.954695 0.541230 0.391873 0.749201 -0.287679 0.663114 1.822966 -0.042535 -0.215786 1.534399 0.896769 0.284021 0.968921 0.944615 0.005656 -0.473527 0.937503 1.376587 0.108845)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
#(27 5.980658531189 #(0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     5.8753982451551 #(0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0) 
     5.8753981590271 #(0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.066453 #(0.000000 1.180887 1.012981 -0.037241 0.953126 0.743204 0.046304 -0.010627 1.594368 1.830120 1.926912 0.836044 0.497153 0.820806 0.580883 1.308790 0.813677 0.203614 0.448890 0.870192 1.163708 0.319673 0.498880 -0.075386 0.820143 1.666968 0.421343)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
#(28 6.1332263946533 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0)
     6.107029914856 #(0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     6.0962085723877 #(0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0) 
     6.0962085723877 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.201582 #(0.000000 -0.594236 0.471372 -0.239106 0.026372 1.367317 -1.367383 0.475651 -0.077031 -1.126466 0.500322 -0.840077 0.289150 0.017573 1.087716 1.066819 1.177512 0.077022 0.675500 0.393911 1.002792 0.832733 0.902383 1.149342 0.256199 0.532177 1.776896 0.135269)
     5.161016 #(0.000000 0.609398 -0.031546 0.163654 1.750544 0.009072 1.168722 1.319687 0.754527 1.449905 0.404768 1.387397 -0.443377 1.700390 0.448442 1.105795 0.302344 0.108046 0.813277 -1.223453 0.735575 -0.228080 1.376959 0.772459 0.355021 0.857861 0.747767 -0.540969)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
#(29 6.2162199020386 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     6.2025485038757 #(0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1)
     6.1994609975558 #(0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 0)
     6.168496131897 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1) 
     6.168496131897 #(0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.244731 #(0.000000 1.423197 1.434334 0.954277 0.877662 1.948724 1.591838 0.966340 0.952717 1.429672 0.787029 0.555356 0.405697 0.817643 1.603999 0.138279 0.926533 1.343354 1.048968 1.281826 1.347978 1.753988 1.784362 0.779861 0.066133 1.166301 0.329314 1.131806 1.874060)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
#(30 6.3668465614319 #(0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1) 
     6.3080444335938 #(0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1)
     6.2868418693542 #(0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1)
     6.257221698761 #(0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.396180 #(0.000000 1.520615 0.225616 0.287942 1.352721 1.627968 0.463888 1.771367 0.587849 1.027773 -0.033501 -0.102620 0.226920 1.922043 0.200259 0.023109 0.666954 1.058135 0.756098 1.607795 0.775242 0.535327 1.831042 0.484415 1.540370 1.001150 0.363611 0.315720 1.783111 -0.093791)
     5.366694 #(0.000000 1.367293 0.678335 1.056059 -0.506652 0.354228 0.103786 0.546097 0.755979 0.321279 -0.471933 -0.199299 0.505109 0.194951 -0.044195 1.645993 0.866175 1.019312 1.251553 0.153557 0.520073 -0.271182 0.225402 -0.451939 0.517701 0.215495 0.989027 0.341703 0.791872 0.749094)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
#(31 6.4472563825087 #(0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1) 
     6.3776631355286 #(0 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1)
     6.3353910446167 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)
     6.3243918418884 #(0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

     5.483548 #(0.000000 1.716513 0.734155 1.284407 0.002926 1.138357 1.651222 0.840380 0.862951 0.362868 -0.011541 1.508984 0.900956 1.004294 1.662373 0.522900 0.542553 0.647212 1.649604 0.938574 0.006447 1.743627 0.420681 1.628282 0.676409 0.803864 1.141938 1.155986 0.676801 1.099313 1.174563)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
#(32 6.5261273384094 #(0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0)
     6.4710988998413 #(0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0)
     6.4692246308309 #(0 0 1 1 0 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0)
     6.4519599479542 #(0 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1)
     6.4451498985291 #(0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.529767 #(0.000000 -0.357496 1.295472 -0.244166 0.378862 0.343677 0.387655 0.125795 0.157477 1.354195 0.239429 0.278240 0.142338 1.318038 1.716131 1.194338 1.731815 1.633958 0.445551 0.658322 0.932928 0.324708 1.907298 1.327700 0.501470 1.391423 1.750708 0.386360 0.706755 0.076956 0.832906 -0.015253)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
#(33 6.678719997406 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 0) 
     6.6342549324036 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1)
     6.6147227287292 #(0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0)
     6.5579299926758 #(0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.635107 #(0.000000 0.096917 0.534048 0.844232 0.664210 0.830370 1.909422 0.035015 0.156012 0.327754 1.408862 -0.022849 0.930596 1.245585 0.370155 0.652349 -0.062548 1.851506 0.444607 0.245493 0.778912 0.461144 -0.163445 0.929749 0.597185 1.314796 1.697920 1.195133 0.256759 1.266343 1.688596 1.108980 0.567202)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
#(34 6.7310481071472 #(0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
     6.7281470298767 #(0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.7141165733337 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0)
     6.6820402145386 #(0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 0)
     6.6788883209229 #(0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0)
     6.6782836914062 #(0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.721275 #(0.000000 1.537213 0.239671 0.278042 1.094883 0.274881 0.871861 1.496857 1.521795 0.761213 1.656084 0.025131 1.235452 0.206266 1.321622 0.722819 0.794646 1.810454 1.109962 1.456186 1.070438 0.656560 1.724659 1.407688 -0.522881 1.349622 1.540863 1.488043 0.627895 0.673112 0.878488 -0.129260 -0.021006 0.554817)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8652677536011 #(0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)
     6.8216953277588 #(0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     6.7839112281799 #(0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0)
     6.7759642601013 #(0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     6.7637429237366 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.769511 #(0.000000 0.102697 1.401830 0.818397 1.461851 0.154032 1.618494 1.534460 1.543814 0.875127 1.319240 1.294792 1.413591 0.147300 1.056367 0.647379 1.391041 1.070554 0.137544 0.362172 1.848827 1.486280 0.790850 1.754258 0.990175 1.205429 0.198438 -0.165833 0.163564 -0.016866 0.359072 0.684081 1.633963 0.564667 0.903834)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
#(36 6.9388113021851 #(0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 0)
     6.934184551239 #(0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0)
     6.9237461090088 #(0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0)
     6.9208335876465 #(0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1)
     6.8763957023621 #(0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0)
     6.8008880615234 #(0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.931449 #(0.000000 1.020268 0.677676 0.141480 0.933164 0.775943 0.190974 1.852375 0.763224 0.240685 0.277882 0.163474 1.552588 0.007697 0.283092 1.674709 -0.345165 0.591058 0.945716 0.824253 0.043245 -0.089554 0.231180 1.353274 0.983801 0.173104 0.583544 0.693163 1.001038 0.832122 1.162817 1.689517 0.636045 1.729156 0.451707 1.432502)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1209874153137 #(0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0)
     7.1156206130981 #(0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0)
     7.1152505874634 #(0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0)
     7.1046371459961 #(0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0)
     7.0939922332764 #(0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0588836669922 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0)
     7.0475845336914 #(0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0)
     7.0251078605652 #(0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.933969 #(0.000000 1.357580 1.821190 0.294387 1.750925 1.845472 1.054143 1.356098 0.293620 0.391313 1.778601 1.534928 0.426019 0.315757 -0.095725 0.216499 0.999813 1.634650 1.366520 0.730349 0.391123 1.330014 0.106679 1.912375 0.325125 0.431168 1.541075 0.670579 0.023629 0.320519 1.802217 0.442394 1.635271 1.059117 1.341290 1.420508 1.824162)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993880271912 #(0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0)
     7.1926069259644 #(0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 0)
     7.1880865097046 #(0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0)
     7.1807923316956 #(0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0)
     7.1668581962585 #(0 0 1 0 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0)
     7.1260185241699 #(0 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0)
     7.1221342086792 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.0688242912292 #(0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.141081 #(0.000000 0.476359 1.183611 1.424660 0.720669 0.084602 1.874771 1.422499 0.404825 0.949357 0.682500 1.709551 1.802453 0.795775 1.088809 0.144361 1.364027 0.520155 0.230721 0.817258 1.067794 1.407900 0.308825 1.598206 1.778867 1.700646 -0.474543 1.394960 1.012106 1.341722 0.530505 1.592235 0.510888 0.855540 1.374812 1.298891 0.989427 1.632520)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3091864585876 #(0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0)
     7.2959136962891 #(0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0)
     7.2940211296082 #(0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0)
     7.2713379859924 #(0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0)
     7.2698922157288 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 0 0)
     7.2519464492798 #(0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0)
     7.2313327789307 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0)
     7.1506487936623 #(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.130953 #(0.000000 0.038461 0.171605 1.637522 1.177657 0.764596 -0.121999 0.532157 0.566373 -0.107168 -0.131067 0.222564 0.601164 1.033230 1.720725 1.942372 1.261330 -0.012481 1.519629 1.204483 0.906347 1.595016 1.659825 1.493185 0.901436 0.172939 0.594674 1.531973 0.100311 1.415234 0.766685 -0.148692 1.282135 1.608493 1.559674 0.288962 1.494453 0.151064 0.429304)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
#(40 7.4570450782776 #(0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0)
     7.448447227478 #(0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.4427533149719 #(0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.4250183105469 #(0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.4126052856445 #(0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)
     7.4104852676392 #(0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1)
     7.4014959335327 #(0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0)
     7.3913831710815 #(0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.346036 #(0.000000 1.818883 1.394935 0.090665 1.139537 1.165964 1.461640 1.551576 0.109199 0.483325 0.457022 1.430459 0.313081 0.193612 -0.212653 1.499702 -0.336679 -0.030396 0.079881 0.292504 0.027640 1.238186 0.695831 0.610958 0.187391 1.410399 0.320777 1.252473 1.494258 1.872292 1.369864 0.531768 1.529954 1.740607 0.843604 -0.279705 1.622680 0.757666 1.267011 0.542859)
     6.330560 #(0.000000 -0.055500 1.612353 0.161597 1.040781 1.375231 1.547588 1.626609 0.015834 0.328740 0.440549 1.222968 -0.049633 -0.052407 0.063037 1.418798 -0.435067 0.286083 0.324626 0.391438 -0.079529 0.954953 0.722271 1.043942 0.284220 1.511639 0.226824 1.387435 1.932227 -0.186417 1.474740 0.437652 1.803128 1.543918 0.780894 -0.187766 1.570949 0.924069 1.272265 0.609643)
     6.330286 #(0.000000 -0.045819 1.600127 0.155043 1.039652 1.376700 1.563111 1.661155 0.050057 0.323163 0.431924 1.241351 -0.044202 -0.066168 0.055611 1.410210 -0.445906 0.280566 0.332922 0.404118 -0.063322 0.965131 0.712707 1.048912 0.294430 1.513916 0.224477 1.395693 1.910012 -0.162538 1.449224 0.446580 1.781307 1.550872 0.770292 -0.175206 1.602409 0.911990 1.261579 0.611431)
     6.328818 #(0.000000 -0.185771 1.608833 0.118847 0.817687 1.353844 1.415394 1.577468 -0.167919 0.452879 0.750506 1.135243 -0.091923 0.422968 0.015288 1.927628 -0.209142 0.433543 0.464803 0.118398 0.065517 0.879942 0.906211 1.106392 0.447050 1.638584 0.371725 1.545148 0.220166 -0.139773 1.376317 0.506218 1.939479 1.290399 0.482924 -0.145636 -0.030130 1.377304 1.794185 0.858100)
     6.314770 #(0.000000 1.477318 1.335538 0.251846 1.014057 1.344577 1.644248 1.746079 -0.046981 0.427480 0.544395 1.279480 0.331812 0.073511 -0.019282 1.703045 -0.342343 -0.112266 0.023018 0.166081 -0.168901 1.203245 0.790101 0.845081 0.487304 1.481093 0.195721 1.092519 1.513429 1.816386 1.253020 0.583214 1.424097 1.687515 0.627946 -0.148951 1.535227 0.370840 1.233467 0.706089)
     6.301754 #(0.000000 1.476257 1.342265 0.249536 0.993496 1.359771 1.647689 1.742640 -0.043805 0.433316 0.547201 1.276571 0.329714 0.081651 -0.007008 1.723278 -0.348484 -0.105026 0.024999 0.161467 -0.165703 1.229751 0.808127 0.870069 0.517209 1.472566 0.175815 1.061432 1.507576 1.812612 1.247658 0.572949 1.415088 1.684510 0.618679 -0.115957 1.533439 0.354306 1.246699 0.710352)
     6.299043 #(0.000000 1.472809 1.342339 0.246263 0.991856 1.364904 1.647208 1.737556 -0.043009 0.433781 0.542673 1.274446 0.327101 0.080827 -0.005060 1.722843 -0.348703 -0.102392 0.020851 0.163683 -0.163807 1.232757 0.806939 0.869455 0.520612 1.473286 0.172075 1.061287 1.508730 1.814241 1.251176 0.573394 1.417654 1.686745 0.620310 -0.108344 1.534180 0.355574 1.249840 0.714009)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
#(41 7.5969347953796 #(0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0)
     7.5873513221741 #(0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0)
     7.5666546821594 #(0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0)
     7.5657444000244 #(0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0)
     7.544189453125 #(0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.4959030151367 #(0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.4493231773376 #(0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.4106826782227 #(0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

     6.336362 #(0.000000 1.136564 1.769039 -0.302528 1.219485 1.077066 0.499384 0.459848 1.421023 1.898005 0.403090 0.295010 -1.896917 1.896083 1.647995 1.178305 0.666829 1.680796 0.463075 0.545628 1.334683 0.394364 -0.085600 0.753986 0.467752 0.515771 0.824057 0.897722 1.181114 -0.015790 0.947115 1.655981 0.729980 0.146814 0.128215 0.219239 0.873463 0.080337 1.491244 0.201806 0.413100)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
#(42 7.8644123077393 #(0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8588690757751 #(0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1)
     7.8527493476868 #(0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.8154973983765 #(0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0)
     7.7903428077698 #(0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 0)
     7.7545323371887 #(0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1)
     7.6252284049988 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.471820 #(0.000000 1.772840 1.376230 1.878926 1.434250 1.458727 0.067418 0.103811 1.658906 0.282284 1.690886 1.026376 0.680086 0.196608 0.767695 0.910874 1.872477 -0.182091 1.140966 1.734810 0.307197 1.845559 1.389052 1.189765 0.517584 0.437872 0.935605 1.214047 1.568245 0.725313 1.533735 0.682885 1.728712 0.817049 0.708683 0.656397 1.079825 -0.049474 0.056311 0.513420 0.035912 0.835037)
     6.465842 #(0.000000 1.779554 1.370344 1.882962 1.433363 1.459567 0.063273 0.108009 1.657492 0.288844 1.687713 1.025902 0.674182 0.201834 0.765952 0.917744 1.874499 -0.184507 1.137962 1.738171 0.305979 1.845120 1.388633 1.189195 0.515261 0.441835 0.939748 1.211754 1.571391 0.721535 1.540322 0.682875 1.729853 0.826543 0.708253 0.660516 1.076207 -0.047500 0.062738 0.510039 0.045388 0.837011)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8286972045898 #(0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.824122428894 #(0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1)
     7.8140468597412 #(0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0)
     7.8020606040955 #(0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7842569351196 #(0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)
     7.7697319984436 #(0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1)
     7.7580170631409 #(0 0 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
     7.7244353294373 #(0 1 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1)
     7.6866073608398 #(0 1 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0)
     7.6619415283203 #(0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

     6.482409 #(0.000000 1.144559 1.691771 1.153951 0.716239 0.646091 1.063134 0.342868 0.213241 1.376155 0.672100 0.425584 0.173096 0.110029 0.015293 0.460666 1.796149 1.444048 0.314197 0.012835 0.819748 0.119031 0.582195 0.100074 0.621426 0.361508 1.290142 0.942275 1.772437 0.174260 1.102162 1.335380 1.397832 0.481081 1.799028 0.225127 0.933833 0.257264 0.672894 1.297185 1.465653 -0.223387 0.778846)
     )

;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
#(44 8.0920171737671 #(0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0)
     7.9767818450928 #(0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     6.552505 #(0.000000 0.516530 0.224688 0.526733 -0.270777 1.917868 -0.031145 -0.157428 0.072119 1.708014 1.778556 0.463152 0.275914 0.508605 1.163702 0.356039 -1.719404 0.466987 0.149273 1.208679 1.406203 0.743516 1.669343 1.404167 0.072628 0.264489 0.573670 0.758686 -0.024977 1.581357 0.913109 1.310679 0.226713 0.685141 1.566700 0.432175 -0.042399 1.284123 0.875160 0.466218 1.017090 0.066147 1.376720 0.160417)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
#(45 8.197151904921 #(0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1)
     8.1777801513672 #(0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

     6.710299 #(0.000000 1.070454 -0.070264 -0.304171 1.303714 0.067328 0.560149 0.926320 1.295525 -0.117952 1.194981 1.956221 1.866342 0.923076 1.845341 0.138668 0.401314 0.279294 1.256758 0.676902 1.303468 0.122084 0.076388 0.565286 0.065561 -0.146052 0.045330 0.692077 1.557091 0.407743 -0.008797 0.050936 1.157411 1.726607 1.190266 1.043818 1.133662 -0.039201 1.443994 1.004945 0.568772 -0.159943 -0.016969 1.559761 -0.010082)
     6.703069 #(0.000000 1.072698 -0.071857 -0.315201 1.289632 0.049576 0.550574 0.936882 1.274552 -0.137730 1.176138 1.942981 1.857508 0.917101 1.838948 0.103561 0.380280 0.254574 1.230670 0.649004 1.266031 0.090864 0.066401 0.507493 0.032763 -0.178855 -0.002723 0.628256 1.522968 0.368551 -0.048869 0.031008 1.094372 1.686721 1.156790 0.976242 1.078178 -0.079430 1.396731 0.951285 0.527926 -0.211141 -0.089011 1.504966 -0.078161)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
#(46 8.4391345977783 #(0 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0)
     8.22203540802 #(0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.699675 #(0.000000 1.448795 1.081717 1.923365 0.599093 0.110602 0.062986 0.201393 1.127916 0.800992 0.134374 1.541686 0.425230 0.988970 1.044715 0.905011 0.394025 1.877303 1.779770 0.103636 0.810901 1.462019 1.298360 0.506301 0.690905 0.079943 0.741252 1.295527 0.922954 1.948031 1.523204 1.191425 1.863021 1.502798 -0.017565 0.925811 1.378082 1.110394 1.347775 1.468163 0.886624 1.241739 -0.114390 0.646794 0.156750 0.998631)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4154777526855 #(0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0)
     8.3755550384521 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0)
     8.3640232086182 #(0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0)
     8.3221893310547 #(0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.844938 #(0.000000 1.706436 0.887725 0.241948 0.640735 -0.015147 0.209797 -0.022816 1.206450 0.338043 0.461560 0.209432 0.953577 1.337507 -0.047268 0.654068 0.962003 1.455413 0.741025 1.220734 0.639406 1.484125 1.927246 -0.192936 1.468640 0.777060 1.109095 1.272173 1.810991 0.648504 0.095681 1.286027 1.013267 1.034501 1.164556 0.313720 1.477368 1.097093 0.373880 1.770353 0.269844 0.335587 0.321184 1.173615 1.779299 1.088415 1.323272)
     6.839431 #(0.000000 1.707000 0.885271 0.233907 0.651927 -0.011748 0.217674 -0.026454 1.211428 0.349699 0.457067 0.222525 0.948014 1.342792 -0.049850 0.652055 0.968625 1.464418 0.749553 1.222877 0.635210 1.480624 1.915233 -0.202765 1.474975 0.776193 1.112445 1.266123 1.809237 0.658024 0.102958 1.290639 1.006124 1.030838 1.151617 0.307178 1.475376 1.085280 0.368954 1.771707 0.262040 0.332089 0.325281 1.173936 1.776791 1.092991 1.334125)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
#(48 8.6921081542969 #(0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1)
     8.5232070520636 #(0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1)
     8.4671268463135 #(0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

     6.922039 #(0.000000 0.581898 1.182752 1.056987 1.123302 0.559460 1.579673 1.272140 0.635349 1.853289 1.413009 -0.089648 0.483330 1.908772 0.150517 0.241853 1.563341 1.614291 0.556765 0.466139 1.066230 -0.405713 1.651731 0.712213 0.695051 0.840148 0.057731 1.075053 0.303817 0.522591 1.272292 0.582286 1.115418 0.924322 1.589370 0.779474 0.392277 0.288094 0.191689 0.867622 1.096187 1.307593 0.513194 1.446415 0.437656 0.580368 1.821366 0.475236)
     6.902985 #(0.000000 0.595417 1.252452 1.049843 1.051913 0.581899 1.649067 1.335137 0.663844 1.802087 1.326417 0.024349 0.377435 1.916300 0.139559 0.226739 1.555403 1.479832 0.626539 0.510002 0.920860 -0.428715 1.560637 0.820535 0.762936 0.712747 0.144765 0.972879 0.300268 0.453897 1.268668 0.675375 1.166918 0.914525 1.734611 0.706266 0.435326 0.307187 0.208988 0.786893 1.079833 1.463245 0.318586 1.584585 0.375390 0.729045 1.572655 0.586362)
     6.881878 #(0.000000 0.610100 1.238591 1.030438 1.049134 0.597052 1.655959 1.339616 0.657388 1.783558 1.326791 0.010446 0.392720 1.924139 0.164435 0.207320 1.573174 1.507986 0.639327 0.511036 0.952547 -0.410923 1.604037 0.838010 0.782931 0.729589 0.155781 0.964525 0.350783 0.494606 1.262700 0.672691 1.153073 0.893633 1.706923 0.719470 0.449106 0.337111 0.199944 0.815749 1.123240 1.485740 0.323633 1.594395 0.364092 0.765133 1.596358 0.619240)
     6.871100 #(0.000000 0.601479 1.243488 1.031934 1.049235 0.596883 1.662432 1.332867 0.654168 1.789395 1.338287 0.008569 0.383718 1.918449 0.167686 0.199365 1.570673 1.514426 0.642526 0.516053 0.941786 -0.405198 1.600367 0.834398 0.797046 0.741498 0.174574 0.975068 0.363528 0.473179 1.257141 0.662389 1.164668 0.895449 1.707104 0.726409 0.457854 0.350294 0.207246 0.807488 1.129362 1.480839 0.314066 1.583313 0.357468 0.760120 1.603578 0.627828)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
#(49 8.7310771942139 #(0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0)
     8.6587047576904 #(0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0)
     8.7183141708374 #(0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1)
     8.5157623291016 #(0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

     6.929571 #(0.000000 1.360679 1.851683 -0.214978 1.057608 0.986005 0.665216 1.627815 0.471249 0.305165 1.828186 1.059632 0.976087 1.710029 0.287784 0.052298 0.533554 1.447717 1.430898 0.686876 0.970578 1.517439 1.541810 1.342579 0.960401 1.120025 1.508539 -0.282505 1.594658 0.670054 0.179124 0.540239 0.121604 1.031155 0.288296 1.743525 -0.166217 1.005938 1.874992 0.416055 1.026028 0.111988 0.756460 0.387235 1.492245 0.037718 0.119758 1.654026 0.170735)
     6.921571 #(0.000000 1.428159 -0.117715 -0.216673 1.072814 1.015693 0.650701 1.622259 0.539828 0.421480 1.870093 1.161169 0.985539 1.720420 0.365388 0.060714 0.531355 1.517179 1.463949 0.724994 0.961176 1.538829 1.564877 1.431255 0.933914 1.183544 1.508100 -0.167102 1.668032 0.675482 0.243270 0.673725 0.266636 1.083568 0.367176 -0.139144 -0.047776 1.096102 1.977531 0.481511 1.201649 0.171345 0.858647 0.506382 1.643450 0.142346 0.246748 1.854181 0.300891)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
#(50 8.8124130871436 #(0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1)
     8.8096923828125 #(0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1)
     8.7809114456177 #(0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

     7.087387 #(0.000000 1.573663 0.774049 1.241474 -0.026290 1.509731 0.199397 1.583522 0.956586 0.946890 0.858339 1.233850 -0.226029 0.852906 0.648412 1.586457 -0.201893 -0.386352 0.826236 1.018356 1.437350 0.752607 0.599041 0.326171 0.692433 0.576111 0.722288 0.396835 1.102605 1.443754 1.096441 -0.268541 0.243429 1.330355 -0.307529 1.202013 1.268885 0.287027 1.486594 0.775267 -0.183879 1.269607 1.203317 1.389069 0.130726 0.626033 0.003073 0.026419 0.915053 1.419645)
     7.040654 #(0.000000 1.534715 0.617340 1.307733 -0.048813 1.530143 0.432374 1.792718 1.159103 0.892119 0.938624 1.101215 -0.189442 0.811760 0.606724 1.584279 -0.422867 -0.153620 1.003191 1.075961 1.293779 0.459341 0.571239 0.205442 0.704022 0.671327 0.610569 0.405468 1.273636 1.501675 0.957497 -0.180772 0.356690 1.399403 -0.501431 1.059546 1.439824 0.309427 1.328508 0.920498 -0.334116 1.442566 1.153151 1.668063 0.274295 0.643666 0.138231 -0.341992 0.857237 1.514377)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
#(51 8.8691492080688 #(0 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)
     8.8213935921978 #(0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.132320 #(0.000000 1.287060 1.262714 1.705251 -0.041103 0.973961 -0.055716 0.551728 0.516681 0.026068 1.539747 0.324242 0.544143 1.771718 0.945969 1.306579 0.557624 1.101368 0.566679 0.705901 0.631899 0.538213 1.702597 1.688417 1.699495 -0.206972 0.093494 0.662083 -0.120375 0.124708 -0.051233 0.904875 1.346818 1.472343 1.483554 0.298836 -0.050457 1.423843 1.249791 0.356067 1.428342 0.124065 1.889690 0.915337 0.041547 0.933934 0.088193 -0.029934 1.191261 1.388158 0.162915)
     7.128861 #(0.000000 1.288807 1.261290 1.708806 -0.041696 0.975112 -0.056845 0.549562 0.520162 0.023559 1.539942 0.320201 0.546541 1.768068 0.944171 1.305590 0.560013 1.101341 0.562523 0.705470 0.630407 0.539298 1.702627 1.682385 1.700139 -0.209021 0.092135 0.662010 -0.115432 0.126860 -0.054516 0.902405 1.344882 1.473202 1.481174 0.301017 -0.049155 1.425283 1.248844 0.361137 1.429243 0.127083 1.892631 0.920088 0.040963 0.937366 0.092836 -0.028756 1.185042 1.386223 0.167497)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
#(52 9.1133499145508 #(0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1)
     9.109245300293 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0)
     8.9920463562012 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

     7.149737 #(0.000000 0.631718 1.446098 1.478773 0.119348 1.347186 0.570275 0.537178 1.768074 0.400579 1.752143 0.527996 1.397343 1.240563 1.338275 1.021738 0.936626 1.568260 0.516819 0.308476 0.482402 1.096064 -0.060160 0.259483 0.398962 1.253846 1.878522 1.121548 1.717764 -0.134371 0.224256 1.122775 0.533335 1.223694 0.258831 -0.099257 1.272598 0.870492 0.890684 0.687746 0.677480 1.098395 1.397497 1.045901 1.346856 0.415368 1.577769 0.869637 0.539653 1.425636 1.250370 0.816634)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
#(53 9.171422958374 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 1 1 0)
     9.0914754867554 #(0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

     7.211402 #(0.000000 0.616516 0.846689 1.603746 1.161970 1.711662 0.514826 -0.046593 0.307026 0.319518 1.005929 1.378198 1.088439 1.754482 1.597324 0.155392 0.927857 -0.374215 0.834281 1.641395 0.751477 1.007227 0.872774 0.298992 0.171911 0.882242 1.761522 0.889562 -0.029460 0.079990 0.274506 1.592029 0.319770 1.894422 1.397662 1.118695 0.715594 0.355740 1.347351 1.817486 0.553207 1.398165 1.814722 1.638043 1.670484 -0.112799 1.641090 0.885500 0.184635 1.804143 0.327137 0.103994 1.699875)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
#(54 9.2755253455568 #(0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1)
     9.1825122833252 #(0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

     7.342698 #(0.000000 1.578625 -0.120628 1.405653 -0.023932 1.151937 0.112401 0.390404 1.121162 -0.326948 0.083748 0.015269 0.189565 1.010094 -0.161237 0.752776 1.563606 0.368025 0.538898 0.992719 1.050035 0.281695 0.286783 0.171798 1.554178 -0.084851 1.596920 1.145343 1.088142 -0.079041 1.634405 1.020695 0.100961 1.434843 0.680232 0.490042 1.247475 0.600168 1.352020 0.454945 0.450793 0.715022 1.272631 0.652538 1.074375 1.713180 1.590420 0.787557 0.230255 0.375704 0.005734 1.269096 0.506331 0.822428)
     7.338774 #(0.000000 1.556971 -0.132289 1.396405 -0.053195 1.159257 0.123606 0.435400 1.178121 -0.274916 0.106951 0.017559 0.221053 0.999478 -0.186174 0.823535 1.599827 0.421678 0.651567 0.967950 1.034555 0.346057 0.414812 0.147223 1.493492 -0.117829 1.572685 1.170441 1.035704 -0.008100 1.589645 1.011825 0.002663 1.392643 0.699302 0.637773 1.253425 0.632521 1.335719 0.499350 0.496359 0.931633 1.219368 0.681354 1.050976 1.697487 1.619177 0.772590 0.297824 0.430651 -0.019534 1.177472 0.591792 0.948101)
     7.337187 #(0.000000 1.556812 -0.133768 1.398398 -0.053398 1.159474 0.122400 0.434564 1.175898 -0.273546 0.103530 0.017448 0.221098 1.000971 -0.184384 0.823630 1.597924 0.423379 0.648174 0.965898 1.037923 0.341282 0.414742 0.145014 1.495445 -0.119993 1.573849 1.165373 1.039813 -0.006045 1.587706 1.014348 0.006027 1.393163 0.698587 0.635727 1.250910 0.631558 1.335542 0.497901 0.493836 0.926372 1.220493 0.681591 1.051914 1.695971 1.617858 0.769169 0.296002 0.427696 -0.016587 1.180303 0.589227 0.946379)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
#(55 9.2178440093994 #(0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0)
     9.0889595835043 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     7.423536 #(0.000000 0.868825 0.424018 1.734408 1.099301 1.206816 -0.192714 0.989212 1.048945 1.733727 0.428300 0.831550 1.686917 0.978163 1.031628 0.999494 1.356789 1.475138 -0.177993 1.467101 1.676172 0.969997 0.925382 1.336069 0.435988 0.400801 1.262873 0.027206 1.488622 0.105702 0.981313 0.990062 1.397714 0.980034 1.383232 0.593349 1.591251 0.296705 0.350165 -0.184797 1.023323 0.332686 0.221790 0.016389 1.632800 0.784575 0.387767 1.320528 1.760953 -0.235371 -0.187641 0.887478 1.280467 0.682110 1.480112)
     7.362111 #(0.000000 0.885530 0.401367 1.717163 1.124947 1.126574 -0.191821 1.027733 0.992438 1.700984 0.430796 0.836783 1.619177 0.985112 1.045116 1.005917 1.389033 1.474269 -0.243032 1.504873 1.672866 0.981265 0.916358 1.357743 0.433494 0.397275 1.319998 0.021765 1.474037 0.089745 0.967695 1.009066 1.302918 0.891780 1.429735 0.645002 1.632259 0.331674 0.431487 -0.162153 1.022976 0.347564 0.232172 -0.004453 1.637392 0.781912 0.428442 1.356111 1.774852 -0.210024 -0.222540 0.890122 1.236139 0.615141 1.528929)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
#(56 9.4667987823486 #(0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0)
     9.3902807235718 #(0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1)
     9.1394176483154 #(0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

     7.411597 #(0.000000 1.593922 1.536735 -0.238565 1.543203 0.094527 1.244143 1.274116 0.325610 1.567667 -0.246463 0.080768 0.028698 1.574374 1.543124 0.587777 0.563928 1.152370 0.076292 0.091488 1.172142 0.112664 1.337922 1.060248 1.817072 1.734864 0.723428 0.751499 1.014841 1.494010 1.237211 1.527045 1.811195 1.275853 -0.025107 0.586757 1.624491 1.148781 0.599886 0.721838 0.910941 0.297234 0.697329 0.227848 0.696872 -0.249645 1.550516 0.565317 1.278341 0.010319 1.837302 1.876404 1.060137 0.530892 1.085689 -1.919039)
     7.385211 #(0.000000 1.582958 1.524511 -0.245189 1.527891 0.088681 1.238060 1.306453 0.310283 1.598216 -0.251088 0.070893 0.013311 1.598438 1.565759 0.587094 0.542007 1.145736 0.081809 0.080091 1.172028 0.113641 1.331311 1.055224 1.832232 1.729282 0.725651 0.709950 0.994296 1.498562 1.247551 1.543494 1.811579 1.254130 -0.010057 0.618103 1.614232 1.173560 0.589093 0.728230 0.912010 0.307446 0.706112 0.238659 0.706886 -0.237367 1.556254 0.572992 1.275229 0.017462 1.816571 1.907670 1.070172 0.566380 1.110901 -1.922635)
     7.371868 #(0.000000 1.572725 1.521995 -0.242193 1.522182 0.087697 1.235193 1.318418 0.303751 1.612110 -0.256007 0.062812 0.007785 1.604800 1.564793 0.577827 0.538414 1.147603 0.084367 0.075947 1.175327 0.118793 1.324996 1.057006 1.840175 1.728376 0.725240 0.681818 0.981640 1.490971 1.254152 1.560648 1.799707 1.244403 -0.013317 0.633080 1.615071 1.174977 0.583467 0.718803 0.924516 0.317835 0.698183 0.247550 0.703436 -0.233591 1.549224 0.583010 1.269996 0.023940 1.805836 1.915516 1.065576 0.571400 1.127566 -1.914815)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
#(57 9.650218963623 #(0 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0)
     9.616 #(0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 1)
     9.370246887207 #(0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

     7.520679 #(0.000000 0.434294 0.845950 0.842308 1.695683 0.220894 0.397920 0.144752 1.817140 1.209654 1.062453 1.027438 0.202316 0.671718 1.533565 1.295334 1.811921 0.062499 1.548311 1.557995 0.127885 0.318033 0.125151 1.422462 0.471021 0.753247 1.666903 1.090152 1.159402 1.477128 1.769995 0.852448 0.998214 1.346725 0.812116 0.583570 1.681157 0.512662 1.545484 1.616182 0.957299 1.804231 1.474004 0.349918 1.341089 0.589556 1.304638 1.365528 0.259796 1.531042 0.119965 0.908086 0.243855 1.566686 1.212055 1.465069 1.474980)
     )

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
#(58 9.623 #(0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1)
     9.6140956878662 #(0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1)
     9.4419231414795 #(0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.651379 #(0.000000 1.064342 1.504305 0.804226 0.420202 0.499413 -0.027694 0.066272 1.293335 1.102447 0.194736 1.116415 1.886865 -0.154834 0.664313 1.587173 0.734407 1.549791 1.503723 0.952773 1.274513 0.693497 1.280953 0.563505 0.260661 0.607424 1.115582 -0.235060 0.131504 -0.035757 0.413936 -0.079368 1.853422 0.952240 1.175408 -0.302425 -0.068159 0.175144 0.018976 1.903472 0.049087 0.394422 -0.096999 0.770258 0.320397 0.203366 1.496702 0.745903 1.252373 0.763008 -0.068530 1.910025 0.886579 0.186324 1.685086 1.329071 1.610123 0.362216)
     7.614594 #(0.000000 0.987958 1.506228 0.850726 0.380897 0.509265 -0.052538 0.094181 1.248365 1.144646 0.168627 1.085892 1.762339 -0.125454 0.565413 1.558021 0.687489 1.590845 1.492717 1.041358 1.278589 0.775079 1.350583 0.616523 0.184568 0.648144 1.037061 -0.198583 0.283778 -0.043684 0.359373 -0.158682 1.827455 0.904627 1.167598 -0.302517 0.012199 0.162117 -0.046657 1.984002 0.036411 0.417016 -0.026748 0.788079 0.414878 0.204426 1.495981 0.773810 1.351203 0.703045 -0.156641 1.867897 0.828634 0.340743 1.675484 1.308778 1.594071 0.197036)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
#(59 9.9013983722749 #(0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1)
     9.4819116592407 #(0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

     7.674817 #(0.000000 0.018517 0.358695 1.385949 1.461232 0.264126 0.966469 0.697430 1.506529 0.264217 1.233066 -0.422313 -0.114097 1.544334 0.198775 1.244501 0.107992 0.668216 0.312414 0.290513 0.022046 0.684867 0.986337 1.224846 0.476492 0.627953 0.949269 0.452772 1.392841 1.180357 0.633197 0.263889 0.620308 1.346266 0.548958 1.562315 0.909309 0.537784 0.837910 0.590670 -1.757389 1.673166 0.198430 0.513936 0.261081 1.780499 1.270897 1.345053 0.209762 1.437916 1.721067 0.289046 0.777234 0.788249 0.492237 1.200359 1.922726 1.369656 0.462461)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
#(60 9.783 #(0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)
     9.575254043103 #(0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     7.671725 #(0.000000 0.399481 0.239449 0.786141 0.670414 -0.608473 0.034241 1.894210 1.121128 0.455359 0.836132 1.312380 0.087777 -0.245112 1.330301 1.028069 0.753869 0.098522 1.514736 -0.008600 1.276254 1.430138 1.575027 0.794757 -0.141186 1.056192 0.833575 0.116435 1.623522 1.229430 0.666103 0.898136 0.114749 0.302197 0.631121 0.169008 0.236804 0.106265 -0.143175 0.628386 0.383079 1.174028 0.836685 0.712943 0.922826 1.231769 -0.237573 0.010352 0.579177 -0.286456 0.144201 0.788319 0.300636 0.987163 1.741741 0.692908 0.111059 0.837947 0.079492 0.394658)
     7.643794 #(0.000000 0.397540 0.244480 0.828939 0.684299 -0.660090 0.010803 1.945847 1.140423 0.432093 0.861725 1.340794 0.111032 -0.305439 1.357800 1.039931 0.759038 0.074933 1.511402 0.050381 1.282365 1.487641 1.599766 0.792382 -0.240351 1.024295 0.767276 0.079220 1.629182 1.203645 0.688830 0.891333 0.145535 0.312949 0.617513 0.139015 0.134090 0.155748 -0.163268 0.570940 0.339601 1.225977 0.799822 0.747503 0.910174 1.173273 -0.237474 0.006161 0.535556 -0.318550 0.103268 0.727307 0.263865 0.972635 1.749039 0.679393 0.098199 0.813779 0.086304 0.358562)
     7.623977 #(0.000000 0.402398 0.245241 0.843498 0.691342 -0.670822 0.004518 1.950803 1.147595 0.429269 0.854085 1.346689 0.104396 -0.298731 1.368196 1.054815 0.749695 0.077305 1.518241 0.047288 1.292130 1.495069 1.605080 0.789898 -0.241399 1.018401 0.756324 0.079705 1.621214 1.206597 0.683097 0.879051 0.141818 0.315978 0.620933 0.132804 0.118419 0.160843 -0.160762 0.557783 0.331507 1.241441 0.792132 0.749708 0.919040 1.164204 -0.233336 0.014619 0.533793 -0.315929 0.091279 0.723109 0.261694 0.971326 1.749159 0.666563 0.098186 0.815384 0.086019 0.362623)
     7.619502 #(0.000000 0.402320 0.240149 0.846641 0.693406 -0.677370 0.001624 1.944472 1.143504 0.426368 0.860481 1.347488 0.090527 -0.304211 1.364881 1.059011 0.742961 0.076710 1.522401 0.047644 1.285109 1.496233 1.604585 0.780472 -0.235054 1.010739 0.757677 0.078992 1.613082 1.197103 0.678700 0.879778 0.140312 0.325237 0.626668 0.139166 0.123748 0.154613 -0.168022 0.559782 0.329302 1.235963 0.791401 0.754815 0.916761 1.170795 -0.235739 0.018036 0.529511 -0.312991 0.095216 0.717299 0.269441 0.968523 1.750563 0.662030 0.098981 0.813196 0.081039 0.368795)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
#(61 10.140303840769 #(0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0 1)
     9.9175914844707 #(0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.791968 #(0.000000 0.483083 1.327479 -0.013635 0.498848 1.941478 -0.009303 0.984458 0.004674 0.525838 0.015263 0.553954 0.564369 -0.160659 0.683175 1.449494 0.677081 1.022310 1.271899 0.521955 0.655482 1.371697 -0.004554 0.922866 0.756002 0.951878 0.643603 0.007431 1.235463 0.460054 1.116385 -0.048824 1.560490 0.143336 0.691707 0.227065 1.806305 0.220057 0.665332 1.958795 1.535010 1.103940 -0.291078 1.411429 1.048123 1.709458 1.078507 0.280803 0.173907 0.081727 0.774373 1.468253 1.386164 -0.054300 0.268078 0.175640 1.615210 1.092424 0.767642 1.336014 1.473282)
     7.786797 #(0.000000 0.479365 1.325597 -0.008216 0.497879 1.950705 -0.008644 0.984944 0.006815 0.533256 0.021971 0.556114 0.567754 -0.162267 0.684181 1.445682 0.682984 1.023942 1.268790 0.524818 0.655237 1.370199 -0.008920 0.924971 0.759242 0.946189 0.642344 0.008230 1.239177 0.463060 1.105504 -0.050618 1.557294 0.142237 0.701652 0.233379 1.809524 0.210102 0.677919 1.960815 1.543024 1.104351 -0.286290 1.415179 1.048047 1.715261 1.081197 0.289286 0.172557 0.076057 0.772217 1.470306 1.397916 -0.056368 0.274819 0.183634 1.614281 1.094203 0.773274 1.332013 1.480061)
     )

;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
#(62 10.281167984009 #(0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0)
     9.9292116165161 #(0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

     7.867687 #(0.000000 0.712778 1.676017 0.246844 1.656097 1.428520 1.829255 1.013884 0.031332 0.606223 1.867187 1.311811 1.377034 -0.032234 1.689363 0.088000 1.027705 0.008990 1.012020 1.179857 0.606252 0.582295 0.019864 1.670998 0.116916 1.143991 0.399068 0.225588 0.727972 0.510771 0.289954 1.584178 1.516566 1.729886 0.285500 1.619304 1.092962 0.710964 1.283837 1.418411 0.070754 0.941077 1.259732 1.195002 0.450871 1.663832 1.507943 1.715520 1.837497 0.647269 1.684433 1.566868 0.724332 0.751690 0.936294 1.116625 0.171934 1.223209 0.807982 0.666927 1.291168 1.547340)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
#(63 10.265982627869 #(0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9866892843745 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0)
     9.9555234909058 #(0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.921801 #(0.000000 0.142718 0.118610 0.583313 1.534648 0.239524 -0.238709 1.282132 0.133458 0.207889 1.501653 0.097281 1.891492 1.168327 1.945945 0.325567 1.274429 0.867531 1.492235 1.217784 0.148043 1.775676 0.945888 0.994144 1.174855 1.032613 1.304584 1.169802 0.353681 1.013972 0.171608 1.815373 1.492883 1.323277 -0.041232 1.329356 1.654292 1.251598 1.289589 0.390684 0.890799 1.804944 1.430243 0.271409 1.555380 0.406815 0.819576 0.470424 -0.016235 1.561170 1.171048 1.055486 0.179958 0.974818 1.455548 -0.128339 -0.156807 -0.006719 1.063115 1.741340 0.215767 0.667652 0.637400)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
#(64 10.1628899603246 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1)
     9.957244923706 #(0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

     8.014991 #(0.000000 0.079525 0.205813 1.969458 0.371107 1.208678 1.399782 0.583811 0.509062 1.228489 1.377818 -0.190609 1.837435 1.615237 0.276085 -0.240569 1.807532 1.286478 1.768616 0.743541 0.829525 1.565670 0.410318 0.564556 1.048860 1.490670 -1.768653 1.318793 0.500756 1.180594 1.236683 0.163052 -0.048199 1.536230 1.738297 1.648024 1.160084 0.944963 0.293455 -0.031681 -0.198922 1.000218 0.164365 0.547122 0.510474 1.349978 0.664899 1.422401 0.051897 0.124020 1.102913 0.479058 1.148093 0.503446 1.471047 1.056149 0.723089 0.325862 1.040797 0.379305 0.832744 1.651902 0.830251 0.926327)
     7.986229 #(0.000000 0.047387 0.225806 1.950536 0.379367 1.205927 1.437187 0.571120 0.594961 1.231237 1.344812 -0.237176 1.832664 1.620827 0.306079 -0.198967 1.798610 1.301086 1.832222 0.727963 0.857502 1.557835 0.425216 0.570091 1.083689 1.464541 -1.744883 1.272284 0.500144 1.193371 1.255011 0.220666 -0.052812 1.584453 1.835476 1.693864 1.173518 1.035527 0.332085 -0.084828 -0.259646 1.053683 0.249366 0.611687 0.481086 1.336321 0.646537 1.409012 0.061840 0.168726 1.065432 0.421138 1.207294 0.515130 1.466023 1.035042 0.804961 0.377940 1.038729 0.444007 0.760689 1.718518 0.849620 0.946875)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
#(65 10.598279953003 #(0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0)
     10.18968963623 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0)
     10.157649040222 #(0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.057018 #(0.000000 -0.464113 1.156968 1.259995 1.444354 1.860947 1.635230 -0.205306 0.992448 1.842589 1.027769 1.611073 0.670223 0.919820 1.411143 1.467440 1.716813 0.114100 0.671029 1.788456 -0.024006 1.126477 0.877343 1.143834 1.730949 0.858302 1.487504 0.173270 0.877104 0.597502 1.379684 0.169023 1.753218 0.447902 1.131769 0.491721 0.437659 1.451204 1.675490 0.505813 -0.188295 0.457471 0.283905 1.417309 1.872297 0.244174 0.700109 0.171762 0.905374 0.174388 1.480701 1.080429 1.161835 1.294409 1.197333 0.954084 0.912195 0.100914 0.019559 1.424227 1.050357 0.074828 1.353644 0.536519 0.254680)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
#(66 10.450973400896 #(0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0)
     10.26798183746 #(0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1)
     10.208241079264 #(0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

     8.124781 #(0.000000 1.089548 1.964647 0.518576 1.650363 1.699992 1.687967 1.016131 0.643933 -0.278135 0.703653 0.860036 0.741587 1.277672 0.260021 0.333349 1.136520 0.349661 1.912945 0.208636 0.953016 1.585496 -0.219978 0.612281 -0.003334 1.382307 1.387554 1.193339 0.209644 0.402380 0.057290 1.624758 1.152746 1.080193 0.803106 0.953352 1.311991 0.260918 0.311750 1.464761 0.301555 1.180190 1.655051 1.593388 0.225137 0.375796 0.942835 0.251682 1.069302 0.352540 1.580180 0.672767 0.576405 1.908935 0.969014 0.126465 0.873077 0.057146 0.573640 0.675647 0.081523 0.044274 0.648729 0.306460 0.600014 0.787706)
     8.122576 #(0.000000 1.092121 1.968109 0.492457 1.672756 1.700450 1.695019 0.998215 0.678167 -0.311717 0.719277 0.863902 0.732946 1.286709 0.266109 0.323077 1.106589 0.340623 1.919750 0.191196 0.952061 1.591005 -0.239746 0.600115 -0.012290 1.386513 1.388282 1.207120 0.216788 0.419727 0.101521 1.646541 1.140161 1.085925 0.803002 0.966605 1.295498 0.266717 0.296325 1.479649 0.305314 1.212626 1.647730 1.571601 0.248797 0.388107 0.956796 0.271254 1.070977 0.299228 1.612209 0.673426 0.586627 1.935958 0.955557 0.126948 0.913987 0.056941 0.556979 0.698853 0.085127 0.075470 0.639667 0.277813 0.604706 0.785988)
     8.111796 #(0.000000 1.095044 1.971480 0.495809 1.669854 1.695553 1.690769 0.992574 0.658744 -0.307192 0.718928 0.862872 0.727787 1.276331 0.262343 0.329210 1.115168 0.340255 1.908658 0.186768 0.958903 1.597859 -0.242502 0.607601 -0.008356 1.387457 1.397068 1.203878 0.209050 0.421653 0.091178 1.651767 1.138553 1.088038 0.802029 0.953054 1.286262 0.267135 0.296174 1.484793 0.310661 1.205720 1.631639 1.569689 0.250821 0.384663 0.963124 0.262172 1.072746 0.289875 1.607486 0.683109 0.585198 1.943271 0.951175 0.119466 0.915585 0.051143 0.540878 0.689771 0.092468 0.068150 0.627519 0.282595 0.609447 0.782814)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
#(67 10.780866622925 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     10.514228551195 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.445269388021 #(0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1)
     10.422191619873 #(0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.174495 #(0.000000 0.828851 1.688834 1.205873 0.089252 0.922284 1.804669 1.055795 0.264519 1.470758 0.157363 0.018677 0.091400 0.807705 0.879828 0.393675 1.102768 0.932634 1.380503 1.647328 0.810902 -0.173383 1.683844 1.819230 -0.127027 1.773378 0.387328 1.422212 0.987593 -0.025242 0.599849 -0.066736 -0.106822 0.013763 -0.071698 1.070300 0.455631 -0.466692 1.312867 0.082320 0.859599 1.567834 1.520230 1.751635 0.851404 1.156984 0.995416 1.047112 -0.084357 1.430768 0.718523 0.613541 0.615002 1.160558 1.539778 0.339156 1.720311 -0.140129 0.934524 1.696149 0.135624 1.233253 1.536207 1.047425 0.661714 0.039077 1.820089)
     8.171159 #(0.000000 0.833028 1.687710 1.206556 0.086498 0.923602 1.807309 1.058637 0.261723 1.472963 0.161430 0.020009 0.094154 0.806756 0.877917 0.392701 1.102137 0.935044 1.379076 1.649736 0.811305 -0.172711 1.690622 1.819474 -0.124717 1.776326 0.386953 1.425407 0.988974 -0.024270 0.605002 -0.060983 -0.112337 0.015102 -0.070516 1.065122 0.463133 -0.464979 1.310845 0.085302 0.860922 1.573822 1.528535 1.752601 0.851644 1.157462 0.992983 1.045906 -0.088076 1.424333 0.720348 0.614425 0.618796 1.159685 1.542862 0.334337 1.723725 -0.143373 0.935326 1.693606 0.135261 1.235601 1.543482 1.045513 0.667727 0.036386 1.812164)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
#(68 10.585594177246 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1)
     10.460547747753 #(0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

     8.197641 #(0.000000 0.331478 1.852498 1.054398 0.777200 0.937337 0.730244 0.726443 0.370454 0.195895 0.474792 0.067610 1.509491 0.919487 0.825906 0.940345 0.808546 1.078537 1.225150 1.049414 0.736445 1.737698 0.058020 1.765818 1.417551 0.217434 0.089861 -0.022853 0.527925 0.671334 1.318190 0.126947 1.525948 1.536065 0.046756 0.228156 1.770087 1.007179 1.313900 1.416181 0.118708 1.243392 0.727368 0.050354 1.437178 1.091859 0.751746 1.478906 0.375119 1.294680 0.553303 1.463022 1.224389 0.167046 0.463856 1.162121 -0.019044 1.448763 0.187766 1.129299 -0.143402 0.687347 1.461100 -0.235374 0.546990 0.683693 0.973453 1.528821)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
#(69 10.631803698099 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.544771744298 #(0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0)
     10.495518383865 #(0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

     8.299080 #(0.000000 0.508857 0.174091 -0.180116 0.629036 1.747663 0.879808 -0.175981 1.593336 0.764649 -0.231941 1.439394 0.705700 0.507236 1.361142 0.555427 0.133651 0.697717 0.364984 -0.110592 1.321147 1.438738 0.435492 0.000792 0.635734 0.126449 1.615283 0.130189 1.020079 1.213203 1.688898 1.049803 0.271531 0.558077 0.310108 -0.123290 1.703486 1.022869 0.333346 0.490474 1.352428 1.046060 1.650816 0.043963 0.365200 0.516481 0.301589 0.265705 1.422839 0.039035 -0.744816 1.649414 0.349508 0.127869 1.391962 1.542995 0.363559 0.471804 1.439979 0.387347 1.070127 0.133602 1.007305 0.873734 0.968254 1.076970 1.251776 1.088230 1.275780)
     8.289844 #(0.000000 0.513585 0.177479 -0.176888 0.623783 1.745401 0.873250 -0.173141 1.596123 0.753018 -0.230814 1.441081 0.705435 0.505271 1.366748 0.558604 0.140712 0.699849 0.362073 -0.111867 1.322811 1.446154 0.437920 -0.004880 0.636812 0.132544 1.613260 0.126691 1.024863 1.218542 1.684056 1.053127 0.272250 0.553128 0.296391 -0.119714 1.708317 1.024886 0.325200 0.493314 1.349317 1.057246 1.659956 0.046289 0.374425 0.519480 0.314406 0.268202 1.430527 0.044485 -0.747002 1.651671 0.338001 0.130617 1.387118 1.539222 0.360122 0.465635 1.448451 0.389965 1.070962 0.131507 1.008142 0.867151 0.967360 1.085348 1.255863 1.090665 1.273123)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
#(70 10.957886695862 #(0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0)
     10.651799201965 #(0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0)
     10.635682482778 #(0 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)
     10.532930374146 #(0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

     8.346754 #(0.000000 0.655484 1.374896 0.289576 0.973706 1.109131 0.854187 1.260047 1.360067 -0.018132 0.674424 1.659490 0.490887 0.913232 1.137634 1.302746 0.987696 1.880807 1.061263 -0.042700 0.329365 1.188950 1.933106 0.970966 0.030974 0.288697 0.661329 -0.073707 0.185857 0.108498 0.256148 1.450247 0.165058 1.651421 0.570093 1.711124 1.184567 -0.086459 1.770960 1.950244 1.451278 0.292741 0.567049 0.753713 0.690306 0.057026 0.466415 0.230363 0.074574 1.359738 1.119809 1.847194 -0.169831 0.594006 1.381831 0.790494 0.195665 1.724791 1.394772 0.590353 0.319079 1.802913 -0.103344 -0.103646 0.896174 1.232397 0.803435 0.456945 0.085191 1.243103)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
#(71 10.922951698303 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0)
     10.610488331633 #(0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.440233 #(0.000000 0.281620 -0.068040 1.212994 0.082884 0.151338 1.172975 1.340633 0.089092 1.520939 0.390424 1.059180 -0.143687 0.793528 0.464831 0.964500 1.038592 0.924100 0.699491 0.628415 0.728953 0.419378 0.416939 1.086266 0.469083 1.218829 1.080263 1.040618 1.221008 0.783493 -0.376804 0.563021 0.825550 0.395924 0.099140 1.667506 -0.052959 0.746264 1.012590 0.010062 1.283091 0.079604 0.707938 0.399370 1.699131 1.331692 0.758939 0.038914 0.842781 1.133462 1.571778 1.821535 -0.070164 1.338298 -0.043193 0.457364 0.927043 1.018106 0.394036 0.214715 1.525753 0.207051 0.804055 1.078445 0.878290 0.145754 1.688584 0.323450 1.544219 0.646703 0.249628)
     8.424513 #(0.000000 0.194051 -0.078724 1.284071 0.120713 0.175960 1.077763 1.335359 0.105452 1.486620 0.366448 1.097868 -0.165525 0.767475 0.428357 0.941941 1.042033 0.869520 0.740147 0.605784 0.770924 0.404261 0.477537 1.116209 0.421449 1.249007 1.045637 1.018411 1.198920 0.812317 -0.428993 0.539055 0.835631 0.384704 0.141836 1.627811 -0.062780 0.726026 0.983545 -0.049691 1.257296 0.036439 0.689288 0.375627 1.715474 1.295745 0.741353 0.061183 0.821121 1.119652 1.477292 1.774965 -0.097064 1.380315 -0.060642 0.385233 0.881453 1.019289 0.438567 0.211146 1.480994 0.240063 0.818842 1.034585 0.906648 0.104241 1.629037 0.292724 1.525743 0.583397 0.232352)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
#(72 11.061260849739 #(0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
     10.908146369485 #(0 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0)
     10.800657366855 #(0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.509295 #(0.000000 -0.109482 0.850217 0.653010 0.050693 1.185668 -0.189008 0.592350 0.602513 1.378281 1.765296 1.052677 1.217338 0.256452 0.397169 1.560562 0.157322 0.864563 0.314629 1.495363 0.987451 1.347990 0.023710 0.069127 -0.046288 0.272003 0.317696 0.865722 0.645013 0.246417 0.101694 0.455991 0.762055 0.592234 0.859140 0.382549 1.784540 1.445197 0.137622 1.231953 1.159845 1.086835 0.416787 0.612377 0.000031 0.590764 0.187426 0.541490 1.701444 -0.349958 0.385149 1.457944 1.415258 0.195118 0.231137 1.667747 1.072145 1.733966 1.010881 0.631834 1.608455 1.085410 1.617413 -0.023438 0.665293 1.364662 0.709312 1.513048 0.424392 1.105246 0.130599 -0.150134)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
#(73 10.9493838342178 #(0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.889594078064 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0)
     10.876985549927 #(0 0 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0)
     10.773231506348 #(0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

     8.537394 #(0.000000 -1.829171 0.132707 1.612382 0.588359 0.908660 0.844617 0.098342 1.254580 -0.028200 1.175275 -0.366087 1.042574 0.874863 1.204060 -0.013793 1.155501 -1.758213 0.175061 0.846362 1.656494 1.064226 -0.124617 1.928276 0.261262 1.625840 0.840232 0.919657 1.180350 1.792914 0.441692 0.246306 1.932330 1.670529 0.188121 0.248314 1.960752 1.142484 0.476013 0.715391 1.374470 -0.179954 0.371401 -0.056495 1.846975 -0.068854 -0.065909 1.513099 0.382010 1.556230 0.112927 1.770438 0.390945 1.164407 1.755034 0.637896 1.215791 0.810047 0.493025 1.550289 1.313141 0.599027 0.427684 1.046047 1.783762 -0.352042 1.066974 0.386915 1.346697 1.855824 0.178968 1.627042 0.561175)
     8.527919 #(0.000000 -1.813709 0.156885 1.589892 0.591209 0.961424 0.858587 0.075042 1.246874 0.014860 1.163736 -0.365694 1.064413 0.917286 1.197963 -0.034882 1.143315 -1.744418 0.153601 0.919804 1.618724 1.026629 -0.117197 1.866866 0.324983 1.632404 0.882484 0.929992 1.108045 1.855616 0.448539 0.254830 1.923958 1.661709 0.281723 0.261319 0.065501 1.122822 0.526010 0.703541 1.320276 -0.094587 0.269492 -0.044672 1.894648 -0.071066 -0.036016 1.532575 0.394280 1.627918 0.126396 1.818584 0.414729 1.131341 1.839299 0.583593 1.147069 0.826976 0.466296 1.610692 1.339702 0.545569 0.411319 1.088690 1.822262 -0.278996 1.090216 0.377301 1.347288 1.896787 0.198928 1.634945 0.662314)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
#(74 11.023842939777 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0)
     10.97177028656 #(0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0)
     10.70422077179 #(0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0)
     10.684138298035 #(0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     8.578336 #(0.000000 1.335705 0.176794 1.617461 1.045203 0.066512 1.102051 0.637884 0.108762 0.851943 0.176256 0.738642 1.768870 -0.006566 1.298843 0.139233 1.081214 1.502333 0.163995 0.568042 1.514133 0.087532 -0.070677 1.072287 1.132557 -0.152249 0.976437 0.813063 0.067734 1.605210 0.464758 -0.523479 1.775148 1.665445 0.058041 0.027413 1.411389 -0.006240 1.343885 0.244179 0.131615 1.667933 1.598918 1.147845 0.782654 1.279496 1.567303 -0.529463 0.352482 1.116167 1.329642 0.666664 -0.010951 0.079175 0.331086 0.646386 -0.044353 0.173698 1.187517 0.909716 0.866173 1.046017 -0.200063 0.386449 0.048579 0.759868 0.357050 0.889766 1.303891 1.084946 -0.069203 -0.331977 1.476896 1.243349)
     8.572496 #(0.000000 1.331968 0.174892 1.622467 1.046242 0.065798 1.097889 0.637789 0.105184 0.855226 0.182384 0.737302 1.773794 -0.003788 1.300225 0.140699 1.076013 1.503236 0.162375 0.573920 1.517583 0.086219 -0.074447 1.073906 1.129989 -0.144815 0.979567 0.810942 0.066706 1.606315 0.466289 -0.521197 1.767442 1.669772 0.059653 0.024619 1.416912 -0.007247 1.340297 0.242365 0.136591 1.664419 1.599163 1.143946 0.778100 1.279223 1.568661 -0.526031 0.356418 1.115808 1.335558 0.665761 -0.011853 0.079010 0.327368 0.643907 -0.041596 0.175817 1.189629 0.907793 0.865933 1.050720 -0.193365 0.385382 0.048009 0.758977 0.359361 0.894035 1.313677 1.088902 -0.060866 -0.338111 1.475049 1.241921)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
#(75 11.477107048035 #(0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0)
     10.935811368418 #(0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

     8.689894 #(0.000000 1.784755 1.275549 1.345815 0.168323 0.929043 1.212360 0.147903 0.174163 1.335540 0.941808 1.244917 1.614862 0.355710 0.348234 1.665251 1.614201 0.925603 1.863519 1.039766 1.211304 1.247839 1.324022 1.152460 1.375073 1.524827 0.700656 0.639020 0.208536 1.054505 1.240563 0.530250 0.088188 1.190609 1.447059 0.354711 0.859424 1.900706 0.534652 0.618361 0.629184 1.126026 1.288842 0.204936 1.279452 0.352995 1.327839 1.474719 1.459492 1.582495 1.612042 0.068056 1.172612 0.091968 1.266124 0.555051 -0.081134 1.442803 0.115099 1.371862 0.825542 0.508402 0.330636 1.426689 1.725441 -0.064859 -0.088049 0.242245 1.591582 0.789268 1.284803 0.335758 0.736989 0.522332 1.693743)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
#(76 11.329963225913 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0)
     11.208243370056 #(0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0)
     10.689208030701 #(0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

     8.715587 #(0.000000 0.281925 -0.253706 1.532477 1.353267 0.338241 0.825181 1.708101 0.623818 1.329772 0.892319 -0.110223 1.205848 1.576251 0.336892 0.382797 1.582123 0.636854 1.287935 0.814706 1.596528 0.626294 1.539351 1.838956 1.200895 0.756781 0.787851 0.936315 0.700555 1.574513 -0.109586 0.613352 1.382131 -0.134916 0.929434 0.697620 0.938363 0.098033 0.458882 0.611792 0.793501 -0.207505 0.608719 0.241124 0.976333 0.737280 1.296248 0.101449 0.306745 0.023850 1.813323 1.153489 0.222564 -0.060923 0.221057 0.154525 1.072947 0.791013 1.134055 1.063743 0.822576 0.987896 0.137559 0.802222 0.936968 0.332305 1.244704 0.917497 -0.070239 1.593690 0.884185 0.690296 1.409572 1.823248 1.581224 1.044184)
     8.693745 #(0.000000 0.389055 -0.214240 1.512820 1.305193 0.233839 0.760517 1.834769 0.712415 1.504071 0.890275 -0.141153 1.218947 1.552096 0.372320 0.406916 1.569773 0.657971 1.243672 0.810549 1.733556 0.546539 1.509186 1.872627 1.270706 0.607256 0.871413 0.881217 0.755034 1.498283 -0.227481 0.612205 1.401916 -0.093683 0.865714 0.664719 0.854258 0.240459 0.359294 0.388009 0.796602 -0.189413 0.546591 0.206229 1.111186 0.879066 1.342898 0.082541 0.297420 0.005262 1.801512 1.070219 0.315302 -0.099132 0.130613 0.172787 1.082438 0.782149 1.181223 1.069229 0.711531 1.120588 0.157034 0.806933 0.801228 0.244528 1.184034 0.894385 -0.126524 1.596304 0.934734 0.678447 1.493203 1.673326 1.658877 1.065092)
     8.675548 #(0.000000 0.395449 -0.221652 1.508912 1.295673 0.225142 0.745185 1.835132 0.696172 1.499982 0.898863 -0.141132 1.224041 1.571359 0.370821 0.413663 1.573949 0.668236 1.248394 0.813796 1.731666 0.540922 1.496927 1.867687 1.275577 0.612159 0.880593 0.878186 0.758700 1.493715 -0.225764 0.619891 1.417171 -0.090012 0.865382 0.650445 0.855134 0.245796 0.357615 0.380467 0.792165 -0.196281 0.536105 0.207395 1.118128 0.877987 1.338340 0.082944 0.308384 0.015781 1.798508 1.072546 0.315979 -0.093624 0.132136 0.181172 1.087870 0.781548 1.187502 1.065952 0.696709 1.124799 0.171193 0.800027 0.790065 0.238454 1.188888 0.881236 -0.120900 1.608859 0.934182 0.682489 1.491805 1.664595 1.660453 1.075790)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
#(77 11.25105381012 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0)
     11.114716461811 #(0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

     8.746446 #(0.000000 0.343092 0.482442 0.607083 1.379080 1.765436 0.124327 0.263273 0.930952 0.363196 0.612436 0.275934 1.066423 0.184709 0.259380 0.787622 1.424087 1.584541 0.542414 0.075530 -0.252877 0.337922 0.125889 -0.165796 0.736013 0.047094 -0.044516 0.815052 0.747878 1.680227 0.716634 1.257338 -0.087740 1.561825 0.663932 -0.053039 -0.081458 1.622831 1.444388 0.728565 -0.055857 1.265919 0.842791 0.490176 0.483760 0.312928 1.658999 0.565781 0.561571 0.966556 0.687691 1.126222 0.723328 -0.056476 0.338984 0.174008 0.692400 1.471446 0.721571 0.800597 1.515975 1.616916 1.511349 1.737913 0.929460 1.339379 0.588014 -0.633630 1.862090 0.944159 1.012028 0.284587 0.489072 0.072198 1.328090 -0.066575 1.290861)
     8.739984 #(0.000000 0.345625 0.482217 0.607256 1.383603 1.768327 0.124348 0.265120 0.937869 0.360204 0.615749 0.276403 1.070789 0.184863 0.257704 0.783170 1.417438 1.586623 0.545035 0.079404 -0.252713 0.339606 0.123187 -0.161837 0.739100 0.048801 -0.042808 0.821384 0.752707 1.678812 0.717844 1.254063 -0.088723 1.561591 0.668050 -0.052214 -0.078714 1.623211 1.440906 0.726355 -0.053126 1.270639 0.843198 0.487033 0.486824 0.316727 1.659991 0.563454 0.556411 0.974428 0.686270 1.128551 0.725616 -0.053730 0.339355 0.169760 0.684991 1.472647 0.721497 0.807985 1.513883 1.613764 1.510136 1.741662 0.931642 1.336116 0.587274 -0.636731 1.857791 0.940446 1.016500 0.290521 0.490249 0.067167 1.330074 -0.066867 1.292205)
     8.732482 #(0.000000 0.348602 0.477765 0.604071 1.391186 1.768872 0.127420 0.258268 0.939406 0.359461 0.622679 0.279852 1.076905 0.187605 0.253898 0.776811 1.412785 1.590214 0.547845 0.079872 -0.258445 0.337571 0.112062 -0.150679 0.750057 0.052500 -0.042874 0.822953 0.754438 1.681775 0.713488 1.250782 -0.089174 1.561891 0.670417 -0.056647 -0.078343 1.627957 1.445961 0.729974 -0.049985 1.270537 0.844387 0.485140 0.495347 0.314589 1.658989 0.557481 0.558533 0.976065 0.690945 1.127291 0.723698 -0.047046 0.344734 0.173346 0.679025 1.477843 0.719957 0.802240 1.508189 1.616867 1.507095 1.742524 0.924032 1.343640 0.581622 -0.632657 1.852719 0.944787 1.014241 0.291712 0.504130 0.056585 1.321487 -0.070558 1.294494)
     8.731162 #(0.000000 0.348676 0.476377 0.606944 1.387256 1.768549 0.128473 0.260518 0.936568 0.358886 0.618317 0.280418 1.076704 0.186339 0.253960 0.776508 1.415471 1.590913 0.546179 0.076687 -0.256531 0.340311 0.112669 -0.148999 0.753233 0.052743 -0.044103 0.824890 0.752198 1.684593 0.714352 1.250265 -0.090239 1.560152 0.669337 -0.059070 -0.080355 1.629461 1.446609 0.729659 -0.052531 1.270090 0.841483 0.483368 0.495715 0.314144 1.657576 0.557726 0.561425 0.975115 0.690361 1.125970 0.725027 -0.046759 0.347806 0.174137 0.676572 1.478198 0.720342 0.799677 1.510275 1.619276 1.506849 1.740348 0.921395 1.343963 0.582947 -0.631428 1.853084 0.942657 1.014466 0.289120 0.506940 0.058495 1.321113 -0.071385 1.294695)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
#(78 11.559678967298 #(0 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1)
     11.541502084124 #(0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)
     11.471938943963 #(0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

     8.810051 #(0.000000 1.281797 1.248071 0.017881 0.219532 1.723330 0.535306 1.852152 1.539652 -0.097691 1.392570 1.862297 1.346899 0.842733 0.393848 1.100209 0.980199 1.569762 0.455029 0.511084 0.846957 1.879482 0.786125 1.522551 0.912634 0.588499 1.547880 0.309074 1.254908 1.549500 0.855883 1.793881 1.637177 1.338799 1.459693 0.617316 1.193509 1.518025 1.379856 0.489189 0.779894 1.402025 -0.116700 0.711399 0.555640 1.274571 1.673260 1.103728 1.548908 0.340613 0.859556 1.289654 0.897163 1.872663 0.984388 0.130889 0.570502 0.001998 -0.028041 1.550459 1.950822 1.592275 0.514806 0.326967 0.072988 0.038166 0.188035 1.021401 0.922653 0.863100 1.462188 1.557348 0.323733 -0.070049 1.714946 0.210174 1.871065 1.067555)
     8.795731 #(0.000000 1.282318 1.240645 0.018820 0.219553 1.725222 0.535292 1.853509 1.538597 -0.096831 1.391656 1.857011 1.353966 0.834555 0.387620 1.109417 0.982126 1.562399 0.452659 0.512667 0.841461 1.888671 0.781666 1.532561 0.910937 0.587818 1.543816 0.308176 1.253865 1.544715 0.852521 1.811133 1.652977 1.333001 1.464081 0.607812 1.200958 1.526308 1.365645 0.477229 0.769767 1.395193 -0.103176 0.702550 0.563945 1.281049 1.663465 1.094164 1.552060 0.346743 0.849897 1.297844 0.896641 1.861136 0.988631 0.126947 0.571843 0.002980 -0.034253 1.549375 1.962618 1.606029 0.511966 0.319012 0.062726 0.030396 0.178722 1.017658 0.911303 0.868079 1.472217 1.559508 0.317521 -0.060899 1.717949 0.205195 1.874515 1.066438)
     8.794117 #(0.000000 1.282102 1.240015 0.017847 0.220140 1.725512 0.535654 1.852526 1.539563 -0.097808 1.392291 1.857206 1.353378 0.834032 0.387900 1.109453 0.981795 1.560899 0.453225 0.511918 0.840637 1.888309 0.781021 1.533489 0.910642 0.589260 1.543961 0.308835 1.253077 1.545209 0.851990 1.811551 1.652706 1.332577 1.464031 0.607707 1.200927 1.525331 1.366128 0.477575 0.769976 1.396647 -0.102003 0.702279 0.563845 1.281107 1.662601 1.095721 1.552502 0.346884 0.849929 1.298623 0.896092 1.861554 0.989388 0.126963 0.572164 0.003751 -0.034407 1.549877 1.964346 1.606783 0.513154 0.319400 0.062595 0.030600 0.179109 1.017830 0.910238 0.867600 1.472571 1.560119 0.318146 -0.061019 1.718368 0.205299 1.874891 1.066065)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
#(79 11.431832400958 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.407577489438 #(0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0)
     11.334476470947 #(0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.890773 #(0.000000 1.200719 1.184803 1.300740 0.794979 0.617244 1.386694 1.898522 0.140595 0.759653 0.089205 -0.063955 0.094324 0.955109 0.721911 1.902498 0.394634 -0.061320 1.134550 0.807232 0.401034 0.105090 0.952478 0.552613 0.944895 0.133962 1.197524 0.674854 0.043557 0.404150 0.200839 0.524821 0.693639 0.656527 0.557877 1.388115 1.076622 0.411917 1.748128 1.398013 1.479067 0.067453 1.807706 0.625028 0.035353 1.626928 1.819691 1.380401 1.326904 0.480509 1.674149 0.476892 0.545451 1.180012 1.605997 1.232547 0.055712 0.452684 1.046977 0.849065 0.687241 1.208147 0.067350 0.143726 1.461656 1.628185 1.641800 0.861760 1.864532 0.465376 1.256437 0.112947 1.532313 0.223112 0.903456 -0.005459 0.639940 1.445292 1.647676)
     8.876967 #(0.000000 1.217017 1.181770 1.293132 0.793316 0.614833 1.385824 1.899700 0.136304 0.765571 0.089227 -0.058049 0.088341 0.966166 0.731551 1.911162 0.396604 -0.041731 1.141711 0.806277 0.403151 0.110752 0.951079 0.551071 0.944648 0.132252 1.199763 0.682201 0.039510 0.406439 0.198195 0.531418 0.682132 0.658893 0.548542 1.393714 1.084636 0.423055 1.758654 1.394376 1.487027 0.072074 1.813052 0.631991 0.040199 1.623285 1.827695 1.384625 1.320552 0.483220 1.671889 0.474795 0.542482 1.181491 1.612736 1.231528 0.072888 0.450538 1.041375 0.841794 0.687693 1.208493 0.061646 0.144702 1.470642 1.623387 1.645158 0.867468 1.870571 0.447174 1.258774 0.120549 1.533480 0.220588 0.906061 0.003645 0.640845 1.436270 1.649416)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
#(80 11.828915596008 #(0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1)
     11.745326966911 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.438133302082 #(0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0)
     11.30185508728 #(0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

     8.912644 #(0.000000 0.694204 0.760040 0.672295 1.037819 1.564711 1.732865 1.658707 1.745101 1.380564 0.727720 0.100135 0.721022 0.561486 0.240974 0.519530 1.196831 0.484789 1.724193 1.193560 0.161363 0.539193 0.422510 1.205796 0.216303 1.688064 1.885395 0.004966 0.464647 -0.102878 1.484681 0.258575 1.401437 1.304456 0.693268 -0.328621 0.908996 0.419588 0.687019 0.890000 0.624502 1.631679 -0.018488 0.583401 -0.238249 0.607463 1.404653 -0.015361 0.571033 1.293398 0.547449 0.286492 0.626279 0.807716 1.744843 0.303817 0.501848 1.159083 0.746854 0.443491 0.594360 0.730355 1.484079 1.507688 1.221762 0.721547 0.333010 -0.081015 1.177818 1.587112 0.777878 0.198064 1.269897 -0.222463 0.382980 1.874167 1.871413 1.687834 0.828659 -0.132880)
     8.903061 #(0.000000 0.696963 0.761557 0.669710 1.036210 1.566931 1.721165 1.661539 1.742714 1.374775 0.726967 0.097896 0.710129 0.558087 0.242710 0.524299 1.210436 0.489564 1.728224 1.188742 0.159534 0.538900 0.415646 1.207113 0.217937 1.688888 1.888232 0.000238 0.460877 -0.104304 1.485707 0.255788 1.410340 1.301874 0.702290 -0.327382 0.909607 0.422622 0.690668 0.901233 0.620949 1.633296 -0.010932 0.586583 -0.225021 0.617489 1.405256 -0.010057 0.566249 1.298874 0.539026 0.284690 0.631124 0.807009 1.755817 0.289809 0.507472 1.150236 0.740494 0.439771 0.587862 0.722419 1.487211 1.509591 1.218374 0.726806 0.333387 -0.089778 1.176145 1.586028 0.773338 0.192841 1.269188 -0.222458 0.391922 1.861083 1.884702 1.681655 0.837890 -0.128449)
     8.898612 #(0.000000 0.696344 0.764272 0.667623 1.036200 1.569339 1.719645 1.664608 1.737251 1.373199 0.729338 0.103458 0.713452 0.558464 0.239859 0.522820 1.209300 0.488208 1.718956 1.187125 0.165889 0.543174 0.415833 1.205810 0.215989 1.691709 1.889656 -0.003553 0.463179 -0.105942 1.484731 0.258248 1.411140 1.300827 0.706613 -0.322679 0.907206 0.421827 0.686941 0.907107 0.624179 1.628249 -0.008342 0.587875 -0.221324 0.618900 1.403357 -0.010860 0.562476 1.295151 0.538929 0.281784 0.631814 0.805536 1.761922 0.286840 0.509143 1.152376 0.740817 0.438429 0.587306 0.718295 1.484159 1.511374 1.221318 0.726713 0.331055 -0.095789 1.175482 1.583274 0.778218 0.195221 1.270534 -0.221414 0.392972 1.858049 1.882084 1.679266 0.843118 -0.126486)
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
#(81 11.712129592896 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0)
     11.501712958685 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0)
     11.22668050284 #(0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.999386 #(0.000000 0.636704 0.919856 0.364855 0.482236 1.332751 0.670771 1.786492 1.132598 1.417907 0.440010 0.232061 1.126315 0.043418 1.334412 1.777180 1.272400 0.776184 1.127149 0.032976 1.580036 0.069827 1.913095 0.028111 0.879566 0.822704 1.299361 1.380039 1.029283 0.158043 0.976969 1.176080 0.254964 1.538453 1.829697 0.589440 1.385747 0.717737 0.653801 1.719225 1.010556 1.795028 -0.124781 -0.038353 0.781428 1.688962 0.392217 0.506997 0.708882 0.726628 -0.179121 0.487411 0.358661 0.029085 -0.184601 0.934967 -0.612037 1.678497 1.758492 1.376364 1.158652 0.351359 1.924829 0.229318 1.186140 0.941704 0.379187 -0.021711 0.337728 0.113318 1.055005 -0.041266 1.172383 0.355135 -0.084320 -0.230776 0.285280 1.605754 0.133969 0.155697 -0.140985)
     8.993998 #(0.000000 0.636751 0.920048 0.365669 0.477946 1.336017 0.669352 1.785557 1.130216 1.416644 0.440922 0.231515 1.127604 0.041463 1.332258 1.780894 1.274713 0.771704 1.126971 0.033094 1.582754 0.067812 1.914158 0.026056 0.878856 0.825850 1.296875 1.383602 1.029910 0.157395 0.976012 1.176464 0.253993 1.535453 1.831173 0.584953 1.391904 0.718067 0.654959 1.713218 1.009768 1.792700 -0.124016 -0.041074 0.778948 1.687788 0.400387 0.505095 0.708859 0.724321 -0.181066 0.483060 0.363237 0.028143 -0.187444 0.935593 -0.616832 1.674274 1.763223 1.371173 1.160874 0.352512 1.928192 0.230330 1.192677 0.944215 0.381375 -0.023299 0.342451 0.111811 1.055875 -0.041760 1.167875 0.356968 -0.077068 -0.226964 0.289050 1.605427 0.129811 0.151778 -0.130837)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
#(82 11.697486877441 #(0 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0)
     11.601468306037 #(0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.108691 #(0.000000 1.664074 0.120439 0.974519 0.656798 1.932908 0.612034 0.041043 1.110170 0.556893 0.379443 0.359746 -0.251371 1.621400 0.914613 0.459432 1.372532 -0.157514 1.110512 1.066157 0.612825 1.658235 0.425776 1.976703 0.353728 0.280241 1.032069 1.701860 0.394105 0.218873 0.867086 1.330782 1.854533 1.014953 0.214208 -0.071965 0.194780 1.561024 1.158727 0.615697 1.413107 1.725886 0.138523 0.377459 0.259413 1.054121 1.617942 0.649733 0.040448 -0.358426 1.110086 1.446356 1.625598 0.779893 1.603956 0.022722 0.353391 1.671051 1.828188 0.991340 0.308657 0.909383 0.859724 0.460147 0.120324 0.623171 0.810607 1.823200 0.684565 0.729743 0.366167 -1.857154 0.497073 0.345905 0.389496 1.371158 1.056787 0.924156 1.573982 1.158865 1.815669 0.445958)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
#(83 12.009690094281 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0)
     11.868338980165 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0)
     11.429935034332 #(0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     9.161778 #(0.000000 0.565844 0.017427 0.999853 0.090643 0.891500 0.228464 1.198563 -0.076140 1.762064 1.661510 1.098817 1.357624 -0.069489 1.276047 0.263820 1.726264 0.020351 1.713473 -0.032576 1.614725 0.509151 0.703442 1.594959 -0.078688 -0.032791 1.718025 0.538263 0.884353 0.649492 0.865299 0.797006 0.741504 0.410048 0.167948 0.299103 0.867977 0.015033 0.211127 1.063424 0.496664 1.726800 1.612783 0.660555 0.288319 0.094786 1.508106 1.115273 0.226816 0.743899 0.616744 1.364321 0.698351 0.217020 0.506185 1.571740 1.849538 0.937887 0.176739 1.217072 0.028008 1.798937 1.113530 -0.045155 0.269435 0.193442 0.418745 -0.120764 0.338159 1.168671 1.342196 0.683757 1.533710 -0.294433 0.580624 1.426343 1.083644 0.422662 -0.019956 0.009565 0.232384 0.892505 1.346317)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
#(84 12.073565240583 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.956374168396 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 1 0)
     11.944072619199 #(0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.81104850769 #(0 0 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 0 1)
     11.774056434631 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

     9.049585 #(0.000000 0.158856 -0.212744 0.193684 1.190883 0.512976 0.196563 1.423546 1.596909 0.075603 0.595901 0.502376 1.884029 1.301361 1.391815 1.011468 1.557590 1.086542 0.594807 1.181278 0.184928 0.621781 0.444991 1.759352 0.214532 -0.174162 1.504541 1.962216 0.137462 0.851089 1.250599 1.294318 -0.296723 0.449954 -0.223886 -0.363573 1.214491 0.997756 1.642970 1.473193 0.239779 -0.169500 0.754651 1.697938 0.960372 0.363829 0.142444 1.134417 0.472866 0.956284 0.615634 1.336872 0.784259 0.714737 0.560874 1.449779 1.045026 0.749576 0.695604 1.031781 -0.001431 0.085914 1.731538 0.709966 0.854696 1.266563 1.324543 0.616336 1.012379 1.505650 0.090964 1.479692 -0.038939 0.925095 0.277363 0.771215 -0.226000 0.707301 0.784892 1.579217 1.078895 1.196283 1.596407 0.574671)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
#(85 12.387479800774 #(0 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1)
     12.285636929325 #(0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0)
     11.953980403239 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1)
     11.927130699158 #(0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

     9.219942 #(0.000000 0.455813 -0.011867 1.411465 0.433424 1.182466 0.733955 -0.167069 -0.410037 0.636163 1.397451 1.743029 0.579611 1.370362 0.708673 1.752489 1.500760 0.360345 0.749853 0.467762 0.265089 1.037236 0.870853 1.736757 0.008222 0.655695 0.967815 -0.057923 1.699543 1.844637 1.107509 0.051899 1.437840 0.404512 0.390788 0.752187 0.628906 1.497586 1.563689 0.404275 0.967716 1.258872 0.942287 0.665873 1.281212 0.332154 0.326249 0.316091 1.566785 0.068793 0.834439 1.705751 0.834980 0.931219 0.679155 1.595164 1.312632 1.314513 0.156668 0.839960 0.627986 0.806000 0.624517 1.293947 0.734541 1.365350 0.946060 1.189674 0.340653 1.547044 1.350826 0.681857 1.078876 0.606677 1.333414 -0.248274 0.732021 0.351338 0.084965 0.218392 -0.147332 1.747101 0.568674 0.487423 0.108240)
     9.212181 #(0.000000 0.455316 -0.010080 1.408851 0.435968 1.183393 0.730527 -0.169335 -0.414238 0.626773 1.399000 1.742036 0.581077 1.371815 0.707328 1.744224 1.505255 0.359516 0.754480 0.465178 0.269557 1.036769 0.873072 1.739996 0.005547 0.663270 0.969270 -0.056337 1.689218 1.840752 1.106477 0.046351 1.437612 0.408201 0.395005 0.750942 0.625242 1.486423 1.567538 0.401179 0.969926 1.260634 0.947695 0.667581 1.286081 0.327228 0.330617 0.317297 1.565397 0.068959 0.835613 1.699302 0.833698 0.936201 0.671377 1.596245 1.317273 1.317053 0.154308 0.839285 0.639068 0.817680 0.622620 1.293614 0.744576 1.359869 0.943260 1.195469 0.341000 1.553647 1.349309 0.685811 1.086387 0.609937 1.336960 -0.254513 0.735210 0.355646 0.085374 0.216898 -0.143342 1.754279 0.566227 0.488966 0.097590)
     9.206495 #(0.000000 0.454294 -0.006778 1.405024 0.435345 1.180265 0.729061 -0.167606 -0.414377 0.622801 1.397590 1.745859 0.580538 1.369588 0.708392 1.745766 1.501891 0.357658 0.749761 0.470769 0.266733 1.037590 0.874498 1.736222 0.004264 0.668144 0.970831 -0.055600 1.693281 1.843913 1.101654 0.045034 1.436150 0.408743 0.391619 0.757017 0.622827 1.480180 1.565855 0.400913 0.972856 1.254371 0.947327 0.668234 1.287300 0.329811 0.330070 0.314091 1.562459 0.066784 0.834398 1.696859 0.841687 0.935500 0.675823 1.598347 1.318536 1.314650 0.150970 0.836407 0.640954 0.819952 0.623171 1.294750 0.745024 1.356839 0.939237 1.198437 0.340920 1.557885 1.350507 0.684458 1.090164 0.608579 1.330718 -0.253728 0.735970 0.353223 0.089358 0.219355 -0.145713 1.750455 0.563666 0.486954 0.088866)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.2736
#(86 11.942325532619 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0)
     11.819784750357 #(0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)
     11.780031204224 #(0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.239690 #(0.000000 -0.324968 0.928427 -0.137032 1.083109 0.081783 0.857088 -0.020624 1.468359 1.303767 0.425809 0.298661 1.668565 0.492912 1.697066 1.176197 0.797614 0.981725 0.972043 1.040105 1.806321 1.476594 1.863863 1.497767 1.907281 0.472454 1.695504 0.631304 0.965743 -0.158278 0.827998 1.034622 0.903844 0.728905 0.175881 1.650357 1.194665 1.525407 0.823707 1.187813 0.843973 0.846807 1.524637 1.514477 0.390252 0.383046 0.799952 0.820872 1.188032 1.754800 0.258172 0.584353 0.367515 1.538483 0.799071 0.708324 1.017484 0.704498 -0.020439 0.956780 0.177360 0.385855 1.635844 0.251629 0.924367 1.339205 1.422273 0.593531 1.512268 -0.661331 1.667758 0.985898 1.452684 1.452826 1.291036 1.207700 0.642522 0.315614 1.769551 0.769238 1.524058 0.224449 0.124287 1.139993 -0.355161 0.089127)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
#(87 12.170317807503 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1)
     12.065419665482 #(0 0 1 1 1 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1)
     11.76194265333 #(0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.391027 #(0.000000 0.908024 -0.306506 0.673470 -0.205597 0.584518 1.887098 -0.003037 0.275437 0.284864 0.498502 1.390619 0.420836 1.130381 0.231886 0.847073 0.095615 0.607414 1.011081 1.447841 0.164573 1.502453 0.831139 0.132345 1.661157 1.312226 1.076357 0.243461 1.200184 -0.157359 0.043305 1.032359 -0.121583 0.546718 0.767293 -0.067637 0.694051 1.269141 0.893547 1.206075 0.570998 1.759030 1.248561 0.298055 0.146313 1.260654 1.554458 1.250667 1.256527 0.344868 0.276564 0.771847 0.802457 0.370262 0.976654 1.676537 1.624269 -0.036514 0.330146 -0.303271 1.905782 -0.218435 0.485886 -0.252420 1.030936 0.499169 1.467945 1.172102 0.363852 0.627021 0.755752 1.579484 0.464510 0.154753 0.560440 0.607319 0.638005 1.680124 0.083722 1.177794 0.736709 0.494518 0.286164 0.424904 0.321110 1.279219 1.729418)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
#(88 12.085149765015 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.991882324219 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1)
     11.638312339783 #(0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     9.391266 #(0.000000 0.951919 0.349780 1.431129 0.882757 1.645123 0.119849 0.231009 0.321553 1.287603 0.883367 1.709760 1.327737 1.482146 1.765489 1.475588 0.024170 0.662054 0.271062 0.577817 0.292748 1.146971 0.373798 0.074173 0.517135 0.103556 0.405735 1.591867 -0.344596 1.357476 0.249961 0.244986 1.364060 0.982833 0.884415 0.627339 0.609179 1.403375 -0.066691 0.162680 0.801953 0.746754 0.041970 0.438098 1.756161 0.828956 0.592865 1.673585 0.747983 1.638153 1.205490 0.167645 0.464929 -0.154792 1.359667 -0.190578 0.214425 1.475987 1.295971 0.956028 1.058690 0.124000 1.060900 1.804021 1.861617 1.346355 1.268512 1.265870 1.274101 1.074875 0.092864 0.042365 0.970234 0.881333 -0.108882 0.764256 0.099451 0.647276 1.526433 0.513606 1.251535 1.222421 0.625559 0.711235 1.507493 1.808233 0.543792 1.368756)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
#(89 12.644 #(0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1)
     12.148494905477 #(0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

     9.472615 #(0.000000 0.150083 0.891634 1.001254 0.117140 0.334827 0.513328 0.409924 0.971306 0.550414 0.454067 0.565463 1.465027 0.649243 1.843011 0.403693 0.574619 1.541968 0.271000 0.363088 0.098278 0.042912 0.284076 -0.218863 0.809814 0.647783 1.447012 0.889636 1.378793 0.534278 -0.334856 -0.186570 1.785150 1.085706 1.516663 1.568373 0.823136 0.765666 0.157943 0.795560 0.634023 1.410905 0.998401 0.634625 -0.048746 0.621077 1.240559 0.590505 0.559871 1.736873 1.447453 1.096197 -0.529446 1.197020 1.258901 1.174681 0.113743 0.131603 1.448674 0.781112 0.041421 0.704153 0.068860 1.919719 1.734535 -0.308648 0.240609 1.196557 0.399186 0.658712 -0.302315 1.187038 0.087947 0.451649 1.231493 1.586420 -1.622483 0.138236 0.980516 0.520557 1.245864 1.011113 -0.550327 0.212162 0.585507 0.099562 0.956382 1.774128 0.914152)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
#(90 12.524876494276 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1)
     12.364291918726 #(0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0)
     12.299262768523 #(0 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0)
     12.059710502625 #(0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

     9.487241 #(0.000000 0.821187 1.065882 0.245299 0.203813 1.336050 1.029192 0.060191 1.116904 0.099855 0.397107 1.567726 1.597774 1.290756 0.257293 0.044108 1.243795 1.542367 0.016757 0.761122 0.736892 1.274128 -0.021140 0.359952 0.382828 1.218339 1.795620 0.424928 -0.350980 -0.045109 1.264637 -0.246113 0.268799 1.163717 0.248773 0.227821 0.973862 0.046334 0.590622 0.249050 1.038956 1.308054 0.927178 1.123337 1.495757 1.079094 1.029002 0.844746 0.881979 0.068151 1.167550 0.339718 1.885933 0.711159 0.478834 1.733200 0.810480 0.944144 -0.078350 1.327983 0.060049 0.690812 0.266076 0.704239 1.824891 1.661000 0.523134 0.570089 0.480904 0.749266 0.577075 -0.345022 1.908572 1.812546 1.629032 0.727732 -0.248250 0.648783 0.210873 0.718072 0.154953 1.374916 1.337617 1.170048 0.324014 0.272274 0.525214 0.775291 0.726050 0.455735)
     9.479133 #(0.000000 0.822048 1.068030 0.245103 0.203813 1.337163 1.028331 0.059571 1.115220 0.098101 0.397397 1.570543 1.598034 1.289018 0.259921 0.045157 1.242626 1.542433 0.015545 0.760564 0.737915 1.271979 -0.019075 0.363900 0.382471 1.216250 1.794431 0.424508 -0.347932 -0.047968 1.264050 -0.245556 0.265542 1.169267 0.248290 0.226799 0.976877 0.046568 0.592976 0.245442 1.039617 1.304587 0.935439 1.123390 1.494419 1.082327 1.025358 0.842932 0.879477 0.065387 1.168085 0.338837 1.888400 0.716047 0.479689 1.733020 0.809078 0.946940 -0.078437 1.324866 0.061389 0.689578 0.267649 0.703261 1.824143 1.659706 0.524310 0.572907 0.479618 0.745116 0.577835 -0.344556 1.911060 1.814292 1.628569 0.729576 -0.246475 0.646149 0.216374 0.717722 0.156295 1.374775 1.335769 1.171186 0.323834 0.268945 0.525905 0.778827 0.723760 0.452553)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
#(91 12.389336585999 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0)
     12.363633155823 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0)
     12.335505485535 #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 1 0)
     12.130150794983 #(0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

     9.528947 #(0.000000 0.481655 1.594439 1.568902 0.697073 1.408460 1.707303 1.224860 0.612341 1.080428 0.880549 1.734112 0.982775 1.127349 0.542673 1.278938 1.245839 0.259013 0.026700 1.730319 1.718641 0.127782 0.350321 1.499262 -0.045960 0.661905 0.491583 0.650691 1.529351 0.348327 1.850119 0.053248 1.564181 1.855067 -0.100690 -0.046751 1.512155 0.331287 0.375579 0.070846 0.530999 1.696360 1.469014 0.538915 1.146418 0.023700 0.842729 -0.119479 1.151201 0.438075 1.568174 0.639290 0.856401 1.661287 0.307628 0.426892 -0.123879 1.724105 -0.224579 0.942282 1.637726 0.293382 0.106322 0.270710 1.076945 1.053470 1.411125 1.497123 0.340993 1.799885 0.724628 1.007280 1.020833 0.419771 1.154723 1.181398 1.725955 -0.054491 0.131589 1.260162 0.429345 -0.095145 1.444416 0.053690 1.369364 1.065391 0.957845 0.105299 1.588168 1.926962 0.805879)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
#(92 12.627931418696 #(0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1)
     12.009957507951 #(0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

     9.654726 #(0.000000 0.073950 0.562760 -0.180087 0.216157 -0.064682 0.011732 1.400011 1.178116 0.006106 1.028579 0.397660 0.590848 0.922626 0.799773 0.385903 1.038718 0.734262 1.870966 0.736360 0.383839 0.570190 0.759824 0.011632 1.798220 1.645576 -0.184029 0.237620 1.801298 0.967908 0.061908 1.192374 0.644525 1.780629 0.342193 1.813004 -0.295376 0.340567 1.530641 1.402841 0.937327 1.001714 0.486703 0.988705 1.444886 0.186970 0.400179 1.119020 0.894213 0.326899 0.696833 1.096411 1.056338 1.205784 1.261436 1.027348 -0.086842 1.888307 1.158896 1.107692 0.414344 0.148968 0.479042 1.049422 1.303973 -0.201718 1.077982 1.447336 0.805073 0.860443 -0.345582 1.821312 1.386986 0.509822 1.929047 0.597704 1.241513 0.026566 1.716940 0.297799 0.891027 1.872299 0.872054 1.577813 0.746929 0.084012 0.519525 -0.035012 1.599347 0.757678 0.953731 -0.218541)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
#(93 12.624432854783 #(0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1)
     12.125471062226 #(0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.703831 #(0.000000 1.516050 1.734847 1.813169 -0.105899 0.481182 0.510023 -0.182647 1.945564 1.305558 0.126574 0.996967 1.682607 0.947402 0.884884 1.365471 1.702460 0.888961 1.100639 1.393874 0.338603 0.546178 0.314508 0.659604 0.192654 0.436951 1.156866 0.121482 0.268899 -0.204085 0.511015 -0.044204 0.266428 1.174160 0.988455 0.526130 0.019860 1.858881 1.115630 0.583368 0.429626 1.036602 1.520239 1.860722 1.659196 1.393464 1.683916 1.144605 1.571413 -0.021336 0.818154 0.857800 1.600648 -0.152887 1.574661 -0.293045 1.441731 1.443098 0.226926 0.935884 0.173234 0.628242 0.300674 -0.334920 1.526390 1.498612 0.342326 1.550562 0.881319 -0.147092 1.462093 0.189243 0.677942 1.359930 0.548757 0.528263 1.535511 1.256459 1.816784 1.375696 0.172911 0.121927 1.240072 1.514902 1.212390 0.413849 1.827908 1.395322 0.406554 1.472932 0.667453 1.743675 0.551960)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
#(94 12.840441703796 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)
     12.510846178591 #(0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

     9.994747 #(0.000000 0.282902 0.945972 0.724203 0.027615 0.953259 1.102656 -0.028654 1.298905 1.116381 -0.029515 0.630456 0.776527 0.953348 -0.104560 0.140764 1.457722 0.751991 0.852252 0.280293 0.911490 0.466508 0.496306 0.849571 0.748952 0.529781 1.080235 0.648396 1.876067 -0.126403 0.927072 0.395861 1.433843 1.073551 -0.243097 1.629522 0.853509 1.580983 0.379343 0.028738 1.793691 1.365035 1.769762 1.307882 1.579379 1.369855 1.201827 0.298233 1.492951 0.969322 1.037440 0.986911 -0.265307 0.160928 0.144083 0.447441 0.186548 1.469520 0.197964 1.216523 1.059884 1.273163 0.432301 1.469448 1.333041 -0.087527 0.126295 0.963711 1.540788 0.792066 0.479372 0.649972 0.855451 1.408971 1.155520 0.292298 0.971896 1.828610 1.433555 -0.131172 1.266750 0.994089 0.550615 0.739833 1.572707 0.069097 1.107277 0.105102 0.466611 1.117144 1.345031 0.969627 0.675127 0.053450)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
#(95 12.744465939438 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.706251144409 #(0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.448801040649 #(0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     12.431831359863 #(0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     9.872220 #(0.000000 1.290021 1.094574 1.289254 0.777075 0.613943 -0.103411 0.953606 0.785437 -0.188455 1.633489 0.093148 0.028987 1.754107 1.308104 1.470491 0.912786 -0.058470 0.613367 1.209875 0.452270 1.600963 1.126752 0.835222 0.371664 1.564190 1.002192 0.873588 1.627648 1.673137 1.348794 1.318139 0.967996 0.790482 1.717003 0.056605 0.621705 0.808080 1.488458 1.280827 0.751371 0.344496 0.711284 0.584875 0.686536 1.550957 0.285460 0.551163 1.155702 -0.004317 0.766557 -0.046598 -0.148508 1.846033 0.937439 1.712194 1.047374 -0.098577 1.043878 0.911165 1.886020 1.782673 0.139943 0.832515 1.386418 0.334932 0.670828 1.181611 0.866170 1.335306 0.778145 0.374585 1.307072 0.030925 1.571911 1.278489 1.677033 1.327630 0.125408 1.117264 0.426978 1.079248 1.294939 1.596728 1.336207 1.528768 -0.069596 1.631456 0.184938 1.395648 0.665217 0.747477 -0.193461 0.117060 1.772423)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
#(96 12.828451411951 #(0 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1)
     12.705632891559 #(0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1)
     12.682573318481 #(0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1)
     12.586637130548 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

     9.858639 #(0.000000 1.670983 0.285310 0.267391 -0.020713 1.527801 1.350806 1.468289 1.959307 0.745049 0.833269 1.695927 0.053448 -0.360648 -0.009685 0.057817 -0.029080 0.963022 1.476375 1.416655 1.644990 1.028547 0.727066 0.591745 -0.097819 1.512883 -0.300131 0.607260 0.624465 1.126166 0.545667 0.641102 0.097644 0.874108 1.620145 0.967134 1.190690 0.560799 0.740485 -0.461228 0.612887 0.640708 1.777573 1.712413 0.461031 1.253034 0.864791 1.041453 0.231399 1.619014 1.278225 0.742019 1.197758 -0.413662 1.153111 -0.258503 0.949095 1.725830 1.436307 0.016825 0.570128 1.054216 -0.002973 0.213207 0.701781 1.912432 0.823896 0.853074 0.015814 1.006434 0.026300 1.447387 1.204384 0.692934 1.771464 1.204723 1.215557 1.200801 1.060016 -0.217865 0.249753 0.789466 0.811931 1.612619 1.000393 0.232656 1.332554 0.067500 -0.262633 0.152330 0.360651 0.843314 0.019120 1.363355 0.954938 1.529730)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
#(97 13.438 #(0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0)
     12.872588157654 #(0 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     12.585 #(0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
     9.893709 #(0.000000 1.554771 0.937691 0.107253 1.348826 1.369619 1.555110 0.726878 0.806368 0.984615 0.564036 1.850901 1.316445 0.720154 0.080322 1.473966 1.778234 -0.107051 -0.190972 -0.016781 0.271373 0.754269 1.672021 0.125303 1.481616 0.619056 1.221190 1.248441 1.459723 0.778322 0.897014 0.194547 1.354525 0.507250 0.474628 1.479252 0.157806 1.409509 1.160421 1.449484 0.927078 1.758283 0.100656 1.433266 1.380713 0.838665 -0.137924 -0.004995 0.105022 0.950957 0.457169 -0.451088 0.057296 1.644440 1.022251 1.820805 1.111880 0.698807 -1.937796 1.661575 1.946096 -0.109704 1.491055 0.841201 1.410935 1.061826 1.369956 -0.020542 1.931642 0.486819 0.575853 0.803189 1.320194 0.509048 0.842233 1.491823 0.207453 1.335914 1.270844 0.600927 0.394468 0.822040 1.507993 0.381442 1.010540 0.194383 0.671291 0.265198 0.433820 0.547122 1.820973 0.655966 1.311413 0.775817 0.005875 0.658500 1.194795)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
#(98 13.163645755645 #(0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1)
     13.161917686462 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1)
     12.724907890996 #(0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

     9.836737 #(0.000000 -0.145976 0.683274 1.134389 -0.147406 1.648139 0.349069 0.470352 0.167808 0.693583 1.684329 0.347891 1.036331 0.537150 0.334998 1.575111 0.939651 0.937274 -0.116531 1.632661 1.649144 0.057636 1.895215 1.196929 1.292516 1.245069 0.012778 0.404644 1.200062 1.646536 -0.138651 0.258970 1.272891 1.681059 1.142761 0.896961 1.124061 1.463466 0.833791 0.451786 0.796953 -0.386569 1.870489 1.731358 -0.254772 0.752185 0.589149 0.607606 0.213099 -0.003029 1.514193 -0.061613 0.589306 0.001238 0.483696 0.530971 -0.068549 1.282771 1.321673 0.034393 0.262373 -0.197474 0.625085 0.480515 0.814692 0.019487 0.599509 1.205008 0.834577 1.229724 0.679187 1.625338 0.327014 1.855764 0.719384 0.083128 1.542502 0.184002 1.459362 0.300517 0.137668 1.544439 1.235258 0.495855 1.415999 0.864357 0.033681 1.478001 0.617221 0.263890 0.566610 0.298059 1.800726 0.244976 1.136425 -0.088466 0.148674 1.197724)
     9.823874 #(0.000000 -0.152345 0.679332 1.140256 -0.151054 1.652515 0.346810 0.478361 0.164853 0.704451 1.694059 0.355041 1.032829 0.539453 0.336846 1.567871 0.942146 0.933437 -0.121620 1.635317 1.642899 0.063383 1.882301 1.198511 1.291510 1.244009 0.013546 0.404787 1.200708 1.644107 -0.143552 0.254249 1.268540 1.675480 1.137364 0.899831 1.123445 1.460838 0.838442 0.451392 0.793729 -0.394990 1.869793 1.730215 -0.250669 0.754055 0.581299 0.611589 0.212658 -0.003194 1.511748 -0.050101 0.596674 0.008164 0.486273 0.528809 -0.072874 1.278417 1.326074 0.034449 0.260856 -0.206668 0.621247 0.479605 0.815411 0.011301 0.598607 1.207641 0.839701 1.227900 0.677182 1.634301 0.325134 1.857569 0.720614 0.081895 1.543589 0.186528 1.462066 0.302752 0.131827 1.549680 1.231391 0.490829 1.419672 0.862258 0.035724 1.479494 0.619156 0.262210 0.564605 0.296763 1.794634 0.247995 1.137577 -0.094459 0.154628 1.189588)
     9.816357 #(0.000000 -0.148460 0.679981 1.142506 -0.147845 1.656387 0.345155 0.479038 0.167025 0.705760 1.696635 0.356402 1.032342 0.538373 0.342390 1.567430 0.944381 0.926671 -0.115394 1.634399 1.642385 0.065401 1.882478 1.193921 1.290380 1.243741 0.015321 0.407853 1.200940 1.646677 -0.140446 0.257082 1.267422 1.673203 1.134641 0.909036 1.120636 1.463714 0.837390 0.444951 0.784365 -0.394187 1.872820 1.726400 -0.237933 0.757251 0.583044 0.615008 0.208779 -0.010693 1.514708 -0.044529 0.599771 0.011962 0.486920 0.531955 -0.064352 1.280390 1.327909 0.039617 0.274209 -0.198351 0.620436 0.477741 0.810833 0.011544 0.599225 1.211252 0.837062 1.231370 0.675467 1.637382 0.322601 1.861993 0.721981 0.079932 1.549764 0.194251 1.462469 0.313013 0.139534 1.549062 1.224767 0.500976 1.419479 0.863486 0.038209 1.480017 0.625455 0.260588 0.561787 0.302218 1.798458 0.257145 1.152665 -0.091103 0.164202 1.195184)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
#(99 13.236550650051 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1)
     13.002375571256 #(0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

     9.907981 #(0.000000 0.606829 1.113142 -0.019981 1.684298 0.213135 1.025392 1.554506 1.633442 1.173780 0.740821 0.745715 -0.145386 0.345123 0.660960 1.631812 -0.455537 -0.158066 1.634130 1.767961 1.076523 0.074577 0.444385 1.597470 0.475127 1.602753 0.048343 1.531815 1.446259 0.857507 1.284824 1.587808 1.169283 0.453226 1.302510 0.636916 0.708757 0.481843 1.251014 0.339437 0.048971 -0.240332 0.735044 0.461840 1.567380 -0.080769 1.671674 1.796597 0.380447 0.539510 -0.007961 1.424577 0.820187 1.166410 -0.081651 0.205082 -0.005158 1.828406 0.059210 0.052884 0.095609 0.285037 1.247667 0.932627 -0.018600 1.449307 0.050820 0.168992 0.728985 -0.352385 0.761385 0.530599 1.750335 0.432050 1.374452 0.835102 1.054672 1.623770 0.648170 0.816474 1.670537 -0.470733 1.430530 1.205820 0.419973 0.290317 1.403853 1.789942 0.237135 1.844063 0.888797 1.761405 0.988553 0.544968 1.477273 0.726444 1.202785 1.552815 1.294774)
     9.906340 #(0.000000 0.598193 1.111553 -0.010149 1.703360 0.211191 1.020566 1.562681 1.634142 1.144106 0.755728 0.764005 -0.124718 0.313538 0.657222 1.668828 -0.445718 -0.155196 1.644254 1.801280 1.042034 0.090314 0.452720 1.626373 0.466828 1.630660 0.063446 1.524994 1.472574 0.816475 1.263051 1.600720 1.167636 0.416678 1.322511 0.629826 0.681919 0.492136 1.220983 0.320167 0.082878 -0.205228 0.784104 0.452318 1.584898 -0.064865 1.693548 1.803515 0.360135 0.516002 0.053316 1.446767 0.855848 1.144718 -0.045736 0.200417 0.037646 1.805130 0.062566 0.045204 0.099898 0.332026 1.263196 1.034018 0.047477 1.478233 0.054102 0.183489 0.800256 -0.311586 0.784371 0.564831 1.762603 0.423143 1.375830 0.867807 1.063036 1.666325 0.701829 0.867742 1.687776 -0.464002 1.474279 1.218540 0.444898 0.284682 1.439562 1.793562 0.242794 1.844931 0.905435 1.794664 1.046412 0.542675 1.533252 0.775693 1.222967 1.590224 1.265381)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
#(100 13.230233676417 #(0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0)
      12.998435541498 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

      10.235334 #(0.000000 1.924415 1.197139 1.906868 1.332442 1.044939 0.284950 1.403233 0.048031 1.282162 0.180341 0.258112 1.642682 -0.367013 0.985799 0.308630 1.585706 0.585957 0.844075 0.659002 0.697927 0.845451 1.535061 -0.184733 1.269560 -0.056618 1.823535 -0.006320 0.531994 -0.197321 1.647520 1.351780 1.750012 0.951263 -0.096685 1.419516 0.746669 0.859061 0.458613 1.298649 1.297162 0.490678 1.586784 1.836338 0.098638 1.822664 -0.069542 0.349470 1.488232 0.113332 0.548901 1.697339 1.305644 0.214436 0.562366 0.788424 1.837627 0.187787 0.314011 1.845657 1.148343 0.592289 0.131486 1.017531 1.295099 0.748345 0.862697 -0.111488 0.087667 0.033728 1.325682 1.229547 0.118200 1.324425 0.143508 0.990696 1.667693 1.534991 0.427675 1.110852 0.875002 1.464896 0.065674 1.650457 1.500716 1.232323 1.013873 1.338201 1.530961 0.917501 0.200657 0.852382 0.715995 1.238679 1.491169 1.124028 0.037417 0.512290 0.728728 1.576193)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
#(101 14.018204689026 #(0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0)
      13.645306283587 #(0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 0)
      13.268 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)
      13.219774246216 #(0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

      10.222326 #(0.000000 1.511340 0.307007 -0.101990 1.669288 1.450369 1.255707 0.352003 0.354773 0.222907 -0.297897 0.618930 1.659147 0.781398 0.648885 -0.011787 1.616042 0.045203 1.469990 -0.384484 0.711829 1.493248 0.762568 0.386853 0.265981 1.580490 0.830950 1.390633 0.475060 0.183610 0.981837 1.316376 0.671956 0.766275 0.973627 0.495198 1.562258 1.222539 -0.126413 -0.000376 0.017674 1.775142 0.655924 0.009658 1.445521 0.961719 1.661668 0.415713 0.480033 -0.209104 0.576231 0.488478 0.765240 1.580352 1.872481 1.098733 1.169426 0.166992 -0.502029 1.572009 0.990606 0.184543 1.122702 1.630818 0.637588 1.709028 1.250265 0.847591 0.078595 0.735935 1.731677 1.780951 1.666286 1.407491 1.801757 1.347989 1.547196 0.539384 0.816326 1.230273 0.720886 1.258285 1.311626 1.061269 1.676801 0.976569 1.220667 1.094809 0.112143 1.294124 0.158725 0.125812 0.412883 1.024418 1.168911 1.599401 1.618174 0.359827 0.776253 1.645653 -0.113651)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
#(102 13.521512151222 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0)
      13.497511863708 #(0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1)
      13.300039088203 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)
      13.194128990173 #(0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      10.258601 #(0.000000 0.112995 0.476137 0.342739 0.801140 0.927907 -0.197682 -0.037213 0.084752 1.673083 1.385505 1.294607 0.737751 0.712118 0.785526 0.423747 1.612431 0.393738 0.451135 -0.496704 0.730224 1.364423 1.501517 0.561328 1.834629 1.839582 0.877534 0.217256 0.545886 1.477387 1.712360 0.504495 1.471856 1.122461 0.829453 -0.219416 0.004943 1.899052 0.640082 -0.070621 1.250418 0.587154 0.242636 0.612317 0.416451 0.537471 1.082279 1.812566 0.500011 -0.011388 0.566559 0.267777 1.677343 0.096339 0.871989 0.953350 1.854853 1.597924 1.031704 1.015147 0.720465 0.353189 0.094984 1.691932 0.665736 -0.268389 1.105588 1.875184 0.225688 0.131946 0.212729 0.343564 0.842191 0.406459 0.139847 0.742979 1.947866 0.641704 0.119899 1.257118 0.071742 0.701629 -0.357087 0.959946 1.311480 0.667025 1.680822 1.598498 -0.295913 0.252788 0.862100 -0.382709 0.231599 0.994707 1.050017 1.186935 0.355210 1.092185 1.267868 0.951887 0.839932 1.858749)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
#(103 13.720711052869 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.673172572795 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1)
      13.435972213745 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

      10.363056 #(0.000000 0.761017 0.774720 0.600901 0.288873 -0.071070 0.774041 1.524736 0.353677 0.863169 0.295170 0.619112 0.240730 0.148717 0.246262 1.886459 1.674206 1.069235 1.738095 0.073984 -0.077494 1.658422 0.668148 1.564746 1.243374 -0.210242 0.480459 1.123439 1.181456 1.237757 0.162689 0.498592 0.955813 1.036959 0.403468 0.253398 -0.210023 1.214469 0.989462 1.272997 0.324820 -0.383531 0.492925 0.899475 1.249765 0.623735 0.025388 1.046901 0.230396 1.568527 1.414344 1.329686 1.494535 1.229123 0.112931 0.940031 1.215343 0.517457 1.132908 0.231647 1.495768 0.562911 1.157367 1.588298 1.380100 1.052242 1.927277 0.983655 -0.022396 1.537754 0.864818 1.491165 -0.009397 1.541430 0.582026 0.104249 -0.136203 0.695567 0.217961 1.674357 0.839835 -0.255416 0.042248 0.191656 0.893903 0.657431 0.748551 0.718148 1.351486 1.423092 1.242628 1.535775 0.442474 1.801999 0.886228 1.290236 0.213409 0.278385 1.078491 0.256112 0.175795 1.208709 1.281774)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
#(104 14.242193222046 #(0 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.682311361591 #(0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)
      13.330215043333 #(0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

      10.188148 #(0.000000 1.530511 1.654647 0.852195 1.504195 1.049830 0.096455 1.246616 1.500932 0.837265 1.484588 -0.180145 1.124927 1.243393 0.858707 0.170526 0.866914 0.395310 0.411743 0.928903 1.593894 0.727391 1.570169 0.845150 0.354634 0.528849 1.650999 0.012487 0.788922 0.043018 0.542951 0.086082 1.762995 0.134307 0.887464 0.506944 -0.165663 1.633791 1.507747 0.705773 0.776452 0.071616 0.887916 0.177118 -0.229958 0.864649 -0.044023 0.700818 1.525519 0.032733 1.887230 0.735838 0.540508 0.663700 0.344925 0.385988 0.598969 1.443690 1.541127 1.495296 0.261203 1.065542 0.392949 0.030537 0.627081 0.095609 1.642821 1.272383 0.050512 0.321322 0.364873 1.365131 1.383970 0.606154 0.951825 1.661958 0.995351 0.910714 1.766385 1.618682 0.478271 0.481183 1.230751 0.021572 0.475093 1.563609 -0.038195 -0.261374 0.290013 1.521032 1.531332 -0.424704 -0.055461 0.020475 0.269512 0.549719 0.629888 0.701417 0.209342 1.527979 0.607184 0.359118 1.544484 0.707679)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
#(105 14.418999645918 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)
      13.595993876506 #(0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

      10.231088 #(0.000000 0.625574 0.201269 1.326538 1.367665 -0.356999 0.508530 0.636597 0.288691 1.054890 -0.132526 -0.048328 1.240775 1.723143 1.099267 1.499243 0.056926 1.025202 -0.012266 1.930481 1.512462 0.800397 0.412570 1.428037 0.152103 -0.235613 0.145326 0.495494 1.140930 1.148623 1.047264 1.271730 0.947046 1.928143 1.139069 1.559823 0.344279 1.453446 1.951859 1.288933 -0.026338 1.376109 1.305408 1.007592 0.496782 0.481295 1.059274 0.469291 0.609489 1.576559 0.572414 1.363658 1.177108 0.232943 0.256078 0.563266 0.662845 0.886259 0.811296 -0.151844 1.511117 1.284141 0.270272 0.137980 1.714484 1.579526 1.906108 1.621311 0.401667 0.143004 1.306697 1.635000 1.149955 0.879745 1.213925 0.346287 -0.198139 0.152693 0.143118 0.860152 -0.036895 0.543163 0.334055 -0.051679 1.606700 0.450838 0.167730 0.397211 -0.267527 0.705635 0.229274 1.078232 1.076773 -0.022538 0.598378 0.654427 1.088360 0.011236 0.559751 -0.176410 1.683065 0.318170 0.700365 1.698039 1.327443)
      10.226878 #(0.000000 0.629256 0.198658 1.321908 1.369825 -0.356164 0.507615 0.637841 0.290389 1.053374 -0.130321 -0.049713 1.242936 1.724732 1.099606 1.496994 0.057854 1.024807 -0.010829 1.930157 1.515302 0.801794 0.413193 1.431368 0.151728 -0.235805 0.143319 0.499331 1.140979 1.148132 1.046869 1.270165 0.946826 1.928882 1.144541 1.560433 0.344734 1.449686 1.947933 1.287702 -0.027775 1.373849 1.304127 1.008319 0.497086 0.481786 1.060175 0.469316 0.609384 1.581398 0.569989 1.363816 1.176386 0.233412 0.256849 0.564662 0.665567 0.890141 0.811987 -0.149684 1.510136 1.288134 0.271329 0.136991 1.716353 1.580326 1.907366 1.616904 0.398961 0.144782 1.303268 1.632982 1.150702 0.880366 1.208390 0.347761 -0.197226 0.155975 0.138032 0.860304 -0.030222 0.546225 0.333954 -0.052274 1.607125 0.453048 0.166754 0.397644 -0.270405 0.703549 0.232865 1.076605 1.078723 -0.025070 0.599438 0.656352 1.092692 0.010873 0.562469 -0.174093 1.683070 0.317462 0.700578 1.696159 1.326756)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
#(106 14.299785614014 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.811582734804 #(0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)
      13.421741504769 #(0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0)
      13.200031373463 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      10.394865 #(0.000000 0.053213 0.080547 1.276536 1.076917 0.877915 -0.109063 0.534427 0.789639 1.001355 1.558069 1.047615 1.317636 0.117332 0.091282 -0.260487 1.200794 0.904796 0.412197 0.044113 0.316251 0.680078 1.444764 0.065700 0.821362 0.225133 0.519586 0.205046 1.215642 1.209968 -0.150845 0.473881 1.254031 0.009507 1.052686 0.525893 0.052625 0.976770 -0.071745 0.030853 1.277478 0.657686 1.436669 0.783909 1.444070 -0.036042 1.084983 0.366442 1.720891 0.373645 1.418115 0.974785 0.758283 0.884965 0.652257 0.618107 1.245824 1.723833 0.642367 1.518152 0.286384 1.120950 1.077855 1.577056 1.398604 0.208505 1.439310 1.093423 0.096413 0.488499 0.097908 1.780658 0.146417 -0.282502 0.351823 0.066776 -0.399454 1.029174 0.071235 0.010902 1.722692 1.267456 0.599928 1.168400 0.912330 -0.167723 0.144122 0.047377 0.209509 0.441739 1.944848 0.392506 1.092205 0.584168 1.441180 1.780611 0.265971 0.352806 1.494605 -0.323564 0.280681 1.691921 1.508991 1.357041 -0.147753 1.239841)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
#(107 13.927956268954 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1)
      13.912716531306 #(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0)
      13.624429092956 #(0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)
      13.224366750161 #(0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.509723 #(0.000000 1.245646 0.597397 1.761809 1.863030 0.529021 0.084134 0.585386 1.594901 0.734250 0.547442 -0.041332 0.358840 1.325735 1.370924 0.634083 1.153129 0.134289 0.287516 1.032572 -0.199022 1.749931 1.061378 0.296885 0.022865 1.645581 1.320963 1.862332 0.609536 0.132901 0.439954 1.889202 1.569803 0.250436 1.344828 1.129371 0.103345 1.153616 0.173360 1.009598 1.491663 0.302014 -0.017385 0.293936 1.465088 1.515908 1.864762 0.425681 0.062365 1.007121 0.618860 1.067812 1.345047 1.723637 1.187258 0.552255 0.950015 1.292533 0.997296 1.353669 0.162073 1.175736 1.435300 0.198459 1.913550 1.278865 1.575872 1.242843 1.528557 1.365254 0.518098 1.361045 1.070391 1.436357 0.538787 1.434357 0.167419 -0.065492 0.770829 0.392656 0.085257 1.775495 0.186464 1.084185 0.813517 0.595097 0.006188 1.398940 1.819096 -0.012876 1.894230 1.463597 1.617757 0.249038 0.490647 0.994520 -0.354368 1.626774 1.379109 1.543355 1.444981 0.614982 0.055505 1.077654 0.419835 0.735585 1.649319)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
#(108 14.009567264777 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0)
      13.998919339781 #(0 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0)
      13.694299006963 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1)
      13.534 #(0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

      10.543357 #(0.000000 1.402747 0.622010 1.807740 1.084340 0.790125 1.320303 1.620102 0.490131 1.765484 1.074825 0.142640 0.488185 -0.011765 0.464977 0.235926 0.835162 0.710086 0.813454 -0.210862 1.257909 1.680089 0.622386 0.197483 0.879514 1.054011 -0.028207 -0.275727 0.704175 0.187452 0.918057 1.468566 0.727604 1.101418 1.579293 1.002747 1.892325 -0.090618 0.533879 0.783135 0.765331 1.558966 0.325124 0.742413 1.758657 0.820769 1.821463 0.012614 0.592984 0.251440 0.496853 0.325838 1.567883 1.010715 0.408180 1.706279 0.004205 1.830026 1.011159 1.233304 0.895308 0.432094 0.651781 1.265685 1.179331 0.749291 0.403725 0.921722 0.169744 0.794285 0.286072 1.738669 1.390921 0.143333 0.315035 0.739224 1.202977 0.548873 -0.264270 0.396975 0.993423 1.055739 0.348132 0.852241 1.275945 1.680136 0.561998 1.392169 1.857298 1.038454 0.212491 1.737653 1.693735 1.592150 1.368268 -0.152064 1.548290 -0.064388 1.090628 0.404743 0.647758 0.011058 1.894132 1.383257 1.648239 1.075805 1.324359 0.994517)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.4403
#(109 13.820175866598 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)
      13.496821304096 #(0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      10.708543 #(0.000000 0.371106 0.470203 0.239003 1.012961 0.129927 1.335363 -0.029381 0.006645 1.533429 1.162957 0.082548 1.474064 1.765598 1.903120 1.798532 -0.303830 1.052279 0.123670 0.276123 1.021894 1.653170 1.255939 1.506088 -0.227044 1.705939 1.649613 0.557253 1.032918 0.928799 1.294648 0.993658 1.887581 -0.127503 1.695253 1.321081 0.812581 0.498744 0.006208 1.570845 -0.002794 1.400353 0.306663 1.463284 1.738958 1.517418 1.701378 0.754943 -0.104189 0.982859 0.619499 0.995150 0.362960 1.469254 1.051047 0.964370 0.499393 1.216927 1.801154 -0.092442 0.014621 1.727291 1.303317 0.006540 0.294231 0.876519 1.690182 0.335380 -0.010161 0.803444 1.345767 0.551736 0.896544 0.901009 0.159505 1.730609 -0.175613 0.489310 0.772393 1.230645 0.693678 0.352660 1.003829 0.851550 0.700109 1.005924 0.039140 1.676203 0.343021 0.995339 1.348977 1.865300 1.179025 1.101625 1.089879 0.728468 1.381045 0.282021 0.357441 1.312131 -0.048052 1.229064 0.069444 0.119271 1.328440 0.842242 0.077966 0.203249 1.188297)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
#(110 13.885513312292 #(0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0)
      13.64278793335 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)
      13.592092514038 #(0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.739090 #(0.000000 1.156282 -0.287659 0.671868 0.016349 0.141141 1.314200 1.378376 0.745508 1.502881 0.428178 1.624259 -0.002906 1.725453 0.434132 0.638339 1.120126 0.921796 1.343557 0.117805 0.906679 1.185773 0.888195 0.502140 0.288921 1.017681 0.810817 1.104031 0.966142 1.064285 0.309628 0.557648 0.802417 0.271693 1.940373 0.091489 0.907542 0.454318 0.870055 0.181110 1.814256 0.100468 1.066253 0.233949 0.272882 1.339976 1.467081 0.680247 1.609198 0.145242 0.599627 0.673463 0.229785 0.169881 0.495581 0.862615 1.428791 1.806616 0.753886 0.984216 0.573874 1.194402 1.163492 1.049031 0.989019 0.700068 1.794268 1.342048 0.409380 0.365945 1.797274 -0.010034 1.903031 1.046556 1.326641 0.773217 0.885631 0.348422 1.371059 0.711162 1.614065 0.997785 1.317350 -0.016300 0.313659 1.749519 0.499507 1.119921 0.951889 -0.189027 1.129542 -0.034033 1.822479 0.590383 -0.280380 1.566555 -0.016838 -0.101813 1.196110 0.316133 0.731239 0.430072 1.155495 0.072031 1.694327 0.899239 0.865048 1.876592 1.200502 0.510936)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
#(111 14.436 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)
      14.359505653381 #(0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0)
      13.80813938144 #(0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

      10.627327 #(0.000000 1.378376 1.040811 -0.200345 1.865443 0.175638 1.815760 1.398729 0.353312 1.532464 -0.112514 1.338746 0.100690 1.221434 1.352756 -0.012325 1.368152 0.486106 0.534577 0.058996 0.661620 0.511417 1.057814 1.433311 0.249248 0.094678 1.000464 -0.045006 0.770639 1.348293 -0.203611 0.895080 1.632205 0.684869 1.444904 1.372922 1.284243 1.074774 0.570188 1.240080 -0.341803 0.370280 0.913216 1.314257 1.477371 1.418605 0.081101 0.557683 -0.017787 1.330401 1.113310 1.260856 1.361928 1.134453 0.075131 0.562865 1.816255 -0.116782 1.733359 1.157096 1.568730 0.745454 0.895487 1.009557 0.733045 0.373773 1.354392 0.955279 1.052502 1.581079 1.626303 -0.046242 0.783561 0.677552 1.562626 0.738597 0.009014 0.176334 -0.172077 0.273163 0.047490 0.130726 0.559438 0.291652 0.315085 1.594876 1.203086 0.818936 1.550355 0.181030 1.871042 1.202748 1.581630 0.528291 0.478774 1.639277 0.339781 1.642247 1.650500 0.958958 0.386046 1.271452 -0.362653 1.449462 0.665294 0.298708 1.243070 0.125123 0.281755 0.794855 0.221503)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
#(112 14.387 #(0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.250584755219 #(0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 1 1 0)
      14.059637729172 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1)
      13.719 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      10.669476 #(0.000000 -0.115927 1.480602 1.003194 0.609644 0.973531 0.775599 0.913985 1.188006 0.349080 -0.294548 0.851453 0.277406 1.542537 1.159683 0.722392 1.201938 0.975781 0.380676 1.927000 1.584338 0.369527 0.504040 0.549515 0.813799 0.752781 1.373472 0.294166 0.291932 0.586148 1.746917 1.809952 0.792813 0.306313 0.164694 0.309571 0.813127 0.167280 1.658517 1.520724 1.439227 -0.005206 0.569538 1.554350 1.622259 0.004096 0.324039 0.313587 0.313931 0.351048 0.773704 0.032142 -0.000638 -0.232135 0.568530 0.669231 1.500293 -0.071934 0.587478 0.833637 0.873289 -0.231860 0.442228 0.929466 0.621790 0.686272 0.830861 0.311257 0.013921 1.648800 1.405256 1.147937 -0.065489 1.787644 0.487982 1.096410 -0.234131 0.133403 1.253568 1.990381 0.775508 1.184870 0.434147 1.305468 1.234114 1.393775 1.014630 0.369631 0.517633 -0.131991 1.217047 0.179100 1.038640 1.832353 1.133503 0.211387 0.260324 0.921873 0.390875 0.737460 1.724116 0.455583 -0.193133 0.839298 1.583047 1.253334 1.198925 1.324328 1.260571 0.081014 1.312703 0.442679)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
#(113 14.501041453443 #(0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1)
      14.027848738379 #(0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.823463 #(0.000000 0.835504 1.045796 0.055731 0.333861 0.961764 1.484522 1.801423 0.155701 0.482925 1.383575 1.266895 0.163729 0.566786 0.311997 0.424348 1.786709 1.129727 -0.010887 1.223532 -0.037472 -0.041890 0.642823 0.699857 0.027489 -0.699762 0.588003 0.372917 1.883299 0.393040 0.094028 1.419367 0.664727 1.480132 1.487791 0.535931 0.515211 0.512990 0.476407 1.748607 1.777557 0.002923 1.168562 0.459414 0.726028 1.334565 0.336794 0.265239 1.229568 1.377214 1.004423 0.217551 -0.136043 1.200489 1.384402 -0.079931 0.081188 0.019276 1.744156 0.626585 0.841138 0.011336 1.011543 -0.201792 0.519659 -0.027177 0.781645 0.488491 0.461901 1.247506 1.026927 1.110988 0.955157 1.190158 -0.022946 1.334306 0.056859 1.617327 0.738682 0.955054 1.118735 0.207948 0.830794 0.064198 1.101640 0.956965 0.530340 -0.289707 1.292669 0.768867 1.453283 0.409912 0.925595 0.666844 0.262774 0.747452 0.647702 0.079949 0.891712 1.775582 0.452232 0.319362 -0.031635 1.522910 1.568498 1.146812 1.613187 1.854049 0.710335 1.563147 0.991356 1.276810 0.650177)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
#(114 14.119774267447 #(0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1)
      13.847382931726 #(0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.834372 #(0.000000 0.647458 0.884834 0.789469 0.943620 0.173117 1.642010 0.894797 1.754491 1.144258 -0.711535 0.160582 0.017340 1.100624 -0.197580 0.369836 1.656584 1.791631 1.651184 -0.602759 0.119961 0.874705 0.656157 0.359640 0.574830 1.260369 0.459233 1.017924 1.608773 0.988063 0.465045 0.835669 0.179715 1.570729 -0.023942 0.140483 0.197289 0.144416 -0.253201 1.567238 0.940119 -0.128288 1.286672 1.136577 1.569716 1.560972 0.911410 0.019828 1.433973 1.234941 1.697560 0.670616 1.244947 0.661817 0.409249 1.306353 1.448433 1.124470 0.270331 1.658856 1.739289 1.491354 0.640699 0.788062 1.224290 1.101571 0.348888 1.073887 1.122818 0.071690 0.802717 0.548724 -0.052226 0.478764 1.033813 1.327515 1.366750 1.171242 0.254427 1.327028 0.753435 1.098242 0.215343 0.549749 1.046690 -0.423054 1.501972 0.890944 1.887403 -0.372900 1.766096 1.051649 -0.303656 1.524429 1.454146 0.658552 0.365659 0.771959 1.615529 -0.266420 1.433222 0.058598 1.166187 0.321542 0.107538 1.034250 -0.030507 1.279442 -0.019697 0.408747 0.953491 0.320782 1.267647 -0.178859)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
#(115 15.196797370911 #(0 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0)
      14.359978160099 #(0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

      10.936834 #(0.000000 0.117113 0.418268 1.018284 -0.225295 1.690675 0.321975 0.364232 1.382813 1.684813 0.504425 -0.225693 0.932449 1.141180 0.112526 0.708909 0.367000 1.065298 -0.223996 1.135386 0.113367 0.984366 0.622849 1.170112 1.306611 1.162359 0.098081 1.635576 -0.065859 0.592693 1.346558 0.918818 -0.007975 0.690462 1.402813 0.055781 0.132473 0.479454 0.830774 0.011132 0.319221 0.899674 1.672888 1.557425 1.192330 1.286929 1.354504 1.481715 0.733358 1.494691 0.295194 1.515279 1.412695 0.405048 1.420816 0.024077 0.715176 0.381691 0.228730 0.923073 1.716090 0.341284 -0.069729 0.222796 0.173749 1.098770 1.358532 0.803328 0.192477 0.003841 0.078668 1.702300 -0.026134 1.247187 0.628320 0.580333 0.686856 1.036717 -0.335193 1.120780 0.616407 0.829463 1.468634 0.884023 0.296707 1.693060 0.578179 0.232270 1.031449 0.107766 1.383234 1.257396 0.338524 1.081066 0.820478 1.747208 0.708556 0.776050 0.160627 0.397607 0.046231 0.309141 0.107422 0.706536 0.579733 0.158914 0.837752 1.178852 0.545793 0.347030 -0.192749 1.555557 0.570452 0.304451 0.290891)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
#(116 14.830805621528 #(0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1)
      14.175787507646 #(0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

      10.896008 #(0.000000 0.781375 0.035823 1.129371 0.440955 1.744662 1.461808 0.881245 0.021244 0.672381 1.008692 0.172427 1.355647 1.177432 0.536994 1.305905 0.006992 0.439957 1.389395 1.926374 1.789203 0.986767 1.838494 0.957412 0.245673 0.230888 0.982926 0.372432 0.314299 1.329171 1.152596 1.564133 0.575067 0.217517 0.875229 0.135910 -0.012897 1.264497 -0.471578 1.018353 0.416938 1.160676 0.937643 0.202111 1.171286 -0.365535 1.209921 1.497064 1.745156 0.144706 1.609539 0.072998 1.124418 1.174663 1.384526 1.235404 -0.264021 1.884353 1.638552 0.573307 0.892047 0.260383 1.479205 1.808362 1.364568 0.248416 1.190124 1.003788 1.396471 0.106587 1.285522 0.683664 0.724122 1.033758 1.069165 -0.119963 1.191128 1.049510 0.272284 1.597648 1.832582 1.289507 0.561115 0.890798 1.727166 1.481027 0.907227 0.419500 1.020158 0.330877 0.473096 1.783430 0.008903 0.247030 1.146386 1.288801 1.679260 0.530699 1.289472 -0.126557 1.572558 1.425496 -0.022265 1.334026 -0.376128 -0.390978 0.054397 0.897087 0.929914 0.593144 0.374114 0.498843 0.812897 0.948609 -0.073957 0.265159)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
#(117 14.857519237248 #(0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0)
      14.522986412048 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)
      14.136 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

      10.961158 #(0.000000 1.458583 1.208021 1.566600 -0.019226 1.590111 1.213860 -0.356402 0.030039 0.798920 0.106860 -0.401527 0.348276 1.855779 0.404768 1.166127 1.571209 0.365978 0.435645 1.016790 0.020645 1.281288 1.439875 1.796927 -0.219511 0.853762 1.609541 1.150125 0.895822 1.477092 -0.396206 0.262922 1.625811 0.938533 -0.305607 1.476434 0.241572 0.614333 0.521967 0.128226 0.118780 0.137886 0.081493 1.852749 1.886536 0.265648 1.513034 0.542774 0.146691 1.755490 1.411807 1.302729 1.686132 0.258077 0.899674 0.727503 0.610001 -0.148311 1.607877 0.770464 -0.261098 1.863300 0.096720 1.137760 0.265682 1.315994 0.616464 1.437295 1.055367 0.960027 0.703569 0.853641 1.657730 0.443313 1.628826 1.625440 1.196841 1.208035 1.651584 0.482949 1.774534 1.125636 1.597681 0.856794 0.032199 1.970635 0.351446 1.671319 1.109907 1.099483 0.638728 1.100368 1.320291 1.300883 -0.185228 0.940765 0.050179 -0.004169 0.929296 0.097740 0.732227 1.330802 0.561306 1.560738 0.399521 0.772326 0.685918 1.855697 -0.165801 1.362574 0.635972 0.321182 -0.077478 0.816474 1.354290 0.251899 0.968938)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
#(118 15.151820108516 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0)
      14.496 #(0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1)
      14.207115029287 #(0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

      11.054130 #(0.000000 -0.332133 -0.102618 0.174619 0.228040 0.855938 -0.091421 1.682894 0.370397 1.285303 0.891615 1.847229 0.741604 0.198794 1.092635 0.734048 0.358691 0.595895 1.635045 -0.506931 1.174552 0.225098 0.775549 0.456772 1.736532 1.550627 1.395929 1.189785 0.539674 1.529851 1.775185 -0.044671 0.741003 0.278457 0.331696 0.670482 0.873006 0.272616 0.394572 1.877037 1.415373 1.345011 1.633134 -0.586167 1.049276 -0.174129 1.081495 0.773864 1.412443 0.256538 1.637893 1.145539 1.179434 1.088579 1.435601 0.026556 1.127291 1.062778 0.149201 1.221989 0.870327 0.520691 1.016033 0.613093 -0.174864 1.450251 1.189791 0.133395 1.548916 0.965434 0.972198 0.779978 0.183661 0.858995 1.109065 0.692716 -0.126375 0.975139 1.240874 0.153331 0.847571 1.029318 1.778654 1.633627 1.825491 0.919039 1.640887 1.586866 1.193866 1.620183 0.645421 1.485034 -0.161428 0.332287 -0.263531 0.352435 1.105493 0.934213 1.204803 0.110707 1.367263 0.172973 0.695810 -0.067532 0.764023 0.153359 0.964041 -0.226645 1.885084 0.230907 0.649538 0.752392 0.293046 0.955674 1.644760 0.053926 0.877309 1.109100)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
#(119 15.63721370697 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.803846337507 #(0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1)
      14.502624011553 #(0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      11.118182 #(0.000000 0.665863 0.819922 1.239018 0.429377 1.735824 0.385981 1.289624 0.983332 1.609088 0.931020 0.584076 0.891094 1.655893 1.704522 0.466315 0.210054 0.196477 0.477716 0.335011 1.767931 -0.646341 1.181508 0.227252 -0.307379 0.024090 0.728566 1.146819 -0.267668 1.347521 0.039257 0.040538 0.305394 0.945588 0.329448 0.363201 1.165975 0.344102 1.678900 1.950969 0.914613 0.934036 0.772338 0.967197 -0.053029 0.502890 0.087134 0.631754 1.619663 0.597036 -0.190757 0.512318 -0.114194 1.918714 1.142599 1.668225 1.348744 0.311939 0.155914 1.377427 1.418464 0.194460 0.964545 0.544917 0.851638 0.798084 0.210416 0.527857 1.140699 -0.187998 1.461176 0.789969 0.131336 0.417191 0.501603 1.859184 0.758752 -0.043783 -0.089433 0.268891 1.454141 1.613991 0.121136 0.734815 0.194010 0.243399 0.616336 0.836206 0.130213 0.339309 0.113811 1.068942 0.067583 0.192555 1.773091 0.018037 1.022706 0.770688 0.895236 1.369385 1.204457 0.894849 -0.048521 -0.148711 1.152253 1.754096 1.312370 1.460315 0.496577 0.963956 0.751118 0.177983 1.766830 0.882617 1.048318 0.166253 1.035173 0.970007 1.626140)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
#(120 14.761 #(0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1)
      14.534638752286 #(0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

      11.001260 #(0.000000 1.628418 1.324050 0.627144 0.050994 0.645025 1.321375 0.548161 0.047364 1.754848 0.936834 0.341606 0.087885 1.869975 0.190947 0.720136 1.676135 0.215591 0.294561 1.296455 0.115845 0.540200 -0.345793 -0.178503 0.408279 1.503318 -0.172528 0.283529 -0.389961 1.654959 0.842373 0.979104 1.648915 1.283500 1.378190 0.328945 1.353254 0.131593 0.707429 0.054174 -0.188920 1.275793 -0.022489 1.673958 0.335989 -0.118265 1.440268 1.697279 1.273991 0.593959 1.860765 -0.048466 0.002214 0.698806 1.585570 0.477068 1.134043 0.621624 1.294736 0.725349 0.373726 0.450448 0.097482 0.787316 0.383155 0.289405 0.966014 -0.095773 -0.163332 1.187611 1.192502 0.965390 0.240076 0.727857 1.544436 -0.311110 -0.124155 0.660828 0.124775 1.369479 0.448099 -0.183493 1.346505 1.735715 1.592965 1.214154 0.209427 0.244200 1.563349 0.670422 1.530625 0.629709 0.932140 1.418825 1.040245 0.936049 1.286139 0.003842 -0.191364 0.134545 1.431979 1.125678 1.787562 1.687456 0.274491 0.353238 0.622957 -0.139942 0.037241 0.089733 0.666554 1.049216 1.009497 -0.118209 1.106734 -0.125548 0.063822 -0.196912 0.478842 1.405480)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
#(121 14.765577345045 #(0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0)
      14.619540214539 #(0 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.286643427331 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)
      14.184466362 #(0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      11.242723 #(0.000000 1.051223 1.226654 0.784745 0.342900 0.402994 0.342405 1.273523 1.037878 -0.023459 1.583926 1.245333 0.476411 1.338040 1.382319 0.244668 1.435405 1.284463 0.422727 1.728660 0.969414 0.615501 0.354228 0.745141 0.170442 1.879491 1.621701 0.598763 -0.366936 1.659818 1.246694 1.383952 0.333008 1.436975 1.323954 0.893398 0.368904 0.068309 0.432824 0.773078 1.242831 0.459826 1.049837 1.639776 0.139686 1.757537 1.782306 0.789855 0.513893 1.202725 1.367920 1.594984 0.107005 1.668759 1.377314 0.488228 1.137623 0.181686 -0.213385 1.767634 -0.269985 1.479847 0.320400 0.552651 0.518063 0.148500 0.270384 0.284453 0.340019 0.724815 0.965478 1.238256 0.867518 0.128521 0.865636 0.984628 -0.194290 0.705287 0.105815 1.739411 0.628255 1.950283 1.140789 0.009299 0.954978 1.321679 0.565201 0.902215 1.078996 1.623235 0.746957 -0.104004 0.469254 1.287040 0.942872 1.788593 0.928002 0.631896 1.065172 1.750427 0.915121 1.065384 0.650683 1.927883 0.360788 0.642006 1.318410 0.789311 0.558514 0.870027 1.639546 0.869476 0.226934 0.707660 -0.069226 0.191320 0.073570 0.196202 0.982067 0.248065 0.527334)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
#(122 14.800878258504 #(0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0)
      14.536 #(0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

      11.185266 #(0.000000 1.829696 0.019213 0.812736 1.158542 1.312114 -0.205640 0.380438 1.271260 1.458933 0.626310 1.309053 1.676297 0.167378 1.017949 0.989455 1.589425 1.514191 0.998704 1.423880 1.811097 0.854624 0.376900 1.598432 0.142466 1.280315 0.945690 0.551746 0.995865 1.650233 1.579291 0.606297 0.872652 0.287046 1.292231 0.822944 0.151578 0.381394 1.177090 0.470342 1.232176 0.351215 0.858499 1.571764 0.347510 1.071181 0.256361 1.474693 1.680240 -0.445105 0.567671 1.697184 -0.015883 1.190187 0.548542 0.887560 1.543331 1.880385 1.865690 0.869909 0.425986 -0.062177 1.296197 0.184510 0.444697 0.729908 0.916718 1.117436 1.374430 0.832407 1.349849 1.184262 1.717579 0.184128 1.013025 0.658082 0.431891 0.401342 1.412107 0.437119 1.126560 0.439793 0.095865 0.952763 1.722789 0.565588 1.212482 1.243749 1.625732 1.879096 1.463459 1.192866 1.117169 1.186799 1.105427 0.826581 -0.265285 0.335710 0.003989 0.359311 1.192710 1.836371 1.548892 1.442056 -0.250205 -0.751219 0.275449 0.184303 0.281086 1.735658 1.553852 0.618821 1.675259 0.868894 0.266289 -0.160750 1.626150 -0.484774 0.803695 -0.175707 1.102859 0.940662)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
#(123 15.175 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.041822824398 #(0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1)
      15.006 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.80501968131 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)
      14.67458183944 #(0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.255107 #(0.000000 -0.037655 0.448883 0.789233 1.319818 0.005692 -0.149828 1.207597 0.712558 -0.355824 1.064979 0.136497 0.293518 0.207603 1.205174 1.816526 1.235509 1.209767 0.902291 1.877987 0.104526 0.218897 0.752276 1.268915 0.179725 -0.009489 1.262283 0.942491 0.786129 -0.387124 -0.120044 -0.229889 1.639323 1.041089 1.133744 0.266895 0.531197 1.887026 0.034924 0.589119 1.564512 1.364027 0.775012 -0.255218 1.537246 0.689690 0.895303 0.111225 -0.094698 1.102052 0.867503 1.122796 1.764357 0.005431 1.010895 0.646293 1.810318 0.117484 0.685563 0.339246 -0.062886 1.396307 1.383007 0.037368 1.547717 0.472433 0.077027 0.433642 0.520046 -0.145158 -0.060319 0.234572 1.119244 0.186687 -0.164261 1.762673 1.248953 1.523965 1.301753 1.081280 -0.012460 1.184370 1.820044 -0.045043 1.140720 0.153035 1.304436 0.401747 0.674145 -0.219824 1.756937 0.573231 0.204319 0.597422 0.197584 0.727924 1.787158 1.217823 0.396556 0.270743 1.050905 0.035678 1.044766 1.375741 1.280885 1.528275 0.746349 1.482168 0.874679 0.293462 1.029099 1.780593 0.864215 -0.168132 0.134705 0.856341 1.410623 1.117614 1.231768 1.407192 1.403969 -0.138063 -0.223379)
      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
#(124 15.808239936829 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      15.141 #(0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1)
      14.607 #(0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

      11.315853 #(0.000000 0.157339 1.717168 0.826720 1.019072 0.802473 0.468867 0.370550 1.579840 0.259667 0.176246 0.109817 0.054843 1.067503 1.075875 0.175495 0.444620 0.986131 1.479203 0.762306 0.203368 1.312370 0.183677 1.868931 0.984081 0.452189 1.372539 0.685862 1.436642 -0.579918 1.664641 0.747790 0.475493 0.386782 0.194231 1.369923 -0.343163 1.124550 1.100356 1.365540 0.524339 0.649561 0.410936 0.227784 0.714047 0.820935 0.526212 0.372587 1.427253 0.313532 1.453966 1.243676 0.941124 -0.144852 0.926753 1.747844 0.041044 0.183089 0.466059 0.713564 1.500331 0.849273 1.730209 1.311275 0.026721 0.178809 -0.201529 1.391341 0.008121 1.690506 0.759580 1.102019 -0.106094 0.826047 1.152807 0.539480 1.242705 0.358399 0.667632 -0.389834 1.443769 1.595530 1.316491 0.577146 1.315268 1.856790 -0.458504 -0.457329 0.623727 1.633793 1.714300 0.888713 1.101645 1.937736 0.505158 -0.233308 0.925295 0.485153 1.279018 1.527294 0.342685 0.735580 0.564654 1.225084 -0.157627 0.231800 0.145929 1.631693 0.495942 0.105911 -0.291031 0.974468 0.567311 0.282459 0.796426 1.418218 0.671441 0.753158 0.883837 1.205463 0.693335 1.239960 0.524797 0.548632)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
#(125 15.546414800183 #(0 0 0 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0)
      14.985 #(0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      11.420352 #(0.000000 1.199592 1.290707 1.486482 0.506978 0.021468 0.650471 0.293588 0.374684 1.092360 1.152957 0.050447 1.489460 0.985245 1.675162 0.956229 1.793109 1.595752 1.684060 0.539517 -0.652254 0.699376 -0.110672 0.889753 0.126441 1.753976 0.194648 1.702302 0.008897 -0.016843 0.389746 0.143448 0.189930 0.310330 0.047562 1.264052 -0.206601 1.438503 1.005154 1.685831 -0.148743 0.824557 0.010612 1.871249 1.741299 0.307006 0.325265 1.424075 0.969293 1.213102 1.542277 1.480431 1.605831 1.173792 0.786110 0.908626 0.027583 0.491596 1.166538 0.417870 -0.458450 0.143903 0.303113 0.064208 1.176182 0.783632 0.853278 0.526847 1.021178 1.274967 1.376727 0.778518 0.372244 1.394301 0.884311 0.003856 1.230298 1.422039 1.588466 0.463395 0.873535 1.094678 -0.043721 0.439165 -0.209719 1.156594 0.083532 1.388328 1.895887 1.023057 1.289266 1.830753 0.411128 0.479855 -0.547531 0.936661 0.847288 1.772796 0.279231 1.053738 1.093826 0.944025 0.074198 0.224206 0.453485 1.738309 -0.020668 1.175484 1.748459 0.720764 1.381752 0.519698 -0.141202 1.491217 0.989817 0.134561 0.557768 1.049790 1.241394 0.908287 1.553249 1.932765 1.303490 0.740673 0.800440)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.2250
#(126 15.477880483871 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.898634217167 #(0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1)
      14.722991453869 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)
      14.67419786533 #(0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.311282 #(0.000000 0.807783 0.314068 1.245640 0.816518 0.985544 1.697308 1.794955 1.896523 0.794408 -0.053318 1.758710 0.352820 0.761778 -0.214960 0.081716 0.944465 0.988008 1.233505 0.487699 1.498470 0.629898 0.773117 0.148649 0.537318 0.997188 0.799158 0.091763 -0.005723 0.024563 0.476460 1.734278 1.260407 1.095807 0.945211 0.922545 0.643602 0.465981 1.247392 1.046263 0.162092 0.691696 0.503144 1.135351 0.918905 0.730614 1.344530 1.127789 0.134882 1.211483 0.563406 0.304171 0.910673 0.139123 0.344415 1.499807 1.515192 1.193821 1.007174 0.604564 1.270157 1.046122 1.220894 0.667491 1.747035 1.236878 1.298399 1.423120 0.226372 0.450960 0.411551 0.557487 1.784232 0.076839 0.915405 0.099943 -0.080836 0.343468 0.849596 0.063454 0.508535 0.763261 0.228612 0.532288 1.382686 1.695523 0.446483 0.133803 1.201137 1.104488 -0.090571 1.779232 1.780339 0.261698 0.959162 1.555363 0.955114 1.667262 1.476692 -0.580889 0.301007 1.837531 0.449560 -0.214256 0.971832 1.107159 0.687844 0.088666 0.943917 0.243851 1.480674 0.269259 1.263523 -0.019614 0.714099 1.216548 0.021555 1.741076 0.719849 0.763679 1.028153 0.466827 -0.090363 0.104097 1.163451 0.814638)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.2694
#(127 15.59486896452 #(0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0)
      14.859080656941 #(0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0)
      14.851 #(0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      11.457936 #(0.000000 0.853237 1.232359 0.255318 1.201026 0.274096 1.740213 0.119358 1.334801 1.226706 0.004055 1.872732 1.516753 1.587398 1.081393 -0.355730 0.139160 1.532223 0.224275 1.677360 1.224952 1.568774 1.240374 0.486048 0.542055 0.187174 0.394113 -0.106267 0.124381 1.180866 0.158879 0.613316 0.074367 1.212290 0.233117 1.782739 0.777502 -0.105694 0.567312 1.164314 0.067357 0.692590 1.854104 1.402452 0.639727 0.749724 0.260594 1.788960 0.887315 1.326313 0.917455 0.165986 0.864267 1.790545 1.010700 1.750799 0.270480 0.505983 0.497477 1.347130 1.200755 1.199819 0.175577 0.229919 1.886410 0.948629 1.757151 -0.083413 -0.366919 0.805953 0.584350 1.390219 0.325378 0.573549 0.608007 0.466714 0.095984 0.011137 0.939287 -0.022555 0.165302 1.696704 1.682010 -0.050885 0.200252 0.358757 0.318105 0.943232 0.690443 1.083408 1.060737 1.327715 -0.130623 0.184266 0.735674 1.790990 1.680652 1.614877 1.286203 0.341164 -0.064309 1.521035 0.586395 -0.006112 1.374584 0.661567 1.651078 0.173970 0.507091 1.055672 1.823127 0.506737 0.875884 1.384750 1.405187 1.648362 0.664422 0.560251 -0.103622 0.064112 0.147238 1.606886 0.399651 1.383159 1.514052 0.363128 1.636473)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.3137
#(128 15.689241428851 #(0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1)
      15.287684641887 #(0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1)
      15.249417304993 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1)
      15.138 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.573528 #(0.000000 1.358622 0.052815 1.525342 1.078254 1.277467 0.851644 0.993773 0.270527 0.666892 0.214715 0.561881 1.486305 0.897301 0.663907 1.464915 1.458940 0.073985 0.227716 0.240977 -0.118121 -0.240614 1.129165 0.562949 0.104761 1.512942 1.850497 -0.150893 1.132547 1.479629 0.454176 1.177070 1.243333 0.052388 0.587923 1.838013 0.100181 0.948655 0.323787 0.826841 0.229639 0.441532 1.219126 0.983808 0.782016 0.761902 0.566556 1.268485 0.018509 0.263246 -0.384569 1.394812 1.372861 0.446364 1.200217 1.335900 0.036123 0.561092 -0.095607 0.396696 0.119690 -0.125962 0.586149 0.613171 1.411972 1.000998 1.395219 1.079869 1.383076 0.460730 1.650881 -0.061949 1.452576 1.251142 0.849189 0.416834 1.306581 1.183581 0.090160 1.263584 1.323055 1.014591 0.198802 0.170910 0.985123 1.132470 0.684690 -0.159944 0.394404 0.148159 0.775584 0.814835 1.415542 1.113548 1.363351 0.271326 0.750728 0.663523 1.188110 0.784207 0.491110 0.586774 0.532456 0.358822 1.296022 0.846135 0.234995 1.116767 -0.154526 1.037932 0.290091 1.320389 0.871439 1.212979 1.564010 0.656220 1.789912 0.666737 1.027019 0.134831 0.399150 0.881457 1.220367 1.794516 -0.015901 1.390136 0.114371 1.152434)
      )

;;; 256 all --------------------------------------------------------------------------------
#(256 23.353 #(0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

      19.419887 #(0.000000 1.716123 1.732087 -1.159217 -1.111520 -0.968808 -1.435400 -0.980823 -1.916807 -0.777076 -0.006575 -1.146768 -1.413466 -0.191988 -0.866295 -1.754753 -1.834771 -1.414461 -0.004612 -0.668272 -0.899105 -1.045292 -1.394965 0.031304 -1.790029 -0.414595 -0.628926 -0.793341 -0.055059 -1.758819 -1.799745 -0.999573 0.034849 -0.438143 -0.082246 -1.718822 -1.067223 -1.726228 -1.738785 -0.419090 -0.072253 -0.101418 -0.158940 -0.227475 -0.805306 0.102396 -1.029779 -0.944501 -1.627544 -0.240643 -0.800061 -1.852822 -0.736694 -0.374906 -0.992797 -1.321129 -1.165724 -0.132383 -0.296684 0.074652 -0.170663 -1.021946 -0.249235 -0.014896 -1.684156 -0.101483 -1.472567 -1.065248 -0.193000 -1.821851 -1.577478 -0.971415 -1.706313 -0.460547 -0.802154 -1.066096 -0.465880 -1.780964 -0.317180 -1.128696 -1.243327 -1.545720 -0.981842 -1.941220 -1.430454 -0.739300 -0.401708 -0.807818 -0.139664 -1.670340 -0.370514 -0.908540 -1.051026 -0.655448 -0.201175 -1.447197 -1.020563 -0.461820 -0.563775 -0.492581 -1.123348 -0.019694 -0.284015 -0.493247 -1.800533 -0.026879 -1.684265 -0.072889 -1.236206 -1.605481 -0.854278 -0.780460 -1.556451 -0.100281 -1.481863 -1.785235 -0.054386 -1.322733 -1.272196 -0.484418 -0.487202 -0.934744 -0.351935 0.001840 -1.361830 -1.761915 -0.791484 -1.765946 -0.130275 -0.078233 -1.712033 -1.491273 -1.447810 -1.802668 -1.915196 -0.812291 0.020535 -0.059922 -0.115027 -1.741334 -1.716313 -0.574287 -1.796141 -1.411787 -0.352083 -0.219272 -0.492707 -1.281724 -0.237492 -0.661764 -0.251830 -1.447982 -0.928988 -0.834556 -1.105051 -1.600594 -0.610828 -0.521753 -1.538844 -1.739439 -0.438630 0.200255 -1.495825 -0.208613 -1.899242 -0.565203 -0.701498 -0.013982 -0.268393 -0.851043 -1.316608 -1.311782 -1.571398 -0.868046 -0.450718 -1.523921 -1.175122 -1.013090 -0.336313 -0.297343 -0.710311 -0.121169 -0.855768 -0.583293 -1.278840 -1.685639 -0.237176 -1.113655 -0.038017 -0.925030 -0.002618 -1.084014 -0.914850 -1.109784 -1.951680 -0.258074 -1.242904 -1.747165 -1.546773 -0.010135 -0.293716 -0.365165 -0.380179 -1.009365 -0.199175 -0.107143 -0.355342 0.056494 -1.740548 -0.797850 -1.195468 -1.012191 -0.519448 -1.741712 -1.728278 -1.202843 -0.439103 0.018019 -0.505945 -0.712019 -0.888461 -0.466715 -1.884487 -1.110926 -1.377129 -1.412918 -0.283507 -1.736733 -0.423668 -1.180448 -0.750304 -0.826461 -0.252142 -0.607448 -0.795197 -1.729275 -1.937314 -1.775060 0.018302 -1.136763 0.041039 -1.517119 -0.102466 -0.808497 -0.452532 -1.777418 -1.448279 -0.170123 -0.689274 -1.668514 -0.718568 -1.461386 -0.741628 -0.144206 -0.275574 0.275344)
      )

;;; 512 all --------------------------------------------------------------------------------
#(512 34.212551772691 #(0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      31.391244 #(0.000000 0.536490 0.982156 1.426326 -0.129626 1.732808 0.654778 -0.037467 0.717993 0.534761 1.425863 1.198865 1.682980 1.546213 -0.071047 1.401448 0.937782 0.982596 0.016895 0.072103 0.569596 0.486124 -0.097286 1.158349 0.918371 1.039216 -0.251432 0.819547 0.575793 0.544080 0.369375 -0.184848 0.368901 0.803569 1.569591 0.698176 0.192969 0.724313 0.149571 1.805778 1.481586 1.290110 0.699094 1.248324 0.394364 0.244421 1.636448 0.053830 1.021639 0.391890 0.621807 0.669918 0.722984 1.661047 -0.053982 1.184501 1.452118 -0.038748 0.079581 -0.157031 0.040992 1.236847 1.450072 0.167693 1.624681 -0.088284 1.086971 0.793397 0.916304 0.324493 0.532068 0.802293 0.153202 1.762480 0.101252 1.207328 -0.129231 0.230528 1.030310 1.154258 1.508591 0.616033 0.882311 1.661175 1.953694 1.099650 0.966354 0.501383 1.007682 0.222557 1.610959 1.720178 1.247885 0.606186 0.834708 1.558361 -0.017869 1.310156 1.008083 0.659261 0.131563 1.937703 0.412195 0.236592 1.603060 1.101767 0.827617 0.591143 0.816380 1.263921 0.148742 0.104597 0.053092 1.950756 0.641813 0.585000 1.924936 1.150271 1.393796 1.729921 0.941614 1.154412 0.016709 0.693894 0.725621 1.812021 0.151548 0.913871 1.847999 1.447775 0.154900 1.383798 1.268622 1.684293 0.167755 0.064703 1.097955 1.093726 0.462700 1.179880 -0.028079 1.477485 1.219357 0.751030 -0.060337 1.210332 0.214512 -0.561537 0.631221 0.866225 0.505200 1.649399 0.763462 -0.177460 -0.124321 0.301932 1.215601 1.531126 1.037628 1.084693 0.882199 1.071766 -0.102511 1.933157 0.994409 1.327775 0.857160 0.274823 0.564669 -0.099448 1.183881 1.389926 0.212160 0.718775 0.317581 0.924967 0.405513 1.649930 1.527277 0.183790 1.201712 0.469506 -0.155659 0.854295 0.612216 0.966494 0.705453 0.102052 0.675180 1.609733 0.239829 1.243022 1.279694 0.667433 0.574003 0.556613 0.553333 0.600770 0.751871 0.860635 1.492204 1.208264 1.697379 1.870484 0.648885 0.791931 0.713354 1.230332 0.984751 0.006536 1.150837 1.690631 -0.027051 0.380760 1.276448 0.938348 0.619960 1.881157 0.864399 0.721671 0.604021 0.280855 1.903049 1.689084 0.993376 0.147486 0.728308 1.043826 -0.093977 0.201345 0.211713 0.591694 1.563665 0.629162 0.028541 1.220537 0.848678 1.673148 1.269501 1.423564 1.256969 0.563220 1.571156 1.255956 0.182322 0.799277 0.912648 0.801445 0.560308 0.589828 0.497125 0.933069 0.424475 0.705311 1.598444 -0.187983 0.441238 0.761108 -0.025473 1.486361 1.415485 -0.420955 -0.301161 0.451074 1.599095 0.958690 0.764750 1.826910 0.763259 1.565082 0.482133 0.634148 0.689109 0.870842 0.258187 1.307766 -0.061122 1.322321 0.737932 1.331468 0.501857 1.012652 0.853045 1.281963 0.626236 1.018208 0.355320 1.778787 -0.216416 0.289103 1.466104 0.834557 1.495024 1.347843 0.915718 0.019062 0.109237 0.935987 0.642501 1.116001 0.102778 1.044616 0.401839 0.000557 1.388259 1.103344 0.236147 1.095986 1.490085 0.811184 1.620642 0.447193 -0.162667 0.472053 0.254521 -0.249527 1.201426 0.405149 1.876543 0.266187 0.130139 1.907565 0.661173 1.806986 1.714549 -0.045649 0.161300 1.867579 0.410807 0.692661 0.164446 1.373170 0.784111 1.624643 1.842397 0.851982 0.372586 -0.153180 0.163399 0.937623 1.029810 0.577761 1.885373 0.257007 1.919724 0.221390 0.992752 0.799199 0.726916 0.499383 0.847904 1.435092 1.516436 1.415791 0.718336 0.775042 0.214479 0.693437 1.416323 0.376686 -0.088726 1.305444 0.236013 1.760923 0.882461 0.966026 -0.039945 1.586889 0.146351 1.058484 -0.153465 0.874027 1.562558 0.221053 0.700956 0.490493 0.224584 0.721736 0.907632 1.824769 1.463914 1.787340 0.284520 0.447051 0.015084 0.421417 0.946031 1.985021 0.625260 1.706503 0.181495 0.118414 1.205197 1.823047 1.191165 1.046795 1.286118 -0.026177 0.916951 1.695990 1.490318 1.309732 1.464060 1.688925 0.463066 0.812221 1.691121 0.060699 1.771571 0.651609 0.701067 0.994197 1.863648 1.878055 0.461586 1.225301 1.689333 0.585832 0.163978 -0.087727 0.814512 1.996254 0.412873 -0.094955 0.264337 0.270751 1.142549 -0.024966 0.070370 0.161447 0.009507 0.773710 1.826772 0.919015 0.469842 1.605350 0.130163 0.372875 0.706787 0.275237 -0.485192 0.934255 0.076963 1.578025 1.319281 -0.268275 1.006626 1.518212 0.244270 0.393465 0.362653 0.762951 0.101773 0.641925 -0.044830 -0.086144 0.912315 0.865131 0.751696 0.355646 1.669420 0.959146 1.402229 0.790946 1.375834 1.946560 0.829893 1.038967 0.415598 0.605293 0.953370 1.545858 0.816660 0.535574 0.545621 1.444071 1.427861 0.317581 1.324961 0.709073 0.233889 1.997939 0.837353 0.714659 0.502688 1.282277 0.578831 -0.367027 0.456635 0.005356 0.566115 1.015260 0.456787 1.559690 0.821948 0.873735 -0.125757 1.347975 1.234391 0.394165 1.313322 1.674955 1.957471 0.199796 -0.216128 1.145281 0.020796 -0.033417 1.546313 0.684777 0.721518 1.014713)
      )

;;; 1024 all --------------------------------------------------------------------------------
#(1024 54.490282136658 #(0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       49.867216 #(0.000000 0.327463 1.836047 0.835169 1.252076 1.674070 0.220548 1.042475 1.509095 1.579464 0.895304 1.247426 1.151972 1.490500 0.157542 1.123668 0.047756 0.787232 0.294584 1.733356 0.107736 1.156565 0.757337 0.396950 1.528176 1.246645 0.358019 1.104207 0.205112 -0.175155 1.961979 0.116865 1.705056 1.224069 1.280180 1.615850 -0.006555 1.362186 1.094292 -0.132951 0.689557 -0.034245 1.478824 0.731044 0.924965 0.400017 0.459628 0.386074 -0.101383 1.148365 0.704241 0.744738 -0.052844 0.067315 0.369521 0.758466 1.902583 1.899586 1.598319 1.737623 1.540374 1.696560 1.697499 0.487205 1.085963 1.880631 1.477181 1.668863 0.024424 1.517648 0.365516 0.200991 1.320714 0.186157 0.388617 1.467282 1.382441 0.897334 0.626981 0.319121 1.447908 0.616025 1.804381 1.745575 1.813291 0.789135 0.051659 1.904341 0.503423 1.476255 0.310011 0.604315 1.774089 1.349431 0.552058 0.129885 0.768054 -0.042991 0.438904 1.716492 1.079908 0.082240 1.637563 1.782814 1.167399 1.555367 1.493576 1.678716 -0.108181 1.820002 0.874064 1.607670 0.305117 1.407464 1.406799 0.699493 1.582569 1.388350 0.152096 1.215999 0.220403 0.345901 0.015759 0.103791 1.475118 1.377921 1.679643 0.718421 0.305952 1.129388 0.650190 1.214505 0.313791 1.900895 -0.280859 0.827104 0.966094 0.952334 0.465933 0.582045 1.202693 0.486327 0.130731 1.189722 1.845737 0.943304 1.846468 0.736959 0.494820 0.406920 0.444435 1.414861 1.519794 0.691958 1.296671 0.239996 1.370349 1.087196 0.317189 1.730290 0.211314 0.381111 1.011776 0.833783 0.304407 0.204684 0.592149 1.184369 1.190663 0.322231 1.702889 0.256307 1.071017 0.840867 -0.242520 0.479950 0.584840 -0.105808 1.448894 0.833770 1.887925 0.447183 0.314914 0.590005 0.817397 1.520556 1.737874 0.323699 0.068906 0.069837 1.455903 1.768167 1.147201 1.651376 0.903538 0.404965 0.830838 1.574402 1.302241 0.460573 0.902816 1.351294 1.845320 -0.081248 0.117244 1.311180 1.295830 0.026240 1.722593 0.293615 0.016937 -0.020631 1.563094 0.366968 0.499012 0.343554 0.941646 1.842772 0.263412 0.928044 0.666097 0.965699 0.095392 0.386295 0.685342 1.098466 0.314857 0.096187 1.378947 1.725601 1.638174 1.066852 0.324141 0.309496 0.903826 1.884009 0.246373 1.446212 0.826576 0.056908 0.590948 1.115228 0.881198 1.458300 0.734711 1.242163 1.780534 0.853455 1.667872 0.196825 1.537188 1.607676 1.937251 1.074072 1.633616 0.370489 0.008710 0.036175 1.429420 1.071794 1.840602 1.451692 1.243956 1.431107 0.691835 0.914980 1.199410 0.181293 1.253487 1.088758 1.075474 0.108051 -0.045571 0.503001 0.028741 1.519924 0.162181 0.231314 1.014758 0.853208 1.665684 1.803304 1.068408 1.146822 1.117985 0.847058 0.807390 1.300311 0.358831 -0.176058 1.632353 0.793462 1.223895 1.408096 0.574718 1.116086 1.528188 1.863540 0.148438 1.178815 1.094527 1.806614 -0.012374 0.398182 0.065034 0.201600 1.678653 1.635712 1.101239 1.677879 1.376663 0.893127 0.765563 1.312772 0.394500 0.623281 1.386574 1.609733 1.397744 0.447440 0.193906 0.667070 1.098978 1.496626 1.415310 0.148141 0.472594 0.260368 0.383833 1.628233 0.220327 0.047597 1.174267 1.122635 0.357754 1.987414 0.602071 0.303888 1.036218 0.431162 1.929514 1.164116 1.448233 0.387663 1.542441 0.132675 1.507592 0.773415 1.237768 1.176487 0.709116 1.107050 1.826342 1.282624 0.165318 1.688758 1.353368 1.369182 0.103481 0.492312 0.148528 0.820568 0.043996 1.646622 0.840124 0.753421 0.628590 0.827439 0.938395 1.158874 1.692810 0.816126 1.584484 0.133035 0.633441 1.856698 0.223451 1.094007 1.265750 1.192640 0.395952 1.640962 1.917364 1.688116 1.442386 0.211922 0.568924 0.069021 0.337714 0.057686 1.444757 0.805875 1.387495 1.241537 1.258564 -0.138313 0.232318 1.082810 0.919288 0.672564 0.858948 1.226057 0.513353 0.916746 0.480683 0.371996 1.820855 1.467856 -0.009218 -0.283047 -0.004140 0.307827 1.551706 1.336385 0.311540 -0.227376 1.460075 1.374821 1.644972 0.942584 -0.008731 1.230541 -0.050886 0.756145 1.492824 0.234443 1.038831 0.415396 0.259582 0.094433 1.743809 1.773181 1.193767 1.144637 1.107278 1.073467 0.192765 1.121611 1.358143 0.256730 -0.001826 0.319586 0.785692 0.371007 0.790865 0.733080 1.010016 0.365066 -0.098482 0.630804 0.165791 1.416869 0.881841 1.014309 0.992919 0.234901 1.418323 1.609100 1.112565 1.226695 1.306198 -0.096032 1.659930 1.253925 1.468504 1.649207 0.667054 0.642219 0.816619 1.780578 1.068621 1.659145 0.823854 0.791623 0.343295 1.504822 1.385473 1.019994 1.644651 0.766151 1.645632 0.537825 0.398247 1.293204 0.059160 0.178873 1.447287 0.527125 0.387974 0.131115 0.312785 1.604447 1.506949 1.620066 1.861402 0.145250 0.285949 -0.076877 1.710147 1.391166 0.304424 1.033493 1.242586 0.544670 1.096730 0.523155 -0.189246 1.481005 1.033398 0.768935 0.023972 1.612024 1.483055 0.518798 0.299824 0.004960 0.939759 0.174131 0.190042 1.122756 0.636602 1.584671 0.313933 1.551720 0.904685 -0.060326 0.005540 -0.025426 1.183830 1.574816 0.451159 0.567990 0.636937 1.946081 0.103934 1.024172 0.668272 0.598832 0.942076 0.803712 0.025316 0.279283 0.860683 1.108376 0.495592 -0.216459 0.511102 0.839492 0.325629 0.423941 0.964281 1.869174 1.376322 0.695771 0.307933 0.728584 0.258248 1.021908 0.522105 1.443610 0.699209 1.445438 0.129220 0.656902 0.367233 1.583887 1.284330 0.304291 1.225496 0.476577 -0.012778 1.769867 1.304421 1.416331 1.394685 1.657958 0.575537 1.154454 1.482178 0.502570 1.130768 0.623558 1.451860 1.828731 1.028878 -0.009475 0.876872 0.279098 0.766784 1.311330 0.735794 0.541035 1.842543 0.936643 1.574537 1.396428 1.299258 0.148915 0.106232 1.382409 0.363703 1.437792 0.458828 0.697511 0.377860 0.415873 0.707742 0.076333 0.899058 1.164566 0.519739 1.494067 0.722474 0.267706 0.170213 0.062507 1.608638 1.572808 0.586666 0.770343 0.501734 1.095273 0.909347 1.158611 1.763224 0.928306 1.155477 -0.094050 1.234292 1.636569 0.857401 1.601954 1.562867 0.898006 0.745695 1.244420 1.045502 0.037133 1.054100 0.435628 -0.045614 1.310834 1.323179 1.515436 0.396760 1.549668 0.626053 0.262609 1.128936 -0.206617 0.519603 -0.070276 0.368711 0.384606 -0.046953 0.004776 1.132741 0.208440 1.125384 0.279383 0.206414 1.581812 0.366788 1.631341 0.047828 0.984452 0.695910 0.001831 0.818618 -0.063551 1.509031 1.770858 1.145267 0.218736 0.163266 0.304181 0.524463 -0.107417 0.636073 0.319627 0.873046 1.806848 0.905657 1.431126 1.307693 0.411432 1.050612 0.383394 0.297520 1.470377 1.512342 1.119568 -0.164563 1.409877 1.369612 0.893616 0.187194 1.160112 -0.426584 1.472282 1.524100 0.642913 0.291994 1.439671 0.405710 0.699882 0.685768 1.837220 -0.135020 0.618382 1.538502 1.936925 1.869902 1.304847 1.204678 1.245764 0.849343 0.077370 1.376208 0.128986 0.683191 1.168443 0.773303 0.918277 0.361282 1.325992 0.182420 0.557109 0.856130 0.916468 1.073525 -0.056735 0.457839 1.415303 1.493321 0.837421 1.245510 0.324402 1.072023 1.495966 0.779674 1.792871 0.438686 1.400304 -0.029656 0.771387 1.191604 0.497478 0.949389 0.583656 1.568371 0.818618 0.376624 1.922430 1.597926 1.106025 1.349123 1.097987 1.226814 0.449548 0.978715 1.149809 0.090419 1.181951 0.196841 0.169854 1.157525 0.672195 -0.013396 1.381930 0.763467 1.101984 1.081354 1.745447 0.052582 0.434851 0.710038 0.252432 1.547955 1.291922 0.243233 0.084185 1.718412 0.754270 1.712834 -0.113817 -0.185231 0.645607 0.602242 0.698745 1.484932 0.708616 0.806637 1.321352 0.822224 0.486883 0.890968 0.415997 0.868384 0.439809 0.369575 0.155202 0.890177 0.736148 1.282829 0.496635 0.179507 0.581791 0.861737 1.329786 0.952408 1.311372 0.616676 1.793129 0.198151 0.583196 0.014657 0.736984 0.943676 1.304757 0.104216 1.131163 0.886646 1.431121 0.607723 1.834661 0.350032 1.233992 0.553257 1.415608 1.339899 -0.021117 1.320488 0.646222 1.478825 0.253185 1.344375 0.782507 0.242220 1.348393 1.611945 1.891346 0.403449 0.420262 1.560522 0.492852 1.786347 0.954743 0.927910 1.007730 0.966809 1.183914 0.132915 0.235582 1.182222 0.510621 0.119231 1.400333 1.559546 0.434169 0.106340 1.159731 1.145452 1.403938 0.593410 0.423464 1.214964 0.097415 0.659427 1.330465 0.265373 0.978681 -0.241303 1.410817 0.374681 0.982607 0.620477 1.028389 1.023993 0.703520 1.277773 0.757705 1.040223 0.694910 0.158208 1.192658 1.103184 1.154745 0.138529 0.659537 1.567368 0.955008 -0.008595 1.044148 0.615600 0.596413 1.600428 -0.130936 0.209722 0.597264 0.214794 0.424799 0.791647 0.212593 1.490120 0.029575 0.222065 1.056546 0.514551 1.117830 0.080900 0.698795 0.825148 0.128150 -1.946314 1.296496 1.764967 -0.109275 0.619906 1.046853 -0.050885 1.414055 0.243491 0.805047 0.478126 0.210018 0.383272 1.147815 -0.142393 0.254600 0.974724 1.253165 0.759822 0.390277 1.900341 0.600527 0.913172 1.508819 0.838474 0.842307 0.052699 0.015556 0.443439 0.953984 0.747720 -0.054054 0.972040 -0.241904 1.438074 0.685282 0.673901 0.604914 0.601935 0.592279 0.658902 1.125537 0.853760 1.677094 1.268821 0.909583 0.771236 0.955089 1.189800 0.847715 0.318412 1.928436 1.740119 0.412900 1.589818 1.013917 1.215481 -0.014813 1.247880 0.223321 0.897915 0.951870 0.304753 1.763894 1.166419 1.525081 1.491253 1.646299 0.047929 0.453022 0.624295 -0.345040 0.250292 1.322349 1.263984 0.481892 1.819190 1.498516 0.274084 0.915689 1.490261 0.159303 1.347132 1.407289 -0.117297 1.828899 1.616281 0.092870 0.390260 -0.086407 1.668212 0.707778 -0.125709 -0.068702 -0.008020 1.483304 1.668166 0.205490 0.775194 1.173496 1.068329 -0.181766 1.426966 1.728307 1.644513 0.798234 0.762223 -0.195164 0.527024 1.036420)
       )

;;; 2048 all --------------------------------------------------------------------------------
#(2048 89.570060996356 #(0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       77.350213 #(0.000000 0.555539 0.501262 1.044749 0.287771 1.412682 1.651595 0.929560 0.549846 1.324740 1.935869 1.135478 1.476903 0.201893 1.072368 1.469797 1.856304 1.710124 0.155645 1.734478 1.438672 1.662318 0.369149 1.305539 1.380565 0.760274 1.791213 0.758033 1.460302 0.314773 1.273350 1.445081 1.922068 1.981608 0.787530 0.220848 0.749937 0.852506 1.079197 1.596357 0.533643 1.661423 1.309207 0.570204 0.799186 0.806331 0.147029 1.886462 -0.011055 1.620080 0.764653 1.039822 1.399443 0.540383 1.263941 1.520079 0.955253 1.475051 0.569591 1.021593 1.696488 1.384568 0.888621 1.246065 0.141108 1.760633 0.530062 0.078663 -0.052280 1.231263 1.886752 1.022966 0.731660 1.519866 0.815188 1.842595 0.428998 0.982542 0.268300 0.449940 0.825066 0.093779 1.541877 1.530942 -0.044025 1.404789 1.172967 1.495494 0.986869 1.354411 0.977699 1.323218 0.290527 0.642299 1.141685 0.305403 0.116047 1.498648 0.363158 1.133291 1.021968 1.050915 0.004007 0.316776 -0.008246 1.753451 1.448398 0.727763 0.491974 0.467132 0.349093 0.846144 -0.057302 0.451593 -0.185527 0.954499 -0.017687 1.738336 1.132264 1.277860 1.255149 0.644067 1.787009 0.975542 0.787661 1.834522 0.750059 0.165831 1.781394 0.656243 0.189155 0.885417 1.864367 1.861898 0.835353 1.925872 0.784282 0.149366 0.389909 1.891355 0.667211 1.629093 -0.156731 0.686377 -0.046381 1.379719 0.174257 1.815414 1.782186 1.460458 1.225364 0.215276 0.433813 0.778669 0.770455 0.591200 1.467950 1.402450 1.237374 1.213320 1.107618 1.577857 0.153528 1.496479 1.690453 0.757018 1.164466 1.863222 1.556344 0.411893 0.045128 -0.148474 0.690145 1.255681 1.262642 1.053606 0.652441 1.807011 1.212250 1.298870 1.843582 0.679071 1.071529 1.212117 0.457856 0.037265 0.056807 0.289533 1.340623 0.191271 0.023689 0.079151 1.691347 0.427278 0.798824 0.971986 0.219384 1.510317 1.755539 0.020056 -0.108987 1.920829 0.654279 1.269937 0.625973 1.626210 1.557939 0.060795 1.054050 0.688441 1.815486 1.547017 1.227524 0.184287 0.725676 1.529612 0.145770 1.961037 0.740800 1.404065 0.938756 0.807687 1.820918 0.792546 -0.054241 0.457527 1.314210 1.386331 1.330133 1.364743 0.425434 0.805132 0.601427 1.151039 0.181880 0.588421 1.746772 0.525817 -0.062391 0.174995 -0.229241 1.865325 0.777080 0.576100 1.157737 1.173633 1.108300 0.620180 0.679835 1.829428 1.415691 1.510131 0.278064 0.869124 1.774022 1.810644 -0.249575 -0.122332 0.003232 1.632364 1.298768 0.233819 0.326577 0.745415 0.803076 1.768981 0.251203 0.915819 1.691281 0.742817 0.546973 0.218234 1.629248 1.253580 1.354290 0.528862 1.813762 0.263825 0.781654 1.287354 0.093701 0.698575 0.887912 1.137370 1.529613 1.518332 0.469199 1.225525 0.065649 0.280063 0.033222 0.909971 0.563943 1.914227 -0.065120 1.804400 0.103014 0.719986 1.951068 0.757568 0.217891 0.598460 1.177422 0.353950 1.684496 1.079766 1.303468 0.083664 -0.101540 0.424187 1.703711 0.337732 0.080405 0.592311 1.778334 1.635999 0.889894 1.617811 -0.035024 0.001647 0.924071 0.404662 1.353001 0.748591 1.771296 1.263408 -0.089484 0.221854 0.796659 -0.134496 0.228028 -0.006122 0.001128 1.259921 0.408335 1.472770 1.057188 1.208943 0.859616 0.951961 0.715820 0.286498 1.182115 0.918625 1.616017 1.001494 1.156487 0.467273 0.762620 1.416134 1.041549 1.777524 1.975901 1.424345 1.013724 1.528658 0.546749 1.515054 0.722119 1.165674 -0.188903 1.095713 0.017814 1.713209 0.808498 0.510307 0.811778 0.118225 0.831248 -0.024877 0.111979 0.001521 0.995340 -0.029678 0.290675 0.273513 0.805748 0.398880 0.215141 1.450122 1.736611 1.571552 1.456815 1.117397 1.312031 1.124964 0.952301 0.371672 1.874636 1.681841 0.351506 1.462640 0.011383 0.220945 0.998689 1.953549 -0.140064 0.559134 1.277572 1.812283 0.159287 1.701742 0.028876 0.066961 1.832832 1.596575 1.021889 0.172947 -0.123165 1.617572 0.738832 0.135822 0.899103 0.675147 0.590566 1.141705 0.619940 1.835079 1.810902 0.002593 0.085103 0.459750 1.324431 0.679980 1.499886 1.342828 0.113834 0.419635 0.474996 1.341851 0.784830 0.644960 1.049676 0.463071 -0.083825 0.357307 1.521176 1.668760 1.414541 0.331217 0.933878 0.750349 -0.094259 1.512555 0.057719 1.957253 1.855659 0.525060 0.191371 0.086135 0.778769 1.177665 1.138710 0.469141 0.550747 1.927353 0.597089 0.788555 -0.049972 0.972408 0.774953 0.590333 0.590142 1.188901 0.464196 0.937929 0.701475 1.283776 1.839285 0.195083 1.905586 1.378602 0.369590 0.773647 1.495702 1.010798 1.832039 1.743886 1.062461 1.551722 0.161056 0.247843 0.963386 -0.138497 0.113261 1.624467 1.660928 0.708473 1.847610 1.082010 1.479425 0.325611 0.661837 0.996064 1.316217 0.550535 0.354734 1.792945 0.587728 0.521299 1.867430 0.374452 1.069128 1.359185 1.163695 0.951998 1.554486 0.652597 0.335947 -0.007622 0.361202 1.522520 0.972243 1.090924 1.066404 1.473604 0.640795 1.326138 1.634896 0.633935 0.819042 0.374617 0.068108 0.899846 0.802853 1.002802 0.759373 0.912908 1.407252 1.871269 1.750381 1.651341 0.745903 0.461669 0.010571 1.287847 0.966184 0.583195 0.846835 0.694802 0.418880 1.389707 0.135708 0.155010 1.328469 0.737490 1.774328 0.368667 1.177429 1.152407 0.410099 1.383384 1.321282 1.568075 1.554693 1.238949 1.708897 0.117567 1.335460 1.803251 1.767886 0.012287 0.229862 0.355011 1.249238 1.512803 0.578011 1.451312 1.246621 -0.119738 1.826298 1.173428 0.117885 1.168928 0.345406 1.476069 -0.166920 1.034463 0.382725 0.245749 0.326820 0.118853 -0.057706 0.849665 0.007921 0.613571 0.734308 1.134450 0.749676 1.890959 0.378518 1.752809 1.108432 1.225504 0.442657 0.756270 1.860343 0.369036 1.527507 0.444954 0.930412 1.102519 1.878509 0.479922 1.150077 1.602579 0.058713 0.962265 0.328221 1.661628 0.457747 0.271408 1.870263 1.306306 0.335093 0.169626 0.654033 1.444649 0.614644 1.787700 0.114577 0.749670 0.270604 1.159625 0.989586 0.567069 1.072818 1.888945 -0.085294 0.121997 0.763024 0.984919 0.155703 -0.016260 0.191743 0.212740 0.115788 0.830523 1.683788 0.348500 0.124881 0.670456 0.678523 1.096574 0.897665 1.161154 0.986261 0.052581 0.418547 1.926610 1.527221 0.733566 1.720164 0.588071 0.718754 0.656306 1.222241 0.299541 1.655932 1.738610 0.208473 1.377056 1.640789 0.933028 0.500950 0.266025 0.202787 1.158416 1.726212 1.606686 0.645745 1.477768 1.448364 1.953745 0.028736 0.535783 0.762769 0.101338 1.101876 0.758538 0.004060 1.805216 1.598025 1.230557 0.047096 1.594085 0.215135 0.853051 1.296541 1.417117 0.235968 0.643987 1.405340 1.661579 0.911175 0.443065 1.589884 0.446420 1.073318 0.341514 0.657629 1.701362 1.726879 1.038635 1.625078 0.744561 0.038576 0.786606 0.041993 1.298454 0.218073 0.832914 0.079816 1.047928 0.782023 1.638485 1.342287 1.936893 0.724752 -0.015138 0.922139 1.148652 1.670824 0.337136 0.637705 1.001048 -0.228216 1.495036 0.605922 1.410177 1.011580 0.373865 -0.050306 -0.030282 1.482241 1.182296 0.616043 1.884674 1.514223 0.449114 1.217143 1.156828 0.699730 0.102999 0.250137 -0.031123 1.355748 1.655393 1.161987 1.872025 1.869860 1.112928 1.115924 0.563079 0.100168 1.165211 0.614544 1.264233 1.208279 0.960027 1.628427 1.610521 0.459497 0.403669 1.211322 0.657728 0.590534 1.175789 1.353568 1.427489 1.516217 1.243310 0.036331 1.415204 1.335414 0.312401 0.846162 1.692827 0.881253 1.673563 1.476773 0.491668 0.078271 1.772063 0.429881 0.829599 1.510362 1.324221 0.970839 1.031818 1.605683 0.417137 0.539905 1.124071 1.428885 0.758991 1.336089 0.469378 0.968420 1.462076 0.079466 1.439924 1.447561 1.037226 0.032416 -0.028897 0.368902 0.151743 1.133019 1.512185 1.860937 1.628533 0.118447 1.427979 0.445947 0.232361 0.041062 1.774814 -0.000513 0.970153 0.175939 -0.114292 0.214713 0.557618 0.732536 1.302739 0.889277 1.136665 1.083674 0.654661 1.702739 0.901405 1.509089 0.547946 0.795351 1.387886 0.101319 1.071538 0.300259 1.362963 1.449746 1.621519 0.648860 1.238117 0.385683 0.777458 1.582777 0.090560 1.423196 0.518231 0.129612 0.369422 1.062708 1.137679 1.093619 0.410051 -0.028865 0.764992 0.842311 0.311702 1.830111 0.825103 0.859872 1.362654 0.443486 0.796728 0.015052 1.894804 0.178369 1.350106 1.080421 0.074839 1.798439 1.439047 0.543832 1.787518 1.095677 1.399291 1.218684 1.329215 0.024198 1.277854 1.781214 1.897330 0.663755 0.933197 1.460518 0.015174 0.890021 0.299191 0.591948 0.637994 0.192189 1.518365 0.789317 0.221733 1.393516 1.452171 1.164045 1.425340 1.211899 0.133999 1.809860 1.760137 0.786782 0.058488 1.033658 1.696528 0.115067 1.775639 1.843275 1.658795 1.102731 0.033810 1.518485 0.287243 0.872813 1.110274 1.284147 1.409632 0.002816 1.287616 1.920460 1.545101 0.357241 0.586921 0.250178 0.941329 0.683970 1.816670 1.249502 0.715161 1.288352 1.693684 -0.049681 0.500555 0.738239 0.766636 1.371281 0.427733 1.686588 1.002051 0.758627 0.719945 0.772296 0.797069 1.369126 1.077561 0.114153 1.255930 1.134835 0.290465 1.528414 1.156214 1.255893 0.569904 0.306550 1.578306 -0.027271 0.175993 0.505511 1.123829 1.257104 0.836799 0.957553 0.983670 0.264465 1.266100 0.704111 0.184087 1.468253 0.982413 -0.018410 0.765235 0.844886 0.194386 0.957304 0.466408 0.358006 1.273348 0.958858 0.192485 1.537449 0.762105 1.953919 0.360697 1.896891 0.771484 1.562116 0.477611 0.862940 1.057378 1.667997 0.072578 0.987503 0.634043 1.564453 1.444159 1.122332 0.573990 -0.026527 0.262861 0.694100 1.056833 0.776423 1.948071 1.715568 1.887729 0.174970 -0.171751 1.467195 1.339357 1.881230 0.084291 1.864481 1.857912 0.659248 0.423773 -0.012834 1.278787 1.236726 0.247062 0.279965 1.858545 1.197597 0.522526 0.880799 0.648553 0.790672 1.467274 -0.136872 0.250201 0.665615 0.060502 0.639605 0.387814 0.576618 0.316508 1.567811 0.098866 0.141794 1.102771 0.799866 0.345332 1.009816 0.888907 1.440320 1.300171 1.855403 0.546924 0.083787 1.421153 1.562621 0.072527 0.037440 0.573282 1.293324 1.351032 1.399589 0.771864 1.155326 0.219484 0.989074 0.912196 1.752766 1.745645 1.137247 0.591051 0.105617 0.254271 0.434891 -0.094733 0.689956 1.337531 0.526193 0.871788 1.523712 1.319939 -0.014173 0.862280 0.823385 0.054355 0.629683 0.514687 1.439869 0.563628 0.106880 0.266513 0.239968 1.239315 1.205902 1.537987 1.098124 0.859805 0.863555 0.449285 1.422210 0.199768 1.541420 0.165019 0.357841 1.333702 0.780552 1.817421 1.326090 1.556642 0.158090 0.988718 0.674445 1.749600 0.960378 0.084288 0.655024 1.656664 0.587799 0.266345 1.475692 0.355335 1.516077 0.871619 0.114120 0.528946 -0.021508 1.566964 0.763272 -0.041987 1.595826 0.231857 1.599241 1.621312 1.104850 1.046262 0.120831 0.746877 0.255028 1.065960 1.308573 1.030611 0.412491 1.820905 0.676300 0.872818 1.288694 1.324473 0.222472 -0.042336 0.351502 0.979300 0.592070 1.751901 1.130980 0.635238 1.762905 1.273495 1.080044 0.919480 1.179593 1.820413 -0.178963 1.488909 1.547676 1.413473 0.037220 0.540918 0.498348 0.519105 1.466716 1.160558 1.879868 1.779510 0.227415 1.843328 0.973617 1.469836 0.661373 0.789077 1.686318 1.083096 0.731552 0.631974 0.625195 0.518437 0.775161 0.599994 1.433824 1.546850 0.244876 1.235352 1.089325 0.745382 0.631062 0.172135 1.346869 0.691421 0.557946 0.547526 0.910145 1.806512 0.841829 0.035993 0.164089 0.876851 0.419736 1.447045 0.857337 1.449753 0.335596 1.526369 1.237708 0.224164 0.915030 1.895158 0.321894 0.243163 0.253147 0.767202 1.294104 1.921776 0.626583 0.519179 1.368603 1.836644 0.124415 0.786054 0.509813 0.419967 1.197343 1.868597 0.775064 0.252892 0.318984 0.927666 1.932340 1.673779 0.940320 1.012894 1.522815 1.848921 1.524047 0.876052 0.835068 0.202396 0.794377 1.439611 0.074539 -0.075361 1.885112 0.757920 0.329423 1.361749 0.638054 1.833880 1.623912 1.949599 1.140473 0.640646 1.616862 1.093454 0.364866 1.044146 1.776136 1.508751 1.419919 0.732729 1.039208 1.607877 1.063599 1.218045 1.039226 0.726168 0.417832 1.530379 1.814359 0.766578 1.503198 0.394050 1.486705 1.297175 1.401889 -0.082990 1.629865 0.667706 -0.397919 1.071902 1.710567 1.259419 0.488686 0.774842 0.495281 0.690810 -0.138360 0.995138 0.649084 1.726986 1.822386 1.675677 0.871295 0.552178 0.176435 1.151023 1.706719 1.714074 1.232741 1.305463 1.102357 1.338847 1.735865 0.353156 0.053635 1.854965 0.082734 1.117492 1.602812 0.202797 0.527913 1.196926 0.224179 0.259190 1.607857 0.393217 0.665176 0.698877 1.498248 0.402702 0.734968 0.030220 0.717933 0.287575 0.263201 1.292487 0.766597 1.392089 1.702156 0.928571 0.132747 0.718224 -0.022519 0.695395 0.961009 0.836784 0.544693 0.008738 0.733264 1.627723 1.340817 1.883794 0.273239 0.966759 -0.014448 1.703981 0.745520 0.782103 1.349896 0.309738 1.248191 0.900551 0.446724 1.461235 1.068695 1.874609 0.429643 0.991606 0.853954 0.549724 0.691665 0.919866 1.355260 0.399310 1.207242 1.036111 0.331131 1.923340 1.034344 1.785499 1.692182 1.469165 1.114091 0.784790 1.244341 1.215443 0.532863 1.669624 1.876519 0.370732 1.081205 0.630715 0.067840 0.069610 0.360604 0.248517 0.996373 0.072779 1.278622 0.558082 0.871795 0.006302 -0.080693 0.699858 0.670774 0.036839 0.792313 1.053054 0.373523 0.895965 0.219529 0.603841 1.529929 1.571200 1.572745 1.371021 0.483877 0.339338 0.252508 1.449230 0.776954 -0.037096 1.490924 0.862926 -0.010051 1.492206 0.908991 0.850959 0.799315 1.197209 1.798803 1.906307 0.600800 1.929103 1.773167 1.595466 1.116230 1.849141 -0.138473 1.401561 1.089434 1.454707 1.516034 0.405189 0.364581 0.477576 1.238788 1.699265 1.225421 1.132382 0.818130 0.342357 -0.093965 0.277981 1.214872 1.234457 1.644311 0.791369 1.302431 1.793582 0.731030 1.184737 1.815189 0.836787 1.397548 0.795514 1.731490 1.978947 1.699272 -0.087754 1.229538 0.342806 1.370505 1.915848 0.745665 -0.007586 0.973025 0.820357 0.688041 1.687190 0.295857 1.467741 0.510938 1.446447 0.725517 0.934034 0.280828 0.016119 0.464653 0.039176 0.699325 0.325100 0.107226 0.235540 -0.001189 1.374634 0.697151 1.094635 0.813547 1.004845 0.482350 0.999131 0.106594 0.262632 1.035519 1.040389 1.543929 1.111148 0.589803 0.294786 0.739019 0.976084 0.242874 1.533302 1.797675 0.710897 0.037253 1.540031 -0.138585 0.099110 0.002289 0.351043 1.535626 1.094114 1.596706 1.760672 0.111407 1.067403 0.300312 1.066585 1.479561 0.664804 1.829358 -0.133782 0.959441 1.032728 1.396513 1.674422 1.797836 1.031267 1.515695 1.300521 1.221482 1.135268 1.060354 0.280176 0.099445 0.768971 1.623602 1.175004 0.859700 0.318892 1.048016 1.141598 0.451777 0.809913 1.805898 -0.088147 0.408319 0.962852 0.001868 0.190438 -0.086998 1.638471 0.448879 1.897520 0.102606 1.398992 0.552579 1.630596 1.779521 1.459921 1.806379 -0.015856 0.522021 1.606515 0.866415 1.424116 0.555575 1.948281 1.030085 1.522586 1.487448 0.345793 0.419242 0.262081 -0.137605 0.615015 1.404327 0.444728 1.303330 1.429523 1.612489 0.842585 0.811464 1.213611 1.776209 0.851089 0.965962 0.450547 1.048746 0.577828 0.621931 1.428382 1.449142 0.237328 1.159246 1.621752 1.046157 1.746994 0.219170 0.418162 1.636099 1.220316 1.860240 1.104417 0.911381 -0.221721 0.477919 0.648802 1.465706 1.034322 0.722603 0.484344 0.507547 1.362755 0.260305 0.012258 1.063129 0.125427 0.731236 1.951972 1.460277 1.336222 1.327980 0.292992 1.466729 0.979436 1.525635 1.525911 0.335487 0.473741 -0.076837 0.875218 0.622684 0.081840 0.662885 1.733616 0.541135 0.388849 0.020387 1.077932 1.301097 1.479384 0.696331 1.842813 0.869590 1.665039 0.472033 0.087064 0.068769 0.055497 0.502784 1.571676 1.461867 1.681430 0.147791 1.648422 1.206459 -0.037747 0.322247 1.620310 0.330283 0.874529 1.548328 0.082016 0.899640 0.252738 1.639547 1.115960 0.718372 1.473943 0.699136 1.736238 1.746811 1.089863 0.308838 1.120907 1.649835 0.230940 0.599980 0.596666 1.447764 0.198200 1.696185 0.270568 -0.052189 1.459685 1.889516 0.973187 0.172200 1.005083 0.140394 -0.325498 0.227479 1.423139 0.675559 1.625686 1.773134 1.707271 0.913240 1.631036 0.019460 -0.103583 0.286102 0.291320 0.171705 1.446563 0.484585 0.563140 1.120302 1.858354 -0.041253 1.012849 1.296992 1.301978 0.760269 1.753296 0.283422 0.885422 1.492344 1.329990 0.612597 1.921560 0.200214 0.943390 0.512296 1.447564 1.846183 1.707477 0.147308 1.193487 0.573805 0.940372 0.256928 1.884388 0.083286 0.452700 0.291224 0.183037 0.545393 0.513289 1.568504 0.086795 1.616080 0.313708 1.244178 1.366657 0.283715 0.918206 0.203207 1.448705 1.446830 1.040873 1.730698 1.611476 0.946093 0.666703 0.615895 -0.026318 1.856548 1.350941 0.160944 1.170338 0.103712 1.306411 1.265492 0.066769 0.766652 0.588182 1.233682 0.122447 1.681384 0.412335 0.178479 1.660841 1.811596 0.064779 1.196947 0.102828 1.177751 1.680742 0.449282 0.904230 1.612891 0.610492 1.241968 1.399466 0.400447 1.883535 1.261774 1.133011 0.954793 1.391021 0.070613 1.790155 0.647170 1.538113 0.897498 1.281308 0.839515 0.299338 1.976000 1.258249 1.677501 0.492876 0.811265 1.486293 1.219526 0.118255 0.198524 0.778925 0.559223 0.356595 0.911936 0.224097 0.843920 0.757074 1.245721 1.201767 1.503895 1.262673 1.087280 1.841884 0.809693 0.271807 0.201811 0.731278 1.725985 1.815260 0.626935 0.345144 1.819499 0.455162 1.284539 0.586586 -0.039343 1.180043 1.600481 1.257565 1.070955 1.769321 1.284756 0.544339 0.946351 1.252154 1.036230 1.576752 1.153164 0.375443 1.727961 1.571085 -0.025115 1.130257 1.617683 0.962908 1.778427 0.723156 0.083418 0.399245 1.317049 1.776371 1.599518 1.205637 0.260734 1.602902 0.159849 0.015420 1.100020 1.095699 0.079940 0.912501 0.640796 0.462014 0.677260 1.211741 1.516331 1.260972 0.602754 1.418955 1.106479 1.705887 -0.011794 -0.109286 0.655006 0.832139 0.926535 1.469372 0.543237 -0.034228 1.638292 1.960348 1.105376 1.332042 1.230009 0.928482 0.888952 0.046935 0.000507 1.314819 0.300831 0.937048 1.256196 0.493401 1.660853 0.728526 -0.110992 1.233577 0.930248 0.678472 -0.188603 1.218183 0.336483 1.191586 0.137376 1.533100 0.065052 0.981398 0.031577 0.994203 0.870125 0.262473 0.406748 0.511844 0.815002 0.421443 1.909838 1.226523 0.209198 0.929653 1.101747 0.799872 -0.201492 0.710339 1.291323 0.977953 1.379452 1.641037 0.096914 1.857579 -0.096609 0.337720 0.155086 0.269412 1.616182 0.568248 0.498010 1.652758 1.650958 0.244174 0.661813 1.505931 0.002924 0.107270 1.744250 -0.050778 1.467242 1.623260 0.801762 0.194925 0.642578 1.510339 1.586904 0.355100 0.041208 0.186780 1.201510 0.782417 -0.071305 1.709116 1.537271 1.490599 0.543263 -0.128944 1.746343 1.737663 -0.131604 0.721233 -0.033503 0.381659 0.516023 0.468830 0.968358 1.682010 1.574023 1.572387 0.110095 0.087750 1.339801 0.879220 0.721407 1.874303 0.700889 0.258858 1.621111 0.253234 1.424104 1.511284 0.981212 0.722846 0.700750 1.110812 0.395794 1.195186 0.912389 1.340990 0.476183 1.514745 1.613236 0.410309 0.055535 0.162381 0.534469 0.793452 1.780666 0.700207 1.016778 0.157602 0.161820 1.110015 0.882580 0.709147 1.213415 -0.036555 1.633111 1.171847 0.640753 0.205253 1.266074 1.492664 0.580884 0.765533 1.322154 0.370372 1.440758 0.830815 1.501849 1.539966 1.852372 0.365379 1.004282 1.053251 0.251083 0.118197)
       )

;;; 4096 155.67;     (expt 4096 .6) is 147
;;; 65536 704.86! [.59 = 697, .5 = 256]

))


;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.539 #(0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
#(3  1.7548747062683 #(0 1 1)

     1.7393749801561 #(0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 #(0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 #(0.0 0.79018270969391 0.69699490070343)

     1.738745 #(0.000000 1.209826 1.303017)
     1.738744 #(0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
#(4  2.19460272789 #(0 1 0 0)

     2.050 #(0 39/25 26/29 27/22)
     2.048743724823 #(0 111/256 281/256 195/256)
     2.0466175079346 #(0 223/512 563/512 49/64)

     2.045218 #(0.000000 1.563819 0.899661 1.233860)
     2.045217 #(0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
#(5  2.7317879199982 #(0 1 1 0 0)

     2.3731805734023 #(0 7/16 7/4 5/8 7/16)

     2.307252 #(0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 #(0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
#(6  2.8638670444489 #(0 0 0 0 1 0)

     2.522759 #(0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 #(0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
#(7  2.9204399585724 #(0 0 0 1 1 0 1)

     2.618497 #(0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 #(0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
#(8  3.2507002353668 #(0 1 1 0 1 1 1 0)

     2.8071956634521 #(0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.791000 #(0.000000 1.197326 0.326760 1.111456 1.318751 0.231304 1.994192 1.872649)
     2.790858 #(0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 #(0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
#(9  3.5549147642153 #(0 1 0 1 1 0 0 0 0)
     3.46973755015 #(0 1 1 0 1 0 0 0 1)
     3.4140722751617 #(0 0 1 1 1 1 0 1 0)

     2.886575 #(0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 #(0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
#(10 3.5391488075256 #(0 0 1 1 0 1 0 0 0 0)

     3.054055 #(0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 #(0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 #(0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 #(0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 #(0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
#(11 3.6182308197021 #(0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 #(0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 #(0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 #(0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 #(0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 #(0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
#(12 4.0877377663658 #(0 0 0 0 1 0 1 0 0 1 1 0)
     4.0507665657231 #(0 1 0 1 0 0 1 1 0 0 0 0)
     4.0 #(0 0 1 1 0 0 0 0 0 1 0 1)
     4.0 #(0 1 1 0 1 0 0 0 1 0 0 0)
     4.0 #(0 1 0 1 0 0 1 0 0 1 1 1)
     4.0 #(0 1 0 1 1 0 0 1 0 0 0 0)

     3.364341 #(0.000000 -0.081820 1.399778 1.018584 0.994103 1.854492 0.464370 0.769854 0.179932 0.999593 0.618367 1.331545)
     3.363698 #(0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 #(0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
#(13 3.9482246631869 #(0 0 0 0 0 0 1 1 0 0 1 0 1)
     3.8778836727142 #(0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.531897 #(0.000000 0.670162 -0.095257 0.537542 -0.014805 0.385445 0.484518 1.431811 0.066607 0.001633 1.257240 0.820923 0.574587)
     3.476053 #(0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 #(0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 #(0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
#(14 4.2126383781433 #(0 0 0 0 0 1 1 0 0 1 0 1 0 0)
     4.2575645446777 #(0 1 0 0 1 0 0 1 0 0 0 1 1 1)
     4.2842662512094 #(0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.6206462 #(0.000000 1.058317 0.285078 1.806037 0.777548 1.158566 0.154927 1.434637 1.675813 0.358961 0.394684 0.549621 0.067593 0.064796)
     3.606512 #(0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 #(0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 #(0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
#(15 4.4701427567987 #(0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)
     4.4776539802551 #(0 0 1 0 1 0 0 1 0 0 0 1 1 1 1)
     4.5555243492126 #(0 1 0 0 1 0 1 0 0 1 1 0 0 0 0)

     3.759718 #(0.000000 -0.397665 0.806430 -0.136442 1.561904 0.158128 0.655585 -0.218498 0.035467 0.628496 0.322341 0.470757 -0.271280 1.477753 1.665977)
     3.754132 #(0.000000 0.903767 1.420933 1.923281 1.041289 0.252052 0.873412 0.620154 1.578503 0.111918 0.212810 -0.101363 1.630440 0.487026 0.384094)
     3.753088 #(0.000000 1.135982 0.074052 1.463569 1.541245 1.092705 1.157015 0.490295 1.413226 1.335648 0.694560 1.273492 1.624971 0.104821 0.184801)
     3.739752 #(0.000000 1.191367 0.176518 1.591145 1.710423 1.309889 1.422724 0.785426 1.754948 1.707551 1.122738 1.744847 0.127913 0.663567 0.776627)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
#(16 4.5778832343715 #(0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)
     4.5854911804199 #(0 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0)
     4.6032500267029 #(0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0)
     4.6629304885864 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1)
     4.6691436767578 #(0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1)

     3.863264 #(0.000000 0.212739 0.823601 0.183475 0.522013 1.322798 0.144924 -0.004654 0.283110 0.829370 -0.006329 1.351573 0.889059 1.066540 0.816406 -0.008936)
     3.858242 #(0.000000 0.144652 0.676444 0.017002 0.269119 1.012194 1.772841 1.585260 1.809100 0.289620 1.399960 0.670537 0.175237 0.296937 -0.017357 1.108803)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
#(17 4.5790815353394 #(0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)
     4.6202440261841 #(0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1)
     4.8765740394592 #(0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 0)

     3.97646324 #(0.000000 0.753931 1.605116 -0.013833 0.719484 1.221266 1.149453 -0.016400 0.682620 0.271202 0.759215 0.509449 0.934281 0.751176 0.303242 1.755965 1.144501)
     3.927805 #(0.000000 0.618908 0.864629 1.180783 1.677629 1.929621 0.580975 1.820904 0.468136 1.289907 0.485211 0.029658 1.160895 0.856998 0.644358 0.814931 0.296558)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
#(18 4.801501750946 #(0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)
     4.857753276825 #(0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     4.86248254776 #(0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0)
     5.0418791770935 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0)
     5.0524249076843 #(0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)
     5.0652704238892 #(0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0)
     5.0697374343872 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0)
     5.0979032516479 #(0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0)

     4.18242582 #(0.000000 1.136222 0.770438 0.400169 1.826042 1.428576 1.017726 1.528217 0.877622 1.606644 0.825490 0.569790 0.688245 0.883189 1.302521 1.639646 0.475959 1.347778)
     4.130024 #(0.000000 1.754352 1.775885 0.648861 0.498465 0.100092 0.902120 1.526431 0.475472 1.473007 0.551653 0.202011 1.209083 1.439412 1.702576 1.066652 0.934229 1.195458)
     4.071185 #(0.000000 0.956640 1.083713 0.493342 0.797185 0.138960 0.613585 0.388904 -0.007616 0.968034 0.616152 1.753096 0.351362 1.174080 1.220111 1.511627 0.186455 1.775153)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
#(19 5.0520766258263 #(0 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 0)
     5.0155117084604 #(0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0)
     4.9927339414282 #(0 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1)
     4.9885946763115 #(0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0)
     4.9724504091175 #(0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1)
     4.9609222566765 #(0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0)
     4.8924918279945 #(0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.341600 #(0.000000 1.579328 0.343104 1.375842 0.353081 0.423388 1.240118 1.912826 1.194961 1.293193 0.615240 0.016197 0.673856 0.516664 0.391481 1.727303 0.190251 0.501442 0.668027)
     4.195254 #(0.000000 0.791760 0.603530 1.420197 0.161131 1.375504 1.353582 1.630311 0.304896 0.430904 0.181997 0.875060 1.590045 0.702894 0.531692 0.132476 0.893747 0.532901 0.172031)
     4.173923 #(0.000000 0.329738 1.407540 1.252167 0.448297 0.551162 1.341659 1.859617 1.357020 0.222879 0.553639 1.254187 0.641694 -0.208417 1.489583 1.646436 1.391179 1.758274 1.299312)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
#(20 5.136606875959 #(0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0)
     5.104093841111 #(0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0 0)
     5.043 #(0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.360063 #(0.000000 0.073521 -0.009620 0.184167 -0.090618 0.682702 1.090680 1.616612 1.399432 0.352373 1.094838 -0.499526 0.947850 -0.319867 1.410866 0.829866 -0.654620 0.294523 -0.287091 1.405089)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
#(21 5.2726634376804 #(0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0)
     5.2359894831295 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1)
     5.2142992491192 #(0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1)
     5.2105652502144 #(0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0)
     5.1372244578347 #(0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.450399 #(0.000000 1.232888 0.090626 0.908626 0.292628 1.789632 -0.064521 1.337231 1.077653 0.742032 1.053479 1.212396 1.464307 0.813375 1.503599 1.665799 0.652080 0.032818 1.058665 1.235482 -0.037282)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
#(22 5.5119525535942 #(0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0)
     5.473 #(0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1)
     5.1805551751198 #(0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.582778 #(0.000000 0.181219 0.413695 1.937138 0.354645 0.584330 1.521156 1.778203 1.534204 1.337940 -0.034924 1.699942 0.807878 0.347955 1.849970 -0.102930 0.038171 0.664785 1.395334 0.513333 1.628189 0.471554)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
#(23 5.5374279022217 #(0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0)
     5.4125407453101 #(0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.663897 #(0.000000 0.403435 0.142748 -0.306349 -0.210666 0.795999 1.004771 1.283072 1.566950 0.563329 0.340321 0.292952 1.204762 0.724980 0.539830 0.518629 0.906326 0.187293 1.164337 0.997077 -1.862047 1.042851 -0.124041)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
#(24 5.6568542494923 #(0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0)
     5.6584029055795 #(0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0)
     5.62041703818643 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)
     5.6193280144865 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.789073 #(0.000000 0.498962 1.192122 1.399568 0.478175 1.498537 -0.058937 0.823036 0.009630 0.862968 0.052440 1.055798 0.997888 1.799698 -0.043449 0.198517 0.646569 0.269929 0.032678 0.156758 0.040928 -0.117138 1.174336 0.689332)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
#(25 5.7861609458923 #(0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1)
     5.7734115151023 #(0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1)
     5.7220960914079 #(0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.889151 #(0.000000 -0.128293 0.647012 0.790395 -0.286222 0.142942 1.157912 1.181898 -0.008090 -0.239858 1.215092 0.277126 0.697826 1.108639 0.614409 1.458730 0.405980 0.119432 0.178568 -0.086880 1.056419 0.142726 0.542932 0.376693 0.306796)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
#(26 5.8912210464478 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0)
     5.8572101593018 #(0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0)
     5.8545204896237 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0)
     5.8537594936002 #(0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.008456 #(0.000000 1.693298 1.368284 1.373891 0.627805 0.749201 1.218581 1.690405 1.084549 0.650173 -0.133773 1.086196 0.314357 0.195942 0.717774 1.230001 1.543258 -0.160224 1.426853 1.764971 0.866097 1.848572 0.672503 -0.114245 0.170724 0.146283)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
#(27 5.9741146989154 #(0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0)
     5.968769496567 #(0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1)
     5.9206547737122 #(0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0)
     5.8637111082051 #(0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.091597 #(0.000000 0.108433 1.216643 1.164927 0.973412 -0.021700 0.035052 -0.150680 0.575434 1.005110 1.378469 0.117668 0.956832 1.742119 0.131354 -0.244103 0.873574 0.514283 1.810072 0.920776 0.162873 1.223342 1.596642 1.233515 1.209783 1.332933 1.299893)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
#(28 6.0999548630948 #(0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0)
     6.0720555632906 #(0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1)
     6.057788848877 #(0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0)
     6.0276107788086 #(0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.092585 #(0.000000 1.695440 -0.043623 0.222052 0.119988 0.906658 0.748492 0.144655 -0.170479 0.199068 0.623366 -0.017877 1.188512 1.804895 0.527591 0.257090 0.180945 1.672974 1.633662 0.481970 1.385001 1.687455 0.368286 1.304198 0.926301 0.205231 0.776507 0.352984)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
#(29 6.2191140571712 #(0 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1)
     6.1821198011886 #(0 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0)
     6.1290216445923 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0)
     6.1179310275088 #(0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1)
     6.0348020511367 #(0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.267374 #(0.000000 0.150950 0.558525 0.734122 1.367984 -0.010939 1.646605 0.436638 1.718320 1.202816 0.978274 1.009951 0.702458 1.591440 0.711769 0.372772 0.283792 1.401587 0.653090 0.959946 0.846748 0.832705 0.047894 1.107158 1.102787 1.831833 0.612394 1.520781 0.108517)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
#(30 6.2854590415955 #(0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0)
     6.2697563171387 #(0 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1)
     6.2528157234192 #(0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1)
     6.2357559204102 #(0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.356917 #(0.000000 -0.272403 0.779609 0.427831 1.743491 0.813040 1.826167 0.242297 0.800154 0.444205 0.599989 1.282484 -0.036742 0.801786 0.590077 1.134322 0.784392 1.820310 1.361582 1.648573 1.057728 0.274607 0.187893 0.071940 0.646543 1.513903 1.900196 1.697822 1.289117 1.535078)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
#(31 6.3631281852722 #(0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1)
     6.3062944412231 #(0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1)
     6.269211769104 #(0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0)
     6.1342258453369 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.423494 #(0.000000 1.386303 -0.055734 1.470363 1.133289 0.301867 1.278872 0.118563 0.785226 0.165360 0.277066 1.264913 0.806911 0.592449 0.252572 0.349148 0.668297 0.601505 0.393268 1.237828 -0.182749 1.792953 1.685727 0.766750 0.385388 1.093159 0.147275 0.340746 0.884734 1.109480 0.159614)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
#(32 6.5067925453186 #(0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0)
     6.5040426254272 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
     6.4926128387451 #(0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1)
     6.4840421676636 #(0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1)
     6.4720740318298 #(0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1)
     6.3532226957365 #(0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.567572 #(0.000000 0.861612 1.209352 0.519940 1.052688 1.500206 0.176574 1.932012 0.476025 1.248486 1.078099 0.961526 1.430505 1.363781 0.301762 1.949580 1.401541 1.767835 1.762773 0.053035 1.192812 0.032127 1.950646 1.510242 1.125351 1.064249 0.897680 1.674417 0.357268 1.272658 0.844033 1.936450)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
#(33 6.6069865226746 #(0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 0)
     6.6028137207031 #(0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1)
     6.5531010627747 #(0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0)
     6.5466594696045 #(0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1)
     6.5448527336121 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1)
     6.4944429397583 #(0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.606985 #(0.000000 1.601250 1.154201 1.251204 1.484471 0.841351 0.331138 1.775294 1.322346 1.205337 1.309192 0.894341 0.780080 0.993837 1.545031 0.197628 0.378099 0.791105 1.808947 1.068283 0.948274 1.605477 1.762770 1.528242 1.622190 0.602603 1.560229 -0.275479 0.725028 1.892782 0.568803 -0.062637 0.716748)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
#(34 6.7313859392731 #(0 1 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0)
     6.7289090156555 #(0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 0)
     6.7241077423096 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0)
     6.6926617622375 #(0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0)
     6.6887402534485 #(0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0)
     6.67742395401 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0)
     6.5771403312683 #(0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.745149 #(0.000000 1.128000 0.272515 -0.039342 0.299166 0.551340 0.311135 0.243296 0.298010 -0.034808 1.017937 0.346637 1.523918 0.449629 1.252707 0.940022 0.532163 0.349046 1.187598 0.382385 0.597063 -0.156613 1.373428 0.579016 1.245233 1.475704 0.214408 0.059071 0.148707 1.076050 1.407267 0.860377 1.325750 0.147798)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
#(35 6.8717794418335 #(0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0)
     6.8709630966187 #(0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0)
     6.8534955978394 #(0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0)
     6.8080215454102 #(0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0)
     6.7822489738464 #(0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0)
     6.7593507766724 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0)
     6.7392678260803 #(0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.838235 #(0.000000 0.446999 1.593042 1.667453 0.393874 0.928772 1.354904 1.466772 0.226754 1.215249 0.009860 0.231727 1.867304 1.148536 1.079686 1.602019 0.201717 1.367553 -0.043267 1.213451 0.401906 0.197087 1.726905 1.537420 -0.145221 -0.105823 1.452971 0.350421 1.134485 0.211013 1.683797 0.967568 0.587830 1.050198 0.967015)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
#(36 6.9997129440308 #(0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 0 0)
     6.9918489456177 #(0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     6.9864625930786 #(0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0)
     6.9756178855896 #(0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0)
     6.9730844497681 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0)
     6.9310870170593 #(0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0)
     6.838840007782 #(0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     6.8277182579041 #(0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     6.000647 #(0.000000 1.912912 1.511457 1.005676 0.475902 1.042301 1.534958 1.687657 1.633883 0.696422 0.109719 0.960671 1.460953 -0.086125 0.280953 1.392145 0.637062 0.548998 1.855535 0.910709 0.899814 1.218376 1.194522 1.403477 0.001627 1.122460 1.703316 1.347718 0.823811 0.867627 1.120797 0.336394 0.652737 0.037688 1.489642 0.050669)
     6.000197 #(0.000000 1.917527 1.510073 1.005131 0.453926 1.063640 1.559823 1.682537 1.623280 0.681308 0.086236 0.947887 1.480950 -0.074836 0.321662 1.405263 0.630112 0.513122 1.845839 0.897702 0.896538 1.245466 1.226396 1.436138 0.029365 1.162940 1.689733 1.372435 0.854198 0.883700 1.124489 0.382194 0.683834 0.036818 1.474548 0.083108)

     5.996066 #(0.000000 1.923294 1.509187 1.003577 0.456660 1.062378 1.555540 1.683067 1.621530 0.683932 0.087670 0.954147 1.484751 -0.073402 0.320903 1.403802 0.626357 0.507563 1.850435 0.892520 0.896703 1.243983 1.224037 1.439495 0.031850 1.163064 1.686561 1.366983 0.859861 0.891355 1.129464 0.385910 0.687566 0.036704 1.476995 0.083963)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
#(37 7.1364183425903 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0)
     7.1333456039429 #(0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0)
     7.1091394424438 #(0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0)
     7.1067843437195 #(0 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0)
     7.0880541801453 #(0 1 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.0842223167419 #(0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.0678915977478 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     7.0 #(0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.024853 #(0.000000 1.197998 1.847287 0.935006 1.782937 0.496617 0.026869 0.302955 1.087642 1.074685 1.005491 1.377595 0.273425 1.653861 0.070205 0.494353 1.198438 -0.081973 0.936958 0.883593 1.529878 0.426603 0.218858 1.480597 1.569766 1.445696 0.463800 0.267438 1.385323 0.811147 0.214359 0.106300 0.522104 0.380804 0.177813 0.326019 -0.015506)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
#(38 7.1993670463562 #(0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0)
     7.1947164535522 #(0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 1)
     7.1848387718201 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0)
     7.1674456596375 #(0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     7.0878057479858 #(0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0)
     7.027690410614 #(0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.150178 #(0.000000 0.458381 0.980410 1.182584 1.502374 1.305302 0.863491 1.146667 1.407357 1.061564 0.795229 1.420865 1.626108 0.940678 1.765120 -0.200782 0.758841 1.330656 0.859416 0.934009 0.734086 -0.018706 1.390826 0.222287 1.806876 0.258169 -0.107351 1.180819 1.133567 0.286545 1.542814 0.215728 1.086918 1.359138 1.067734 1.591630 0.412893 0.246316)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
#(39 7.3710842132568 #(0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     7.3583292961121 #(0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.3438787460327 #(0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0)
     7.3397698402405 #(0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.3336853981018 #(0 0 0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0)
     7.3038640022278 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0)
     7.2819819450378 #(0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0)
     7.2700448036194 #(0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 0)
     7.2362656593323 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.187454 #(0.000000 0.388618 1.432653 1.784425 0.371935 0.650011 0.589744 1.419632 1.232381 1.275218 1.031193 0.648549 1.314783 1.550413 0.796967 0.829675 0.920444 0.286140 1.176611 0.777335 1.481467 -0.170605 1.810857 0.590069 1.604413 0.287254 1.659794 1.308709 0.893762 0.025955 0.915239 0.336227 0.586243 1.686232 1.285404 1.206990 1.759017 1.037935 0.925206)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
#(40 7.6328768730164 #(0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 1 1)
     7.5038495063782 #(0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.277925 #(0.000000 1.286847 1.056558 1.064552 0.386122 0.823982 0.120665 1.715364 1.070368 1.544864 0.375054 1.038193 0.380390 0.305991 1.429156 0.150341 0.742273 -1.907886 0.495478 -0.131302 1.454190 1.544371 0.424550 1.222035 1.334261 1.409069 0.400912 1.070887 1.396403 -0.550278 0.327917 1.771458 0.927243 0.552970 1.392666 1.183354 1.462584 1.291648 1.910305 1.576805)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
#(41 7.86743174872036 #(0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0)
     7.7093445316966 #(0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.327577 #(0.000000 0.582814 1.286033 1.434762 0.968648 0.414373 0.202678 -0.084375 1.012441 1.216240 0.698275 0.906119 0.006115 0.289651 0.751619 0.181944 1.916605 0.830850 0.905938 0.268842 -0.060925 0.318843 0.592034 1.698481 1.912304 1.683298 0.193210 0.459818 0.828474 1.122554 0.525807 1.056723 0.751455 0.901980 -0.077116 0.957355 -0.093347 1.453165 0.349371 1.538528 1.034674)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
#(42 7.9323644638062 #(0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0)
     7.8349797520917 #(0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1)
     7.77445936203 #(0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.408479 #(0.000000 0.615414 1.470843 0.696787 0.198900 1.065083 0.258615 1.498581 1.009578 1.330852 -0.125534 0.667854 -0.151832 1.235447 1.351733 1.833745 1.621535 1.576927 0.386650 1.123212 1.738064 0.185423 -0.092954 -0.362850 1.267803 0.809007 0.146693 0.174438 0.940048 0.098849 1.557978 1.898566 1.061904 1.399143 1.502843 -0.309744 1.594046 1.048117 0.348277 0.500199 0.501915 1.050638)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
#(43 7.8550543785095 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 0 1)
     7.8274940102143 #(0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0)
     7.7573688953539 #(0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.480896 #(0.000000 0.162445 0.869999 0.643054 0.499615 0.316081 0.502954 0.136590 0.117083 1.312132 1.258206 1.002617 1.668339 0.653729 0.901112 0.185217 1.792525 1.096541 0.881150 0.351883 0.533560 1.402531 1.721250 -0.341462 0.698820 1.678458 1.686345 1.303828 -0.030019 0.457569 1.242075 0.589258 1.726081 0.987456 0.169302 1.113924 0.233149 0.477401 1.064623 1.025028 1.388482 1.105104 1.814053)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
#(44 8.20137867697624 #(0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0)
     7.9338580613871 #(0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.604847 #(0.000000 0.351044 1.306542 1.465763 1.320249 0.565440 0.399940 -0.237398 1.055407 0.418613 0.685395 1.680568 1.845447 1.017355 1.471092 1.618392 0.598714 0.202675 1.546748 0.895775 1.499434 -0.449664 0.958870 0.671637 0.465436 0.361895 0.743954 0.800411 1.320233 0.704441 1.101784 1.234656 0.652603 1.451040 0.413040 1.111137 0.556088 1.736681 0.344377 0.023949 0.937837 1.223467 1.558214 1.345712)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
#(45 8.1525803340105 #(0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1)
     8.1351366043091 #(0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.631015 #(0.000000 1.007271 0.477966 1.144428 0.405377 0.709562 0.591098 0.023922 1.174211 1.114679 1.631206 1.257380 1.314198 0.342822 0.579809 1.458996 0.840637 0.297374 1.352000 1.645616 1.557736 1.966797 0.747895 1.349386 0.523533 0.276675 1.146356 1.736290 1.157329 1.019943 0.469399 1.677619 1.797739 1.624789 1.799637 0.670741 1.546255 1.428852 1.094569 0.113612 0.742588 1.142278 0.965770 1.246971 0.979825)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
#(46 8.2970391011104 #(0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 0 1 0)
     8.1455316543579 #(0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.716722 #(0.000000 0.589157 0.764149 0.948916 0.779538 1.268976 0.079906 -0.380388 0.448649 1.688367 0.584830 0.606310 0.913828 1.245805 0.098838 0.459100 0.785114 0.012839 0.855902 1.034909 1.254775 0.506944 1.208460 0.513427 0.740531 1.441441 0.587365 1.582678 0.642329 1.527431 1.201228 0.845885 0.317234 0.031593 0.892897 0.339503 -0.008048 1.585731 0.008559 0.333144 0.349434 -0.214088 -0.070758 1.486266 0.987125 0.864350)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
#(47 8.4595276184949 #(0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1)
     8.336971282959  #(0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.830684 #(0.000000 0.925613 0.731025 0.826587 0.337466 0.552586 -0.007756 1.553024 1.574187 1.261569 -0.195026 1.740012 -0.008571 0.116716 -0.038767 0.642461 0.120597 1.285158 1.379269 0.169504 0.014258 1.661969 -0.108759 0.555943 1.282464 -0.130334 0.346154 1.746316 1.242394 0.734793 0.636960 0.445502 0.999801 1.599522 0.463287 -0.003293 0.565885 1.073841 1.870809 0.138086 1.429672 0.722631 1.436033 0.766038 1.792260 1.484750 0.511596)
     6.813080 #(0.000000 0.905073 0.720857 0.809038 0.349935 0.537327 -0.000922 1.557978 1.558030 1.262358 -0.197354 1.752599 0.008794 0.124688 -0.046228 0.662516 0.096529 1.285846 1.345281 0.200201 0.052671 1.678541 -0.089455 0.531007 1.289353 -0.091483 0.360154 1.752654 1.281049 0.712465 0.676290 0.476665 1.008383 1.642560 0.426923 0.037457 0.580019 1.098416 1.911742 0.149095 1.445158 0.729070 1.437273 0.755012 1.791986 1.500943 0.493857)
     6.794799 #(0.000000 0.897163 0.698247 0.822409 0.375616 0.539014 0.014454 1.555415 1.549108 1.257725 -0.202933 1.765450 0.025614 0.114875 -0.043447 0.663807 0.097520 1.291742 1.359676 0.228655 0.060069 1.644723 -0.084038 0.524959 1.308818 -0.081506 0.352086 1.751467 1.301845 0.679219 0.700158 0.496101 1.009200 1.661339 0.434627 0.072114 0.589374 1.130793 1.939998 0.152364 1.467129 0.726907 1.427280 0.765815 1.803918 1.480200 0.488883)
     6.793437 #(0.000000 0.899395 0.699139 0.822602 0.369563 0.538099 0.016185 1.556790 1.551639 1.250469 -0.202952 1.763170 0.028017 0.112846 -0.039936 0.661519 0.095443 1.286970 1.353214 0.225122 0.058009 1.649322 -0.090812 0.524816 1.307299 -0.085913 0.352297 1.754603 1.303478 0.680448 0.691624 0.498042 1.007138 1.659354 0.432424 0.069410 0.584615 1.128677 1.938358 0.151391 1.459330 0.723424 1.430080 0.763673 1.799518 1.483215 0.487535)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
#(48 8.35563071219336 #(0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.915278 #(0.000000 0.983076 1.015620 0.063842 1.494106 -0.005972 1.695997 1.678942 0.358953 1.057343 0.527209 1.428031 0.645552 1.494269 1.067870 1.497755 0.247545 0.757125 0.451247 1.449833 0.075956 1.020230 1.426922 1.629153 0.243356 1.483650 1.142286 1.674642 1.408206 1.680090 0.120730 0.539714 1.132654 0.585944 0.600580 0.199581 0.412146 0.506536 1.718622 1.360266 0.869834 0.354663 0.260398 1.244798 0.248387 0.541562 0.248243 1.958786)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
#(49 8.57458718352971 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

     6.997932 #(0.000000 -0.164932 0.062543 1.158715 1.337678 0.224375 0.048734 -0.092163 1.331151 1.726668 0.869593 0.492681 0.773739 1.547901 0.177653 0.783886 1.699317 1.314118 1.727115 1.406752 1.010538 0.644469 1.163474 0.987306 1.315592 -0.176138 0.077515 1.241145 1.483011 1.781204 0.940989 0.041761 -0.011584 1.150594 0.905660 1.772957 1.156521 1.425270 0.817709 1.841119 0.475148 1.453704 0.759985 0.412258 1.319758 0.058409 0.262995 0.090380 0.205050)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
#(50 8.7349090576172 #(0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 1 0 1)
     8.7194833755493 #(0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1)
     8.711 #(0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.955341 #(0.000000 1.361678 1.058811 0.255280 1.370961 1.849509 -0.002708 1.051990 0.138785 0.680633 0.885054 1.004997 1.663130 1.665701 1.471149 1.691478 0.092552 0.824520 1.755358 1.033319 0.055803 1.509243 0.690460 1.232103 0.639211 1.442515 1.557836 1.909825 0.175467 1.577584 1.679153 1.359609 1.558171 1.882842 1.134585 1.054710 0.137527 1.900435 0.058225 0.972013 1.379097 0.844996 0.356897 0.497540 1.235873 0.734577 0.652916 0.243110 1.084307 -0.045442)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
#(51 8.7549686431885 #(0 1 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 0 0)
     8.5829010009766 #(0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.140673 #(0.000000 0.867055 0.885398 0.429251 1.849215 0.747712 0.065763 0.297205 0.076698 0.020687 1.261107 -0.047356 1.084633 1.476871 0.848989 1.290344 0.747829 0.976562 1.361295 0.723954 0.647901 1.773634 1.210579 0.738833 1.019675 -0.059702 0.752004 1.494564 1.628786 0.551730 0.826612 -0.121929 1.222271 0.542366 1.067393 0.894100 -0.088997 0.339684 0.354277 1.340250 1.185251 1.701668 0.318583 0.201705 0.498855 0.413847 0.268222 1.464644 0.943368 0.570515 0.929197)
     7.102448 #(0.000000 0.874846 0.874020 0.383400 1.888250 0.756017 0.077335 0.335823 0.069116 -0.025940 1.275212 -0.078764 1.078041 1.479295 0.805292 1.256350 0.745203 1.018548 1.380234 0.724702 0.624764 1.775180 1.216776 0.734076 1.029524 -0.060703 0.737883 1.483175 1.588250 0.541946 0.847349 -0.125391 1.213407 0.539383 1.054778 0.894488 -0.105971 0.339852 0.361281 1.377967 1.208041 1.701540 0.349199 0.207973 0.510160 0.390055 0.277980 1.424992 0.939638 0.580019 0.935273)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
#(52 9.0527429580688 #(0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0)
     8.8599758148193 #(0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.087457 #(0.000000 0.217695 0.815228 0.652105 0.472210 0.034513 -0.067645 0.661251 0.580253 0.051364 1.785056 0.529546 0.204393 -0.248113 1.238820 0.097387 0.952805 0.167446 0.758512 1.718336 0.161942 1.593107 0.882652 0.246677 1.208436 0.995914 0.028887 0.487573 1.153005 0.362942 0.720923 0.863427 0.090963 0.015179 0.082123 0.995009 1.057407 1.708206 0.745582 -0.334290 1.156564 0.740724 0.619550 1.021238 1.501400 1.347681 1.370305 1.480905 0.364029 1.829054 0.147181 0.425026)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
#(53 9.2427225112915 #(0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1)
     9.1345848658318 #(0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1)
     9.127 #(0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0)
     9.037 #(0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.280061 #(0.000000 1.321647 0.124991 0.267301 -0.097572 -0.182250 -0.264318 0.305281 1.510023 0.690643 -0.083761 1.149156 1.615661 1.082902 0.053495 0.729805 0.372777 0.867953 1.622402 1.147465 1.254474 -0.097105 0.284065 0.155239 0.747118 0.191728 0.572524 0.648832 1.863557 -0.077024 0.661631 1.317858 0.017675 1.383827 1.176558 0.383061 0.407564 -0.057445 0.037863 1.268097 0.050462 -0.093915 1.305364 0.606032 1.418849 -0.216569 1.955628 -0.054434 1.046128 1.613160 -0.222178 0.527538 0.279199)
     7.277941 #(0.000000 1.320608 0.123883 0.266260 -0.098726 -0.180951 -0.263113 0.307354 1.509795 0.692362 -0.084460 1.146543 1.613082 1.083223 0.052430 0.729954 0.371750 0.865216 1.624262 1.151576 1.254591 -0.097077 0.283807 0.157287 0.747426 0.191510 0.576525 0.650443 1.865135 -0.076524 0.659368 1.316048 0.013316 1.383629 1.179236 0.382065 0.409609 -0.059453 0.038301 1.267468 0.048020 -0.089572 1.305742 0.607804 1.419408 -0.216409 1.955990 -0.058582 1.049800 1.616185 -0.225681 0.530375 0.281400)
     7.273215 #(0.000000 1.343052 0.104313 0.292254 -0.099809 -0.115744 -0.303393 0.309762 1.568110 0.711662 -0.129520 1.100770 1.602083 1.083618 0.030557 0.757257 0.439398 0.786330 1.619827 1.211602 1.230947 -0.130689 0.250207 0.237032 0.708572 0.165884 0.610782 0.691233 1.953472 -0.061951 0.592191 1.344205 -0.076495 1.318636 1.179553 0.359772 0.385425 -0.145969 0.033263 1.236535 0.044816 -0.007354 1.322911 0.548895 1.412806 -0.236927 0.039279 -0.084552 1.051232 1.601387 -0.195420 0.519143 0.313332)
     7.271553 #(0.000000 1.343135 0.103283 0.287007 -0.102113 -0.119135 -0.299440 0.306934 1.564192 0.708532 -0.127587 1.101288 1.599644 1.082570 0.030040 0.754816 0.434230 0.785436 1.626496 1.210693 1.232434 -0.132579 0.255945 0.230787 0.708125 0.164488 0.610014 0.688544 1.945948 -0.058700 0.591940 1.336609 -0.071792 1.322368 1.176977 0.357916 0.384133 -0.143441 0.029700 1.235899 0.047215 -0.009258 1.321575 0.549885 1.411465 -0.234445 0.035711 -0.088922 1.047606 1.600927 -0.199308 0.525150 0.312914)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
#(54 9.3444428264144 #(0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1)   
     9.025 #(0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.343237 #(0.000000 0.356519 1.378098 0.100713 1.597092 -0.025702 1.221174 1.251558 0.690644 0.974868 0.161868 1.045405 0.521711 0.003817 0.306043 -0.096834 1.232150 -0.099464 0.224397 0.415571 1.740071 0.094513 0.078550 1.542437 1.225294 1.399009 0.336583 0.674783 1.840391 1.660692 0.517435 1.402550 0.393296 0.592199 1.897829 0.665758 0.536805 1.096961 0.623716 -0.026615 1.280422 0.608136 0.821814 1.798315 1.255450 0.438527 0.834992 1.356753 1.200356 1.790553 -0.115951 0.080012 0.586774 0.361501)
     7.341731 #(0.000000 0.356465 1.378320 0.098833 1.596818 -0.023654 1.218823 1.251692 0.691288 0.972560 0.161978 1.045118 0.521354 0.003562 0.307317 -0.097314 1.234937 -0.099161 0.226221 0.415364 1.740269 0.091970 0.079470 1.547113 1.226610 1.398885 0.336150 0.678460 1.841150 1.662881 0.519475 1.400656 0.391672 0.592116 1.898122 0.666766 0.533527 1.098876 0.624484 -0.028163 1.280801 0.610596 0.821449 1.798883 1.252672 0.438494 0.835603 1.353298 1.199447 1.791275 -0.116097 0.078485 0.587033 0.360167)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
#(55 9.3425494397445 #(0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 1 0)
     9.2039985656738 #(0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.418031 #(0.000000 0.371883 -0.102385 1.384110 0.788939 1.172597 1.460679 -0.051584 1.613915 0.238888 1.525865 0.549649 -0.043003 0.333004 0.044794 0.512744 1.722267 1.079306 1.246830 1.284907 0.207450 0.040677 0.202715 0.238687 1.612592 0.166071 0.400629 1.260632 1.623827 0.653615 0.626094 0.034784 0.350367 0.574431 1.183380 0.988854 1.735576 0.588499 -0.354395 1.140552 1.016796 0.000102 1.159353 1.267678 0.628601 1.407149 0.225892 0.684474 0.382309 0.514872 0.105129 1.589405 0.489089 0.324447 -0.112140)
     7.404942 #(0.000000 0.377657 -0.163749 1.307019 0.766445 1.174591 1.554696 -0.065054 1.596223 0.235021 1.487365 0.562129 -0.056753 0.320528 0.088709 0.493279 1.702053 1.159242 1.253441 1.121244 0.218681 -0.012837 0.194853 0.218523 1.612330 0.162538 0.477456 1.220509 1.626107 0.697021 0.606582 -0.002540 0.392884 0.556790 1.119006 0.941328 1.694649 0.609115 -0.343444 1.141359 1.128719 0.007663 1.054168 1.118833 0.641850 1.493868 0.180476 0.692227 0.423391 0.515456 0.123028 1.635448 0.507483 0.365848 -0.081100)
     7.393931 #(0.000000 0.378507 -0.167999 1.303367 0.765000 1.172284 1.557323 -0.069028 1.593115 0.235078 1.482530 0.561149 -0.058717 0.314387 0.094982 0.493767 1.694436 1.161228 1.256150 1.115168 0.221349 -0.016290 0.194457 0.217551 1.610384 0.165550 0.477403 1.224092 1.629992 0.696230 0.613196 0.002173 0.397633 0.549432 1.107815 0.948327 1.688439 0.607705 -0.336957 1.132758 1.135627 0.007272 1.054953 1.105488 0.644644 1.501879 0.180228 0.701215 0.425909 0.523464 0.116797 1.644929 0.498341 0.370645 -0.083698)
     7.388862 #(0.000000 0.380156 -0.171931 1.305953 0.766789 1.172901 1.559612 -0.075057 1.594209 0.233800 1.478965 0.563052 -0.064375 0.315917 0.092488 0.489599 1.684953 1.165576 1.262217 1.111692 0.227250 -0.025739 0.190013 0.217850 1.606986 0.164294 0.472832 1.227464 1.629452 0.697721 0.615520 0.002756 0.393787 0.546726 1.101414 0.952868 1.676931 0.600150 -0.336717 1.126210 1.136438 0.000608 1.053599 1.103228 0.649802 1.498716 0.172656 0.704531 0.425773 0.526132 0.114614 1.643561 0.494086 0.373521 -0.092896)
     7.384000 #(0.000000 0.377170 -0.171355 1.303977 0.765847 1.173036 1.564018 -0.072211 1.588223 0.235555 1.476689 0.559065 -0.064492 0.319345 0.095498 0.485382 1.686734 1.162129 1.270167 1.107241 0.234030 -0.027234 0.192277 0.220076 1.602606 0.164187 0.465725 1.231364 1.629068 0.697588 0.620787 0.005975 0.394481 0.549307 1.099799 0.964361 1.679269 0.595539 -0.332886 1.121604 1.140852 0.005330 1.057829 1.103141 0.657093 1.506149 0.171394 0.709315 0.427763 0.530110 0.119909 1.650065 0.491806 0.378320 -0.092271)
     7.380864 #(0.000000 0.378551 -0.175193 1.300624 0.762558 1.175276 1.564939 -0.074547 1.588074 0.235386 1.476865 0.556896 -0.066849 0.320111 0.097192 0.478953 1.683244 1.161925 1.270025 1.102513 0.235436 -0.031016 0.191299 0.221952 1.599370 0.162880 0.467467 1.233359 1.633245 0.699500 0.616427 0.003933 0.396463 0.543856 1.099953 0.961829 1.677585 0.593150 -0.332782 1.122442 1.143751 0.006167 1.059002 1.097752 0.656783 1.507140 0.168776 0.709153 0.425304 0.531258 0.118299 1.654258 0.491202 0.377929 -0.088468)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
#(56 9.5274312814935 #(0 0 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0)
     9.3816785812378 #(0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.438757 #(0.000000 0.399584 1.080682 1.282815 0.754797 1.304787 1.824143 1.790693 0.691286 0.987316 0.360583 0.349008 0.752988 1.116013 0.562702 1.074532 0.850688 0.844939 1.444388 1.530941 0.255231 1.863387 1.106579 1.310141 1.836783 -0.005007 0.360656 1.658990 1.588332 -0.013412 1.425619 1.827389 0.425917 1.713960 1.019636 1.345889 1.564516 1.246321 1.028804 0.474895 0.129090 0.228469 1.190499 0.208117 1.372797 1.554651 -0.150304 1.292293 0.381212 1.275332 0.867023 1.563695 0.615073 1.736449 1.595570 1.057393)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
#(57 9.5457010269165 #(0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0)
     9.543363571167 #(0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1)
     9.3903837203979 #(0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.498232 #(0.000000 -0.129172 1.380361 0.700320 0.780441 0.090360 1.662756 0.878900 1.570440 1.307072 1.212448 0.971480 0.736973 1.472139 1.503004 1.321091 -0.333336 0.652738 1.407756 0.559265 0.970311 0.614385 1.441684 0.387567 1.768917 0.697588 -0.175161 0.102601 0.178290 1.528309 0.468873 0.084595 0.063505 0.298061 0.525085 0.923933 1.286889 1.429105 0.333843 1.303850 0.808595 0.285713 0.098774 1.284736 0.038814 0.328707 1.274912 0.350159 1.518973 1.572017 0.226187 0.841753 0.707945 0.437563 0.618742 0.866615 1.853272)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
#(58 9.7054271697998 #(0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.6265433375878 #(0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1)
     9.5893135070801 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.600558 #(0.000000 0.520739 -0.135944 1.323686 0.400915 0.909904 0.533857 1.060902 1.237556 1.269869 1.780318 1.589139 0.543975 1.422673 1.606043 0.380912 0.893798 1.363714 1.916308 1.467556 0.484343 0.035905 1.362512 1.052674 0.701216 1.227654 0.054331 0.336647 0.485517 1.190925 1.006530 0.883787 0.199084 0.210890 1.799500 1.041239 -0.101762 1.809564 1.478560 -0.155244 1.422988 0.562288 -0.223688 0.441421 1.097613 0.463947 0.279884 1.513750 0.404962 1.608757 -0.053634 1.500664 -0.269655 0.342883 0.921060 0.214677 1.886658 -0.040125)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
#(59 9.955 #(0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0)
     9.6750946044922 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1)
     9.5173864364624 #(0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.643378 #(0.000000 1.756964 0.515006 1.343849 0.363765 0.378549 0.312840 0.835322 1.267171 0.687404 0.005918 1.887716 1.613832 1.301738 0.410797 1.416006 0.747219 1.294673 1.478405 1.859201 1.711376 0.584699 0.070707 1.974769 0.292569 1.523774 0.763544 0.102772 0.215383 1.156123 0.808543 1.393270 1.010094 1.412165 0.836472 0.254670 0.922440 0.933923 -0.075272 0.189433 1.079606 0.702089 1.223734 1.404309 0.456849 1.626797 1.979675 1.029592 1.497623 1.325369 0.651798 1.380466 0.242519 0.739915 1.552026 1.160547 0.760069 0.930698 1.441945)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
#(60 9.8824768066406 #(0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 0)
     9.6560277938843 #(0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.739591 #(0.000000 -0.033501 0.619177 1.679261 0.721982 0.363648 0.878008 0.753620 0.225391 0.790557 0.189152 0.980066 -0.081610 1.728314 1.754207 -0.082883 1.638402 0.243777 1.229442 -0.466843 1.486892 0.262866 0.775574 1.130741 1.791308 0.031265 -0.171199 1.509590 0.224673 1.282758 1.212715 0.402030 0.299992 1.810442 0.424136 0.139270 1.799454 1.623755 0.488829 0.280451 0.137561 0.865648 1.810471 0.659298 1.194928 1.622255 1.425441 0.549726 0.110141 0.980860 -0.102558 1.102577 1.367909 0.445596 -0.086685 1.609098 0.043088 0.846296 0.673395 0.574626)
     7.717261 #(0.000000 -0.043543 0.600571 1.684561 0.722320 0.365276 0.898920 0.760440 0.237420 0.799852 0.177231 0.980091 -0.082164 1.722522 1.747076 -0.096968 1.637533 0.245814 1.222271 -0.463850 1.487297 0.275317 0.757190 1.138657 1.800100 0.004736 -0.174304 1.515674 0.231338 1.288318 1.221744 0.401221 0.323048 1.801172 0.413376 0.134236 1.802419 1.619328 0.485155 0.285264 0.130134 0.861710 1.813452 0.662559 1.223815 1.624613 1.430619 0.561330 0.100676 0.991556 -0.091888 1.106293 1.347663 0.435925 -0.077868 1.612575 0.063087 0.865799 0.679820 0.564508)
     7.715763 #(0.000000 -0.042788 0.602795 1.680148 0.721955 0.364027 0.894513 0.761479 0.236381 0.801451 0.176852 0.981725 -0.083622 1.720521 1.748351 -0.096212 1.639998 0.247099 1.225553 -0.461897 1.486616 0.276795 0.759617 1.138466 1.798696 0.004884 -0.171091 1.515113 0.231143 1.285422 1.222896 0.402531 0.319870 1.799104 0.412826 0.132684 1.801011 1.618575 0.483378 0.284155 0.129012 0.861247 1.811542 0.663827 1.221591 1.622984 1.428996 0.559001 0.101540 0.992031 -0.090308 1.103974 1.349687 0.436834 -0.074972 1.609682 0.062500 0.865222 0.678405 0.566972)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
#(61 9.9989261627197 #(0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1)
     9.9643812179565 #(0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1)
     9.8069976254571 #(0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0)
     9.6689287776524 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.809490 #(0.000000 -0.347299 0.793707 1.811628 0.240523 0.524836 0.085050 1.161547 0.819582 0.385911 -0.524673 1.681428 0.563219 0.127900 0.046343 1.748579 1.838258 1.071821 1.686561 0.689660 0.261703 1.405419 1.244730 0.500682 1.483387 -0.277613 0.790414 1.382252 0.681797 0.971691 1.011080 0.193345 1.027561 0.848769 0.408905 0.718976 0.066616 1.445358 -0.468838 0.723417 1.209631 0.833117 1.003452 0.842427 1.502443 1.188317 1.639950 0.772570 -0.011154 1.213419 -0.216225 0.125308 0.657417 1.209510 -0.445899 0.104651 -0.062845 0.680681 0.915011 0.960735 0.796222)
     7.792714 #(0.000000 -0.343101 0.788235 1.807129 0.250452 0.515871 0.078884 1.161668 0.818069 0.389917 -0.522127 1.682658 0.557878 0.126877 0.032745 1.749626 1.832283 1.082822 1.695062 0.704172 0.270385 1.399369 1.236448 0.490179 1.475946 -0.283804 0.796979 1.368227 0.662971 0.968794 1.001694 0.178359 1.027742 0.860403 0.408279 0.714470 0.073722 1.455674 -0.474831 0.732973 1.213177 0.821829 1.009196 0.833184 1.504515 1.182845 1.644605 0.781065 -0.011683 1.218709 -0.200932 0.138780 0.645282 1.217009 -0.451601 0.095310 -0.063303 0.680020 0.909181 0.946688 0.793901)
     7.785940 #(0.000000 -0.344035 0.780624 1.808341 0.250309 0.511377 0.080614 1.156775 0.820476 0.392090 -0.519581 1.679294 0.562126 0.124871 0.037611 1.745936 1.825676 1.086555 1.688053 0.704340 0.270700 1.402108 1.232848 0.487597 1.474823 -0.284646 0.795967 1.369438 0.657817 0.974474 1.000398 0.177017 1.023875 0.864966 0.405700 0.718453 0.072830 1.456422 -0.479406 0.735547 1.217599 0.812412 1.022836 0.830688 1.510230 1.175223 1.640030 0.780812 -0.009698 1.223518 -0.208985 0.133118 0.651112 1.217323 -0.447806 0.092414 -0.063668 0.675161 0.911236 0.947342 0.780516)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
#(62 10.200 #(0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     10.048614501953 #(0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1)
     9.8772821666628 #(0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0)
     9.7982149124146 #(0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.893479 #(0.000000 1.929259 -0.202519 0.202658 0.617252 0.268175 1.329217 1.059626 1.406404 0.763068 0.103528 0.007712 0.070200 1.336930 0.731135 0.476774 0.216176 0.314923 0.691629 0.218698 -1.582369 1.885828 0.220809 0.020779 0.003236 0.436863 0.855347 0.244141 1.246469 0.343757 1.267676 1.211176 1.263833 0.833753 0.697185 1.196813 1.483596 0.082094 0.170065 0.104139 1.218481 1.433001 0.210549 0.612879 1.334970 0.480931 0.976340 1.341949 -0.104781 0.788199 0.507699 1.539628 0.219600 1.471214 1.405548 0.863803 0.058269 0.981510 0.951304 0.421504 1.598123 0.871876)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
#(63 10.203475952148 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     10.191082449969 #(0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0)
     9.8550319671631 #(0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.940259 #(0.000000 1.542569 0.171945 0.896148 0.642894 0.569664 0.369784 0.726839 1.008494 0.972836 1.738328 -0.004158 -0.035959 0.494729 1.210873 0.350075 0.373066 1.300277 0.329185 1.037995 1.820481 0.456996 1.842722 0.891526 0.887551 1.532249 0.962499 0.045781 0.641793 0.627595 0.905140 0.151373 0.653657 1.545098 -0.115563 1.891716 1.086127 1.581227 1.501765 1.619898 1.804098 1.473757 0.836941 0.159290 1.814826 0.036670 1.828512 1.001818 1.459834 0.597377 0.807186 1.227622 0.116137 -0.111195 1.333733 1.160589 0.872671 0.149202 1.385936 0.717015 0.438339 -0.057115 0.652632)
     7.922612 #(0.000000 1.542207 0.163798 0.899691 0.637697 0.564752 0.365357 0.716048 0.996810 0.982500 1.731288 -0.005293 -0.038408 0.478090 1.213103 0.363702 0.362237 1.295278 0.318722 1.028975 1.826409 0.464993 1.857240 0.877690 0.875154 1.527304 0.964893 0.056771 0.647930 0.623841 0.899321 0.141916 0.661435 1.535736 -0.126261 1.889924 1.092416 1.583640 1.493200 1.613142 1.801427 1.485352 0.831148 0.156522 1.814154 0.038239 1.842321 1.003502 1.461179 0.605234 0.807007 1.230316 0.117303 -0.111077 1.332244 1.156262 0.885634 0.161495 1.406960 0.709890 0.438698 -0.048522 0.645487)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
#(64 10.559404013831 #(0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0)
     10.301 #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1)
     10.113667488098 #(0 1 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1)
     10.022200584412 #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 1)
     10.0 #(0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     8.063789 #(0.000000 1.101099 0.602034 0.782491 0.697303 0.953568 1.029560 0.116167 0.534482 0.056839 1.177875 1.130699 1.283612 -0.059984 0.623810 0.344036 0.995635 0.096315 1.454462 0.914478 0.627848 0.663044 0.895985 0.021578 0.525686 -0.656147 0.794994 0.316795 1.350578 0.539610 1.703530 0.953234 0.770323 0.217282 1.058758 1.203159 1.048775 0.409086 1.090816 1.638682 0.456816 -0.128952 -0.103400 0.536416 1.625188 0.267460 0.387143 0.504877 0.640085 1.600063 -0.276082 -0.015244 -0.472943 1.570136 0.279373 0.427984 1.349728 1.459025 0.789425 1.021546 0.125635 1.434044 0.285470 0.750018)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
#(65 10.517309434908 #(0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)
     10.169842720032 #(0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.063423 #(0.000000 1.514017 1.477049 1.701599 1.477098 1.169313 -0.075329 1.286913 0.276989 1.468126 1.119589 0.404989 0.067303 0.491026 0.781791 1.701024 -0.020529 0.158627 0.277331 0.576195 1.931735 0.013487 1.631717 1.098265 1.396954 1.592476 0.527632 1.605742 0.711046 1.211603 1.716435 0.235070 -0.346987 0.362548 1.804862 1.235988 1.622218 1.297965 1.428305 0.007277 1.067887 0.026547 0.129971 0.135503 0.797012 1.235581 1.256506 0.828380 0.948896 1.703647 0.203535 0.911377 1.509825 1.310639 0.464424 -0.021037 1.773975 1.041112 0.489609 1.766338 0.167302 1.250383 0.535074 0.908499 0.837807)
     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
#(66 10.212840820553 #(0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.157682 #(0.000000 0.864481 -0.087958 0.952979 0.990806 1.117378 -0.079822 0.799417 1.371802 1.727158 0.176395 1.489530 0.091710 -0.055244 0.768556 -0.182732 1.511445 0.919447 0.529018 0.741118 -0.207254 0.800079 0.010178 1.152014 0.183475 1.472872 1.571378 0.446209 1.663618 1.364506 0.715046 0.828731 0.313345 0.066095 1.516975 1.454528 1.677262 0.265348 0.285413 0.096996 0.990233 -0.034999 1.186591 0.321899 0.654849 1.135127 0.632072 0.949446 1.927164 0.016900 1.513154 0.066336 0.780091 1.101350 1.161809 1.669676 1.820897 1.282518 1.327582 1.730419 1.612974 1.135344 0.869848 1.264996 1.504778 0.959294)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
#(67 10.718281745911 #(0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1)
     10.287303318203 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 1)
     10.209677696228 #(0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.189482 #(0.000000 0.223835 0.709563 0.361631 1.551719 0.569710 0.892711 0.412471 -0.122532 1.384928 0.920338 0.229931 1.448943 0.172890 0.823530 0.990828 1.509979 1.338332 1.208846 0.787460 0.061898 0.478875 0.981296 1.272732 0.373155 1.666130 0.172923 0.490908 1.701260 -0.223436 -0.153385 -0.210376 1.754388 0.900377 0.534928 0.735691 -0.024560 1.844372 0.982693 1.901761 0.736388 0.462828 1.348703 0.713521 0.867221 1.154715 1.565263 -0.077256 1.621203 0.799836 1.222303 0.052403 0.526227 0.481968 0.153640 0.955669 0.588080 -0.054516 0.786535 0.593333 1.327174 -0.007899 0.946668 0.129005 0.631564 0.210690 0.355805)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
#(68 10.698028101377 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 1)
     10.359804316765 #(0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.313178 #(0.000000 0.244343 1.642715 0.935745 0.628088 0.349339 0.336732 0.124857 0.857555 -0.116402 1.447310 0.953846 0.817972 0.894526 0.216338 1.688708 0.261371 0.735227 0.573014 0.775001 1.626527 1.148714 0.406863 0.670940 0.918299 0.604950 1.210229 0.031199 0.141725 0.375232 -0.081240 0.677485 0.378578 0.906117 0.294520 0.392067 1.355911 1.690390 0.718951 1.487329 -0.138179 0.553201 1.536097 0.881957 -0.082538 1.382961 1.427653 1.067926 1.340027 0.840907 1.660791 0.289066 0.274973 1.390968 -0.190181 0.543981 0.061245 1.393573 1.655279 1.916631 0.332779 1.712105 1.020206 0.398966 0.816453 1.294153 0.656319 0.218180)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
#(69 11.012202262878 #(0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1)
     10.744618415833 #(0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1)
     10.636575441359 #(0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1)
     10.452348709106 #(0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.299240 #(0.000000 1.809793 1.335116 -0.212710 0.158753 0.164651 0.603125 1.322153 0.831452 0.183363 1.448673 0.721080 1.066312 1.181872 1.076260 1.013268 0.191732 0.040800 0.486287 0.191971 1.710264 0.131293 0.621897 1.438011 1.135075 0.253412 1.507015 -0.159413 0.582721 0.193017 0.964253 -0.301532 0.293120 1.510278 0.034886 1.510459 0.975161 1.367320 1.238913 0.711944 1.636109 1.055624 0.191284 0.131365 0.923162 1.196510 1.037073 1.867255 0.433263 0.695116 -0.176328 0.235278 1.513915 0.550725 0.590587 0.684660 -0.200846 0.627019 0.987897 1.135787 0.574659 0.584443 -0.132204 0.924754 1.054659 0.926694 0.631260 1.327795 0.666286)
     8.287150 #(0.000000 1.788301 1.283865 -0.243377 0.143266 0.147064 0.583603 1.353517 0.822051 0.190027 1.414426 0.749816 1.060222 1.185192 1.093194 1.015512 0.161763 0.036963 0.497716 0.199845 1.710593 0.157923 0.616485 1.421608 1.168253 0.254166 1.519024 -0.174832 0.580521 0.195896 0.931932 -0.335581 0.290075 1.495789 0.039388 1.508198 0.993690 1.383338 1.230196 0.721038 1.621157 1.080787 0.186354 0.155199 0.911321 1.202612 1.049209 1.889955 0.428940 0.699100 -0.158825 0.279340 1.504069 0.569377 0.588039 0.685787 -0.246385 0.660960 0.985862 1.105698 0.572672 0.607429 -0.158430 0.926470 1.112443 0.938063 0.625090 1.346978 0.671578)
     8.286822 #(0.000000 1.788409 1.282257 -0.243275 0.144332 0.147372 0.582588 1.352720 0.820670 0.189941 1.414000 0.749482 1.059640 1.185143 1.094489 1.016383 0.161516 0.036696 0.497605 0.199194 1.710632 0.158778 0.616819 1.421634 1.168175 0.254077 1.519069 -0.175539 0.581179 0.194080 0.931559 -0.335790 0.288181 1.495548 0.038347 1.508309 0.993101 1.383618 1.230992 0.720738 1.621197 1.080692 0.185939 0.155063 0.909757 1.202469 1.049902 1.890071 0.429591 0.699293 -0.158546 0.279706 1.502937 0.567855 0.587581 0.684816 -0.246769 0.661087 0.986565 1.105766 0.572827 0.606959 -0.158508 0.926574 1.112685 0.938932 0.623827 1.346926 0.670541)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
#(70 11.087729454041 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1)
     10.431521047498 #(0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.399369 #(0.000000 1.041809 0.558998 -0.356095 0.410185 0.900684 1.065151 0.079886 1.674079 1.324525 1.821960 -0.126729 -0.122480 0.934871 -0.019438 -0.259186 0.281052 0.398346 0.793651 -0.106925 0.074709 0.543314 0.801611 0.974564 0.830604 -0.322194 1.089920 0.719797 0.373809 -0.416539 0.459879 0.707878 0.458655 1.815417 1.450694 1.417860 -0.172227 1.250917 0.620934 0.936718 1.279287 0.582055 1.291883 1.822360 0.417697 1.819451 0.644713 1.510927 0.229612 1.474653 0.670958 0.275604 1.324073 1.274402 0.946809 1.379872 -0.425068 -0.128081 1.162357 1.062375 0.760342 0.799273 0.040479 0.941652 1.525445 1.141700 0.969630 1.236806 0.049996 0.718550)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
#(71 11.111848131381 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1)
     11.002258540604 #(0 0 0 0 0 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0)
     10.642364501953 #(0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

     8.544504 #(0.000000 1.192383 0.795808 1.814023 0.056608 0.083907 -0.121050 1.626552 0.286630 0.766728 1.045352 0.813921 0.864758 0.794241 -0.252016 0.298119 1.064468 0.399420 1.532548 1.071264 1.065947 1.441145 1.758062 1.782588 1.457751 1.574983 0.499529 1.425562 0.810711 0.355236 1.084616 1.675909 -0.179044 0.717225 -0.165733 1.115628 1.485185 1.816919 0.012182 0.966936 0.903934 0.282770 0.928839 1.334934 1.757792 1.915789 1.073267 1.033220 1.131276 1.295678 0.674973 0.957907 1.155850 0.411091 1.358848 0.430934 1.032809 -0.242665 0.780401 0.116051 -0.143764 0.882115 1.167719 0.546914 1.849824 0.136356 1.758031 1.431559 1.298153 0.304816 1.714100)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
#(72 11.026193997702 #(0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.912703440154 #(0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1)
     10.880306243896 #(0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.605355 #(0.000000 1.538496 0.528188 0.224102 0.798611 1.667890 1.077695 1.251919 0.236481 1.248046 0.323237 0.802574 1.704665 0.718246 1.482106 1.728872 1.094605 0.405459 1.712545 0.074434 0.493266 0.643511 0.431980 0.576201 0.969406 1.300867 0.905210 1.837071 1.243165 1.100725 0.665435 0.215780 1.699240 0.155038 0.348205 1.558373 0.736396 0.445371 1.125432 1.537966 0.150096 0.661420 0.835098 0.410480 0.664983 0.762141 0.133680 1.168201 1.819381 0.989486 1.005334 1.375496 0.415260 1.297598 0.824824 1.270970 1.112196 0.988207 0.602187 0.364890 0.792911 1.213964 0.087899 0.306864 0.115764 1.421002 1.127294 -0.276309 0.279516 0.344478 0.039173 1.742464)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
#(73 11.087996391987 #(0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1)
     10.907942771912 #(0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.577606 #(0.000000 1.468120 0.399577 -0.018267 1.129749 1.540112 0.080443 -0.225521 0.984350 1.318256 1.725963 -0.015940 0.240457 1.585666 0.066646 0.456005 0.751053 1.114533 0.580701 1.657836 0.496435 0.433822 1.298768 0.600415 -0.190098 0.064658 0.103847 1.339139 1.507511 0.087123 1.469545 1.406973 0.042591 0.416789 0.070338 0.413098 0.972952 0.584179 1.008661 1.214009 0.655088 0.742369 0.248321 0.571683 -0.200036 0.424291 0.202007 1.422478 0.685909 1.132358 0.366535 0.103301 0.284148 1.188052 1.256745 0.599482 0.119285 -0.134695 -0.000187 0.303508 1.738552 0.317055 0.701322 -0.250651 1.419996 1.135309 0.264805 1.507796 0.275630 0.983246 0.282234 1.603893 0.010492)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
#(74 11.4198214166449 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0)
     11.288741871055 #(0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0)
     11.262331896     #(0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.505770 #(0.000000 0.271959 0.303263 0.871130 0.904134 -0.104703 1.438323 1.380312 0.153606 0.874000 1.112738 -0.381121 1.128821 1.800391 0.271558 0.179924 1.245144 0.340659 0.429014 0.985023 0.709222 1.205236 1.196024 0.193210 0.875814 1.373206 -0.208581 0.550691 0.133632 0.785455 -0.009102 0.272459 0.666791 1.782681 1.718095 1.685691 -0.371908 1.897876 1.085596 1.690614 0.839009 1.371639 0.648809 -0.333122 0.227967 1.542904 0.506314 0.141899 1.120242 1.221884 1.118539 0.201184 1.273447 0.940438 0.135993 1.603620 1.099885 1.279633 1.766033 1.155852 1.376417 1.081428 0.676161 0.039331 1.365221 -0.352489 1.294597 1.006846 0.055171 0.246691 -0.270644 0.094155 1.572455 0.920094)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
#(75 11.202813597023 #(0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1)
     11.190553665161 #(0 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1)
     10.942812919617 #(0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.683698 #(0.000000 1.124940 1.810082 -0.048540 0.885185 0.101134 0.938946 0.189377 1.804564 0.801297 1.688153 0.224055 0.930401 -0.034817 0.076145 1.457725 -0.522454 1.353074 1.346269 0.916340 0.092845 0.958076 1.682504 0.027480 0.309688 1.061777 -0.013601 -0.050917 0.351752 -0.000108 0.484661 0.289700 0.926135 0.549821 0.935781 0.557659 0.449714 0.113690 1.820721 0.164733 1.593766 0.791524 1.700317 0.143258 0.971859 1.745798 1.477768 0.014993 0.086193 0.310990 0.869473 1.077134 1.225568 0.295373 1.810290 0.261102 1.605132 1.918757 0.779195 1.750321 0.094238 -0.024202 0.975187 0.766697 0.238490 1.630859 1.240419 0.857804 -0.286669 1.532284 1.412769 0.565085 0.735535 0.956985 0.019220)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
#(76 11.511628975629 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 0 0)
     11.446428749262 #(0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0)
     11.21743106842 #(0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.691930 #(0.000000 0.227276 0.852463 0.798261 1.206049 0.469874 1.014414 1.056681 1.488890 0.859453 1.672754 0.409646 1.266606 0.221296 1.159074 1.002170 0.608039 0.458947 1.540083 0.022303 0.493105 0.973576 0.879272 0.834550 0.404380 0.486092 0.947824 1.355887 0.257317 0.846067 0.109915 1.425777 0.555724 0.041354 1.723813 1.397993 0.430583 0.879698 0.485460 0.867599 0.227712 0.037324 1.528474 0.162632 1.848376 1.951430 0.307077 1.592204 0.961903 0.990102 0.524891 0.905010 -0.015454 1.132349 0.700305 0.574546 1.532296 1.008896 0.469612 0.935083 1.895638 0.275404 0.376082 1.374586 0.447984 1.724017 1.362390 0.115529 0.873605 0.708290 1.589815 1.522961 1.650538 1.546135 0.099896 0.795639)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
#(77 11.623893901139 #(0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.38523739395 #(0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1)
     11.302083969116 #(0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1)
     11.192246437073 #(0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.738911 #(0.000000 1.735390 1.596183 1.688158 0.936460 1.171580 0.505377 0.087525 1.862148 1.431401 0.594847 0.469813 0.196922 0.535307 0.536063 0.953652 1.327262 1.042995 -0.239454 1.283974 0.373825 -0.231495 0.842073 1.180351 -0.200754 1.452179 0.278091 1.438428 0.651650 0.579116 1.359926 1.185874 0.646945 0.889845 1.929037 0.820540 -1.753498 0.788440 0.134659 -0.052264 0.029418 0.734290 -0.032548 0.116885 1.060915 1.618492 0.727618 -0.211968 1.156442 -0.079189 0.326736 0.907689 -0.005226 0.152753 0.054647 1.883310 1.223284 -0.341320 -0.253047 0.094276 0.965735 0.643481 0.075505 0.256644 -0.263207 1.005258 0.117913 1.054554 1.077316 1.857353 0.229976 0.488605 0.099240 0.563812 1.742434 0.311603 0.824202)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
#(78 11.455265310659 #(0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.802318 #(0.000000 1.670624 0.812122 0.146846 0.294174 0.693556 0.587537 0.634781 1.067651 0.436186 1.879310 1.122795 0.875431 1.177280 0.081581 -0.171779 0.307696 -0.040349 1.123589 0.453417 0.838454 0.781236 0.260980 0.086805 -0.163582 0.675514 0.678636 0.987481 0.002829 -0.141018 0.519002 0.397540 0.841714 1.116573 -0.056209 0.665263 0.588230 0.601360 1.262779 0.489363 0.951797 1.844032 1.183466 1.520023 0.226265 1.028907 1.744367 1.798831 0.850890 1.303993 1.629043 0.218880 -0.013397 0.760540 0.223307 0.242187 0.497769 1.705174 -0.220494 1.417201 1.258808 -0.026975 1.662089 1.392477 1.011251 0.392762 1.200206 -0.223742 1.247356 0.076980 1.596406 0.650646 1.163958 0.226439 1.049893 0.648772 0.668638 0.239788)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
#(79 11.710210993982 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)
     11.54291004024 #(0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     9.019300 #(0.000000 0.161159 0.069766 1.245082 -1.663996 1.132454 0.793379 0.236735 0.199520 0.768958 0.690238 1.070772 1.318977 1.196527 0.174596 1.494555 0.315415 0.025691 1.304467 1.618472 0.201499 1.335994 0.229519 0.715032 0.631996 0.002248 1.222420 1.376248 1.054293 0.790825 1.192140 1.232103 -0.120973 0.966026 1.061828 1.346696 0.759767 1.112226 0.017812 0.267345 1.182142 0.834654 1.669569 0.189431 1.572185 1.413667 -0.121426 0.959040 0.405245 1.021485 0.075605 0.638948 1.449329 1.313878 1.374454 1.847087 0.376677 0.367060 1.346860 0.315156 0.360571 0.056967 1.209722 1.397062 1.155088 0.087380 1.151101 1.112584 0.549660 1.007032 0.610121 0.708874 -0.071285 0.985505 1.339651 0.986339 0.354263 1.605654 1.163052)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
#(80 12.0 #(0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 0 1 0)
     11.963202476501 #(0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1)
     11.681501776885 #(0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1)
     11.501195907593 #(0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1)
     11.122416496277 #(0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.975296 #(0.000000 0.661832 0.582609 1.535343 0.368813 1.442670 0.288143 1.720507 1.159325 1.205434 0.363832 1.135859 0.398801 0.780442 0.109059 -0.233851 -0.014242 0.866814 1.170313 0.571895 1.728338 1.048867 0.573378 0.186444 0.762977 -0.042956 0.166725 1.469320 0.668773 1.299568 0.889649 0.040495 1.240631 1.108944 0.129800 0.721144 1.067299 -0.108522 0.942423 0.143182 0.363181 1.503391 0.483014 0.839084 -0.130151 0.311957 0.853400 1.290713 1.419147 0.872778 0.357362 1.159105 0.470178 0.822707 0.086509 1.527850 1.188547 0.499837 0.491618 0.911131 1.381265 1.436439 0.098022 0.967860 0.602227 0.287322 0.505081 0.825983 1.366303 1.496619 1.659715 1.944169 -0.046671 -0.166435 1.699946 0.102851 -0.189778 0.020478 -0.353821 1.052153)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
#(81 11.757609887857 #(0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     11.553661099057 #(0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.381307601929 #(0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1)
     11.372210502625 #(0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.994542 #(0.000000 0.154013 -0.316348 0.071738 1.106993 1.468229 0.131212 1.016340 0.347330 0.790110 0.582586 0.573996 1.621030 -0.055594 0.422842 1.432066 0.973798 0.924172 0.517788 0.808823 0.322273 0.477855 1.110729 0.828232 -0.135776 0.453821 0.977388 1.079080 0.813213 1.339889 0.985697 1.418288 1.872633 0.935702 0.560398 1.716219 0.625329 0.674462 -0.191195 1.017852 1.180580 1.259494 1.238203 1.074177 -0.246143 0.408570 1.154438 0.464503 0.237200 0.406748 0.428747 1.803989 0.602651 0.236975 0.696601 -0.007967 -0.109139 1.624732 1.107572 0.212492 1.019018 0.430487 1.302442 1.524648 1.430984 0.088883 0.131497 1.050853 1.025920 0.220497 0.271749 1.730206 1.423209 0.551947 1.919540 0.532335 0.723265 1.045572 -0.032108 1.423657 0.888376)
     8.979620 #(0.000000 0.133971 -0.325879 0.058128 1.116281 1.475033 0.088635 1.009750 0.356790 0.799299 0.624490 0.593664 1.616289 -0.067242 0.372934 1.431140 1.001806 0.880386 0.505977 0.815701 0.344281 0.468214 1.141868 0.829938 -0.170002 0.461248 0.936587 1.075431 0.837609 1.318066 0.963230 1.378111 1.858712 0.911927 0.588728 1.758887 0.624705 0.697629 -0.193269 1.006514 1.201616 1.263814 1.198019 1.079340 -0.267858 0.375758 1.151285 0.480731 0.258408 0.362257 0.458080 1.807940 0.623036 0.213144 0.719329 -0.053019 -0.116682 1.631840 1.109487 0.214661 1.030431 0.439182 1.277276 1.498167 1.406049 0.063731 0.100756 1.056934 1.016131 0.217283 0.289228 1.768181 1.383609 0.560872 1.955323 0.542811 0.720389 1.003976 -0.042309 1.458275 0.852285)
     8.978751 #(0.000000 0.133442 -0.323272 0.060725 1.114679 1.473804 0.089264 1.010184 0.354571 0.798241 0.627718 0.594956 1.616426 -0.067445 0.370170 1.433443 0.999941 0.878691 0.506811 0.816927 0.341781 0.470013 1.141387 0.832036 -0.171466 0.461911 0.937434 1.074597 0.837015 1.318765 0.967657 1.380005 1.862128 0.913359 0.586701 1.759303 0.626415 0.695822 -0.190484 1.006634 1.203431 1.266834 1.197949 1.077990 -0.267729 0.380595 1.150154 0.478725 0.254873 0.362966 0.458333 1.811543 0.623044 0.209843 0.719689 -0.056221 -0.112031 1.630512 1.109177 0.215435 1.027013 0.440511 1.281860 1.500481 1.406261 0.066775 0.100497 1.059738 1.020731 0.214321 0.289590 1.768407 1.382768 0.561941 1.958539 0.543300 0.720294 1.004120 -0.043334 1.455233 0.853445)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
#(82 11.815696616621 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0)
     11.662058134504 #(0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     9.042421 #(0.000000 1.613429 0.890216 0.650247 0.418218 1.544981 1.351274 1.041821 0.736636 -0.052917 1.081786 0.682808 1.700282 0.443440 1.632352 1.476576 0.452722 1.365793 0.061696 0.416085 0.179035 1.612726 0.359782 0.147488 0.040516 0.024699 1.869944 -0.112635 1.097677 0.268033 0.556971 0.475782 1.772405 0.132338 -0.190930 1.845529 0.126807 0.920947 0.992215 -0.284266 -0.218677 0.284711 1.612935 0.566004 0.593993 1.112984 -0.131771 1.759380 0.896818 0.116126 0.882942 1.708811 0.774247 1.351876 0.743857 1.126350 0.329744 1.311156 1.741855 0.539284 0.734174 1.444281 0.266389 1.812979 0.182870 1.519402 1.556083 0.123915 0.153347 0.837477 0.626772 -0.362496 0.925116 0.876296 1.110977 1.503293 1.058612 -0.070260 0.265042 0.422215 0.314116 -0.020861)
     8.956328 #(0.000000 1.643417 0.930734 0.689653 0.459028 1.593622 1.395371 1.072996 0.631861 -0.043633 1.099666 0.636948 1.712104 0.476746 1.634771 1.484565 0.482834 1.313999 0.039060 0.427177 0.212554 1.582973 0.394395 0.162584 0.034735 -0.034150 1.846695 -0.114756 1.176241 0.261099 0.544044 0.481753 1.753535 0.147113 -0.077837 1.852751 0.089577 0.941708 1.042049 -0.248672 -0.246388 0.240284 1.601806 0.604079 0.624166 1.095407 -0.116063 1.788283 0.927447 0.114648 0.912323 1.773105 0.731730 1.312518 0.797511 1.130357 0.376900 1.293915 1.747093 0.588107 0.704443 1.456343 0.248930 1.811513 0.132706 1.579869 1.572933 0.088710 0.236497 0.885229 0.558925 -0.346604 0.954554 0.842875 1.065506 1.508473 1.080853 -0.118242 0.320826 0.502405 0.287435 -0.040363)
     8.948791 #(0.000000 1.646364 0.928529 0.693440 0.460887 1.595958 1.394805 1.076015 0.626935 -0.035751 1.099515 0.631936 1.715216 0.483859 1.634990 1.488401 0.486827 1.309023 0.037548 0.428335 0.214774 1.578527 0.387809 0.163045 0.041178 -0.034336 1.843570 -0.112925 1.175887 0.260055 0.544850 0.480701 1.747090 0.142986 -0.070411 1.857869 0.091286 0.937248 1.043072 -0.244613 -0.249110 0.236774 1.589347 0.603067 0.625259 1.093170 -0.117445 1.790187 0.921893 0.118787 0.918942 1.774733 0.728860 1.304744 0.805082 1.133332 0.377366 1.284792 1.748077 0.586947 0.701690 1.453035 0.246783 1.819209 0.129644 1.576061 1.568360 0.088126 0.240960 0.884392 0.556728 -0.346198 0.948937 0.841328 1.063756 1.503795 1.073970 -0.121108 0.318456 0.509518 0.288220 -0.040604)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
#(83 12.05688291879 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.795211509729 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1)
     11.732900669843 #(0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.107370 #(0.000000 0.835270 1.070766 0.324594 0.180708 1.521614 1.066314 0.570971 1.544859 0.209148 0.988385 0.858708 0.495870 0.425352 1.594189 1.008851 0.620310 1.317094 1.729720 1.466155 0.660122 -0.274303 0.854003 0.212032 0.062313 -0.122891 0.463347 0.374442 1.370005 0.619558 1.616310 0.054785 1.609815 1.386199 1.949023 0.509205 1.445269 0.239075 -0.011744 0.173754 -0.253878 1.826857 0.652062 1.228839 0.039399 0.642567 -0.003758 1.030309 0.749010 0.712883 1.005339 0.826674 0.072984 1.286902 1.640088 0.907258 1.203641 0.823959 0.062483 0.744552 0.606129 0.682347 0.915180 -0.148703 1.749999 0.015959 0.625552 0.690874 1.836891 0.542447 0.107816 1.289411 1.325541 0.025501 0.995863 0.569416 1.194610 0.751797 0.840909 0.832618 0.816495 1.720996 0.199928)
     9.105408 #(0.000000 0.837905 1.072904 0.324368 0.184295 1.517304 1.069122 0.570319 1.545392 0.210606 0.986292 0.862289 0.498149 0.423639 1.599582 1.011412 0.624482 1.318296 1.727190 1.469788 0.663108 -0.277095 0.851493 0.213180 0.063053 -0.121885 0.467512 0.374048 1.370758 0.615862 1.620039 0.051967 1.610885 1.386455 1.953047 0.509459 1.449382 0.234978 -0.008785 0.166382 -0.257114 1.831570 0.652824 1.226541 0.039884 0.644892 -0.008557 1.034498 0.743282 0.715743 1.003139 0.825556 0.067494 1.288519 1.643253 0.907913 1.202416 0.818474 0.059978 0.749557 0.604237 0.682081 0.917032 -0.156287 1.745699 0.021442 0.625191 0.686611 1.840109 0.544796 0.107766 1.290472 1.326859 0.030333 0.992087 0.566603 1.200687 0.753756 0.836194 0.836363 0.819465 1.721461 0.195247)
     9.098442 #(0.000000 0.839572 1.074098 0.324921 0.180873 1.518224 1.071608 0.572848 1.544103 0.208707 0.988181 0.862080 0.497301 0.425505 1.602983 1.012766 0.625086 1.316448 1.725429 1.471562 0.661237 -0.273288 0.850910 0.216989 0.065921 -0.124476 0.473030 0.376843 1.370353 0.617187 1.623533 0.049665 1.611932 1.386692 1.955490 0.505504 1.447189 0.240009 -0.006708 0.166903 -0.255242 1.834944 0.654286 1.229426 0.040813 0.641985 -0.009213 1.031854 0.749665 0.718158 1.006079 0.824983 0.065384 1.285071 1.646733 0.911415 1.196057 0.818339 0.060266 0.752603 0.606354 0.685039 0.915633 -0.158850 1.743393 0.020574 0.625319 0.683486 1.837454 0.549326 0.109589 1.286323 1.331894 0.025378 0.994511 0.565370 1.200207 0.756063 0.841852 0.838865 0.818311 1.724021 0.197827)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
#(84 12.003616535189 #(0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.724502770898 #(0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)
     11.626023292542 #(0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.263173 #(0.000000 -0.016320 1.973184 1.169374 1.849875 0.832567 0.608967 1.871553 1.827386 0.123062 0.496102 0.959622 -0.000539 1.001472 1.802268 1.208691 1.121411 0.814397 0.608465 0.455541 0.606534 1.302086 1.563147 -0.460730 0.799467 1.757879 1.552438 0.510707 0.442904 0.879144 1.604210 0.335665 1.828810 1.881566 0.873701 0.210316 1.116186 1.555052 0.943600 1.271988 1.011573 1.731869 1.527478 1.060290 0.804706 0.634384 0.033383 0.652087 0.523407 0.863108 0.107650 1.095047 0.312794 0.568246 0.242147 0.054946 0.928314 0.432300 1.132718 1.048968 0.736860 0.984114 0.324606 0.311659 0.975292 0.025172 -0.470048 0.478237 0.522809 0.276511 1.248570 0.889811 1.428301 1.433484 0.259033 1.109021 1.287522 0.162643 1.450125 1.888807 0.347945 1.132503 1.380355 0.438804)
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
#(85 12.48290348053 #(0 1 1 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     12.309050256429 #(0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)
     11.829360154975 #(0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.353589 #(0.000000 1.062584 1.974507 0.608443 0.359786 0.411786 1.661456 -0.028715 0.210937 0.873240 -0.059884 1.657858 1.581829 1.238215 0.536159 1.437517 -0.031102 1.293736 1.866925 0.834699 -0.375618 1.277667 0.903381 1.153848 1.876213 -0.444848 0.884017 0.277843 0.770722 1.710188 1.570201 0.627960 0.896388 1.326751 1.064012 0.342962 1.448176 0.981887 1.749804 0.392723 -0.401994 1.686496 1.545365 0.549190 1.373092 1.132788 0.680954 1.375558 0.681657 0.407214 0.845644 0.198826 1.051408 1.109983 -0.149865 0.022369 1.355476 1.413985 0.178634 1.766333 0.534910 1.614543 -0.059502 1.003867 0.316441 0.599270 1.040099 0.395452 0.092270 0.153942 0.548461 0.755956 1.371414 1.087311 0.323880 0.319537 0.299601 -1.847088 1.101468 1.070178 1.120305 0.670136 1.280313 1.530576 0.114287)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
#(86 12.300269991896 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.274354058598 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)
     12.140432277993 #(0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.398907 #(0.000000 0.705469 0.427835 1.637982 0.061577 0.723983 0.775333 1.213958 0.673955 0.191237 -0.034643 0.369731 0.647523 0.480344 0.747244 -0.053932 1.740985 -0.425730 0.395850 0.272203 1.347231 1.653055 1.447653 0.338387 0.525490 1.701418 0.588177 0.945880 0.835314 -0.048045 0.835140 0.985577 1.412670 0.148280 1.484922 0.880897 0.366136 0.559943 0.254912 0.327286 1.856098 1.156292 1.693251 1.752343 -0.272463 1.243030 0.420624 0.931525 1.429965 0.611611 1.233825 -0.144495 1.068145 0.667757 -0.026517 1.562509 1.907152 0.911441 1.440415 1.183903 -0.108879 0.528208 1.251635 1.847758 1.600133 0.414245 0.059739 0.413562 0.879645 0.159609 0.371270 0.815080 0.281107 0.553620 0.148459 1.708116 0.886074 1.241416 1.194420 0.554734 1.849850 0.704675 0.063044 -0.036534 1.044823 0.566389)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.3274
#(87 12.733045578003 #(0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 1)
     12.481803894043 #(0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1)
     11.937030388359 #(0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

     9.401467 #(0.000000 1.284004 0.784369 1.387463 0.594585 1.403798 0.619627 1.084772 0.963852 0.814530 0.106339 0.227008 1.231747 0.842795 0.694052 -0.291296 0.405925 0.569187 0.767739 1.358815 1.825672 0.200551 1.132871 0.480291 0.800280 0.608803 1.553239 1.365053 0.722494 0.856576 0.946966 1.591187 -0.059040 1.033606 0.474244 0.412313 0.136109 0.759312 1.576754 1.677523 1.162569 0.892982 0.713765 0.359716 0.651517 0.358747 -0.064433 0.133454 1.080119 0.154469 0.831139 1.144518 -0.565948 1.287001 0.300469 -0.328174 1.225022 0.501021 -0.039512 1.576506 0.418970 1.984225 0.200258 1.748909 0.768382 1.405825 0.669027 -0.283931 -0.075376 -0.636660 1.585905 0.363904 0.579985 1.231522 0.359706 1.078442 0.091968 0.210537 0.891673 0.243248 0.318340 0.696129 0.838218 1.272772 0.628451 -0.269209 1.151461)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
#(88 12.652858832418 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.592202186584 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0)
     12.128922775356 #(0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.374166 #(0.000000 0.683143 1.184346 1.603088 0.932241 1.495288 1.667150 0.438774 1.206520 1.113628 0.640173 0.163748 0.681157 0.335294 1.298404 0.448249 1.029206 -0.036684 -0.240776 1.391343 0.201134 -0.056881 1.009737 1.516185 0.930881 0.483971 0.921785 1.240958 0.636868 1.834218 1.631346 0.596388 0.526080 0.594877 1.940642 1.315665 -0.042700 0.611697 0.305291 1.504152 0.784185 0.766276 1.802874 1.820106 0.043145 0.206121 1.398090 0.795809 1.759875 0.165211 0.225300 1.353262 -0.198378 1.618287 0.955837 0.943272 1.582833 1.189148 -0.462950 1.449064 0.416978 0.098372 0.381884 1.328909 0.077113 1.165026 0.925880 0.457446 1.327030 0.654601 1.331357 -0.042995 0.959468 1.203640 1.293054 1.843013 1.400333 1.489951 1.502059 -0.490348 0.120710 0.439928 -0.038327 1.002285 -0.127460 -0.108202 1.634599 1.683607)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
#(89 13.0 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.521632157997 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0)
     12.4725522995 #(0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0)
     12.362 #(0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.377504 #(0.000000 0.054834 0.829530 0.145221 0.421266 0.764833 0.349149 1.212123 0.144398 0.742358 0.560343 -0.049216 0.476585 1.547515 1.010781 0.255859 0.279279 1.116407 1.468245 1.321424 1.212072 1.200524 -0.193772 1.629519 1.436179 1.186230 1.116370 0.535144 1.278945 1.437979 0.174974 1.401957 0.493331 0.557237 0.175215 1.884868 0.920494 -0.028641 0.379436 1.204356 0.686946 1.785681 1.065198 1.989751 0.879149 1.028614 1.434442 0.552236 -0.140257 1.285831 1.125671 1.255905 1.378880 0.310793 0.378475 0.763354 1.062858 1.712477 1.689018 0.917160 1.316803 0.357480 0.638064 0.318895 1.050348 1.477982 -0.707041 1.294279 0.603067 1.218237 -0.316345 0.400534 0.503430 -0.088968 0.161285 1.133055 0.760213 1.924600 1.332651 0.887901 0.901255 0.893994 1.101471 1.646197 0.864775 -0.068467 0.313848 -0.207240 0.470312)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
#(90 13.064256668091 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 1)
     12.44910044225 #(0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1)
     12.309 #(0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.510523 #(0.000000 0.758042 -0.054694 0.811880 0.761526 1.962723 -0.083244 1.053429 1.104472 -0.109216 0.937640 1.934646 0.897694 -0.126299 0.506296 0.359410 1.053820 0.091346 0.762136 0.742704 1.389725 0.618145 -0.219023 1.630783 0.754322 0.266215 1.441909 0.620122 0.234893 0.616837 0.660831 1.498764 0.998798 1.035328 1.113532 0.821990 -0.270132 0.795919 1.445665 0.244993 0.731299 0.815056 0.735003 0.920760 1.770960 1.628052 1.555348 1.090727 1.750098 1.453904 1.038033 0.772409 1.025806 1.301509 1.506752 0.390104 0.632396 0.358268 0.682164 0.608589 0.147662 1.018801 1.379351 0.167187 0.413327 0.954108 0.835458 1.961105 1.093313 0.141085 0.089670 0.098091 1.305209 1.482012 1.810606 0.378853 0.174115 1.905916 0.832232 0.069140 0.579561 0.064074 1.474377 1.386413 0.673245 0.953543 1.240323 0.412327 0.521503 -0.323035)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
#(91 13.107619285583 #(0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.7095674403 #(0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0)
     12.351367950439 #(0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.517071 #(0.000000 0.116931 0.970464 0.965784 1.786481 -0.104910 1.031285 0.179536 0.745209 0.251101 0.791489 0.042267 0.013101 0.973355 1.079119 0.142745 1.329378 1.291486 0.057536 1.710925 0.765837 0.120948 0.005924 0.244411 1.228533 0.572040 1.491525 1.466867 1.685676 1.529194 -0.014875 0.591882 1.207272 1.749940 0.671185 0.269410 1.026054 1.556473 0.986325 0.698807 1.002196 0.819681 -0.094679 1.575348 0.989949 1.356162 1.541673 0.638391 0.478663 1.062002 1.211443 0.321970 0.307459 0.083077 0.547336 0.849975 0.855714 -0.135740 1.397339 1.227185 0.874884 0.696862 0.523700 0.957928 0.774798 1.746360 1.000622 1.415682 0.490824 0.948885 -0.042497 1.842632 1.048212 -0.194279 0.706176 1.137567 1.172946 1.669103 1.348792 0.824941 -0.178877 1.188802 1.721503 1.038427 1.175879 0.619800 1.588361 0.422945 0.279855 0.380800 0.167005)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5917
#(92 12.42142723142 #(0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1)
     12.280749613899 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.634525 #(0.000000 1.247446 1.319207 0.950587 0.452425 1.876206 0.264256 1.666127 0.609610 0.925207 0.662099 0.333582 -0.153680 0.881276 1.494863 0.970017 0.309421 1.936947 0.649117 1.350210 0.130162 1.705484 0.180095 -0.329571 0.688864 0.823313 0.836461 0.550355 1.015927 1.250913 0.470321 1.158648 1.136391 0.068808 0.276366 1.685759 0.747571 0.029705 1.438875 0.797500 0.408569 1.171600 0.281505 1.247889 1.007486 0.704625 1.577580 1.467729 1.032037 0.625462 0.048570 1.324714 0.603308 0.834711 1.050809 1.566897 0.024238 0.603450 1.645371 -0.014035 0.366682 1.130775 1.449842 0.781178 1.467666 1.076926 1.054439 0.698728 0.588754 1.190422 1.575009 0.895428 1.292113 0.793515 0.876154 -0.102684 0.885130 1.735654 1.667490 1.792386 0.304239 0.539130 0.807323 1.407339 0.523480 0.332608 0.151888 0.484842 0.086933 -0.044276 1.851457 0.611953)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
#(93 13.111316272074 #(0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1)
     13.078753471375 #(0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0)
     12.587555885315 #(0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1)
     12.403578299298 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.822547 #(0.000000 1.397907 1.230130 0.668638 -0.127925 -0.166071 1.012709 1.295178 0.909842 1.030492 0.368243 0.926136 0.788893 1.839950 1.499009 1.463814 0.506359 1.242952 1.719331 1.096963 1.614923 0.175641 -0.142982 1.551626 0.788085 1.193027 0.525508 0.486577 0.184534 1.406102 1.517136 -0.333528 -0.081708 0.236483 -0.114236 0.947467 -0.082448 0.522091 0.226532 0.132740 -0.032060 0.909086 0.249207 1.726365 1.576513 -0.072367 -0.201191 0.697267 1.891195 -0.005393 1.825586 0.797124 -0.173159 0.701413 0.955565 1.408674 0.345171 1.292886 1.681852 0.422694 0.732385 1.186514 1.749761 1.855408 1.239998 1.430283 0.943961 1.773486 0.757919 1.438537 0.320533 0.100790 1.069439 0.407057 0.215010 0.731047 -0.201736 1.410334 0.140587 0.117434 0.862483 0.934566 1.627772 0.884522 1.392359 1.156673 1.559646 1.771905 0.825475 0.161152 1.312555 1.398735 0.942213)
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
#(94 12.792093608509 #(0 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)
     12.789479876738 #(0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.926277 #(0.000000 1.408236 0.855509 0.882774 0.630503 0.642086 1.130310 0.416741 0.874497 0.356241 0.789438 0.547290 1.486176 1.720832 0.643867 -0.339645 1.373807 0.730889 0.939196 0.040518 1.036344 -1.802189 0.521604 1.556687 0.175360 0.074306 0.644538 1.308330 -0.002342 0.396875 1.519031 0.243990 -0.131487 0.582258 1.212364 0.129075 0.583055 0.463612 1.296247 1.060621 0.927032 0.844809 0.785386 0.841503 0.978899 0.874850 0.057548 -0.064850 1.155018 0.218260 0.773815 0.339885 -0.140192 0.434056 1.362180 -0.021382 0.214020 0.814343 0.611888 0.176243 1.669842 1.369627 0.692350 1.416748 -0.047682 1.437737 0.546148 1.050339 1.110134 1.887185 0.112070 1.656797 -0.097977 1.581545 0.369988 0.371235 0.861004 1.518383 1.089170 -1.913009 1.767710 1.280715 -0.090192 1.300752 1.568334 0.014890 0.875429 0.709139 0.559907 1.104174 -0.096583 1.584003 1.448777 0.763876)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
#(95 13.132 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.981590594561 #(0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.858592033386 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0)
     12.575266058635 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.766551 #(0.000000 1.305371 0.072105 -0.379317 1.644169 1.509707 0.879319 1.133990 1.484710 0.349362 1.012468 1.377372 1.792175 1.147321 0.643214 0.986769 0.284981 0.281992 0.352619 1.195819 0.156649 1.657724 1.090923 0.339412 0.735766 0.208052 0.110018 0.847498 1.401058 1.299427 0.616564 0.217961 0.327468 1.756609 0.862846 1.045424 0.106023 0.597053 1.438389 1.196689 0.828739 1.785055 1.131191 0.847919 0.771617 0.402166 1.698963 1.235833 1.051641 1.456541 0.145180 0.638130 0.742197 1.071565 0.853311 1.619762 -0.126568 0.081526 -0.366906 1.701624 1.001601 -0.194031 1.100553 -0.103693 1.147626 0.037573 0.875820 1.501720 0.078242 0.085548 1.195959 0.998398 0.261973 0.961143 0.661391 0.879954 0.745535 1.142076 1.364642 1.539562 0.066375 1.431239 1.915804 1.186098 -0.163350 -0.299812 1.287124 0.464752 1.359648 1.187932 0.548102 -0.071507 0.994302 1.030334 0.091644)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
#(96 13.232 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     13.00986051659 #(0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0)
     12.956554412842 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)
     12.803173065186 #(0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.848509 #(0.000000 0.532299 1.551561 0.277924 0.111472 0.262158 0.979774 0.169100 0.326655 -0.015235 0.573742 1.898393 0.651227 0.946335 1.346372 0.112448 0.303472 0.455385 0.745914 -0.004552 0.846126 -0.145122 0.609423 -0.144150 0.338604 1.304191 1.465712 0.375141 0.580068 0.185382 0.362862 1.357391 1.829181 1.535355 1.239897 0.654227 0.787708 0.062126 1.036184 -0.136954 1.656906 1.855309 0.148835 0.366962 0.473220 -0.089206 0.687423 0.836314 1.711478 0.770922 0.570067 0.591691 1.406196 1.131478 1.817338 0.824578 1.734648 1.268754 0.618486 0.695930 1.041795 0.985922 0.568895 0.054591 0.298505 -0.365288 1.210457 0.453510 0.692872 0.602675 1.441808 0.916229 1.250730 0.151859 0.275531 1.174411 1.750829 0.014065 0.707742 0.253193 1.489647 -0.383903 1.412445 1.456166 1.488345 1.274547 -0.062568 1.518447 0.802217 0.484473 1.652296 0.801542 0.288020 1.801701 0.185648 0.889189)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
#(97 13.340280990563 #(0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.954301727663 #(0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0)
     12.837450993031 #(0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.908417 #(0.000000 0.431077 1.515482 0.054320 -0.083060 1.485605 0.284339 1.278973 1.578470 0.517197 1.647412 0.190782 0.762927 0.965430 1.916437 0.969768 0.720572 -0.331541 0.044205 0.743759 0.293286 0.923233 0.598354 0.782102 0.583413 0.678205 0.319384 0.637984 1.466597 0.130734 -0.141766 1.616943 1.791399 0.410783 1.370469 1.176646 0.197182 0.372771 0.580596 0.537403 1.359190 -0.196138 -0.323700 1.708294 0.219663 1.704787 0.532203 1.850438 -0.114427 -0.188949 1.638869 0.545226 1.457448 1.226960 0.724808 1.940971 1.667443 0.960042 -0.004518 0.107150 0.277340 0.648929 1.149626 -0.049493 0.215509 1.729136 0.662507 -0.010818 0.665784 0.560313 0.538803 0.867756 1.720020 1.653110 0.990133 0.727693 0.128193 -0.155102 1.199834 1.697761 0.636433 0.309768 1.364956 1.791368 1.621481 0.886892 0.411810 0.752734 -0.001318 0.587080 0.572992 1.025564 1.526296 0.844584 1.070604 0.597584 -0.110638)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
#(98 13.53905582428 #(0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.128762135265 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 0 1 0)
     13.062 #(0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0)
     12.972 #(0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     10.041603 #(0.000000 1.081951 0.822630 -0.045978 -0.256881 0.976452 1.712734 0.884845 0.581899 -0.176025 0.022020 1.701752 -0.036061 1.388371 0.731055 1.602331 0.458696 0.729181 1.545164 -0.123101 1.014594 1.556143 1.119676 0.549522 0.010363 1.665103 1.647772 1.564544 1.540723 0.671888 0.100539 1.209262 1.202402 1.198564 1.275535 -0.138844 0.834634 -0.087258 0.775755 1.032037 0.291503 1.394642 1.041705 0.132007 1.180888 0.351946 0.751443 0.900146 0.441935 0.637009 0.990149 1.283683 1.517584 0.345385 -0.231388 0.130309 -0.397039 1.542670 0.182385 -0.012664 0.118632 0.932819 1.073089 0.714960 0.910068 0.685325 1.708155 0.366179 0.367843 0.740304 1.342496 1.438555 0.680162 0.415164 1.030089 1.216253 0.752964 0.131560 -0.253153 1.122509 1.526881 0.614186 1.361597 1.180983 0.580253 0.708237 1.236459 0.044048 0.833144 0.243361 1.377357 1.611426 1.486604 1.791281 1.790226 0.227751 1.038879 1.572361)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
#(99 13.792359352112 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1)
     13.577017376954 #(0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1)
     13.046126365662 #(0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     13.000000000002 #(0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     10.117316 #(0.000000 0.480738 0.094999 1.487729 1.322270 1.025540 1.160121 0.131999 1.105208 0.706566 1.402344 1.658138 1.438662 1.520278 1.827075 0.425564 0.358262 1.212927 0.994260 0.119963 0.806067 -0.631582 1.089314 1.430212 1.341223 -0.046463 1.355553 1.211227 0.493326 1.452827 1.783695 0.133028 0.661082 -0.268151 0.685502 1.420668 0.102385 1.161665 1.006807 -0.115080 1.524930 0.527663 0.614478 1.370106 1.632264 0.479802 1.153895 0.605805 0.384979 0.155340 0.852045 -0.258582 0.435282 1.238019 0.070941 1.299425 0.271410 -0.239169 0.677967 0.427984 1.123482 0.969881 1.112348 0.874737 0.235582 0.886565 0.554918 0.235788 0.745853 0.642994 -0.160772 -0.168551 1.805419 1.273181 0.478336 -0.001441 1.904115 1.324684 0.518612 -0.035511 0.440382 0.292254 1.367185 -0.344900 1.092552 1.644593 0.151789 0.571107 0.991986 1.166765 0.940416 0.751498 1.158879 0.522421 1.326566 0.054784 1.195223 1.295297 1.072284)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
#(100 13.916926312979 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0)
      13.24493912033 #(0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0)
      13.117680368039 #(0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      10.230825 #(0.000000 1.024941 0.898750 0.722381 0.475307 1.535505 0.523315 1.113341 1.771270 0.523051 1.394219 0.680737 -0.280243 0.532731 0.796394 1.078708 0.170623 0.090284 1.307576 0.035015 0.750558 1.419655 0.047013 0.150595 0.289834 1.242517 0.606241 0.333290 1.832803 1.134900 1.005448 1.041529 0.426243 0.116098 1.482270 -0.007122 1.553676 1.766504 -0.121393 1.782972 0.875434 1.500324 0.686370 1.699664 0.369284 0.820049 0.316063 0.097620 0.332992 -0.144352 0.643975 0.144824 0.852860 1.173564 0.289978 0.956151 0.298542 -0.394363 1.908566 0.480701 0.463222 0.409345 0.662053 -0.056905 0.761239 0.594164 1.647334 1.140117 0.472329 -0.165645 1.195089 1.584012 0.391171 0.548044 1.260238 1.383102 1.316887 0.161189 0.186009 0.371309 0.383644 0.304180 1.262110 1.751683 -0.160225 1.046529 1.907404 0.520494 -0.138808 1.371784 0.211322 1.435242 1.256575 1.049378 0.249966 -0.425532 0.777676 1.056834 1.035417 1.130586)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
#(101 13.462674500314 #(0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1)
      13.28250751675 #(0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      10.046903 #(0.000000 -0.089763 1.523396 -0.106133 0.944573 0.620202 1.377647 0.439372 1.425613 1.356086 0.661032 0.135688 0.191846 0.890619 1.002619 0.445886 1.504230 1.207741 0.500700 0.903449 0.417390 0.884693 1.134860 0.560794 1.843279 1.731562 1.700889 1.523091 0.370999 0.245966 0.362748 1.563073 0.841907 0.694332 0.414231 -0.040376 0.893373 1.817813 1.672556 -0.431972 1.582816 0.030271 0.973669 -0.346984 1.831408 0.129311 -0.100660 0.613519 1.270960 0.324668 0.540290 1.876115 1.205386 1.778934 0.554608 0.939545 0.166026 0.268052 1.003884 1.657246 1.370522 0.967522 0.829124 1.322942 1.294043 0.335230 0.282187 -0.072124 -0.429651 0.473323 1.546141 1.779507 1.031407 -0.256904 1.489466 0.036539 -0.055417 1.246659 1.629869 1.393476 0.678594 1.087784 0.606406 1.490950 -0.059973 -0.098351 0.662146 0.348207 1.543479 0.641425 0.308024 1.412530 0.169371 0.720921 1.867977 1.297091 -0.212019 1.810737 -0.133402 0.444295 1.394429)
      9.997232 #(0.000000 -0.103212 1.550728 -0.110599 0.979368 0.639386 1.379969 0.410134 1.418129 1.383938 0.695047 0.166531 0.162436 0.866524 1.018737 0.426200 1.498479 1.196432 0.500174 0.916312 0.402881 0.920422 1.120259 0.573939 1.891738 1.738635 1.711957 1.549849 0.387975 0.225356 0.409585 1.535627 0.819706 0.732893 0.459626 -0.057073 0.872711 1.776059 1.695593 -0.439936 1.643523 -0.022818 0.929384 -0.404822 1.867331 0.106732 -0.070922 0.649782 1.236875 0.352861 0.541981 1.855009 1.192844 1.790359 0.545262 1.013566 0.213212 0.275280 0.979706 1.627273 1.366046 1.009915 0.809926 1.351043 1.267467 0.268879 0.305911 -0.110279 -0.464923 0.472048 1.529764 1.800241 1.015487 -0.280177 1.487234 -0.020377 0.004957 1.286004 1.644804 1.404665 0.699153 1.153573 0.597678 1.475982 -0.051817 -0.105043 0.674217 0.365450 1.531205 0.658106 0.279493 1.436280 0.096662 0.739081 1.888921 1.349760 -0.203939 1.841016 -0.163733 0.416219 1.379646)
      9.990273 #(0.000000 -0.103261 1.551689 -0.106365 0.982709 0.641488 1.374974 0.404901 1.419395 1.381273 0.692730 0.170389 0.163315 0.873466 1.021006 0.419164 1.505185 1.198052 0.500229 0.921687 0.402096 0.918041 1.123883 0.571960 1.893612 1.736056 1.719711 1.549107 0.391084 0.225297 0.411403 1.533444 0.820553 0.733262 0.456509 -0.060734 0.873892 1.777713 1.694072 -0.437061 1.636225 -0.024301 0.930406 -0.402962 1.873950 0.101804 -0.071018 0.651149 1.235664 0.344657 0.543747 1.848278 1.187686 1.784786 0.537188 1.010839 0.216202 0.270360 0.978834 1.621905 1.366680 1.012803 0.809752 1.350005 1.264731 0.274186 0.305176 -0.106456 -0.465317 0.469683 1.535517 1.800710 1.014885 -0.286733 1.486075 -0.015447 -0.000524 1.292544 1.638650 1.408795 0.692338 1.154279 0.593364 1.477675 -0.054927 -0.093958 0.675613 0.371872 1.539091 0.661045 0.277231 1.435201 0.092819 0.740928 1.890046 1.344568 -0.208154 1.843774 -0.156548 0.415849 1.386195)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
#(102 13.701085090637 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)
      13.159336831147 #(0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.140793 #(0.000000 -0.229617 0.172026 0.112864 1.779965 1.514819 0.691339 0.534706 0.467893 1.143322 0.607869 1.640585 0.565378 0.496028 1.760060 0.913508 0.723881 1.276699 1.866275 0.295575 -0.254951 1.332486 0.684335 0.653959 1.047149 0.529057 1.799171 1.159538 0.067279 0.364036 1.044032 1.327131 1.318399 1.408496 0.574525 0.284252 0.179317 1.419136 1.670408 0.333457 0.195098 0.780697 0.255817 0.802170 1.078392 1.038637 1.589150 0.844458 1.354914 1.044204 0.136194 1.306618 0.550305 0.815017 -0.099393 1.275216 1.398323 -0.091960 1.086866 1.991480 1.524072 1.653941 0.907669 0.935918 0.540850 -0.182560 0.288266 0.443192 1.318796 0.005767 0.923023 0.920569 0.580737 0.730902 -0.310538 0.087187 0.713741 0.532155 0.771701 -0.048732 0.421255 0.202898 0.498034 0.164858 0.610957 0.624820 0.151230 1.763491 -0.103103 1.029934 1.596064 0.001427 0.924024 0.957896 0.485303 1.581631 0.965908 0.565355 1.131889 1.931709 1.633305 0.606986)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
#(103 13.551587266363 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)
      13.142812158651 #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.168531 #(0.000000 1.402262 0.390984 1.499485 1.313607 1.147732 0.692998 1.120347 0.496669 1.460754 1.449668 0.084461 1.588684 0.392787 0.213884 -0.062145 1.632734 0.377039 1.334216 0.206141 -0.197229 0.898931 0.228959 1.182027 1.762695 1.221298 0.896145 0.188843 0.416276 0.501312 0.054420 0.825865 1.279867 0.961295 0.656148 0.137858 1.568590 0.495997 0.831373 1.847500 0.251311 1.104471 1.198906 -0.050567 1.242664 -0.045544 0.683930 0.505964 1.089093 0.651840 1.811556 0.349401 0.738311 0.582424 1.004810 0.126191 1.055201 1.137010 1.337411 -0.026831 1.067466 -0.192191 1.371924 0.990625 0.493989 0.568246 0.383517 0.879501 1.848268 1.565590 -0.148568 1.223874 1.413067 0.258781 -0.457032 1.318003 0.593281 0.683947 1.541394 1.249979 1.839212 0.921716 0.877955 0.240218 1.522931 0.967608 1.071890 0.152969 0.910066 0.759704 0.550783 1.462973 0.246988 0.705636 0.812567 0.923483 1.112980 0.598411 0.974719 1.130685 0.061317 1.985387 1.825697)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
#(104 13.622 #(0 0 0 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.301904678345 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.214084551284 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)
      13.176067352295 #(0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.475946 #(0.000000 1.034264 -0.120029 1.262694 1.368873 1.300536 0.054042 1.817693 -0.056800 -0.180350 0.483603 1.303103 1.522845 0.299207 1.072152 0.191353 0.819941 1.591426 -0.005969 1.216579 0.132209 0.790814 0.634302 0.937402 -0.324582 0.537853 1.500007 0.747718 0.685856 1.183303 0.655624 1.325389 0.781541 0.870379 0.863653 1.283311 0.867947 1.048089 0.688819 1.790352 -0.011129 1.080550 0.759160 0.775928 0.383127 0.984140 1.193758 0.011420 0.248008 1.044386 1.716602 0.380584 0.981620 1.533101 1.033426 0.209011 -0.012617 0.260827 -0.037006 0.862634 1.945689 0.758958 0.913390 1.519516 1.373001 1.144957 1.412838 1.512255 1.343577 1.124987 0.831931 0.983327 1.911909 0.478600 -0.024278 1.141464 0.071413 0.672771 0.088945 -0.138390 1.383770 0.315274 0.171961 1.195759 1.119445 0.258603 1.574629 0.855465 0.791216 1.391318 0.787759 0.233799 1.583542 1.589038 1.534872 1.781760 0.761360 0.525572 0.693136 1.450937 1.681966 0.492576 0.574320 -0.210512)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
#(105 14.179738044739 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0)
      13.491228801467 #(0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.221648 #(0.000000 0.068203 1.395718 1.083644 0.687861 0.942702 0.643586 0.723372 1.477722 1.611410 0.446862 1.451846 1.613897 0.733670 0.611803 0.898766 1.513768 1.867597 0.350883 1.956552 1.591570 1.515030 0.520177 1.118003 -0.453819 1.636422 0.814682 1.367228 -0.245478 1.332731 1.403304 0.581101 0.875430 -0.302259 1.199879 1.337193 0.947364 0.353909 0.673534 1.615034 0.841909 1.070209 1.455103 1.345994 1.633647 0.219709 1.341427 -0.191302 -0.206411 0.234408 1.670074 1.442518 0.679760 -0.082208 1.126311 0.030913 -0.299587 0.772723 0.070010 0.558118 1.211275 0.943280 -0.085959 0.706171 1.294850 1.186996 0.232086 1.425801 -0.096055 1.797146 1.023384 0.167586 0.635350 0.702860 1.145107 -0.239263 1.361830 0.817387 0.496423 1.186989 0.982737 0.727347 -0.042396 0.509686 1.460082 0.168462 1.551172 0.358655 0.206593 0.981103 1.652127 1.680727 1.454691 0.378918 1.142396 0.321625 1.273114 -0.091463 0.366808 0.185588 0.328641 0.273204 0.366357 -0.164352 1.250870)
      10.198964 #(0.000000 0.064247 1.385316 1.087164 0.688020 0.947488 0.640627 0.727728 1.485689 1.606885 0.446655 1.463230 1.609641 0.728469 0.610768 0.890953 1.511493 1.851404 0.351876 1.967073 1.592336 1.522885 0.516160 1.110256 -0.445962 1.639360 0.811583 1.357540 -0.252436 1.338788 1.396833 0.572722 0.877284 -0.303365 1.194008 1.335377 0.948123 0.349938 0.657086 1.611558 0.841043 1.065370 1.450795 1.348185 1.626223 0.226620 1.334513 -0.184931 -0.203549 0.232519 1.662350 1.459561 0.673021 -0.086246 1.123006 0.036049 -0.297185 0.766635 0.075537 0.555732 1.211198 0.936259 -0.088448 0.720358 1.284849 1.182400 0.239811 1.423376 -0.101828 1.798570 1.023366 0.165394 0.629886 0.703719 1.141718 -0.247919 1.357187 0.799814 0.498700 1.188319 0.975104 0.715660 -0.042929 0.505153 1.466161 0.162641 1.553625 0.358126 0.222062 0.981936 1.655089 1.692040 1.439102 0.382904 1.151260 0.315812 1.276971 -0.097067 0.365417 0.178585 0.330527 0.267621 0.366209 -0.168047 1.250199)
      10.192870 #(0.000000 0.063312 1.384372 1.086439 0.684302 0.945358 0.642095 0.724572 1.489181 1.605861 0.449210 1.461912 1.614328 0.722935 0.610542 0.890187 1.513085 1.844156 0.353463 1.966071 1.593301 1.526519 0.522510 1.113977 -0.439345 1.638405 0.797486 1.355105 -0.255746 1.339037 1.396457 0.571655 0.873681 -0.305117 1.200537 1.335227 0.949159 0.352487 0.654704 1.614195 0.841539 1.060210 1.455080 1.348910 1.627499 0.228142 1.329739 -0.188034 -0.200956 0.237959 1.661858 1.458479 0.671755 -0.084937 1.122471 0.025425 -0.291339 0.765119 0.080334 0.559106 1.206004 0.929365 -0.089206 0.719279 1.289436 1.187059 0.233841 1.424446 -0.096978 1.801004 1.014600 0.173925 0.630554 0.701096 1.141457 -0.244831 1.350965 0.801662 0.499860 1.187650 0.966455 0.716418 -0.042838 0.498374 1.473096 0.163606 1.550290 0.361961 0.223757 0.982662 1.653466 1.696386 1.443212 0.385979 1.155039 0.315577 1.275138 -0.097552 0.370438 0.172582 0.331487 0.265687 0.367633 -0.161193 1.254543)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
#(106 13.492804348903 #(0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1)
      13.091135978699 #(0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.292134 #(0.000000 0.810475 1.033482 0.550694 0.184882 1.297239 1.661161 1.167427 0.653962 1.155880 -0.117293 1.007879 0.642013 0.700634 1.522209 0.093964 0.118360 1.189116 1.681308 0.560938 0.507175 1.259013 -0.294203 1.738922 0.876156 0.157191 1.264238 1.135688 1.199355 0.268997 -0.233823 1.797328 -0.057653 0.963253 0.370744 1.107202 1.708749 1.444814 0.351633 1.290274 0.324094 0.285112 0.301000 1.136974 0.387817 0.901660 0.343419 0.673908 0.864742 0.961904 1.054553 0.082074 0.677455 0.709940 -0.010277 -0.001559 1.717900 -0.032390 1.355783 -0.043158 1.719512 0.049870 1.037079 1.106304 0.325726 1.215582 1.524725 1.745123 1.252031 1.617458 1.551681 0.207463 0.541297 0.662701 0.057061 1.699055 1.353228 0.340712 1.668569 1.375789 1.332979 0.289056 1.855486 1.162714 0.926262 1.664853 1.144741 -0.058810 0.099760 1.361997 -0.241533 1.019775 1.429797 -0.022629 1.813910 0.625118 0.001802 1.374735 1.210000 0.203619 0.854706 0.077140 0.257839 1.375323 0.181331 1.652287)
      10.271435 #(0.000000 0.820273 1.066396 0.583402 0.192883 1.250319 1.682159 1.171181 0.681767 1.127098 -0.100470 1.006906 0.669311 0.718493 1.521670 0.106314 0.103259 1.176128 1.706630 0.519764 0.481287 1.315302 -0.310944 1.724029 0.908784 0.194295 1.230327 1.120031 1.153386 0.281420 -0.224812 1.795179 -0.079057 0.979449 0.420459 1.115413 1.731622 1.448892 0.339819 1.309962 0.311546 0.261757 0.334242 1.188917 0.360576 0.888348 0.366241 0.652850 0.875215 0.955773 1.049946 0.141514 0.680544 0.762852 -0.041218 -0.033690 1.712522 -0.055808 1.401464 -0.005650 1.762081 0.090872 1.010261 1.116637 0.320760 1.232171 1.581197 1.758825 1.295134 1.620603 1.544819 0.243649 0.577472 0.716783 0.031780 1.717275 1.373437 0.329551 1.665503 1.368029 1.300265 0.340533 1.907645 1.149096 0.926168 1.715792 1.153850 -0.066233 0.073290 1.388787 -0.227996 1.042181 1.453125 0.006688 1.819924 0.638807 0.026610 1.384624 1.227832 0.195921 0.852566 0.090208 0.259805 1.389529 0.206802 1.649577)
      10.270846 #(0.000000 0.819165 1.068752 0.583908 0.193268 1.246632 1.680630 1.168493 0.681515 1.119941 -0.103583 1.005783 0.671557 0.715469 1.521683 0.100050 0.103928 1.177788 1.706211 0.520642 0.487117 1.315232 -0.310270 1.727651 0.907859 0.195037 1.229054 1.119869 1.152686 0.282011 -0.224722 1.796458 -0.080301 0.980885 0.424151 1.117927 1.730879 1.450803 0.340809 1.313348 0.310943 0.257235 0.336745 1.188642 0.362171 0.886119 0.364003 0.651269 0.876388 0.956443 1.044360 0.139906 0.683371 0.764369 -0.035602 -0.032529 1.711134 -0.057775 1.401260 -0.006722 1.765680 0.094171 1.006063 1.119062 0.319911 1.233788 1.580745 1.758932 1.294949 1.619289 1.547561 0.246759 0.578580 0.715653 0.029566 1.719637 1.377564 0.331648 1.662851 1.367436 1.299842 0.341815 1.905510 1.149747 0.921856 1.715496 1.152941 -0.067907 0.075487 1.389444 -0.225447 1.044800 1.457795 0.003916 1.820320 0.642746 0.023596 1.383278 1.227376 0.196685 0.853371 0.087277 0.264363 1.394060 0.210839 1.646463)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
#(107 13.864 #(0 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1)
      13.762476921082 #(0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1)
      13.722554538648 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1)
      13.537808159641 #(0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.564685 #(0.000000 1.442175 1.714218 0.024813 0.730244 1.477796 0.212396 1.793928 0.270982 1.436933 1.425689 0.127181 1.470763 1.592296 0.109544 1.661733 0.129864 1.268207 -0.231060 0.165683 0.789503 0.120281 1.515600 0.722604 0.861210 0.284618 1.170853 0.497879 0.007694 -0.069463 0.250328 1.661666 0.683306 0.091404 0.005311 0.810871 0.896219 0.870627 0.327870 0.872352 -0.070917 0.900991 1.907068 1.702029 1.262354 1.452413 1.543830 1.851235 1.337845 0.441569 0.484224 1.105428 0.246771 0.075988 0.452082 0.385840 1.493622 -0.199899 0.401164 0.414604 0.037372 1.048729 0.770333 1.770540 0.995159 0.652450 1.523172 -0.206947 0.893680 1.207278 0.715401 -0.199037 0.413755 0.546151 1.910577 0.546285 0.904996 0.603409 1.774117 -0.116066 1.700700 0.450234 0.364439 0.346205 0.011096 0.765281 1.746558 1.167818 1.639313 0.009292 -0.266074 0.634907 0.776120 0.111310 1.816230 0.005991 1.426916 0.125735 1.051790 1.000327 1.771173 0.344467 1.897868 1.949971 1.448781 1.046428 1.450648)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
#(108 13.775 #(0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 0 0)
      13.751863479614 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.584542754139 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)
      13.472808406168 #(0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.406293 #(0.000000 1.853444 0.165967 1.339625 0.623535 0.993422 -0.435000 1.051705 -1.305298 0.768597 -0.150947 1.574742 0.993298 1.773003 0.618536 -0.219773 0.513372 1.070267 1.525944 -0.238250 1.509352 0.364276 0.166977 0.865200 -0.439411 0.580944 0.953531 1.625995 0.296526 1.448246 -0.095677 -1.858632 0.387882 0.276046 0.462832 1.980035 1.787199 1.271279 1.604171 0.357875 0.428413 0.246068 0.836949 1.911944 -0.348477 1.882220 0.968017 0.750913 0.759681 0.355108 0.873494 1.384603 0.872708 0.526108 -0.395009 0.418307 -0.500907 1.112269 1.115501 1.666087 0.358067 -0.483899 1.006133 0.571987 0.934614 0.645014 0.775909 1.191542 0.979462 0.418623 0.533518 1.056806 1.941330 0.123425 0.152561 0.462794 0.911592 0.532095 0.305539 1.441709 0.881869 -0.009356 1.118317 1.115001 1.219134 0.245858 0.674521 1.582140 0.663859 1.947600 1.503964 1.666919 0.435476 1.234883 1.372534 0.142103 0.262261 0.684596 -1.364882 0.562651 0.178530 0.577085 0.236834 1.409709 1.004758 0.345641 1.404775 0.087191)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
#(109 13.889015913621 #(0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
      13.798 #(0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.712744 #(0.000000 -0.122631 1.753336 0.436833 0.453704 1.829495 1.081663 1.255451 0.521091 1.303507 1.204398 1.414721 1.691490 0.140331 0.920105 1.619359 1.074023 0.825667 0.637596 0.773546 0.099787 1.594848 1.256565 0.304155 0.602824 1.316802 0.410428 0.296739 1.276171 0.969599 1.068681 0.560404 0.549078 1.465733 1.172204 1.152179 1.176213 0.312634 1.202143 -1.487915 1.328552 0.249897 0.003810 0.984289 1.096427 0.574688 1.366813 0.690499 0.496665 0.393870 1.320489 0.809599 1.748248 0.435771 0.796130 1.552224 1.489437 1.123537 1.285033 0.675041 1.449935 0.977039 0.038202 1.474324 0.668888 0.083984 0.814875 1.787747 0.548843 0.456033 0.123470 0.337210 1.370167 -0.235331 1.610983 0.172074 1.635245 0.944265 0.614020 0.051557 0.270858 1.472766 -0.123660 0.667610 0.800181 0.976585 1.491190 0.855510 1.303823 1.096929 1.145931 1.907986 1.217941 0.580133 1.028008 -0.076763 0.475882 1.390663 1.255236 -0.221159 0.631367 1.043835 0.420976 0.910816 0.797859 1.737982 -0.188767 0.011574 0.171562)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
#(110 13.816418806615 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.75 #(0 1 0 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
      13.576010454591 #(0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.461826 #(0.000000 1.595493 1.136304 0.922027 0.386040 0.083768 0.665092 1.222882 1.644688 1.443081 -0.274470 -0.074757 1.665441 1.223501 1.365287 0.028045 0.059500 0.631391 1.593962 1.257425 1.427888 1.404926 1.082188 1.204899 1.409151 -0.317922 -0.204164 -0.263206 0.378480 0.176297 1.933898 1.164209 -0.414109 0.507337 1.227766 1.532342 1.519271 0.975238 -0.105706 0.766783 1.358601 1.531223 0.821349 0.478701 0.747612 1.821774 0.179361 0.724758 0.913540 0.186340 0.367727 0.022290 1.469492 0.515440 0.505152 0.909759 0.032270 0.600161 1.433900 1.126651 1.475620 0.795769 0.801024 0.167153 1.157008 0.049059 1.160907 1.515451 1.624651 1.744556 0.542862 0.268045 1.730002 0.525513 1.390582 0.517818 1.020301 -0.650183 0.848573 0.347117 0.386743 0.157248 0.084442 1.120038 1.509647 0.727803 -0.109245 1.359937 0.278567 1.060748 -0.088458 0.980213 0.066107 1.720969 0.442198 0.008038 -0.647051 0.971838 1.646129 -0.250533 1.753056 0.879333 0.412980 1.291610 0.858393 0.759239 1.227102 0.087704 0.052262 0.681925)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
#(111 14.376 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0)
      14.114 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)
      13.709900383304 #(0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.706926 #(0.000000 0.061875 0.397989 -0.144662 0.557681 -0.106239 1.114440 0.911387 -0.331115 0.078640 1.583233 0.014655 -0.047399 0.918827 0.888663 1.874354 1.474690 1.301488 1.511467 1.646293 0.136549 0.267571 1.957911 0.926052 -0.078395 1.638090 0.704843 1.825046 1.492976 -0.058997 0.913704 0.870986 0.557202 0.547575 0.070643 1.586480 0.829607 0.866682 1.222577 0.666205 0.334146 0.865159 0.333048 0.051439 0.568078 0.072509 0.940531 1.188601 0.165766 1.298967 1.313795 0.109766 0.909888 1.702862 1.590200 0.425391 1.437553 -0.182804 1.728746 0.603013 0.143642 0.161199 0.123802 0.988186 0.696595 0.468927 0.426097 0.363838 1.726729 1.379896 -0.235008 0.046851 1.425945 1.466027 -0.106864 0.421495 -0.009249 0.643024 1.392736 1.913771 0.775136 -0.034587 -0.065666 1.642139 1.767288 0.409867 1.544938 0.686857 1.544277 0.529076 1.255817 0.320781 0.508603 0.874253 1.206557 -0.097165 -0.067888 0.061964 0.329536 1.687111 1.247926 1.199691 0.065184 -0.176759 0.560442 1.091173 0.162705 1.258456 1.543257 0.792801 0.446572)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
#(112 14.528804585299 #(0 0 1 1 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      14.383410482601 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0)
      13.92684841156 #(0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      10.820741 #(0.000000 0.414304 0.106262 0.809513 0.330582 0.804601 1.429044 0.280538 1.478466 0.682441 1.181995 0.988431 -0.004766 1.724597 0.259892 0.852900 0.709660 1.600976 1.255224 1.278691 0.949251 -0.092569 1.737118 1.621944 1.331150 0.643812 0.425780 0.362304 1.117314 0.989322 0.295332 0.013416 0.024744 1.574390 0.752305 1.637729 0.508835 0.959838 0.555045 0.377723 0.132450 0.510706 1.913852 1.736510 0.155154 1.162286 0.887832 0.580311 1.695573 0.896830 0.097438 1.107363 1.041407 -0.000165 0.618563 1.042217 -0.324037 1.501660 0.255596 0.437381 0.397068 0.895929 1.022816 1.269464 0.502766 0.823070 0.264708 -0.338497 0.364128 1.350822 0.474962 0.326256 0.176979 0.303814 0.511444 0.344425 0.607021 1.174789 -0.220907 0.579905 1.131238 -0.082150 1.168447 0.773891 1.460107 1.517829 1.173832 0.455714 0.303135 1.401693 0.114560 0.353025 1.544372 1.158476 0.229098 0.240915 1.541450 0.096978 -0.121740 1.044179 1.125378 1.394865 0.821585 1.561913 1.153476 1.425413 1.681310 0.813806 1.287380 0.661694 1.285159 -0.017547)
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
#(113 14.292 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      14.00348588593 #(0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0)
      13.825498858186 #(0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.714268 #(0.000000 0.826391 0.340897 1.231603 0.281185 1.360627 0.359989 -0.176419 0.849727 1.859846 1.073767 1.810540 1.353346 -0.366643 0.074464 1.641871 -0.182253 0.604179 0.675567 1.081491 0.861656 1.534240 1.684512 1.438158 1.736220 0.865729 1.737018 0.798208 1.154877 0.664851 0.717687 0.903291 1.780468 1.301662 1.449823 1.164801 0.441093 0.318331 1.127356 0.670499 0.426985 0.887536 0.417727 0.613767 0.501312 1.382563 0.421126 0.467025 1.342975 1.363476 1.372643 0.915281 0.403037 1.871616 0.476704 1.715045 -0.013559 1.647304 0.567680 0.680413 0.898771 1.538648 0.770538 0.813378 0.208644 1.545020 0.554732 1.057556 0.304802 1.844122 1.618833 0.732444 0.080115 0.673417 0.927917 1.754678 1.463688 0.171342 0.277180 1.437160 0.810315 0.539759 0.002191 -0.077850 0.051580 1.393488 1.697822 0.495907 1.033713 0.258546 0.964879 1.040002 0.352930 0.782125 0.840113 0.433318 0.412767 0.964654 0.753607 1.054496 1.885042 0.505525 1.427456 1.591678 1.570443 0.772436 1.213934 1.082669 1.930862 -0.132721 0.792514 0.580200 1.270484)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
#(114 14.507795639854 #(0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 1)
      14.388 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0)
      13.974405288696 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0)
      13.920305720092 #(0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.745561 #(0.000000 -0.210357 0.564676 0.359404 0.913773 1.626584 0.718679 0.687824 1.035981 1.565826 0.374126 0.188499 1.735183 0.100430 1.140883 -0.490323 1.481962 1.069450 0.720725 1.574153 0.361899 1.179454 0.510984 0.525476 0.801021 0.759170 0.912309 1.555884 0.437215 0.950259 0.487743 1.822344 0.674389 1.541322 0.883876 0.752883 1.321180 0.318249 1.743803 1.086956 0.267247 1.148302 0.002330 0.484939 1.759551 1.424349 1.747661 1.299089 0.624948 1.608514 1.762967 1.584380 0.998119 -0.687997 1.667925 1.080614 -0.217279 0.152777 0.193713 1.802880 0.769596 0.043067 0.453482 0.737948 0.642979 1.787105 0.652594 1.858944 1.393939 0.999191 1.953789 1.842134 0.069427 -0.055875 1.074162 0.462072 0.728017 1.625944 1.094125 1.140312 0.585763 -0.017057 0.374815 1.438164 0.165894 0.255645 1.419049 1.568101 1.490758 -0.099656 1.796795 0.732987 1.903514 1.357932 1.461532 0.249644 1.630673 0.208778 0.661031 1.242395 1.372645 1.898467 1.467145 1.337736 0.925703 0.504022 0.524923 1.289935 0.239605 1.706071 1.728121 0.764558 1.275663 1.683002)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
#(115 14.773869138996 #(0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 1 1 1)
      14.449532208006 #(0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0)
      14.20306968689 #(0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.922902 #(0.000000 0.840984 -0.243031 0.063049 0.648859 0.632203 0.214491 0.829543 1.123258 0.473687 0.950036 0.445834 0.265200 1.163244 0.913847 0.135028 1.511865 1.369851 0.310831 0.155738 1.543602 0.956873 1.557325 0.022552 0.222716 0.161605 0.831637 1.017057 0.197264 1.300888 -0.316745 0.263788 1.599583 1.096538 1.093216 0.465839 1.239585 0.876232 1.200420 0.696233 0.268726 0.845096 1.401600 0.030217 0.100494 1.803292 0.229196 1.897150 1.168120 0.141148 -0.131717 0.276636 0.213398 0.322406 0.082188 0.022607 0.314060 0.775366 0.299651 -0.001089 -0.417549 0.032852 1.281165 0.246120 -0.327139 1.324789 0.596132 0.091979 0.972752 0.329168 1.140066 1.089367 0.014799 -0.005480 0.047563 1.576402 0.940191 0.775863 0.737318 -0.006716 0.321478 1.570426 1.576351 1.319919 1.440254 0.253068 -0.642478 0.730931 1.429291 1.991402 0.469861 0.613863 1.756256 0.499038 0.777771 0.839054 1.817310 1.194248 1.742070 0.373792 -0.000906 0.981181 0.019664 0.404965 0.463031 1.034022 1.437050 1.678633 1.097957 0.696506 1.002708 0.276197 0.826246 1.021240 0.315904)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
#(116 14.661133289609 #(0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0)
      14.619069099426 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)
      13.887789451571 #(0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.990832 #(0.000000 0.483308 1.870123 1.135804 0.881776 1.543776 0.925742 0.959800 1.206557 0.157522 0.765275 1.305527 0.179590 1.753652 -0.142120 0.825137 0.368838 1.576888 0.742503 1.655416 0.221411 0.173082 1.172117 0.090774 0.294153 0.772403 0.191147 0.548875 -0.120934 0.296752 1.776133 0.206215 1.630176 0.905938 1.526007 0.119822 0.974283 1.532681 1.684339 -0.206959 0.636301 1.456178 0.190032 0.704702 0.488949 0.923296 0.893836 1.578122 1.778414 0.044662 1.318758 1.179643 0.003013 0.985236 0.727650 1.230497 0.502470 0.957220 0.705947 1.540165 1.726261 1.640448 0.129576 0.851087 -0.046779 1.440963 1.097736 1.455777 0.291127 1.238446 1.034565 1.081555 1.456873 1.924640 1.261044 1.237561 0.479763 1.499119 0.343522 1.627329 -0.085516 0.727681 1.731229 0.043013 0.750403 0.701056 0.158874 -0.233570 1.702514 0.279862 -0.068752 1.247258 1.671759 1.508737 1.263823 0.481625 -0.144337 0.295030 0.306982 1.522546 0.906287 0.764511 0.463967 1.755991 1.403214 0.018778 1.300239 0.705304 0.843053 1.543715 1.630033 1.679997 -0.174261 0.000270 1.536367 1.152539)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
#(117 14.63381513714 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)
      14.427604264985 #(0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      11.037769 #(0.000000 0.137964 0.675480 0.160818 1.131517 1.092021 0.723771 1.569504 1.684353 0.598318 1.226316 0.680087 1.714373 -0.259627 1.399954 0.960558 1.372140 0.362544 0.944488 0.039937 0.667426 0.745932 1.453703 1.413876 1.134027 0.818729 0.080433 0.947502 1.351924 -0.058520 0.406758 1.607203 1.706730 1.147281 1.736244 0.502240 0.326382 0.055903 0.022030 1.370695 1.640995 0.134073 0.086849 1.076378 0.580534 1.628515 0.945665 1.124381 -0.362337 0.525801 1.209501 0.827087 0.775197 1.237011 1.584438 1.428350 0.134828 1.743865 1.046538 0.542581 1.246821 0.560342 1.489692 0.883846 0.807941 1.439275 0.824409 0.210415 0.053994 1.740471 1.942155 1.807424 1.511354 1.266302 0.338851 0.393535 0.263333 0.879408 -0.047411 0.705981 0.744599 1.801911 0.044930 1.419224 0.148072 1.720139 0.459947 0.694573 0.332017 1.847351 1.248398 0.061959 1.651879 1.776782 1.525557 0.318321 0.488890 1.052778 1.672246 1.251859 0.346986 0.757273 0.203793 1.413012 0.021139 0.069347 0.124428 0.833593 -0.018404 0.251948 0.269619 1.171170 1.647843 0.374480 1.797783 1.203842 1.317826)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
#(118 14.922 #(0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0)
      14.72793006897 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)
      14.399567650824 #(0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      11.012091 #(0.000000 1.480011 1.791206 1.317972 0.667823 1.060985 0.389171 0.160365 0.377486 1.797135 0.540329 1.478985 -0.410860 0.978816 1.085161 0.585052 0.350877 0.431572 0.268930 0.813766 1.376231 0.370006 1.529775 0.786981 1.538166 0.214135 -0.287817 -0.137665 0.332724 0.966408 0.577642 -0.344356 -0.004296 1.792405 0.621335 0.388650 1.949559 0.790385 1.445541 1.303857 1.783078 1.780124 0.718120 1.682682 0.080756 0.237137 0.451021 0.941003 -0.121972 0.883877 1.322149 1.410348 1.632154 -0.303599 0.556446 1.533535 1.343956 -0.506974 1.540406 0.695569 0.389200 0.951136 1.321144 1.025056 0.038567 1.122603 1.706936 0.621069 1.509223 1.045062 0.608019 0.571780 1.082745 1.795905 0.022436 0.262838 1.974441 0.732706 1.330304 0.327734 -0.017860 1.404263 0.566868 1.320404 1.430562 1.098734 1.170050 1.201259 0.226385 1.437925 1.014109 0.586779 0.951723 0.137834 0.252783 -0.364672 1.125355 0.926415 0.099283 1.319397 1.027191 1.796116 1.319273 1.460922 0.720907 0.863175 1.493185 1.620443 0.976030 -0.284737 1.549533 0.421205 1.520783 -0.201265 0.197766 -0.039088 1.184821 1.841056)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
#(119 15.03294064107 #(0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.647579104049 #(0 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1)
      14.464 #(0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

      11.206045 #(0.000000 1.419767 -0.012038 0.580925 0.872505 0.692523 1.371043 1.730743 1.572303 0.038471 1.639547 1.598556 0.735377 1.607372 0.242556 1.485546 0.920224 0.738712 0.287146 -0.266329 0.399140 0.565476 0.479707 -0.201439 1.570200 0.382674 1.626736 1.511277 0.018284 0.736849 0.092602 0.093643 1.695695 0.122981 0.682440 1.289197 1.006784 0.153299 -0.126135 0.452443 -0.193903 0.998972 1.640481 0.602162 1.122949 0.121712 0.000640 0.144050 0.261232 1.443214 1.298757 1.455139 0.296681 0.859360 1.500930 0.557455 1.467350 1.687349 0.785901 1.234823 -0.078128 0.693136 0.944604 1.005181 0.813814 1.808285 0.921052 -0.096434 1.939541 0.853915 1.297815 1.447043 1.283129 1.255134 1.221865 1.727207 1.258580 1.876334 1.220588 0.183087 -0.154260 0.012891 0.891644 1.429420 0.955077 0.192789 1.382834 1.354000 0.650147 0.442754 1.391625 0.251602 0.415076 0.550256 0.810998 0.899852 -0.062985 1.150152 0.755542 1.794270 0.213876 1.604646 -0.214661 0.108222 1.171838 0.745312 1.698636 1.703330 0.938312 0.051676 1.085729 0.740273 1.463535 1.737180 1.503266 1.007561 1.277970 0.643222 1.783385)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
#(120 14.701 #(0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.672351088208 #(0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1)
      14.578378677368 #(0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1)
      14.530112637252 #(0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      11.080256 #(0.000000 1.602530 1.359004 1.216921 0.319722 1.550366 0.109575 0.144151 0.969125 1.199184 0.920369 1.594663 1.656346 0.819801 1.242772 0.677183 0.644951 1.160759 1.051582 1.210705 0.235042 0.605796 1.428659 1.296079 1.904633 0.711499 0.904090 1.459446 1.862607 0.071023 0.472155 -0.164657 0.285848 -0.239760 0.282408 1.011413 0.605420 0.146094 0.940774 0.211799 1.487192 0.195858 0.520824 1.405869 0.418864 1.066989 1.966162 1.500298 0.608814 0.465602 1.261944 1.234802 0.791744 -0.053748 1.198734 1.480129 0.071408 0.013565 1.333027 0.664251 0.840791 1.323433 0.534236 1.162291 0.616102 0.175852 1.182198 1.711556 0.370380 -0.028137 0.479946 1.859519 0.208500 1.526814 0.739995 1.075897 0.551908 0.245447 1.923134 0.888156 1.428761 0.984225 1.687129 0.094709 -0.000665 0.973570 1.644389 1.605423 1.054161 0.214641 0.317574 0.246435 1.685207 0.983954 0.219164 0.707254 0.431278 0.976742 0.603242 0.694936 -0.072926 1.828922 1.870283 0.357365 0.497193 1.899340 0.681073 0.449050 -0.005727 1.748396 0.516348 1.306116 1.260654 0.311637 1.017677 0.987539 0.422854 0.874208 0.648925 0.015114)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
#(121 15.185772112492 #(0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0)
      14.673 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)
      14.355115628334 #(0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

      11.251755 #(0.000000 0.616396 1.145651 0.448244 1.761234 0.192024 1.606262 0.862349 0.348055 1.176986 1.299320 1.556365 0.505344 1.218624 1.265898 0.933279 0.856541 0.916727 1.161758 0.614744 1.928067 0.111721 1.443155 0.955924 1.271842 0.264505 0.120298 1.090835 1.813127 1.689743 0.391028 0.745365 0.325537 1.569771 0.112161 1.759158 0.591817 0.031537 0.437154 0.155541 1.282148 1.603690 1.297436 -0.042911 0.360966 0.175879 0.480785 0.072954 0.498092 -0.012986 0.589839 0.064536 0.584865 0.623220 1.716464 0.688040 0.773709 -0.048689 0.583532 -0.225163 -0.041259 1.431336 -0.167221 1.810487 1.135295 0.244937 0.798260 1.440149 1.066054 0.903238 0.151253 0.363163 0.554300 1.154564 1.732657 0.106500 0.179440 1.889491 0.798931 0.383142 1.791086 0.608853 0.388150 0.613343 1.182517 -0.041143 0.882164 0.212484 1.013654 -0.164814 1.443794 1.315656 0.517417 -0.160450 0.216250 1.187339 1.211088 -0.153762 1.564433 1.130817 1.878274 1.429911 0.526793 0.338560 0.100965 1.331100 0.339220 0.942326 1.098782 1.625798 1.140704 0.884529 -0.134149 0.399116 0.699562 1.697921 0.765048 1.005095 0.261851 -0.025205 1.419104)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
#(122 15.079724293912 #(0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0)
      14.561 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1)
      14.266534958875 #(0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

      11.246495 #(0.000000 1.245631 1.162837 1.527233 1.113641 0.011457 1.330436 -0.041764 -0.007967 0.382655 1.634043 0.160497 1.252079 0.109803 1.380072 1.832167 1.363414 1.381673 1.671982 1.142331 1.577349 0.065745 1.509838 0.223603 1.283341 0.366969 0.481818 1.266854 1.180148 -0.017504 1.311096 1.532121 1.496593 0.335825 0.202360 -0.482809 0.546887 0.010958 1.361750 0.679290 0.216769 1.604545 0.655670 0.581029 1.462756 0.569601 1.324264 -0.069937 1.680274 1.651840 0.522395 1.541310 0.220902 1.227011 0.532318 -0.353937 -0.238770 -0.488853 0.928347 0.827352 0.023419 1.061824 0.871101 1.270478 0.309881 1.490184 0.833985 1.734296 -0.125259 0.514623 1.167498 0.789180 0.928607 0.752371 0.747638 0.506290 1.671542 0.298542 0.934464 0.183999 0.461499 1.429797 -0.199387 0.557684 0.744948 1.232482 0.580417 1.060463 -0.096660 0.264088 0.045764 1.542472 1.063855 0.977500 1.023406 1.301820 1.681261 -0.056686 0.399820 0.503143 1.518676 1.441290 -0.056598 0.565211 0.352773 -0.012555 0.061340 -0.273158 -0.010289 1.711990 0.681576 0.474307 -0.067198 1.714449 1.240049 0.536606 0.963800 0.892794 1.549811 1.615110 0.777068 0.784197)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
#(123 15.249 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0)
      15.019962594276 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0)
      14.795100232697 #(0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

      11.384759 #(0.000000 1.250375 1.638093 1.086966 0.658382 0.846843 0.405161 0.615402 0.386733 -0.026369 1.721995 1.026231 0.061451 1.882944 -0.005338 0.402508 0.515210 1.186359 1.545807 0.853467 1.488045 0.367485 0.714167 0.051067 0.100578 1.087377 0.496844 0.942943 1.185225 -0.331715 0.124691 0.014727 0.950346 0.956943 1.070854 0.316490 0.741272 0.896410 0.874612 1.578197 0.233741 0.304034 1.733987 0.347933 1.383002 -0.137449 0.832731 0.070192 0.448378 1.013829 0.339511 0.950333 0.291005 1.514992 1.299699 0.818996 1.241667 1.454117 1.752918 0.561735 0.387893 0.621071 0.813016 0.433006 1.548487 1.640182 0.410180 1.072599 1.236529 1.246118 -0.089532 0.986450 1.846205 1.519808 0.469451 0.479186 1.863532 1.521196 1.544448 0.280134 0.470877 0.336639 0.103598 -0.090484 0.814306 0.082853 1.086843 0.176162 0.755825 0.730478 1.554684 0.342884 1.398871 1.469353 0.439863 1.427253 0.989932 0.245396 0.941740 1.150852 0.002136 0.092133 1.736549 -0.389764 -0.108687 0.793881 -0.496038 0.499635 -0.113663 1.260419 -0.585550 1.184958 0.700767 1.656396 1.241261 1.545065 1.199595 0.651157 1.436004 1.574158 0.859605 0.387712 1.229129)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
#(124 15.930208950198 #(0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0)
      14.82254124518 #(0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

      11.416926 #(0.000000 0.723460 0.166879 1.239074 0.427397 0.853546 -0.075003 1.057125 0.435319 -0.640591 0.045342 -0.079915 0.914526 0.741272 0.451741 1.736620 0.038110 0.271977 0.718888 1.459293 -0.368510 0.217107 1.151924 0.489479 1.399034 0.168148 0.233828 1.187929 1.783316 0.664789 0.609273 0.034294 -0.178285 0.653035 0.402717 1.669426 0.550203 1.528056 1.375306 0.286962 1.407903 -0.011825 0.009961 0.925318 1.690169 0.527957 0.021174 0.017170 1.019581 -0.013888 -0.295351 0.760782 0.309956 0.635375 0.685708 1.065410 1.657570 0.044175 0.408312 0.394344 1.062728 0.586544 0.581731 0.161170 -0.403342 1.018291 0.559335 1.106904 1.131061 0.912043 1.104409 1.783921 0.811553 -0.509711 1.673242 1.238184 0.092261 1.313953 1.841521 0.672446 0.100199 0.677194 1.207219 1.385792 0.496340 0.449547 0.863961 0.610006 0.775449 0.169326 -0.190403 -0.338723 0.185599 -0.459463 -0.275919 0.716070 0.272647 0.948934 -0.104097 1.352349 1.571514 -0.177207 1.335790 0.208072 0.250251 1.238009 1.362764 0.709775 0.746154 0.550918 1.709562 1.416034 1.285573 -0.534798 1.435270 0.007139 1.353559 1.510108 0.564476 0.953143 0.951187 0.806356 0.487335 -0.231079)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
#(125 15.409635839002 #(0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0)
      14.833 #(0 0 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0)
      14.82163143158 #(0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.503401 #(0.000000 0.932730 0.020454 0.602478 0.445704 1.765781 1.303976 0.504734 1.010458 0.328786 0.683215 1.709178 1.612800 1.172004 1.315930 -0.034533 0.425707 1.213999 0.415559 1.003129 0.292226 0.499899 0.819166 1.069695 0.004133 0.235471 0.733217 1.438617 0.405088 0.941772 0.718005 -0.204201 1.917446 0.626017 -0.449527 0.955084 1.886234 0.932921 -0.094300 0.308763 0.670563 1.721060 1.028205 1.698074 -0.029921 1.389368 1.376606 1.882382 1.190830 -0.022031 -0.024884 0.081997 0.268694 -0.131962 0.122368 0.271079 0.214541 1.340622 0.846695 -0.047984 1.323879 1.276260 -0.189041 -0.188626 -0.007887 0.081372 0.378631 1.585740 1.402648 1.133031 1.009678 0.028533 0.442132 0.306251 0.924656 1.799292 0.096741 1.629028 0.058173 0.551119 1.222606 0.292777 -0.159025 1.496803 1.112726 1.080061 0.698329 0.082659 0.582344 0.271257 0.542795 1.688189 1.339524 0.162558 1.219458 -0.161464 1.834483 1.096260 0.470864 1.959908 1.409887 1.132229 1.217207 1.694429 0.047349 1.035647 1.979567 0.981595 0.291474 0.349901 1.083215 0.954099 0.244986 1.487293 0.393262 1.127344 0.460420 -0.059706 0.343980 0.513511 0.099425 1.387214 0.908243 0.187944 0.377584)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
#(126 15.556811374771 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 1)
      14.961482935205 #(0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

      11.506033 #(0.000000 1.266121 1.908615 -0.366608 0.823384 -0.521945 1.115330 1.371954 1.172745 1.704962 0.897211 0.975854 1.053070 0.891245 1.122386 -0.188017 -0.396512 0.437547 1.484287 0.595893 -0.008735 0.234866 0.156480 1.510266 0.088044 0.727707 1.281599 1.666574 0.610950 -0.196122 0.082257 0.465263 0.001416 0.791317 -0.287253 -0.143747 -0.132604 1.194516 0.849203 1.249729 0.910290 1.844533 0.084167 1.467108 0.498020 0.858984 1.652790 1.518373 0.190904 0.079888 0.078302 1.903608 -0.147934 -0.046274 0.858075 0.875775 1.724292 1.423719 1.015240 1.953227 0.351650 0.383988 0.343356 -0.000835 -0.103335 0.750725 -0.101707 0.630361 1.069452 0.085379 0.409710 1.275717 1.169644 0.850489 -0.004781 1.603057 0.371773 1.077787 1.107195 1.235167 1.493176 0.863299 1.346491 1.884561 0.396369 0.360168 -0.006038 1.448186 0.399320 1.629697 1.338342 0.671621 0.917412 -0.311833 1.429459 1.280685 1.008590 0.861427 1.669294 1.575964 0.236148 0.245763 1.727782 1.489714 0.966605 0.383522 0.826262 0.429808 1.425319 -0.127594 0.671419 -0.224113 0.948785 -0.049150 0.479472 1.065639 0.749481 1.112281 -1.746268 1.740858 1.133709 1.885854 0.622258 0.730045 0.006577 1.165635)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
#(127 15.055509004493 #(0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0)
      15.018874168396 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1)
      14.695912364919 #(0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

      11.531653 #(0.000000 0.563286 0.849127 0.422032 -0.125775 1.300790 0.955761 0.509517 1.296381 0.317664 -0.080052 1.390132 1.467842 0.388221 0.233424 -0.274987 0.301923 0.546211 1.241123 0.836584 0.325866 1.134782 1.290904 0.216370 0.948111 1.102877 0.193082 0.975895 0.917134 1.861877 0.638104 0.124618 1.576442 1.159573 0.131442 0.684599 -0.059082 1.879811 1.597417 -0.031975 1.295807 0.674429 0.993280 0.575059 1.304510 0.972670 1.186933 1.609821 1.136712 1.624798 -0.143161 0.378790 0.870280 1.266235 0.895716 0.353514 0.648678 0.920766 1.505831 1.758151 0.587786 1.034640 -0.259911 1.644029 1.233026 -0.204073 0.920900 1.558313 1.130770 1.083242 1.126439 1.212624 0.857170 1.678815 1.790734 1.381193 1.385268 0.582973 1.421926 1.193587 0.638798 -0.135870 0.044868 0.021301 0.079377 1.433099 0.340228 0.983048 0.746590 1.117996 0.377123 0.681405 0.506217 0.086128 1.181701 0.460264 0.601461 0.475469 0.014581 1.305066 1.727692 0.788232 0.164313 1.595350 1.003271 1.824572 0.191308 -0.289767 0.788802 0.897077 0.932286 1.698471 1.704891 1.934381 0.379866 -0.051166 0.815438 1.337609 1.267631 1.367122 0.431119 0.864281 1.127105 0.244966 1.082387 -0.093369 1.079540)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
#(128 15.527 #(0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1)
      15.003612518311 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)
      14.876242756695 #(0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.536342 #(0.000000 0.099460 0.679861 1.017305 0.457597 0.754826 0.907482 0.982807 1.665447 1.118787 0.658139 0.587830 0.885804 -0.007757 0.743706 -0.021259 0.225502 -0.455116 0.982149 0.232118 0.453686 1.403265 0.637269 0.499924 1.100407 -0.261963 0.396030 0.153827 0.866530 1.297508 1.570019 -0.077564 0.140754 1.527847 0.857455 0.324059 1.042013 0.740414 0.808730 0.995200 0.234176 0.116054 1.063554 0.680273 1.486116 0.566574 0.901660 0.701926 1.267260 -0.102702 0.846148 1.993686 1.001548 -0.300311 0.723125 1.488775 0.952124 0.604170 1.283554 0.697299 0.605975 1.334293 1.321676 1.260337 0.168502 0.178643 0.984507 0.877372 1.386577 1.462938 0.732017 1.966392 0.589665 0.412565 1.919130 0.426838 0.151191 0.262800 0.513221 1.468738 0.174501 1.345854 0.239976 -0.178660 1.943910 0.245842 1.668020 1.271993 0.762743 0.887384 1.441278 -0.054260 0.576819 0.570504 0.070665 0.032993 1.342717 1.654309 1.442610 0.362253 1.792056 0.336713 0.042709 1.086287 -0.136542 0.645214 0.878180 0.215453 0.476804 1.280053 1.230921 0.848777 0.297820 1.093385 0.890336 1.466071 0.315274 1.881593 1.514888 0.505520 1.051009 0.432769 0.321625 -0.146951 1.504860 1.055377 1.623794 1.507014)
      )

;;; 256 odd --------------------------------------------------------------------------------
#(256 22.546259712247 #(0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
      19.779971 #(0.000000 0.287166 1.811728 0.003647 1.563327 -0.199797 1.748861 -0.027658 1.491523 0.358283 1.786152 0.407453 1.895896 1.702005 0.820432 1.443342 0.126567 0.528978 1.062681 0.144427 1.060071 0.368932 1.288502 1.669328 0.601969 1.609873 0.009521 0.796369 0.509981 1.904275 0.044862 0.614773 1.710675 1.495519 1.692276 1.250582 1.156222 1.594534 0.298597 1.684540 0.924734 0.804943 0.689590 1.177326 0.902799 0.909396 0.954254 0.261017 1.169485 0.938560 0.019866 1.334679 1.574350 0.442405 0.413355 1.552164 0.377894 1.422514 0.243015 0.559434 1.800624 1.468365 1.592498 0.584550 0.034812 0.293061 0.193868 1.089628 1.551790 0.037622 1.190818 0.318859 0.819004 1.851057 0.518624 0.663998 0.448473 0.066841 0.121442 0.912629 1.902379 1.968342 0.338155 1.260192 0.187056 1.823089 0.529718 0.076074 1.893909 1.177725 0.252346 0.193078 1.743428 1.843296 1.581080 0.130352 0.411188 0.552704 1.459730 -0.190870 1.185873 1.213912 1.881537 1.413927 0.390691 0.406250 1.645390 0.152258 0.066573 1.047526 0.945901 1.029638 1.224255 1.274278 1.742960 0.466865 1.882173 1.585879 1.499684 1.765278 0.688359 1.510365 0.729048 1.561332 0.482075 1.161051 0.635742 0.621496 0.237812 1.429801 1.538338 1.807873 0.866385 0.985705 0.165602 0.760224 1.891478 1.496052 0.933548 1.722668 0.466509 0.099331 0.101735 0.991972 1.628542 1.607529 1.751580 1.265628 0.234833 0.306012 1.365655 1.492678 1.262225 1.708575 1.110893 1.962624 1.207292 1.779446 0.254648 1.807960 1.406200 0.343366 1.203432 0.955798 0.389970 1.528111 1.208576 0.010439 0.869974 0.035552 1.208552 0.683287 0.473739 0.683814 1.317711 0.374975 1.738225 0.120217 -0.175098 1.582996 0.867052 0.692109 0.493305 1.718047 1.208498 1.811081 1.821705 0.654337 0.217531 -0.099005 1.010084 0.259226 1.288077 1.708184 0.570772 0.336605 0.604351 0.689981 1.178933 -0.158272 0.131307 -0.014422 0.959472 1.490474 1.313114 0.053727 0.366844 0.481538 1.929683 0.975977 1.124109 1.896357 0.758496 0.888582 0.159146 0.818597 1.655710 0.590078 1.621154 1.243084 0.695850 0.941639 0.608910 -0.136277 0.932800 1.416731 0.412678 0.218232 0.303734 0.129337 1.481931 0.515983 0.719833 1.705010 0.804065 1.067955 0.475270 0.737429 1.074355 1.333884 0.284629 1.317930 1.349354 1.980213 0.481352 1.075718 1.302558 1.547761 1.722849 1.882200 1.571505 0.804632 1.874854 -0.081974 1.014450 0.864487)
      )

;;; 512 odd --------------------------------------------------------------------------------
#(512 35.541 #(0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      31.627573 #(0.000000 0.641971 0.823435 1.073329 0.539150 1.644256 0.942410 0.791472 1.064522 0.907704 1.428794 0.001231 1.342358 1.365932 0.655059 1.273217 0.387305 1.151713 0.464556 0.040873 1.211746 0.565890 0.572488 0.447248 1.881382 0.212994 1.677831 1.225395 1.627225 1.565389 0.526112 0.810610 1.095356 0.987163 1.475014 0.670579 0.628158 0.893664 1.170671 1.124505 0.755854 0.300778 0.869316 0.919963 0.365823 1.723706 1.014851 0.498120 0.637194 0.352754 1.176211 0.866662 0.273392 -0.100029 0.834522 1.417914 0.163216 0.001094 0.094626 0.941186 0.740318 1.686733 0.919502 0.781344 1.668460 1.372868 1.926722 -0.013075 1.859527 0.808579 1.050819 1.202535 -0.065064 1.005084 0.221611 0.092920 0.014314 -0.126624 1.411892 0.640148 1.726499 1.132514 0.613199 0.879500 1.336432 1.600858 0.194537 1.580641 0.936076 1.506791 0.812228 0.638475 1.187229 1.635303 1.915488 0.799069 0.160834 0.881635 0.830638 -0.237466 1.203243 0.069071 1.015759 1.594863 0.741846 0.396797 1.024115 1.576269 0.297798 0.159265 1.736938 1.305428 -0.180384 0.324437 1.638834 1.298223 1.545155 1.094452 0.373838 1.545743 1.267383 0.175106 0.836172 0.339434 1.641107 0.308164 0.618412 0.020865 1.493642 1.738528 0.223837 1.728277 -0.001512 0.572589 0.109109 1.031926 0.299462 0.994195 1.218696 0.638982 0.509796 1.559371 0.148304 0.598851 1.007413 1.005303 1.318366 0.405786 1.262346 1.267264 0.506932 1.133813 0.475700 1.880509 0.789002 0.453480 0.239026 0.227558 1.059055 0.767671 0.566336 0.870093 0.650822 1.420300 0.752287 0.068587 0.289154 0.589494 0.967799 0.716662 -0.136748 0.894624 1.762980 0.374462 0.652941 0.795161 0.405835 0.987008 1.149128 0.792408 1.814055 0.946290 1.372088 1.420931 0.766271 1.803197 0.048647 0.842236 1.000451 1.426188 0.472345 1.886308 0.733469 0.500330 1.201671 0.533436 0.047414 0.185851 0.012020 0.210052 0.058992 0.149168 0.225954 1.275422 1.600178 0.027805 0.734000 1.142974 0.760770 1.247212 1.162280 1.726486 0.314615 0.098353 1.326208 1.035621 0.171545 0.304654 0.998041 1.758815 1.437338 0.710766 0.526788 0.043168 0.406921 0.608124 1.606403 0.893683 0.477997 0.000670 0.488634 -0.069036 -0.061680 0.112820 1.036929 1.548689 0.075054 1.741209 1.196178 0.352973 1.109566 -0.088309 0.774755 0.401376 0.242119 1.087618 0.068851 0.857888 1.221587 -0.019816 1.439372 1.169566 1.554426 1.678997 1.788747 0.784626 0.497675 1.010605 0.845773 1.777904 0.686256 1.393740 1.509084 1.190820 0.403592 1.261550 1.103977 0.536027 1.461863 1.261457 0.063297 0.362984 1.275933 0.945974 -0.109974 -0.203292 0.297974 1.745096 1.406757 0.680111 1.145314 0.780465 1.423008 -0.110897 0.521349 0.893654 1.653106 1.409408 1.732378 1.643879 1.021437 0.297832 0.198983 1.426222 1.445222 0.925063 0.860053 1.108162 1.379936 1.207276 1.543307 0.381530 -0.226848 -0.264262 0.012490 0.992932 0.864424 1.492055 0.915972 1.732040 0.817003 0.307476 1.352170 0.423888 1.329013 1.399071 0.992404 1.355255 1.651646 0.309776 1.671406 1.043917 1.869139 1.594136 -0.005031 1.744908 0.655800 1.327847 1.409992 -0.103359 0.063715 0.768347 -0.043384 1.369031 0.587208 1.037146 1.074892 1.093514 0.744290 0.053865 0.348258 1.204096 1.167382 -0.131176 0.694914 -0.167478 0.848484 1.882004 0.096415 1.570844 0.993590 -0.020994 0.913612 1.588955 0.704219 1.085327 1.546526 0.651243 0.540599 0.940847 0.628133 0.081446 1.846942 0.928486 0.107920 0.007586 -0.062816 1.188460 1.236358 1.495043 0.028409 1.657622 1.712531 1.879651 0.801929 0.276453 0.178559 0.124729 0.356095 1.077818 1.274958 -0.171551 0.461760 0.426529 0.303303 0.286626 1.048164 1.799901 1.036822 1.694543 0.305443 1.309533 1.256076 0.827871 0.345051 1.259048 0.783575 0.662862 0.523535 0.764332 1.439512 1.490591 1.277727 1.771280 0.968938 1.828813 0.616693 0.026985 0.630998 1.165842 1.604957 0.506658 1.643773 -0.010849 1.199100 -0.097492 1.070350 1.825319 1.071090 -0.091097 0.476000 0.246988 0.001741 1.570443 0.157951 1.654163 0.256397 0.418448 0.401357 1.115814 -0.163746 0.006042 1.620231 1.476353 0.625221 1.336783 1.237377 1.107035 -0.011244 0.501244 0.937261 0.874984 1.284656 0.415597 0.001246 0.170531 1.295187 1.042093 1.554322 0.772877 1.325785 1.217688 0.441610 -1.899803 0.043140 1.813774 0.405185 1.057689 0.374283 1.706719 1.083516 0.941168 1.031645 1.166947 0.663039 1.808751 0.239071 1.846075 0.787534 1.538073 1.752155 0.737674 0.162097 1.744119 0.626675 1.785334 0.656878 1.530504 1.882550 -0.066498 0.448671 1.407281 0.142294 0.329252 0.502527 1.533283 1.717776 1.422026 0.012518 1.271419 1.775104 0.652861 0.652894 0.475309 1.835944 1.609988 -0.142017 0.251089 0.591652 0.158013 0.883469 1.255936 0.571626 0.204126 1.716678 1.066841 0.807994 1.069000 0.686395 1.517494 1.291233 1.140441)
      )

;;; 1024 odd --------------------------------------------------------------------------------
#(1024 52.508 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       48.812539 #(0.000000 1.519639 1.650443 1.195998 1.376729 1.899699 1.970244 0.812566 0.904608 0.600090 1.324454 0.983250 1.017466 0.767844 0.473656 1.362846 0.411668 1.143136 1.709002 1.799336 1.634334 1.127351 -0.096953 1.054946 0.631221 1.250117 1.431825 1.462402 0.392219 1.150149 0.361692 -0.007895 1.410301 -0.155259 1.559313 1.025404 0.848567 0.413175 1.206342 0.941843 1.655170 1.899345 -0.179528 1.520982 0.422331 1.843755 0.338626 0.259524 1.219677 0.928668 0.359292 -0.035002 0.292293 1.153387 1.456000 -0.123570 1.766526 1.738248 0.524497 0.103671 1.368994 0.239364 0.976560 1.227616 0.548531 0.854823 0.785093 -0.197237 1.336605 1.539099 0.835663 1.511255 0.962715 0.529653 1.142525 1.602263 1.389138 0.657746 1.560084 0.537641 1.281309 1.646253 0.540975 0.972241 -0.100372 0.678740 1.332669 1.561545 0.551248 1.375355 0.212979 1.193149 1.549790 0.906638 1.351033 1.793558 1.975586 1.399301 1.183386 0.721803 1.068055 0.343392 -0.284674 0.637779 0.099731 1.080489 1.644659 1.671862 0.243661 1.739989 0.343292 0.666143 1.387914 0.983866 0.682169 1.307094 0.441588 -0.079958 1.574357 0.516534 0.821922 0.946185 1.676179 1.618357 1.436315 1.560073 0.444652 1.752148 1.545784 1.140653 1.762060 0.454780 1.132888 1.286946 0.909353 0.217248 1.608014 0.408949 0.982308 0.842400 -0.210310 0.264674 0.498652 0.910983 1.178934 -0.004034 0.340697 0.615753 -0.136166 1.321752 0.263196 1.709158 0.839955 1.174310 0.322353 0.297043 1.553360 1.401766 1.007148 1.677521 0.741845 0.907691 1.276494 0.432523 1.605921 1.143725 1.756996 0.320225 1.288530 0.332776 -0.196583 0.603381 1.336746 0.086445 1.672621 0.890109 0.463938 1.357177 0.922958 0.697499 0.299459 1.219213 1.829846 1.943642 0.749969 0.829949 0.653853 0.398390 0.727336 1.275356 0.674723 0.748253 0.256595 0.201768 1.419157 0.468013 -0.030328 1.410807 0.229406 1.979323 1.794527 -0.016365 1.616308 1.369367 0.712107 1.706465 1.848255 0.226421 1.849134 0.380595 1.411511 0.299912 0.108735 1.186805 0.457520 0.271926 -0.067552 1.609142 1.431855 0.868110 1.197096 1.629939 0.035468 1.862078 0.753638 0.605706 1.277352 1.735611 1.272105 0.935222 1.246256 1.571576 1.870573 0.025272 1.040066 0.940302 1.227315 1.882565 1.396880 0.843794 1.345301 0.792983 1.395248 0.706526 1.661413 0.446114 0.907125 -0.062988 1.049496 1.071169 1.136989 1.421889 0.905366 0.518945 1.552620 0.983677 -0.059829 1.561292 1.006026 0.133199 1.906396 0.441897 1.763764 1.574203 1.360252 1.738862 -0.148160 1.201349 0.701943 1.000967 1.904072 1.310693 -0.020100 0.178949 0.724875 0.252065 0.310697 1.382325 1.227708 0.408125 0.958815 0.649841 -0.077987 1.301784 0.826432 1.474625 0.805014 1.200874 0.124273 0.639817 0.336398 0.230644 0.675556 0.205384 1.219305 0.297402 0.896968 0.099148 1.180783 0.995222 1.801650 1.005890 1.669304 1.555321 0.893841 0.076777 0.821684 0.103460 1.274312 1.641740 0.108476 0.474745 0.106818 1.121379 0.259728 1.241445 0.558062 0.844266 0.902584 1.679800 1.962091 1.160123 1.751210 1.564581 1.787630 0.017232 0.526177 0.946544 1.537788 0.162595 0.274043 -0.044734 0.870207 1.061828 1.973221 0.316719 1.874725 1.919981 0.798782 -0.079217 1.207291 0.982608 0.779931 0.543867 1.919099 1.476795 0.646670 0.139511 1.457573 1.694085 0.629716 1.716191 0.131491 0.664390 0.787058 0.586046 0.644992 -0.006434 1.389868 1.461697 1.509464 1.325643 1.325259 1.204176 1.780741 0.818762 0.535146 0.040136 1.734284 1.577489 0.131655 0.306406 1.644914 1.594499 1.639871 1.971222 1.349697 0.012654 -0.129510 1.611419 0.072394 1.749559 1.734331 0.117738 1.641966 0.797545 0.365172 0.268189 0.523823 1.624812 0.594331 1.509286 0.660606 0.244640 1.683550 0.574769 0.691397 0.958587 1.980250 -0.055636 0.626289 0.244708 1.483613 1.349865 0.598110 1.383298 0.003756 0.637659 -0.080158 0.676783 0.636104 1.458856 0.713675 0.532894 1.606586 0.019165 -0.068957 1.679326 1.139161 0.032928 0.191688 1.041482 0.050956 0.579658 -0.086398 0.011405 1.881689 0.667973 1.016102 0.664665 0.937454 1.751825 1.316685 0.124775 1.792093 0.746284 1.794429 0.643490 0.622783 0.556543 0.160050 0.107300 0.132343 0.640078 1.177660 1.821213 1.816797 0.766212 0.843537 1.824573 0.062901 1.724824 1.075620 -0.018658 1.030264 1.530522 1.314744 1.689721 0.324854 0.383385 1.535095 1.312333 0.745413 1.612902 0.986807 0.028575 0.527696 0.022035 1.685790 0.049529 0.258771 0.934595 1.292434 1.410893 0.805550 0.379555 1.953132 1.889999 0.256214 1.738588 -0.077133 1.023294 0.169218 0.252723 1.382993 1.154004 0.545944 1.321628 0.996409 1.398047 0.279943 0.403421 0.999037 1.888683 1.595423 1.628037 0.559370 1.693110 0.686705 0.382186 0.172950 1.892951 0.773946 0.976296 1.321030 0.111411 1.621968 0.153825 0.547817 1.789581 1.033120 1.189280 1.377718 0.724048 1.497776 0.211222 1.135220 0.266237 -0.119750 1.227078 1.763611 1.286882 0.019319 0.217713 1.199864 0.139524 1.574282 1.464184 1.150806 0.500220 0.119072 0.741896 0.924713 0.317970 0.222493 1.640251 0.523108 0.481320 0.822623 1.781413 0.213174 0.526517 0.784168 0.325984 1.630501 0.652451 0.316042 0.853892 0.706219 0.007041 1.327154 1.456855 1.828532 0.975735 0.357055 1.857690 1.354029 -0.002919 1.867148 0.775657 1.449311 0.258681 1.761863 0.655676 1.286698 0.401581 1.805723 0.089138 1.750159 -0.068260 1.189680 0.106126 0.502482 -0.049569 0.188084 0.806860 1.767305 0.783989 0.042035 -0.089529 1.620846 1.742942 1.638746 1.719033 0.620464 0.165571 1.198973 1.674614 1.772405 0.539545 0.054570 1.607511 1.487697 0.667428 0.150144 1.328158 1.098030 0.732064 1.431842 1.088525 0.593456 1.151458 1.172287 0.425020 1.182693 0.220969 1.859578 1.566433 0.923298 0.977581 0.362573 0.127506 1.222420 1.575324 1.416319 0.704553 0.751691 0.764554 1.478321 0.276418 0.260139 1.048863 1.597529 1.209535 1.071833 1.356900 1.823221 0.498971 0.746938 0.652020 1.900459 0.028526 1.481411 0.327912 1.079162 1.904872 0.898093 0.576127 1.484575 1.189478 1.135242 0.137399 1.126530 0.274352 0.797920 1.009056 0.338346 1.610297 -0.226829 1.631574 0.959330 1.320781 1.954762 1.442338 0.384065 0.746277 0.250366 1.096580 1.790088 0.003760 0.999329 1.147548 0.586431 0.599300 1.667488 1.279694 1.378872 0.759814 0.286225 0.889077 1.344080 1.453847 0.842622 0.487144 1.759146 -0.021070 1.741457 0.255220 -0.087000 0.379022 1.406398 1.296095 1.573207 0.547077 0.266035 1.220016 0.967606 1.841949 1.059298 0.545929 1.503344 0.057557 1.865376 0.175297 0.023235 -0.129818 0.081379 0.343826 0.309096 1.178139 1.234620 0.401212 0.247771 1.242728 0.215679 1.555335 0.391381 0.215626 1.318046 1.403085 1.109228 1.784926 -0.059823 0.366344 1.472272 0.134227 0.905526 0.317002 1.705593 0.778299 1.488104 1.866262 0.311398 1.071911 0.626873 0.238504 -0.012674 1.321815 0.134023 0.680665 0.878893 0.847214 0.978909 1.839554 0.440437 1.381565 0.402718 0.001953 0.405290 1.118864 1.625751 0.595378 1.714297 1.740414 0.774178 1.699347 1.192736 0.295696 1.260521 0.701036 1.140521 0.356675 0.978455 1.370680 1.420406 0.130293 1.653114 -0.018893 0.205569 1.517424 0.446663 1.261641 1.895881 1.784830 1.763404 1.312276 1.486071 1.216977 1.956752 0.167875 1.476998 0.857182 0.633043 1.109241 0.002331 0.823632 0.871605 0.377286 0.698788 0.438774 1.153781 1.232744 0.574432 -0.020814 0.677651 1.865215 0.654114 0.735767 1.621349 1.517040 1.717531 1.731811 -0.054153 1.877084 0.317175 0.457941 0.096350 1.311998 0.489681 1.413648 0.564409 1.706366 0.164517 0.790116 0.629520 1.107932 0.148285 0.249165 0.506282 0.500732 0.232053 1.264683 0.554141 0.156996 0.326906 1.494430 0.478989 0.922682 -0.195313 1.587851 1.760958 0.894217 0.283230 0.952266 0.740249 1.100321 0.880764 1.505061 0.604270 0.704770 -0.047172 0.511816 1.807854 0.422215 1.522333 0.963650 1.304077 1.666527 1.502872 0.589480 1.376377 1.698090 1.158540 0.370463 0.811208 0.347224 0.006019 0.975977 1.784091 1.823852 0.346739 0.110648 0.819458 0.262966 -0.022950 0.321824 0.959696 0.889141 0.219784 1.217523 1.828829 1.188780 0.642719 1.233994 1.041576 0.808517 0.545278 0.807380 -0.100107 1.389803 1.807516 0.153430 1.534635 1.483870 1.199173 0.558907 1.363742 1.066229 0.228446 0.249453 0.894989 0.990075 0.432789 1.489101 -0.125393 1.049266 -0.060522 0.592996 1.108054 0.556959 -0.010652 -0.122495 1.192843 1.419502 1.033551 1.312986 1.654147 1.925127 0.570975 0.668912 0.596661 0.829670 0.124816 1.442843 0.029297 1.031269 1.673783 0.961837 1.711478 0.674847 0.749091 0.236244 0.804937 1.696901 0.928621 0.764829 1.715576 1.230534 0.889448 0.986091 0.837907 1.573717 0.972857 0.317330 0.783659 1.499296 1.172750 0.024671 0.919212 1.526316 1.664955 0.823036 1.671347 0.781608 1.212905 0.794665 1.831645 0.704887 0.663996 1.716970 1.335391 0.027250 0.914860 1.219676 1.163079 1.499094 1.582351 1.784156 1.039722 0.794989 0.345994 0.696063 0.060440 -0.034531 -0.014465 0.729209 1.532895 0.872457 0.952792 1.406826 1.546432 0.813457 0.051863 -0.057923 1.613237 0.606250 0.434442 1.717713 0.718646 1.651523 1.780966 1.568871 1.319644 -0.013301 0.004435 0.210102 0.085420 1.825764 0.539987 0.842744 1.405067 0.388233 0.609273 1.790490 0.014141 1.051512 0.713006 1.582000 1.973531 0.351609 0.656460 -0.024499 1.169279 0.458410 1.325534 0.274793 0.654578 0.624672 0.130134 0.295107 0.020848 0.076070 0.118378 0.940751 1.186130 0.553624 1.471068 1.866328 1.822359 1.955424 1.788350 1.554351 0.750241 0.632195 1.295917 -0.114335 1.180616 -0.008546 1.109797 1.348653 1.327862 1.845807 0.705358 0.002658)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
#(2048 83.108 #(0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       78.937441 #(0.000000 1.689846 1.018490 1.611502 0.639207 -0.082787 1.592906 0.601026 0.457537 0.853588 0.246480 0.384884 1.166407 1.518233 1.610776 0.682841 1.354812 1.022675 1.260499 -0.112300 0.069724 0.538233 1.350546 1.731710 1.788711 0.798385 1.720292 0.552885 1.914312 0.083341 1.189678 1.001287 -0.016752 0.082208 1.635077 1.097941 -0.211066 1.915710 0.755430 0.377368 0.141690 1.508951 -0.063008 0.455045 0.203452 0.898819 1.541895 0.734814 1.350906 1.164589 0.953740 1.385840 0.788728 1.463142 1.354194 0.191281 0.579789 1.257225 0.559072 1.122363 1.468759 0.308060 0.535123 0.171149 -0.035758 0.383213 1.313251 0.349952 1.270535 1.135458 1.334934 1.890883 0.201654 1.594547 1.903186 1.646471 0.951539 1.635073 1.622014 1.631851 1.367584 1.552595 1.728701 0.503153 -0.095067 1.062992 1.535287 0.428952 -0.115113 0.904825 1.834421 1.316028 0.139571 1.862408 1.474241 0.357211 1.399016 0.565894 0.914744 1.336730 -0.021306 0.427360 0.982944 0.246389 1.520693 1.429115 1.795578 1.639579 0.993318 1.397084 1.476412 0.372916 0.127072 0.078109 1.452725 1.376697 1.742105 0.223687 0.910528 1.065049 1.633967 1.318213 0.850379 1.824021 0.982950 1.747574 1.683992 0.758363 0.534234 0.648109 1.761061 1.684306 0.998762 0.599534 0.636315 1.560104 -0.085181 0.292286 0.687333 1.315914 1.968365 0.498146 0.872936 0.750372 1.064806 0.913607 -0.281292 1.049262 1.431464 0.630016 0.070509 0.782794 0.040723 1.266929 0.098300 0.871494 1.325216 0.428614 -0.023960 -0.257052 1.568632 1.612023 0.370339 0.462301 0.888796 -0.048313 0.277648 1.743637 1.021040 1.635300 0.468648 -0.299562 1.640302 0.579774 0.064992 0.038520 0.939604 1.190498 0.120304 0.541286 0.541673 1.009244 1.560773 1.452497 0.646789 1.167337 0.164892 1.045596 1.183654 1.504427 0.689198 0.507543 0.474697 0.285834 0.591708 1.250029 0.879318 1.605841 0.233841 0.888556 0.769118 0.609719 0.005003 1.165066 1.500099 0.895021 0.312884 -0.181818 -0.210240 0.557941 0.168915 1.201735 1.729684 0.438679 0.710349 0.066805 1.172545 1.217293 1.790687 0.425805 0.600925 1.609051 1.095530 0.709253 0.066051 1.122549 0.360681 0.504521 1.391375 1.336403 0.056554 0.787635 0.366142 1.100069 -0.145467 0.490070 0.750042 0.057074 0.500767 1.115333 1.323101 1.500424 1.652321 1.578052 1.424819 1.991538 1.503509 1.341974 0.124773 0.286553 1.512043 1.195123 0.116467 1.495999 0.150475 0.027458 1.256602 1.914178 1.348946 0.392902 1.287852 0.230423 0.958003 0.103199 0.114147 1.300265 1.337726 1.960234 0.875466 1.375678 0.887083 1.091556 1.629083 0.517975 0.251541 0.586015 0.521301 0.456918 1.797111 0.628470 0.222309 1.874302 0.151586 1.270942 0.496347 1.704067 1.347411 0.882141 1.354015 0.482906 0.856096 1.842757 1.198720 0.849675 1.254644 0.826368 1.421665 1.565656 1.849673 0.296163 1.321414 1.594984 0.087468 1.904057 1.770304 0.793373 1.811382 1.738248 0.462200 0.809299 0.173428 1.173632 0.144430 0.424475 1.053220 0.438286 1.053618 1.341106 0.601239 0.987605 0.470342 -0.084584 1.657004 0.844639 0.225215 0.485905 0.210184 0.877181 0.051768 0.365625 0.433545 0.746015 1.265726 1.261056 0.846870 0.380347 1.777246 0.734969 1.263058 1.188062 1.231298 0.176469 0.633541 0.141868 0.355117 1.292107 0.788635 0.283102 1.491545 0.163836 1.840225 0.320653 0.924229 1.684915 0.457135 0.366316 0.874699 0.332267 0.811181 0.009053 1.707102 1.224700 0.647231 0.470735 0.285938 1.249680 0.848736 0.154419 1.302189 0.895984 0.384598 1.149654 1.339615 0.657930 0.197967 1.099859 0.240221 -0.153442 0.545081 0.929453 1.706713 1.972300 1.409127 1.618121 0.006566 0.576765 0.166203 0.440455 0.587109 0.296341 1.125394 1.573122 0.397018 0.779058 0.971743 0.402398 1.799594 0.038208 1.672239 0.269341 0.945851 0.650314 1.220807 0.761092 1.240143 1.289371 1.635050 1.213648 1.046902 1.318709 1.036745 0.879976 -0.197862 1.091013 0.799716 0.415004 0.529374 0.637845 0.383399 0.463124 1.542566 0.699920 1.623643 1.293281 1.800152 -0.015788 0.322487 1.117097 0.956307 0.996452 1.172323 1.326188 1.147377 1.113843 0.785183 1.575362 0.649795 0.523062 1.860141 0.223472 -0.063293 1.909246 1.736574 0.279197 1.477865 0.554212 1.260388 0.277292 1.918266 0.649419 1.792368 0.946606 1.286217 1.246372 1.179007 1.168477 1.733196 0.040035 1.869694 0.417707 -0.156793 -0.001456 0.649687 1.705122 1.327413 -0.139936 1.559127 -0.059925 0.722765 0.854277 -0.012595 0.185935 0.880412 0.884245 1.159530 1.868145 1.721058 1.444300 1.726310 1.551803 1.792034 1.663910 1.037587 0.549667 0.246300 1.919241 0.898305 0.864542 0.391918 1.169414 1.044794 0.943499 -0.018653 0.086991 1.211404 -0.409634 1.709608 1.558102 1.500905 0.023446 0.566640 1.586175 -0.075684 0.457930 0.590761 1.012075 0.155814 1.237055 1.774284 1.163196 1.795167 1.756188 0.853326 0.344718 1.331156 1.207746 1.380685 0.825802 -0.204853 0.528726 1.294224 0.820804 1.714428 1.655171 0.596704 0.807545 0.528328 0.170826 1.360744 1.164118 1.534691 1.959252 0.988720 1.825915 0.954587 1.225160 1.067375 0.648538 0.689203 0.574944 0.228763 0.739069 1.338497 1.522466 1.148973 0.666870 0.301196 1.345073 0.515258 0.304323 1.626868 0.573854 0.770224 0.922824 0.986235 0.208474 0.534145 1.448620 0.464703 0.329886 0.435022 1.080056 1.761027 1.393992 0.840270 0.262735 0.545578 0.566577 1.039111 1.013874 0.439128 1.378553 1.474475 0.078150 0.097586 0.430367 1.040096 0.267498 1.407214 0.720580 1.398352 1.906690 1.573703 0.691050 -0.001253 1.087465 0.916375 1.561718 1.104275 -0.024568 1.743167 0.657410 0.043592 -0.071737 1.277783 1.669473 1.445207 1.805207 1.084871 0.357552 0.482975 -0.129299 0.222610 0.964868 1.674946 1.111144 0.811232 1.444958 0.936872 0.630285 0.291784 0.547889 1.274707 0.491720 1.178913 1.597362 1.417560 0.905568 0.064594 -0.006279 0.681924 0.572009 0.510396 0.882066 1.337806 0.824705 0.900296 0.161452 1.480708 0.429205 0.998680 0.862028 0.872584 1.079492 0.049996 -0.061398 0.641068 1.223042 0.895426 0.016166 1.705578 0.370580 1.235064 -0.076644 0.016159 1.553502 0.272781 1.680527 1.735360 1.216306 0.022477 1.458031 0.335270 1.029615 1.390275 -0.072170 0.673519 0.918164 0.172376 1.873272 0.143937 0.143151 1.946490 1.050878 1.389078 1.718545 0.761876 1.584491 0.076813 0.426127 1.157282 1.665873 1.282022 0.297428 1.612887 1.525788 0.109507 0.850433 1.541619 1.906604 1.351349 0.712067 0.032909 1.741764 1.603154 0.331176 1.967791 -0.047457 0.458334 0.650869 1.822431 1.699982 0.392443 0.889921 0.738170 1.855018 1.469024 1.304174 0.145973 0.241900 0.483690 0.610548 0.244614 0.690385 0.625302 1.254416 1.724031 1.813264 0.692617 0.895372 1.588647 1.665977 1.093177 1.780833 0.040080 0.147953 0.452095 1.815039 0.610101 1.499230 0.418529 1.527535 1.809753 1.780717 1.208619 1.087756 0.044489 1.396951 1.008861 1.166751 -0.015608 1.040863 1.011715 -0.389544 1.669576 1.727841 0.409541 1.391926 1.267091 1.816381 1.266583 1.292674 1.538488 0.792896 1.144202 0.190028 1.168753 0.058544 1.008912 -0.033880 0.982838 1.145292 1.408490 1.218427 1.723407 1.907386 0.024240 0.720236 0.415344 1.872643 1.418392 0.399808 1.547256 0.227670 0.450452 1.674352 0.768133 1.757588 0.207193 1.366841 0.954998 0.102805 1.840467 1.672033 0.946903 0.828078 1.755832 0.884133 0.608293 1.688522 1.454057 -0.091730 -0.218085 1.430139 1.876307 1.361689 0.162513 0.428011 0.099895 1.496198 0.017040 1.527240 1.600076 0.702599 1.227307 0.445765 0.991653 0.193662 0.653609 0.032302 -0.082556 -0.076239 1.247906 1.725657 0.098284 0.458830 0.585844 0.788715 0.476530 1.571552 0.062623 1.411266 1.153636 1.113152 0.388102 1.666505 -0.010299 0.608357 0.002597 0.400810 0.236498 1.574672 1.024283 1.142883 0.739700 1.197592 1.569635 1.120229 0.086709 0.760356 1.446372 0.526550 0.983182 0.898425 1.210298 0.777244 1.126512 0.150391 1.780786 0.777891 1.141635 0.546798 1.666439 1.352269 0.900695 1.494562 0.579397 0.725360 0.320734 0.768538 -0.104320 1.309681 1.358290 0.178735 1.223322 0.916266 0.737696 0.608325 -0.024323 0.252577 0.022089 0.625930 1.055275 1.732884 0.450856 1.338871 0.564340 0.408611 1.468491 1.325711 0.758030 0.859666 0.600947 1.793976 0.169648 1.263140 0.822255 0.174901 0.291032 1.213018 1.398540 1.120993 1.022251 -0.023604 1.740733 1.244085 0.970147 0.777177 1.692535 0.188452 1.351635 1.161318 1.256602 1.751087 0.013196 -0.020020 1.265055 1.092603 1.917020 0.602027 0.227003 1.388828 1.812699 0.448303 0.993327 1.552104 0.642990 0.227204 0.536533 -0.171320 -0.037833 0.286305 1.107339 1.082198 1.823262 -0.118176 1.508469 0.574280 0.745998 0.151052 0.343717 0.754622 0.850362 0.188574 1.308237 0.557021 1.622333 0.740050 -0.106173 -0.036187 0.929924 1.028599 0.128394 0.655953 0.554832 0.478155 1.700954 1.480740 0.692557 0.784791 0.538025 1.181506 1.027617 1.061888 0.554753 1.885562 0.427859 0.878171 1.705383 1.731963 1.584336 0.604257 1.269572 1.224752 0.395571 1.377190 0.473402 1.037091 1.321103 0.241379 0.536589 1.212185 0.436461 1.328625 1.400157 1.301094 0.177789 0.219838 -0.214149 1.529232 0.144458 1.192349 1.282177 1.056078 1.550038 -0.173016 0.100030 0.265853 0.645390 0.923329 0.085731 1.043286 1.818031 1.237997 1.530902 0.423281 0.255900 0.058007 1.501958 0.593022 0.868580 1.054524 0.798523 1.892550 1.536475 1.470470 1.466108 0.333749 0.753592 0.381069 0.805574 -0.083849 0.230417 0.524273 1.576543 0.796882 1.326149 1.468547 0.883022 1.145331 1.129588 0.767485 0.714530 -0.051568 0.381323 0.900830 0.938250 1.115005 0.803678 0.478197 0.102689 1.790473 0.186175 1.138002 0.407343 0.081624 -0.078497 1.907566 0.568199 0.206528 0.698892 1.618703 1.116152 1.630912 0.735694 1.657675 -0.029995 0.597313 -0.074403 1.651119 0.671345 0.428239 0.340794 0.303227 1.221853 0.149125 1.845223 0.690593 1.519544 0.570921 0.378247 1.959188 -0.007756 0.533438 1.355284 0.385166 0.748448 0.519275 0.121959 0.127587 1.048075 1.696453 0.957310 1.509362 1.558839 0.717115 0.377524 0.867385 0.483117 1.383031 -0.097048 1.840125 1.664936 1.781564 0.631422 -0.103132 0.403964 1.771127 0.746246 0.918520 1.169435 0.737263 1.212805 1.178431 0.492576 0.605805 0.341944 1.377818 0.931836 0.529464 1.388507 1.052530 0.254824 -0.081377 0.937911 1.308701 1.681287 1.041637 0.101439 0.808291 0.144335 0.199211 0.907294 1.556385 1.606147 0.993618 0.565487 1.805140 0.626057 0.297878 0.108579 0.333362 0.383693 0.664077 0.780133 1.818635 1.485239 1.804957 1.845173 0.759440 0.296443 1.827938 0.708014 1.691701 0.097561 1.790460 0.002644 1.363152 1.554413 0.128835 0.088458 1.075820 1.662939 0.305822 0.097597 0.951771 0.612277 0.927043 1.564098 1.633525 1.149458 0.821430 0.621419 0.295695 -0.035046 0.526376 1.760242 0.054878 0.643260 1.248458 0.803343 1.623275 0.668091 0.657572 1.121589 1.524828 1.183610 1.417931 1.405314 0.536478 0.777992 1.514447 1.406728 1.296213 0.977414 1.302449 0.188034 0.494615 0.604689 1.593324 0.321907 1.433822 0.820379 0.896724 1.841162 0.648542 0.849222 1.488341 1.646264 0.422691 1.202526 1.552600 1.286227 0.205148 0.977204 0.071457 0.072226 0.854723 1.474934 0.490317 0.994710 1.695319 0.149264 1.945845 -0.050080 1.100174 1.428384 0.392919 1.388543 1.470599 1.687390 -0.209425 0.981376 1.820625 1.486939 1.163029 0.254903 1.663587 0.173397 1.158270 0.008252 1.527331 0.957022 1.565874 0.399190 1.405211 1.610452 0.517417 0.017736 1.604007 0.441982 -0.117242 1.540578 1.122133 0.783699 1.475956 0.425079 0.061031 1.809454 0.020958 1.791601 0.082641 1.232839 0.787976 0.330191 1.079316 0.726671 1.154152 0.664516 0.651535 0.733283 0.178061 1.170989 1.021345 1.431385 1.099593 1.694602 0.959398 1.896463 1.048918 0.980361 1.074828 1.193343 0.231910 1.142775 1.514885 0.820666 1.664680 1.082302 1.454204 1.588263 1.689028 1.772394 1.918052 0.740639 0.483110 0.712257 0.069489 0.905804 1.535153 0.363147 1.835617 0.006427 0.899992 0.380714 1.396011 0.685106 1.823151 0.493868 1.604512 0.224912 0.847624 1.141404 1.562281 1.012902 0.067857 0.682509 1.253834 1.124161 0.614664 0.283374 1.613595 1.434018 0.305996 1.201243 1.266871 0.838092 0.076908 1.420109 1.146620 0.622686 1.115452 0.924323 0.974351 0.825545 1.439257 1.047256 0.983947 -0.023433 0.739378 0.058896 1.009265 0.099088 0.208031 0.584839 1.555592 0.199829 1.098928 1.389603 0.203500 1.217365 0.487433 0.522761 1.901220 0.024564 0.335503 1.627773 0.511258 0.181775 1.136641 0.858910 1.135934 1.389248 1.254197 1.570636 0.887318 1.421787 1.619915 1.382710 0.324584 1.154740 1.550762 0.651293 0.306905 1.355501 0.026583 1.261312 0.455843 1.440013 1.036724 1.152275 0.920599 0.682892 0.672700 1.070057 1.453899 1.087117 1.098307 1.315810 1.292233 0.819280 0.701348 0.997834 1.209758 1.168699 0.077635 0.868252 1.083290 1.930890 0.353494 1.250223 0.310608 1.253033 1.727092 -1.975097 0.941442 0.539454 1.355973 1.005988 0.701618 1.813894 1.775295 0.242359 1.510528 0.986700 1.547890 -0.012287 1.356305 1.522370 0.878012 1.294380 0.155478 1.042814 0.348062 1.188096 1.135315 1.520515 0.878021 0.622847 1.073612 0.317276 1.370638 0.685988 0.992102 1.497485 1.458836 1.101655 0.035966 1.192860 0.380699 1.178862 0.618449 0.213396 0.559044 1.830349 1.447613 0.780973 0.149827 0.000783 1.578653 0.246629 0.619069 0.870396 1.009880 0.007773 1.529581 1.531002 1.437893 1.160448 0.240842 0.009787 1.814160 1.271699 0.449839 0.395650 -0.113986 -0.067771 0.643784 0.033350 0.664053 1.167828 1.330358 0.974541 1.039259 1.278764 0.649775 1.807600 1.456944 1.297261 1.733868 0.415873 -0.032983 0.865685 0.984468 1.747983 1.754950 1.624645 0.955834 0.669497 0.707638 0.496434 0.214751 0.573953 1.537258 1.920697 1.147869 0.279585 1.887307 1.463413 0.319350 0.444741 1.008618 1.021958 0.435657 0.185043 1.371241 0.855151 0.505792 0.741886 0.871680 0.370576 1.264162 1.034020 1.020442 -0.032455 0.151317 0.930427 1.250914 0.457365 1.711895 1.622588 1.474334 0.727044 0.158372 0.547219 1.964062 0.960274 -0.043104 1.429620 1.502524 1.799005 1.879995 0.965812 1.601466 -0.115173 1.786859 -0.082629 1.571997 0.151759 0.116636 -0.138644 1.220180 1.544541 0.711250 1.337424 1.122127 1.265975 1.641180 0.369341 0.941194 1.756270 1.554377 0.421053 0.367857 1.468897 0.120653 1.868696 1.648081 0.013217 0.546092 1.094144 0.662116 1.286971 1.508045 0.588153 1.236472 0.589536 0.744566 -0.014088 1.541068 1.703645 1.335776 0.751643 1.645108 1.835447 -0.004121 1.225363 0.415798 1.680503 0.651280 0.657478 1.380731 1.366587 0.360555 1.416929 0.218857 1.003629 0.196413 0.458188 0.219018 0.371207 0.792944 0.732561 1.096142 1.517356 0.544260 0.244358 1.027194 0.914613 -0.264228 1.386405 0.399853 0.192045 -0.056645 0.448320 1.168258 0.216500 1.282546 0.378607 0.437151 0.271768 0.227147 0.947933 1.169574 1.692082 0.352268 1.556365 0.430126 1.874195 1.391513 1.410537 0.937927 -0.099725 1.350224 0.198315 0.235114 1.785468 1.268030 1.467114 1.142498 0.972180 1.325000 0.953697 1.637360 1.870641 0.094691 0.308883 0.051680 0.986847 0.571862 0.079983 1.563896 0.588847 0.287709 0.038406 0.213414 0.278655 1.462399 0.910186 0.949603 0.231716 0.110559 0.750252 1.849528 -0.017336 1.351536 1.030800 0.135700 1.350730 1.752152 1.144277 0.825775 0.482093 0.451732 0.553985 0.050941 1.589921 1.226160 0.121789 1.892118 1.514707 1.947830 1.899008 0.106199 0.095068 1.481495 0.637728 0.793037 1.046402 0.656131 0.981478 1.645677 1.692830 1.201035 1.580738 0.862287 1.857116 0.752617 1.140952 0.535734 1.166873 1.813586 1.358043 1.562120 0.887429 0.453656 0.808900 1.329005 1.880473 1.667600 0.168656 0.082993 0.554744 0.113094 0.184322 1.116499 1.257143 1.463536 0.845188 0.753503 0.545217 0.808865 0.734823 0.010412 0.637141 0.721788 1.206453 1.725305 0.835897 0.641933 0.849589 1.122095 1.122129 0.082734 1.852811 0.736282 0.466664 0.727515 1.164618 0.912293 0.714009 1.682613 0.400246 0.931132 1.423104 0.690233 0.402124 0.519093 0.013658 1.495360 0.513651 1.911956 1.531564 0.638779 1.926638 0.085423 1.244383 1.405098 0.240999 1.024934 0.085108 1.136585 1.354954 0.694244 0.147529 1.114749 0.327110 0.099190 0.519456 1.197549 1.441452 0.985099 0.496182 0.344015 0.311060 0.341567 1.223570 0.104840 1.555720 0.310844 1.427243 0.253303 1.861208 0.751524 1.176798 0.011549 1.520196 0.725046 1.248869 1.766864 1.132848 0.788957 0.794897 0.471681 1.719229 1.386139 1.274509 -0.039519 1.527659 0.844650 1.774762 0.707953 1.216432 1.474809 0.078357 0.551012 1.506891 1.599422 0.243091 0.153408 0.457904 0.924834 1.678234 0.096402 0.949920 1.821400 0.824671 1.452500 1.524634 1.003177 1.464511 1.816518 1.713961 0.863097 0.517152 0.758012 0.136979 0.120142 0.690421 0.223639 1.498008 1.562219 1.678837 1.627798 0.839019 1.132131 1.535145 1.518018 0.297419 0.203623 0.546133 1.052566 0.784445 1.055616 0.148830 1.720326 0.140740 0.266692 1.425404 0.783229 0.124041 1.494743 0.644046 1.644611 0.750264 1.828214 1.787737 0.538946 0.550047 1.183492 1.041592 0.959210 0.270846 -0.035403 1.739175 0.534984 1.624026 1.611428 1.579430 1.022286 0.855608 1.828514 0.038338 1.291444 0.134507 1.254891 0.596733 0.399162 -0.114539 -0.055887 1.938324 1.170327 1.087488 1.697423 0.478833 0.757412 0.171117 1.059573 0.635458 -0.161792 1.015750 1.708417 0.270384 0.660484 1.333092 -0.030724 1.713327 0.151431 -0.174953 -0.041691 0.300599 0.725691 1.065660 0.588839 0.723013 1.086514 1.665008 0.904689 0.943094 1.548079 1.780577 1.098286 1.413405 0.080554 0.679165 0.451513 1.625382 0.791710 0.263149 -0.161505 1.192182 0.992099 0.009485 1.008730 1.535096 1.036929 1.297483 1.822460 0.975063 -0.085459 1.420746 0.376603 0.192391 -0.220597 0.389186 1.323278 0.098973 0.116023 0.308756 0.430429 1.250750 1.912196 0.463174 0.133615 1.184156 0.919106 1.188101 0.221491 0.139415 1.695088 1.043669 0.180492 0.167037 0.186236 1.544480 0.189182 1.816467 0.395217 1.129900 0.056081 1.599691 0.956415 1.935582 1.752012 1.235924 0.567385 1.236629 1.378551 -0.032682 0.967778 1.161775 0.439121 0.146630 0.210634 0.838256 0.256489 1.849426 1.034341 0.180033 0.002728 0.460610 -0.059008 1.026499 0.239384 0.014096 0.253629 1.317847 1.430188 0.739864 1.356334 0.501333 1.570755 0.964145 1.279445 0.064247 0.367146 1.924309 0.038641 1.441898 1.500527 0.252632 0.522914 1.127721 0.149886 0.482652 0.742163 0.866292 0.415201 0.038035 0.581754 1.410195 1.305935 1.399564 -0.002591 1.315112 0.506490 0.634606 0.712693 1.491569 0.763732 1.133934 1.646626 1.199255 1.255783 0.793887 0.463719 1.274033 0.646579 1.299227 0.074139 1.517832 0.680066 0.556593 0.198377 0.731884 1.265722 0.273535 0.174173 1.643091 0.233723 0.835886 0.331656 0.841667 1.950204 1.700806 1.493564 1.992014 1.047484 0.056101 0.246552 1.178977 1.446793 0.909130 0.666524 1.743752 -0.065462 0.647845 1.528075 -0.027380 0.892732 1.060713 0.961817 0.819512 0.522143 0.761281 0.549432 0.374579 0.281346 0.405971 1.961061 0.861053 0.951913 0.894288 0.120547 1.199477 1.578494 0.905148 0.153248 0.867220 0.425392 0.982660 0.841154 1.540130 1.454289 1.585546 1.708407 0.786107 0.741469)
       )
))



;;; ---------------------------------------- prime-numbered harmonics (and 1st) ----------------------------------------

(define primoid-min-peak-phases (vector

#(1  1.0   #(0)
     )

#(2  1.76  #(0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
#(3  2.1949384212494 #(0 0 1)
     1.980 #(0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 #(0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 #(0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
#(4  2.5978584289551 #(0 0 1 1)
     
     ;2.2039985204158 #(0 0 12 4) / 20
     2.1930510997772 #(0.000 0.996 0.596 0.217)
     2.1930510997772 #(0.000 1.996 0.596 0.217)
     2.1930510997772 #(0.000 0.004 1.404 1.783)

     2.1927945613861 #(0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 #(0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 #(0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
#(5  2.7172040939331 #(0 0 1 0 0)

     2.476848 #(0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 #(0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
#(6  3.1241359710693 #(0 0 0 1 0 0)

     2.805574 #(0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 #(0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     )

;;; 7 prime --------------------------------------------------------------------------------
#(7  3.5358893688327 #(0 0 0 0 0 1 0)
     3.4886319637299 #(0 1 1 0 0 0 0)

     3.061861 #(0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     )

;;; 8 prime --------------------------------------------------------------------------------
#(8  3.8668605608975 #(0 1 0 1 1 1 0 0)
     3.7088719446694 #(0 1 0 0 0 0 1 0)
     3.7088720798492 #(0 0 0 0 0 0 1 0)

     3.263115 #(0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.262977 #(0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     )

;;; 9 prime --------------------------------------------------------------------------------
#(9  4.0320072303689 #(0 1 1 0 1 0 0 0 0)
     3.915482117267 #(0 1 0 1 1 1 0 0 0)
     3.9154822826385 #(0 0 0 1 1 1 0 0 0)

     3.382645 #(0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 #(0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     )

;;; 10 prime --------------------------------------------------------------------------------
#(10 4.1794095733027 #(0 0 1 0 0 1 1 1 1 1)
     4.1718228801521 #(0 0 0 0 0 1 0 0 1 0)
     4.1209712028503 #(0 0 1 0 0 0 1 0 0 0)

     3.602714 #(0.000000 0.594153 1.304664 1.610566 1.241680 0.148124 1.920208 0.972526 1.622030 0.768137)
     3.602602 #(0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 #(0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     )

;;; 11 prime --------------------------------------------------------------------------------
#(11 4.56653492525 #(0 0 1 0 1 1 1 0 0 0 0)
     4.487418596136 #(0 0 0 0 0 0 1 1 0 1 1)
     4.4176635742188 #(0 0 1 0 0 0 0 0 0 1 0)

     3.779310 #(0.000000 0.795034 0.550625 0.191200 0.209037 0.086985 0.729229 1.230323 0.721250 -0.058459 1.262582)
     3.779046 #(0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     )

;;; 12 prime --------------------------------------------------------------------------------
#(12 4.7299025085604 #(0 0 1 0 1 1 1 1 0 1 0 0)
     4.6850221453825 #(0 0 1 0 1 0 1 1 1 0 0 0)
     4.3595271110535 #(0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 #(0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     3.936584 #(0.000000 0.366730 0.995852 1.762390 1.293763 0.137304 0.753397 1.560313 1.278944 0.297723 0.322472 0.315856)
     )

;;; 13 prime --------------------------------------------------------------------------------
#(13 5.06212613641 #(0 1 0 0 1 0 1 0 1 1 0 0 0)
     4.9963458682976 #(0 1 0 0 1 1 1 1 1 1 1 0 1)
     4.9494566649932 #(0 1 0 0 1 1 0 0 0 0 1 1 1)
     4.8980793952942 #(0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.180492 #(0.000000 1.772215 1.337771 1.572723 0.985677 1.717413 1.821689 0.986759 1.151868 0.637061 0.595788 1.561353 1.695959)
     4.155503 #(0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155104 #(0.000000 0.888606 1.516761 -0.128988 1.376524 0.383262 0.572385 -0.041726 0.228441 1.918487 0.187862 1.304384 1.779710)
     )

;;; 14 prime --------------------------------------------------------------------------------
#(14 4.827317237854 #(0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.328845 #(0.000000 1.631608 0.105786 1.732589 0.749692 0.105117 0.626364 1.395811 1.430614 0.705052 0.780338 1.582470 1.046721 0.950090)
     4.326087 #(0.000000 0.362120 1.888454 0.251240 1.230086 1.854603 1.332783 0.548088 0.507657 1.215301 1.123713 0.312281 0.829297 0.910443)
     4.325356 #(0.000000 0.359558 1.885647 0.244632 1.221244 1.839379 1.316045 0.525308 0.483244 1.183590 1.084986 0.271051 0.780356 0.855105)
     )

;;; 15 prime --------------------------------------------------------------------------------
#(15 5.2087744996197 #(0 0 0 0 1 0 0 0 1 1 1 0 1 1 1)
     5.1680134390775 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 1)
     5.116711139679 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.482073 #(0.000000 0.430607 1.010272 0.810816 1.103409 1.274070 0.728190 1.576850 0.465054 1.582164 0.985518 1.441214 0.149277 1.211260 1.202522)
     4.468487 #(0.000000 -0.170894 1.166594 0.261941 0.795313 -0.037553 0.002464 1.693993 1.753074 1.644706 -0.070294 0.671844 1.070595 0.053777 -0.250027)
     4.467959 #(0.000000 1.165302 0.822381 1.719844 1.177673 0.000074 -0.047034 0.249259 0.174863 0.272306 -0.034377 1.204925 0.800910 1.798882 0.085175)
     )

;;; 16 prime --------------------------------------------------------------------------------
#(16 5.3690811579971 #(0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1)
     5.2829658956774 #(0 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0)
     5.2015118598938 #(0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.662724 #(0.000000 0.254861 1.684311 0.497899 0.656871 1.722503 0.329340 1.047910 0.635053 1.158523 0.448629 0.050078 1.573549 1.470622 1.991728 1.975781)
     4.607704 #(0.000000 0.863393 1.574552 1.705278 1.569228 0.102457 0.353917 0.651931 1.696462 1.761383 0.072955 1.294632 -0.307040 1.072928 1.543936 0.777891)
     4.602871 #(0.000000 0.062093 0.362233 0.127394 0.197994 1.532775 1.215275 0.817953 1.672076 1.484960 0.991530 1.690500 1.074819 1.570572 1.070642 1.684336)
     4.602505 #(0.000000 0.065822 0.364277 0.133567 0.202441 1.541212 1.225002 0.832999 1.687176 1.503245 1.015565 1.715739 1.103351 1.602678 1.102870 1.723542)
     )

;;; 17 prime --------------------------------------------------------------------------------
#(17 5.6171013426079 #(0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1)
     5.5776449751108 #(0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1)
     5.5725093120778 #(0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0)
     5.5318970680237 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.732840 #(0.000000 1.594259 1.537383 1.654009 0.059827 1.456178 1.640619 0.725632 -0.052840 0.741210 1.485914 1.399005 0.596215 1.791931 0.887057 0.720499 0.037113)
     4.720335 #(0.000000 0.741764 1.745798 1.858232 0.394387 0.086105 0.379819 1.692029 1.022315 0.008990 1.069411 1.241786 0.653220 0.028583 1.334535 1.358902 0.976814)
     )

;;; 18 prime --------------------------------------------------------------------------------
#(18 5.6380511040237 #(0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0)
     5.518 #(0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.881625 #(0.000000 1.688958 1.279188 1.177293 -0.318361 0.802007 0.250184 -0.270074 -0.003800 1.870180 1.633808 0.442468 -0.114869 0.906870 1.252354 1.245762 -0.107436 0.786324)
     4.856709 #(0.000000 0.761349 1.398941 1.387382 -0.020892 1.258976 0.808017 0.461939 0.840319 0.868659 0.861865 1.748851 1.411948 0.655653 1.051244 1.278422 0.114546 1.310974)
     )

;;; 19 prime --------------------------------------------------------------------------------
#(19 5.9841752522819 #(0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0)
     5.707 #(0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)
     5.7069295560724 #(0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.050598 #(0.000000 0.718637 1.798883 1.579536 0.015456 1.806520 0.208708 1.353434 1.112089 1.766036 0.720549 1.107314 0.509279 -0.117956 1.148417 0.726527 0.254889 1.769009 0.642150)
     5.016706 #(0.000000 1.615592 1.626110 1.313424 1.625675 1.187140 1.457241 0.377999 -0.071449 0.474555 0.996594 1.284924 0.372672 1.499744 0.593870 0.033098 1.161407 0.320243 1.064382)
     )

;;; 20 prime --------------------------------------------------------------------------------
#(20 5.9970674135126 #(0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1)
     5.9696664680177 #(0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0)
     5.931 #(0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0)
     5.8879864574703 #(0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.219761 #(0.000000 1.154818 1.816853 1.891880 -0.032202 0.197019 1.018732 1.639212 0.953425 0.695031 0.577021 1.061687 0.455312 0.907081 0.481515 1.400124 0.806615 1.262883 0.187894 1.041939)
     5.214980 #(0.000000 0.840843 0.870934 -1.936784 0.124790 0.037596 1.842854 1.506881 0.243469 1.454635 0.781572 1.020004 -0.209275 1.345639 1.356003 1.554666 0.375592 1.561439 1.206468 1.818047)
     5.190073 #(0.000000 1.305012 0.829288 0.733488 0.022101 1.272217 1.780612 0.000702 1.609711 0.398599 0.056785 1.250942 0.237528 0.553904 0.013636 0.751667 1.626948 0.622700 1.016243 0.075548)
     )

;;; 21 prime --------------------------------------------------------------------------------
#(21 6.1566464314438 #(0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0)
     6.1375694270894 #(0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0)
     6.1138607493652 #(0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.486939 #(0.000000 1.054487 0.664992 0.221211 0.326872 1.588195 1.592726 1.336003 -0.011408 0.242484 1.885446 1.030420 0.900483 1.377784 1.752653 1.724134 1.420616 1.866623 1.449894 1.955882 0.634259)
     5.329864 #(0.000000 0.272438 0.199162 0.592353 1.763983 0.854454 0.508802 0.394659 -0.117248 0.409584 1.672133 1.498039 0.065454 0.630259 0.862041 1.058228 0.978442 1.314381 0.056427 1.089844 1.751788)
     )

;;; 22 prime --------------------------------------------------------------------------------
#(22 6.389194775669 #(0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1)
     6.3868380259357 #(0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1)
     6.33751039349071 #(0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)
     6.3374844973589 #(0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.446875 #(0.000000 1.499440 1.283938 1.144681 0.719116 0.527122 0.660420 1.925016 0.467488 0.510019 0.651972 0.189033 1.100881 0.083261 0.858169 -0.068443 1.057677 1.751471 1.463218 0.262023 0.956227 1.595986)
     )

;;; 23 prime --------------------------------------------------------------------------------
#(23 6.540168762207 #(0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1)
     6.5358400344849 #(0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 1)
     6.5309901747782 #(0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.685285 #(0.000000 0.254600 -0.012994 0.113546 0.539539 1.037398 1.757854 1.055458 0.272297 -0.046061 0.094856 0.510270 0.402511 -1.992644 1.761629 0.351312 0.348956 1.246604 0.787427 1.083729 1.586582 0.611927 0.184053)
     5.567379 #(0.000000 0.276519 0.590196 0.226039 1.171867 1.340464 0.217215 0.993714 0.638313 1.635401 0.478131 0.411698 0.177712 0.474576 0.294538 0.736543 1.282025 1.529047 0.619437 0.150444 1.091367 1.495687 1.461734)
     )

;;; 24 prime --------------------------------------------------------------------------------
#(24 6.6087727546692 #(0 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0)
     6.5951228141785 #(0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     6.5623834870329 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.949920 #(0.000000 0.128611 0.694957 0.658206 0.886509 0.768948 1.233345 -0.189112 1.759586 0.197333 1.393597 1.021426 0.619470 0.959617 0.232166 0.499447 1.419100 0.526324 0.173261 0.228559 1.292462 0.139965 0.391749 1.913935)
     5.650520 #(0.000000 0.857557 1.842675 1.202065 1.234674 0.492676 -0.102075 -0.239685 1.781251 1.389180 0.305730 1.687909 -0.302137 1.101152 1.813988 1.401012 1.339875 0.431908 0.908768 0.169122 0.275926 0.743300 1.184128 1.445914)
     )

;;; 25 prime --------------------------------------------------------------------------------
#(25 6.84773846418216 #(0 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0)
     6.8138422966003 #(0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 1 1 1 1)
     6.6733964421745 #(0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0)
     6.635721206665 #(0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.988895 #(0.000000 0.958244 1.345633 0.953582 0.394970 1.901749 1.046106 1.586016 1.673907 1.504535 0.855726 1.185762 0.711920 0.273710 0.138584 1.350736 -0.012172 1.001100 -0.022766 1.615113 1.538010 -0.061672 0.033456 -0.153052 0.855356)
     5.817801 #(0.000000 0.565115 1.218582 1.332443 1.457356 0.307620 -0.086640 1.159236 1.303142 0.191122 1.559887 0.364215 -0.020320 1.538774 -0.224345 1.038168 1.392305 1.023305 1.898968 0.543144 1.617259 0.873326 1.477436 0.455001 0.528076)
     )

;;; 26 prime --------------------------------------------------------------------------------
#(26 6.9502968788147 #(0 1 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 1)
     6.9264550209045 #(0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.9264546836564 #(0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1)
     6.8401503562927 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.114195 #(0.000000 0.487946 1.509453 0.656427 -0.061099 1.024534 1.764200 0.719985 0.845113 1.416156 0.999041 1.502717 1.217362 0.470360 0.781338 0.378324 1.225888 1.318663 1.531597 0.037759 1.356653 1.047908 -0.226597 0.213201 0.995851 0.546112)
     6.065277 #(0.000000 1.952952 1.987242 0.420412 0.992066 0.834479 -0.019176 1.658533 0.252187 0.140726 1.394199 0.402324 0.268800 0.242479 -0.131235 1.784926 -0.095062 0.379551 1.355690 0.747495 0.652914 0.431680 0.652519 1.167388 1.821792 0.276656)
     )

;;; 27 prime --------------------------------------------------------------------------------
#(27 7.0658421516418 #(0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0)
     6.9657588005066 #(0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1)
     6.949148677349 #(0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)
     6.9491486549377 #(0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.306082 #(0.000000 1.014487 0.044686 1.244051 0.504595 0.487037 0.595344 0.942363 1.421788 1.271617 1.672410 0.919810 -0.088188 -0.004921 0.389662 1.276380 1.315062 0.969929 1.267761 0.826017 0.908595 0.237755 0.772601 0.772305 0.470772 1.354427 0.868884)
     6.208117 #(0.000000 1.512045 0.359682 0.506255 0.085924 1.805313 1.736555 1.032065 0.043760 1.546411 0.703269 1.873342 1.194067 0.033337 0.973932 0.070491 1.492023 0.364381 0.350403 1.174480 1.292443 1.655361 -0.178682 1.921343 1.907984 1.669334 0.318176)
     )

;;; 28 prime --------------------------------------------------------------------------------
#(28 7.2303333282471 #(0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0)
     7.2299618721008 #(0 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0)
     7.2240290641785 #(0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1)
     7.1576952692751 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)
     7.1576952934265 #(0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.266481 #(0.000000 0.464977 0.954351 0.843190 1.125317 0.010507 1.072665 0.506420 0.334117 -0.002274 0.804342 1.777515 0.702462 1.533180 1.276804 0.055155 0.922788 0.985869 0.597230 0.416958 0.876178 1.168420 0.578974 1.494226 1.590875 0.468961 1.546102 0.116359)
     6.196485 #(0.000000 0.458944 0.985055 0.811841 1.148693 -0.005212 1.062478 0.554335 0.356816 -0.025801 0.767531 1.763049 0.823656 1.563708 1.227984 0.170565 0.942617 0.969630 0.568960 0.481321 0.845313 1.114047 0.660943 1.585424 1.609223 0.526033 1.503429 0.092184)
     )

;;; 29 prime --------------------------------------------------------------------------------
#(29 7.2895045280457 #(0 0 1 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0)
     7.24235304747816 #(0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)
     7.2415904369233 #(0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.372077 #(0.000000 0.906700 0.020499 1.650846 0.580089 0.578369 1.397436 1.003048 -0.081655 0.050050 1.763555 1.526930 0.976916 1.568543 -0.090164 0.995351 1.487167 1.249980 0.097075 -0.067935 0.669015 0.440346 0.565400 1.317269 1.160383 1.242277 0.930720 0.791130 0.517575)
     )

;;; 30 prime --------------------------------------------------------------------------------
#(30 7.5369029045105 #(0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0)
     7.5239403940776 #(0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1)
     7.5096759796143 #(0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1)
     7.4977698326111 #(0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1)
     7.1189651489258 #(0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.658580 #(0.000000 1.477513 0.548175 1.347892 0.733820 0.121555 -0.032344 0.713938 0.819135 1.370527 1.738632 0.698418 0.364253 0.441036 -0.035716 0.516534 0.740702 0.984618 1.142869 0.406938 1.301988 0.810169 0.504070 1.569824 0.496394 0.536230 1.606405 0.027724 1.473284 1.742612)
     6.456773 #(0.000000 1.682298 0.804525 0.935259 0.852365 1.701892 1.279341 1.476692 1.214874 1.902003 0.957590 1.784524 1.954155 1.382964 0.111155 0.106883 1.261078 1.571988 0.412759 0.387649 1.591012 0.972707 0.057129 0.913450 1.666840 1.659204 1.092741 1.343541 0.655401 0.866116)
     )

;;; 31 prime --------------------------------------------------------------------------------
#(31 7.5859903003103 #(0 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1)
     7.5834159851074 #(0 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0)
     7.5718903541565 #(0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1)
     7.4906754493713 #(0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.715110 #(0.000000 0.725211 0.683580 0.750597 1.391109 0.559370 0.384624 1.051186 1.685491 0.785928 1.483000 1.124375 1.692462 1.314818 0.611419 1.753370 1.283488 0.879908 0.233025 0.968221 0.809905 0.782282 0.050986 1.316304 1.849362 0.837962 0.668673 1.033563 0.899101 1.872927 0.388541)
     )

;;; 32 prime --------------------------------------------------------------------------------
#(32 7.7375974655151 #(0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0)
     7.719434261322 #(0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0)
     7.6655950546265 #(0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1)
     7.6567826271057 #(0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0)
     7.6309351921082 #(0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.945565 #(0.000000 0.046495 0.496817 0.680238 1.009260 1.131116 1.092336 0.893510 1.099114 0.815014 -0.083387 0.117703 1.618006 0.348695 1.351638 1.392799 1.435601 1.178568 0.246956 1.532146 1.530973 0.353380 1.008482 1.228068 1.716716 1.252232 0.794560 0.240630 1.365270 1.163613 1.530387 0.931563)
     6.868423 #(0.000000 0.299978 0.514058 0.053964 0.542128 0.122705 0.887974 1.276625 1.025220 1.346655 0.784384 0.686179 0.263848 0.933113 0.840397 1.726479 0.051412 1.939447 0.278912 -0.081005 1.403209 0.883998 -0.014454 1.586441 1.411201 -0.042922 0.306515 0.996493 1.744986 1.056448 0.331918 1.402460)
     )

;;; 33 prime --------------------------------------------------------------------------------
#(33 7.9869227409363 #(0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
     7.8325562477112 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0)
     7.7895503044128 #(0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 0 1)
     7.7389698028564 #(0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.914355 #(0.000000 1.554709 1.222325 0.792367 1.049103 0.742138 0.876199 0.536015 1.040981 1.003315 1.121035 0.437391 1.438037 0.339961 0.862777 0.435682 0.463584 1.436555 -0.045105 1.031626 0.326208 1.844769 1.009536 -0.070087 0.434222 0.877722 1.762874 0.343356 1.717990 1.467251 0.647507 1.860696 0.603647)
     )

;;; 34 prime --------------------------------------------------------------------------------
#(34 8.0215682983398 #(0 0 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     7.9724597930908 #(0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0)
     7.9716167449951 #(0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9716163031165 #(0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1)
     7.9624452590942 #(0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     7.053846 #(0.000000 1.757683 0.219567 1.742969 0.309832 0.883629 0.426015 0.611588 1.959158 1.190735 1.283537 -1.865210 1.403648 0.671456 1.570826 -0.354368 1.603689 1.234174 1.053732 0.638777 0.718266 1.165709 0.665924 0.035389 1.384529 1.140937 0.571096 0.091813 0.800454 1.433826 1.237339 0.510342 1.562376 0.400741)
     )

;;; 35 prime --------------------------------------------------------------------------------
#(35 8.2040424346924 #(0 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 0)
     8.1993579864502 #(0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0)
     8.1756086349487 #(0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1)
     8.1555442810059 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0)
     8.1336851119995 #(0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 0 0)
     8.1317510604858 #(0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 0 1 0 0 0 0)
     8.0019035339355 #(0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.229111 #(0.000000 1.231983 0.486040 0.577601 -0.012197 0.838851 1.162661 1.750225 1.480975 0.857238 0.974172 1.385849 0.196467 1.743568 1.401858 0.748455 0.103496 1.441526 0.391075 0.230401 0.991860 1.528312 0.473115 0.562470 0.294655 0.049385 0.675186 0.327022 0.697676 0.555997 1.391450 0.187347 0.223156 0.168209 1.110493)
     )

;;; 36 prime --------------------------------------------------------------------------------
#(36 8.4211139678955 #(0 0 0 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0)
     8.4162702560425 #(0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0)
     8.4114933013916 #(0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0)
     8.3864717483521 #(0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0)
     8.3820142745972 #(0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0)
     8.3783054351807 #(0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0)
     8.3031883239746 #(0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.404178 #(0.000000 0.349597 1.716038 0.690553 0.687639 0.221012 0.695126 0.411892 0.166628 1.193809 0.529764 1.092664 0.874871 0.839078 1.019423 0.026393 0.456310 -0.081007 1.374823 0.044332 1.771459 1.642610 0.600080 1.318849 1.746532 0.618120 0.686859 1.495821 0.653764 1.669378 -0.037137 0.363138 0.574791 1.309700 1.649377 -0.147887)
     )

;;; 37 prime --------------------------------------------------------------------------------
#(37 8.6493539810181 #(0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0)
     8.5117635726929 #(0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0)
     8.4779825210571 #(0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)
     8.4775905609131 #(0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.355103 #(0.000000 1.297016 1.085901 1.270940 0.623129 1.068545 0.632645 1.726241 1.127554 0.020035 1.494836 0.203468 1.597125 0.155391 1.228219 1.087730 0.701184 0.157445 1.802225 0.997757 -0.003140 0.049293 0.881400 0.756950 1.400671 0.203737 0.778794 0.564982 1.042535 0.081237 0.525257 -0.076745 1.241541 1.383181 1.882417 1.280355 1.618429)
     )

;;; 38 prime --------------------------------------------------------------------------------
#(38 8.6871099472046 #(0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0)
     8.67653465271 #(0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0)
     8.6688671112061 #(0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0)
     8.6612920761108 #(0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0)
     8.6306476593018 #(0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0)
     8.6206035614014 #(0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0)
     8.5991640090942 #(0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0)
     8.5527725219727 #(0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

     7.573586 #(0.000000 0.248408 1.278089 -0.086094 0.371944 0.914090 1.962709 0.609285 0.192338 0.761292 1.612434 1.666337 0.435003 1.022096 1.329415 -0.364564 0.275582 0.234433 1.188155 -0.245500 1.737331 0.470040 -0.111115 0.712031 1.921176 0.905594 0.314595 0.610337 0.729598 0.532701 0.521500 1.366396 0.213289 0.296348 -0.150930 1.317939 0.614995 0.099802)
     )

;;; 39 prime --------------------------------------------------------------------------------
#(39 8.9125862121582 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 0)
     8.8173857964668 #(0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.634012 #(0.000000 0.042681 1.027751 0.102947 1.472368 1.405094 0.905971 0.337563 0.018822 1.097136 0.902141 1.409376 0.342976 0.454238 1.346778 1.662894 0.033674 0.984603 1.391594 1.387653 1.108578 1.295792 0.968019 0.586814 0.529142 0.621100 1.251114 0.957131 1.042381 0.912972 1.461099 0.129751 1.322284 1.822587 1.556607 0.052453 0.499121 1.268853 1.378747)
     )

;;; 40 prime --------------------------------------------------------------------------------
#(40 9.0681540417544 #(0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1)
     8.9134502410889 #(0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.811677 #(0.000000 1.606372 1.708650 1.164091 0.070664 0.438284 0.925625 0.653761 0.285719 1.310341 1.566530 0.551547 1.266693 0.294219 0.676875 1.139287 0.658980 0.410301 1.703919 0.461543 1.687469 0.224294 0.449290 1.886059 1.752414 1.267174 0.602352 0.275341 1.397959 0.579675 0.636600 1.552175 0.598055 1.436111 1.770487 0.639434 1.383003 -0.039689 1.433201 1.442039)
     )

;;; 41 prime --------------------------------------------------------------------------------
#(41 9.295313835144 #(0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     9.1567583084106 #(0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     7.896724 #(0.000000 0.611471 -0.038036 1.228898 0.385347 0.040518 -0.205041 -0.141688 0.136159 -0.044044 1.496521 0.492978 1.520705 1.941823 1.343851 0.777914 0.012500 1.486257 1.079901 0.410520 0.519316 0.764307 1.292590 0.530463 1.697495 0.689827 0.613289 0.973484 0.945034 0.811200 1.709230 1.319255 0.589344 0.205769 0.678197 1.574715 0.274661 0.815107 0.362836 1.351584 0.690213)
     )

;;; 42 prime --------------------------------------------------------------------------------
#(42 9.3096771240234 #(0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0)
     9.2193641662598 #(0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

     8.016184 #(0.000000 -0.291512 -0.100016 1.534256 0.920647 1.277050 1.312375 1.720782 0.392198 1.456934 1.082943 1.212166 0.294325 0.004793 0.762919 0.516225 1.618765 0.489047 1.228725 0.837576 1.953801 1.540962 0.776034 0.326776 0.251790 1.766810 0.533914 1.043314 1.124539 0.745273 1.176358 0.321088 0.153090 0.527726 1.123364 1.312058 0.328806 0.204066 1.404972 0.911502 0.894116 0.772235)
     )

;;; 43 prime --------------------------------------------------------------------------------
#(43 9.4925568571597 #(0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1)
     9.4329051971436 #(0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     8.117380 #(0.000000 1.842087 0.240000 0.005942 1.205212 0.146893 0.110616 1.679117 0.700643 0.796349 0.948554 1.740978 0.483293 0.385560 1.153672 1.554812 0.060414 1.933818 0.200326 1.493279 1.446128 1.411565 0.092756 1.174802 1.892478 0.087790 1.133558 0.218843 0.029965 0.134713 -0.134121 0.719584 0.768232 1.613737 1.410761 0.297493 1.702758 1.215832 0.830435 0.020807 1.765772 0.226708 1.490764)
     )

;;; 44 prime --------------------------------------------------------------------------------
#(44 9.6622378996026 #(0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0)
     9.6263332366943 #(0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

     8.215317 #(0.000000 1.318160 0.197729 0.803473 1.004322 0.886728 0.515874 0.795863 0.293865 0.795663 0.112448 0.806048 1.766879 0.052205 0.210621 1.814594 1.845717 0.972716 1.444914 0.287591 0.558596 0.184601 1.290546 1.309210 0.651282 0.234753 1.110353 1.301404 0.549284 -0.043084 0.372597 -0.011711 0.585949 0.978766 1.300105 1.502709 1.058925 -0.263301 0.235962 1.064019 0.870735 1.508524 0.916606 1.878285)
     )

;;; 45 prime --------------------------------------------------------------------------------
#(45 9.8476276594031 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1)
     9.7923860549927 #(0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.326119 #(0.000000 0.615534 0.786808 1.463577 0.302019 0.572091 0.243502 1.524952 1.154508 0.327857 1.312145 1.313026 0.949294 0.781999 0.312781 0.886116 1.325416 1.542244 1.265398 0.192906 1.601553 1.432439 0.524971 0.978226 1.459196 1.894745 0.965588 1.805077 0.714599 1.729128 0.478069 0.037499 1.222079 1.346949 1.229158 1.575769 -0.047226 1.222618 0.785747 1.328347 0.458307 0.555124 0.709305 -0.098620 0.742388)
     )

;;; 46 prime --------------------------------------------------------------------------------
#(46 9.928765296936 #(0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0)
     9.8914480209351 #(0 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)
     9.7220277786255 #(0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.388195 #(0.000000 0.341399 0.073766 1.441221 0.964981 0.723168 0.793927 0.409368 -0.012034 1.722063 0.073566 1.384487 1.221381 -0.209197 1.242466 0.619383 0.404177 1.051852 1.658824 0.621661 1.026108 0.237692 0.647377 1.189008 0.930807 0.163838 0.991847 1.522371 1.886735 0.052868 -0.337804 0.524642 1.369977 0.937413 1.089298 0.852838 0.013817 1.606451 0.689174 1.067406 1.206902 1.163092 1.326614 0.660474 0.602437 1.119066)
     )

;;; 47 prime --------------------------------------------------------------------------------
#(47 10.097447395325 #(0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     10.0            #(0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.496667 #(0.000000 1.151517 0.189498 0.013781 0.945422 0.165356 1.213007 1.579839 1.070307 1.030655 1.286981 0.618317 -0.305344 0.920514 0.375348 1.737515 1.808712 0.165928 1.021635 0.358213 0.410242 1.648572 1.036397 1.774765 1.549977 1.826003 0.623620 1.348277 1.019149 1.205025 1.343082 1.000649 1.208319 1.279188 1.894045 1.245705 0.007883 1.289943 1.181721 1.205084 -0.184564 1.113608 1.470585 0.241726 0.036454 0.580900 0.228296)
     )

;;; 48 prime --------------------------------------------------------------------------------
#(48 10.298553466797 #(0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0)
     10.248653411865 #(0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0)
     10.073040962219 #(0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.604461 #(0.000000 0.306203 1.667769 1.680415 0.428100 0.559237 0.820987 1.781776 -0.001529 0.107037 1.002614 0.977037 0.536281 1.124314 0.776388 0.403581 1.067061 0.469432 1.806294 0.567358 0.004000 0.612561 1.600977 1.219969 1.664782 -0.100684 0.985158 1.276297 1.305389 0.716428 1.608092 1.275434 -0.028608 0.642270 1.748536 0.849084 1.287227 0.773784 0.595312 1.018597 1.388126 1.074577 1.874473 1.172345 0.675567 0.990745 0.329066 -0.172689)
     )

;;; 49 prime --------------------------------------------------------------------------------
#(49 10.28332063912 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0)
     10.207101821899 #(0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 0 0)
     10.209 #(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.721727 #(0.000000 1.499026 0.320811 1.012405 0.965354 0.238586 -0.062636 0.816989 0.799934 1.565103 1.180433 1.616783 1.191686 1.753034 0.326889 1.457085 0.129444 1.740509 0.413310 0.047595 1.160271 1.020068 0.609400 1.770818 0.009382 0.128358 -0.009560 0.510302 1.223153 1.135703 1.635406 1.940126 1.813497 0.002140 1.210441 0.688281 -0.121560 1.807460 1.698233 1.538374 0.855067 1.667660 0.945316 -0.069390 0.328337 0.889780 0.563232 1.817766 1.256732)
     )

;;; 50 prime --------------------------------------------------------------------------------
#(50 10.669495582581 #(0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1)
     10.402973175049 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.698816 #(0.000000 1.484777 1.088926 1.020064 1.347675 1.055405 0.560314 1.688912 1.249576 1.209396 1.226523 1.429666 0.837134 1.808991 0.071307 0.700038 -0.100589 0.062265 1.078496 1.917410 1.162420 0.994992 0.947585 0.198830 0.740457 0.446782 0.918367 0.122761 0.837213 0.056895 1.295449 1.238670 1.926003 0.868891 0.442390 -0.213250 0.810476 1.014028 0.114921 1.518697 0.818511 1.330636 0.888278 1.413279 -0.001982 1.586011 0.586157 1.277906 0.034523 1.187727)
     )

;;; 51 prime --------------------------------------------------------------------------------
#(51 10.5841327092253 #(0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.805015 #(0.000000 0.539973 1.555252 0.814573 0.453988 -0.004906 1.087602 1.343043 0.843771 0.098192 -0.265161 1.563033 0.801463 -0.168911 1.833601 0.442514 1.200853 0.877153 0.989126 1.024179 -0.061071 0.011869 0.286293 0.879863 0.602071 0.797164 0.295490 1.396754 0.507117 0.424387 0.410578 1.735741 0.436422 0.246191 1.055064 0.393157 0.246676 0.479976 0.834408 0.328859 1.197324 1.185085 1.910551 1.626711 1.757691 1.204866 1.035406 0.687687 0.204443 -0.083877 0.599236)
     )

;;; 52 prime --------------------------------------------------------------------------------
#(52 10.767134666443 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0)
     10.737469673157 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 1)
     10.64324760437 #(0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     9.037908 #(0.000000 0.258676 0.085364 0.269316 1.792440 1.695660 1.754235 0.570365 1.345382 0.685811 0.376499 -0.068359 1.102238 1.628337 0.018979 0.256896 1.399966 0.450366 1.380123 0.058452 1.303262 0.491376 -0.060279 1.471446 0.121811 1.381052 0.065406 0.529831 0.765545 0.256384 0.709690 0.778739 0.998882 1.449813 0.684843 1.760110 0.027686 1.838691 1.056877 1.660123 1.622804 0.865755 0.860272 1.110810 0.290132 1.262879 0.496774 1.492458 0.676634 0.836150 1.137608 1.015006)
     )

;;; 53 prime --------------------------------------------------------------------------------
#(53 10.969209228042 #(0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1 0)
     10.959488868713 #(0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.950836181641 #(0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0)
     10.851609230042 #(0 1 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1)
     10.848851203918 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     10.678050692694 #(0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     9.292846 #(0.000000 0.738700 1.231731 0.377708 0.241486 0.025287 0.876478 1.775113 1.305052 1.734757 1.826661 0.399139 1.524510 -0.177252 0.453777 1.760097 0.629257 0.509507 0.770489 1.803168 0.903666 0.187474 0.536689 -0.207488 1.569643 0.541952 1.283905 1.548022 1.328222 1.043297 0.849999 0.700842 1.602833 0.481557 0.384933 0.811873 0.807981 0.731086 1.732606 1.872106 0.794196 1.468475 0.803742 1.862857 0.112874 1.215686 1.111758 1.024789 1.237618 0.613044 1.240303 0.932407 1.617040)
     )

;;; 54 prime --------------------------------------------------------------------------------
#(54 11.062943458557 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1)
     11.050 #(0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1)
     10.781757504258 #(0 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1)
     10.582709312439 #(0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     9.215414 #(0.000000 1.358117 1.640818 1.724813 1.142410 1.097880 0.419190 1.313319 1.127393 1.569103 1.715267 0.231328 1.332343 0.564847 0.652586 1.735011 1.266139 0.673952 0.187090 0.230731 -0.038445 -0.015014 1.486649 0.782149 0.819414 1.613686 0.229438 0.327177 1.119806 -0.033707 -0.103160 1.309205 1.367680 1.395692 0.075574 0.854077 1.595090 0.108962 0.599577 1.715162 1.871743 0.361101 1.100268 1.772462 0.928532 1.327810 0.949600 1.487634 1.828513 0.155421 0.989476 1.636329 0.174122 0.301666)
     )

;;; 55 prime --------------------------------------------------------------------------------
#(55 11.142364777492 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1)
     10.806410031758 #(0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.425589 #(0.000000 0.972564 1.116398 0.006411 0.683938 0.749216 1.010097 1.439661 0.555665 0.636990 1.364710 0.087873 0.741599 1.680054 1.628158 1.265659 1.436288 0.078667 1.303928 1.069673 0.628631 0.846875 0.400093 -0.091694 1.443599 1.268576 -1.761194 0.384707 0.174074 1.415190 -0.378182 1.204791 1.260365 1.326258 1.221515 0.670135 0.102841 0.701767 1.227454 0.438261 1.356978 0.649857 0.236124 0.128726 1.592504 0.125229 1.173637 1.721251 0.263454 1.678769 1.635922 0.014282 1.894135 0.220747 -0.147730)
     )

;;; 56 prime --------------------------------------------------------------------------------
#(56 11.365570068359 #(0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1)
     11.143131256104 #(0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1)
     10.976176261902 #(0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

     9.563502 #(0.000000 0.104270 0.700593 1.696738 1.150445 0.306132 1.669051 0.422620 1.598566 -0.108372 0.454200 1.252955 1.507430 1.406894 1.644301 1.113576 -0.045121 1.371545 0.008749 1.947034 1.874701 0.354846 0.187576 0.344692 0.493759 1.624118 -0.099543 0.210134 0.494902 0.682380 1.537911 1.604316 -0.049825 1.593831 0.245257 0.674798 1.063070 0.707970 -0.241590 -0.293127 1.419370 0.750307 0.046415 0.271615 1.476934 1.775006 1.077570 0.279780 0.755331 -0.150835 0.067161 0.525076 1.580263 1.321137 1.580781 1.301531)
     )

;;; 57 prime --------------------------------------------------------------------------------
#(57 11.484163284302 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1)
     11.352762647901 #(0 0 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)
     11.247724533081 #(0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

     9.695760 #(0.000000 -0.060645 1.785143 1.531305 0.025068 1.724167 0.374447 0.769733 1.289691 1.752836 1.644119 0.739838 0.318559 -0.043428 1.011534 1.593575 1.163717 -0.074204 1.201326 1.800316 1.335847 1.177295 0.693277 0.705889 1.186352 -0.118458 1.674789 0.775816 1.360858 0.829366 0.314305 0.087484 0.140580 0.205054 -0.063191 1.414703 1.865168 1.336386 0.061942 1.561372 0.512909 0.735564 0.878027 0.445788 1.216211 0.699679 1.738879 0.669774 0.833224 1.191517 1.342387 1.075674 0.615860 1.445789 0.301327 1.576866 0.974657)
     )

;;; 58 prime --------------------------------------------------------------------------------
#(58 11.564489172529 #(0 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)
     11.261419321863 #(0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

     9.855235 #(0.000000 1.933222 0.325455 0.423608 0.261309 0.866965 0.031165 0.122504 0.581873 1.679026 1.025402 1.513411 0.679112 0.786381 1.204491 1.203420 0.697415 1.340698 0.444405 1.200858 1.208208 1.042978 0.142443 0.110563 -0.117619 0.157484 0.712883 0.842792 1.621427 0.545252 1.081227 1.320820 1.301107 1.537564 0.672035 0.117009 0.244746 1.214942 0.911267 1.187062 1.914937 0.611871 1.154090 1.340449 0.824697 0.992644 1.712023 0.505795 0.038028 1.015521 0.147263 1.212660 1.158566 0.165421 0.273322 0.166763 0.529011 1.641613)
     )

;;; 59 prime --------------------------------------------------------------------------------
#(59 11.677247047424 #(0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0)
     11.650652430228 #(0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0)
     11.523194313049 #(0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 1)
     11.34253692627 #(0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.588297 #(0.000000 1.036635 1.252797 0.393709 0.941001 0.289643 0.221427 1.653864 1.898801 0.037244 1.391779 0.013128 1.296783 1.180326 0.928061 0.822326 1.343584 -0.120529 1.590336 1.539808 -0.196635 1.589293 0.475360 1.852687 0.794865 0.908591 0.350835 1.546472 1.908488 0.745148 1.102399 1.103840 0.602980 1.170248 1.294223 -0.084880 0.278291 0.821092 1.412892 1.591251 0.626561 -0.009036 1.045060 1.158156 0.638069 1.133336 1.675645 0.547567 0.369815 1.827912 0.972435 0.075210 0.457357 1.695742 0.139805 0.005764 0.028464 0.399412 0.883274)
     )

;;; 60 prime --------------------------------------------------------------------------------
#(60 11.705318182776 #(0 1 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0)
     11.579921722412 #(0 0 1 0 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0)
     11.512454032898 #(0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     9.759110 #(0.000000 1.446642 1.657485 0.940805 -0.104635 1.424740 0.095135 1.410898 1.136645 0.854509 0.171933 1.537982 1.306166 0.496033 0.046360 0.968561 1.548539 0.434157 1.665089 0.224963 0.978510 0.355066 0.765341 0.925084 1.116028 1.851129 0.624633 0.780213 1.738750 0.768829 0.568430 1.111388 1.649464 1.517104 1.214873 1.790060 0.222210 0.373911 1.747530 0.638438 0.072388 0.620207 0.922723 -0.250381 -0.128313 1.280293 1.860441 1.336931 -0.047623 0.414745 1.216120 1.751910 0.106666 0.494895 1.725411 0.902702 0.016593 1.774689 0.162571 0.829897)
     )

;;; 61 prime --------------------------------------------------------------------------------
#(61 11.989195823669 #(0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0)
     11.915099143982 #(0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0)
     11.850807189941 #(0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     10.093851 #(0.000000 0.439572 1.556340 1.228997 1.657707 1.219943 0.204623 1.113713 0.996377 1.200979 0.478917 0.788803 0.004344 0.671797 1.750051 1.095895 0.530684 -0.042672 0.217918 0.677640 1.205577 0.790224 0.061761 0.991983 0.793815 0.247220 0.201224 1.897933 0.605791 1.398619 1.588963 0.708249 0.043214 0.194824 1.387510 1.039889 1.228907 0.278349 1.091617 0.594822 1.701476 0.120599 0.871850 0.530007 1.692692 0.971859 0.874623 1.094944 -0.152315 1.211545 0.675216 1.297936 1.265448 1.757916 1.822036 0.519508 0.612398 -0.078465 0.933052 1.682153 0.538893)
     )

;;; 62 prime --------------------------------------------------------------------------------
#(62 12.4221113188342 #(0 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0)
     11.929849152918 #(0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0)
     11.709966659546 #(0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

     10.151157 #(0.000000 0.275433 0.389948 0.221775 1.784730 0.053486 1.042229 0.475188 1.651999 0.192716 0.023687 0.515597 1.042667 1.194969 1.042262 1.256818 0.511148 0.063043 0.422100 0.779265 0.394290 1.334439 -0.514199 0.342323 1.545625 -0.325018 0.555532 1.682117 0.536119 1.631512 0.922219 0.182103 1.085601 0.129234 0.167626 0.215261 1.622656 0.721452 1.261149 1.168998 0.274058 1.702664 1.136935 0.657845 1.030874 1.643228 1.092581 0.735506 0.049024 0.835669 0.567459 0.365711 1.953481 0.562915 0.579137 0.056177 0.668614 1.382740 0.565309 1.195908 1.849961 0.018970)
     )

;;; 63 prime --------------------------------------------------------------------------------
#(63 12.219760894775 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     12.000000000004 #(0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)
     11.975765228271 #(0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.936658 #(0.000000 -0.172976 0.053117 0.193207 1.582039 0.279041 1.154298 0.645558 1.180892 0.466938 0.752179 -0.091238 0.242467 0.005372 -0.091444 1.301269 0.218170 1.438113 0.989258 0.756959 1.749924 1.438965 1.263101 1.471579 1.677287 0.336900 0.648660 0.846226 0.598351 1.720861 -0.130696 1.894805 0.612663 0.697210 1.483336 0.948180 0.417612 1.420734 1.619973 0.681741 0.843955 0.678963 0.288608 1.963969 0.802151 0.530457 1.429951 0.417925 -0.190943 0.355155 0.446542 1.791712 0.509038 1.523929 0.040420 1.421476 0.205217 0.565373 0.549874 0.099518 0.264580 1.036675 0.377782)
     )

;;; 64 prime --------------------------------------------------------------------------------
#(64 12.176999092102 #(0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)
     11.932915769505 #(0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     10.267900 #(0.000000 -0.055464 0.198871 1.543029 0.273897 0.541242 1.037970 0.940072 0.399901 0.008175 1.498673 0.565903 1.018603 1.387812 0.406554 0.840569 0.982692 0.436187 0.026512 -0.015321 1.846961 0.342803 0.737278 1.505152 0.123641 0.646926 1.693673 0.588292 1.550689 1.376816 0.163942 0.733286 0.414648 1.198500 0.352227 0.287012 0.557964 1.409624 0.955079 1.280112 1.351285 1.563695 0.499405 0.551315 1.105607 1.548578 0.378990 -0.137018 0.151584 1.405173 0.603268 0.632565 -0.148703 1.595775 0.941656 0.715958 0.864652 1.216898 1.536642 1.024869 0.563455 0.725519 0.226640 0.491522)
     )

;;; 65 prime --------------------------------------------------------------------------------
#(65 12.496994018555 #(0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 0)
     12.264873504639 #(0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

     10.474157 #(0.000000 1.273082 -0.108748 0.002171 0.221568 0.298934 0.620223 1.795584 0.009754 1.449682 1.110502 1.681545 1.418284 0.589352 0.145387 1.276013 0.728335 0.082043 0.956326 0.079416 0.257929 0.397685 1.325636 1.057434 1.124161 0.969295 0.681901 1.820279 0.064926 0.123739 1.169622 1.044837 0.523695 1.894276 1.861180 0.109117 0.631163 0.642180 1.303103 0.827956 1.333076 1.148451 0.129643 1.437061 0.141904 1.458851 0.150246 0.234687 0.214824 0.871574 0.140300 -0.039724 1.494791 1.298930 1.834425 -0.037572 1.554111 0.323365 -0.158908 1.063261 0.185935 1.420761 1.515474 1.895882 0.194772)
     )

;;; 66 prime --------------------------------------------------------------------------------
#(66 12.564531326294 #(0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0)
     12.359117360586 #(0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0)
     12.347700119019 #(0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0)
     12.090668678284 #(0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.556190 #(0.000000 -0.097410 0.466528 1.308208 0.089559 0.411734 1.120474 0.896344 0.382486 0.160205 0.491699 1.107105 1.297836 0.115885 1.221218 1.995276 1.682799 1.126891 -0.240986 0.085971 1.931944 1.169230 0.261608 0.424403 0.869078 0.602102 1.700036 0.236859 0.614581 0.141426 0.284138 0.093545 0.350527 0.910054 0.678764 0.048839 0.277789 0.707343 1.196932 1.405096 0.791701 1.953311 1.198877 1.176208 0.815496 1.679594 0.643402 1.661119 -0.178075 0.973553 0.506388 1.914033 1.162835 0.568432 1.168914 1.270541 1.157177 0.255981 0.624529 0.129369 0.665529 0.244705 1.465881 0.519362 0.023394 0.339325)
     )

;;; 67 prime --------------------------------------------------------------------------------
#(67 12.65784740448 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 1 1)
     12.20425496356 #(0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

     10.548870 #(0.000000 -0.090470 1.285858 1.883442 0.628501 0.073784 1.323940 1.075641 0.049603 0.274005 0.320800 0.667656 0.164957 0.114796 0.756507 0.174762 1.581460 1.561145 1.514403 0.732542 0.872410 0.966478 1.593815 0.938832 0.444737 0.882006 0.648639 0.950035 0.376566 0.690365 1.057734 1.537733 1.430833 0.953945 1.368865 0.849178 0.019499 1.383576 1.700967 0.040155 1.509674 1.112533 0.870563 1.381018 1.059651 1.845667 0.970247 0.577069 0.965240 1.053062 1.367131 0.971382 1.428853 0.422239 0.001277 1.592744 0.691079 0.418683 0.599436 1.560980 1.196877 0.761136 0.232014 -0.089189 0.948608 0.345004 0.601538)
     )

;;; 68 prime --------------------------------------------------------------------------------
#(68 12.551372528076 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1)
     12.501034736633 #(0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1)
     12.466281890869 #(0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

     10.692181 #(0.000000 0.160992 1.670151 -0.032752 1.125438 1.816792 0.134967 0.948462 0.004882 1.213856 -0.158463 1.824966 1.525159 1.935532 0.134622 0.791181 0.233909 1.349193 0.979140 0.292243 0.051319 0.836471 0.015026 1.439303 1.082337 0.487288 -0.111585 1.299924 1.260731 1.979344 0.032276 -0.032787 0.653119 -0.369577 1.006835 1.330359 1.931848 1.776156 0.696444 0.432833 -0.182891 1.180915 0.074824 0.258276 1.331393 1.788205 1.781506 1.641605 0.759944 0.940918 1.268084 1.236164 0.813942 0.772363 0.319672 1.861579 1.551981 1.465513 0.541387 0.556417 0.037051 0.668245 0.048594 1.275290 1.530979 1.723000 0.284872 1.482839)
     )

;;; 69 prime --------------------------------------------------------------------------------
#(69 12.88109067433 #(0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 1)
     12.549396894774 #(0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1)
     12.336643218994 #(0 0 1 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1)
     12.29846572876 #(0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.763634 #(0.000000 1.753520 1.357588 1.349359 1.210221 0.223202 1.616367 1.551867 0.795698 0.663015 1.855602 1.296520 1.111189 0.836249 0.242252 0.311343 0.146391 0.002260 1.429232 0.891762 1.921451 0.270087 0.766162 0.347999 0.440657 0.842536 1.884912 -0.289951 1.825709 1.643856 0.696483 1.776219 1.027783 1.698935 0.462354 0.911005 1.177298 1.522980 1.613608 1.149327 1.612005 1.723442 1.155985 -0.119464 0.831590 0.611851 0.812450 -0.161761 -0.035119 0.717943 1.403965 1.026422 0.295489 1.021151 1.207599 1.201595 1.979504 1.039141 0.816797 1.072647 1.088019 0.486815 1.736794 -0.122594 0.865409 0.359528 1.288615 1.273472 0.770874)
     )

;;; 70 prime --------------------------------------------------------------------------------
#(70 13.072455719834 #(0 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0)
     12.851739571463 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0)
     12.797727584839 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0)
     12.669577598572 #(0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)
     12.665026664734 #(0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.698743 #(0.000000 0.917657 0.123444 -0.097777 0.409283 0.930340 0.256683 1.613682 1.088572 1.577497 0.869528 1.139879 1.003839 0.832060 0.516889 0.190919 0.024640 0.686993 0.802303 0.473356 1.111103 1.660306 0.953037 0.027468 1.873261 1.712852 1.756612 0.779990 1.031228 1.868799 1.363995 0.354652 -0.042712 0.517563 0.176572 0.067269 1.147898 -0.152266 0.463278 1.757448 1.531505 0.505005 0.273214 0.601439 1.433153 1.307425 1.416402 1.626800 1.415407 1.755430 0.283343 1.669748 0.123397 0.161843 1.062569 -0.118134 1.505597 0.660921 1.250885 0.668895 0.436236 0.786729 1.605519 0.854474 0.156990 1.138298 0.102255 0.999860 0.760478 0.166668)
     )

;;; 71 prime --------------------------------------------------------------------------------
#(71 13.189444031428 #(0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0)
     13.116391136133 #(0 0 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 0)
     13.027417182922 #(0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0)
     12.702159881592 #(0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 1 0)
     12.609085083008 #(0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.884054 #(0.000000 0.700486 0.853924 0.989945 1.689407 0.918740 0.744315 1.057189 0.483826 0.768038 0.761188 0.884357 1.632170 0.673515 0.789651 0.498739 1.014446 1.184214 1.216849 1.423179 0.401067 0.233366 0.798127 0.617673 0.664167 1.522969 0.107288 0.236985 0.074207 1.190683 0.813119 1.326250 1.086336 -0.046935 0.500346 1.719498 1.602767 0.905568 -0.024416 0.605887 1.109109 0.246011 1.414593 0.615444 0.901041 1.772998 1.286792 0.236649 1.611391 0.926675 0.981132 0.273330 1.010399 0.017578 1.305678 0.227278 1.205339 1.137628 0.233969 0.266322 1.861144 1.026408 1.529998 1.514863 0.404514 0.107001 0.310359 0.858560 0.683476 1.420264 1.428305)
     )

;;; 72 prime --------------------------------------------------------------------------------
#(72 13.268 #(0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0)
     13.043850898743 #(0 0 1 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 1 1)
     12.841200828552 #(0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0)
     12.708446502686 #(0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     11.036202 #(0.000000 1.555837 1.025791 -0.187849 1.682176 0.956874 1.304511 0.926585 1.500981 1.422966 0.071885 0.038414 1.600046 0.019298 1.593547 1.335251 1.733701 0.347665 1.826757 1.107160 -0.062540 1.807220 1.113454 0.015090 0.575244 0.269891 1.412969 0.180691 0.653291 0.186951 0.556191 1.679837 1.484269 -0.124820 1.793095 1.094361 1.230862 0.269486 1.298574 1.379857 1.440590 -0.049442 1.107503 0.634906 1.016408 0.105408 1.342113 0.599832 1.022758 1.976131 0.720148 1.210875 0.180060 1.717250 0.988749 0.749358 1.654285 0.540438 0.670766 0.750538 0.177837 0.813033 1.194317 0.072315 1.534461 1.358219 1.974172 0.240556 0.224253 0.816651 1.055865 0.158297)
     )

;;; 73 prime --------------------------------------------------------------------------------
#(73 13.602198600769 #(0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 0 0 1 1)
     13.40486240387 #(0 1 0 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0)
     12.986406962349 #(0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0)
     12.877750118249 #(0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     11.118679 #(0.000000 0.434501 0.333216 0.719468 1.458550 0.451221 0.939800 1.736607 1.517449 0.423585 0.554421 0.367915 1.426098 0.667101 0.520957 0.289323 1.675424 0.329151 0.266985 0.885520 0.251753 1.517916 1.196999 1.480591 1.369799 0.350043 -0.079333 0.284003 1.710049 1.137288 1.145704 1.494724 1.244751 1.394959 1.506704 1.488724 0.084836 0.057033 0.706312 0.088758 0.608104 0.160927 0.040245 0.242943 1.035648 0.946944 1.543643 0.645944 1.262427 1.252289 0.315223 1.286484 0.997853 0.282003 0.175037 -0.035960 0.936933 1.816070 0.439689 1.047663 1.457949 0.512868 1.886309 0.641958 1.427687 0.612058 1.562598 0.841326 1.613817 0.254045 0.441391 0.200222 1.598683)
     )

;;; 74 prime --------------------------------------------------------------------------------
#(74 13.442555427551 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.395832061768 #(0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1)
     13.261976242065 #(0 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1)
     13.115156173706 #(0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     11.143587 #(0.000000 0.223354 1.297732 0.690294 0.430385 0.263640 -0.000352 0.171266 0.689208 1.537350 0.634841 1.144467 0.184863 1.148024 0.960496 0.930781 0.289972 0.839713 -0.221555 1.705567 0.092382 1.111238 1.119112 1.544807 1.908028 1.134536 -0.092828 1.476457 0.074742 1.142977 1.070901 0.211990 0.096295 -0.038108 -0.035757 -0.208502 0.613663 0.142985 1.212992 0.039257 0.172057 0.009624 -0.084753 1.626470 1.382426 1.139975 1.877900 1.703467 0.176346 0.636074 0.498859 0.902619 1.381147 1.672351 0.888918 1.860899 1.800433 0.017469 -0.109214 1.254427 0.550313 0.119931 1.615840 1.675114 0.536367 0.684312 1.012642 -0.010625 1.136293 1.144114 -0.063852 0.984962 -0.037460 0.325008)
     )

;;; 75 prime --------------------------------------------------------------------------------
#(75 13.676464080811 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1)
     13.618774108319 #(0 1 0 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 0 0)
     13.357945520561 #(0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)
     13.254356384277 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     11.256054 #(0.000000 0.381655 1.033561 1.415017 1.262343 1.145383 1.461399 -0.060049 0.741321 1.771985 0.892627 1.389406 1.944436 1.069766 0.112067 1.378147 0.803500 1.090366 1.191732 1.179956 0.662808 1.195478 0.415344 1.614436 1.658955 0.252101 1.357739 0.248581 1.665508 1.312384 0.042090 1.818294 0.664742 0.981456 0.935826 0.853087 1.228400 1.704388 1.321483 1.684956 1.746245 1.353541 1.427954 1.574369 1.695422 0.245862 0.615121 0.877734 1.656741 1.787665 1.664886 0.482302 0.433966 0.511882 1.921395 0.634727 0.722862 0.218401 1.012773 0.962796 0.263415 -0.125167 1.756777 1.045617 0.925910 0.409731 1.774654 1.571995 0.929924 0.857474 0.033493 0.173762 0.978908 0.029818 1.437907)
     )

;;; 76 prime --------------------------------------------------------------------------------
#(76 13.691219362758 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0)
     13.288178191792 #(0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     11.299403 #(0.000000 1.241495 0.999479 0.964904 1.838997 0.522125 1.222791 1.279289 0.882294 0.132471 0.977891 0.742621 0.938716 1.611221 0.602686 1.284526 0.392724 -0.171664 0.713380 0.598817 0.518470 0.396219 1.818132 0.187349 0.895660 1.612149 1.236258 -0.045504 0.739878 1.813611 0.440468 -0.245870 0.612876 1.137698 1.827779 0.633777 0.901279 1.807544 0.023310 0.221511 0.430111 0.194415 1.609028 0.853130 1.801377 1.022800 0.532060 0.068653 0.709012 1.539447 1.220525 0.103244 0.410303 0.074064 1.078201 1.115672 1.201014 0.374624 0.815839 1.453531 0.640044 0.629945 1.568741 1.330625 0.048198 0.928694 1.224285 1.891436 0.625319 0.183677 0.585615 0.389148 -0.111707 1.866034 0.702952 0.571396)
     )

;;; 77 prime --------------------------------------------------------------------------------
#(77 14.029663085938 #(0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1)
     13.845010757446 #(0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0)
     13.330450043717 #(0 1 0 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1)
     13.158900260925 #(0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     11.239864 #(0.000000 1.109621 0.890720 1.863634 0.134879 1.644549 1.817765 0.480887 0.969833 0.546584 0.713110 1.218674 1.808239 -0.071246 0.280540 0.135188 1.320442 0.275620 0.596746 0.251612 1.443239 0.551624 1.129987 1.096342 0.309075 1.305569 1.150699 0.524859 1.027640 -0.005707 0.848125 0.083280 0.451110 0.402089 0.573143 0.977593 0.391596 -0.086082 0.958365 0.825219 -0.128403 -0.035252 0.320221 0.001786 0.309046 1.509392 0.192510 1.927761 0.561747 0.632578 0.154824 1.672061 0.617582 0.285347 1.718501 1.246786 1.227906 0.851849 0.794182 1.908346 0.672980 0.322095 0.554457 0.637541 1.508116 1.300005 0.136564 1.239918 1.133282 0.396450 1.562246 0.739157 1.281788 1.069054 -0.148058 1.643111 0.030518)
     )

;;; 78 prime --------------------------------------------------------------------------------
#(78 13.920186042786 #(0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.683882347187 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)
     13.498236182018 #(0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     11.639300 #(0.000000 1.444740 1.330418 1.228692 1.557311 1.886873 0.995250 1.605060 0.146579 0.383570 0.838826 1.385863 1.700528 1.067474 0.939476 0.250724 0.010874 1.095024 1.577274 1.581792 0.900002 0.965555 0.517227 1.776338 1.793449 0.470719 1.762490 0.750045 0.040104 -0.038553 1.061092 -0.171106 -0.005245 0.239462 1.109468 -0.185231 1.657940 1.411404 0.316343 1.038738 0.771111 0.592423 1.587574 1.478494 -0.248962 -0.078133 -0.053091 1.569874 0.094895 0.455466 1.286336 0.154083 0.963308 0.353958 1.415946 0.229199 0.123859 0.095481 -0.102981 1.289160 0.762350 -0.088173 0.866346 0.549633 -0.109149 1.492669 0.382902 1.023349 1.079868 -0.275265 0.951262 0.916281 1.417148 1.504252 0.571734 1.791701 1.117613 1.483546)
     )

;;; 79 prime --------------------------------------------------------------------------------
#(79 14.000000000005 #(0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0)
     13.77695274353 #(0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0)
     13.178678233398 #(0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     11.822309 #(0.000000 1.287834 1.482178 1.225615 0.377335 0.987336 0.854630 1.119063 0.579927 1.694615 1.696355 0.954657 0.578915 1.699769 1.918381 0.402669 1.692082 0.093979 0.683596 1.265664 1.852374 1.452670 0.605715 0.323950 1.114435 1.077825 1.850615 0.376783 0.249026 0.582006 0.924428 1.263835 0.369729 0.899371 1.573830 1.601979 1.533407 0.475399 1.370329 0.046108 1.473031 1.222650 1.735396 -0.061803 1.413475 0.612188 0.893376 0.535710 0.071805 1.072960 1.591368 1.760374 0.555545 0.172784 0.095049 0.398064 1.084636 0.935731 -0.119359 -0.027653 -0.114990 1.496204 0.198897 1.361297 0.028404 0.834063 1.883012 0.422217 1.381685 1.475074 1.881618 1.812030 1.621278 1.645626 1.160226 1.702831 1.740155 1.376602 1.022833)
     )

;;; 80 prime --------------------------------------------------------------------------------
#(80 14.309369414534 #(0 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0)
     14.119678497314 #(0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1)
     13.563344594765 #(0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0)
     13.547472953796 #(0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     11.850996 #(0.000000 1.923753 0.207464 0.106551 0.052573 1.185030 0.585776 0.530437 0.400860 0.604131 1.402735 0.877646 1.474500 1.459669 0.124363 0.225126 -0.082702 0.470808 1.252222 1.782389 0.573241 1.488777 0.648072 1.098672 1.397661 1.005371 0.482778 0.775387 0.323520 -0.054461 1.787321 0.425380 1.109768 1.720601 0.008270 1.783768 0.462057 1.475670 0.388588 1.856675 0.324432 0.000032 0.401085 1.101134 1.465674 0.811806 0.160773 1.177489 0.702036 1.253724 1.079275 0.789570 0.319269 1.064353 0.568766 1.090129 0.506116 0.246433 0.752833 1.897920 1.751946 1.367062 1.059717 0.627555 1.303947 0.339922 0.648486 0.078103 1.162853 0.125846 1.197362 0.652326 1.581347 0.917897 1.372245 1.382548 1.347964 1.692676 1.401581 1.663786)
     )

;;; 81 prime --------------------------------------------------------------------------------
#(81 14.317508929282 #(0 1 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0)
     14.256287400004 #(0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 1 1)
     13.652944564819 #(0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     11.685857 #(0.000000 -0.040391 1.131311 0.019069 -0.037458 1.353503 0.148279 0.224472 0.311463 0.524761 0.168723 0.260394 0.791519 0.332435 0.741557 1.238699 0.473804 0.677736 0.568135 1.767246 0.074862 1.364437 1.247670 1.601182 1.752298 0.887626 1.413716 0.060632 1.627882 1.473798 1.035145 0.573759 0.093034 0.630049 1.254752 1.122726 -0.289866 0.164029 1.815696 -0.037242 1.749053 0.895509 0.951675 0.058817 1.597293 1.240331 1.438622 -0.044412 0.777350 0.757925 1.448836 0.102016 0.153065 0.531193 -0.101505 0.537232 -0.137195 0.778521 0.684756 0.540993 1.875908 0.021696 1.286286 1.290897 0.104490 0.883543 0.911221 1.330125 -0.249724 1.479590 0.629937 0.605166 0.948781 1.530031 0.215407 0.452406 0.559695 1.333624 0.104992 1.221576 0.471772)
     )

;;; 82 prime --------------------------------------------------------------------------------
#(82 14.492313651671 #(0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)
     14.126787045134 #(0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.793913 #(0.000000 1.170349 -0.097255 1.488841 0.017345 1.364978 0.461705 1.727372 0.840293 0.054901 0.997486 0.323991 1.551969 0.141358 0.229977 1.365159 1.193638 1.002416 0.156161 0.227249 1.918915 0.252739 1.494449 1.946944 0.107423 1.228288 0.347901 1.092938 0.070295 0.369466 0.036890 0.021648 0.743776 0.503837 1.396482 0.203930 0.913320 0.172275 0.195615 0.116574 0.368468 1.178622 0.517182 1.549983 1.439848 0.172758 1.651794 0.396402 0.720403 0.645746 0.165501 0.171553 0.431707 -0.011481 0.140885 0.475134 1.287334 1.342788 1.305448 -0.049168 0.822490 1.483831 1.714022 -0.063970 0.640560 1.220804 1.731432 1.410055 0.654261 0.302038 1.015069 1.234688 0.697108 1.668639 0.527685 1.136551 0.839111 0.160152 0.026120 0.544483 0.663823 0.085128)
     )

;;; 83 prime --------------------------------------------------------------------------------
#(83 14.249828726851 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)
     14.019070339131 #(0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.781927 #(0.000000 0.530341 1.462561 0.792280 0.894542 1.667883 1.244382 0.182770 1.363983 1.783346 1.218239 1.712844 1.488441 1.507912 0.327828 1.691918 1.871686 1.520428 0.686325 0.485910 0.105318 1.820285 0.676625 1.334245 0.330571 0.586894 0.050602 0.636315 0.942987 1.350991 -0.161344 1.647640 0.213664 1.715449 0.981739 1.633688 0.787265 1.815226 0.909485 1.319231 1.798180 0.703953 1.113935 0.133946 1.066183 0.544998 1.257395 0.559915 1.632454 0.803147 0.286591 0.274266 0.301649 0.618040 1.440041 1.608840 0.918621 1.531779 1.536820 0.481949 -0.082803 0.686537 0.684744 0.181267 1.926122 0.440091 0.393218 1.498843 1.583768 0.440312 1.781636 0.822340 0.745293 0.543583 1.876210 1.259398 0.246035 1.623192 1.482278 0.145790 0.640657 1.435786 0.301700)
     )

;;; 84 prime --------------------------------------------------------------------------------
#(84 14.422843763275 #(0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)
     14.299305314276 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.264351844788 #(0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1)
     14.024940956301 #(0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     12.004509 #(0.000000 1.277509 1.189592 1.446784 1.053877 1.331731 0.905086 -0.324632 -0.414553 0.466868 0.808486 0.989202 0.871063 0.707718 0.942488 -0.202099 1.911154 1.330897 0.707097 1.079185 1.314532 1.409379 -0.313856 1.410196 0.490850 0.345208 1.059653 0.367735 0.764355 0.269834 1.122760 0.148507 1.796443 0.661215 0.478102 0.328019 1.203103 0.699161 0.614278 0.799993 0.522522 1.333019 0.059328 1.362159 -0.108220 0.288238 0.966131 0.592853 1.073228 1.341413 0.082539 1.136860 -0.048696 1.100377 0.364296 -0.516615 0.656912 0.662283 1.741784 0.470812 1.160452 0.651716 0.538545 1.119000 0.523460 0.980785 -0.367373 1.335729 -0.044907 0.638042 0.865138 0.183679 -0.209664 1.279064 1.428596 0.695890 0.531733 1.198948 0.124891 0.995194 1.537150 0.855236 0.017794 0.679676)
     )

;;; 85 prime --------------------------------------------------------------------------------
#(85 14.721940394615 #(0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1)
     14.400919537796 #(0 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)
     14.253310943921 #(0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     12.039301 #(0.000000 0.149657 0.168518 1.773141 0.538506 1.625616 1.072180 1.321021 1.055680 1.727304 0.540394 1.695622 0.798492 0.770518 1.163725 -0.065875 1.311492 1.390917 1.389698 1.265307 1.586608 0.776281 0.428607 1.238289 0.038149 0.126323 0.046653 1.153154 1.073400 1.400608 0.740725 0.450922 0.614097 1.925040 1.177843 1.209951 0.917891 1.069069 1.105236 1.458497 0.609869 0.102141 0.538918 1.490561 0.193033 1.913814 0.035299 1.312357 0.675572 1.514172 0.931182 0.913987 0.112454 0.838766 -0.069918 0.814992 0.249891 1.253838 1.675524 1.790600 1.558739 -0.379214 1.760864 1.443013 1.677219 -0.390056 0.800589 1.781779 1.295915 1.256057 -0.056767 0.818539 1.000559 -0.026975 1.774770 0.332170 -0.108745 0.752305 0.477748 0.182615 1.194757 1.490663 0.572421 -0.106723 -0.159562)
     )

;;; 86 prime --------------------------------------------------------------------------------
#(86 14.993455205117 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1)
     14.394402956102 #(0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 0 1)
     14.017106967247 #(0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

     11.840326 #(0.000000 1.245722 0.828003 1.708429 1.063770 1.069235 1.168816 0.968148 1.757909 0.722838 0.259673 0.587983 1.075019 0.244887 0.711027 0.351768 0.547579 1.242458 0.885462 0.363198 0.762477 0.413777 0.102231 1.673876 0.229266 1.573827 0.131656 1.849326 0.442221 1.142077 1.793307 0.358676 1.624291 0.368933 0.260608 1.521706 0.921970 1.227777 0.523225 0.076505 1.513864 1.635909 1.833596 1.644361 1.122009 0.722632 0.590190 -0.119164 0.988147 0.934217 0.148785 1.776617 1.320398 0.797478 1.762137 0.720651 0.834263 1.652184 1.312187 0.821513 1.889830 0.489234 1.017541 0.848079 1.479264 1.503801 -0.079078 0.579380 -0.011220 0.294908 0.801151 1.672624 0.234183 1.377348 0.594402 1.461213 1.836654 0.542457 1.520245 0.732249 0.741348 0.487670 1.197161 1.215874 1.847161 1.441704)
     )

;;; 87 prime --------------------------------------------------------------------------------
#(87 14.798576861642 #(0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0)
     14.519235937355 #(0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)
     13.98394199918 #(0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

     12.278568 #(0.000000 0.412364 1.223406 1.298739 0.006362 1.770656 1.094099 1.408717 1.716793 0.694176 -0.043292 1.288866 -0.087361 0.119449 0.680407 0.992194 0.444975 0.155017 1.650203 1.792642 -0.090438 0.257539 0.893761 1.411144 1.009541 1.789497 0.736787 0.065074 1.110366 0.108902 1.078271 0.038187 1.482789 0.863019 1.387008 0.560131 0.969230 1.865104 0.540981 1.226077 1.214274 0.411539 0.219403 1.117461 0.515727 1.631561 1.097264 0.789113 1.340605 0.702159 1.630237 0.654006 1.730371 1.548904 0.239716 0.015830 0.916299 1.890040 0.455797 1.482705 0.462974 1.210534 1.548630 1.878069 0.425900 1.380459 1.605786 0.842110 1.265157 0.041089 0.502876 1.725587 1.345118 0.849311 1.638318 1.522073 0.846612 0.322261 1.950929 0.367392 0.876150 1.615912 1.594580 1.345836 1.701283 1.854293 1.691318)
     )

;;; 88 prime --------------------------------------------------------------------------------
#(88 15.158827781677 #(0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1)
     14.908 #(0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0)
     14.84298551254 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.837036132812 #(0 1 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)
     14.825139803345 #(0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     12.267925 #(0.000000 0.754460 0.652788 -0.033735 0.216378 0.368348 0.713363 0.924529 0.547182 0.524683 1.283563 0.812515 1.390031 1.389931 1.051739 0.796371 0.316181 0.756561 0.446962 0.390794 0.332449 1.186846 1.026512 0.865814 0.311668 1.528157 -0.105637 -0.032159 0.936438 1.732794 0.733784 0.064966 0.487154 0.490956 0.956031 0.105321 1.334677 0.642384 1.552601 0.113089 0.543796 1.179294 0.724583 0.296678 1.864205 1.607135 1.707671 1.557779 1.667891 1.212015 1.656287 0.872714 1.722735 0.302166 1.164200 1.785858 0.746105 1.293976 0.673090 0.164975 0.940912 1.010588 0.563849 0.297045 1.739515 0.364008 1.749362 1.937720 1.196475 0.218009 0.815956 0.778317 1.134642 -0.346215 1.899577 0.745130 1.064204 0.943983 1.710673 0.698309 1.669642 1.750405 1.326278 0.581812 0.893851 0.300904 1.316352 0.740312)
     )

;;; 89 prime --------------------------------------------------------------------------------
#(89 15.157893052401 #(0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1)
     14.69031483888 #(0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

     12.651973 #(0.000000 0.471939 1.363563 0.108442 0.730890 1.385921 0.996613 1.218010 -0.023093 -0.208802 0.525127 1.645619 1.866316 -0.103319 1.696867 0.293852 0.609618 -0.365048 0.074968 1.171058 1.291555 0.982487 -0.095011 1.235712 0.124715 0.650807 0.969652 1.482253 -1.839298 0.495598 1.635463 1.206163 0.159770 0.913806 0.743779 1.662616 1.121384 0.276599 -0.109640 0.455045 0.323325 1.017570 1.039953 1.144361 1.685230 1.302811 1.560763 1.052119 1.511649 1.626125 0.416173 0.001014 0.337360 1.692176 0.439056 1.808475 0.388513 0.732715 0.073367 1.522512 1.492169 1.601574 1.245074 0.034793 0.183671 1.478965 0.656010 -0.151913 -0.066876 1.134750 1.567692 1.595653 -0.490514 0.831137 1.390058 0.980535 1.620810 1.146107 0.480464 1.409584 0.829325 0.367767 0.067898 1.281604 1.288599 0.866958 0.283750 1.622425 0.255839)
     )

;;; 90 prime --------------------------------------------------------------------------------
#(90 15.253639451837 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.917379556641 #(0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)
     14.831111851861 #(0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     12.578275 #(0.000000 0.352853 1.776583 1.006669 1.230317 0.463070 0.333844 0.626069 0.645700 0.367359 0.379690 -0.171225 0.144022 0.927449 1.818760 1.174975 1.429937 1.581624 0.414658 1.819385 0.163889 1.853150 -0.272025 0.564434 1.466496 1.124176 0.612306 0.068344 0.249396 0.696224 1.559513 1.967924 0.189973 1.308010 0.018644 -0.393229 1.173932 1.630189 1.389419 0.415176 0.053722 1.840251 0.883656 1.102177 0.248822 1.065762 0.083677 0.596246 0.702770 1.102675 -0.161312 0.497115 1.459369 0.468208 1.658864 1.182907 1.337511 -0.094214 0.809584 1.208696 1.478172 1.502669 0.852172 0.154069 1.195031 1.691869 0.306220 1.565424 1.171824 1.217510 0.921889 0.088021 1.494758 0.225219 0.442189 1.345095 0.331248 1.767593 0.389567 0.923971 0.853385 1.038999 -0.117295 -0.294579 1.673740 0.571394 0.725540 -0.171347 1.178060 1.069325)
     )

;;; 91 prime --------------------------------------------------------------------------------
#(91 15.264 #(0 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0)
     14.775403022766 #(0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0)
     14.702056847646 #(0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.629576 #(0.000000 1.679240 0.654985 0.776518 1.547019 1.159878 -0.068081 1.172938 1.021768 1.809376 1.141874 1.358206 0.728796 1.768509 1.637295 0.889668 1.068659 1.299650 1.780210 -0.034723 1.744365 1.210389 1.563365 0.610598 0.844614 0.656048 1.724491 1.682362 1.538038 1.266915 0.905536 0.358275 0.304424 0.682976 0.355716 1.314345 1.820261 1.763058 0.591130 0.643209 -0.331434 -0.012008 0.586484 0.541365 0.793949 0.204461 1.566304 1.095366 0.023427 0.699966 0.935116 0.681367 0.664912 -1.674827 0.728626 1.336879 0.404289 0.548549 1.394881 1.631360 0.524503 0.476542 1.712185 0.135718 -0.114241 1.441882 1.096389 1.775230 0.672996 1.443928 0.368348 1.545666 0.590401 0.727335 0.429758 1.014322 1.489869 0.902604 1.552226 0.652601 -0.019285 1.045323 1.807951 0.355588 0.401540 0.581587 0.726943 0.783052 1.308264 -0.010893 0.403544)
     )

;;; 92 prime --------------------------------------------------------------------------------
#(92 15.373 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     15.307026596891 #(0 0 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0)
     14.9424 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)
     14.556435035882 #(0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     12.531982 #(0.000000 1.197630 1.286524 1.134488 1.687179 1.331282 0.423861 0.229597 1.341267 0.641466 1.644844 0.346189 0.931973 0.940738 1.498691 0.162354 0.581651 -0.535354 0.064798 0.250870 1.786906 0.407749 0.302417 1.250585 1.687763 0.769284 -0.419091 0.904445 1.470606 0.441817 0.647582 0.860484 1.045901 1.752163 1.201123 1.924536 0.063187 1.109556 0.669731 1.249843 0.479142 0.224540 0.475146 -0.046664 1.463038 1.156496 0.799478 1.867400 0.601784 1.202337 1.730280 0.809457 1.646588 1.634621 1.339264 0.031345 1.297349 0.079275 0.056181 0.599928 0.485525 1.063617 1.212654 1.359354 0.890919 1.457699 0.184004 1.396460 1.057016 1.480759 0.729965 1.622920 1.273612 -0.133136 1.493449 1.201381 0.873388 1.693488 1.000367 1.975718 -0.289631 1.156916 1.260537 1.502312 0.530260 0.756128 0.694658 0.478037 0.168640 0.999282 0.734376 1.195628)
     )

;;; 93 prime --------------------------------------------------------------------------------
#(93 15.814494404587 #(0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     15.072628413546 #(0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1)
     14.994668960571 #(0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     12.740920 #(0.000000 0.188043 1.250705 -0.000151 1.228016 -0.193061 0.162121 1.280943 1.006184 1.384922 -0.409434 0.098067 1.797771 -0.148143 1.763714 0.086220 0.037436 1.743021 -0.039108 1.051706 1.390078 1.372962 0.674078 1.052485 0.649269 1.756623 0.123223 0.377072 0.831176 0.312538 1.829401 1.413709 0.513972 0.114445 1.619219 1.310546 0.782819 -0.161318 1.823344 1.884581 0.931950 1.118936 0.120509 0.392247 1.584774 0.336701 0.969706 -0.295968 0.407316 1.508201 0.525923 0.147302 1.138294 1.309043 1.176706 1.169358 1.400554 0.272430 0.264573 0.372944 0.887675 0.444991 0.794783 0.347072 0.448518 0.681926 1.421566 1.117338 1.185835 0.616689 1.950590 1.666723 0.377147 -0.194421 0.320546 0.480874 0.042091 0.774658 0.185282 1.458199 0.139066 1.034689 1.737673 0.372517 0.385303 -0.008946 1.597156 0.699801 0.038969 1.129397 1.490356 0.165484 1.258360)
     )

;;; 94 prime --------------------------------------------------------------------------------
#(94 15.835750579834 #(0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1)
     15.441287870957 #(0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)
     14.811392756555 #(0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     12.750939 #(0.000000 0.411806 0.932107 0.620165 0.690812 0.078780 0.207637 1.355914 1.428537 1.008014 0.163175 -0.040811 0.574537 1.489363 0.614312 1.194371 0.935368 1.005805 0.928318 0.370350 -0.065244 0.435006 1.441155 1.395062 1.621190 0.021982 0.013473 1.227189 1.566996 1.720462 0.409641 1.816058 0.717818 1.188239 0.348420 1.488145 -0.204496 0.768563 1.723000 0.656714 0.746940 1.143901 0.283060 0.314007 1.380832 1.686174 1.708777 1.265056 1.438127 0.011357 1.011067 0.933857 0.061587 0.441761 0.692061 1.431374 1.644647 1.236298 1.428838 0.828837 1.716444 1.264772 0.205713 -0.192299 1.315354 0.747254 0.888175 0.332702 0.710146 0.094558 1.628910 0.414220 0.853669 0.773296 1.067344 0.189408 0.529961 0.799169 1.427935 0.528594 1.063577 1.008261 1.850893 0.082046 0.297715 1.142832 1.438558 0.590975 0.337215 0.929215 -0.054223 1.059628 0.837326 1.297742)
     )

;;; 95 prime --------------------------------------------------------------------------------
#(95 15.827 #(0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.616318215916 #(0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0)
     15.240 #(0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     13.142269 #(0.000000 0.446688 0.943416 0.420303 1.262593 1.481551 1.816759 1.602944 1.335361 0.232664 1.151008 -0.271285 1.095303 1.115766 0.807686 0.853009 0.833502 1.638512 1.799897 1.539482 1.210974 0.251853 1.140131 0.074874 0.330599 0.975283 0.196529 0.497575 1.108776 0.454628 0.099328 0.206635 0.429721 0.767821 0.776883 0.241734 1.086834 1.177070 0.648981 0.385316 1.435368 1.745089 1.820420 0.447206 0.305271 0.314686 1.406340 0.245081 0.379705 1.727534 0.485952 0.138705 0.256316 1.115237 1.593934 0.143114 0.862360 0.700441 0.802048 1.455463 0.924965 0.639165 0.663868 0.248541 1.349485 0.397723 0.076215 1.824268 -0.142783 0.500073 -0.174686 0.657917 1.428001 1.143254 1.721062 1.414540 0.572450 0.100496 0.158099 1.989891 0.400767 0.722835 0.589185 1.822999 0.245200 1.420401 0.615495 1.234701 0.314335 1.000579 0.095663 0.630419 -0.246846 1.810582 0.891630)
     )

;;; 96 prime --------------------------------------------------------------------------------
#(96 16.039880627473 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.648203810823 #(0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 1)
     15.281 #(0 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)
     15.135 #(0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

     13.204725 #(0.000000 1.076776 1.347926 1.525387 1.703093 0.146409 1.317966 1.859505 0.707164 0.830831 0.443644 0.827604 0.209278 0.749602 0.059328 1.266240 1.293110 1.093154 0.211555 0.428549 0.234880 1.309308 1.849895 0.556242 1.146080 1.112880 0.255098 0.697511 0.976003 0.447974 -0.060853 0.989003 0.981427 1.357143 -0.108507 0.508258 1.350016 1.370815 0.706419 1.417351 0.130302 -0.164616 0.121236 0.899029 1.704503 1.010661 0.546214 0.056403 -0.018220 0.776486 1.737256 -0.288192 0.433604 0.009935 1.911131 -0.011896 0.429002 1.681473 1.443604 1.443566 1.122321 0.851995 1.174060 1.043964 1.121883 1.576569 1.220681 1.062173 1.465088 1.469385 0.007614 0.689833 1.413660 1.426225 0.669850 1.847272 1.185576 0.967159 0.585257 1.342471 0.036719 1.434241 0.611492 1.555664 1.306827 1.708606 1.324519 0.822315 0.043925 -0.223593 1.382941 1.347398 -0.049609 1.255274 0.199951 0.735570)
     )

;;; 97 prime --------------------------------------------------------------------------------
#(97 15.972457232959 #(0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.726 #(0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0)
     15.685384750366 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)
     15.404807595571 #(0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

     13.130301 #(0.000000 1.135539 0.220794 0.501697 0.344944 0.755439 0.145509 0.410232 -0.069275 0.590695 1.315603 0.498558 0.367854 0.758084 1.750221 1.169065 1.563732 0.376182 1.614424 1.432746 0.401221 0.948428 0.164632 0.245083 0.882567 0.851738 0.460102 1.561468 0.587073 1.409750 1.205538 0.791857 1.107094 -0.019229 1.649686 1.725724 1.387495 1.675489 0.316317 1.218656 1.514383 -0.251456 0.140774 0.306294 0.782155 1.061756 1.669052 1.881173 0.577275 0.454949 0.395989 0.432079 1.150703 0.455565 0.073468 -0.034277 -0.116020 1.243542 1.455278 0.818342 1.963380 0.647866 1.701929 1.360171 0.710187 1.751986 0.222756 0.275196 0.862379 0.351462 0.384630 -0.050442 1.402016 0.933288 0.004450 1.443734 0.717086 0.049513 0.145930 0.282718 1.270029 -0.172234 0.514496 1.445399 0.031963 1.327775 1.602313 0.542788 1.757408 0.829093 0.848058 -0.074176 0.289279 1.318336 0.872820 0.817913 1.039671)
     )

;;; 98 prime --------------------------------------------------------------------------------
#(98 16.082024156883 #(0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.695913722267 #(0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
     15.435913738557 #(0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

     13.248109 #(0.000000 0.806557 0.262881 1.867756 1.016904 1.114474 1.460983 1.144977 0.448064 0.564776 1.309806 1.407660 0.456039 0.241507 1.599983 1.315170 1.685695 -0.046356 0.667947 0.978005 0.565613 1.400774 0.028675 1.910738 0.601055 0.692619 1.788011 0.339211 0.756386 1.704737 0.206648 1.489324 1.126591 1.063848 1.933635 1.364613 0.820200 1.412620 0.711578 1.806407 1.151760 1.451559 0.613411 1.775502 1.528788 0.601964 0.555366 0.404114 0.239432 1.363959 1.526932 1.485087 0.640645 1.353945 0.021482 0.454975 0.710329 0.785540 0.581148 0.546960 1.392598 0.381629 1.529397 0.167858 1.862416 0.867406 0.913261 1.620342 1.571704 1.174026 0.693710 0.486823 0.941496 1.086163 -0.040154 -0.028709 -0.350031 1.360503 1.509944 0.465076 1.731316 1.903022 0.000146 0.055909 1.763235 1.211515 1.381084 1.828342 1.857280 1.390634 1.624002 1.283691 1.528542 1.941368 -0.211128 0.514289 -0.192757 0.769871)
     )

;;; 99 prime --------------------------------------------------------------------------------
#(99 16.078 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0)
     15.391923904419 #(0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

     13.417088 #(0.000000 1.559945 0.679892 0.674962 1.756398 1.695903 0.401813 0.005080 1.029154 0.671775 1.171238 0.285684 0.630452 0.755517 0.815868 1.357683 0.610223 1.143563 1.614983 1.595505 1.069498 0.796386 1.119027 0.834828 0.740210 1.949991 0.061002 0.953336 1.230924 0.958287 1.371388 1.564298 0.261222 -0.010390 0.773606 0.940706 0.956031 0.810858 0.887419 1.164018 -0.115594 1.559292 0.579724 0.991116 1.439472 1.418994 1.216858 0.729381 0.540029 0.156547 1.728180 0.684488 0.509670 1.038439 1.050519 0.045074 1.132486 0.551763 0.844086 -0.039091 0.477565 0.399046 0.989335 0.707601 1.907892 1.929551 0.370973 -0.067772 -0.350270 0.633308 1.462355 0.124279 1.017802 0.790201 1.200371 0.099750 1.422687 1.061369 1.436887 0.911376 0.081101 0.334191 1.262800 0.349036 0.319207 1.279195 0.066768 0.784048 0.689953 -0.085822 1.130693 1.794484 0.390554 1.520836 0.796991 1.632885 0.940490 0.541288 1.233197)
     )

;;; 100 prime --------------------------------------------------------------------------------
#(100 16.360503791276 #(0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0)
      15.909478013087 #(0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0)
      15.637986183167 #(0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

      13.350323 #(0.000000 1.347291 1.335295 1.559511 1.513041 0.420091 1.446150 0.936304 0.968825 0.471476 0.229477 1.490924 1.146614 0.849935 0.272878 1.543067 0.347814 -0.183964 1.192151 -0.000406 1.244043 0.510242 0.312847 0.704933 0.429063 -0.195030 0.012066 0.364912 1.415345 0.499942 0.823523 1.178868 0.020705 1.397189 1.198130 0.051001 1.467040 1.323921 1.208960 0.128077 0.136646 0.425231 0.308165 1.120807 1.593734 1.046358 -0.090457 0.819613 1.336156 0.159520 1.565179 1.640817 0.820969 0.025706 0.585067 1.097878 0.806226 1.779178 1.936539 1.231978 1.727892 -0.025632 -0.199731 1.298209 1.651621 1.113488 1.644500 1.253673 0.566898 1.212925 0.163316 1.648533 0.338483 1.505009 1.463799 1.930395 1.037162 1.275538 -0.138791 0.123191 1.494724 0.659895 1.078520 0.561220 1.267316 1.542507 0.599513 0.706521 1.538514 1.921392 0.977027 0.964494 1.829239 1.658676 0.623196 0.410435 0.630435 0.208433 1.515059 1.199698)
      )

;;; 101 prime --------------------------------------------------------------------------------
#(101 15.994265071036 #(0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0)
      15.74836063385 #(0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0)
      15.735968313601 #(0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

      13.367912 #(0.000000 0.654247 -0.091498 1.529566 0.905510 0.063118 0.360987 1.604033 0.336155 0.141129 0.328458 1.562039 0.273322 1.796364 1.134065 1.496218 -0.147314 1.491008 0.375911 1.079236 0.689347 1.311013 0.300978 1.275996 1.814558 0.081484 0.406729 0.712703 -0.356399 -0.038969 0.024023 1.429284 0.887421 1.037849 0.501236 1.174085 1.046310 0.104379 0.585085 0.083337 1.911528 0.153750 1.390828 1.121544 0.607100 0.513995 0.179122 1.607381 1.463256 1.114189 0.457923 1.704870 0.126489 1.289546 -0.023958 1.001482 0.366164 0.161977 0.543713 0.947266 0.809842 0.062521 1.247137 0.150843 0.714702 -0.062568 0.692229 -0.259662 0.911269 1.122622 1.204335 -0.089709 1.207972 0.102285 1.714895 0.827832 1.052186 1.303130 0.534419 1.551686 0.717385 0.094388 0.534082 1.213040 0.565091 0.858818 0.204472 0.410718 0.986172 0.643377 0.318661 0.346982 0.842806 0.272745 0.132947 0.372491 1.102802 0.886143 0.185439 0.509936 0.596354)
      )

;;; 102 prime --------------------------------------------------------------------------------
#(102 16.342473246951 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 1)
      15.374809992584 #(0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

      13.734776 #(0.000000 0.221877 1.243121 0.124249 0.534786 1.740095 0.309831 0.472160 0.913336 1.586492 1.542612 0.127636 1.695775 -0.249305 0.474613 1.165661 1.540073 0.214973 0.496311 1.279505 1.164011 0.006533 1.566821 -1.776331 1.272407 1.234801 0.842033 1.662228 0.023604 1.862499 1.249007 1.372462 0.763687 1.466331 0.268718 1.112790 0.942525 0.201331 0.255182 0.847207 0.448221 0.205017 1.535718 0.821255 1.392787 1.591272 1.418683 0.550308 0.502008 0.891037 1.292234 1.497745 1.636601 1.314780 0.241229 1.735772 1.046111 1.516883 1.505525 1.125668 1.191540 1.024114 1.722574 1.218940 1.628030 0.993848 1.509907 0.258484 0.875189 0.582090 0.563444 1.700417 0.435370 1.333991 0.876028 1.270626 1.365904 0.451492 -0.076741 1.558101 0.002255 0.605875 0.745534 0.526966 1.785687 0.643974 0.605130 0.715142 0.306563 1.460811 0.757927 1.268627 0.072038 1.421838 1.348002 0.106015 1.197327 0.298970 1.442966 0.917147 -0.204056 -0.006923)
      )

;;; 103 prime --------------------------------------------------------------------------------
#(103 16.7018587939366 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)
      16.296298498866 #(0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

      13.772705 #(0.000000 0.238354 0.536558 0.324929 0.704065 0.507699 1.507532 1.517100 0.638503 1.444394 0.431866 0.840836 0.265987 0.223329 -0.020791 1.664785 0.769555 0.180190 1.719330 0.271487 0.974353 1.134294 -0.055623 0.638430 0.946376 0.202208 0.781306 0.139141 1.445604 1.331632 1.326980 0.618119 0.040494 1.345823 0.380539 1.247570 0.485588 0.077155 1.900221 0.559785 0.028733 1.556634 1.873143 0.584114 -0.004187 0.970645 0.481924 0.856825 0.182393 0.681554 0.438141 0.522591 0.830257 1.834920 1.657443 1.318948 1.258636 1.781056 0.372371 -0.068325 0.738084 -0.067199 0.666146 0.378842 1.473734 1.566571 0.336762 1.070138 1.335755 0.258751 0.922542 -0.100712 1.927664 1.600578 0.511452 1.293875 1.594452 0.415793 0.952708 0.779595 1.753124 1.503190 0.875825 0.615630 1.312943 0.645958 1.194518 1.043613 0.195353 0.359734 1.643154 1.907836 0.852858 1.602648 0.618506 1.343838 0.398837 1.157758 1.729708 1.187759 0.597997 0.494442 0.872763)
      )

;;; 104 prime --------------------------------------------------------------------------------
#(104 16.659368297545 #(0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      16.473171464163 #(0 0 0 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0)
      15.919013023376 #(0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

      13.993371 #(0.000000 0.188329 1.111048 -0.100154 -0.376245 1.597602 0.096426 1.249824 1.402639 1.204005 1.010524 0.161963 0.009312 1.478244 0.927302 1.278700 1.149346 0.997963 0.926399 0.364278 0.119416 1.764457 0.410808 0.352700 0.706182 0.878757 0.400477 1.353085 0.528155 0.702960 0.645851 0.085977 0.595468 1.661199 1.285255 1.274286 1.425240 1.377314 0.489061 1.381083 0.598625 0.946450 1.682002 0.658031 0.529033 1.453881 1.106832 1.384738 1.551505 0.133627 1.730866 1.864778 1.503836 0.895453 0.980989 0.773824 1.766372 0.356812 1.848877 1.340434 -0.030271 0.403764 1.267956 1.419167 1.472885 -0.112607 1.670565 1.413276 1.207639 -0.086673 1.620010 0.043714 0.638915 0.359545 0.675379 1.464392 1.899663 -0.356398 0.060074 1.455902 1.243469 0.880923 0.334093 0.547230 1.299365 1.565596 0.377568 1.452280 1.167613 1.196489 0.106466 0.294307 0.927989 0.194348 0.231233 1.092900 0.303840 0.700110 1.259197 0.861940 1.496196 0.790985 1.281275 -0.132162)
      )

;;; 105 prime --------------------------------------------------------------------------------
#(105 17.115185731735 #(0 0 0 1 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1)
      16.038356734428 #(0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

      13.733954 #(0.000000 -0.057207 0.202276 0.185274 0.126702 1.487775 0.560354 0.488858 0.081591 0.774343 0.419146 1.541621 0.626389 0.577437 1.705918 1.726068 1.196291 0.123183 1.327598 -0.045578 1.150621 -0.174194 1.592878 1.091598 1.240179 0.131065 1.475428 1.316258 1.197934 1.545057 1.801324 1.347733 0.056423 0.115307 0.847007 1.363723 1.354264 1.498486 0.645884 1.029424 0.523531 -0.033214 0.180910 0.329707 1.466191 1.722143 1.650013 0.316790 -0.161566 0.572711 1.144891 1.283886 -0.041891 0.869680 1.505028 -0.165390 1.363371 1.758632 0.561180 0.853593 1.967762 0.390348 0.298768 1.512178 1.124543 0.800175 -0.187913 0.095403 0.949442 0.124104 0.949703 1.501429 1.387851 -0.086070 1.226796 -0.059413 1.752856 0.787439 1.427513 0.416599 0.652411 0.790945 0.816452 0.432856 1.499300 1.805749 1.136543 1.428011 1.551056 1.666298 1.285181 0.042618 -0.046349 1.093249 1.456235 0.069290 0.885411 1.876144 0.497724 1.131476 0.118694 1.851809 0.657571 1.286536 1.789641)
      )

;;; 106 prime --------------------------------------------------------------------------------
#(106 16.130035426315 #(0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1)
      15.730461834714 #(0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

      14.044266 #(0.000000 1.168391 1.688412 0.804848 -0.304384 0.906747 0.058327 1.644042 0.624335 0.494527 0.615524 0.622222 1.409697 1.718821 0.350090 1.389658 1.209032 0.180248 0.931190 1.365269 0.343767 1.812733 1.237468 -0.512139 1.118740 1.498549 1.056374 0.761146 1.886816 1.170955 1.402087 1.845065 0.433271 -0.138902 0.762070 1.059789 1.337425 1.329490 0.401868 1.103406 1.162577 0.636318 1.490876 1.313403 1.297553 0.262629 0.635850 0.096304 1.031049 0.294039 1.009510 0.909412 -0.062032 1.017405 1.112563 1.191585 1.517058 0.331334 0.462812 0.001922 0.181448 1.035009 0.663188 1.733732 0.727981 0.679770 1.097288 0.999696 1.115074 0.544753 1.258146 1.004226 0.521647 0.271801 1.681253 0.778102 0.311500 1.911441 0.342980 0.381079 -0.044874 -0.067470 1.286002 0.427334 1.371015 1.419744 0.996442 1.589182 1.047697 0.858619 -0.306462 0.283883 1.146414 1.672801 1.730907 1.769098 0.878023 1.247921 0.092427 0.447693 -0.050116 0.332543 1.335542 0.821866 0.773028 1.070814)
      )

;;; 107 prime --------------------------------------------------------------------------------
#(107 16.541004232936 #(0 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1)
      16.328491210938 #(0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.264743804932 #(0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)
      16.2013 #(0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

      14.118279 #(0.000000 0.309578 0.433032 1.201941 0.702272 1.695979 1.040730 -0.021916 1.688469 0.128463 1.509670 1.460615 1.534028 0.801508 0.194107 0.873256 0.455218 0.689835 0.385046 -0.015583 1.277196 0.930713 0.664839 1.077093 1.870296 0.768058 0.314184 1.584528 0.341102 1.634370 0.402593 0.739632 0.027738 1.006818 1.307907 -0.050412 1.142453 0.876470 1.243777 1.120053 -0.001249 1.331518 1.456581 1.097026 1.225886 0.815335 1.403207 0.120641 1.510594 1.433979 1.525469 1.766478 0.770608 0.353099 1.569449 0.752264 0.301105 1.277781 0.614478 1.051196 0.783966 0.540327 0.280075 0.560022 1.372883 1.373512 0.534535 0.770166 0.124949 0.184874 0.641705 0.429014 1.865665 0.933858 0.212224 0.623596 0.843016 0.341843 0.985754 1.179071 0.844780 1.728357 0.033317 0.842639 0.364646 0.568863 1.660410 0.621760 1.534506 0.481556 1.691609 1.550537 1.223125 0.698850 0.362714 1.164226 1.004211 0.575552 0.226514 0.097768 0.697810 1.563454 1.172327 1.297605 0.621703 -0.068260 1.166413)
      )

;;; 108 prime --------------------------------------------------------------------------------
#(108 17.139458240072 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1)
      16.664336486859 #(0 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1)
      16.517358779907 #(0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

      14.222145 #(0.000000 0.599318 0.638584 1.288517 0.293646 1.540621 -0.178150 1.476100 1.098450 1.640201 -0.015230 0.111038 1.199095 0.664050 1.667587 0.303470 1.744176 1.682686 1.309820 0.745518 0.857420 1.060908 0.537889 0.981349 0.025491 1.766826 0.230263 0.176099 1.629897 1.807307 0.596113 0.968111 0.206805 0.433488 1.214545 0.791476 0.529768 1.272767 0.103127 0.379186 0.512906 1.130058 1.037583 -0.204777 0.670791 0.236406 0.442510 1.744854 0.583293 1.737013 0.648648 1.837082 1.658988 -0.110766 1.254309 0.018486 0.745459 1.607560 0.769936 1.465605 0.801145 0.489387 0.669714 0.599173 0.489382 0.345900 1.804959 1.312825 0.175844 0.276952 0.884274 0.761508 1.873498 0.835047 0.282611 1.452564 1.686154 0.143142 0.037846 0.673694 1.027602 1.066025 0.202472 0.000487 1.522137 0.112020 0.917102 0.279099 0.300973 0.703228 1.494839 0.481807 0.482812 1.503146 0.968238 0.538350 1.074987 1.670845 0.562804 1.840202 1.382023 1.801281 0.215956 0.003567 1.659404 -0.099932 -0.311447 1.693331)
      )

;;; 109 prime --------------------------------------------------------------------------------
#(109 17.4553 #(0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)
      17.086888321276 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.93954489715 #(0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 1 1 1 0)
      16.726722717285 #(0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

      14.419214 #(0.000000 1.300790 -0.006926 0.773327 0.708801 1.015725 0.035532 0.226004 0.945952 0.534916 0.402579 1.073290 1.498778 0.238919 1.619468 1.320496 1.535472 1.053367 1.812064 0.391906 0.180223 0.796572 0.139915 1.539512 0.578652 1.362616 -0.069406 1.593469 0.408819 0.979317 0.890705 1.681394 0.756783 0.210938 1.458372 0.943836 1.251372 0.867572 0.896799 1.216196 1.576241 1.567004 0.739566 0.625992 1.253050 0.032154 1.484322 0.353187 0.889775 -0.048650 1.593411 0.310678 1.308218 0.831486 0.840779 0.241462 0.716517 0.756137 0.891262 0.964786 0.804902 1.545584 0.888058 1.558892 0.454797 0.717132 1.507170 0.938320 1.473778 1.190394 -0.131379 0.932203 0.180487 0.236346 1.344305 0.601074 0.471478 1.421418 0.318443 1.634065 1.168984 1.473262 0.405938 0.455669 0.277548 0.089718 -0.105955 0.766990 1.673855 0.459974 0.539123 0.351769 0.772969 0.029607 1.566211 1.894868 0.434534 0.473609 1.869304 1.490013 0.507535 0.153474 1.266197 1.236000 1.126231 0.766448 0.762158 1.207849 0.416779)
      )

;;; 110 prime --------------------------------------------------------------------------------
#(110 17.014086078381 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 1)
      16.799713998439 #(0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1)
      16.455888332339 #(0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      14.426873 #(0.000000 1.039166 0.514619 1.450796 0.140005 1.064093 0.944980 0.913520 0.213750 0.095845 1.051913 -0.038085 1.842847 0.522460 1.705237 0.392511 0.249279 0.652200 0.691180 0.727147 0.221881 0.819418 1.615676 1.183390 1.720363 1.197507 -0.004953 1.333453 1.376768 0.132674 0.516867 1.048115 0.004219 1.067702 1.422479 0.459724 0.135972 1.513600 0.409821 1.783523 1.707333 0.086960 1.140839 0.367325 0.444879 1.408237 0.386379 1.926705 1.751398 0.327167 1.768948 0.640168 0.131968 0.092947 1.726434 -0.017572 1.921486 1.620687 0.713713 1.721261 0.978353 1.401084 0.686441 1.364529 -0.001337 0.407102 0.608210 1.206334 -0.152870 0.356790 -0.009919 -0.090009 0.618983 1.639555 -0.128631 1.754325 1.659546 0.826274 -0.152067 1.637028 1.908577 1.491225 0.848067 0.847922 0.199798 1.624607 1.714322 1.382941 1.553981 0.443838 0.744395 -0.070181 1.564362 0.835583 0.621513 1.817217 0.286471 1.282179 -0.003312 0.585323 1.207241 -0.055570 0.191386 0.560983 0.852781 0.471364 0.476339 0.453849 1.587045 0.346710)
      )

;;; 111 prime --------------------------------------------------------------------------------
#(111 16.941944255543 #(0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1)
      16.783880166046 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)
      16.6662 #(0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

      14.358766 #(0.000000 0.659407 0.547971 0.601549 -0.028974 1.373525 1.798721 1.198662 0.979211 0.662947 0.136636 0.342132 0.325957 1.176519 1.386220 1.347916 0.957115 -0.052670 1.458363 1.168401 1.018063 1.690943 1.300300 0.497557 1.164762 -0.000129 0.856057 0.508065 1.494447 1.393105 0.983196 0.937358 1.434769 0.876672 1.837136 0.562990 1.433507 0.706022 0.129804 1.923902 1.693111 0.839175 0.891579 1.624837 0.186684 0.832938 0.717215 1.558207 1.159672 -0.048943 1.011181 -0.046400 1.762824 1.165196 0.135140 0.655628 -0.132993 0.282647 1.730818 1.624686 0.107364 0.340237 0.557052 1.595467 1.278033 1.713650 1.840910 1.637383 1.589750 1.070182 0.876249 1.416170 1.058428 1.101365 1.542914 1.141893 0.037098 0.314337 0.552063 0.033999 -0.197783 1.674368 0.784119 0.933804 0.958217 0.033527 0.308507 1.150017 1.084754 1.432294 1.174488 -0.130959 0.308899 -0.209192 1.123864 -0.270016 1.557410 0.064706 0.086060 0.152416 1.469301 1.455282 0.684911 1.591490 0.825123 0.306192 1.519915 0.070585 -0.139883 0.415905 1.100580)
      )

;;; 112 prime --------------------------------------------------------------------------------
#(112 17.423562009124 #(0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)
      16.697049415765 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

      14.512239 #(0.000000 0.823904 -0.026523 1.191200 1.738972 0.777179 0.946076 1.347166 0.791446 1.746648 1.170600 0.743502 1.370829 0.626619 0.802756 1.911766 0.191174 0.743365 0.082081 0.609440 0.538666 1.301472 1.192544 1.517308 0.632716 1.434155 1.371011 -0.348053 0.705356 0.034351 1.432956 1.954948 0.002890 1.410013 1.192581 0.613872 1.618336 0.870312 0.270214 1.778357 0.277457 -0.070267 1.753390 0.765589 0.372362 0.266454 1.739881 0.812017 0.529720 0.110219 0.141460 0.351444 -0.031122 0.241114 1.021806 1.913743 0.594823 1.268346 0.094330 0.142220 0.762310 1.769818 0.865720 1.256483 1.201361 0.342471 1.874103 1.390767 0.737992 1.871024 0.285992 1.299653 1.099243 1.782183 0.406719 0.880075 1.744972 1.925984 0.299195 1.450742 0.260394 0.509957 0.596303 0.957482 0.640024 0.108720 1.711047 1.197895 0.633768 1.204059 1.926061 1.519598 0.046797 1.457380 1.114454 0.803559 -0.112607 1.230066 0.586343 0.005752 1.144948 0.815816 0.368985 0.911106 0.726444 0.904422 0.281286 0.533560 0.562610 1.062592 -0.032279 0.343720)
      )

;;; 113 prime --------------------------------------------------------------------------------
#(113 17.29593895793 #(0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0)
      16.7898 #(0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 0 1)
      16.203890830538 #(0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

      14.786014 #(0.000000 0.788373 -0.358172 1.128706 1.623176 1.037114 1.488254 0.899659 1.429510 1.518287 0.698778 -0.131251 0.628924 0.324429 1.157348 0.646091 1.144403 1.057406 0.233292 0.139601 0.996627 1.712925 1.329768 0.154083 0.543528 0.775271 1.674670 0.294816 0.842786 1.183472 0.462813 0.441326 -0.073156 0.931105 1.875955 1.707066 0.124343 1.399632 1.788492 0.149571 0.671145 1.230967 0.589257 1.384336 1.231158 1.501441 1.320324 0.007033 1.500650 0.482075 0.533416 1.011762 0.355345 1.285008 1.214893 0.007796 1.262646 -0.091463 1.528651 1.637271 -0.035028 -0.107942 0.074131 1.809202 1.065455 -0.035082 0.133037 0.765301 -0.022712 1.074905 0.438038 0.655216 1.706208 0.696533 0.278876 0.483443 1.798921 0.271167 0.446037 0.050000 1.106320 1.041730 1.589234 1.504740 0.264765 1.902703 0.855665 1.279842 0.558551 0.103286 -0.007444 0.513057 0.184740 1.129864 0.281098 1.037482 1.241272 0.344156 1.449324 1.817232 1.626209 1.278025 1.041896 0.690845 0.492841 1.850950 1.460211 1.831747 0.689224 1.278534 1.090858 0.968413 0.106950)
      )

;;; 114 prime --------------------------------------------------------------------------------
#(114 17.592388063856 #(0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1)
      16.769464540605 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)
      16.442732865586 #(0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

      14.948891 #(0.000000 0.978978 0.726730 1.128308 -0.147953 1.932326 1.165075 1.257746 1.485226 1.487200 1.904894 1.564821 0.905982 1.393084 0.335668 1.582710 0.079030 0.864439 1.776450 1.115845 1.271879 0.252132 1.799846 1.372890 1.402315 0.757744 0.243702 1.292339 -0.151615 0.648808 1.088920 1.386682 1.674450 -0.071733 1.553538 0.355673 0.432627 1.309699 1.755264 0.623021 0.902501 1.501949 0.220334 0.493978 0.443102 0.641838 1.707412 0.277483 1.804339 0.372677 0.923711 0.712884 0.336069 0.493459 1.847191 1.923149 1.818283 1.185702 1.534563 1.897698 1.843882 1.473773 0.047793 1.662878 1.344406 0.646665 -0.050595 1.500280 1.356185 0.810597 1.259955 1.388231 0.001823 0.189353 0.606286 1.122536 0.942480 0.506064 0.248304 0.437235 1.278690 -0.030877 0.019077 1.653080 1.191210 0.271344 1.257047 0.913483 0.870597 1.502525 1.413387 1.204756 1.454413 1.875837 0.214780 0.352315 0.240268 -0.235823 1.773094 0.935520 1.003721 0.550964 1.815067 1.131293 1.318912 0.993374 -0.001400 0.023449 1.685309 1.309732 1.104725 0.087360 0.351955 0.408322)
      )

;;; 115 prime --------------------------------------------------------------------------------
#(115 17.480941944057 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0)
      17.1559 #(0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 0)
      16.774665887963 #(0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

      15.003644 #(0.000000 1.521334 0.324519 1.180852 0.342269 0.799302 0.349376 1.490931 0.461994 0.698235 0.579424 1.296593 1.551890 0.452325 0.217462 0.161273 -0.263563 0.956767 0.750000 1.429229 0.470176 1.026787 0.676033 0.015889 0.669290 0.514550 1.203210 1.474618 0.116623 1.599761 0.832043 0.391929 1.811585 -0.186016 0.596675 1.440842 0.238095 1.569401 -0.423337 0.600943 1.439827 -0.143576 1.625588 0.165713 0.566686 0.533658 1.562619 1.024286 0.034242 1.690241 1.281311 0.484921 -0.036568 0.925811 1.107110 1.281428 0.216351 1.800838 -0.096038 1.733824 1.486645 1.311669 1.257184 1.903842 0.557251 0.576529 1.289752 1.230487 -0.150515 0.081905 0.138898 1.491903 1.176713 0.368194 0.324368 1.579634 1.402010 1.024846 1.811072 0.737444 0.054879 1.462170 0.847652 1.907709 0.716463 1.461904 0.745498 1.491129 1.371845 0.343171 1.726105 0.464200 0.947454 -0.011851 0.982635 0.639355 1.679065 1.269789 1.067392 0.202943 1.476740 0.202140 0.215580 1.430039 -0.209059 0.429796 1.367410 1.450978 1.482926 1.700384 1.312799 1.134148 0.137432 0.038835 0.318001)
      )

;;; 116 prime --------------------------------------------------------------------------------
#(116 17.885190963745 #(0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)
      16.812931137234 #(0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

      15.011954 #(0.000000 0.895324 1.080605 0.871194 1.797176 1.105444 0.141707 1.190261 0.403795 1.729571 0.049956 0.504870 0.545034 -0.101924 1.313643 1.122682 1.939962 0.576047 1.591576 0.535609 -0.274074 1.950945 0.037173 0.708883 1.705509 1.183891 1.092194 0.791868 0.976740 1.179337 0.678557 0.975956 0.069461 1.494859 1.877908 0.693246 0.403791 0.047075 0.283252 -0.260045 0.791025 1.034602 -0.095147 -0.262920 0.184872 1.038335 0.794040 0.782470 0.304109 1.038061 0.305982 0.340481 0.329622 1.880763 1.696321 0.521828 0.116953 1.196068 0.071045 0.174418 0.458747 0.232042 0.699656 0.962657 1.750888 0.309965 0.563911 0.966881 0.849440 0.518210 0.854257 1.721865 0.585776 -0.186606 0.882232 0.423530 1.875517 0.218284 1.325349 0.770654 0.212122 0.808292 1.579496 1.718136 0.917651 1.247202 1.489896 0.001213 1.364685 1.555169 0.087023 0.568778 1.223376 1.743216 1.543960 1.501413 0.566670 0.473943 1.556665 -0.074547 0.874418 0.289601 0.445176 0.445437 1.538487 1.514579 0.999137 1.845443 0.806883 1.711935 1.054836 1.338621 1.240568 1.080716 0.255118 0.746953)
      )

;;; 117 prime --------------------------------------------------------------------------------
#(117 18.290939331055 #(0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1)
      17.710553146299 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)
      17.5997 #(0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

      15.181137 #(0.000000 0.224326 0.902631 0.098790 1.246900 1.132017 0.263523 1.802895 0.410163 0.651502 -0.032932 0.275146 0.231115 1.705593 0.193145 1.394253 1.160095 1.556795 1.409713 1.698549 0.222818 1.224692 1.482602 1.008240 0.447499 0.668317 1.291378 0.125445 0.526746 0.411943 0.661584 0.684465 0.867579 1.542711 1.766719 1.856037 0.034681 0.769718 0.615133 0.270093 1.502362 0.658587 0.351858 1.045320 1.606480 0.503217 0.216940 0.927440 0.951638 0.551856 0.923275 1.233812 0.914086 0.052408 1.082047 1.165229 1.552389 1.657101 1.541823 0.625354 0.821943 0.556658 0.796364 0.453163 1.274677 1.905624 1.496862 0.312540 1.745685 0.090040 -1.808337 0.317480 1.953635 1.873567 0.799413 0.164165 0.439839 0.678006 1.128292 1.582973 1.243713 0.414201 -0.068000 1.713160 1.069002 1.215011 1.501450 1.332542 1.135367 0.379693 0.475116 -0.004746 1.266495 1.808843 0.473021 1.186028 0.294930 1.465918 0.162180 0.067922 0.341282 1.143951 1.647384 0.637389 1.506229 0.104698 0.601344 0.016105 0.317574 1.056534 1.595644 0.169081 1.484584 -0.018875 0.613216 1.870010 0.690378)
      )

;;; 118 prime --------------------------------------------------------------------------------
#(118 17.985612869263 #(0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0)
      17.181785583496 #(0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

      15.137914 #(0.000000 1.640867 0.780433 1.712049 -0.161474 0.670901 0.482006 1.274545 0.718991 0.776086 0.087845 0.784701 0.310767 1.284980 0.329700 0.902815 1.431718 0.280755 0.937443 1.383084 0.206523 0.249923 0.611057 1.751128 0.601768 0.540698 1.208920 0.885189 0.365543 0.076717 1.678156 0.205674 0.398901 1.038445 -0.239758 1.002600 -0.128405 1.497866 0.348459 1.742440 -0.032207 0.514131 0.594141 0.821487 -0.349981 0.127128 0.898444 1.468461 0.790779 0.963758 0.675344 1.328450 1.633111 0.779342 1.601078 1.436455 0.767272 0.104581 -0.024251 0.738506 0.767227 0.548637 0.638639 1.621830 0.703380 0.343527 0.738198 0.297744 0.016986 -0.062415 0.111411 1.380676 1.165187 1.654255 0.283420 1.215198 0.899737 1.027485 1.246882 0.985765 0.650806 1.656022 0.396593 1.725728 -0.311149 -0.065736 0.223937 1.765199 1.106971 1.715064 1.729307 1.291860 0.646123 0.220546 0.098962 0.882825 1.827312 1.379151 0.628209 1.099082 1.443062 0.296102 0.282024 0.448389 1.639202 0.802788 0.019072 1.267381 0.258817 0.201743 0.559132 0.132762 0.024619 -0.169620 0.491008 0.700473 0.984826 0.652372)
      )

;;; 119 prime --------------------------------------------------------------------------------
#(119 18.0781 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1)
      17.500297546387 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1)
      17.167841346875 #(0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      15.006433 #(0.000000 1.475939 1.123284 1.217534 0.457017 1.038768 0.337429 1.846941 0.008807 1.248583 1.522239 0.765931 1.002081 0.409814 0.253950 0.835367 1.015371 1.751106 0.710231 0.568312 1.319752 0.141815 1.196235 0.639907 0.871170 1.792801 0.730665 0.086541 0.153688 1.247847 1.485341 1.064472 0.186015 1.167339 1.197413 1.395887 0.951346 1.026541 0.092748 0.402047 0.746467 -0.119835 0.755914 0.966587 1.626902 0.355745 1.706765 1.706105 -0.178878 1.107956 0.887626 0.882426 1.114356 1.183371 1.594317 1.563553 1.403894 1.879219 1.301287 1.955893 1.139745 1.117362 1.196405 1.315510 1.707315 1.602587 0.536065 -0.132992 0.701073 0.364695 1.249668 0.735326 0.319717 0.649877 1.765869 0.879341 0.301771 1.268152 0.190542 0.115418 0.747571 0.410138 1.055035 1.737366 0.769813 1.098021 1.675956 1.868067 0.272785 0.575001 1.076302 1.488183 0.429886 -0.065214 1.371255 0.984994 1.160495 1.078925 -0.143781 -0.056876 0.389900 1.389681 0.922026 0.621552 0.601439 1.811232 0.755350 0.015226 1.412040 1.726424 0.560160 -0.017879 1.926528 0.068931 -0.026802 1.450687 0.873770 1.851103 0.659471)
      )

;;; 120 prime --------------------------------------------------------------------------------
#(120 17.635260884038 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.540792728815 #(0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0)
      17.067 #(0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

      15.084399 #(0.000000 1.349066 0.768199 1.282160 0.151448 0.057492 1.275033 0.868343 0.970863 1.165031 0.355439 1.047473 0.890245 0.004268 1.207689 0.906997 0.687406 1.716710 0.063995 0.164498 1.218806 0.370186 0.229937 0.684438 1.049243 -0.069305 1.225417 1.870263 1.727722 0.855450 0.901835 1.105697 1.095301 0.884888 0.368718 0.133367 0.065377 1.691901 0.288391 1.479203 0.805942 0.969171 0.544722 0.802658 0.975270 -0.116149 0.337768 0.140628 0.517871 1.283843 1.640142 0.916929 0.472678 0.841827 1.346003 1.443199 1.799617 0.548457 0.511672 1.414072 0.024533 1.448374 0.136517 1.461599 0.582979 0.547236 0.244988 0.299588 1.233362 1.599276 1.389252 0.319888 0.484755 0.446634 1.717476 1.218275 1.383662 1.404694 1.752398 0.954416 -0.160690 0.558077 1.913004 1.511770 0.243355 0.515690 0.169042 0.632460 1.004272 1.508841 1.170444 1.093613 0.018730 1.165413 0.222669 0.317562 0.762711 0.058141 0.050477 -0.086056 0.651531 1.417697 0.366672 1.342366 0.536916 1.080350 0.574676 1.636129 0.980795 0.982020 0.669241 1.081458 0.552138 0.096992 0.809534 0.701964 0.940725 0.630392 1.556548 -0.027099)
      )

;;; 121 prime --------------------------------------------------------------------------------
#(121 18.236074758398 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0)
      17.782977183017 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      15.321142 #(0.000000 -0.117048 1.681886 -0.034157 0.225788 1.515039 1.746260 -0.361587 0.271444 0.364637 1.216716 1.740918 1.255047 0.161901 0.377525 0.067654 0.444454 0.089529 1.116581 -0.164087 0.549881 1.296717 1.130027 0.737692 0.420493 0.306057 1.703841 -0.241283 0.014144 -0.042929 1.083474 1.331645 0.456784 1.153886 1.139634 0.719368 1.311440 0.673175 0.572299 0.493146 0.535932 1.267344 0.428965 0.843055 0.236023 0.100384 1.628865 1.069575 -0.114976 1.655901 0.230393 1.406226 1.167086 1.340029 0.023328 0.567314 1.545825 -0.091466 1.100500 0.665367 1.393909 0.955962 0.747700 1.613044 1.414513 1.616236 0.486696 0.472358 -0.362768 0.661889 1.099914 1.260910 -0.062308 0.950824 0.967612 -0.070390 1.832823 1.539255 0.625869 -0.025886 1.441267 0.421970 -0.042297 1.418393 0.743352 1.713872 0.175422 0.393203 1.628652 1.428473 0.482139 1.261226 0.223537 0.335134 -0.033516 1.237988 0.035917 1.133045 1.691934 0.649236 0.849955 0.948864 0.799503 0.773480 1.344895 1.167544 -0.106063 0.368291 0.541651 0.639455 1.666884 1.052653 0.331419 0.987203 1.661517 -0.033688 1.087222 0.390595 0.051978 1.036687 0.290769)
      )

;;; 122 prime --------------------------------------------------------------------------------
#(122 18.225525517344 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)
      17.876078447724 #(0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

      15.251945 #(0.000000 0.688640 1.859461 1.521603 1.751725 0.890215 0.607749 1.822219 1.759114 1.753233 1.002949 0.424696 -0.242252 1.240468 1.841921 0.141445 0.029510 1.651913 0.939693 0.925739 1.181659 1.209588 0.383831 0.594499 1.431393 0.421305 -0.116674 0.309796 0.492167 1.817431 1.265813 0.166139 1.896007 1.705249 0.288531 0.559129 -0.320142 1.305505 1.737860 1.044038 1.006098 1.054456 1.813879 1.611474 -0.094076 0.853754 0.317075 0.744886 1.601425 1.482001 0.813213 0.049856 0.964439 1.240553 0.093776 0.228662 -0.016452 0.919376 0.110556 0.386383 -0.041016 0.734648 0.585427 1.723694 1.208069 1.392730 0.806464 1.111013 0.332968 1.764866 1.112561 0.100228 1.309941 1.508438 0.273999 0.017261 1.680330 1.626417 1.469436 0.418360 1.364687 0.766702 0.799923 1.314216 1.632121 0.435944 1.004142 0.236168 1.051523 0.106850 1.298839 1.511274 0.609419 -0.126038 1.435764 -0.093554 0.065428 0.789329 0.264103 0.323049 1.624746 -0.145949 0.735821 0.317636 0.975902 -0.066972 0.328774 0.094732 1.533190 1.437178 1.857223 1.371419 0.337989 1.841120 1.001122 0.884530 1.438326 0.044550 1.523065 0.000571 1.159134 1.898655)
      )

;;; 123 prime --------------------------------------------------------------------------------
#(123 18.144585330068 #(0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1)
      17.389867782593 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)
      17.273 #(0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      15.220702 #(0.000000 0.076094 0.614190 1.001322 0.947202 0.431033 0.148046 0.299184 1.811943 0.347146 1.879843 0.387433 -0.025914 1.489931 0.836928 1.645797 1.536374 0.958547 0.479540 0.659108 -0.232723 1.843698 1.592907 0.169237 -0.092707 0.970875 1.319865 1.606724 0.267371 1.550300 1.775031 0.525360 0.688239 0.983173 1.473141 1.781249 0.276902 0.663709 0.902158 0.780325 -0.138588 0.750443 1.188222 0.310526 0.132130 0.041814 1.183662 0.955834 1.458813 1.162684 1.689943 1.801563 1.439708 1.245899 0.268778 0.340879 1.023210 1.053583 0.729792 1.114146 1.510925 0.742922 0.525444 0.185928 1.404096 0.462257 0.747687 1.536339 1.105558 0.520130 0.720767 0.248423 -0.130095 1.004970 -0.021858 1.079084 0.565894 1.445069 0.204753 0.421702 0.525875 0.449502 -0.166936 0.900054 1.353947 1.713061 1.406081 0.471150 -0.370299 0.937904 0.323081 -0.138824 0.619482 -0.060088 0.635970 0.908129 0.528311 0.971996 0.700009 -0.047913 0.059198 0.855309 0.415952 0.633834 1.064882 0.445029 1.350947 0.880060 0.821460 0.366689 1.088147 1.574185 0.510625 0.976690 1.549354 1.536031 1.798626 0.761267 -0.040229 1.704702 1.463949 0.078192 0.531566)
      )

;;; 124 prime --------------------------------------------------------------------------------
#(124 18.115 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
      17.868420183527 #(0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

      15.540921 #(0.000000 1.217773 1.124594 1.153631 1.262846 1.993591 1.184626 1.358434 0.506087 0.216991 0.529496 1.200283 0.285355 0.801126 1.298075 1.542069 0.646501 0.038164 1.645607 0.795462 1.378977 0.941180 0.445058 0.047249 1.753933 0.778261 -0.067500 0.592220 -0.101055 1.187480 1.637649 0.647380 1.153670 0.670503 0.766928 1.387808 0.057550 1.277009 0.031053 0.264915 0.814008 0.989294 0.944746 1.469497 0.842415 1.131808 0.672533 0.642800 1.142184 0.188330 1.170782 0.879007 1.621705 1.246337 0.174457 0.157587 1.156982 0.675892 1.403630 -0.006232 1.358645 1.312198 0.998303 1.074335 0.009008 1.684835 0.584239 0.379817 1.568883 0.492375 0.521023 1.307598 1.545926 0.162352 0.610210 0.734211 0.936702 0.557030 0.483607 0.178244 0.743423 1.420115 0.451861 1.474427 1.638420 1.166919 0.604636 1.296789 0.264186 1.719628 1.753371 1.346833 1.754733 1.858438 0.958943 1.740664 0.098106 1.941090 1.008534 1.062671 0.704715 1.366384 1.255431 0.184956 1.315287 0.027644 1.576164 0.830199 0.899068 0.333823 0.973688 1.547930 1.728147 1.868548 1.949766 -0.107378 0.109816 0.702031 1.959791 1.102839 1.182144 1.688203 1.098812 1.284315)
      )

;;; 125 prime --------------------------------------------------------------------------------
#(125 18.072 #(0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1)
      17.637776156888 #(0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      15.362448 #(0.000000 1.654918 0.720556 0.684643 1.709943 0.652844 0.631424 1.917287 -0.233197 -0.112682 0.988906 0.271155 0.511579 0.658025 0.112073 1.046208 0.660085 0.486493 1.025100 1.192677 0.530423 1.353432 1.197801 1.063185 1.235353 1.180145 0.165405 0.042759 -0.417545 1.119972 0.133205 0.479940 1.037093 -0.225334 0.705207 0.100943 0.209029 1.868183 0.062819 0.351250 0.853666 0.709486 0.176903 -0.114001 1.578748 1.248181 0.747113 0.764470 0.840062 1.803154 0.936251 0.907981 1.269213 0.370148 1.462391 0.405455 1.206449 0.074874 1.939105 1.123635 0.652890 0.679214 0.069371 0.623402 0.295628 0.301653 0.503425 -0.066810 1.152252 1.416505 0.242059 0.091715 1.327333 1.290367 1.310794 1.271543 0.574527 0.649270 0.039244 0.034992 1.451171 -0.029592 1.619078 0.626239 0.963385 1.668878 0.741597 1.867663 0.682986 0.827351 0.704187 -0.040316 1.143270 1.494232 -0.028913 0.540397 0.601378 0.760909 0.172475 0.705596 0.388340 1.046330 0.369936 0.055605 1.208938 0.958396 0.278936 -0.121301 0.200190 1.791690 0.677243 1.418077 1.353727 -0.014837 0.196793 0.935015 0.703204 1.733907 1.184366 0.209569 -0.226600 1.285465 1.457423 0.390204 1.939354)
      )

;;; 126 prime --------------------------------------------------------------------------------
#(126 19.269804000854 #(0 0 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1)
      18.284595039843 #(0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      15.562902 #(0.000000 1.452951 0.562465 0.794665 1.694170 0.193763 0.924874 1.311239 1.539899 1.322103 -0.135353 1.250313 0.060445 1.306277 -0.079719 1.417374 0.729008 0.008732 0.456884 0.387456 0.836960 1.334906 0.200048 -0.386814 -0.079738 1.612578 1.750339 1.857476 0.551361 1.296512 -0.027290 1.559904 1.019028 1.425303 1.589059 0.198061 0.874416 0.674661 1.210120 1.770154 0.783155 1.433354 1.465431 1.635362 0.652646 1.167792 1.306958 0.625902 1.167803 1.690507 0.288367 1.010229 0.652818 0.142488 1.471464 0.198130 0.348923 0.608272 0.493248 0.859356 1.203010 0.234862 0.691428 0.860691 0.890453 0.184244 0.152823 1.183134 1.290893 0.675100 0.444450 1.603422 0.846537 0.500300 1.193480 0.890163 1.532053 0.836537 -0.166349 0.160545 0.681157 1.575188 1.318708 1.405662 0.316608 0.277469 1.431339 1.112299 0.905450 1.489587 1.052206 -0.336952 0.606503 1.638235 1.178275 1.597753 0.491919 0.485414 0.084265 0.512602 0.464877 1.279072 0.982788 1.055584 0.208709 0.025151 1.470946 0.082988 1.009360 -0.052361 1.433644 1.032805 1.766485 0.882102 0.873660 1.898155 1.077755 -0.081368 -0.018353 1.377518 0.544384 0.224842 1.400411 0.567529 0.816930 0.428663)
      )

;;; 127 prime --------------------------------------------------------------------------------
#(127 19.129140790802 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)
      18.198689419357 #(0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

      15.423949 #(0.000000 -0.068229 0.267688 0.575691 0.591258 1.632677 1.777805 1.169958 1.800941 0.107565 0.683242 1.259603 -0.242478 0.425680 0.876706 0.630510 1.865862 0.998362 0.105690 0.807726 1.059385 0.326149 1.101475 0.799923 1.002494 0.413507 0.742211 1.154543 0.714087 1.406898 0.078656 1.268647 0.812276 1.772963 0.408524 0.931640 1.674739 0.805382 1.364353 -0.215538 1.194779 1.798259 0.668526 0.267624 1.757023 0.795779 1.752988 0.407965 0.318453 1.335940 1.262505 1.369480 1.171166 0.782644 1.277960 1.848536 0.788292 0.858543 0.355767 0.991551 0.550350 -0.029673 1.021708 0.992889 0.247588 1.787875 0.216754 0.080255 -0.436436 1.884775 0.639373 1.733017 -0.089457 0.951211 0.762325 1.151384 1.564490 1.546516 0.576219 0.650196 0.972414 0.160430 1.194341 0.264746 1.112508 1.269578 1.198527 0.717220 0.301604 1.627012 0.908117 0.090997 1.251716 1.282557 1.387603 0.963555 0.314566 0.698657 1.243513 0.899135 0.170171 0.112056 0.849981 0.167081 1.467325 0.653224 0.241637 1.719437 1.908013 0.877879 0.941773 0.587039 1.567096 1.213344 0.942158 1.737165 0.840726 0.245156 0.412159 0.203869 0.101863 0.423622 0.965750 0.885603 0.781999 1.336122 0.823527)
      )

;;; 128 prime --------------------------------------------------------------------------------
#(128 18.871676504971 #(0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1)
      18.306106723228 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)
      18.276384353638 #(0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      15.686779 #(0.000000 0.979651 1.537016 1.181726 1.862616 0.174626 1.819718 0.733293 -0.095941 0.216225 1.363778 0.865687 1.435754 -0.075491 0.899025 1.109137 0.947837 1.495148 0.926234 0.701109 1.735827 0.370019 0.878408 1.821532 0.885518 0.909199 1.488364 1.581318 1.336424 1.673582 1.850812 -0.257866 -0.016581 0.020435 0.093834 0.331827 0.174171 1.391198 0.544307 -0.016343 0.657815 1.833354 0.425262 1.761253 0.309422 1.931132 1.532811 0.633160 0.202740 -0.131869 0.348352 1.764851 0.643102 1.210746 -0.178354 1.034409 0.335541 1.550093 1.915689 0.635516 1.332592 1.325235 0.989694 1.308152 1.599277 0.251584 0.416791 1.069196 0.547375 0.148300 0.666663 1.686635 1.786636 1.153302 1.952982 1.374036 1.081645 1.042714 1.633467 -0.229743 0.917544 1.284479 1.900045 1.717268 1.283712 1.441808 0.618335 0.849974 -0.019614 -0.074100 0.861441 0.684155 0.626783 1.989703 1.817180 1.284678 0.683762 0.410896 -0.067566 1.147659 0.994150 0.590098 0.447205 1.697644 1.765019 0.891012 1.840350 1.385415 0.409455 1.214262 0.770241 0.687793 0.528441 0.897142 0.794231 1.512882 1.201444 0.356692 1.650858 0.804883 0.729351 0.568769 1.642450 1.152032 0.092117 0.519293 1.182557 0.774254)
      )

;;; 256 prime --------------------------------------------------------------------------------
#(256 27.740 #(0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      25.419292 #(0.000000 1.139929 1.102745 1.741314 0.362270 1.867278 -0.105796 0.818148 1.710527 1.852271 1.124318 1.670890 1.153503 0.195801 1.002124 0.467505 1.049937 0.142894 0.085485 1.658937 0.491728 1.241311 1.322988 0.765513 1.862684 0.158048 0.184902 0.364251 0.607460 0.160072 1.059841 1.058104 1.188210 1.281788 0.605768 0.044404 0.063311 0.674089 0.592930 0.211703 0.030582 0.160150 1.609868 1.314862 1.540462 0.499958 0.255349 1.385713 1.225596 1.323240 1.907235 1.512131 0.755403 0.859403 1.645985 1.326003 0.062908 0.441796 0.954669 0.168027 0.516707 0.922222 0.189230 0.272544 0.472239 0.553957 1.434892 0.429635 1.400931 0.255779 0.446915 -0.097364 0.010974 0.185385 1.838088 0.722158 0.636251 0.319610 0.900579 0.585282 1.916411 0.284763 1.647549 0.469510 0.056494 1.051937 0.839561 0.491974 1.028802 1.773079 0.399350 1.305864 1.439648 1.938862 1.794159 0.371223 1.096547 0.742554 0.816016 1.210775 0.917874 0.861164 0.505923 1.824144 1.685486 0.860715 1.263824 1.850040 0.906459 1.245640 1.446237 0.478492 0.330388 0.240550 0.475287 0.333923 0.461789 0.887379 0.765592 1.453119 0.159768 1.029570 1.310462 0.743877 0.659014 0.156047 1.339711 1.733763 1.914764 1.783195 0.311674 0.523974 1.009176 1.284070 0.814963 1.982550 1.654619 1.786557 0.152975 0.552534 1.941831 1.909265 0.024048 1.982739 0.172030 0.361974 1.716273 -0.145229 0.059166 0.923627 1.369358 0.259568 0.603591 1.244786 1.772948 1.455451 0.278943 1.396699 0.483204 0.706810 0.610680 1.017552 0.504030 1.246537 0.695997 1.710753 0.064401 0.966739 0.486122 1.103392 1.069961 1.199883 0.173924 1.605015 1.493330 1.468259 0.224231 1.356642 0.799457 0.943289 1.443695 0.483173 1.340693 0.391180 1.005750 1.024557 0.693691 0.750249 0.307649 0.380108 1.914054 0.115308 0.520112 0.000006 0.467400 1.333649 0.446022 0.351018 1.570672 1.024307 0.066464 0.462119 0.177876 0.365882 0.903910 0.056543 1.482436 0.056456 1.134537 0.787030 0.268455 0.834182 -0.004538 1.625912 1.079081 1.485660 0.837184 0.498066 1.823166 1.225371 1.040093 0.129168 0.924645 0.160099 1.780342 0.192620 1.690804 0.751720 1.760030 1.260828 0.448859 1.138104 0.090032 0.250034 -0.145296 1.040075 1.391702 0.079881 0.515861 0.385145 1.779559 0.214107 0.743183 1.112600 0.419711 1.838072 1.427776 0.925752 1.817873 0.317608 0.532205 1.862275 0.506156 1.710729 1.157460 0.942925)
      )

;;; 512 prime --------------------------------------------------------------------------------
#(512 43.486 #(0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      40.250883 #(0.000000 1.067513 1.698501 0.882175 0.731347 0.396065 0.813755 0.963760 0.557013 0.330055 0.624000 1.141499 1.802667 1.147883 0.326439 1.700018 0.473901 -1.947004 0.102662 0.379112 0.161997 0.698965 0.728968 1.831300 1.279360 0.816655 0.480698 0.093700 1.500681 0.898464 0.536091 0.756778 0.355391 1.392086 1.233289 1.645259 1.641894 1.615256 0.190786 0.267903 -0.286330 -0.089039 0.457097 0.658540 1.669825 0.917012 -0.042627 1.298688 0.946526 1.789310 0.083576 1.102187 0.738679 1.390586 0.999921 1.312093 1.826088 0.412733 1.685728 0.303259 1.268988 0.900854 0.694405 1.727172 1.988661 1.867458 0.705458 0.724026 0.979505 0.018063 1.080148 0.984039 0.301365 0.996085 0.485066 1.698333 0.099220 0.144439 1.014550 -0.046011 0.199879 0.463422 1.340837 0.783213 1.151598 0.929237 1.727193 1.863491 1.325152 0.546479 0.970852 1.131669 1.594581 0.745485 0.269563 0.379861 0.913425 1.716346 0.963726 0.148826 -0.018344 0.857745 0.892045 1.081944 0.100251 1.000912 0.257282 0.111202 -0.008496 0.039287 1.417113 0.640192 0.675981 0.443529 0.868295 0.738861 0.820750 0.210774 0.082349 0.151630 0.783391 -0.180922 -0.106637 1.765370 0.742155 1.145606 1.368009 0.515346 0.436263 0.531741 0.802011 1.255309 1.894160 0.809353 1.813552 0.281020 0.025004 0.747411 0.889253 1.421629 1.808561 1.930509 0.839043 0.610805 0.811512 0.326999 1.060202 0.726316 0.486908 1.524130 1.740371 0.854892 1.794712 0.054857 0.374885 0.689897 0.804719 0.518621 0.778791 0.586676 1.098197 0.585149 1.186102 0.137320 -0.004366 0.332212 1.070131 1.845537 1.823307 0.557314 0.209620 0.792755 1.166951 0.717837 0.512510 0.629260 0.191128 1.302358 -0.197581 1.489802 0.982325 1.740676 -0.076574 1.688248 0.129965 0.784432 1.177913 1.102657 0.962095 0.929165 0.113690 1.498481 0.501354 0.386777 1.808656 0.189192 1.582104 0.598519 1.088596 1.677954 0.635479 0.886732 1.765869 1.721541 1.323683 -0.029727 1.928583 1.600246 0.279454 1.267423 0.990704 0.156419 0.680659 1.338166 1.787057 1.240138 0.302495 0.331931 0.199416 0.603149 0.714679 0.722359 1.555137 0.579030 0.968070 0.619479 1.564829 -0.173450 0.479277 1.582690 1.625073 -0.082864 1.364367 0.506113 1.020073 0.013031 0.901348 0.115571 1.654832 1.160506 1.382047 1.813620 1.803032 1.458055 0.157051 0.295770 -0.207462 1.435226 1.701103 0.634436 0.784529 0.075139 0.479500 1.222882 1.537827 0.905886 1.390016 0.322620 1.008572 0.815478 1.829604 0.684699 0.623092 1.869009 1.370361 1.545318 0.088302 -0.093316 0.065215 1.068848 0.441787 1.694437 0.956069 0.531992 0.195136 0.288213 1.080005 0.403178 0.327435 0.601585 0.419989 0.803862 0.624187 0.121109 -0.032458 1.233677 1.888075 0.416680 0.921255 -0.123147 1.100991 0.523132 1.866156 1.580633 1.521367 0.834357 0.017950 1.945026 1.112936 0.074866 0.578255 1.851390 0.917212 0.470515 1.494667 1.926605 0.420451 1.685173 1.321757 0.252699 0.908983 0.451996 1.280635 1.347889 1.101279 0.819891 0.717237 1.824992 0.064816 1.741467 0.171609 0.367474 1.450054 1.791245 0.070692 1.882472 0.030173 1.297571 1.480154 1.019678 0.718667 0.009196 0.641561 1.714326 1.179383 0.407542 1.176762 0.501786 1.884444 1.476017 1.294272 0.449015 0.628767 1.217169 0.537140 1.715118 1.505923 0.199813 1.524782 1.165141 1.676667 1.223004 0.016727 0.463878 1.136164 -0.053033 -0.084847 1.208615 1.445901 1.497341 0.161310 1.250596 0.942847 0.829403 0.387769 0.719178 1.738210 0.958532 0.472944 0.434584 0.253559 0.806841 0.948416 1.626398 1.745251 1.181118 0.900461 0.328407 0.004865 0.656956 1.561263 0.493976 0.215685 1.621837 0.977926 0.157229 0.368698 0.411012 0.533672 1.014733 0.265047 1.919729 1.249631 0.505841 0.810354 0.808424 1.184479 0.057215 0.275118 1.014035 1.475267 0.761434 1.193820 1.598491 0.134348 1.906886 0.063865 0.360892 1.182738 1.769838 0.652317 0.819564 0.835923 0.873375 0.958236 1.235262 -0.217562 0.548985 0.580422 0.773421 0.815778 0.094611 0.051274 0.456619 1.003721 0.560851 1.398235 1.328115 1.445608 1.526814 0.276018 1.944863 1.629687 0.184749 1.510383 0.270380 1.027430 1.256674 0.015870 0.564502 0.718165 1.794438 1.735884 0.904383 1.655901 1.675424 0.066250 1.899808 0.176362 1.550287 1.717784 0.905738 1.345949 1.001299 1.577679 0.550037 1.204039 1.754941 0.899017 0.959777 1.948798 0.199359 1.227196 1.454662 0.390714 1.580219 0.079875 1.186840 0.105451 0.922283 1.889599 1.204774 0.367870 0.720431 1.167140 1.635057 1.070144 -0.105934 0.316941 1.460835 1.680478 0.253545 1.791164 1.507054 0.456342 0.357901 1.697439 0.953658 0.592291 1.033133 1.478020 1.576280 1.358444 0.415789 -0.015554 1.241819 0.088719 1.636832 1.709484 0.595426 1.748375 1.690569 1.694795 1.541541 0.654394 0.467730 0.368448 1.418385 1.025035 0.300805 -0.128955 1.867573)
      )

;;; 1024 prime --------------------------------------------------------------------------------
#(1024 70.140 #(0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)
       )

;;; 2048 prime --------------------------------------------------------------------------------
#(2048 102.619 #(0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

#(1 1.0 #(0)
    )

#(2 1.7601724863052 #(0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
#(3 2.2325525283813 #(0 0 0)
    2.0235652605711 #(0 33/64 63/128)

    2.0214650630951 #(0.0 0.52414411306381 0.48787820339203)
    2.021465 #(0.000000 0.475854 0.512123)
    2.021465 #(0.000000 0.524145 0.487877)
    2.021465 #(0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
#(4 2.8359191417694 #(0 0 0 0)
    2.450505601523 #(0 3/16 21/32 15/32)

    ;2.434727537119 #(0 37 52 46) / 31

    2.4311048984528 #(0.000 0.191 0.672 0.479)
    2.4311048984528 #(0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 #(0 0 0 0))
    2.4308773660653 #(0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 #(0 3/16 21/32 15/32))
    2.430877366065 #(0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 #(0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
#(5 2.816308259964 #(0 1 0 0 0)

    2.6048328876495 #(0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 #(0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
#(6 2.9795869831363 #(0 0 1 0 0 0)
    2.9795892238617 #(0 1 0 1 1 1)

    2.8369779013614 #(0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 #(0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 #(0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 #(0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 #(0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 #(0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    )

;;; 7 even --------------------------------------------------------------------------------
#(7 3.4936672673663 #(0 0 0 0 1 0 0)
    3.3825581073761 #(0 0 0 0 0 1 0)

    3.0470769405365 #(0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 #(0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    )

;;; 8 even --------------------------------------------------------------------------------
#(8 3.7968969947382 #(0 0 1 1 0 0 0 0)
    3.7706393073421 #(0 1 0 1 1 0 0 0)
    3.611234664917 #(0 0 0 0 0 1 0 0)

    3.197691 #(0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 #(0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 #(0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 #(0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    )

;;; 9 even --------------------------------------------------------------------------------
#(9 4.1871630323114 #(0 1 1 0 0 0 0 1 0)
    4.1397546805979 #(0 0 1 0 0 0 1 1 1)
    4.0601739883423 #(0 0 0 0 0 0 1 1 0)

    3.454235 #(0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 #(0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 #(0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 #(0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    )

;;; 10 even --------------------------------------------------------------------------------
#(10 4.1456241150012 #(0 0 0 1 1 0 0 0 0 0)
     4.0054845809937 #(0 1 1 0 0 0 0 0 1 0)

     3.559069 #(0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 #(0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 #(0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     )

;;; 11 even --------------------------------------------------------------------------------
#(11 4.2814919726737 #(0 1 1 1 0 1 1 0 1 1 1)
     4.8058149616573 #(0 0 0 1 0 1 0 0 0 0 0)
     4.2754249521261 #(0 1 0 1 0 0 1 1 1 1 1)
     4.2368197441101 #(0 0 1 1 0 1 1 1 0 0 0)

     3.656997 #(0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 #(0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 #(0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 #(0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     )

;;; 12 even --------------------------------------------------------------------------------
#(12 4.5077774785482 #(0 1 0 1 1 0 1 1 1 0 0 0)
     4.4722682088655 #(0 1 0 0 1 0 0 0 0 1 1 1)
     4.4100483425078 #(0 0 0 1 1 0 1 0 0 0 0 0)

     3.788546 #(0.000000 1.556167 0.360103 0.557527 1.272879 -0.160667 1.208794 0.416499 0.207991 0.153798 0.406432 0.105283)
     3.788220 #(0.000000 0.550342 1.343009 1.534780 0.244087 0.805462 0.167902 1.368575 1.154099 1.090872 1.336846 1.030125)
     3.787893 #(0.000000 0.448349 1.651266 1.457646 0.745846 0.182779 0.817835 1.614340 -0.173074 -0.112402 -0.361602 -0.056645)
     3.787770 #(0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 #(0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 #(0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     )

;;; 13 even --------------------------------------------------------------------------------
#(13 4.7678911684727 #(0 1 1 0 0 1 0 1 0 0 0 0 0)
     4.4552875568415 #(0 1 0 0 1 1 0 1 0 1 1 1 1)
     4.4076361656189 #(0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973640 #(0.000000 0.230119 1.573121 1.035418 0.607827 0.004639 0.570316 1.864444 0.017841 1.712936 0.049649 0.243649 0.758519)
     3.973518 #(0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 #(0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 #(0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 #(0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     )

;;; 14 even --------------------------------------------------------------------------------
#(14 4.6162051765776 #(0 0 1 0 1 0 0 1 1 0 0 0 0 0)
     4.5770673751831 #(0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.099610 #(0.000000 -0.080758 -0.027479 0.199399 0.386347 0.449299 0.202554 1.784429 1.717900 0.329527 0.954548 -0.264053 0.856281 0.353663)
     4.099044 #(0.000000 0.064712 0.002392 1.758239 1.562496 1.488613 1.718784 0.123849 0.177636 1.552432 0.915397 0.118052 0.982785 1.477200)
     4.098933 #(0.000000 1.064573 1.002412 0.758783 0.562663 0.489006 0.720164 1.124184 1.179525 0.554249 1.917231 1.120737 -0.014393 0.478996)
     4.098145 #(0.000000 1.929164 -0.010969 0.226671 0.421687 0.490908 0.253400 1.847703 1.785923 0.405487 1.039797 -0.170604 0.960326 0.465294)
     4.097747 #(0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     )

;;; 15 even --------------------------------------------------------------------------------
#(15 4.949674522378 #(0 1 1 1 0 0 0 0 1 0 0 0 1 0 0)
     4.8773546682689 #(0 1 1 0 0 0 1 1 0 1 0 0 0 0 0)
     4.7838921546936 #(0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.199573 #(0.000000 0.504296 0.613533 0.293607 0.288557 1.021780 0.287132 0.744077 -0.060941 1.352372 0.993154 1.256681 1.521460 0.388861 0.364865)
     4.197351 #(0.000000 0.630844 0.628794 1.068650 1.167425 0.572395 1.431155 1.077518 0.027658 0.719923 1.211198 1.055057 0.880835 0.189555 0.316525)
     4.193772 #(0.000000 1.675587 1.705815 0.187561 0.316258 1.764366 0.667280 0.345731 1.343497 0.068095 0.602689 0.479768 0.335628 1.703907 1.864339)
     4.193545 #(0.000000 1.673990 1.704095 0.184742 0.312157 1.759699 0.661838 0.338558 1.336129 0.060082 0.592895 0.470075 0.323799 1.690560 1.851587)
     4.193539 #(0.000000 1.674972 1.705674 0.187574 0.315997 1.764079 0.667192 0.344813 1.343115 0.068186 0.601740 0.479341 0.334140 1.702389 1.863580)
     )

;;; 16 even --------------------------------------------------------------------------------
#(16 5.1845584915919 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0)
     5.1708735549117 #(0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1)
     5.1363370276686 #(0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1)
     5.0737318992615 #(0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.396519 #(0.000000 1.090547 1.139126 -0.009529 0.458824 0.778347 -0.106183 1.308832 1.218737 0.200208 0.290540 0.016830 0.423513 0.112582 0.603363 0.004222)
     4.353701 #(0.000000 0.561831 0.989050 1.195832 1.557580 0.017410 0.685599 1.728228 0.371692 0.005402 0.173541 0.126093 1.783105 1.542090 0.769507 0.225043)
     4.328579 #(0.000000 -0.050344 1.847492 1.547825 1.358460 0.943178 0.995171 1.405548 1.304846 1.241639 0.001478 0.213619 1.127944 0.266623 1.638359 0.274327)
     4.326872 #(0.000000 0.955614 0.859979 0.567169 0.385493 -0.026738 0.033152 0.450270 0.355426 0.300069 1.068503 1.286708 0.206676 1.350539 0.730076 1.370356)
     4.326467 #(0.000000 0.954646 0.857741 0.564427 0.380619 -0.030405 0.027220 0.443651 0.347240 0.290827 1.057423 1.274647 0.193509 1.337335 0.715554 1.355809)
     4.326323 #(0.000000 0.953094 0.856111 0.562335 0.378555 -0.035716 0.021343 0.437774 0.341052 0.283988 1.049334 1.266917 0.184364 1.326298 0.704383 1.343207)
     )

;;; 17 even --------------------------------------------------------------------------------
#(17 5.2972948285536 #(0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1)
     5.2612584721964 #(0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 1)
     5.2483402924188 #(0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1)
     5.2332563400269 #(0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.494270 #(0.000000 1.690932 1.377703 -0.129164 -0.024726 0.145784 0.623192 0.601419 1.696617 1.062285 0.338962 0.425431 0.203410 -0.198553 0.017368 0.919786 1.663170)
     4.479510 #(0.000000 1.466836 1.017287 1.287212 1.239798 1.196077 1.475713 1.252884 0.088143 1.339107 0.374990 0.334947 -0.053319 1.236824 1.357721 0.013234 0.581999)
     4.464269 #(0.000000 1.476895 1.019325 1.288655 1.217216 1.181033 1.470508 1.274331 0.076928 1.335513 0.388067 0.349071 -0.061964 1.248056 1.367096 0.016797 0.585932)
     4.464096 #(0.000000 1.478399 1.021179 1.293532 1.222041 1.188322 1.479616 1.284032 0.091138 1.349289 0.401522 0.364537 -0.044880 1.268488 1.386805 0.039323 0.607489)
     )

;;; 18 even --------------------------------------------------------------------------------
#(18 5.4135673169319 #(0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0)
     5.3738845938103 #(0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 0 1)
     5.3310880661011 #(0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.589734 #(0.000000 0.128904 0.791112 1.176829 1.319456 -0.047760 0.250141 1.390995 0.366355 1.103698 0.393661 -0.024093 1.112970 0.986605 0.815414 0.987317 0.858855 0.551348)
     4.580164 #(0.000000 0.088065 1.683756 0.348660 0.864971 1.361146 1.224199 0.124257 0.574705 0.001082 1.664767 0.723022 1.280851 0.880081 1.007566 1.375306 1.095774 0.962641)
     4.570825 #(0.000000 1.014207 0.576401 1.182722 1.623809 0.037366 -0.106276 0.719945 1.088940 0.493703 0.074031 1.074477 1.595481 1.109120 1.197779 1.498819 1.161324 0.997523)
     )

;;; 19 even --------------------------------------------------------------------------------
#(19 5.4721938266519 #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0)
     5.4619059562683 #(0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.760423 #(0.000000 0.078500 -0.009665 0.445299 0.326637 1.124753 0.889843 1.345388 1.144621 0.990641 0.735224 1.219841 0.734403 1.676249 0.197585 1.008479 1.250738 0.438525 0.297651)
     4.747536 #(0.000000 1.217706 0.673412 0.449616 1.339090 1.249452 0.119748 -0.159813 -0.067080 0.446567 1.155275 1.187059 0.684859 0.863274 0.563311 1.197365 0.360905 0.957607 0.891096)
     4.743668 #(0.000000 1.219811 0.663388 0.442999 1.326759 1.245187 0.104481 -0.172642 -0.076545 0.433008 1.136268 1.162596 0.675108 0.838538 0.550324 1.176777 0.324581 0.937881 0.863149)
     4.743457 #(0.000000 1.217893 0.656820 0.434930 1.318439 1.234525 0.095173 -0.185206 -0.086731 0.407144 1.121209 1.131725 0.654678 0.822361 0.535204 1.154897 0.288114 0.908839 0.830917)
     )

;;; 20 even --------------------------------------------------------------------------------
#(20 5.670516977407 #(0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0)
     5.5380347270104 #(0 0 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0)
     5.5266017913818 #(0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.841326 #(0.000000 0.883035 0.097875 0.018453 1.302230 0.272330 1.409446 1.703194 0.582507 1.044653 0.993417 1.668381 0.672273 0.285918 0.289609 0.363572 1.035594 0.801569 0.774777 0.509188)
     )

;;; 21 even --------------------------------------------------------------------------------
#(21 5.7292241651627 #(0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0)
     5.6852540969849 #(0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1)
     5.6849967470046 #(0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.921985 #(0.000000 -0.018937 1.375553 1.496177 -0.139325 1.937047 0.317759 0.213913 0.072638 0.935832 1.306093 0.124717 0.468826 1.814956 1.578619 1.412244 0.051100 1.297844 0.783258 1.334465 0.605216)
     )

;;; 22 even --------------------------------------------------------------------------------
#(22 5.9318449080552 #(0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1)
     5.9259635937391 #(0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 0 0)
     5.8572781078687 #(0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.057619 #(0.000000 -1.549052 1.840561 0.899352 0.955243 0.675735 1.388002 0.130931 1.230411 1.016199 1.248642 1.548860 -1.869404 1.414806 -0.062473 -0.077279 1.209336 1.129629 0.911002 1.328778 1.284364 0.506500)
     )

;;; 23 even --------------------------------------------------------------------------------
#(23 5.9574251174927 #(0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
     5.9548940658569 #(0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1)
     5.9208135892745 #(0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.150197 #(0.000000 0.491565 0.619397 0.387291 -0.214520 1.136551 0.632100 0.890158 1.398097 0.878024 0.675567 0.944519 0.610269 -0.181328 0.353190 1.383289 1.649469 0.413950 0.150962 0.559863 0.266346 1.101816 1.465450)
     )

;;; 24 even --------------------------------------------------------------------------------
#(24 6.119236946106 #(0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 0)
     6.0757751464844 #(0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1)
     6.0318420391191 #(0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1)
     6.0318420391191 #(0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.255682 #(0.000000 0.045474 0.639735 -0.206951 0.266882 1.229094 0.912231 0.212812 1.489192 1.359872 0.864819 0.404719 0.603383 0.597438 0.068739 1.051236 1.659277 1.626118 0.036193 0.246242 1.406697 0.040503 -0.053562 0.164493)
     )

;;; 25 even --------------------------------------------------------------------------------
#(25 6.2507610321045 #(0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0)
     6.2422542572021 #(0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1)
     6.152729668872 #(0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 0 0)
     6.1513186981755 #(0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.405563 #(0.000000 0.044827 1.794775 1.405349 1.248426 0.256712 0.428860 -0.020263 0.210400 1.157456 1.741591 0.245940 1.005440 0.948100 0.615139 0.227320 0.746752 0.771990 0.270736 1.529920 0.384512 1.822551 0.327748 0.151266 0.690608)
     )

;;; 26 even --------------------------------------------------------------------------------
#(26 6.3358421325684 #(0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0)
     6.3140621185303 #(0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1)
     6.2921685546228 #(0 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1)
     6.2921685546205 #(0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.454886 #(0.000000 0.050016 0.205870 1.808742 0.405651 -0.024060 0.116196 0.407889 0.823937 0.626331 0.635265 0.067838 0.842405 0.576072 -0.127322 -0.089535 1.707122 0.545902 0.984830 1.260435 0.630088 1.784744 1.306613 1.809592 0.666905 0.989508)
     )

;;; 27 even --------------------------------------------------------------------------------
#(27 6.4054713249207 #(0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0)
     6.243681443715 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)
     6.2436904245852 #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.623706 #(0.000000 -0.020576 0.519707 0.371551 0.864699 1.334512 -0.208181 1.688257 0.033386 1.773592 0.573873 1.617213 0.354916 1.095283 1.392347 1.239659 1.112991 0.853261 0.890503 0.160590 -0.311451 1.252818 1.081249 -0.272186 1.565173 0.964482 1.599914)
     )

;;; 28 even --------------------------------------------------------------------------------
#(28 6.6246975836201 #(0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1)
     6.6145820617676 #(0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0)
     6.5361909866333 #(0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.735312 #(0.000000 1.446564 1.395795 0.794943 1.296122 1.464047 1.535520 1.775478 1.012087 0.704121 0.624490 1.243648 1.360898 0.181612 0.804675 1.270828 0.567656 1.780076 -0.124407 1.351868 -0.223622 1.763371 0.154008 1.296854 0.775406 0.203491 0.802273 0.102755)
     )

;;; 29 even --------------------------------------------------------------------------------
#(29 6.7166719436646 #(0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 1 1 0 0)
     6.7148699760437 #(0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 0)
     6.6767044067383 #(0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.770226 #(0.000000 1.752583 1.827320 1.103585 0.682546 0.650877 0.531929 0.078102 0.175544 1.355580 1.450164 1.046064 1.724627 1.604828 0.350175 0.848881 0.374945 1.131460 1.003712 0.972516 0.411587 0.914857 1.010043 0.192283 0.966189 0.663343 1.289531 1.532023 0.429197)
     )

;;; 30 even --------------------------------------------------------------------------------
#(30 6.8207087516785 #(0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0)
     6.8207082748413 #(0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1)
     6.799307346344 #(0 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0)
     6.6998701095581 #(0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.910618 #(0.000000 0.908807 1.373286 1.277087 -0.177124 0.095893 0.332228 0.128921 0.398841 0.946104 1.403293 0.557346 0.656008 1.276507 0.062453 -0.049983 1.902438 1.755902 1.437139 1.947315 1.608205 1.117016 0.415452 1.614229 1.733504 1.087788 0.099823 0.781893 -0.003344 1.852877)
     )

;;; 31 even --------------------------------------------------------------------------------
#(31 6.9357690811157 #(0 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1)
     6.9057178497314 #(0 0 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     6.9018726284795 #(0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0)
     6.8986349105835 #(0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0)
     6.8660564422607 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.991553 #(0.000000 1.294060 1.380565 1.150714 1.133080 1.031322 1.467952 1.316738 1.560524 1.149380 1.426520 0.309986 0.093879 -0.092838 1.618876 0.386127 1.276099 0.768874 0.092478 1.372697 0.935849 0.029991 0.353204 1.817033 0.371684 0.700369 1.341168 1.538111 1.331703 0.301405 0.818032)
     )

;;; 32 even --------------------------------------------------------------------------------
#(32 7.1377140468569 #(0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 1 0 0)
     7.0221180915833 #(0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1)
     7.011866569519 #(0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 1 1)
     7.003 #(0 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1)
     6.9974670410156 #(0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.065521 #(0.000000 0.285485 1.824991 0.361483 1.113714 0.962272 1.152452 1.837244 0.183331 1.504654 0.432023 1.106977 0.465457 1.357599 1.532977 1.672348 0.833050 1.852805 -0.259910 1.830866 0.240364 0.782902 0.068331 1.705348 0.669695 -0.000853 1.835622 1.185939 1.464578 1.660632 0.971966 1.137154)
     )

;;; 33 even --------------------------------------------------------------------------------
#(33 7.1199560165405 #(0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1)
     7.0745658874512 #(0 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0)
     7.0716042518616 #(0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1)
     7.0670447349548 #(0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0)
     6.978609085083  #(0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.167745 #(0.000000 -0.096128 -0.403532 1.394302 -0.306153 0.366725 0.336897 0.377486 0.129520 0.155758 1.349437 0.237012 0.252758 0.242534 1.430701 1.663672 1.235952 1.670554 1.653037 0.461736 0.694770 0.916622 0.353714 1.885227 1.308226 0.583336 1.382051 1.789584 0.399779 0.760162 0.153822 0.882572 0.072583)
     )

;;; 34 even --------------------------------------------------------------------------------
#(34 7.3321795463562 #(0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0)
     7.3251795768738 #(0 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0)
     7.3184022903442 #(0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0)
     7.314661026001 #(0 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1)
     7.3119759559631 #(0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0)
     7.2703185081482 #(0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0)
     7.2649097442627 #(0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0)
     7.2615523338318 #(0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.229511 #(0.000000 -0.008167 0.081183 0.535218 0.826037 0.619188 0.742084 1.930906 0.000551 0.137816 0.330078 1.391798 -0.021117 0.937153 1.215968 0.408462 0.580765 -0.025711 1.814883 0.352120 0.226327 0.687310 0.409312 -0.196530 0.928045 0.653844 1.224674 1.550245 1.196347 0.209949 1.156937 1.629324 1.104182 0.522358)
     )

;;; 35 even --------------------------------------------------------------------------------
#(35 7.3807096481323 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 1 0 0)
     7.3793916702271 #(0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0)
     7.3590030670166 #(0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0)
     7.3509883880615 #(0 1 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0)
     7.3254580497742 #(0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 1 1 0 0 0)
     7.3159041404724 #(0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0)
     7.3109955787659 #(0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0)
     7.2921919822693 #(0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.410552 #(0.000000 0.115507 1.633859 0.215021 0.209754 1.087733 0.248431 0.906668 1.492002 1.458242 0.742810 1.664038 0.014457 1.257697 0.197675 1.279071 0.798103 0.667759 1.767077 1.115570 1.410963 1.060110 0.655727 1.616105 1.372627 -0.583220 1.471148 1.526299 1.456164 0.649372 0.686998 0.968478 -0.156278 -0.033128 0.572736)
     )

;;; 36 even --------------------------------------------------------------------------------
#(36 7.5039777755737 #(0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0)
     7.497097492218 #(0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0)
     7.4732356071472 #(0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0)
     7.4679698944092 #(0 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 0 0 0)
     7.466917514801 #(0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 0 0 0 0 0)
     7.4267778396606 #(0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.4214091300964 #(0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0)
     7.3326554298401 #(0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.437336 #(0.000000 0.003662 0.086859 1.388832 0.898267 1.459432 0.131070 1.657729 1.521867 1.471295 0.951271 1.325100 1.241786 1.395425 0.150709 1.064708 0.651806 1.427047 1.086410 0.098846 0.328758 1.795857 1.461283 0.857023 1.694299 1.032403 1.245628 0.175004 -0.134353 0.154319 -0.012838 0.387005 0.719800 1.603900 0.574577 0.835322)
     )

;;; 37 even --------------------------------------------------------------------------------
#(37 7.6800961494446 #(0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0)
     7.6781373023987 #(0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)
     7.6548581123352 #(0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 0)
     7.6323590278625 #(0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0)
     7.6028599739075 #(0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0)
     7.5926213264465 #(0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0)
     7.5687103271484 #(0 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0)
     7.4919209480286 #(0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

     6.592781 #(0.000000 0.037594 1.055072 0.685920 0.161609 0.839093 0.802610 0.152490 1.856725 0.671067 0.274340 0.237263 0.202130 1.590830 -0.034293 0.194667 1.738288 -0.314827 0.547569 0.940661 0.822411 0.069900 -0.039381 0.212854 1.361647 1.053422 0.197448 0.557614 0.663862 1.010270 0.752829 1.076373 1.629151 0.648012 1.718682 0.394746 1.438442)
     )

;;; 38 even --------------------------------------------------------------------------------
#(38 7.7734541893005 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0)
     7.7677249908447 #(0 0 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0)
     7.7656890155417 #(0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)
     7.7583861351013 #(0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0)
     7.735631942749 #(0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)
     7.669114112854 #(0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.542358 #(0.000000 -0.020303 1.378297 1.768113 0.243867 1.765618 1.779113 1.045484 1.285905 0.293978 0.321881 1.722391 1.560756 0.401328 0.335125 -0.059127 0.231619 0.961929 1.594001 1.401091 0.650439 0.412010 1.330120 0.099600 1.940222 0.267803 0.404762 1.515814 0.579493 0.002405 0.261785 1.800376 0.421241 1.617996 1.112239 1.305682 1.421552 1.716025)
     )

;;; 39 even --------------------------------------------------------------------------------
#(39 8.060715675354 #(0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1)
     8.0530862808228 #(0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1)
     8.0486888885498 #(0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0)
     8.0062685830938 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.705947 #(0.000000 1.037443 0.333866 0.359287 1.777460 1.532794 0.275647 1.518549 0.326185 0.278158 1.695901 0.434612 0.614148 0.719213 0.309239 0.973763 0.607398 0.508703 1.701292 0.243344 -0.213403 0.307579 -0.129111 -0.128406 0.524383 1.000763 -0.053241 1.216388 0.785259 1.231778 0.025299 0.483101 0.427891 1.260549 1.216340 1.348266 1.383905 0.582409 0.581337)
     )

;;; 40 even --------------------------------------------------------------------------------
#(40 8.1045722961426 #(0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0)
     8.0884717473459 #(0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1)
     8.0304555793911 #(0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.761232 #(0.000000 0.023188 0.023926 0.151984 1.640242 1.214051 0.773557 -0.137799 0.536297 0.565406 -0.060829 -0.068244 0.186358 0.627516 1.073507 1.744829 1.971102 1.317584 -0.015344 1.543462 1.167210 0.918408 1.568799 1.698107 1.541456 0.892281 0.171140 0.631718 1.603612 0.084185 1.407920 0.810878 -0.183335 1.383169 1.586319 1.585765 0.272620 1.542019 0.166367 0.470470)
     )

;;; 41 even --------------------------------------------------------------------------------
#(41 8.3439186011904 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1)
     8.2169809341431 #(0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.893502 #(0.000000 0.181689 0.450912 0.027867 0.642726 -0.263199 0.359151 -0.280418 -0.105306 1.416892 1.252445 1.044906 1.030928 0.172191 0.076215 -0.235561 -0.378435 1.358175 -0.217451 0.041207 1.699284 0.627892 0.603605 1.029706 1.415976 -0.726929 1.402743 0.286298 1.502874 1.429952 0.542371 -0.256595 1.228549 0.367267 1.268157 1.785724 0.092146 0.637646 1.600918 1.414134 0.245237)
     )

;;; 42 even --------------------------------------------------------------------------------
#(42 8.3791161021838 #(0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1)
     8.3605623245239 #(0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     7.002749 #(0.000000 -0.062045 1.223201 1.752977 -0.282378 1.183570 1.042052 0.560047 0.568202 1.436165 1.986823 0.356858 0.254391 -1.856478 1.951268 1.675305 1.157917 0.657319 1.698164 0.358307 0.589314 1.186077 0.510113 -0.025544 0.797365 0.523371 0.518219 0.736052 0.921434 1.164987 -0.038902 0.986985 1.646265 0.689506 0.172764 0.134811 0.176103 0.871762 0.143289 1.392015 0.249343 0.464946)
     )

;;; 43 even --------------------------------------------------------------------------------
#(43 8.4720001220703 #(0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 0)
     8.3471550144283 #(0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.085708 #(0.000000 0.102971 1.668873 1.596006 1.807964 1.576542 1.441056 0.141315 0.049620 1.729709 0.188964 1.762867 0.966443 0.838286 0.335600 0.826853 0.764224 1.846333 -0.099161 1.246704 1.593408 0.310089 1.850305 1.430794 1.148144 0.560892 0.422540 0.898869 1.304073 1.629401 0.836809 1.567767 0.814604 1.803638 0.886536 0.668821 0.944404 0.962109 1.756483 0.224486 0.631284 0.095230 0.832820)
     )

;;; 44 even --------------------------------------------------------------------------------
#(44 8.6881771087646 #(0 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 1 0)
     8.4271850585938 #(0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.109316 #(0.000000 -0.032144 1.098477 1.589007 1.125803 0.701741 0.682793 1.076320 0.411724 0.305595 1.430240 0.701954 0.465775 0.175811 0.135092 0.153522 0.514764 1.916510 1.422118 0.509997 0.071310 0.752994 0.225893 0.609617 0.203770 0.607961 0.547543 1.263403 0.991594 1.797950 0.123775 1.133189 1.343940 1.460376 0.518368 1.832725 0.113764 0.916619 0.287031 0.675397 1.441629 1.464365 -0.221451 0.866949)
     )

;;; 45 even --------------------------------------------------------------------------------
#(45 8.7060899734497 #(0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0)
     8.6457691192627 #(0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0)
     8.6353975051189 #(0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.192680 #(0.000000 0.057332 0.441301 0.199983 0.485474 -0.313950 1.908115 -0.079364 -0.124360 0.002294 1.687636 1.770401 0.455563 0.343994 0.526844 1.109678 0.216375 -1.690525 0.479029 0.212353 1.170801 1.398573 0.741714 1.634523 1.342817 0.159730 0.445320 0.585610 0.643524 -0.074267 1.507709 0.921576 1.122022 0.213119 0.581376 1.594284 0.302729 0.017086 1.156093 0.799309 0.340474 0.962243 -0.108793 1.300028 0.207007)
     )

;;; 46 even --------------------------------------------------------------------------------
#(46 8.9638475105267 #(0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1)
     8.7939519711145 #(0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.297936 #(0.000000 -0.078804 1.011763 -0.096714 -0.258733 1.307775 0.182505 0.557889 0.847609 1.400929 -0.203362 1.228983 -0.012605 1.875706 0.821983 1.937306 0.182345 0.269968 0.316437 1.238318 0.647510 1.317709 0.112618 -0.037406 0.644675 -0.113421 -0.371684 -0.000676 0.948560 1.507452 0.291447 -0.024843 -0.238613 1.165664 1.606363 1.163349 1.170328 1.076386 -0.080060 1.269596 0.914392 0.516468 -0.117959 1.954092 1.482673 -0.016118)
     )

;;; 47 even --------------------------------------------------------------------------------
#(47 8.8732557296753 #(0 1 0 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 0 0 1)
     8.8477687835693 #(0 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0)
     8.7835607528687 #(0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.301922 #(0.000000 -0.053526 1.456950 1.068230 1.922250 0.587173 0.113076 0.076120 0.179477 1.141402 0.812346 0.142976 1.531368 0.451314 0.949848 1.067497 0.916032 0.341962 1.848713 1.768320 0.074681 0.785484 1.395789 1.291783 0.510783 0.671456 0.045318 0.742934 1.222180 0.878857 1.825307 1.492034 1.220702 1.751740 1.540532 -0.096681 0.897103 1.316457 1.098920 1.278173 1.429320 0.894027 1.150808 -0.161264 0.595627 0.087773 0.936854)
     )

;;; 48 even --------------------------------------------------------------------------------
#(48 9.12184715271 #(0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1)
     8.9965600967407 #(0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

     7.474126 #(0.000000 0.070239 1.074215 1.157299 0.848479 0.448148 -0.110880 0.924571 0.710266 1.666944 0.400870 1.406229 0.367270 1.104874 1.804893 0.695592 1.381898 1.018859 1.130033 1.207390 1.370288 -0.147581 1.774211 0.266088 0.501427 0.569425 1.484913 0.428415 0.102395 0.025162 1.539625 1.143271 1.439041 1.212210 0.834073 0.105112 1.296692 1.351195 1.645674 0.836913 1.239133 1.467542 1.752822 0.800139 1.353522 0.848769 0.297705 1.379071)
     )

;;; 49 even --------------------------------------------------------------------------------
#(49 9.2634744644165 #(0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
     9.1650037765503 #(0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

     7.608305 #(0.000000 0.068138 0.679749 1.131497 1.012913 1.066324 0.673787 1.534630 1.211245 0.635392 1.825036 1.537186 0.029975 0.294496 1.479396 0.400498 0.174306 1.407679 1.611290 0.828492 0.454368 1.006751 -0.269358 1.753959 0.505820 0.501376 0.813538 -0.120927 1.252063 0.004156 0.443261 1.446819 0.552555 0.997770 1.107340 1.236998 0.960979 0.932704 0.392401 0.048958 0.791250 1.207220 1.118176 0.820602 1.135021 0.633318 0.738907 1.711689 0.406399)
     )

;;; 50 even --------------------------------------------------------------------------------
#(50 9.348 #(0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0) ; symmetric??
     9.1582123370176 #(0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

     7.676923 #(0.000000 -0.008193 1.291711 1.655501 -0.167235 0.967496 0.813454 0.650991 1.561054 0.165286 0.230454 1.500888 1.061240 0.720637 1.385728 -0.135706 -0.114521 0.349709 1.051728 1.291738 0.754204 0.326406 1.181522 1.357535 0.723646 0.442521 1.166303 1.551438 -0.581133 1.413316 0.469045 0.268851 0.879378 0.276209 0.547427 0.439320 1.511827 1.785747 1.208133 1.745071 1.651133 1.051455 1.755286 1.014227 -0.069840 1.238746 -0.426038 -0.245576 1.486576 0.023383)
     )

;;; 51 even --------------------------------------------------------------------------------
#(51 9.5728101730347 #(0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0)
     9.3615226745605 #(0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

     7.693537 #(0.000000 -0.051290 1.627869 0.754765 1.205706 -0.052680 1.553165 0.270389 1.515820 1.094036 1.047894 0.859351 1.264986 -0.247851 0.790396 0.692006 1.583249 -0.224467 -0.278676 0.894038 1.122481 1.336932 0.742288 0.789345 0.422579 0.766439 0.760165 0.853962 0.306849 1.213562 1.543059 1.101883 -0.062980 0.304389 1.344848 -0.220703 1.375707 1.304080 0.307697 1.447171 0.865600 -0.182172 1.498314 1.346822 1.521929 0.215965 0.585926 0.193670 0.152752 0.922243 1.528033)
     )

;;; 52 even --------------------------------------------------------------------------------
#(52 9.5426025390625 #(0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 0)
     9.449512348335 #(0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     7.859478 #(0.000000 0.132627 1.330649 1.382518 1.627564 0.179920 0.848128 0.079317 0.595512 0.588623 1.627672 1.609483 0.179739 0.505332 1.625678 0.784610 1.296926 0.690716 1.118770 0.725817 0.666131 0.607463 0.479386 1.672864 1.746182 1.804698 1.948158 -0.127795 0.662983 1.834720 0.065532 -0.104616 0.595170 1.739828 1.593939 1.694248 0.353606 0.292383 1.424003 0.948196 0.209740 1.376565 -0.067964 1.897368 1.039511 0.125523 0.412428 0.106350 0.057427 0.926824 1.210237 0.431857)
     )

;;; 53 even --------------------------------------------------------------------------------
#(53 9.7638588738802 #(0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1)
     9.627 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0)
     9.6159172058105 #(0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.790912 #(0.000000 -0.014721 0.597956 1.432364 1.518339 0.166664 1.364463 0.526534 0.454820 1.819848 0.366539 1.757163 0.550767 1.356307 1.236584 1.365934 0.988683 0.956225 1.588462 0.498059 0.312348 0.460739 1.088142 -0.060930 0.244924 0.363157 1.254326 1.787124 1.191833 1.719932 -0.131743 0.168747 1.045126 0.581188 1.161916 0.289508 -0.183475 1.204879 0.882192 0.910842 0.724523 0.689363 1.084176 1.395251 1.015143 1.333377 0.393682 1.489802 0.800470 0.502060 1.391056 1.181562 0.813403)
     )

;;; 54 even --------------------------------------------------------------------------------
#(54 9.7764141549279 #(0 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1)
     9.748743057251 #(0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0)
     9.5190944671631 #(0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.855122 #(0.000000 0.061746 0.632327 0.842339 1.611758 1.150095 1.703025 0.507565 -0.049068 0.311846 0.308734 0.987647 1.348159 1.059905 1.709561 1.605324 0.127596 0.919590 -0.389635 0.852831 1.633968 0.806511 1.012135 0.855487 0.317759 0.184048 0.886486 1.728394 0.867804 -0.010665 0.099227 0.211391 1.647046 0.262422 1.898410 1.428321 1.078328 0.691561 0.395797 1.390059 1.858071 0.546135 1.391831 1.764841 1.624141 1.663058 -0.097852 1.642854 0.846015 0.132400 1.818213 0.291995 0.074920 1.694608)
     )

;;; 55 even --------------------------------------------------------------------------------
#(55 10.131931993478 #(0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)
     9.9292899584938 #(0 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1)
     9.7848987579346 #(0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1)
     9.6719217300415 #(0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

     8.126581 #(0.000000 -0.017578 1.584354 -0.093168 1.531239 0.248826 1.154076 -0.002427 0.199797 0.769553 -0.042905 1.863541 0.089556 0.092282 0.763122 0.096387 0.593446 1.560174 0.079199 0.521694 0.721694 1.197196 0.234160 0.037993 0.188034 1.112255 -0.050873 1.562006 1.182811 0.682014 1.456581 1.375106 0.714082 1.650403 0.887440 0.602145 0.538017 0.430968 0.110595 1.077083 0.059621 0.321630 0.693900 0.891590 0.475025 1.161320 1.588110 1.296436 0.211809 -0.005616 0.223692 1.438833 0.983474 0.292480 0.524535)
     )

;;; 56 even --------------------------------------------------------------------------------
#(56 10.014793395996 #(0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1)
     9.9184818267822 #(0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1)
     9.7564358364052 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 1)
     9.6809562784664 #(0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     8.127228 #(0.000000 -0.065084 0.953266 0.469965 1.744892 1.118836 1.092843 -0.281702 1.262486 1.119947 1.652243 0.429290 0.656616 1.551880 1.247797 1.280662 1.022781 1.614311 1.672045 -0.164690 1.548432 1.721747 0.801196 0.697421 1.209034 0.380507 0.495485 1.342351 -0.111888 1.413701 -0.183281 1.112407 1.268384 1.442055 0.606387 1.351642 0.485190 1.769683 0.396270 0.395613 0.087616 0.915977 0.523822 0.428476 0.030793 1.769195 0.732339 0.392055 1.285837 1.755740 -0.203110 -0.018695 0.750391 1.180725 0.657173 1.655962)
     )

;;; 57 even --------------------------------------------------------------------------------
#(57 10.246812120784 #(0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0)
     10.116240908787 #(0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0)
     9.9813938140869 #(0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1)
     9.8992366790771 #(0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

     8.167946 #(0.000000 -0.021825 1.616053 1.628409 -0.201021 1.345463 0.322884 1.140931 1.319886 0.203849 1.752731 0.017969 0.353236 0.131437 1.563403 1.521172 0.352986 0.304319 1.160737 0.254536 0.053689 1.214832 0.083531 1.303160 1.013460 1.573206 1.678964 0.522247 0.747357 1.021577 1.424989 1.011853 1.225708 1.644420 1.460621 -0.036676 0.544588 1.635133 1.217170 0.640376 0.532648 0.689698 0.414922 0.884542 0.075466 0.721876 -0.300310 1.588133 0.527345 1.226068 0.145045 1.550715 1.545418 1.158744 0.369218 0.752245 -1.889727)
     )

;;; 58 even --------------------------------------------------------------------------------
#(58 10.486150288901 #(0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1)
     10.185283647732 #(0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 0 1)
     10.040289878845 #(0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1)
     9.8761510848999 #(0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.203010 #(0.000000 0.069827 0.408935 0.771695 0.844827 1.685164 0.234131 0.383531 0.128000 1.812442 1.228405 1.080293 1.044640 0.257822 0.724617 1.497554 1.311941 1.824638 0.026836 1.557362 1.582184 0.095741 0.301797 0.097586 1.399420 0.456986 0.719293 1.703503 1.137475 1.173006 1.478351 1.744100 0.915105 1.057491 1.356142 0.804177 0.590666 1.599345 0.496048 1.572976 1.578065 1.005785 1.799260 1.515839 0.369227 1.308267 0.569480 1.332755 1.430893 0.193002 1.570086 0.119578 0.834367 0.261330 1.626012 1.280670 1.462948 1.477761)
     )

;;; 59 even --------------------------------------------------------------------------------
#(59 10.306503751934 #(0 1 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.305177937827 #(0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.237511634827 #(0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1 1)
     10.094394683838 #(0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.266793 #(0.000000 0.179619 1.182368 1.325189 0.727114 0.436888 0.299668 0.059304 0.090844 1.214137 1.397656 0.253415 1.008339 1.588466 -0.158261 0.855785 1.695539 0.758786 1.722481 1.305608 1.025159 1.276577 0.564233 1.167731 0.601839 0.138810 0.839727 1.270536 -0.161166 0.097016 0.163134 0.360127 -0.012022 1.797028 1.079822 1.305053 -0.198245 1.801287 0.166361 0.025768 1.927927 0.174101 0.379331 0.188926 0.960160 0.240596 0.165641 1.528662 0.760838 1.459681 0.793703 -0.139933 1.864098 0.932244 0.219483 1.472140 1.530306 1.664921 0.331418)
     )

;;; 60 even --------------------------------------------------------------------------------
#(60 10.491376876831 #(0 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0)
     10.333255371943 #(0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.349076 #(0.000000 0.023410 0.105502 0.388451 1.322048 1.464928 0.273834 0.959434 0.740831 1.541130 0.290120 1.234187 -0.438720 -0.110201 1.510683 0.192065 1.223285 0.142852 0.642813 0.303924 0.299257 0.110392 0.675310 0.961578 1.197338 0.491665 0.651696 0.938672 0.422497 1.350988 1.210232 0.615872 0.226627 0.616241 1.330114 0.501232 1.571857 0.878996 0.484291 0.803888 0.511371 -1.804772 1.671615 0.191420 0.454813 0.184252 1.734625 1.270928 1.305437 0.101047 1.478927 1.701736 0.275493 0.691354 0.678875 0.446037 1.158449 1.841216 1.329196 0.460581)
     )

;;; 61 even --------------------------------------------------------------------------------
#(61 10.587104797363 #(0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 1 0)
     10.557340621948 #(0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1)
     10.209 #(0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0)
     10.120587847566 #(0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     8.498887 #(0.000000 1.184418 -0.164212 -0.407229 1.678453 1.189212 0.126346 -0.094664 1.694401 1.072813 0.583122 0.403564 0.133602 1.609985 1.061090 1.731036 0.100032 0.735004 1.357572 0.355496 0.406192 0.323835 0.793173 1.756637 0.049922 1.234516 0.184111 0.811164 0.394268 0.877829 0.219630 1.694386 1.369464 1.190031 0.216830 -0.249323 0.347670 0.075921 0.534353 1.290015 1.456751 0.104550 0.098326 1.091472 0.224510 1.334514 1.335698 0.329517 0.595763 0.262553 0.482429 0.381831 1.218932 0.431015 1.648342 1.724744 0.101341 1.639233 1.568429 1.782905 -0.093922)
     )

;;; 62 even --------------------------------------------------------------------------------
#(62 10.800075218392 #(0 0 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0)
     10.501984943687 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1)
     10.318392753601 #(0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.517835 #(0.000000 0.774789 0.014215 0.450429 0.117721 0.167545 0.355767 0.026534 1.867379 1.483846 1.422869 0.956013 1.074250 -0.390198 0.543745 1.844210 1.544402 0.813803 1.948858 1.234192 0.325079 0.883292 0.827358 0.945973 0.067367 0.854527 0.929290 -0.394734 1.129093 1.504493 0.823216 1.284789 0.709228 1.894305 1.610690 0.670475 1.026329 0.417421 0.090443 0.004163 1.000238 1.531190 0.547867 0.602355 1.169982 0.348374 0.478046 0.577709 0.772384 1.138024 1.318210 1.570824 0.461266 -0.085576 0.543759 0.717806 1.014433 1.554571 0.856803 0.691874 0.095862 1.575436)
     )

;;; 63 even --------------------------------------------------------------------------------
#(63 10.855396270752 #(0 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1)
     10.68339442069 #(0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.562 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0)
     10.45694065094 #(0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.521367 #(0.000000 0.032870 0.705334 1.688980 0.249302 1.643667 1.412901 1.822500 0.986010 0.001512 0.575512 1.864509 1.329760 1.413044 -0.041660 1.673923 0.123662 0.985044 0.038903 1.049359 1.179567 0.672520 0.561926 0.023813 1.713509 0.056794 1.085934 0.396018 0.295784 0.692603 0.497314 0.272359 1.563238 1.525498 1.712649 0.248900 1.568228 1.045792 0.715781 1.309581 1.430012 0.063981 0.839025 1.210318 1.219229 0.447685 1.681585 1.484728 1.703934 1.748260 0.620075 1.661606 1.571532 0.766690 0.757050 0.888331 1.026634 0.148968 1.148914 0.835220 0.728612 1.285404 1.457780)
     )

;;; 64 even --------------------------------------------------------------------------------
#(64 10.952004432678 #(0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1)
     10.532917976379 #(0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1)
     10.487 #(0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.542787 #(0.000000 -0.089867 0.154615 0.120108 0.536982 1.627371 0.350612 -0.370250 1.457888 0.112597 0.155857 1.560140 0.085692 1.734069 1.058661 -0.072205 0.237103 1.221326 0.954037 1.483889 1.201430 0.262434 1.787845 0.981710 1.009972 1.218046 1.020089 1.229132 1.201357 0.316125 0.994728 0.176511 1.815820 1.408317 1.416871 -0.111609 1.393356 1.590037 1.084442 1.335802 0.385133 0.787198 1.779678 1.432279 0.252665 1.533799 0.306906 0.791457 0.438323 0.034359 1.534327 1.238506 0.942408 0.134877 1.081379 1.459285 -0.163649 -0.055572 -0.039182 1.009042 1.792768 0.203071 0.581938 0.601696)
     )

;;; 65 even --------------------------------------------------------------------------------
#(65 10.903659606228 #(0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 1 0)
     10.842938423157 #(0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0)
     10.593795776367 #(0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

     8.749849 #(0.000000 0.073719 0.015579 0.068227 1.871504 0.403115 1.615543 1.450557 0.392669 0.374976 1.039419 1.308780 -0.182581 1.434850 1.381909 0.178594 -0.149260 1.645449 1.270141 1.859000 0.773617 0.635904 1.766246 0.521745 0.628824 1.293042 1.402505 -1.826722 1.627702 0.725112 0.946916 1.401118 0.204285 -0.103995 1.607419 1.812165 1.516199 1.285337 1.128720 0.247161 -1.858456 -0.026095 1.085038 0.419403 0.319708 0.710367 1.430493 0.741876 1.619346 1.840851 0.398944 1.190377 0.677413 1.156521 0.874404 1.287331 1.186736 0.976237 0.109417 0.970627 0.256959 0.983184 1.823471 0.891821 0.997611)
     )

;;; 66 even --------------------------------------------------------------------------------
#(66 10.77367179842 #(0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

     8.836109 #(0.000000 0.010367 -0.205986 1.171337 1.327831 1.512233 1.869065 1.591444 -0.254035 1.170494 1.757040 1.232386 1.512940 0.561816 1.004048 1.462997 1.412732 1.707607 0.297803 0.566241 1.872105 0.295912 1.137523 0.905752 1.163352 1.613579 1.066580 1.590972 0.163207 0.833208 0.485754 1.237879 0.237092 1.735711 0.501360 1.090471 0.304339 0.455594 1.248233 1.539884 0.429618 -0.061306 0.269441 0.113623 1.234173 1.768822 0.238377 0.668365 0.269869 1.086048 0.103245 1.321057 1.035813 1.387964 1.144403 1.043022 1.043390 0.778548 0.027521 -0.166339 1.238629 0.820081 -0.100524 1.319191 0.411261 0.106898)
     )

;;; 67 even --------------------------------------------------------------------------------
#(67 11.373999595642 #(0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1)
     11.240343093872 #(0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0)
     10.668939590454 #(0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

     8.944867 #(0.000000 -0.025015 1.003583 1.930700 0.499193 1.599837 1.721695 1.703445 0.930537 0.674239 -0.139350 0.595302 0.753067 0.768074 1.246754 0.174514 0.196381 1.336575 0.383135 1.840128 0.276128 0.950728 1.472484 -0.245643 0.729250 -0.100849 1.451212 1.470420 1.043601 0.222098 0.486074 -0.067070 1.472901 0.907556 0.983795 0.839528 0.800003 1.499739 0.168443 0.298736 1.292240 0.166515 1.255652 1.714659 1.740734 0.022248 0.420838 0.911747 0.335256 0.931796 0.477220 1.524442 0.572786 0.470210 1.851318 1.004657 0.298544 0.636087 0.020845 0.528699 0.652775 -0.032563 -0.124374 0.771220 0.491492 0.536178 0.705497)
     )

;;; 68 even --------------------------------------------------------------------------------
#(68 11.328473091125 #(0 1 0 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0)
     10.834321813096 #(0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

     8.916190 #(0.000000 -0.104832 0.765135 1.532697 0.963816 -0.082984 1.031817 1.656183 1.076025 0.165052 1.620701 0.240468 -0.046228 1.719362 0.944756 0.771824 0.461104 1.230711 1.047654 1.182589 1.483778 0.955475 1.866256 1.762057 1.658654 -0.278909 1.587632 0.746967 1.419744 1.261777 0.106312 0.519110 -0.195955 -0.156535 0.022469 0.058837 1.210493 0.270149 -0.183795 1.368097 -0.014117 1.079074 1.373575 1.451447 1.720025 0.519428 1.012756 0.954146 1.097469 -0.053819 1.337734 0.581769 0.380455 0.610798 0.908933 1.358007 0.588809 1.874634 0.141538 0.905277 1.642186 0.383349 1.012929 1.282387 0.910305 0.638383 0.043957 1.789537)
     )

;;; 69 even --------------------------------------------------------------------------------
#(69 11.439030647278 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0)
     11.237507249543 #(0 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0)
     11.164121627808 #(0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.950748 #(0.000000 -0.053401 0.115566 1.770633 1.098751 0.816372 0.851004 0.721026 0.654971 0.307979 0.136697 0.369700 -0.010511 1.605232 0.968361 0.961023 1.053310 0.804228 1.076480 1.328696 0.997083 0.777642 1.685268 0.039055 1.916906 1.490596 0.105518 0.085961 -0.109495 0.422949 0.522445 1.428732 -0.124664 1.557171 1.509905 -0.076278 0.156114 1.708855 1.063227 1.390842 1.449235 0.217048 1.267465 0.613878 0.251084 1.578478 1.105819 0.664329 1.462424 0.177717 1.354291 0.555501 1.603989 1.346581 0.175215 0.452590 1.310128 0.081674 1.314474 0.062238 1.047228 -0.061161 0.752760 1.585514 -0.119503 0.526129 0.628292 0.979199 1.702760)
     )

;;; 70 even --------------------------------------------------------------------------------
#(70 11.561226844788 #(0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 1)
     11.405939102173 #(0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 1)
     11.188811302185 #(0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

     9.058851 #(0.000000 0.121159 0.576856 0.158848 -0.234950 0.566734 1.722889 0.687546 0.071559 1.421566 0.854695 -0.408773 1.361871 0.689671 0.509831 1.153878 0.449053 0.279824 0.889760 0.511866 -0.032511 1.167718 1.628461 0.270051 0.365802 0.827888 0.134069 1.588296 0.414358 1.132476 1.444719 1.517992 1.024335 0.354219 0.559606 0.530244 -0.044712 1.842651 1.004993 0.184402 0.644878 1.340455 0.963770 1.732643 0.105361 0.317021 0.530116 0.184180 0.456019 1.336998 0.021852 -0.444627 1.863037 0.556559 -0.027893 1.457535 1.530709 0.625855 0.516940 1.757313 0.459956 1.245366 0.462890 0.932146 0.890223 1.064682 1.112648 1.322089 1.252086 1.143332)
     )

;;; 71 even --------------------------------------------------------------------------------
#(71 11.438183906719 #(0 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.28450554254 #(0 1 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0)
     11.146488189697 #(0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

     9.225730 #(0.000000 0.015725 0.545996 1.272491 0.472476 1.108689 1.073279 0.900303 1.317767 1.447378 1.932714 0.814563 1.642416 0.490063 1.095978 1.120342 1.262688 1.037007 1.746055 1.115621 -0.101456 0.357639 1.319868 1.680679 0.776621 0.264615 0.264928 0.738242 -0.018405 0.202374 0.155540 0.331233 1.427694 0.235058 1.651940 0.390992 1.594949 1.118703 0.007629 1.684457 1.719676 1.460375 0.111075 0.580922 0.748173 0.584652 0.045226 0.276985 0.194508 0.155105 1.278587 1.049163 1.918914 -0.235732 0.572361 1.424215 0.633549 0.582431 1.566549 1.438833 0.598809 0.122045 1.716142 0.095397 -0.097925 1.133116 1.116168 0.632528 0.333952 0.116017 1.109651)
     )

;;; 72 even --------------------------------------------------------------------------------
#(72 11.543568607158 #(0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 0)
     11.492732978803 #(0 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1)
     11.323646371629 #(0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     9.167233 #(0.000000 -0.003412 0.214620 -0.130722 1.291605 0.082678 0.104622 1.145834 1.344990 0.116068 1.474443 0.354225 1.062779 -0.128823 0.739618 0.475103 0.983025 1.071183 0.894017 0.766133 0.625074 0.795627 0.410293 0.522370 1.053675 0.458242 1.227458 1.048438 0.993567 1.128366 0.669918 -0.382503 0.434493 0.754830 0.336742 0.018588 1.623686 -0.043009 0.749260 1.029434 -0.155921 1.192569 -0.003763 0.713181 0.378187 1.537275 1.232971 0.729622 0.014029 0.849349 1.088820 1.517085 1.786912 -0.122131 1.413550 0.022589 0.321059 0.923589 0.944656 0.358397 0.200667 1.525153 0.177780 0.837621 1.000235 0.815402 0.123612 1.586424 0.159750 1.465097 0.529446 0.223174)
     )

;;; 73 even --------------------------------------------------------------------------------
#(73 11.708482477396 #(0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.567651928526 #(0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0)
     11.416394233704 #(0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

     9.302168 #(0.000000 0.032140 1.907316 0.878541 0.693148 -0.008522 1.172751 -0.053727 0.579047 0.694540 1.398695 1.548054 1.185226 1.198072 0.290962 0.373467 1.623023 0.180633 0.996197 0.349315 1.503820 1.081731 1.419133 -0.032341 0.120072 0.064854 0.335463 0.359196 0.827477 0.651239 0.219565 0.108597 0.586370 0.639096 0.682574 0.885262 0.383903 1.816350 1.458950 0.004416 1.229934 1.243895 1.032897 0.323084 0.648017 0.107553 0.627668 0.195057 0.654869 1.671353 -0.279148 0.257537 1.465606 1.485401 0.221482 0.325492 1.708195 1.293679 1.790267 1.090446 0.600836 1.729475 1.198304 1.740643 -0.017571 0.889107 1.350961 0.673878 1.598586 0.376804 1.095096 0.152571 -0.043872)
     )

;;; 74 even --------------------------------------------------------------------------------
#(74 11.869382858276 #(0 0 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1)
     11.749699425492 #(0 0 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1)
     11.47264289856 #(0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

     9.344159 #(0.000000 -0.012609 -1.905976 1.859092 1.417437 0.860807 0.905857 0.771240 0.122416 1.243651 0.068817 1.150239 -0.205465 1.055486 0.948879 1.184715 1.840787 1.262684 -1.762382 0.141138 0.740817 1.840838 1.150378 -0.169583 1.888763 0.196769 1.618112 0.896823 1.071116 1.298505 1.654345 0.272492 0.018515 1.833085 1.682691 0.210267 0.505755 1.782005 1.252012 0.684098 0.906543 1.374823 -0.222963 0.373997 -0.033322 1.792122 -0.018054 0.165731 1.509515 0.163411 1.586658 1.877239 1.705462 0.461730 1.343597 1.617134 0.450825 1.170443 0.862822 0.655855 1.517663 1.159605 0.702929 0.596179 1.168883 1.644387 -0.361488 0.997777 0.131719 1.106729 1.685278 0.222425 1.351272 0.529510)
     )

;;; 75 even --------------------------------------------------------------------------------
#(75 12.015588177241 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1)
     11.787453747993 #(0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 1)
     11.599789619446 #(0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1)
     11.479255355845 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     9.315259 #(0.000000 0.083860 1.284890 0.260837 1.596615 1.000253 0.051517 1.169728 0.687449 0.130121 0.883250 0.095312 0.712238 1.788278 0.035737 1.283325 0.147150 1.057419 1.512825 0.103442 0.610805 1.451045 0.059564 -0.007715 1.233503 1.246368 -0.254513 1.000534 0.885766 0.137135 1.554846 0.595520 -0.616611 1.761949 1.667208 -0.028873 -0.064585 1.316430 -0.172843 1.474990 0.217844 0.016890 1.730372 1.579694 1.139748 0.977022 1.234444 1.549798 -0.500025 0.329286 0.968957 1.308810 0.840027 -0.023797 0.075167 0.265679 0.648636 0.062863 0.109633 1.245027 1.011075 0.739592 1.027690 -0.159163 0.458890 0.031746 0.779207 0.327165 0.763284 1.335794 1.120541 -0.054967 -0.322074 1.469957 1.398732)
     )

;;; 76 even --------------------------------------------------------------------------------
#(76 11.890932162956 #(0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1)
     11.477294510597 #(0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

     9.491125 #(0.000000 0.013434 1.778722 1.274783 1.334415 0.346506 0.915789 1.008551 0.135148 0.077413 1.430859 1.109552 1.225060 1.677788 0.308334 0.404331 1.730136 1.567956 0.797335 1.901866 1.241114 1.250980 1.298619 1.348529 0.995989 1.385924 1.370249 0.830892 0.773012 0.326258 0.997952 1.279157 0.487595 0.163929 1.206127 1.449687 0.413829 0.852410 1.791283 0.595179 0.436461 0.546870 1.042179 1.198581 0.541311 1.038830 0.357400 1.254669 1.515279 1.439878 1.571228 1.559030 0.056285 1.192545 0.093689 1.172672 0.562754 -0.110091 1.468336 0.078087 1.497815 0.674774 0.565987 0.611082 1.350381 1.621715 0.040891 -0.167028 0.206375 1.672482 0.857794 1.314883 0.253111 0.912820 0.662493 1.614651)
     )

;;; 77 even --------------------------------------------------------------------------------
#(77 11.909692733602 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1)
     11.875939332637 #(0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1)
     11.594018936157 #(0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

     9.549271 #(0.000000 0.038931 -0.151762 -0.116561 1.499153 1.428357 0.414596 0.756334 1.366729 0.581739 1.445354 1.054201 -0.155678 1.286129 1.627272 0.200495 0.347175 1.424107 0.772265 1.150154 0.971415 1.550362 0.464054 1.482091 1.861986 1.336708 0.751318 0.642834 1.108603 0.611501 1.353260 -0.142518 0.782372 1.401054 0.039766 0.981710 0.786083 0.867810 0.087907 0.156914 0.565875 0.978118 -0.037536 0.638549 0.120677 0.932023 0.671419 1.129332 1.892793 0.264449 0.027690 1.715738 1.158770 0.172267 1.876485 0.202278 1.861036 1.111721 0.695208 0.927311 0.875670 0.883621 0.808820 0.285715 0.729704 0.981391 0.394267 1.253717 1.207400 1.806811 1.667609 0.872412 0.666444 1.312231 1.807807 1.350590 1.033095)
     )

;;; 78 even --------------------------------------------------------------------------------
#(78 11.940728787203 #(0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.722686 #(0.000000 0.041250 0.229149 0.578291 0.646882 1.195423 1.748984 0.323224 0.223523 0.820584 0.594179 0.356713 0.333205 1.058700 0.290449 0.335164 0.734131 1.481300 1.443499 0.531017 1.858232 -0.087589 0.437928 0.245757 -0.114242 0.584232 0.176670 -0.119556 0.788980 0.989819 1.615347 0.884161 1.297188 -0.157894 1.488979 0.621304 1.865417 -0.094043 1.339426 1.219808 0.723368 1.862441 1.068487 0.856066 0.338384 0.512073 0.000987 1.836569 0.437243 0.562905 1.155474 0.517697 1.343789 0.729055 -0.139029 0.434784 0.378612 0.613892 1.274765 0.553170 0.992078 1.605782 1.455134 1.699970 1.789101 0.931741 1.250740 0.551294 -0.359418 1.855476 1.045881 1.165135 0.333953 0.469587 0.198724 1.503226 -0.020367 1.415823)
     9.7174727609649 #(0.0 1.3777043269231 1.1040846538462 0.60948998076923 0.11776130769231 0.27577763461539 0.034774961538462 1.7724032884615 1.2821526153846 1.3359069423077 0.13592926923077 1.7730645961538 0.81286992307692 0.98686025 1.4741995769231 0.91952490384615 0.81977723076923 0.83644455769231 0.38959088461538 0.72256121153846 1.6307735384615 0.67525986538462 0.64980619230769 1.7998685192308 0.91590484615385 1.1958411730769 1.8730555 1.1539138269231 1.4006111538462 0.70562348076923 1.0157228076923 1.4231861346154 1.3368034615385 1.3740037884615 0.40209911538462 0.8889884423077 1.5382857692308 0.89470509615385 1.9822254230769 1.17707775 1.8378320769231 0.43334640384616 1.1336717307692 0.082769057692303 1.1023583846154 0.49240971153846 1.6885430384615 0.40967936538461 0.6875336923077 0.068937019230766 1.8603313461538 0.95328167307693 0.766595 1.7433563269231 0.34927465384616 0.12154398076923 1.3255793076923 1.2057186346154 1.3850489615385 0.0048972884615353 1.4619366153846 1.5502389423077 1.0369442692308 0.30222159615384 1.9134249230769 0.47217625 0.27244857692308 0.88913690384616 1.0524662307692 0.9146825576923 1.3819598846154 0.83147321153847 1.4838315384615 1.0793558653846 0.008615192307694 0.64893751923077 0.63414384615384 1.3779281730769)
     )

;;; 79 even --------------------------------------------------------------------------------
#(79 12.421415328979 #(0 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)
     11.878196632448 #(0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

     9.769763 #(0.000000 -0.038152 0.997931 1.413044 -0.134215 0.408422 1.658772 0.201322 1.769197 1.295654 -0.243545 1.619636 1.764148 1.100018 0.925418 0.341845 1.115119 0.864568 1.674545 0.442445 0.369242 0.892507 1.389029 0.741076 1.396511 0.731329 0.408046 1.652585 0.387323 1.171049 1.677121 0.959071 1.721812 1.559726 1.169276 1.147457 0.758408 1.147374 1.595756 0.903446 0.290663 1.067093 1.138061 1.904995 0.731009 0.669372 1.257771 1.901501 1.230235 1.193230 0.551270 0.767583 1.487089 1.124120 1.510338 0.624208 0.027235 0.554328 -0.037810 1.879777 1.516932 1.698420 1.200459 0.130986 -0.090654 -0.059712 0.341743 0.207536 1.023102 0.932060 0.838773 1.403014 1.344771 0.340070 -0.084183 1.619549 1.668792 1.572712 0.584824)
     )

;;; 80 even --------------------------------------------------------------------------------
#(80 12.739060401917 #(0 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0)
     12.228775030303 #(0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0)
     12.095606803894 #(0 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0)
     11.989325523376 #(0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

     9.794468 #(0.000000 0.080293 1.081196 1.285011 1.316422 0.729124 0.529908 1.417138 1.769282 0.204183 0.703112 0.119959 0.047449 0.120381 0.911049 0.778823 1.782657 0.277672 0.040349 0.967776 0.868929 0.402093 0.094496 0.881338 0.369149 0.981006 0.110667 1.260356 0.651909 1.953645 0.378542 0.202656 0.521020 0.714556 0.705593 0.540473 1.252527 1.091780 0.318776 1.750833 1.418582 1.618091 -0.027051 1.636355 0.702202 -0.014224 1.644060 1.903649 1.421139 1.250015 0.453353 1.510764 0.574579 0.623550 1.121192 1.647203 1.203559 -0.084481 0.383212 0.975431 0.958642 0.847726 1.040614 0.011726 0.068107 1.581414 1.546093 1.580465 0.928070 1.524723 0.394443 1.129467 0.140645 1.532327 0.248585 0.778553 1.848814 0.429336 1.493088 1.608107)
     )

;;; 81 even --------------------------------------------------------------------------------
#(81 12.189952580352 #(0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1)
     12.039585160315 #(0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)
     11.979215621948 #(0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

     9.909988 #(0.000000 -0.027044 0.670925 0.672287 0.556422 0.959061 1.660404 1.827490 1.905204 1.572938 1.373745 0.831711 0.128112 0.570430 0.434295 0.195583 0.358256 1.146370 0.628086 1.483182 1.214550 -0.065975 0.458916 0.501501 0.929542 0.491767 1.503491 1.754954 0.111944 0.504737 0.092861 1.544656 0.164190 1.755634 1.221889 0.787583 -0.143678 0.905795 0.441179 0.584480 0.876410 0.663568 1.537778 -0.028267 1.158967 -0.048259 0.437283 1.306139 0.048632 0.836907 1.320011 0.768327 0.367308 0.809095 0.904707 1.604869 0.430890 0.663938 0.954948 0.951226 0.568565 0.312704 0.653386 1.519386 1.820067 1.378419 0.869714 0.026266 0.117129 1.358608 1.578943 0.853699 0.160601 1.528143 1.910946 0.431626 1.950106 1.853442 1.792735 0.765719 0.185923)
     9.8865253871568 #(0.0 0.4981674382716 1.6926788765432 0.25877431481481 0.66029275308642 1.527037191358 0.55834362962963 1.2068170679012 1.6499475061728 0.22075794444444 0.35487338271605 0.20917982098765 0.081467259259259 1.1896286975309 1.5328081358025 1.7123705740741 0.49349901234568 1.6781464506173 1.4552218888889 1.1841373271605 1.1504737654321 0.6274052037037 1.5028576419753 1.8736840802469 1.1618285185185 0.67017495679012 0.64406239506173 1.3401768333333 1.9451352716049 0.91003470987654 0.83908114814815 0.92792158641975 0.19960602469136 1.850665462963 0.23851990123457 0.14247333950618 1.6113487777778 1.3394012160494 1.352189654321 0.11547109259259 0.8338045308642 1.0490439691358 0.55128140740741 1.412857845679 0.50724228395062 0.19621072222222 1.5346021604938 0.81722659876543 1.901177037037 0.97268047530864 0.20352291358025 1.9454683518519 0.18649079012345 1.0346882283951 1.7065776666667 1.1611311049383 0.18421654320988 0.90468698148148 0.046087419753086 0.13269585802469 0.3284752962963 0.9755197345679 1.6046761728395 0.86870761111111 1.3940900493827 1.6022014876543 1.6057639259259 1.7082733641975 1.7795968024691 1.5490352407407 0.45499467901235 0.14810611728395 0.063276555555554 1.6367569938272 0.64297643209876 1.7555298703704 1.718774308642 0.24097674691358 0.53632618518518 0.19834562345679 1.7269090617284)
     )

;;; 82 even --------------------------------------------------------------------------------
#(82 12.307968522655 #(0 0 0 0 0 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0)
     12.071621513807 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0)
     11.74796962738 #(0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

     9.915995 #(0.000000 0.013356 0.793654 0.807120 0.385986 0.612703 1.075798 0.778105 1.722507 1.352170 1.621124 0.551454 0.170706 1.124597 0.153060 1.323356 1.724245 1.242420 0.963031 1.121989 0.078935 1.587239 0.208033 1.892606 0.063849 0.795856 0.928224 1.372118 1.509870 1.084814 0.106895 1.002213 1.104878 0.547661 1.588202 1.778922 0.888510 1.608223 0.545424 0.717108 1.828114 0.971174 1.799876 0.040207 1.937773 0.908719 1.729093 0.315852 0.320842 0.753728 0.835987 -0.124456 0.574030 0.450267 0.037301 -0.030971 0.941660 -0.263390 1.968022 1.899176 1.447947 1.113842 0.266141 1.872220 0.352361 1.246076 1.064772 0.594709 0.002330 0.397204 0.367096 1.017269 1.780618 1.123570 0.544857 -0.157043 0.012776 0.236071 1.740389 0.151771 0.158908 0.001821)
     )

;;; 83 even --------------------------------------------------------------------------------
#(83 12.587569236755 #(0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1)
     11.931811297539 #(0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

     9.964258 #(0.000000 -0.015307 1.651454 0.054974 1.028095 0.539716 1.774710 0.757193 -0.001333 1.174703 0.510370 0.562803 0.315481 -0.261822 1.841484 1.081384 0.261253 1.419579 -0.008086 1.440693 1.049286 0.416351 1.647543 0.351957 1.942363 0.275681 0.381913 1.144163 1.750719 0.341542 0.338071 0.862652 1.173890 1.818892 0.943453 0.130729 -0.003023 0.084500 1.467693 1.409452 0.521387 1.668714 1.592862 0.112413 0.353013 0.185851 1.121689 1.705980 0.368155 0.009158 -0.172796 1.313934 1.400947 1.597049 0.599193 1.593803 -0.090365 0.296104 1.485148 1.649484 0.965162 0.340780 0.901228 0.856575 0.362794 1.829806 0.557054 0.795557 1.556663 0.748098 0.707237 0.110081 -1.850680 0.524206 0.361262 0.443496 1.181593 1.253553 0.970684 1.576949 1.190006 1.674497 0.383965)
     )

;;; 84 even --------------------------------------------------------------------------------
#(84 12.747644424438 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.50866273996 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1)
     12.426499838032 #(0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     9.989895 #(0.000000 0.120898 0.606820 -0.041426 0.817641 0.153986 1.209349 0.448695 1.182402 1.819802 1.737963 1.555523 1.039652 1.305047 -0.030669 1.289589 0.363819 1.722467 1.954442 1.682288 -0.096232 1.689870 0.543181 1.011992 1.644200 -0.023901 -0.070151 1.821048 0.587828 0.695372 0.782663 0.902039 0.811379 0.625511 0.382625 0.216227 0.360093 0.945817 0.055488 0.215842 0.940260 0.404373 1.581135 1.719626 0.512690 0.179356 0.016335 1.468330 1.073548 0.198904 0.753430 0.665657 1.575344 0.667275 0.305653 0.402354 1.472849 1.884676 1.102031 0.382941 1.262032 1.974116 1.665007 1.253935 -0.004963 0.077856 0.208185 0.431352 -0.057999 0.057088 1.214337 1.276088 0.811996 1.650235 1.724358 0.766080 1.362174 1.334602 0.459625 0.027886 1.945155 0.175653 0.965477 1.427053)
     )

;;; 85 even --------------------------------------------------------------------------------
#(85 12.635076593197 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1)
     12.624737923152 #(0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1)
     12.270205061432 #(0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     10.062737 #(0.000000 -0.053166 0.118817 -0.074368 0.188285 1.295311 0.521867 0.459224 1.246169 1.616232 -0.077420 0.347090 0.432939 1.661505 1.063938 1.416193 0.989215 1.425194 1.132974 0.603470 1.159207 0.101846 0.696956 0.427568 1.941017 0.267014 -0.129528 1.557595 1.817554 0.131593 0.956970 0.942471 1.261806 -0.086081 0.508562 -0.280398 -0.302917 1.163169 0.936668 1.359628 1.439682 0.115087 -0.097035 0.711525 1.672363 1.133281 0.328498 0.145548 0.965470 0.566986 0.834914 0.425989 1.113858 0.920544 0.820226 0.713008 1.573233 0.799527 0.810769 0.749089 1.124330 -0.116418 0.160945 1.454955 0.885413 0.605857 1.290508 1.462062 0.724327 1.041691 1.322778 0.230136 1.669614 -0.290838 1.200167 0.151272 0.788256 -0.180767 0.725771 0.595460 1.513509 1.100469 0.914540 1.420823 0.479684)

     10.039863832621 #(0.0 0.17040441176471 0.49966482352941 0.29846923529412 0.87530164705882 0.042905058823529 1.5354024705882 1.3893938823529 0.78678129411765 1.1305487058824 1.7796471176471 0.47034952941176 0.54722894117647 0.099286352941176 1.6870227647059 1.9478811764706 1.7379385882353 0.454465 0.15382141176471 1.8324908235294 0.58936623529412 1.7634206470588 0.37067805882353 0.36429247058823 1.8490578823529 0.47464229411765 0.25635270588235 0.10546011764706 0.73353952941176 1.0791899411765 1.9632213529412 0.53313576470588 0.74725917647059 1.3266225882353 0.243704 1.7402684117647 1.7709858235294 1.5194542352941 1.4731236470588 0.28874205882353 0.28936947058823 1.2263598823529 0.98748529411765 0.082040705882353 1.1957321176471 0.62857052941176 0.20243194117647 0.15145135294118 1.3138287647059 0.82268217647059 1.4765045882353 1.306259 0.19790141176471 1.8156928235294 1.9165752352941 1.9331166470588 0.99242605882353 0.75807747058824 0.63303188235294 0.74946429411765 1.2560457058824 0.39323811764706 0.65098752941176 0.46701594117647 1.6158483529412 1.9309827647059 0.51325417647059 0.74163858823529 0.203836 0.77028341176471 1.4339588235294 0.18967723529412 1.7488096470588 0.40058305882353 1.5350214705882 1.0576938823529 1.7219502941176 0.89513970588235 1.9988451176471 0.24684052941176 1.2115699411765 0.88165235294118 1.1694447647059 1.7399731764706 0.88864158823529)
     )

;;; 86 even --------------------------------------------------------------------------------
#(86 13.114136440046 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)
     12.791990425787 #(0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     10.041675 #(0.000000 0.112103 0.317771 0.005112 1.532171 0.585805 1.332101 0.950402 -0.087351 -0.289302 0.726863 1.385797 1.698763 0.465161 1.348953 0.617193 1.759126 1.514938 0.417638 0.774824 0.408721 0.357751 1.012052 1.023860 1.786553 -0.054863 0.490374 0.948081 -0.113774 1.782919 1.788938 1.199212 0.070892 1.574350 0.493308 0.457365 0.793946 0.575572 1.671337 1.489789 0.449252 0.994558 1.335453 1.034148 0.489141 1.174185 0.271978 0.357430 0.343206 1.776009 0.146154 0.657341 1.628403 0.669748 0.811691 0.659678 1.421771 1.161627 1.352316 0.311754 0.821306 0.614966 0.694564 0.801004 1.121973 0.742996 1.478235 1.010668 1.117066 0.257915 1.606296 1.407133 0.604530 1.093920 0.579647 1.300207 -0.057475 0.730878 0.342553 0.064756 0.251045 -0.077083 1.590027 0.661095 0.670198 0.180184)
     )

;;; 87 even --------------------------------------------------------------------------------
#(87 13.008953483644 #(0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.872 #(0 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 0)
     12.669403362513 #(0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1)
     12.625063286678 #(0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     10.238298 #(0.000000 0.066942 -0.182376 0.801189 -0.065905 1.144956 -0.015544 1.052298 0.046454 1.597587 1.124345 0.314926 0.370070 1.578570 0.577031 1.737011 1.039564 0.732365 0.937341 1.001514 1.023713 1.544246 1.462956 1.752787 1.437937 1.781610 0.724886 1.604814 0.678762 0.913243 -0.037269 0.761400 0.971517 0.812727 0.904312 0.055710 1.646198 1.063246 1.472306 0.870427 1.210941 0.557182 0.786091 1.658813 1.616213 0.368867 0.400205 0.711367 0.886148 1.363253 1.617439 0.062174 0.547700 0.449392 1.443803 0.890860 0.701005 0.898009 0.632901 -0.083828 1.171362 -0.061668 0.707514 1.723434 0.481165 0.665069 1.284858 1.307613 0.322040 1.553666 -0.439224 1.503196 1.055019 1.520815 1.293931 1.379175 1.095728 0.670095 0.182900 1.867188 0.986949 1.343003 0.159908 0.258942 0.938753 -0.037949 0.136886)

     10.234102522951 #(0.0 0.46066810344828 0.59636820689655 0.31043131034483 1.7056404137931 1.3864495172414 0.84579162068966 0.081764724137931 1.6647208275862 1.6143719310345 1.9104480344828 1.493158137931 1.8266782413793 1.6572503448276 0.94226544827586 0.60708755172414 0.54688665517241 0.62897175862069 1.273750862069 1.7247369655172 0.25346706896552 1.4803511724138 1.6112922758621 0.45922937931035 0.55380148275862 1.4239835862069 0.44982468965517 0.13354279310345 1.5300108965517 0.325118 1.6617651034483 1.1087092068966 1.7760013103448 0.1058914137931 0.39162051724138 0.29926462068966 0.23440872413793 0.23938482758621 1.0307949310345 0.78976303448276 1.614537137931 1.7313652413793 0.19486734482759 1.3333654482759 1.7838735517241 1.1203166551724 1.5737787586207 0.45135286206896 0.93294096551724 1.7607690689655 0.78820517241379 1.7522452758621 0.53909437931035 0.78292448275862 0.4145605862069 0.13581668965517 0.50573779310345 1.2755658965517 1.423248 1.1589791034483 0.59686620689655 0.27811431034483 0.9472774137931 0.65793451724138 1.7343876206897 0.86779372413793 1.7432998275862 0.28703593103448 1.9189620344828 1.298367137931 1.5854362413793 0.37519334482758 0.15400144827586 1.0814555517241 1.5422656551724 1.8411437586207 0.21847586206896 0.11396596551725 0.24772606896552 0.16233117241379 1.6226862758621 0.83817437931035 1.9992334827586 0.3597395862069 1.8361136896552 0.80162779310345 1.7065838965517)
     )

;;; 88 even --------------------------------------------------------------------------------
#(88 13.132745742798 #(0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.908752771202 #(0 0 0 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.675436588537 #(0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 0 1 0 1 0)
     12.661032846106 #(0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     10.260520 #(0.000000 -0.053123 0.920617 -0.224469 0.496556 -0.144355 0.523516 1.876669 0.064539 0.348442 0.300585 0.583962 1.309648 0.513627 1.159275 0.266455 0.749529 0.132874 0.595738 1.010777 1.427341 0.261497 1.513718 0.871339 0.134698 1.674836 1.297021 1.100144 0.248757 1.067638 -0.097675 -0.012605 0.973103 -0.025622 0.541251 0.712897 -0.091809 0.761495 1.272273 1.004809 1.116752 0.620629 1.872563 1.416984 0.071693 0.011202 1.307716 1.455638 1.203607 1.169211 0.326562 0.321695 0.718738 0.965485 0.381102 1.038516 1.652023 1.555393 0.024141 0.455197 -0.085925 1.771667 -0.086617 0.492325 -0.166478 1.233892 0.556320 1.402736 1.207374 0.524752 0.481225 0.808315 1.652309 0.759568 0.254846 0.717369 0.636846 0.903389 1.434193 0.216304 1.167401 0.772932 0.368764 0.276368 0.474540 0.508542 1.081153 1.677196)
     )

;;; 89 even --------------------------------------------------------------------------------
#(89 13.321250915527 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0)
     13.191189069613 #(0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1)
     12.707793861614 #(0 0 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1)
     12.335865540187 #(0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     10.282702 #(0.000000 -0.015223 0.818013 0.439800 1.393574 0.838609 1.686731 0.154344 0.362178 0.327140 1.360011 0.760386 1.663825 1.200773 1.522577 1.769636 1.474195 -0.050911 0.620337 0.233906 0.501610 0.226796 1.131160 0.409621 0.147625 0.420148 0.078800 0.414000 1.633681 -0.251312 1.642499 0.220051 0.276215 1.341864 0.918209 0.762504 0.686214 0.705498 1.371989 -0.025170 0.117608 0.712575 0.775450 0.154318 0.400036 1.699598 0.804739 0.607929 1.693296 0.888299 1.640273 1.176156 0.251534 0.437662 -0.202005 1.403495 -0.298369 0.214833 1.515344 1.393541 0.973731 1.000082 0.193994 1.064267 1.843642 1.857150 1.273960 1.206263 1.275356 1.415117 1.095208 0.046760 0.128804 1.034612 0.846241 -0.057303 0.755995 0.176369 0.460802 1.762666 0.419918 1.130565 1.081277 0.520296 0.645978 1.394072 1.686277 0.610781 1.405948)
     )

;;; 90 even --------------------------------------------------------------------------------
#(90 13.53812119512 #(0 1 1 1 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 0 1)
     13.016282120103 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0)
     12.781593429563 #(0 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 0 1 0)
     12.716424196959 #(0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

     10.423338 #(0.000000 -0.059593 0.047105 1.024694 0.973690 0.328775 0.131624 0.493450 0.366481 1.074242 0.521339 0.443944 0.863406 1.005750 0.625199 1.829814 0.302332 0.382353 1.550721 0.204190 0.315747 -0.093544 -0.034958 0.337432 -0.106699 0.704903 0.830886 1.252144 0.667439 1.501282 0.505628 -0.163559 -0.089048 1.709144 1.128089 1.214753 1.186714 0.715082 0.646252 0.256689 0.803150 0.528957 1.524062 0.940925 0.569767 0.037647 0.405332 1.212918 0.714806 0.682153 1.335388 1.071065 1.128278 -0.427767 1.102872 1.255250 0.978987 0.273511 0.128033 1.696380 0.612685 -0.029126 0.975986 -0.027789 1.881741 1.646397 -0.099850 0.278094 1.240329 0.221699 0.757000 -0.228110 1.297182 0.171916 0.768636 1.283307 1.741887 -1.603217 0.424262 1.051706 0.539647 1.501255 1.312252 -0.345041 0.215645 0.617058 0.225711 1.224397 1.784378 0.787966)
     )

;;; 91 even --------------------------------------------------------------------------------
#(91 13.63089466095 #(0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     13.263186228373 #(0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1)
     12.853587071592 #(0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

     10.365494 #(0.000000 -0.024940 0.757344 1.029438 0.235550 0.187465 1.283768 1.130030 0.108245 1.095932 -1.963996 0.217803 1.466600 1.557597 1.440386 0.203115 1.910649 1.395083 1.561350 -0.145060 0.821342 0.588193 1.237769 -0.129430 0.422311 0.451378 1.139437 1.817227 0.370254 -0.199828 0.094701 1.503705 -0.118368 0.310169 1.220417 0.147991 0.275655 1.126423 0.128225 0.711216 0.424041 0.910716 1.086919 0.973064 0.908243 1.489553 1.087049 0.980688 0.643564 1.140825 0.213225 1.022213 0.311881 -0.031007 0.694556 0.465727 1.931992 0.749568 0.822378 1.913371 1.316644 -0.106508 0.652921 0.640262 0.635226 1.867433 1.589699 0.560078 0.464987 0.575220 0.955501 0.351536 -0.203180 1.662350 1.908504 1.526407 0.853832 -0.207532 0.698241 0.409468 0.660616 0.243171 1.537715 1.612588 1.228118 0.266105 0.225329 0.514260 0.858161 0.678089 0.497157)
     )

;;; 92 even --------------------------------------------------------------------------------
#(92 13.355320111641 #(0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 0)
     12.754180011349 #(0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

     10.511820 #(0.000000 -0.105506 0.291495 1.852505 1.585054 0.811097 1.393110 1.723895 1.189683 0.686843 1.055781 0.822005 1.828075 0.830184 1.427743 0.448988 1.131443 1.094548 0.414856 -0.115631 1.738385 1.708345 0.190900 0.389683 1.349921 0.190257 0.667806 0.598121 0.628108 1.362797 0.439471 1.542675 0.072998 1.656392 1.723448 0.059500 0.134628 1.288274 0.800218 0.487443 0.065395 0.676806 1.844822 1.642819 0.319920 1.188294 -0.025549 0.726852 -0.051818 0.931928 0.516016 1.580203 0.502042 0.814580 1.661990 0.218665 0.448468 -0.289113 1.809635 -0.176204 0.905899 1.497113 0.182788 0.117034 0.198510 0.851627 1.112991 1.334223 1.261274 0.549689 1.460357 0.857568 0.946196 0.728539 0.552800 1.286292 1.179435 1.706620 1.925744 0.040745 1.291314 0.636392 -0.068970 1.392593 -0.083182 1.470525 1.158193 0.831414 0.098897 1.598731 1.751177 0.774915)
     )

;;; 93 even --------------------------------------------------------------------------------
#(93 13.783703804016 #(0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0)
     13.143995954461 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0)
     12.876626968384 #(0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.529277 #(0.000000 0.079888 0.038829 0.461615 -0.274820 0.070957 0.160659 -0.082677 1.416001 1.175881 1.899840 0.849458 0.407770 0.549649 0.948397 0.964194 0.601102 1.009821 0.527481 1.835378 0.706788 0.382708 0.661546 0.739028 0.024973 1.837450 1.706901 -0.167824 0.274897 1.765784 0.911444 0.008641 1.198741 0.817568 1.697767 0.437021 1.863020 -0.167666 0.003655 1.415745 1.401873 0.896569 0.964888 0.423985 0.902300 1.405262 0.278351 0.359753 1.132947 0.856288 0.356314 0.718786 1.068318 0.994356 1.146538 1.300839 0.977174 1.788013 1.856884 1.136712 0.993443 0.427029 0.124543 0.497798 1.165173 1.075495 -0.180446 1.337306 1.332654 0.872918 0.831869 -0.386750 1.880209 1.364438 0.393124 -0.000096 0.717590 1.217321 0.066484 1.752988 0.313665 1.044126 1.897967 0.989531 1.534166 0.547795 -0.008547 0.606672 -0.016756 1.707883 0.697910 1.132604 -0.003224)
     )

;;; 94 even --------------------------------------------------------------------------------
#(94 13.381710407562 #(0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0)
     12.991560374803 #(0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     10.607747 #(0.000000 0.008591 1.589841 1.631673 1.789168 -0.057956 0.483181 0.481567 -0.166781 1.730893 1.358812 0.247721 1.087730 1.656942 0.887071 0.942405 1.463482 1.706442 1.015786 1.186014 1.223496 0.419662 0.631367 0.448773 0.665721 0.157693 0.463672 1.206966 0.065798 0.193374 -0.155675 0.369782 1.912389 0.057557 1.227139 0.823080 0.463464 0.135407 1.840705 1.175335 0.587688 0.691658 1.027581 1.581719 1.791396 1.706039 1.379941 1.665721 1.268194 1.635092 -0.133950 0.839881 0.699475 1.512570 -0.061646 1.628646 -0.330928 1.498254 1.375388 0.166583 1.021378 0.315920 0.664898 0.226529 -0.184709 1.244786 1.618997 0.179743 1.495736 0.765057 -0.112194 1.503965 0.179533 0.611801 1.317852 0.599633 0.549589 1.452814 1.110927 1.609022 1.320044 0.080826 0.125538 1.065195 1.397524 1.007702 0.231943 1.621536 1.613157 0.348439 1.464791 0.702923 1.638451 0.763543)
     )

;;; 95 even --------------------------------------------------------------------------------
#(95 13.458537482645 #(0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0)
     12.939489078295 #(0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

     10.847318 #(0.000000 0.022934 0.194761 1.007235 0.795753 0.028009 0.891805 0.893636 0.066452 1.171378 1.064089 0.111174 0.447771 0.519913 0.917990 -0.009951 0.256680 1.605361 0.726895 0.990149 0.505450 1.021562 0.596241 0.372539 1.002967 0.765761 0.783400 0.983929 0.315576 1.849736 -0.009997 1.051060 0.489022 1.505765 1.044999 -0.107356 1.415763 0.677376 1.616051 0.492162 0.048535 1.854612 1.324572 1.860586 1.020481 1.490086 1.252603 1.224883 0.176278 1.655385 0.991140 1.147909 1.059962 -0.013897 0.150075 0.037194 0.392264 0.260084 1.601950 0.193959 1.089935 1.032085 1.215828 0.172969 1.673577 1.515390 1.886335 0.193175 0.980039 1.213316 0.840179 0.741572 0.563684 0.995658 1.498504 1.194993 0.562819 1.227914 1.626576 1.375742 0.083680 1.092438 0.905851 0.373342 0.700268 1.646335 0.178545 1.502069 0.062655 0.496035 0.709649 1.166216 0.948421 0.690988 -0.101676)
     )

;;; 96 even --------------------------------------------------------------------------------
#(96 13.465419214875 #(0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.179516746745 #(0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0)
     13.077001047978 #(0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     10.859221 #(0.000000 0.077075 1.457810 0.998504 1.137598 0.850695 0.609868 0.132924 1.214266 0.833163 -0.026278 1.490368 -0.138672 0.125729 1.908105 1.296552 1.492731 0.898669 0.028695 0.726757 1.106642 0.284706 1.936842 0.959581 0.775655 0.444202 1.676912 1.324468 0.787044 1.726548 1.732904 1.351417 1.456199 1.156241 0.573441 1.686335 0.079921 0.674194 0.818204 1.387839 1.425536 0.489745 0.455310 0.750414 0.825754 0.770452 1.389666 0.122461 0.514628 1.050001 0.044144 0.556848 -0.104515 -0.121364 1.845794 0.713276 0.054248 1.039267 0.046404 1.491341 0.872275 1.693055 1.714100 1.832799 0.595452 1.461834 0.086311 0.584001 1.441370 0.733231 1.175457 0.801035 0.724121 0.947545 -0.102397 1.476238 1.583419 1.348130 1.482810 -0.116029 1.161739 0.517565 1.208232 1.106932 1.713531 1.346760 1.608434 -0.120111 1.560003 -0.029556 1.299506 0.696034 1.043234 -0.132096 0.112910 1.807923)
     )

;;; 97 even --------------------------------------------------------------------------------
#(97 13.449318349909 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)
     12.969611395004 #(0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

     10.836009 #(0.000000 0.186663 1.700559 0.225489 0.103192 0.071564 1.658519 1.508813 1.483675 1.752977 0.771156 0.821723 1.766095 0.146674 -0.226100 -0.114952 -0.102092 -0.095609 0.590855 1.580834 1.533895 1.676310 1.026189 0.910449 0.487318 -0.005305 1.519780 -0.441944 0.625523 0.787920 1.053317 0.425901 0.497517 0.014618 0.930086 1.686064 1.208237 1.282648 0.374509 0.525538 -0.582836 0.612647 0.704858 1.767220 1.518827 0.386233 1.130313 0.807837 1.100980 -0.059182 1.633854 1.350309 0.726071 1.404868 -0.473619 1.376823 -0.363009 0.929431 1.907634 1.513327 0.051334 0.457166 0.974331 0.154462 0.241046 0.730075 1.798518 0.727833 1.109885 -0.117398 1.142323 0.016882 1.528578 1.287680 0.927573 1.826069 1.320385 1.024143 1.268864 0.815613 -0.123862 0.210593 0.815815 0.688005 1.572993 1.289181 0.304408 1.395008 0.035903 -0.202892 0.150563 0.350275 0.896221 0.007265 1.202328 0.992902 1.569224)
     )

;;; 98 even --------------------------------------------------------------------------------
#(98 13.942760654268 #(0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1)
     13.490633234777 #(0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 1 1)
     13.468658765207 #(0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

     10.920455 #(0.000000 0.047069 1.576452 0.876088 1.802543 1.488284 1.537079 1.573830 0.878790 0.827047 1.079947 0.380723 1.881821 1.286863 0.703713 0.090934 1.410981 1.894906 -0.179537 -0.023507 0.173893 0.348133 0.853647 1.610249 0.237956 1.574665 0.794465 1.227033 1.110419 1.531959 0.851186 1.035726 0.186554 1.135193 0.609395 0.449357 1.392724 1.734026 1.524181 1.423232 1.530592 0.770312 1.498666 0.035577 1.532561 1.447896 0.563114 -0.103741 1.889740 -0.016059 0.809530 0.280671 -0.327710 0.174960 1.870343 1.120078 1.668515 1.086141 0.566562 -1.845809 1.762873 1.820194 -0.089310 1.454483 0.735031 1.481885 1.116715 1.237835 1.947315 1.820509 0.420046 0.725654 0.823513 1.304758 0.551320 0.917675 1.382577 0.176323 1.215243 1.114225 0.468486 0.223439 1.043977 1.446513 0.303853 0.944326 0.214337 0.498908 0.212480 0.512750 0.615222 1.572368 0.887690 1.247430 0.787888 1.760047 0.595127 1.070264)

     10.878712658801 #(0.0 0.29799107142857 0.15075314285714 1.8316642142857 1.2992172857143 0.83878135714286 1.1575654285714 1.6410475 1.1108065714286 1.4882876428571 1.9645257142857 1.8419377857143 1.4267938571429 1.1903289285714 0.892029 0.55018807142857 0.24182314285714 0.84408221428571 1.2567882857143 1.4708583571429 1.9430404285714 0.5291855 1.3100725714286 0.52581564285714 1.2770887142857 0.93139278571429 0.36682385714286 1.2669489285714 1.592191 0.10146407142857 1.7180541428571 0.13473721428571 1.7302612857143 1.1882303571429 0.63894642857143 0.9043155 0.20693057142857 1.1834756428571 0.73316971428572 0.78207278571428 1.3691268571429 1.1447119285714 0.273908 0.91427207142857 0.54487314285714 0.79031121428571 0.54625428571429 1.8676563571429 0.29857642857143 0.7065845 1.8505105714286 1.6547136428571 1.0444477142857 1.8508227857143 1.7359578571429 1.4117599285714 0.508305 0.09737107142857 1.9822891428571 1.6436772142857 1.5410392857143 0.12355135714286 0.36574242857143 0.2644925 1.9126295714286 0.78035464285714 0.72923671428571 1.3353577857143 0.24285085714286 0.49302592857143 1.346194 1.7332190714286 0.25854614285714 1.0735422142857 0.56038728571428 1.1915633571429 0.13914442857143 1.1527655 0.57921757142857 0.81213864285714 0.44021271428571 0.53174478571429 1.2573078571429 0.24125192857143 1.412692 0.33978107142858 1.8216151428571 0.59651421428571 0.48841228571429 0.95502535714286 1.3663184285714 0.9381605 0.071144571428572 1.0245826428571 0.78697771428571 0.31502678571429 1.2656428571429 0.099928928571426)
     )

;;; 99 even --------------------------------------------------------------------------------
#(99 14.049349722487 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.942 #(0 1 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1)
     13.341398779709 #(0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

     10.935272 #(0.000000 -0.058056 -0.064525 0.720038 1.162189 -0.133475 1.672199 0.428406 0.679800 0.029717 0.592079 1.498265 0.113477 0.918147 0.555757 0.199928 1.773096 0.955248 0.645137 0.322272 1.589119 1.804055 0.188603 1.772538 1.261795 1.266287 1.275653 -0.019112 0.380657 1.179342 1.638873 -0.138611 0.205014 1.359633 1.646116 1.230614 0.847759 0.982841 1.503112 0.804577 0.629158 0.965822 -0.280134 1.766593 1.793859 -0.004894 0.622628 0.439199 0.606680 0.055302 0.182137 1.276570 1.972833 0.493276 0.174908 0.430413 0.484641 1.872625 1.301314 1.314572 0.039656 0.310656 0.045974 0.476798 0.586820 0.963277 0.059920 0.639178 1.129383 0.783886 1.258531 0.697627 1.726337 0.249306 1.711661 0.704658 0.165383 1.419227 0.291127 1.476152 0.283197 -0.032688 1.534693 1.197155 0.443916 1.523789 0.498040 0.211672 1.302069 0.633387 0.501526 0.836235 0.316967 1.689521 0.102971 1.394532 -0.037136 -0.014200 1.413808)
     10.800392237871 #(0.0 0.74692234848485 1.3453846969697 0.92074804545455 0.13019539393939 1.5867667424242 0.13792109090909 1.5736114393939 0.45441678787879 0.88932613636364 0.17498348484849 1.9127808333333 1.3194701818182 0.74233253030303 0.99528587878788 1.5462252272727 1.5181875757576 1.6420609242424 0.37127327272727 0.076130621212119 0.57284596969697 1.3277543181818 0.49769266666667 1.0616920151515 1.1200573636364 1.9634387121212 0.66372206060606 0.18222440909091 1.3216787575758 0.8616881060606 0.054347454545454 1.0141468030303 0.15859715151515 1.9158595 1.0685628484848 1.2769231969697 1.7982405454545 0.75676289393939 1.8467632424242 1.9673615909091 0.32184493939394 1.4081812878788 0.97655163636364 1.9904809848485 0.59098333333333 1.3735726818182 1.115679030303 1.6883943787879 0.46728072727273 0.80797407575758 1.3354244242424 1.6077477727273 0.79543312121212 0.18665546969697 0.34576881818182 1.5676491666667 0.35960651515152 0.51022186363636 0.60188621212121 1.3963275606061 0.85495790909091 1.8364722575758 0.11083460606061 1.6765439545455 0.28077130303031 1.3607856515152 1.308419 0.64302234848485 0.0019716969696972 0.37470404545455 1.5159343939394 1.7069537424242 1.4157910909091 0.84793243939394 1.1342467878788 0.74115713636363 0.84603048484848 1.0627848333333 0.45419418181819 0.46933453030303 0.066800878787888 0.64024422727273 0.79669457575758 1.2193219242424 1.2424532727273 0.90787862121212 1.098807969697 1.0204533181818 1.2091836666667 1.1015440151515 1.4835993636364 0.53172071212121 1.0190740606061 1.2622364090909 0.46784575757576 0.11028810606061 1.6134424545455 0.6156698030303 0.39357415151515)
     )

;;; 100 even --------------------------------------------------------------------------------
#(100 14.500160217285 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1)
      13.694382146343 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)
      13.512077331543 #(0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.842341 #(0.000000 0.012729 0.570094 1.143946 0.074605 1.594604 0.226219 1.085061 1.508235 1.590062 1.068353 0.657540 0.747908 -0.136965 0.344496 0.694573 1.528503 -0.392214 -0.015879 1.667115 1.637305 1.079343 0.146474 0.407268 1.598985 0.380913 1.557238 -0.080428 1.551447 1.483941 0.889089 1.314542 1.645670 1.195541 0.509216 1.224304 0.549149 0.638802 0.512324 1.251109 0.219441 -0.014327 -0.217927 0.636275 0.553988 1.492813 -0.193474 1.765689 1.744997 0.424458 0.463659 0.154225 1.488015 0.893653 1.157346 -0.006027 0.157262 -0.002646 1.848990 0.146079 -0.084614 0.179014 0.338883 1.155261 0.939177 0.152328 1.538717 0.145386 0.157805 0.652923 -0.237112 0.652293 0.299731 1.762892 0.565166 1.374159 0.911676 0.931841 1.755524 0.695283 0.994979 1.646116 -0.368382 1.586175 1.147376 0.500149 0.106220 1.501742 1.918139 0.181499 1.792966 0.967497 1.755110 0.999093 0.626002 1.423554 0.735817 1.214337 1.566218 1.237756)
      )

;;; 101 even --------------------------------------------------------------------------------
#(101 14.704120635986 #(0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1)
      14.20509180893 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)
      13.916260357992 #(0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

      11.042735 #(0.000000 -0.041712 1.948309 1.214552 1.831514 1.346508 1.125286 0.326100 1.322958 0.054286 1.349670 0.047114 0.280178 1.597320 -0.290691 1.015583 0.365765 1.669536 0.529818 0.664978 0.710867 0.613281 0.927859 1.407834 -0.154368 1.338459 0.021342 1.814976 0.132083 0.459280 -0.217461 1.619858 1.417143 1.643363 0.994693 -0.051656 1.466180 0.753830 1.007570 0.467105 1.288053 1.252295 0.715885 1.522690 1.849186 -0.017253 1.828852 0.077223 0.248587 1.464700 0.010380 0.550487 1.760970 1.452763 0.070666 0.453915 0.791740 1.867229 0.184981 0.098040 1.871225 1.088405 0.583865 0.133910 1.077293 1.236530 0.563602 0.762048 -0.019214 0.063343 0.023118 1.484355 1.311581 0.006514 1.398763 0.313688 0.811180 1.666691 1.559063 0.424567 1.060105 0.754099 1.517534 0.157053 1.696772 1.404867 1.214701 0.930743 1.417808 1.569803 1.020607 0.222722 0.910574 0.855327 1.278708 1.445048 0.972102 0.009456 0.790828 0.659313 1.566582)
      )

;;; 102 even --------------------------------------------------------------------------------
#(102 14.246722674125 #(0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1)
      13.955191612177 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1)
      13.554303556646 #(0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

      11.024877 #(0.000000 0.048494 1.403994 0.189049 0.045903 1.661687 1.482846 1.260755 0.257983 0.274710 0.210422 -0.280162 0.514494 1.556566 0.888331 0.856392 0.057507 1.740334 0.091397 1.424838 -0.418235 0.786688 1.577866 0.901401 0.535098 0.204435 1.676175 0.694328 1.457988 0.649948 0.113547 0.992263 1.329441 0.512623 0.813759 0.949639 0.539691 1.505519 1.289237 -0.113537 0.062406 0.090990 1.977055 0.453144 -0.026137 1.416119 1.122032 1.723400 0.299697 0.339870 -0.304247 0.441737 0.515457 0.791655 1.653413 1.877889 1.214761 1.233278 0.336295 -0.422534 1.542911 1.078370 0.162104 1.206449 1.773875 0.691961 1.695774 1.103363 0.717278 0.061987 0.706267 1.739881 1.798867 1.569748 1.433384 1.705741 1.209359 1.451532 0.491041 0.830191 1.224367 0.721560 1.099436 1.205677 1.022561 1.659873 0.983870 1.294312 1.007917 -0.022422 1.427133 0.110725 0.041515 0.429195 1.111661 1.343976 1.674030 1.753673 0.427230 0.822146 1.601642 -0.174437)
      )

;;; 103 even --------------------------------------------------------------------------------
#(103 14.267168699654 #(0 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      14.260 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 1 1 0 1 0)
      13.923377530893 #(0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

      11.361804 #(0.000000 0.012900 0.149112 0.580163 0.388185 0.737705 0.891940 0.030448 0.094621 0.222515 1.702261 1.549121 1.354059 0.574681 0.526041 0.749587 0.448856 1.668506 0.292586 0.509824 -0.462477 0.456429 1.446079 1.384067 0.486428 1.634295 1.567034 0.644925 0.225833 0.355474 1.712127 1.659107 0.589959 1.495951 1.238576 0.877099 -0.124515 0.001316 1.754342 0.552641 -0.127346 0.963601 0.671625 0.300078 0.532847 0.336947 0.451727 1.037892 1.831422 0.399204 -0.221917 0.661207 0.113435 1.690191 0.151019 0.672075 1.209504 1.631280 1.607400 0.989043 1.015167 0.566364 0.263106 -0.125432 1.472797 0.681898 -0.190956 0.861075 1.802553 0.124093 0.018827 0.282757 0.429782 0.805599 0.254524 0.271832 0.721652 1.745383 0.508043 0.236386 1.090605 1.777114 0.759912 -0.106845 0.910250 1.120643 0.643737 1.569578 1.545998 -0.343253 0.182117 0.828483 -0.087223 0.278642 1.086767 1.133859 1.174332 0.252639 1.115972 1.084180 0.967486 0.825005 1.728775)

      11.247144958527 #(0.0 1.2578883495146 0.62877169902913 0.24980204854369 1.3742923980583 1.0905817475728 0.47523709708738 0.60753644660194 0.025893796116506 1.4057471456311 0.25196649514563 1.2222768446602 0.38926719417476 1.0902995436893 0.32255489320388 1.6538512427184 0.54996059223301 0.99653294174757 1.0357282912621 0.3510136407767 0.66106299029126 1.1458793398058 1.0379666893204 0.43294903883495 0.75064838834952 1.2818377378641 0.54467908737864 0.8405194368932 1.4381297864078 1.0246481359223 1.2140374854369 0.70689883495146 0.75692218446602 0.98217153398058 1.8906648834951 0.85554523300971 1.0645645825243 0.54681193203884 1.6988092815534 1.697727631068 0.24491298058253 0.82384033009708 1.4184646796116 0.33183502912622 1.9594043786408 1.0214267281553 0.40033507766991 0.20303142718446 0.19120677669903 0.13654012621359 0.88302947572815 0.71886482524272 1.6779711747573 0.34542552427185 0.022309873786412 0.05584822330097 1.3950975728155 1.5544889223301 0.55544827184467 1.2471166213592 0.48844797087378 1.4516543203884 0.34226666990291 1.3419500194175 0.19678636893204 0.4284787184466 0.75224206796117 1.3841074174757 1.4115917669903 1.0199841165049 0.18413046601941 1.522801815534 0.91152516504854 0.6680405145631 1.4901968640777 0.48147321359224 0.3424935631068 0.80526891262136 0.75699526213592 1.4930786116505 1.888185961165 1.9606983106796 1.8484736601942 0.047646009708728 0.6225673592233 0.23198970873787 0.84542305825244 1.117108407767 0.29267275728155 1.6561501067961 1.4627394563107 1.3299398058252 1.3430191553398 1.2152155048544 1.2362118543689 0.54941020388348 1.9442165533981 0.37037990291262 0.36524325242718 1.7988146019417 0.74072195145629 1.8866553009709 0.16336065048544)
      )

;;; 104 even --------------------------------------------------------------------------------
#(104 14.290776635081 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)
      14.080453047533 #(0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

      11.414434 #(0.000000 0.026783 0.554871 0.694362 0.631118 0.139017 -0.030109 0.875949 1.442909 0.350004 0.915476 0.250663 0.759652 0.238278 0.140281 0.259804 1.794832 1.813032 1.076407 1.676140 1.930398 -0.193182 1.753611 0.727026 1.637880 1.331007 -0.115065 0.619492 1.193303 1.343360 1.540138 0.309420 0.727482 1.148883 0.879680 0.607466 0.223909 -0.282260 1.213178 1.044913 1.175194 0.242832 -0.272989 0.561895 0.840116 1.290391 0.829322 1.922689 1.264085 0.109576 1.542933 1.304995 1.397476 1.648033 1.160630 -0.025561 0.998231 1.512523 0.355440 0.881235 0.009456 1.657043 0.549110 1.269617 1.572247 1.398086 1.008398 1.733226 0.830436 0.013389 1.485520 0.936378 1.550445 -0.074007 1.460307 0.528006 0.036071 -0.049588 0.736162 0.063031 1.491402 0.692650 -0.177557 0.006671 0.181392 0.804548 0.572498 0.682893 0.721213 1.340507 1.532374 1.312598 1.304434 0.421951 1.592339 0.986297 1.206479 0.215756 0.134334 0.825164 0.212132 0.557322 1.290703 1.440032)

      11.350146934479 #(0.0 0.87868088942308 0.51837877884615 1.4107626682692 0.11562455769231 0.68227744711538 1.2010153365385 0.92480722596154 0.55418311538461 0.26180500480769 1.6499778942308 1.9606597836538 1.1632826730769 1.6635815625 0.45024945192308 1.4264753413462 1.9453532307692 0.61178112019231 0.88549100961539 0.43303189903846 1.6476017884615 0.37480467788462 0.98940156730769 0.87780845673077 0.65308734615384 1.2103962355769 0.635461125 0.20484301442308 1.7265039038462 0.66320179326923 1.5981836826923 1.4017965721154 0.61638046153846 1.9522823509615 0.91210924038462 1.1572991298077 1.8859100192308 0.30116990865385 0.60434279807692 1.2580166875 0.42023257692308 0.35073646634616 0.52106635576923 0.27620324519231 1.5614341346154 0.79040502403846 1.0430559134615 1.3233898028846 1.2235836923077 1.2857595817308 1.5025714711538 0.22706936057693 1.02109225 0.064622139423079 0.67789102884615 0.44037991826923 0.14616080769231 1.3001536971154 1.4809485865385 0.97508047596154 0.95250036538462 1.0953022548077 1.0411261442308 0.51426303365385 1.8238749230769 0.4943578125 1.0451807019231 0.79889659134615 0.73395548076923 0.60658537019231 1.0454162596154 1.2511611490385 0.75618903846154 0.13430792788462 0.56381581730769 0.48309270673077 0.88399659615385 1.5222254855769 1.232676375 1.6337512644231 1.9688281538461 0.012987043269234 1.7964169326923 0.97276182211538 0.00085071153846172 1.5817786009615 0.22398749038462 1.1937883798077 0.042066269230773 1.5540851586538 0.50437204807692 1.2025889375 0.37441682692308 0.15979671634615 0.39800260576923 0.36091249519231 1.6436013846154 1.4454552740385 0.38911216346154 0.06789905288462 0.1242009423077 0.92256483173077 0.83415972115385 1.7859056105769)
      )

;;; 105 even --------------------------------------------------------------------------------
#(105 14.699862480164 #(0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0)
      14.062 #(0 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)
      14.023490699521 #(0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

      11.153638 #(0.000000 -0.117930 1.405699 1.751923 1.025040 1.507166 1.082418 0.335450 1.302420 1.595136 0.670865 1.371317 -0.085117 0.905144 1.144586 0.994916 0.035644 0.796264 0.414731 0.201139 0.938555 1.619766 0.637605 1.589805 0.817279 0.237060 0.398102 1.765661 -0.229953 0.796519 0.348796 0.574186 0.039323 1.805857 0.206302 0.756674 0.392800 -0.092506 1.607550 1.493728 0.512815 1.140449 1.857498 0.769528 -0.004495 -0.128819 0.744468 0.009671 0.520963 1.533900 -0.054983 1.663945 0.743651 0.613762 1.048793 0.308676 0.400140 0.530170 1.511269 1.601915 1.535277 0.102412 1.009888 0.417007 1.920236 0.443633 -0.017981 1.806167 1.253307 0.028122 0.091363 0.194659 1.426449 1.266835 0.759119 1.093388 1.376369 0.931770 1.023178 1.601059 1.726093 0.431322 0.307920 1.155578 0.088880 0.285189 1.455533 1.817223 -0.432521 0.341547 1.558886 1.626227 -0.298746 -0.096352 1.941622 0.093486 0.533030 0.741522 0.784065 0.039008 1.351971 0.328080 0.270455 1.309863 0.667936)
      )

;;; 106 even --------------------------------------------------------------------------------
#(106 14.783208847046 #(0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.160224278203 #(0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 1)
      14.077123010357 #(0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

      11.209829 #(0.000000 -0.077371 0.691064 0.288215 1.240226 1.374077 -0.256112 0.313730 0.650999 0.299904 0.931248 -0.178710 -0.077488 1.319886 1.701320 1.115420 1.507715 -0.001271 0.934387 -0.010077 1.920016 1.515019 0.900707 0.366170 1.437594 0.167407 -0.044979 0.212151 0.413526 1.164026 1.190817 1.117866 1.278762 0.980742 1.853021 1.296176 1.589775 0.414719 1.499473 1.879927 1.403026 0.005157 1.526101 1.337108 0.942514 0.608791 0.418325 1.088642 0.570546 0.731193 1.459300 0.579173 1.331547 1.226716 0.268619 0.099347 0.585919 0.680434 0.841642 0.713759 -0.054472 1.450644 1.339594 0.396965 0.375586 1.662673 1.646305 1.788859 1.546925 0.234353 0.247798 1.218464 1.532274 1.277222 0.831140 1.166112 0.159026 -0.233072 0.145567 0.205774 0.837907 -0.025631 0.590665 0.491928 0.075640 1.662042 0.408504 0.208092 0.451837 -0.259377 0.738889 0.190384 0.979129 1.072633 1.985405 0.682348 0.653082 0.961997 -0.041791 0.634546 0.033840 1.712533 0.277745 0.623680 1.913054 1.395442)
      )

;;; 107 even --------------------------------------------------------------------------------
#(107 14.355038210217 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 1)
      13.979104817741 #(0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      11.380216 #(0.000000 -0.026061 0.091072 0.276295 1.420434 1.066137 0.819438 0.084077 0.614336 0.814829 1.064954 1.425748 0.999836 1.290655 0.093110 0.199003 -0.266462 1.303007 0.879829 0.520708 0.031095 0.313260 0.599296 1.527843 1.915620 0.773106 0.246851 0.507544 0.197202 1.386573 1.063599 0.199302 0.396500 1.231461 0.050816 1.051231 0.493090 0.153946 0.916281 -0.188910 0.068996 1.315143 0.775042 1.577419 0.871625 1.348617 -0.022422 1.128444 0.309180 1.499753 0.273074 1.452665 0.789304 0.753274 0.718449 0.639399 0.621083 1.085411 1.646010 0.653336 1.328479 0.341842 0.923365 1.148914 1.494159 1.214641 0.201218 1.404642 0.875117 0.268957 0.549414 0.039274 1.817413 0.004057 -0.337186 0.368444 0.126589 -0.364528 1.248374 0.010829 0.098263 1.712187 1.374366 0.804474 1.238342 0.922587 -0.230805 -0.057556 -0.116936 0.164212 0.406590 1.860535 0.268337 1.047364 0.618715 1.402549 1.911315 0.363476 0.454359 1.579912 -0.098743 0.276363 1.549830 1.571044 1.283274 -0.182229 1.288886)
      )

;;; 108 even --------------------------------------------------------------------------------
#(108 14.418597227362 #(0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0)
      14.367991447449 #(0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1)
      14.247987286758 #(0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1)
      14.201394892821 #(0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      11.460894 #(0.000000 0.038161 1.198130 0.608491 1.814016 1.787498 0.403159 0.086593 0.662660 1.605315 0.696542 0.569464 0.173808 0.493614 1.294885 1.331433 0.630489 1.103261 0.099590 0.240497 0.991334 -0.088838 1.718425 1.159330 0.308769 0.003346 1.584343 1.316384 1.710332 0.553343 0.132742 0.490728 1.925848 1.553655 0.168406 1.425197 1.066180 -0.100206 0.885391 0.072116 0.791840 1.316580 0.239058 -0.044177 0.249298 1.522455 1.572966 1.789817 0.276541 0.221416 1.008965 0.716337 1.063386 1.294883 1.658341 1.090302 0.578843 0.829731 1.333770 0.931386 1.389008 0.116268 1.190646 1.448012 0.209410 1.824291 1.350253 1.552236 1.288064 1.492421 1.285274 0.502352 1.314918 1.095651 1.340779 0.568621 1.414768 0.029722 -0.024608 0.760345 0.441508 0.028560 1.863392 0.151069 1.146183 0.825666 0.579746 -0.008478 1.410421 1.696209 0.024222 1.811706 1.593352 1.480985 0.097000 0.449722 0.997189 -0.233247 1.736991 1.413023 1.713123 1.508852 0.757830 0.047894 1.153695 0.363220 0.777378 1.630901)
      )

;;; 109 even --------------------------------------------------------------------------------
#(109 14.988188773557 #(0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 0)
      14.476561866583 #(0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

      11.467916 #(0.000000 0.028435 1.316280 0.464901 1.738668 1.251636 0.996354 1.453781 1.647812 0.395369 1.520654 1.075348 0.185792 0.461252 0.041724 0.400535 0.200380 0.606710 0.653705 0.916322 -0.291031 1.349232 1.528404 0.624830 0.061641 0.725027 0.923812 -0.092744 -0.207003 0.693782 0.321281 0.867138 1.245053 0.852884 1.116199 1.433340 1.021546 1.775296 -0.122409 0.552154 0.663988 0.809101 1.728008 0.531688 0.875414 1.659433 0.832846 1.702139 0.096207 0.738220 -0.038013 0.379193 0.387371 1.369462 1.089522 0.277560 1.690834 0.058083 1.682209 1.007174 1.359229 0.972462 0.577936 0.724200 1.184498 1.162717 0.954630 0.143106 0.590829 0.230342 0.997915 0.029739 1.647859 1.406874 0.007629 0.134249 0.670470 1.276427 0.422626 -0.109003 0.552029 0.954315 0.974999 0.272186 0.562468 1.254746 1.452860 0.533064 1.423789 1.732492 1.001736 0.179992 1.773052 1.685789 1.573925 1.238652 -0.184991 1.479490 -0.244242 1.173447 0.349786 0.704014 -0.131749 1.793798 1.454553 1.420870 0.975165 1.360375 0.813767)
      )

;;; 110 even --------------------------------------------------------------------------------
#(110 14.433 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.401108392424 #(0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0)
      14.141825477743 #(0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      11.577186 #(0.000000 -0.054653 0.316260 0.456447 0.183358 1.065777 0.062436 1.275701 -0.022138 -0.057584 1.600070 1.161301 -0.023941 1.436743 1.791838 1.780291 1.734460 -0.131029 1.021282 0.274739 0.248227 1.178256 1.393758 1.298610 1.277751 -0.268273 1.683493 1.613744 0.488715 1.023033 0.990127 1.443459 1.158226 1.824315 -0.194491 1.777691 1.323915 0.755342 0.286188 0.248852 1.619499 -0.119008 1.351812 0.400940 1.394734 1.606231 1.501558 1.588401 0.924841 0.003067 0.961605 0.517952 1.170232 0.111852 1.484099 1.063792 0.948719 0.526039 1.279252 1.745211 0.049730 0.107751 1.749800 1.425277 -0.007140 0.379332 0.868795 1.604866 0.250481 1.906247 0.968687 1.170170 0.403458 0.777490 0.997415 0.071721 1.734287 -0.148744 0.306546 0.715563 1.270343 0.749765 0.473788 0.705326 0.766873 0.639656 0.855652 -0.044790 1.593559 0.304079 0.963098 1.289962 1.877130 1.137181 0.963723 1.388990 0.734085 1.245352 0.194874 0.466764 1.235919 0.109326 1.355133 0.282922 0.056025 1.543595 0.867429 0.008408 0.111948 1.344603)
      )

;;; 111 even --------------------------------------------------------------------------------
#(111 14.983455708572 #(0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.470418444168 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 1)
      14.043108609984 #(0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

      11.690323 #(0.000000 0.066992 1.269991 -0.109380 0.639989 0.032390 0.133598 1.358484 1.453167 0.669595 1.490341 0.256207 1.616721 -0.053035 1.492048 0.339914 0.763430 1.284251 0.988356 1.306142 0.076079 0.855833 1.030470 0.939398 0.499765 0.411455 0.954797 0.949378 1.247536 1.003664 1.088218 0.162393 0.630710 0.861912 0.294064 1.775962 0.040746 0.950723 0.468476 0.919251 0.039424 1.829466 0.167754 1.193155 0.445401 0.468676 1.307373 1.569541 0.822386 1.716083 0.248845 0.589507 0.734291 0.163573 -0.044734 0.537567 0.978009 1.467594 1.750481 1.019360 1.106405 0.761352 1.296389 1.237688 0.898064 1.116619 0.816006 1.793590 1.450096 0.222336 0.438396 1.657694 -0.160494 1.915209 1.215272 1.300799 0.565944 0.967193 0.353347 1.365447 1.008586 1.490542 1.274959 1.316257 0.045367 0.256887 1.817298 0.577671 1.318027 0.868794 -0.129830 1.223081 0.075836 1.856150 0.507124 -0.225295 1.533139 0.022511 0.034950 1.278562 0.488745 0.731925 0.540876 1.282008 0.353168 1.720509 1.086288 0.818389 1.929584 1.286380 0.562448)
      )

;;; 112 even --------------------------------------------------------------------------------
#(112 14.939 #(0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0)
      14.53456401825 #(0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

      11.535874 #(0.000000 -0.020384 1.360442 0.930512 -0.161552 1.884305 0.125201 1.748379 1.495279 0.276543 1.573130 -0.242674 1.253331 0.101132 1.228332 1.249920 0.075904 1.268788 0.504891 0.479139 0.069736 0.406035 0.608360 1.034616 1.408045 0.048239 0.045543 1.004035 0.091993 0.811398 1.253133 -0.258796 0.862426 1.545033 0.794306 1.363296 1.426796 1.366003 0.947699 0.498413 1.207339 -0.242775 0.481852 0.935817 1.318911 1.364272 1.431351 0.026323 0.500142 -0.200533 1.222274 1.078667 1.261486 1.408869 0.951479 0.185798 0.496304 1.674433 -0.065134 1.510996 1.116365 1.313360 0.694084 0.943307 0.919189 0.723541 0.241037 1.347009 0.896534 0.983343 1.520063 1.489718 -0.004873 0.729574 0.850303 1.551866 0.695307 1.891942 0.080157 -0.112694 0.307677 1.935671 0.164295 0.597946 0.121193 0.240557 1.601706 1.112934 0.926687 1.611113 1.872625 1.860484 1.214317 1.637980 0.643535 0.451202 1.701134 0.354032 1.529426 1.543344 0.921420 0.300821 1.305205 -0.324826 1.507564 0.665946 0.271480 1.358090 0.224564 0.258808 0.612930 0.152705)
      )

;;; 113 even --------------------------------------------------------------------------------
#(113 15.33184168793 #(0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.840950350147 #(0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 0 1)
      14.699631659332 #(0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      11.648573 #(0.000000 -0.002033 -0.154959 1.355967 1.024392 0.482808 1.092636 0.803276 0.820847 1.095507 0.332093 -0.179983 0.994953 0.314033 1.420121 1.116176 0.757784 1.143495 0.914595 0.387007 -0.039189 1.799261 0.253893 0.515814 0.605265 0.756503 0.642255 1.382960 0.314211 0.282691 0.671435 1.806527 1.847358 0.718014 0.308353 0.267690 0.335009 0.727119 0.223738 1.693179 1.481557 1.534577 -0.054200 0.560981 1.502498 1.682553 1.934327 0.344884 0.377161 0.447090 0.455196 0.832649 1.956822 -0.007903 -0.192979 0.495982 0.772162 1.598230 -0.194143 0.622837 0.906504 0.889875 -0.271752 0.351965 1.001001 0.676561 0.734461 0.699796 0.355018 0.027377 1.593485 1.494849 1.222396 0.003126 1.764387 0.338547 1.095191 -0.147266 0.227079 1.209578 1.755083 0.603384 1.216716 0.470778 1.368989 1.203223 1.493291 1.029783 0.518545 0.500007 -0.008094 1.320521 0.189148 0.865059 1.741425 1.005397 0.255832 0.277373 1.050305 0.579333 0.773903 1.759490 0.654701 -0.060509 0.902455 1.423720 1.315425 1.111667 1.399844 1.351199 0.100495 1.376697 0.582675)
      )

;;; 114 even --------------------------------------------------------------------------------
#(114 14.84645338611 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.794 #(0 1 0 1 0 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1)
      14.492 #(0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

      11.903493 #(0.000000 0.030871 0.888039 0.959311 0.070171 0.436603 0.757816 1.217508 1.619759 -0.129337 0.330925 1.334481 1.277796 0.176499 0.416610 0.405059 0.347102 1.797714 1.109814 1.786828 1.298739 0.024165 1.875529 0.396367 0.525690 0.085794 -0.853079 0.745254 0.470764 1.708415 0.454432 0.154292 1.462384 0.611113 1.516746 1.371688 0.703292 0.701390 0.544563 0.626810 1.837098 1.610825 -0.024228 1.358625 0.479292 0.329229 1.052435 0.463840 0.312830 1.141728 1.582086 0.765008 0.327578 -0.085831 1.025222 1.291122 -0.200144 0.034110 -0.142378 1.852735 0.417386 0.764887 -0.019552 1.031569 -0.134898 0.442984 1.851464 0.765045 0.390155 0.409642 1.494195 0.907120 1.218247 0.925510 1.218873 0.082822 1.269590 -0.113144 1.736202 0.789672 0.902667 1.309261 0.125219 1.015082 0.103562 0.966352 0.882833 0.512183 -0.206360 1.361027 0.879198 1.428818 0.481892 0.858788 0.830911 0.157959 0.596064 0.538693 0.094129 0.926733 1.570637 0.418544 0.228207 -0.036964 1.469787 1.423685 0.893617 1.433152 1.658379 0.825654 1.401066 0.922419 1.034588 0.704542)
      
      11.803769491638 #(0.0 0.99588815789474 0.82728031578947 0.03346047368421 0.039283631578947 1.3133017894737 0.93709294736842 0.45573910526316 1.7685282631579 1.1186944210526 0.44180657894737 0.33834473684211 1.2175528947368 1.1102750526316 0.50922021052632 1.2503193684211 0.35855852631579 0.71680768421053 1.0557138421053 0.910988 1.1412951578947 0.87617931578948 1.8676494736842 1.5482506315789 0.60117278947368 0.92469294736842 1.1933301052632 1.4769832631579 0.25778542105263 0.76405557894736 0.2696847368421 0.96656089473684 1.2877880526316 1.5290362105263 1.3403293684211 0.34387652631579 0.38790468421053 1.3630728421053 0.35674 1.3160451578947 1.5841333157895 0.60897147368421 1.8302256315789 1.9917527894737 0.27849294736842 1.5409951052632 1.1454202631579 1.1435374210526 0.067870578947364 0.028087736842103 1.1716218947368 1.7947190526316 0.0037352105263153 0.64602936842105 0.97844952631579 0.15825068421053 1.6898058421053 0.846813 1.7807891578947 0.50155731578948 0.3798744736842 1.5903156315789 1.7564017894737 1.7524969473684 1.5350501052632 1.2523892631579 1.7014414210526 1.5061515789474 0.20888573684211 1.1781838947368 0.95967705263158 1.7349862105263 0.81493536842105 1.6549925263158 0.88588168421052 0.66866584210527 1.021806 0.74024715789473 1.2966033157895 1.4138464736842 0.62610663157895 1.7856757894737 1.8707769473684 1.4895111052632 1.7188032631579 1.7521334210526 0.60334657894737 1.1726097368421 1.3484508947368 1.9267150526316 0.39880121052632 0.079105368421054 0.031622526315793 1.5431936842105 0.28033084210527 0.872149 0.35271515789474 1.2488533157895 1.6769884736842 1.484639631579 1.3643977894737 1.0369359473684 1.8999541052632 0.5448452631579 1.0952784210526 0.13675457894738 0.71095673684211 0.17321989473685 1.4099700526316 1.2621442105263 1.1108443684211 1.5349415263158 0.81628368421053 1.1855388421053)
      )

;;; 115 even --------------------------------------------------------------------------------
#(115 14.597 #(0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)
      14.568 #(0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

      11.676566 #(0.000000 0.067553 0.653503 0.882622 0.827479 0.925322 0.258571 1.621426 1.030244 1.580838 1.200280 -0.742377 0.150540 0.066998 1.078082 -0.236212 0.318037 1.626689 1.742126 1.676229 -0.577039 0.280826 0.963643 0.690871 0.398581 0.551697 1.329859 0.552115 1.050369 1.450845 0.953593 0.476721 0.902030 0.358031 1.634738 1.974060 0.161275 0.038301 0.217788 -0.178035 1.564126 0.995273 -0.132996 1.124653 1.247653 1.459544 1.619556 0.955365 -0.065033 1.547019 1.279550 1.755313 0.732190 1.156938 0.660023 0.439794 1.246918 1.537440 1.007210 0.259036 1.659688 1.751201 1.506234 0.730661 0.816064 1.131378 1.141258 0.493167 1.056117 1.189325 0.091546 0.779929 0.667523 -0.049141 0.494646 1.019342 1.371700 1.291314 1.064055 0.387822 1.300785 0.955861 1.026125 0.078953 0.564900 0.986564 -0.410755 1.428478 0.870598 1.940108 -0.427626 1.762049 0.991685 -0.251416 1.569317 1.435946 0.638768 0.508629 0.704507 1.558544 -0.321402 1.522050 0.135905 1.150574 0.436741 0.091794 1.083022 -0.024602 1.375476 0.043205 0.392641 0.804293 0.339565 1.200128 -0.200300)
      )

;;; 116 even --------------------------------------------------------------------------------
#(116 15.190026349904 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)
      15.016979484255 #(0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

      11.826645 #(0.000000 0.013900 0.171155 0.275448 1.069590 -0.196944 1.635883 0.305574 0.372541 1.431087 1.665267 0.493972 -0.212485 1.083736 1.109024 0.121405 0.690414 0.458025 1.027554 -0.080356 1.202693 0.126717 0.894044 0.573849 1.184366 1.286433 1.109589 0.001747 1.655646 -0.163641 0.735539 1.418429 0.798147 0.066174 0.728189 1.400123 0.041229 0.185357 0.554883 0.777903 -0.019728 0.328320 0.961357 1.711609 1.526973 1.221694 1.352168 1.275483 1.570009 0.647463 1.565477 0.191250 1.564219 1.393424 0.570736 1.426222 0.152820 0.704288 0.425529 0.281952 1.073729 1.625996 0.326072 -0.024784 0.206907 0.199494 1.057205 1.381629 0.754599 0.074818 0.104657 0.102461 1.644794 -0.064312 1.340091 0.660109 0.478779 0.785647 1.026103 -0.237891 1.007427 0.831385 0.857820 1.584975 0.908874 0.273944 1.675793 0.575279 0.237439 1.133738 0.076080 1.429150 1.227778 0.438062 1.092608 0.728743 1.957503 0.684171 0.827400 0.139757 0.362696 0.039210 0.239828 0.190600 0.697420 0.628631 0.234754 0.830164 1.028327 0.565604 0.499624 -0.165429 1.678136 0.514057 0.233190 0.230650)
      )

;;; 117 even --------------------------------------------------------------------------------
#(117 15.56056534994 #(0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0)
      15.070538411179 #(0 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)
      14.875072951405 #(0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

      11.856473 #(0.000000 0.035477 0.906529 0.086230 1.225728 0.479742 1.504243 1.584944 0.899303 0.033243 0.806450 1.038181 0.065447 1.483519 1.102521 0.468538 1.300082 0.083387 0.640383 1.349689 1.809411 1.768953 1.005724 1.862740 0.980140 0.296359 0.352607 0.904763 0.412898 0.326532 1.210849 1.129621 1.640920 0.362943 0.153860 0.824012 0.309799 -0.009311 1.201006 -0.408854 1.060964 0.304417 1.181715 0.819976 0.228449 1.161197 -0.327199 1.366064 1.449786 1.673919 0.158522 1.611130 0.002508 1.148944 1.354884 1.389304 1.175018 -0.110344 1.813979 1.544803 0.697112 0.829304 0.172170 1.385658 1.735160 1.531082 0.177289 1.170706 0.993428 1.568097 0.174165 1.520415 0.668791 0.785494 0.960482 1.106937 -0.036450 1.351021 1.136476 0.293034 1.623058 1.729169 1.358417 0.465130 0.998331 1.753357 1.598742 0.991237 0.504333 0.921985 0.437578 0.447351 1.915223 -0.077959 0.357745 1.266907 1.372865 1.538951 0.613277 1.328459 0.013298 1.553691 1.347771 -0.096116 1.441907 -0.472992 -0.159038 0.086840 0.920710 0.975991 0.612253 0.356911 0.506514 0.709328 0.879050 -0.096250 0.316338)
      )

;;; 118 even --------------------------------------------------------------------------------
#(118 15.425480892646 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1)
      14.841081077183 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1)
      14.774983755641 #(0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

      12.124469 #(0.000000 -0.101844 1.526167 1.040742 1.526927 0.080488 1.602658 1.483052 -0.459908 -0.038895 0.795467 0.008851 -0.277377 0.337360 1.876286 0.292929 1.414530 1.605137 0.266403 0.268276 0.782042 -0.024236 1.384291 1.168997 1.869737 -0.228479 0.882177 1.618271 1.171696 0.872709 1.378093 -0.169864 0.191552 1.501933 0.888886 -0.091719 1.495681 0.219309 0.542807 0.550860 0.189947 0.140827 0.102895 1.721432 1.414137 1.813983 0.260362 1.287057 0.595302 0.196190 1.624744 1.146396 1.283547 1.587944 0.168946 0.974937 0.661164 0.586746 -0.044034 1.525222 0.833386 -0.207521 1.888113 0.102417 1.177923 0.014173 1.273258 0.509042 1.684444 1.029755 1.031756 0.630019 0.802522 1.733930 0.351432 1.630372 1.566092 1.268313 1.270650 1.787636 0.402989 1.700179 1.127993 1.663395 0.787482 0.005615 1.759743 0.303584 1.637027 1.533976 0.956211 0.881291 1.141253 1.291578 1.376154 -0.003898 0.940461 -0.032703 1.890197 0.697064 0.151305 0.844421 0.952321 0.845714 1.642460 0.490608 0.965392 0.810311 1.596525 0.148308 1.281598 0.543299 0.481803 0.130521 0.708019 1.395795 0.251578 0.984080)

      11.94427607766 #(0.0 0.2862155720339 0.031014144067797 0.066667716101695 0.71146228813559 1.4118518601695 1.3074044322034 1.2173690042373 1.9333225762712 0.60597914830509 1.661075720339 1.2552312923729 1.0330598644068 0.069078436440678 1.8627970084746 0.69800158050847 1.7455761525424 0.43687372457627 1.5178582966102 1.8737408686441 0.74110144067797 0.031172012711864 1.5780305847458 0.022833156779661 0.66610072881356 0.93587830084746 0.29536687288136 1.3373614449153 1.1641610169492 1.1960735889831 0.06355916101695 0.47647673305085 1.4218203050847 1.0709248771186 0.66986244915254 1.7119380211864 1.7801945932203 0.83154816525424 1.4905247372881 1.684374309322 1.5768488813559 1.8536184533898 0.15894002542373 0.38876259745763 0.44623416949153 0.76623674152543 1.4315643135593 0.96516588559322 0.28112145762712 0.17125402966102 0.066268601694915 0.0088011737288127 0.18593874576271 0.85555731779661 1.7137178898305 0.64153046186441 0.75557503389831 0.9242886059322 0.4521921779661 0.49459575 1.9433983220339 1.1980518940678 1.6086654661017 0.12830103813559 1.4555566101695 0.86969418220339 0.20622175423729 1.7929073262712 0.89995389830508 0.80424147033898 0.99511704237288 1.0248746144068 1.4611621864407 0.55146675847458 1.6232653305085 1.0949939025424 1.3778234745763 1.2354400466102 1.5328496186441 0.26261419067797 1.3801947627119 0.95799533474576 0.59531290677966 1.3535734788136 0.89890205084746 0.36052262288136 0.58517419491525 1.2522007669492 0.85828933898305 0.58309291101695 0.85888448305085 0.68434505508475 1.4322006271186 1.9383391991525 0.20514677118644 1.0052513432203 0.41745991525424 1.8130894872881 0.044957059322037 1.2646376313559 0.71929720338983 1.6399997754237 0.52479034745762 0.041509919491524 1.3271574915254 0.45215606355932 1.1111766355932 1.3109842076271 0.76697877966102 1.0316963516949 0.84628692372882 0.40590049576271 0.37732606779661 0.26488163983051 1.4450492118644 0.26908078389831 1.4529053559322 0.45615992796611)
      )

;;; 119 even --------------------------------------------------------------------------------
#(119 15.519069915733 #(0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1)
      14.971 #(0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

      12.197901 #(0.000000 0.062772 -0.230894 -0.023186 0.137044 0.115669 0.747539 -0.016469 1.836034 0.429324 1.221476 0.835800 1.928046 0.714197 0.291508 1.145038 0.872468 0.303766 0.469804 1.742339 -0.401733 1.222324 0.207115 0.863223 0.526300 1.868195 1.624093 1.574289 1.281763 0.606577 1.673180 1.656332 -0.055371 0.713841 0.264359 0.194509 0.585495 0.993664 0.276942 0.412030 1.903785 1.344433 1.259395 1.623046 -0.551576 1.135833 -0.133608 1.057739 0.759391 1.259282 0.244461 1.664654 1.198154 1.166275 1.085676 1.322459 0.232410 0.969214 1.024215 0.320998 1.039121 0.704587 0.714973 1.008864 0.743958 -0.035347 1.357510 1.029688 0.074847 1.713622 0.991435 1.052979 0.888225 0.214659 0.721347 0.993389 0.695233 -0.304478 0.878306 1.422327 0.054718 0.884687 0.953296 1.712647 1.563591 1.738488 1.067875 1.686497 1.580518 1.184042 1.579698 0.702024 1.576476 -0.054125 0.360220 -0.197336 0.378704 1.159006 1.028114 1.193458 0.298060 1.374308 0.194132 0.612428 -0.064545 0.689271 0.387523 1.143695 -0.348251 1.965698 0.233743 0.762618 0.870385 0.341755 0.909464 1.482337 0.146037 1.171221 1.200280)

      12.036718462396 #(0.0 0.5140493697479 0.6959657394958 1.4395301092437 0.2308164789916 0.7982868487395 1.9402342184874 1.5069245882353 1.7952889579832 0.99684132773109 0.42579669747899 0.54615806722689 0.01582143697479 1.4242458067227 1.3954851764706 0.80337554621849 0.95883791596639 1.0975302857143 1.8487836554622 1.4019830252101 1.774056394958 1.9695887647059 1.5341841344538 0.59868450420168 0.79395687394958 0.58776624369748 0.91591061344538 1.2752619831933 1.5831673529412 1.4471057226891 0.95133209243697 1.7107154621849 0.40490883193277 1.7046322016807 1.7561355714286 0.32342394117647 1.1762593109244 1.8928326806723 1.8064920504202 0.44249742016807 0.43901178991597 0.49139715966387 0.93508452941176 1.7372568991597 0.032005268907564 0.18149763865546 1.4721420084034 1.2418153781513 1.4482337478992 0.60086211764706 1.959006487395 1.8544108571429 1.8761062268908 0.42405059663865 0.84724496638655 1.7083163361345 0.81332070588235 0.42810507563025 0.87764144537815 0.47811381512605 0.064951184873948 0.22733855462184 0.39175192436975 1.4011432941176 1.5122526638655 1.2383450336134 1.3775094033613 1.6310987731092 1.0887521428571 1.018322512605 0.94888988235294 1.4697032521008 1.7915326218487 1.7092649915966 0.89864836134454 1.6627677310924 1.7604681008403 1.4554264705882 1.0709898403361 1.850774210084 1.2772805798319 0.48556994957983 1.1813663193277 0.44475168907563 0.81377405882353 1.5196874285714 1.1272847983193 0.36318216806723 0.82321053781513 0.94425990756303 1.8846262773109 1.4239136470588 0.77757601680672 1.6451633865546 0.65292775630252 0.57115912605042 1.7011744957983 0.96828186554622 1.3110512352941 0.095690605042016 1.5156439747899 1.2862493445378 0.60600871428572 1.6428950840336 1.3936024537815 0.73920682352941 0.64259219327731 1.9673235630252 1.2906869327731 1.916465302521 0.77633767226891 1.7090180420168 0.32592141176471 0.3806247815126 1.5573021512605 0.7604375210084 1.6836528907563 1.0210852605042 1.7669256302521)
      )

;;; 120 even --------------------------------------------------------------------------------
#(120 15.824793168635 #(0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.350 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)
      15.153992567168 #(0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

      12.139284 #(0.000000 0.000122 0.703927 0.971900 1.257551 0.290803 1.582352 0.270067 1.657523 0.855797 1.574961 0.908150 0.587151 0.893046 1.595014 1.822891 0.538527 0.103474 0.227983 0.571291 0.384168 1.829277 -0.603040 1.220668 0.258305 -0.367428 -0.016177 0.774725 1.068252 -0.000977 1.431563 -0.114915 0.230052 0.647155 0.914983 0.255767 0.374496 1.197947 0.348093 1.722565 1.906354 0.907487 0.939997 0.739386 0.933395 -0.188097 0.352454 0.069809 0.555350 1.682706 0.464865 0.049539 0.436308 -0.140569 1.797031 1.099253 1.809190 1.354162 0.273056 0.312106 1.311613 1.411470 0.397575 1.114915 0.624153 0.759756 0.843301 0.259887 0.479945 1.090341 -0.150012 1.401047 0.933551 0.197717 0.373562 0.426747 1.711653 0.777957 0.088650 -0.203553 0.173169 1.615588 1.591470 1.949905 0.724110 0.203614 0.212319 0.431490 0.667648 1.941387 0.305490 -0.002896 0.803694 -0.001617 0.231930 1.816514 -0.031397 1.016222 0.829782 0.808806 1.201953 1.276155 0.891326 -0.114659 -0.120025 0.930991 1.656351 1.354644 1.526335 0.424834 0.915454 0.750827 0.352496 1.565589 0.846293 1.135707 -0.015005 1.061949 1.153939 1.528346)

      12.107688986925 #(0.0 1.1521484375 0.970159875 0.2763673125 1.84761175 0.1901191875 0.648714625 0.4510200625 0.5068115 1.3526679375 1.130572375 1.6046528125 0.40985725 1.8690236875 1.785971125 0.9867485625 0.90069 1.7965774375 0.935148875 0.3685363125 1.37797975 1.9630481875 0.700924625 1.6809220625 1.8788145 0.4963319375 1.979949375 1.8365738125 1.40697525 1.1446366875 1.911974125 1.7558585625 0.909288 0.3262924375 0.11863487500001 0.6546433125 1.84054475 1.7954671875 0.125742625 0.6126890625 0.036906500000001 0.1526989375 1.324270375 0.3147208125 1.66172825 1.7936506875 1.501718125 0.2381105625 1.934879 0.0749364375 0.204457875 0.5688133125 0.42403675 0.9496731875 0.13472962500001 0.5107630625 0.1885375 1.0212049375 1.136548375 0.1326718125 0.50633325 1.6995186875 1.627663125 1.5498965625 0.282417 1.7412864375 0.83988087499999 1.4043613125 0.87395075000001 0.63894118750001 0.46239262500001 1.2637150625 1.7446565 0.2381719375 1.676175375 0.9127358125 1.42246525 1.4741816875 1.823795125 0.9302935625 0.440766 0.7781644375 0.090162875000004 1.7494563125 1.51528375 0.12662718749999 1.328164625 0.8532500625 0.2252685 0.67142393749998 0.032668375 0.95931881250002 1.06659825 1.2173876875 0.494508125 1.2271925625 0.624287 0.78110443750001 1.681234875 0.95793131249999 0.58422874999999 1.5714491875 0.413989625 0.6227680625 1.6747265 0.1278389375 1.881830375 0.59225281249999 1.89234625 0.080756687499999 1.700284125 0.63959456249999 1.218608 1.9596034375 0.22753887500001 1.5453883125 1.81547175 1.8365401875 0.923522625 0.73180406249999)
      )

;;; 121 even --------------------------------------------------------------------------------
#(121 15.507 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      15.168510014453 #(0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1)
      14.652157793709 #(0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

      12.157683 #(0.000000 0.059763 1.666720 1.218256 0.672025 0.154875 0.916309 1.303918 0.495384 0.138934 1.916394 0.800511 0.257720 1.915678 1.822857 0.205238 0.682056 1.519945 0.147422 0.361404 1.219148 0.162136 0.398907 -0.153342 -0.288258 0.316684 1.491173 -0.205193 0.277440 -0.334620 1.749739 0.792253 0.915550 1.553009 1.203314 1.397799 0.324699 1.302033 0.145779 0.697510 0.063544 0.006244 1.223857 0.079204 1.671795 0.353459 -0.270794 1.519014 1.438884 1.316406 0.482605 1.827624 -0.154250 -0.019478 0.519099 1.560395 0.323778 1.294633 0.662858 1.227912 0.657667 0.297037 0.418416 0.048946 0.975766 0.288400 0.404737 0.972322 0.200980 -0.041432 1.205873 1.042617 1.100103 0.388073 0.739181 1.656298 -0.421720 -0.044708 0.783754 -0.072960 1.299760 0.296091 -0.368405 1.475799 1.772041 1.546627 1.244455 0.230731 0.383765 1.621325 0.728766 1.584175 0.587352 0.899458 1.331695 1.012643 1.046419 1.309046 0.103540 -0.001532 0.043263 1.562889 0.842747 1.633106 1.510290 0.150293 0.334205 0.734559 -0.045976 0.039961 0.115134 0.602101 1.044593 0.986087 -0.130790 1.387421 0.035534 0.059984 -0.080403 0.363073 1.777303)

      11.986011240286 #(0.0 0.085227272727273 1.7988725454545 1.5797318181818 0.96805309090909 0.47713036363636 1.1563886363636 1.9179659090909 1.2299791818182 0.81440945454545 0.60712072727273 1.874334 1.3643332727273 1.1958395454545 1.0631568181818 1.4693560909091 0.083772363636363 1.1249986363636 1.7496819090909 1.9138791818182 1.0010004545455 1.9056177272727 0.4152 1.6144342727273 1.8669515454545 0.53896081818182 1.7192270909091 0.12860836363636 0.66989263636364 0.081629909090909 0.21177718181818 1.4844184545455 1.7063767272727 0.461415 0.18122727272727 0.36114454545454 1.3971268181818 0.50666309090909 1.3702293636364 0.031292636363636 1.4632649090909 1.3053981818182 0.85533845454545 1.6422837272727 1.423958 0.17121627272727 1.8021895454545 1.4459498181818 1.7881880909091 1.4501273636364 0.85532263636364 0.20735590909091 0.38335218181818 0.51925945454545 1.3010787272727 0.27307 1.2497952727273 1.9919975454545 1.5648058181818 0.32314509090909 1.8389853636364 1.5725896363636 1.7345389090909 1.4668001818182 0.24186145454545 1.9229277272727 1.914405 0.67624127272727 1.6996815454545 1.7173498181818 1.1535200909091 1.2436383636364 1.1017536363636 0.46166690909091 1.0346751818182 1.9364814545455 0.16616272727273 0.438345 1.3085552727273 0.85772954545454 0.18766081818182 1.3515080909091 0.80514336363636 0.42036863636364 0.89480590909091 0.83728318181818 0.54369945454545 1.6241997272727 1.7442 1.1485762727273 0.34087654545455 1.2863068181818 0.47061809090909 0.85827636363636 1.4301886363636 1.1368359090909 1.1178671818182 1.5531844545455 0.35611472727273 0.246136 0.65727227272727 0.039933545454545 1.8188598181818 0.56597109090909 0.55109236363636 1.2233546363636 1.3873289090909 1.7422751818182 1.0646034545455 1.3270137272727 1.464733 0.12678127272727 0.59467054545454 0.64017881818182 1.5977000909091 0.90787036363636 1.7608156363636 0.035412909090908 1.8599061818182 0.62088745454546 1.6327527272727)
      )

;;; 122 even --------------------------------------------------------------------------------
#(122 16.162 #(0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.305 #(0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1)
      15.057187309653 #(0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      12.310349 #(0.000000 0.012723 1.133793 1.225249 0.651969 0.460879 0.328863 0.676572 1.241382 1.005473 1.926524 1.569414 1.540793 0.399477 1.220058 1.341996 0.435519 1.544750 1.373593 0.428403 1.871360 1.200755 0.702107 0.244549 0.691709 0.146237 1.816794 1.498548 0.536709 -0.062704 1.699018 1.107899 1.434719 0.396414 1.321667 1.261157 0.865970 0.399915 0.129481 0.414328 0.710666 1.302598 0.414021 1.285793 1.674278 0.031574 0.004900 1.776253 0.840537 0.570943 1.129058 1.462228 1.557058 0.272883 1.515687 1.406072 0.544957 1.111516 0.112061 -0.037467 1.839602 -0.302946 1.451021 0.334404 0.575774 0.582248 0.200163 0.409741 0.301837 0.092206 0.702513 0.891971 1.090664 1.048963 1.897733 0.568759 0.901539 -0.050878 0.879234 0.135860 1.750046 0.560798 1.740672 0.973016 0.070230 1.104491 1.324300 0.707263 0.814664 0.960611 1.514765 0.851825 -0.063266 0.567436 1.153202 0.856833 1.864802 0.833290 0.741363 1.101304 1.599991 1.016757 1.004149 0.647463 1.753768 0.285767 0.645186 1.272755 0.829270 0.616469 1.016873 1.725655 0.976140 0.398702 0.591325 -0.036746 0.129641 0.042284 0.153348 0.886558 0.335197 0.542861)

      12.235707477806 #(0.0 0.21887807377049 1.503043147541 1.8320042213115 1.633801295082 1.4148803688525 1.715043442623 1.9111145163934 1.0135275901639 1.0384346639344 0.15439973770492 0.036615811475411 1.8848108852459 1.3376339590164 0.37022303278688 0.65539210655738 1.7829541803279 1.1418712540984 1.2754193278689 0.57685540163935 0.15280947540983 1.5795205491803 1.4588646229508 1.3870506967213 1.9726357704918 1.6799578442623 1.5400729180328 1.4908599918033 0.71921906557377 0.017298139344263 0.21472221311475 0.0066842868852461 0.34262736065574 1.5826384344262 0.88208650819671 0.98342158196721 0.7553446557377 0.45544172950819 0.39576880327869 0.97905587704918 1.5030629508197 0.22239702459016 1.6340480983607 0.47922517213115 1.2408552459016 1.9852543196721 1.8220583934426 0.05448346721311 1.3181115409836 1.2701086147541 0.1011516885246 0.53996776229508 0.97842283606558 1.7320099098361 1.4849049836066 1.416776057377 0.76118713114752 1.640796204918 0.87771027868851 0.73664635245902 0.87106542622951 1.1026395 1.0543885737705 0.060662647540994 0.55009072131148 0.75928279508197 0.58500986885247 0.95929194262297 1.1481890163934 1.4086160901639 0.059923163934428 0.47861323770491 0.94566531147541 0.8177603852459 0.22714745901639 1.1853105327869 1.5886796065574 0.68890268032789 1.7843107540984 1.3476568278689 1.2772519016393 0.33071597540983 1.8450380491803 1.2682701229508 0.41208919672131 1.5574872704918 0.14769934426229 1.6269364180328 0.13464049180328 0.50201456557377 1.2866306393443 0.67951271311476 0.021503786885233 0.74456686065572 1.8495529344262 1.6616830081967 0.82081008196721 0.1288471557377 0.078180229508206 0.69714530327869 1.6359233770492 1.0655374508196 1.3613985245902 1.1609115983607 0.64028267213115 1.3183317459016 1.8577458196721 0.69372389344261 0.44405696721313 0.40322704098361 0.92807111475406 1.9402871885246 1.3922592622951 0.95968533606558 1.622437409836 1.1141084836066 1.604690557377 1.6676886311475 1.996923704918 1.0163157786886 0.49666885245901 0.97938892622955)
      )

;;; 123 even --------------------------------------------------------------------------------
#(123 15.443287674437 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.448 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.332496766406 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 0)
      15.156582832336 #(0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

      12.163403 #(0.000000 0.068703 -0.021877 -0.047587 0.862823 1.226244 1.250429 -0.190467 0.416265 1.162066 1.565705 0.561870 1.389201 1.695185 0.307672 1.048441 1.072534 1.458096 1.522299 1.037836 1.460719 1.742574 0.831361 0.236716 1.404405 0.085887 1.309385 0.817860 0.469255 0.987499 1.663839 1.415368 0.523263 0.821840 0.416039 1.232212 0.755849 0.389740 0.261382 1.058139 0.612402 1.279360 0.376074 0.891688 1.399740 0.396095 1.112557 0.214367 1.583431 1.735841 -0.217973 0.590664 1.642397 -0.078150 1.017390 0.398996 0.831750 1.763445 1.812018 1.704923 0.905785 0.477507 -0.195914 1.241307 0.167461 0.251523 0.687946 1.092431 1.205123 1.248329 0.816281 1.278279 1.066581 1.721905 0.226169 1.042189 0.641021 0.399239 0.318773 1.276608 0.554440 0.998621 0.553980 0.208261 0.970399 1.771966 0.416073 1.378422 1.313480 1.509111 1.715450 1.394675 1.085512 1.048900 1.129927 1.102288 0.601806 -0.319029 0.250784 0.092708 0.605014 1.072021 1.602139 1.424560 1.453397 -0.310501 -0.704342 0.101276 0.237662 0.048595 1.698063 1.412384 0.624816 1.906981 0.774464 0.181777 -0.133472 1.550417 -0.529260 0.721053 -0.220293 1.084786 1.011620)
      )

;;; 124 even --------------------------------------------------------------------------------
#(124 15.877207326383 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1)
      15.402028019163 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)
      15.192802705519 #(0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

      12.193166 #(0.000000 -0.050987 -0.032981 0.316445 0.827665 1.250612 -0.169572 -0.032548 1.220042 0.785043 -0.417413 0.995378 0.096652 0.245475 0.220507 1.275688 1.770950 1.238644 1.211243 1.094146 1.800192 -0.085799 0.155749 0.589531 1.026461 0.136453 0.096791 1.145043 0.942850 0.665242 -0.466778 -0.248305 -0.190341 1.643032 1.008580 1.180122 0.239951 0.564708 1.857136 -0.045204 0.463242 1.634521 1.480832 0.779274 -0.237974 1.591917 0.741158 0.820641 -0.031873 -0.116113 1.109491 0.737561 1.083391 1.797393 0.081783 0.999359 0.611586 1.753444 0.164625 0.845119 0.281125 -0.029550 1.357666 1.357357 0.036045 1.544780 0.241579 0.160011 0.470215 0.342304 -0.016687 -0.174193 0.146268 1.022046 0.268926 -0.079487 1.731415 1.256784 1.649429 1.166536 1.094032 -0.076514 1.083287 1.735539 -0.042000 1.165917 0.029496 1.288898 0.486094 0.692155 -0.050708 1.726637 0.354762 0.242497 0.536100 0.283045 0.706931 1.770421 1.210836 0.420450 0.137656 0.902346 0.027211 1.028361 1.312287 1.364626 1.333162 0.604307 1.350145 0.868595 0.247240 0.789627 1.685524 0.795045 -0.165028 -0.021183 0.821451 1.447203 1.183790 1.322231 1.336908 1.467733 -0.139625 -0.299339)
      )

;;; 125 even --------------------------------------------------------------------------------
#(125 15.874541816027 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.743360519409 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0)
      15.340427254326 #(0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

      12.379664 #(0.000000 0.052749 0.014035 1.687655 0.789570 0.979924 0.862033 0.404380 0.317580 1.628968 0.197246 0.305623 0.276046 -0.240301 1.198595 0.995851 0.230109 0.391084 0.895871 1.414747 0.747502 0.087673 1.334762 0.152484 1.855308 0.964881 0.517092 1.307159 0.768227 1.500690 -0.438645 1.570254 0.828717 0.452778 0.392852 0.287195 1.369315 -0.241435 1.267174 1.034155 1.382849 0.521905 0.629150 0.396087 0.305649 0.902896 0.828583 0.534132 0.363429 1.413634 0.487090 1.383422 1.260585 1.002835 -0.035220 1.027331 1.789819 0.174450 0.240380 0.450906 0.701094 1.443610 0.940787 1.692568 1.337326 0.024295 0.244911 -0.322159 1.500392 0.058143 1.808035 0.688408 0.963369 1.928314 0.884636 1.206046 0.505334 1.314452 0.604621 0.917144 -0.426780 1.457585 1.542016 1.284606 0.753813 1.463603 1.783762 -0.542774 -0.361244 0.754319 1.526302 1.762918 0.709243 0.971056 1.822930 0.461321 -0.156383 1.046698 0.500881 1.145216 1.436649 0.406079 0.768861 0.539241 1.103581 0.006652 0.091975 0.355275 1.628583 0.500908 0.243999 -0.350568 1.071794 0.507568 0.188127 0.876943 1.445596 0.795271 0.806290 0.985326 1.250818 0.765550 0.907527 0.618544 0.644491)

      12.304565132582 #(0.0 0.203625 0.560741 0.332062 1.640086 0.033855 0.027032 1.896907 0.00097499999999995 1.411752 0.293285 0.413696 0.552614 0.697575 1.91616 0.130753 1.432272 1.907949 0.645495 1.344245 0.83071 0.476003 1.790138 0.864462 0.754669 0.073366 1.746953 0.867317 0.3913 1.339778 1.534646 1.975017 1.259801 1.191362 1.307761 1.321501 0.697327 1.191561 0.863254 1.044423 1.511302 0.867698 1.206778 1.166685 1.190295 1.876639 0.188779 0.095908 0.150139 1.399775 0.490648 1.835952 1.8348 1.733811 0.857013 0.123356 1.14735 1.648927 1.988959 0.480394 0.93654 1.915718 1.463543 0.559589 0.340671 1.261952 1.623735 1.443176 1.235945 0.057081999999999 1.944216 1.214445 1.758641 0.762147 1.895997 0.422448 0.0062749999999987 0.920022 0.243943 0.750324 1.898901 1.944179 0.29193 0.217271 1.677458 0.618344 1.377034 1.260356 1.460683 0.744523 1.963 0.248764 1.618155 0.041302000000002 1.072203 1.849695 1.308947 0.679239 0.440034 1.43768 1.892826 0.90847 1.509045 1.536521 0.401913 1.227491 1.814812 1.937216 1.618799 0.692221 0.503492 0.306351 1.779219 1.581211 1.494962 0.206992 1.040526 0.499672 0.779782 1.11652 1.635981 1.3296 0.079889999999999 1.574104 1.801121)
      )

;;; 126 even --------------------------------------------------------------------------------
#(126 15.964 #(0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.680 #(0 1 0 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1)
      15.28212621738 #(0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

      12.496996 #(0.000000 0.043702 1.208303 1.354701 1.420749 0.540685 -0.012542 0.620860 0.334785 0.647306 0.981098 1.023731 1.860482 1.434667 0.843218 1.553274 0.893912 1.566878 1.629090 1.531618 0.459282 -0.871897 0.850404 -0.122459 0.824325 0.173998 1.763771 0.141679 1.631798 0.015339 0.124197 0.337347 0.156508 0.448075 0.156007 0.131808 1.166853 -0.184664 1.435711 0.979083 1.561752 0.046495 0.760019 0.210722 1.816800 1.817598 0.259865 0.324996 1.361265 0.861626 1.210521 1.577801 1.419723 1.659738 1.058148 0.850366 0.818485 0.094797 0.620677 1.247684 0.485557 -0.340825 0.063081 0.174775 0.219721 1.129656 0.676973 0.760106 0.565893 0.894092 1.264752 1.388040 0.788329 0.299885 1.340501 0.778336 0.097679 1.273185 1.394099 1.514751 0.459616 0.784483 1.090003 0.014569 0.481415 -0.199532 0.997466 0.132132 1.516462 1.863074 1.054286 1.250663 1.812057 0.471105 0.707174 -0.613582 0.820175 0.779698 1.774273 0.278986 1.040204 1.049339 0.966633 0.163475 0.332859 0.408581 1.621383 0.023523 1.367312 1.749255 0.805369 1.571926 0.510583 -0.159182 1.420442 0.886683 -0.053010 0.563299 1.128697 1.048473 0.946568 1.646947 1.636124 1.279848 0.689700 0.608960)

      12.401357608606 #(0.0 1.7734375 0.746467 0.6110195 0.580232 1.3741655 0.662093 1.0645335 0.481088 0.3356215 0.826735 0.6607695 1.331697 0.5441475 1.81337 0.2767245 1.331229 1.9415465 1.517627 1.3793725 0.008267 0.5899335 1.715001 0.6783905 1.452253 0.4623785 1.863351 0.077460500000001 1.358552 1.4385845 1.186282 1.3663085 0.89344800000001 0.7133675 0.60720500000001 0.1178745 1.107802 1.4105865 0.829128 0.1692165 0.623331 0.5621945 1.308932 0.26842449999999 1.902499 1.5459865 1.885131 1.6768275 0.549075 1.8677305 1.884977 1.9875895 1.699181 1.5980185 0.939417 0.32517250000001 0.221126 1.1135205 1.350971 1.7993505 0.82412000000001 1.7212375 0.097027999999995 0.029675499999996 1.564208 0.44961949999998 1.830507 1.6735905 1.120597 1.3883655 1.415592 1.2907895 0.46601799999999 1.8331815 0.628676 1.8921235 0.78510599999998 1.7849855 1.750164 1.6900285 0.33839499999999 0.5219725 0.51655300000002 1.1515915 1.407915 0.53246850000001 1.672219 0.37259449999999 1.450828 1.7318245 0.63243199999999 0.6720785 0.98700300000002 1.3408155 1.18298 1.9290315 1.186661 0.87072549999999 1.569671 1.8495435 0.39748799999998 0.21101349999999 1.83465 0.73826050000001 0.661706 0.6644225 1.722684 1.7371445 0.706734 1.0531465 1.798889 0.23331449999999 1.144698 0.25723550000001 1.663092 0.93512949999999 1.853311 0.04995550000001 0.315415 0.2804565 1.720787 0.13918649999999 0.29213999999999 1.4363025 0.64692300000002 0.48012749999998)
      )

;;; 127 even --------------------------------------------------------------------------------
#(127 15.859804776319 #(0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.609939955803 #(0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1)
      15.237931718393 #(0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      12.433433 #(0.000000 0.001039 0.794589 0.480502 1.208764 0.770971 1.073324 1.674362 1.759250 1.653246 0.687630 0.117389 1.757594 0.396153 0.742139 -0.145275 0.150278 0.989943 0.871445 1.284923 0.503406 1.468297 0.547288 0.717952 0.333519 0.467563 0.859810 0.710502 0.157439 -0.056125 1.830397 0.438027 1.628650 1.381862 1.053617 0.920360 0.822025 0.688382 0.334613 1.051817 1.027260 0.203568 0.917096 0.646127 1.008962 0.965638 0.659078 1.314658 1.103724 0.240444 1.161698 0.495615 0.015437 0.971561 0.222253 0.342979 1.441628 1.676417 1.250376 1.121554 0.560005 1.503617 0.874148 1.197806 0.599591 1.638135 1.294060 1.377340 1.250695 0.193947 0.461795 0.268431 0.454564 1.602492 -0.056376 0.853305 0.018596 0.077381 0.484563 0.721471 0.176812 0.446403 0.825071 0.310039 0.502119 1.338224 1.729751 0.207977 0.303827 1.102208 0.966639 -0.018319 1.909312 1.729043 0.150613 1.106267 1.608811 1.055529 1.617021 1.672950 -0.451767 0.290000 1.734544 0.181495 -0.125976 0.874095 0.964353 0.807511 -0.067029 0.794199 0.120181 1.440997 0.424676 1.073894 -0.135463 0.688492 1.074206 -0.267919 1.540866 0.725381 0.727642 1.052285 0.292076 -0.070293 0.145539 1.020900 0.791555)

      12.30257214351 #(0.0 0.43922244094488 1.6862278818898 1.6317353228346 1.0025297637795 1.0126302047244 1.6208786456693 0.77186508661417 1.3087345275591 1.8495249685039 1.1866324094488 0.7781288503937 1.0293792913386 0.062711732283464 0.91089217322835 0.37337661417323 1.1092750551181 0.41124649606299 0.89401193700787 1.5787313779528 1.2721478188976 0.72214125984252 0.2927917007874 0.87523314173228 0.68998758267717 1.517879023622 0.41697146456693 0.65816390551181 0.38999134645669 0.73172778740157 1.2012362283465 0.09235566929134 1.7893961102362 1.7547475511811 0.029369992125982 0.31799643307087 0.73455287401575 0.89483231496063 1.1564337559055 0.37706719685039 0.61516063779527 0.17021207874016 1.139038519685 1.3897089606299 0.4611384015748 0.68391484251969 0.93484628346457 1.9879847244095 0.21046616535433 1.6567816062992 1.1726050472441 0.96375048818897 1.1437379291339 0.18946237007874 1.8571348110236 0.50164925196851 0.096263692913382 0.55087113385827 0.66872257480315 0.92129801574803 0.95791045669291 0.062725897637794 0.27791333858268 0.89190777952756 0.77772722047244 0.29649366141732 0.2255591023622 0.72630254330709 1.290245984252 0.53272042519685 1.1965308661417 1.5963443070866 0.18150274803149 1.8474701889764 0.57929962992126 1.8570880708661 1.480848511811 1.7392919527559 0.60281839370079 1.5481688346457 1.2012492755905 0.085552716535432 0.77950115748032 0.68407459842519 1.4269730393701 0.71659348031496 1.4686529212598 0.65883536220472 0.78537780314961 0.29193424409449 0.63450768503937 1.8786711259842 0.18769656692913 0.62802600787402 1.5486074488189 0.68529388976378 1.7207173307087 1.5596907716535 0.71106121259843 0.9597136535433 1.3413550944882 0.66247353543307 0.63821997637795 1.6894714173228 1.4648778582677 1.0901882992126 1.6647377401575 1.6846451811024 1.5246896220472 0.81916306299213 0.55831950393701 0.23436494488189 1.4621723858268 0.89565882677165 0.051744267716529 1.2246797086614 0.1663511496063 1.4105805905512 1.5693240314961 0.98731947244094 1.4703719133858 0.17406835433071 0.051964795275588 1.9339972362205 0.56767967716536 0.066256118110232 0.15666555905512)
      )

;;; 128 even --------------------------------------------------------------------------------
#(128 16.159544533014 #(0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0)
      15.889096531102 #(0 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 0 0)
      15.651492555885 #(0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      12.528413 #(0.000000 -0.079332 0.938346 1.160259 0.230390 1.225509 0.442412 1.721188 0.207074 1.440051 1.256394 -0.089755 1.739909 1.449194 1.508940 1.073220 -0.278995 0.147610 1.373821 0.096652 1.598830 1.369199 1.569043 1.361844 0.503915 0.585748 0.276077 0.397551 -0.004169 -0.053489 1.150795 0.195006 0.612633 -0.097664 1.446672 0.157424 1.791922 0.844548 0.133218 0.619582 1.318879 0.051848 0.705624 1.747860 1.359784 0.751444 0.536367 0.242972 1.806722 0.980567 1.318305 0.951673 0.202557 0.970235 1.781484 0.961001 1.770872 0.170014 0.510015 0.672623 1.393489 1.102865 1.255744 0.245755 0.052952 1.715652 1.028201 1.904819 -0.029773 -0.255206 0.678382 0.553428 1.293404 0.464451 0.634848 0.642514 0.528549 0.229411 0.048225 0.795223 0.021765 0.209159 1.613393 1.754357 0.083754 0.335073 0.225132 0.272850 0.979203 0.746490 1.030677 0.995461 1.350837 0.079883 0.132801 0.618254 1.737905 1.455269 1.632640 1.335859 0.352393 -0.003285 1.570878 0.698130 -0.017442 1.310598 0.731961 1.647774 0.081318 0.519782 0.940151 1.682232 0.564370 0.729395 1.296974 1.283772 1.539642 0.664982 0.672759 -0.114977 1.894972 0.222322 1.720771 0.398352 1.571079 1.606445 0.455806 1.641557)

      12.446469647423 #(0.0 0.1856689453125 1.223338890625 1.7899528359375 0.99890778125 0.1289227265625 1.389191671875 1.0405636171875 1.6053565625 1.0079485078125 1.084340453125 0.0468693984375 0.10257934375 1.9273602890625 0.186671234375 1.8667961796875 0.612407125 1.2972980703125 0.870682015625 1.7502789609375 1.38941990625 1.1225268515625 1.657102796875 1.5093407421875 0.9451126875 1.1833776328125 1.015220578125 1.4078585234375 1.09082546875 1.5065574140625 0.749387359375 1.9148173046875 0.55395825 0.2028711953125 1.524289140625 0.7275720859375 0.46661803125 1.6505239765625 0.950971921875 1.8085578671875 0.5938508125 1.6798247578125 0.490733703125 1.8383296484375 1.57159859375 0.9947235390625 1.289665484375 0.9883424296875 0.702479375 1.9861613203125 0.610374265625 0.3880932109375 1.82014015625 0.7029371015625 1.814591046875 1.2200379921875 0.1505499375 0.8536828828125 1.275248828125 1.4524317734375 0.48591371875 0.5293776640625 0.712568609375 1.8697955546875 0.1106595 1.9519774453125 1.202797390625 0.1963613359375 0.54257028125 0.4468852265625 1.803167171875 1.7676931171875 0.7590020625 1.8786170078125 0.312370953125 0.5328378984375 0.57821484375 0.3923827890625 0.496428734375 1.6088976796875 0.831013625 1.2010975703125 0.922400515625 1.0947804609375 1.54580640625 1.9847773515625 0.327402296875 0.4735892421875 1.2824241875 1.2160561328125 1.795724078125 1.9551340234375 0.40898596875 1.1366799140625 1.638853859375 0.3746508046875 1.61533675 1.6884496953125 1.810685640625 1.6650145859375 0.91027853125 0.6882774765625 0.458667421875 1.7094773671875 1.3034013125 0.8685242578125 0.343887203125 1.5177061484375 0.22258609375 0.7437260390625 1.478985984375 0.4315159296875 1.302460875 1.8566748203125 0.551150765625 0.7573477109375 1.18403165625 0.3889076015625 0.468490546875 1.9910114921875 0.3470374375 0.6132833828125 0.259938328125 1.2377942734375 0.40851221875 0.7244561640625 1.759071109375 1.2169860546875)
      )

;;; 256 even --------------------------------------------------------------------------------
#(256 24.434719362486 #(0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

      21.147051 #(0.000000 0.013043 0.920117 0.211418 0.668306 1.385627 1.906635 0.858012 -0.025540 1.212427 1.778724 0.580100 0.439691 1.356157 -0.119063 0.434266 0.154352 0.442955 -0.005968 1.535794 1.403556 0.183703 0.719695 0.808134 0.717026 -0.004795 0.750023 0.510510 -0.111539 0.030727 1.471914 0.702448 0.847566 0.053362 -0.108798 1.030415 0.581323 1.534487 0.340353 1.468027 1.258297 0.652253 -0.177908 1.046447 0.259688 1.647334 1.350135 0.131395 0.878222 0.018247 1.361793 1.595723 -0.194803 1.278955 0.422974 0.308531 1.680151 0.819388 0.650454 1.170154 0.982131 0.916385 0.251795 0.614215 0.058138 0.237243 0.480617 0.078361 0.274005 1.104676 -0.049561 0.890974 0.285114 1.560285 -0.042858 1.287080 0.986201 0.225144 1.911656 0.412797 1.906001 1.113150 0.002975 0.378566 0.185842 0.978524 0.886147 1.174987 1.402841 1.532148 0.452840 1.653473 1.368866 1.142209 0.399142 -0.053477 1.387350 1.063119 1.101594 0.660387 0.318690 -0.075495 1.596588 1.423152 0.699488 1.066220 0.932593 0.726316 0.721243 0.616117 1.231920 1.204386 0.280095 0.737486 0.246794 1.225672 1.938762 1.669744 1.911752 0.028184 0.352670 1.169110 1.138933 0.911609 1.153860 1.295188 1.451568 1.222645 1.836765 0.315515 1.661130 0.665886 1.423539 -0.027924 1.624245 0.211892 0.318464 1.015468 1.652245 0.240743 1.150550 1.257988 1.368042 0.690738 1.931274 -0.034743 0.771903 1.856503 0.683190 0.957751 0.409827 0.925581 0.140171 0.602555 0.465835 0.338671 1.281554 0.705219 1.397775 1.170389 0.382381 0.242999 0.668790 0.700098 1.973505 0.627343 0.670404 0.886476 0.982946 0.759522 0.694097 0.252884 0.859515 1.570045 1.546775 0.284098 0.314092 0.168123 1.469812 1.098694 0.268268 1.420670 1.272723 0.382719 0.671480 1.435402 -0.110241 0.561019 1.353828 1.506014 0.931446 1.044498 1.647818 0.262634 1.666668 0.124893 0.309225 1.239534 0.520530 1.500534 0.061664 1.274884 -0.244216 1.650214 0.424051 0.892559 0.202169 0.442374 0.683088 1.684786 1.219867 0.391490 1.016231 1.491883 1.765165 1.764702 1.283017 0.934137 0.230333 1.283241 -0.045685 1.411918 1.307833 1.725023 0.245397 0.538120 1.457284 0.616433 0.168907 0.521502 0.384247 0.974783 0.364292 0.076939 -0.235106 1.283357 1.428764 1.664927 0.374574 1.099794 0.852722 1.803641 0.274149 1.335009 1.914350 -0.207888 0.073165 1.428393 1.365955 1.849232 0.634655 0.268387 -0.166276 0.397839 0.357434 0.489122)
      )

;;; 512 even --------------------------------------------------------------------------------
#(512 35.776 #(0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      31.628149 #(0.000000 0.193458 0.879636 1.705304 0.490370 0.075082 0.075683 1.300845 1.564891 0.673316 0.757185 0.241756 0.594649 0.885118 0.323693 1.454812 0.908273 1.351061 1.781313 0.564771 0.183286 0.637926 0.622421 1.045142 0.517278 0.296784 1.410403 0.602065 0.772561 1.389650 0.527960 1.708369 0.033642 1.830155 1.178018 1.593299 0.764263 1.671821 0.206173 1.235732 1.402783 1.788135 0.201137 0.539609 -0.025782 0.918770 0.935892 0.891239 1.913603 1.292613 -0.101151 0.722659 0.055747 -0.088554 0.598806 0.380559 1.211892 1.546048 0.916625 1.399887 1.565523 0.904754 1.010130 1.643551 1.461234 0.875915 0.213846 0.357475 1.186241 1.381267 0.754949 1.779095 1.006740 1.311595 1.737320 1.086140 0.608280 1.768795 1.226748 0.139423 0.844731 1.174543 0.052337 0.835236 0.709458 1.432591 0.165398 0.442884 0.896570 1.597184 1.133267 1.895467 1.175626 0.109893 1.094502 1.928908 -0.087649 1.565508 0.274473 0.027155 1.554166 1.239019 1.373234 1.458458 1.546571 0.031108 1.855623 1.647770 1.494922 1.630144 0.041700 1.725269 0.114205 1.279109 0.713125 1.361675 1.293302 0.370706 1.155957 0.160127 1.306020 1.564145 0.329533 1.577490 0.426179 0.865540 0.506954 0.836528 1.895468 1.155187 1.524271 1.949386 0.062295 1.616901 0.556622 0.305661 1.919946 1.844259 0.313013 0.024129 1.635243 1.597075 1.722121 0.294542 1.002701 1.459972 1.504069 0.899408 0.331782 0.396363 1.663102 1.290621 1.116303 1.021895 0.255551 1.181969 0.645937 1.543659 1.606428 0.192360 0.894664 -0.002504 0.398536 1.481294 0.918465 0.074277 0.749762 0.689678 0.975924 0.653357 1.294427 1.063153 0.441398 0.872255 0.882166 0.959648 1.175046 1.530354 0.796278 0.915558 0.628151 0.260515 1.245714 1.010362 -0.030800 0.853342 0.047830 1.010196 1.020267 0.045034 1.849312 1.096281 0.221294 1.343819 1.249551 0.337281 0.664846 1.064716 1.335370 1.464875 0.181615 -0.072256 0.046603 1.522391 0.275503 0.681141 1.127342 0.430827 1.110432 1.803612 0.451171 0.807526 0.146612 0.741306 0.879652 0.538416 0.789395 0.835580 0.727230 1.500085 1.242144 0.634364 1.803171 1.822514 0.007316 0.582259 1.098006 1.111451 1.052686 0.268482 1.292779 0.408770 0.900978 1.129338 1.119845 0.000211 0.183560 0.409985 1.130318 0.154686 0.903140 1.250848 0.304084 0.291391 0.665312 0.134932 1.031483 1.180817 0.740031 0.591860 0.493782 0.623373 1.760510 1.738938 0.012331 1.868767 0.485398 0.081272 0.744972 1.162890 1.398893 0.348679 1.033764 1.570188 1.891519 0.983723 -0.050025 1.963561 0.683179 1.444931 1.720623 1.922344 1.346126 0.185147 0.425063 0.833788 1.212862 -0.059036 0.979852 1.030316 0.907000 1.585882 1.726983 1.272771 0.520458 -0.246594 0.841441 0.243286 0.398740 1.568681 0.966791 0.492237 1.295293 0.553432 1.719542 1.511716 0.828907 1.018781 1.032010 1.199895 1.666214 1.226917 1.062734 1.392689 0.232672 1.537926 0.453832 1.574299 1.015965 1.273439 -0.120286 1.196312 0.890951 0.947130 0.079812 0.887578 0.233129 0.272637 1.660534 0.099048 0.112940 0.379953 0.313779 0.871859 0.259424 0.974751 0.544740 0.642333 0.302637 -1.970061 0.729276 1.344147 1.146828 0.710229 0.621069 1.365003 1.840156 1.310442 1.151197 1.477337 0.559900 0.108648 0.736983 0.902099 0.115156 1.417090 0.059287 0.355397 1.408677 1.265478 0.852907 -0.030095 0.935670 1.092577 1.649094 -0.066605 0.057334 0.214826 0.920179 1.511506 0.311621 1.288626 0.990573 1.623492 -0.026333 0.306924 1.579035 1.170370 1.732023 1.379262 1.454543 0.891698 0.314877 1.693038 1.768550 0.910599 1.712155 0.945812 0.118254 1.453481 1.939489 0.720326 0.426107 1.203759 1.574972 0.592306 0.975781 0.305093 -0.166629 0.079805 0.409358 0.854323 0.437473 1.528093 0.769890 0.423876 1.508832 1.226392 -1.878260 -0.092214 1.155334 0.010793 1.006280 1.091219 0.386780 0.322578 0.667815 0.434221 1.551779 1.471623 0.419732 1.605348 0.905476 0.713039 0.202928 1.354968 1.929707 0.296628 1.021984 1.535443 0.083646 0.013591 1.615944 -0.015945 1.228774 1.545535 0.273210 1.194157 1.343078 1.185077 1.122175 0.433956 0.758581 0.690958 0.339400 1.730253 0.001977 1.448248 0.615799 0.047214 0.859970 0.772423 1.342656 0.293016 -1.937301 1.859989 1.689477 1.784597 1.602245 0.845767 1.643665 -0.004067 0.091824 1.211465 0.680110 0.230715 0.070609 1.607121 1.378560 0.381059 0.163719 0.922614 0.053089 0.596216 0.562829 1.081319 -0.048350 0.527026 1.238211 0.277364 1.357698 1.757117 1.384714 1.522857 1.368884 0.056972 0.225257 0.823227 0.584976 -1.935447 0.491177 0.763213 1.717924 0.488438 1.535602 0.456160 0.375383 0.517346 1.517261 0.749545 1.085532 0.050128 1.339560 1.741740 1.301265 1.630336 1.618351 1.672383 1.593969 0.959235 0.695771 0.230646 1.678169 0.693007 1.099661 1.490070 0.420988 1.438392 0.212033 1.272969 1.845317 1.413990)
      )

;;; 1024 even --------------------------------------------------------------------------------
#(1024 51.895 #(0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

       51.627202 #(0.000000 1.029633 -0.012293 0.012880 0.026980 0.979853 0.999814 -0.000026 0.008393 -0.008618 -0.022589 0.994746 0.002832 1.008481 0.003050 0.997875 0.996213 1.012876 0.966656 0.015767 1.000358 -0.002088 0.014429 0.990790 0.013957 1.001392 -0.004078 0.967774 1.013049 1.007123 0.985283 0.013699 0.971495 0.995694 1.026385 0.974549 0.984726 0.014450 1.020521 1.057512 -0.000030 1.035989 1.011331 -0.003193 -0.024617 1.040479 0.999058 0.999748 1.023188 0.015959 0.999918 -0.018936 0.999973 -0.023246 -0.020062 1.051671 0.022658 0.002794 0.974167 0.991086 1.010851 -0.001529 1.001922 1.036863 0.021006 0.005011 1.000699 0.000936 1.014853 0.987112 0.961076 -0.027263 -0.000447 0.965279 -0.006262 -0.009089 0.013976 0.015081 0.978343 0.998354 -0.031203 0.998879 0.993033 0.003160 1.007951 -0.029531 0.037120 0.015294 -0.004457 0.999168 0.006669 0.003518 -0.020636 0.989249 1.037455 0.983981 1.009819 0.041730 1.025735 0.004988 1.017361 0.003502 1.042945 0.015924 1.024463 0.960856 0.011509 0.010562 0.988670 0.024436 0.966800 -0.002597 -0.016676 0.022567 -0.028052 0.946179 -0.017664 1.028163 1.003919 0.001928 1.027279 -0.018987 0.026212 1.037909 0.988421 0.989442 0.020639 0.966655 1.036646 0.002339 0.008427 -0.005614 0.995024 0.983470 0.983405 0.042460 0.974342 0.994593 0.956085 0.009439 0.014059 0.004228 -0.019889 0.026260 0.974355 0.992867 -0.012583 0.984210 0.977740 1.012509 0.987531 0.000750 1.019558 0.026047 1.016442 1.035160 0.993711 -0.030273 1.002476 -0.005058 1.000699 -0.013934 0.956348 1.046660 -0.027964 0.032912 0.003031 0.977465 0.004538 0.989628 0.963685 1.010626 -0.012712 1.018052 -0.017753 1.015077 0.998898 -0.009983 0.997626 0.017615 -0.000785 0.002492 -0.012174 0.002126 -0.016138 1.012447 0.997926 0.966007 -0.013935 1.029393 -0.013026 -0.007371 1.016575 1.007787 1.056292 0.973143 -0.033484 0.035206 0.014191 -0.029943 -0.028705 0.008654 1.000375 -0.021321 0.995735 0.005904 -0.005691 0.957727 0.987992 -0.036335 0.960456 -0.001191 1.023020 0.989914 0.968869 0.041460 0.977261 -0.011659 1.009737 -0.021828 1.008003 -0.001250 0.022942 -0.048050 -0.009089 1.009767 1.043325 1.003191 0.971106 -0.021518 1.028051 -0.011409 1.025024 0.979361 1.044646 1.011438 1.010722 0.031823 -0.028157 0.983741 -0.020268 1.009392 -0.007202 0.998145 -0.026679 1.026788 -0.081497 1.010086 0.018136 -0.018995 -0.001939 0.022706 -0.023740 -0.007240 -0.012899 -0.018640 1.038529 1.020417 0.968369 0.994357 1.027397 0.000794 -0.000991 0.991696 0.031240 0.998445 1.044540 0.970462 0.026110 1.010814 1.020783 0.015899 1.018002 -0.031991 0.007949 0.001502 -0.012758 1.001363 0.004017 -0.007267 0.010560 0.013211 -0.009000 0.009694 1.014273 0.018818 -0.034834 1.028054 -0.003934 1.000986 1.002141 0.992753 -0.028723 1.028360 0.987299 -0.013088 0.996655 1.026438 1.006617 -0.029586 0.003482 0.997825 0.977397 -0.001844 0.989263 0.017137 -0.018305 -0.000071 0.035462 -0.000083 0.020862 0.961786 1.014986 -0.009066 0.004347 0.961092 0.991390 1.004558 0.027069 0.984372 -0.023434 0.988090 0.035406 -0.013962 1.041369 0.024094 0.005763 -0.024629 0.999857 0.043759 0.025275 0.984999 0.997705 0.974194 0.991177 1.004969 0.984649 0.030149 0.982526 0.026091 0.008305 0.993917 0.948422 -0.015968 0.018284 1.030583 0.048958 1.046400 0.020097 -0.041524 0.961135 0.980055 1.003964 1.036523 -0.038536 0.993082 -0.008009 0.037197 0.005452 0.985760 1.009046 0.989319 -0.023085 0.000904 0.027545 -0.000386 1.003513 -0.003653 0.001093 1.022776 0.997472 1.001837 0.009261 0.012077 0.942776 -0.005592 0.975448 0.004766 0.991773 0.016776 0.978178 -0.007370 0.982051 0.960966 1.011421 -0.023355 0.980278 0.973420 0.045377 -0.005290 0.956521 0.992809 0.027688 0.025117 -0.022656 -0.030804 -0.015162 1.036309 -0.026387 0.983041 -0.021172 0.035189 -0.027150 1.004452 0.027891 0.011484 0.034644 0.978769 0.023693 0.998483 0.986597 0.987475 0.010519 0.029762 1.001533 0.993668 -0.016914 1.024557 1.048005 0.011502 1.011339 0.994209 1.017864 0.992986 0.014354 -0.013499 0.992949 -0.060393 -0.016525 1.005615 0.984517 0.995298 0.015187 1.030776 -0.033503 0.000253 0.037666 1.025964 1.007485 0.988947 0.022461 0.006082 -0.020616 1.004962 0.012512 0.962994 -0.004937 1.011421 1.041467 1.008283 0.995643 0.971042 0.987471 0.001468 -0.007697 0.991715 1.049958 1.012746 1.035164 -0.032069 1.013038 0.006264 1.006054 0.035898 0.032052 0.963860 1.014151 0.949502 0.999608 0.009928 0.001465 1.029049 1.025787 1.026326 -0.043190 -0.007875 0.009982 0.011519 0.983107 0.005975 1.006135 -0.001058 -0.024465 1.034626 0.978896 1.011989 1.027524 1.041145 -0.025044 0.018773 0.023996 -0.011560 1.024837 -0.013806 1.002818 0.015362 1.050348 0.022866 0.962501 0.984475 0.010984 -0.010308 0.952987 0.024839 -0.026681 1.012307 1.001104 0.036619 -0.025891 0.014527 0.990542 0.011253 0.024178 1.008209 0.016545 -0.034511 0.036489 -0.014980 1.008478 0.989790 0.976929 1.025218 0.995142 0.987581 0.028634 0.033934 0.019969 -0.021838 1.028720 -0.028955 1.015472 -0.006441 -0.020510 -0.018391 0.978147 0.015688 -0.021362 0.952391 0.029016 0.001211 -0.008983 1.017301 0.981964 -0.001380 0.985470 0.022753 -0.004467 1.038918 -0.047590 1.013576 0.992650 1.023843 0.035368 0.026779 0.037419 1.014741 0.995189 0.997746 -0.034357 0.995854 0.003107 0.951826 -0.014409 0.013970 1.057036 -0.046316 0.969485 1.013522 -0.031630 0.992596 0.019914 -0.030536 0.998738 1.009072 0.042841 0.007827 -0.040331 0.996280 0.005153 0.977472 1.017287 -0.007443 1.023492 1.008942 0.976506 0.991476 0.021767 0.994859 -0.020314 0.017953 0.030219 -0.014664 1.027291 0.995978 0.994587 0.009074 0.983176 0.979563 0.026420 -0.010245 0.972168 1.035690 0.001320 0.993513 -0.006353 0.993098 1.018795 1.026884 1.026658 0.970022 0.999193 1.016983 0.979543 -0.022890 0.020692 -0.040886 1.018579 -0.011065 0.055122 0.983881 0.025346 -0.040047 1.013370 0.955646 1.036308 0.991315 0.033330 -0.025327 0.016975 0.995791 0.981244 0.961974 1.008112 1.057891 -0.001461 0.987480 0.009720 -0.026757 0.013022 0.980104 0.999666 -0.012002 -0.002490 1.031008 -0.036579 -0.019712 -0.012903 0.988206 0.016822 0.004518 1.021480 1.018658 0.022505 -0.040063 0.965796 0.967095 -0.030506 0.986755 0.009185 -0.029252 0.027913 -0.001038 0.005149 1.030725 -0.022649 -0.050486 0.985861 1.023283 -0.035330 -0.003861 -0.024807 -0.017869 1.007192 0.991993 -0.037209 -0.015099 1.024263 0.988398 1.000630 -0.011148 1.011225 1.003859 1.000624 0.027737 1.030697 -0.007960 0.015120 0.030404 1.063288 -0.015487 0.009610 0.997903 -0.014983 0.009095 0.001637 0.028463 -0.017241 0.980929 1.031302 0.957184 1.006390 -0.000930 0.026429 -0.035760 -0.008466 0.002222 1.003563 0.029085 0.031352 0.955169 0.956096 1.049753 1.023909 0.993320 1.004337 0.981836 0.009217 0.959911 0.028388 0.983865 -0.035427 -0.010471 -0.031064 -0.002590 0.956357 0.036784 -0.009809 0.991834 -0.034104 -0.018459 0.012906 0.991005 0.022404 1.021742 0.004101 -0.003005 0.999319 0.002777 0.970118 0.020836 -0.025284 1.027935 -0.012000 -0.004879 -0.034122 0.007932 1.021494 0.992149 1.020224 0.016422 1.035923 1.005921 0.970291 1.017378 1.005947 -0.036189 -0.030483 0.001790 0.032815 1.014774 0.983789 0.988084 0.023220 -0.019774 0.971264 -0.028081 -0.029889 0.992294 1.005999 0.977060 1.014232 -0.021160 -0.010988 0.959821 0.005604 0.021718 -0.021955 1.054722 -0.016545 0.964984 0.985050 0.984349 1.031167 0.974286 0.002534 0.035348 -0.012068 -0.013231 1.015785 0.023828 1.015996 -0.031622 1.005232 -0.009273 -0.019787 1.025036 -0.026464 0.006101 0.967905 1.014269 0.979093 -0.029265 -0.021119 1.021888 0.954078 0.000085 0.002622 0.994485 1.000089 0.999748 0.998280 0.023211 0.988740 -0.018255 0.960366 0.045586 -0.019498 0.008522 1.020829 1.008354 0.006514 1.022643 0.015185 0.000755 0.018782 1.014301 0.027370 -0.012785 1.014767 0.991316 1.003698 1.039078 0.005598 0.005237 1.002700 1.029163 0.004849 -0.028907 -0.023045 1.017953 0.020296 0.006471 1.017652 -0.022322 1.034186 1.027202 -0.016734 1.002485 0.047223 0.040688 0.006990 0.990955 0.022236 1.031053 -0.003084 1.020609 0.017659 0.020197 0.011235 0.962757 0.001996 1.044123 0.976238 -0.019950 1.030412 0.011057 1.017582 0.014033 0.025446 1.004206 -0.003240 0.027075 -0.007050 -0.035685 0.992859 1.011519 0.014202 0.981388 1.005139 1.004029 1.006912 1.005778 1.021140 0.983053 -0.016137 -0.014145 1.000304 0.997530 1.003746 1.049578 0.959733 0.000454 -0.009718 -0.026521 0.029837 0.007222 1.010987 0.005317 -0.030318 1.007035 -0.032687 -0.011029 0.989009 1.041889 0.982391 -0.018390 0.038156 1.006608 0.000964 0.020590 0.018089 1.004892 1.001298 0.040112 1.005506 1.015600 -0.009035 0.940825 0.000076 0.006269 0.006741 -0.012462 -0.037129 0.010208 -0.024410 -0.019642 -0.014977 -0.024707 0.990616 0.038768 0.010238 1.040880 -0.006119 -0.047665 0.986770 -0.011567 1.004318 -0.029971 1.013665 -0.022161 1.002074 0.010501 0.960155 0.984224 1.026497 -0.016095 1.010019 0.031642 0.999133 0.979670 0.000233 -0.007173 1.008576 0.977465 0.974203 0.962648 1.001036 0.999199 1.006937 1.008107 1.030886 0.032255 0.013490 1.006674 1.009720 -0.000453 0.030604 1.006832 1.002142 1.011386 -0.032413 -0.010262 1.028395 1.007678 0.997719 1.024479 0.960010 -0.004909 0.994707 -0.013372 0.977065 0.994209 0.973989 0.007180 -0.027035 0.985703 -0.005303 -0.038704 0.037271 1.004149 0.966830 1.029492 -0.024194 -0.015545 1.038917 1.042772 1.001889 0.998939 0.955875 -0.005453 0.980182 -0.007532 0.998567 0.983303 0.017570 -0.020865 -0.013117 1.027734 0.984047 0.038060 -0.007684 1.009226 -0.024667 1.000606 1.016532 0.981910 -0.010374 0.007713 1.032539 0.989510 1.024116 1.001067 0.024989 -0.020873)
       )

;;; 2048 even --------------------------------------------------------------------------------
#(2048 87.471149563312 #(0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       78.079325 #(0.000000 1.036212 -0.043685 0.331976 0.639530 1.127516 1.095152 1.508236 0.077934 1.337557 0.072113 -0.092944 0.796909 1.784824 0.440076 0.246196 1.387524 0.190896 1.640182 0.925143 0.346541 1.367537 0.178172 0.900392 1.703536 1.678208 1.753849 0.425105 0.187619 1.751892 1.898170 0.616148 1.276449 1.748534 0.146310 1.804887 0.286781 -0.064076 1.520935 0.166848 1.246710 0.087250 0.943537 1.755401 0.334485 0.490353 1.501725 1.277784 1.245080 0.471353 0.764254 1.697034 1.056331 1.736214 0.463227 0.796303 1.150866 -0.021932 0.234603 0.080694 1.745115 0.716674 0.093762 0.744119 1.143077 1.540437 1.841607 1.711093 0.867517 1.296036 1.315314 1.006884 0.239668 1.666083 1.671147 1.716928 -0.027459 1.906723 0.073560 1.255469 1.796692 0.526703 0.076840 0.934228 0.293278 0.367456 0.305891 1.422085 1.299849 1.951249 1.462008 1.040367 1.853366 0.810937 0.603550 0.848743 0.268307 1.173776 1.919876 1.102197 1.660214 1.762553 1.781211 0.633437 0.456915 0.254253 0.486765 0.536153 1.493176 0.945749 1.791455 0.934973 0.284784 1.433744 0.425334 0.064742 0.690643 1.925513 1.755950 0.618329 1.632172 -0.059593 1.375330 0.869966 1.487228 1.414963 0.333672 0.780241 1.330677 0.484533 0.218933 0.162630 0.710074 0.419557 -0.032680 0.883965 1.717277 0.430915 0.263252 1.360127 0.169506 1.343179 1.234460 1.750884 0.164361 0.378299 1.460882 0.897871 0.213904 0.128719 0.360447 0.555828 1.579900 1.051631 1.398250 1.313610 0.220306 0.871110 1.178519 1.513441 1.303728 0.802201 0.242388 1.900778 1.477677 0.067540 0.652996 0.103896 0.687602 0.914043 0.697581 0.105317 1.825200 0.024458 0.235192 0.433521 0.312835 0.809192 1.808814 0.468703 0.865854 1.628971 1.590464 1.720208 0.790391 0.109924 1.554973 -0.023990 1.192392 0.712254 -0.008308 1.166932 0.323937 0.599507 1.428804 1.009547 0.297463 1.703546 1.729917 1.681205 0.524857 1.697748 0.256667 1.120927 0.047187 1.189398 0.820638 0.699302 0.002442 1.121649 1.667851 0.869163 1.641192 0.656529 0.841409 0.057676 -0.196215 1.453792 1.886624 0.125107 0.602688 0.239635 0.436713 1.300259 1.239844 0.261666 1.553825 0.240232 0.801341 0.507041 1.560623 1.566831 1.253461 -0.062284 1.669509 1.095250 0.027748 1.068831 0.602783 1.174264 1.815938 0.796036 0.386048 1.233720 1.401215 0.759974 0.913111 1.179032 1.213203 0.938878 1.696577 0.360595 1.305400 0.044128 1.743675 1.440756 1.459247 0.623194 1.508843 1.421417 1.629960 0.477983 0.835293 -0.070334 0.708287 1.142955 0.932387 1.813043 1.382192 0.381127 0.190410 0.729845 0.321732 0.824558 -0.020023 1.607442 0.200267 0.318647 0.044651 1.768240 0.643757 1.206201 1.468765 0.601437 1.706259 0.495261 0.956913 0.394710 1.176569 0.800067 1.886558 1.605179 1.122676 1.144265 1.561625 0.181947 1.309849 1.577300 0.495188 1.655610 1.180832 1.194001 0.875913 0.228611 1.639141 0.550083 1.839287 0.580971 -0.197365 0.327613 1.901067 0.522438 1.020637 1.267341 1.342859 0.445176 0.112095 0.457659 0.120276 0.250883 1.204237 1.402798 1.271260 1.255292 0.578618 1.686129 0.490946 1.771289 1.121957 0.127348 0.581481 0.812819 1.448200 -0.003892 -0.044962 0.952367 1.033247 -0.085086 0.150310 0.057854 1.842500 0.716853 0.935519 0.269127 1.299626 0.388259 0.164338 1.057650 1.178504 1.241059 0.565924 1.615325 0.390452 0.686889 1.489199 0.183366 1.767188 1.365040 1.248231 1.196393 0.220573 0.358798 0.163202 1.499695 1.793435 -0.212597 0.677471 0.562186 1.706417 0.638842 0.138384 1.541313 1.495553 1.825920 1.099565 0.289989 1.936921 0.388891 1.617689 0.315048 0.242499 1.724502 0.758918 0.479832 0.306301 1.154626 1.015534 1.286300 0.819723 0.897789 1.897385 0.811133 1.198870 -0.023538 1.581550 1.752737 0.752872 1.653243 1.098279 0.913859 0.290667 0.391090 0.448864 1.747363 1.628653 1.296395 1.685456 0.410609 0.613612 0.229500 1.978170 0.563390 1.684018 1.175413 1.421149 0.835252 1.423949 1.519247 0.020578 0.410433 0.532037 1.105479 1.305389 0.747326 0.273148 1.468421 1.561328 1.045465 0.300840 1.851806 1.623959 -0.020047 0.551127 0.952587 1.750489 0.425896 1.297055 1.252366 0.774082 0.008302 0.830022 0.354751 1.630433 0.527393 0.320074 0.992472 1.329100 0.937461 -0.124987 0.528489 0.860443 1.777412 -0.179698 1.649835 1.523675 0.255615 0.752546 1.044250 1.061394 1.473542 1.559139 1.750843 0.228407 0.244978 0.318506 0.214338 -0.127687 0.016065 1.683527 1.059087 1.084321 1.209844 1.162599 1.700206 1.028836 1.111259 0.965422 1.349098 0.449160 1.236238 1.152610 1.241247 0.441411 1.200500 1.575948 0.056337 0.109621 0.678763 1.605571 1.462870 0.670350 1.160814 0.178948 1.776617 0.814727 1.471143 0.666341 0.666497 0.003085 0.367263 1.764549 1.817682 0.565043 0.256262 0.744401 0.069362 0.856509 1.798907 0.484543 1.036560 1.448462 1.009617 0.983445 0.719152 0.713983 1.197878 0.928722 0.442562 0.632379 1.311255 1.163303 1.389071 0.013803 1.283658 0.183551 0.216748 0.742490 0.246195 0.580366 1.004491 0.032852 1.729133 1.159382 1.701779 0.944042 1.827589 0.917849 1.400392 1.223004 1.113159 0.052572 0.168081 1.615230 1.221824 1.526728 1.850771 -0.240328 1.487522 1.159816 1.866293 1.698164 0.013835 -0.093167 0.180008 0.018965 1.603158 1.613742 1.313466 1.035280 1.492647 0.815996 0.391557 1.242014 0.993247 1.401424 0.488225 0.393455 0.894952 0.309407 0.321448 0.558471 0.718740 1.467551 0.500281 0.439320 1.869730 1.364530 1.553036 0.969732 1.636285 1.798396 1.363995 0.920638 0.126592 0.286258 1.696296 0.331371 0.356812 0.490460 1.101761 0.373647 0.097306 0.453078 1.827015 0.179707 -0.019918 -0.106312 0.084833 1.193623 0.408083 0.143266 0.206533 1.082562 0.158416 0.854906 0.878107 0.339914 0.457130 0.154799 0.176600 0.085438 0.131041 0.453107 0.593969 0.303633 0.916178 1.161798 1.896318 0.930094 0.986481 1.688216 0.819416 1.265892 0.011344 0.265144 0.267354 1.189048 0.659992 1.171202 1.786897 0.902370 -0.041938 0.785186 0.246222 1.558295 1.890657 1.369584 1.616357 1.670144 1.849685 1.342838 1.757000 1.172827 0.103451 0.032886 1.109693 0.659929 0.371860 1.404352 1.477883 1.155474 0.555608 0.969331 0.650971 1.813202 1.603915 0.999884 1.494172 1.882922 1.689689 1.690194 0.705259 1.560645 1.081311 0.825846 1.685601 0.689103 0.269731 0.147349 0.167554 0.803327 0.198449 1.282138 1.170132 0.901085 1.709183 0.934868 1.972921 0.385259 1.488122 0.118213 1.387825 0.546603 0.472410 0.223942 0.792440 1.272964 0.539143 1.056110 0.965279 1.256909 0.069278 0.438772 0.688522 1.474529 1.518833 0.647516 1.850584 -0.061940 1.420599 1.301753 0.184502 0.147262 0.261775 0.575331 1.308330 1.224554 0.672189 0.758277 1.191895 1.228368 0.130276 0.482407 1.350231 1.750711 0.397622 1.713381 1.011249 0.522822 1.072918 1.821285 0.965512 0.063639 0.566385 1.807346 1.175784 1.223074 1.591887 -0.168041 0.271021 1.529439 0.521842 0.823001 0.940921 1.684294 0.286489 1.242930 1.937690 0.607200 0.275302 1.790606 0.491021 1.035487 -0.045868 0.085148 1.238065 1.129382 -0.053312 1.545108 0.434470 0.810550 1.100562 0.221267 1.037507 1.624758 1.555603 1.062386 0.144378 0.886916 0.149410 -0.066826 1.113563 0.490079 0.634885 0.842660 0.061321 1.725263 1.823881 0.115290 1.146242 0.979557 1.530480 0.067327 0.568197 0.897626 0.771983 0.563170 1.194766 0.655189 1.549104 1.322518 0.483177 0.760693 1.010138 0.534980 0.223935 1.152460 1.731132 1.519096 0.446488 1.420973 1.696386 1.157486 1.211136 1.546897 1.232762 1.175520 0.355595 1.525833 -0.042267 1.352048 0.992497 -0.093673 0.742530 0.634885 -0.089066 0.868194 0.573537 1.674126 0.329153 1.158907 1.178480 0.551158 1.486852 -0.071558 0.725909 1.395015 1.209212 0.379942 0.747225 0.444854 0.946742 1.211242 1.139390 1.010957 1.097783 0.203142 1.127162 1.614090 1.772287 0.331896 1.598023 1.816077 0.662803 1.330979 0.944114 1.383701 0.797215 1.196402 1.084443 1.184444 1.682543 1.168272 1.958979 -0.058496 0.841894 1.219141 1.365510 0.769766 1.232995 0.960628 1.742029 1.659964 0.361424 0.247996 1.622047 1.491439 1.012850 0.556413 0.070470 1.055118 0.709469 1.227676 1.050289 1.817507 1.250045 0.044881 -0.105998 0.360108 0.510639 -0.000754 0.913624 0.014253 0.869683 0.815496 -0.043945 1.463465 1.037174 0.323537 0.584260 1.687824 0.186494 1.408948 0.905638 1.501561 1.450375 1.647727 1.343515 0.997551 0.097973 0.620795 0.473197 0.975124 1.453483 0.888388 0.452833 1.689714 0.696728 0.633683 0.509294 1.106199 0.373384 1.699003 1.169996 0.082561 0.289835 0.757159 1.514061 1.528786 0.435419 0.161517 0.726914 1.380867 1.654754 0.604942 0.070114 0.541874 1.167294 1.310511 1.570194 0.673809 1.267196 0.489289 1.272471 1.573227 1.458789 0.530304 0.456318 1.679920 1.109017 0.240982 1.697797 0.777016 0.870109 1.599744 1.746059 0.193197 0.572600 1.617885 0.423393 0.264299 1.931463 0.929567 1.333438 0.553075 0.123102 0.783267 1.986789 1.667679 1.525086 1.102518 0.117178 0.013899 0.476557 1.428021 1.781881 0.479378 1.440749 0.433516 0.176847 1.747379 1.328355 0.058455 1.628266 1.215447 1.600718 0.965239 1.219616 1.227710 0.034900 1.335400 0.576945 0.169250 1.234608 1.110724 1.740429 1.656377 0.259109 1.608270 0.156542 0.335333 0.895697 -0.078619 0.093744 0.937474 0.090269 0.752748 0.885184 1.935435 1.556700 1.833155 0.379459 1.439350 0.281834 1.377687 1.469181 0.560304 0.350829 0.370361 0.413143 1.546821 1.107825 0.763796 1.687563 0.219324 0.055037 -0.020128 1.641061 1.731840 1.877911 1.717828 1.356597 1.730658 0.588868 0.835297 0.297291 0.088419 0.412212 1.415406 1.017343 1.423175 0.375775 1.302219 0.953702 0.678804 1.572374 1.727477 0.254556 1.094641 1.162163 0.143319 0.854688 1.063038 0.441476 1.282254 1.589355 0.648429 0.822071 1.490818 0.276396 1.213776 0.318534 1.167492 0.713979 0.593799 1.038818 1.843043 0.450884 1.098196 1.002340 1.751110 1.258344 0.802075 0.796882 0.068028 0.990778 1.404822 0.767441 0.258966 0.014912 0.397819 1.169281 0.671758 0.828982 0.684022 1.483627 0.060148 0.140681 0.965311 1.046164 1.448760 0.937335 0.043049 1.426389 0.175311 0.942467 1.289194 0.705897 0.195736 1.367220 0.481110 1.117710 0.026294 1.480040 1.701576 0.741539 0.129438 1.793396 0.216626 0.338432 1.293825 1.852766 0.567380 0.675267 1.660257 1.295361 0.379806 0.115345 0.037783 0.635233 0.390593 0.891898 1.623418 1.141114 0.967319 0.436616 1.163548 1.438313 1.028606 1.507879 0.276194 1.126750 1.086763 0.657033 -0.091488 1.327256 1.184128 1.357378 0.116523 1.532550 0.455893 1.613945 0.808970 0.183575 0.288911 -0.057175 0.416408 1.883558 1.036690 -0.004024 1.155543 0.908210 0.958228 0.735059 -0.149409 -0.109242 1.993416 0.061976 0.994397 0.312822 0.358556 0.357396 0.166228 1.906441 1.936369 1.954589 1.571014 0.719233 0.153949 0.028336 1.320995 1.240948 0.545995 1.805452 1.619213 0.231489 1.707803 0.618275 0.642514 1.471382 1.348917 1.095451 0.221991 0.792513 0.689445 1.882995 1.365514 1.063222 1.950163 0.465549 0.519653 0.736476 1.311946 1.452773 1.442715 1.517899 0.924450 -0.258534 0.766737 0.924843 0.502570 1.115330 1.657088 0.120016 1.780444 1.686548 0.035927 0.449644 0.309346 1.622740 0.581408 0.299807 1.408994 0.611973 0.764394 0.604130 1.299785 1.686040 1.006944 0.701090 1.243781 0.213973 0.887207 1.233295 1.666529 0.235283 1.402144 1.228392 0.531790 0.502582 1.344011 1.047300 1.113632 0.075538 1.422393 1.570034 1.313722 0.186419 0.938804 1.688331 0.356313 1.160071 1.677615 0.597077 0.892649 1.278418 1.866713 0.634605 1.131045 1.247527 0.323580 1.122900 0.478811 0.712857 0.778489 0.733910 0.492143 1.681476 0.182306 0.475863 1.491278 0.187728 0.437657 0.198048 1.236439 0.268664 0.149327 0.934080 1.438262 1.896760 0.457386 0.548858 1.210218 1.289090 1.057745 0.668857 1.173530 0.693912 1.373334 0.504490 1.774419 1.309479 0.081305 1.710946 1.383983 0.433639 0.367597 0.598191 0.968980 0.477561 1.759027 0.625170 1.727969 1.718828 0.634164 0.574901 1.059254 0.056017 0.516804 0.253417 0.694276 1.806842 1.251926 1.330344 0.582436 0.789520 1.835852 0.867891 1.822064 1.359273 0.296168 0.365411 0.131864 0.093576 0.901545 1.224841 -0.103847 0.409143 1.472189 1.522564 0.937037 0.936778 0.858129 0.405727 0.803283 0.405592 1.621314 0.477697 1.071232 1.490250 0.210905 0.388916 0.148961 0.484107 0.248858 0.677626 1.216797 1.366933 0.495657 1.673293 0.762780 1.143691 1.830348 0.353612 0.038958 1.687620 0.671154 0.712933 1.807885 1.122232 1.188992 1.701760 0.242220 1.603391 0.699724 1.054033 0.076868 1.632921 1.612600 0.087130 0.365903 0.458822 1.024159 1.354588 0.392699 1.423641 1.204423 1.164681 1.649578 1.256031 1.243822 1.042854 0.005560 1.024514 0.604398 0.680137 1.912453 0.670310 0.213643 0.446770 1.090682 1.474974 1.806865 0.764624 1.563431 0.473634 0.510617 1.001005 1.364194 0.537668 -0.014680 0.885588 -0.005747 1.738242 1.410596 1.602084 0.734862 1.493989 1.349989 0.406916 1.170482 -0.017990 1.034213 0.634019 1.456131 0.974789 -0.144669 1.737158 -0.037172 1.400515 1.623550 0.499450 1.479595 0.507050 1.358218 0.582744 1.475859 0.513808 1.600273 1.836597 1.059912 -0.072725 1.290524 -0.073595 1.937918 0.300206 0.119306 1.027133 -0.093444 0.011477 1.127890 1.399417 1.853798 1.657887 0.145866 0.588742 0.873359 0.762305 1.639168 0.778598 0.019634 1.817733 0.156595 0.169164 1.530459 1.438248 0.803585 -0.094272 0.468694 0.847016 0.311870 0.299559 0.551763 0.793044 1.160950 0.697742 1.837771 0.754430 1.758952 0.505686 1.737258 0.020417 1.293145 1.675271 0.394950 0.929538 0.720083 0.978614 0.784199 0.905034 0.921702 0.937761 1.562150 1.166453 1.603212 0.260741 0.602140 1.673881 0.673664 1.946860 1.010728 1.288978 1.297659 1.198620 0.504487 1.420515 1.576870 0.975311 1.683510 1.543454 1.716402 0.940588 1.162463 1.651787 0.589731 0.285012 0.638073 1.089187 1.489366 0.491525 1.435921 1.014411 1.601370 0.949407 1.694644 0.959875 -0.062780 -0.004119 1.163389 0.589582 1.149178 1.817933 0.849953 1.802695 1.461496 1.665429 1.837845 0.976053 0.862346 0.530923 0.811633 0.503788 -0.027013 1.611602 0.057407 0.611054 1.824034 0.259920 0.148035 0.105941 -0.021158 1.835611 1.319838 1.754236 1.193537 1.357026 0.094401 1.491186 0.366416 1.555586 1.669437 0.823707 1.243186 0.432020 1.052515 0.858115 1.022105 0.954847 1.455406 1.318994 0.283690 1.211015 0.710161 0.270613 1.714336 1.101135 0.235311 1.092475 1.008566 0.447003 0.602655 0.757184 0.009064 0.530056 1.724465 0.607925 1.121575 1.099024 0.882158 0.934761 0.125447 0.972944 0.967420 1.343086 0.315752 1.165505 1.109567 1.918061 1.478347 0.850704 0.940172 0.696083 0.793045 1.211155 0.866708 0.135821 0.480730 1.058685 0.463469 0.583533 1.522858 0.588384 0.353159 1.576867 1.754930 0.850029 1.919190 1.543405 0.995776 0.821301 1.793940 1.151072 -0.047846 1.508846 1.746284 0.877808 0.214307 0.787802 -0.003151 1.141139 1.698635 0.232169 1.093325 1.515191 0.901564 1.506350 0.135967 1.384636 -0.242650 0.302616 1.608186 0.459148 0.023364 0.249132 1.086552 0.992569 1.132819 0.061330 1.433907 1.539244 0.001712 1.876374 1.299743 1.030055 0.164439 0.092647 0.881217 1.088556 1.351722 -0.088421 0.062334 -0.051555 1.260415 0.983686 0.258617 0.860731 0.793959 0.416831 1.721077 0.095305 0.351122 0.421061 1.074247 -0.008811 1.438063 1.858745 1.305784 0.273960 1.682787 1.279785 0.274409 1.389220 0.882641 1.632991 1.590305 0.893791 0.055411 1.041678 1.451974 0.782716 0.213219 0.208404 1.139321 0.013312 0.073161 1.595535 1.686000 1.590328 0.023294 0.960934 0.758890 0.838775 1.710621 1.483697 1.281650 1.870804 0.139547 0.420537 0.308122 0.843944 0.520105 0.603303 -0.123864 1.234056 1.586800 0.927689 1.817960 1.506645 1.174470 0.276079 0.650528 0.932391 1.014056 0.664840 1.016866 1.426511 0.276789 0.219182 -0.115031 -0.164867 0.961712 0.416951 1.540063 0.375102 1.075987 1.313615 1.096641 0.764154 1.064504 0.355545 1.636517 0.212986 0.487153 0.606986 0.525136 0.094256 1.722629 0.854306 0.459009 1.050404 0.099495 1.863554 1.019865 1.702596 1.229915 1.749507 0.590639 0.164343 1.868513 1.170840 1.017598 0.404087 1.088319 0.595386 0.693810 1.531079 -0.137773 0.882791 1.035974 1.610308 1.572178 1.281505 1.448052 1.385965 0.085841 0.156089 1.020082 1.499413 1.367482 1.202166 -0.310324 1.093902 0.466865 0.481107 0.055940 1.626791 0.579934 0.932207 0.524863 0.771645 1.410464 1.781815 0.875062 1.565260 0.492144 0.931433 0.731301 0.464124 0.688570 0.033927 0.659049 -0.144339 1.390582 0.216364 1.564810 1.784761 0.542130 1.644616 0.892364 0.103014 1.151370 0.406893 0.685594 0.203695 0.116843 1.116841 0.017775 1.255535 0.180776 1.604852 1.357176 0.844518 1.917543 0.710840 0.586218 -0.084711 0.326304 0.583894 0.000981 1.527582 0.764193 0.691981 1.254365 0.042940 0.799959 1.234613 0.912676 1.261576 1.804612 1.772885 1.638278 1.452687 1.856363 1.017673 1.335012 1.093288 1.791716 0.240760 1.583614 0.215117 1.054497 1.759230 1.720795 1.725051 0.719870 1.536084 0.793019 0.072407 1.612325 0.603805 0.749790 0.930307 1.444787 0.076331 0.716031 0.751130 1.730048 1.119736 1.740692 1.642864 1.211815 0.613767 1.280443 0.196315 0.724783 0.377146 1.066938 1.497331 1.166708 1.287064 1.948271 1.408327 0.113842 -0.199587 0.630400 0.343945 1.153303 0.303357 -0.235653 1.575467 1.304018 0.481724 0.321926 1.036142 1.030288 0.337553 0.573686 1.834042 0.718673 0.182114 0.139978 0.253556 1.503381 0.215937 1.358417 0.238777 1.828073 0.206519 0.338254 0.358048 1.340274 1.144155 0.382861 -0.237688 1.081990 0.287210 0.604778 0.308728 1.486981 0.684669 1.827156 0.478181 1.795964 1.220849 1.367205 0.507990 0.995111 0.581857 0.196941 1.401782 0.618658 0.678201 1.941176 0.922033 0.346514 1.451221 1.191571 0.812039 0.176868 0.358644 0.856782 1.053754 0.172649 -0.008915 0.891004 1.275467 1.965871 1.446554 1.059213 1.698536 0.639863 1.290197 1.301277 0.460338 0.904108 1.206822 1.204141 0.172712 1.004515 0.611142 0.640455 1.099407 0.564655 0.577778 1.778285 0.167018 0.507458 0.762661 0.259884 0.066707 0.947613 0.965715 0.752844 0.822051 1.036867 1.496747 1.109711 1.909353 0.600886 1.668852 1.668992 -0.160977 0.189295 1.475624 0.412875 0.557318 1.130005 0.439886 1.255571 1.411751 0.901388 0.499673 1.791033 0.684314 -0.123345 1.518751 0.858235 1.779307 0.897544 1.242344 1.789823 1.117474 0.471404 0.148429 0.200067 1.627870 1.184473 1.258861 1.514572 1.105948 0.122797 0.601905 0.937069 0.692200 1.745527 1.038032 0.377653 0.204106 1.113841 0.997556 1.126370 0.095557 1.147967 0.559979 1.673772 1.556295 0.142426 1.654656 0.686755 0.114523 1.891052 1.870233 0.340505 0.325592 1.788001 1.691946 1.832371 0.254110 -0.056957 0.552635 0.359382 1.244098 0.331889 0.956126 1.636252 0.526733 1.070660 0.740225 1.503924 0.042864 0.662653 0.013249 0.159303 0.325720 0.297550 0.820869 1.730514 0.000052 0.161939 0.357257 0.877505 1.576861 1.847738 0.044951 0.597694 1.584933 -0.105788 1.430351 0.083180 1.563544 1.130148 1.599446 1.171509 0.524299 0.631284 0.480371 1.906399 0.915214 1.139324 0.334117 1.299283 0.373882 0.383787 0.345985 1.171992 0.720625 1.314793 1.338926)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


#|
  (with-sound (:channels 2 :clipped #f)
    (let* ((n 24)
	   (c-phases (vct 1/2 1/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 1/2 1/2 1/2 3/2 3/2 3/2 3/2 3/2 1/2 3/2 1/2 1/2 3/2 1/2))
	   (s-phases (vct 0 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1))
	   
	   ;; n amp phase

	   (cos-phases (make-vct 72))
	   (sin-phases (make-vct 72)))

      (do ((i 0 (+ i 3))
	   (j 0 (+ j 1)))
	  ((= i 72))
	(set! (cos-phases i) (+ j 1))
	(set! (sin-phases i) (+ j 1))
	(set! (cos-phases (+ i 1)) 1.0)
	(set! (sin-phases (+ i 1)) 1.0)
	(set! (cos-phases (+ i 2)) (* pi (c-phases j)))
	(set! (sin-phases (+ i 2)) (* pi (s-phases j))))

      (let ((gen1 (make-polyoid 100.0 cos-phases))
	    (gen2 (make-polyoid 100.0 sin-phases)))
	(run 
          (do ((i 0 (+ 1 i)))
              ((= i 88200))
	    (outa i (polyoid gen1 0.0))
	    (outb i (polyoid gen2 0.0)))))))

(set! (mus-rand-seed) (current-time))
(set! (print-length) 1000000)

(define (vector-find-if func vect)
  (let ((len (vector-length vect))
	(result #f))
    (do ((i 0 (+ i 1)))
	((or (= i len)
	     result)
	 result)
      (set! result (func (vect i))))))

(define low-primes (vector 1
       2       3       5       7      11      13      17      19      23 
      29      31      37      41      43      47      53      59      61 
      67      71      73      79      83      89      97     101     103 
     107     109     113     127     131     137     139     149     151 
     157     163     167     173     179     181     191     193     197 
     199     211     223     227     229     233     239     241     251 
     257     263     269     271     277     281     283     293     307 
     311     313     317     331     337     347     349     353     359 
     367     373     379     383     389     397     401     409     419 
     421     431     433     439     443     449     457     461     463 
     467     479     487     491     499     503     509     521     523 
     541     547     557     563     569     571     577     587     593 
     599     601     607     613     617     619     631     641     643 
     647     653     659     661     673     677     683     691     701 
     709     719     727     733     739     743     751     757     761 
     769     773     787     797     809     811     821     823     827 
     829     839     853     857     859     863     877     881     883 
     887     907     911     919     929     937     941     947     953 
     967     971     977     983     991     997    1009    1013    1019 
    1021    1031    1033    1039    1049    1051    1061    1063    1069 
    1087    1091    1093    1097    1103    1109    1117    1123    1129 
    1151    1153    1163    1171    1181    1187    1193    1201    1213 
    1217    1223    1229    1231    1237    1249    1259    1277    1279 
    1283    1289    1291    1297    1301    1303    1307    1319    1321 
    1327    1361    1367    1373    1381    1399    1409    1423    1427 
    1429    1433    1439    1447    1451    1453    1459    1471    1481 
    1483    1487    1489    1493    1499    1511    1523    1531    1543 
    1549    1553    1559    1567    1571    1579    1583    1597    1601 
    1607    1609    1613    1619    1621    1627    1637    1657    1663 
    1667    1669    1693    1697    1699    1709    1721    1723    1733))

(define (get-fft-size choice n1)
  (let ((n (if (eq? choice :all) n1
	       (if (not (eq? choice :prime)) (* 2 n1)
		   (low-primes n1)))))
    (min (expt 2 16) 
	 (expt 2 (ceiling (/ (log (* n 64)) (log 2)))))))

(define (random n)
  (if (rational? n)
      (mus-irandom n)
      (mus-frandom n)))

(define pi2 (/ pi 2))
(define data-file "test.data")

(define (save-case n choice peak phases)
  (let ((fd (open-output-file data-file "a")))
    (format fd "~%;~A: ~A ~A #(" n choice peak)
    (do ((m 0 (+ 1 m)))
	((= m n))
      (if (zero? (phases m))
	  (format fd "0")
	  (format fd "1"))
      (if (< m (- n 1))
	  (format fd " ")))
    (format fd ")~%")
    (close-output-port fd)))

(define (try-any)
  (let ((choice (let ((v (random 4)))
		  (case v
		    ((0) :all)
		    ((1) :even)
		    ((2) :odd)
		    (else :prime))))
	(n (+ 24 (random 104))))
    (let* ((size (get-fft-size choice n))
	   (tries (if (not (eq? choice :prime)) 2500000 500000))
	   (fft-rl (make-vct size))
	   (fft-im (make-vct size)))

      (format #t ";~D ~A~%" n choice)

      (let* ((cur-min 1000.0)
	     (phases (make-vct n 0.0)))
	(let ((min-val (vector-find-if (lambda (val)
					 (and val
					      (vector? val)
					      (= (val 0) n)
					      (let ((a-val (val 1))
						    (a-len (vector-length val)))
						(do ((k 2 (+ 1 k)))
						    ((= k a-len))
						  (if (and (number? (val k))
							   (< (val k) a-val))
						      (set! a-val (val k))))
						a-val)))
				       (if (eq? choice :all)
					   noid-min-peak-phases
					   (if (eq? choice :odd)
					       nodd-min-peak-phases
					       (if (eq? choice :even)
						   neven-min-peak-phases
						   primoid-min-peak-phases))))))
	  (if (and (number? min-val)
		   (< min-val cur-min))
	      (set! cur-min min-val)))

	(let ((nc (if (eq? choice :all) 0
		      (if (eq? choice :odd) 1
			  (if (eq? choice :even) 2 3)))))

	  (run 
	   (lambda ()

	     (do ((try 0 (+ 1 try)))
		 ((= try tries))
	       (do ((i 1 (+ 1 i)))
		   ((= i n))
		 (if (> (random 1.0) 0.5)
		     (set! (phases i) pi)
		     (set! (phases i) 0.0)))
	       (clear-array fft-rl)
	       (clear-array fft-im)
	       
	       (do ((k 0 (+ k 1)))
		   ((= k n))
		 (let ((phi (+ (phases k) pi2))
		       (bin (if (= nc 0) (+ k 1)
				(if (= nc 1) (+ 1 (* k 2))
				    (if (= nc 2) (max 1 (* k 2))
					(low-primes k))))))
		   (set! (fft-rl bin) (cos phi))
		   (set! (fft-im bin) (sin phi))))
	       
	       (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
		 (if (< peak cur-min)
		     (begin
		       (save-case n choice peak phases)
		       (format #t ";~A: ~A ~A #(" n choice peak)
		       (do ((m 0 (+ 1 m)))
			   ((= m n))
			 (if (zero? (phases m))
			     (format #t "0")
			     (format #t "1"))
			 (if (< m (- n 1))
			     (format #t " ")))
		       (format #t ")~%")
		       (set! cur-min peak))))
	       )))))))

  (set! (mus-rand-seed) (current-time))
  (try-any))

(define* (try-all (num-threads 2) (data "test.data"))
  (set! data-file data)
  (let ((threads '()))
    (do ((i 0 (+ i 1)))
	((= i num-threads))
      (set! threads (cons (make-thread try-any) threads)))
    (for-each 
     (lambda (thread) 
       (join-thread thread))
     threads)))

;;; then once a new local minimum is found,
(define (optit choice n)
  (let* ((size (get-fft-size choice n))
	 (fft-rl (make-vct size))
	 (fft-im (make-vct size)))

      (let* ((phases (make-vct n 0.0))
	     (min-phase 0.0)
	     (min-phases (make-vector n 0)))
	(let* ((min-val (vector-find-if (lambda (val)
					  (and val
					       (vector? val)
					       (= (val 0) n)
					       (let ((a-val (val 1))
						     (a-len (vector-length val))
						     (a-data (val 2)))
						 (do ((k 3 (+ 1 k)))
						     ((= k a-len))
						   (if (and (number? (val k))
							    (< (val k) a-val))
						       (begin
							 (set! a-val (val k))
							 (set! a-data (val (+ k 1))))))
						 (list a-val a-data))))
					(if (eq? choice :all)
					    noid-min-peak-phases
					    (if (eq? choice :odd)
						nodd-min-peak-phases
						(if (eq? choice :even)
						    neven-min-peak-phases
						    primoid-min-peak-phases)))))
	       (cur-min (car min-val))
	       (cur-phases (cadr min-val)))

	  (set! min-phase cur-min)
	  ;(format #t "~A ~A: ~A~%" choice n cur-min)

	  (let ((nc (if (eq? choice :all) 0
			(if (eq? choice :odd) 1
			    (if (eq? choice :even) 2 3))))
		(inc 1))

	    (do ()
		((> inc 1))

	      (do ((i 1 (+ i 1)))
		  ((= i n))
		(let ((old-val (cur-phases i)))
		  (do ((k 0 (+ k 1)))
		      ((> k inc))
		    (if (not (= old-val (/ k inc)))
			(begin
			  (set! (cur-phases i) (/ k inc))

			  (clear-array fft-rl)
			  (clear-array fft-im)
	       
			  (do ((m 0 (+ m 1)))
			      ((= m n))
			    (let ((phi (+ (* pi (cur-phases m)) pi2))
				  (bin (if (= nc 0) (+ m 1)
					   (if (= nc 1) (+ 1 (* m 2))
					       (if (= nc 2) (max 1 (* m 2))
						   (low-primes m))))))
			      (set! (fft-rl bin) (cos phi))
			      (set! (fft-im bin) (sin phi))))
	       
			  (let ((peak (vct-peak (mus-fft fft-rl fft-im size -1))))
			    (if (< peak min-phase)
				(begin
				  (do ((m 0 (+ 1 m)))
				      ((= m n))
				    (set! (min-phases m) (cur-phases m)))
				  (set! min-phase peak))))

			  (set! (cur-phases i) old-val))))))

	      ;(format #t "~D: ~A~%" inc min-phase)

	      (if (< min-phase (- cur-min .001))
		  (begin
		    (do ((m 0 (+ m 1)))
			((= m n))
		      (set! (cur-phases m) (min-phases m)))
		    (set! cur-min min-phase)
		    (if (= inc 1)
			(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)))
		  (begin
		    (set! inc (* inc 2))))))


	  ;(format #t ";~A: ~A ~A ~A~%" n choice cur-min cur-phases)
	  ))))
|#



(define (tstodd phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstoddderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 2)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (tstall phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallf mult phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (if (= k (- len 1))
	      (set! val (+ val (* mult (sin (+ (* j x) (* pi (phs k)))))))
	      (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tsteven phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstprime phs)
  (let ((len (vector-length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (primes k) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallderiv x phs) 
  (let ((sum 0.0)
	(len (vector-length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 1)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (get-best choice n)

  (define (vector-find-if func vect)
    (let ((len (vector-length vect))
	  (result #f))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       result)
	   result)
	(set! result (func (vect i))))))

  (vector-find-if (lambda (val)
		    (and val
			 (vector? val)
			 (= (val 0) n)
			 (let ((a-val (val 1))
			       (a-len (vector-length val))
			       (a-data (val 2)))
			   (do ((k 3 (+ 1 k)))
			       ((= k a-len))
			     (if (and (number? (val k))
				      (< (val k) a-val))
				 (begin
				   (set! a-val (val k))
				   (set! a-data (val (+ k 1))))))
			   (list a-val a-data))))
		  (if (eq? choice :all)
		      noid-min-peak-phases
		      (if (eq? choice :odd)
			  nodd-min-peak-phases
			  (if (eq? choice :even)
			      neven-min-peak-phases
			      primoid-min-peak-phases)))))

(define (get-worst-overall choice choices)
  (let ((diffs (make-vector 116))
	(total 0.0)
	(this 0.0)
	(last 0.0)
	(next 0.0)
	(choice-list '())
	(first (car (get-best choice 11))))
    (set! this first)
    (set! next (car (get-best choice 12)))
    (do ((i 12 (+ i 1)))
	((= i 128))
      (set! last this)
      (set! this next)
      (set! next (car (get-best choice (+ i 1))))
      (set! (diffs (- i 12)) (cons i (+ (- this last) (- this next))))
      (set! total (+ total (abs (- this last)))))
    (sort! diffs (lambda (a b)
		   (> (cdr a) (cdr b))))
    (do ((i (- choices 1) (- i 1)))
	((< i 0))
      (let ((c (diffs i)))
	(set! choice-list (cons (diffs i) choice-list))))

    (list choice-list (- (+ total first) this)))) ; first to this would be a straight line



(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results '()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall #(0.0 0.1 0.2 0.3))) #(0.0 0.1 0.2 0.3))
;;; 3.49630991 #(0.0 1.1 0.2 1.3)
;;; 3.49630680 #(0.0 1.9 1.8 1.7)
;;; 3.49630979 #(0.0 0.9 1.8 0.7)

(set! (print-length) 123123)

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadr (car other-mins)))
	    (pk3 (cadr (cadr other-mins)))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (car (car other-mins)) (car data))) .001)
		(> (abs (- (car (cadr other-mins)) (car data))) .001)
		(> (abs (- (car (caddr other-mins)) (car data))) .001))
	    (format #t "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format #t "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (car data)
		  (list-ref phases 0)
		  (list-ref phases 1)
		  (list-ref phases 2)
		  (list-ref phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42,  0.576  
;; 1 Apr 5405.890, 0.575
;; 1 May 5138.261, 0.562
;; 1 Jun 5061.829, 0.558
;; 1 Jul 4669.101, 0.540
;; 1 Aug 4633.454, 0.539
;; 1 Sep 4616.517, 0.538
;; 1 Oct 4592.994, 0.537
;; 1 Nov 4560.903, 0.536
;; 1 Dec 4541.710, 0.535
;; (10)
;; 1 Jan 4360.644, 0.527
;; 1 Feb 4292.451, 0.524
;; 1 Mar 4280.782, 0.524
;; 1 Apr 4272.964, 0.523
;; 1 May 4267.719, 0.523
;; 1 Jun 4261.356, 0.523

;    all 0.4861 (20) to 0.5076 (94), dist: 6.3076
;    odd 0.4821 (11) to 0.5092 (125), dist: 12.0591
;    even 0.5158 (64) to 0.5244 (22), dist: 86.9326
;    prime 0.5449 (24) to 0.5712 (117), dist: 288.4718

;    all 0.4861 (20) to 0.5070 (94), dist: 5.6759
;    odd 0.4821 (11) to 0.5061 (119), dist: 7.2783
;    even 0.5158 (64) to 0.5244 (22), dist: 86.5343
;    prime 0.5449 (24) to 0.5712 (117), dist: 288.4718



;(test-all-phases #f) in test-phases.scm

;all peaks... Mon 31-May-2010 04:17
;all 512: peak-phases value: 31.391244, current: 31.393507890848, diff: 0.0022638908477184
;all 1024: peak-phases value: 49.867216, current: 49.863543040531, diff: -0.0036729594690925
;odd peaks... Mon 31-May-2010 05:20
;odd 2048: peak-phases value: 78.937441, current: 78.931916185936, diff: -0.0055248140642448
;even peaks... Mon 31-May-2010 06:17
;even 256: peak-phases value: 21.147051, current: 21.149844044205, diff: 0.0027930442051805
;even 512: peak-phases value: 31.628149, current: 31.625265493922, diff: -0.0028835060781311
;even 1024: peak-phases value: 51.627202, current: 51.61731817532, diff: -0.0098838246798678
;even 2048: peak-phases value: 78.079325, current: 78.055349684919, diff: -0.023975315080548
;prime peaks... Mon 31-May-2010 07:15
;prime 256: peak-phases value: 25.419292, current: 25.416395401039, diff: -0.0028965989614846
;all done! Mon 31-May-2010 07:51

;;; gad161: clean-up-evens
