.TH sndconfig 8 "Wed Aug 19 1998"
.SH NAME
sndconfig \- configure sound card for use with Linux kernel modules
.SH SYNOPSIS
.B sndconfig
{\-\-help,\-\-noprobe,\-\-noautoconfig}
.br
.SH DESCRIPTION
\fBsndconfig\fR sets up the necessary configuration files 
to use a sound card on a Red Hat system. If PnP support is compiled
in, by default \fBsndconfig\fR will
do an initial probe for PnP sound cards using the \fBpnpdump\fR utility.
If the \fB\-\-noprobe\fR option is given this step will be skipped.
The user will be notified if any cards were found. Otherwise the user
must pick the card type from a menu. Then the user must choose the
I/O port, IRQ, and DMA settings for the sound card. These must be
known ahead of time and depend upon the jumper settings of the sound card.
For PnP cards, the program will determine settings for the card; if the
\fB\-\-noautoconfig\fR option is given the user can choose the values which
will be programmed into the PnP device. \fBThere is no guarantee that the
values entered do not conflict with an existing non-PnP or PnP device\fR.
The user must make sure these types of conflicts do not occur.

.SS OPTIONS
.TP
.I "\-\-help"
Print a usage message on standard output and exit successfully.

.TP
.I "\-\-noprobe"
No probe will be made for PnP cards, and the PnP configuration files will
not be changed.

.TP
.I "\-\-noautoconfig"
No autoconfiguration of PnP cards will be done; the user will be prompted
for settings.

.SH FILES
.DT

/etc/sysconfig/soundcard	Stores current settings
/etc/modules.conf		Stores sound module configuration
/etc/isapnp.conf		Stores PnP configuration

.SH "SEE ALSO"
isapnp(1), pnpdump(1)

