#!/usr/bin/perl
# This program was written by Anthony Stevens (astevens@chaotic.org), and is
# free for distrubtion. The author will not be liable for any damages caused by
# this software. Anyone is free to make modifications / enhancements to this
# script, as long as changes are sent back to me so that they may be included
# in# the official distrubtion.     

require 'getopts.pl';

#&Getopts('a:dt:iI:');
&Getopts ('hc:d');
if (defined($opt_h)) {
 print "Guardian v1.0.. \n";
 print "guardian.pl [-hd] <-c config>\n";
 print " -h  shows help\n";
 print " -d  run in debug mode (doesn't fork, output goes to STDOUT)\n";
 print " -c  specifiy a configuration file other than the default (/etc/guardian.conf)\n";
 exit;
}
&load_conf;

# get the default time limit, or set no time limit...
#if (defined ($opt_t)) { $timelimit = $opt_t} else {$timelimit = 0}

print "My ip address and interface are: $hostipaddr $interface\n";

if ($hostipaddr !~ /\d+\.\d+\.\d+\.\d+/) {
   print "This ip address is bad : $hostipaddr\n";
   die "I need a good host ipaddress\n";
}

$networdaddr = $hostipaddr;
$networkaddr =~ s/\d$/0/;
$gatewayaddr = $hostipaddr;
$gatewayaddr =~ s/\d$/$hostgatewaybyte/;
$broadcastaddr = $hostipaddr;
$broadcastaddr =~ s/\d$/255/;
&build_ignore_hash;

# This is the target hash. If a packet was destened to any of these, then the
# sender of that packet will get denied, unless it is on the ignore list..

%targethash = ( "$networkaddr" => 1, 
              "$broadcastaddr" => 1,
              "$hostipaddr" => 1);

if (!defined($opt_d)) {
  print "Becoming a daemon..\n";
  &daemonize;
} else { print "Running in debug mode..\n"; }

open (ALERT, $alert_file) or die "open $alert_file: $!\n";
@junk=<ALERT>;
# this is the same as a tail -f :)
for (;;) { 
  sleep 1; 
  if (seek(ALERT,0,1)){ 
    while (<ALERT>) { 
      chop;
      if (defined($opt_d)) {print "$_\n";}
      if (/\[\*\*\]\s+(.*)\s+\[\*\*\]/){ 
        $type=$1;
      }
      if (/(\d+\.\d+\.\d+\.\d+):\d+ -\> (\d+\.\d+\.\d+\.\d+):\d+/) {
        &checkem ($1, $2, $type);
      }
    } 
  } 
}

sub checkem {
  my ($source, $dest,$type) = @_;
  my $flag=0;
  my $date = localtime();
  return 1 if ($source eq $hostipaddr); # this should prevent is from nuking
                                       # ourselves 
  return 1 if ($source eq $gatewayaddr); # or our gateway 
  if ($ignore{$source} == 1) { # check our ignore list..
     &write_log("$date: ");
     &write_log("$source\t$type\n");
     &write_log("Ignoring attack because $source is in my ignore list\n");
     return 1;
  }
  # if the offending packet was sent to us, the network, or the broadcast, then
  # deny the punk ass.. 
  if ($targethash{$dest} == 1) {   
    &write_log("$date: ");
    &ipchain ($source, $dest, $type);
  }
  # you will see this if the destination was not in the $targethash, and the
  # packet was not ignored before the target check.. 
  else { 
    &write_log ("Odd.. source = $source, dest = $dest. No action done.\n"); 
    if (defined ($opt_d)) {
      foreach $key (keys %targethash) {
	&write_log ("targethash{$key} = $targethash{$key}\n");
      }
    }
  }
}

sub ipchain { 
  my ($source, $dest, $type) = @_;
  &write_log ("$source\t$type\n");
  if ($hash{$source} != 1) {
    &write_log ("adding '-A input -s $source -i $interface -j DENY' to ipchains\n");
    system ("/sbin/ipchains -A input -s $source -i $interface -j DENY");
    $hash{$source} = 1;
  }
  # print "$source already Denied.\n";
}
  
sub build_ignore_hash {
#  This would cause is to ignore all broadcasts if it
#  got set.. However if unset, then the attacker could spoof the packet to make
#  it look like it came from the network, and a reply to the spoofed packet
#  could be seen if the attacker were on the local network. 
#  $ignore{$networkaddr}=1; 

# same thing as above, just with the broadcast instead of the network.
#  $ignore{$broadcastaddr}=1;
  my $count =0;
  $ignore{$gatewayaddr=1};
  $ignore{$hostipaddr}=1;
  if ($ignorefile ne "") {
    open (IGNORE, $ignorefile);
    while (<IGNORE>) {
      chop;
      next if (/\#/);  #skip comments
      next if (/^\s*$/); # and blank lines
      $ignore{$_}=1;
      $count++;
    }
    close (IGNORE);
    print "Loaded $count addresses from $ignorefile\n";
  } else {
    print "No ignore file was loaded!\n";
  }
}

sub load_conf {
  if ($opt_c eq "") {
    $opt_c = "/etc/guardian.conf";
  }
  if (! -e $opt_c) {
    die "Need a configuration file.. please use to the -c option to name a
configuration file\n";
  }
  open (CONF, $opt_c) or die "Cannot read the config file $opt_c, $!\n";
  while (<CONF>) {
    chop;
    next if (/^\s*$/); #skip blank lines
    next if (/^#/); # skip comment lines
    if (/LogFile\s+(.*)/) {
       $logfile = $1;
    }
    if (/Interface\s+(.*)/) {
       $interface = $1;
    }
    if (/AlertFile\s+(.*)/) {
       $alert_file = $1;
    }
    if (/IgnoreFile\s+(.*)/) {
       $ignorefile = $1;
    }
    if (/HostIpAddr\s+(.*)/) {
       $hostipaddr = $1;
    }
    if (/HostGatewayByte\s+(.*)/) { 
       $hostgatewaybyte = $1;
    }
    if (/ipchainsPath\s+(.*)/) {
       $ipchains_path = $1;
    }
  } 
  if ($interface eq "") {
    die "Fatal! Interface is undefined.. Please define it in $opt_o with keyword Interface\n";
  }
  if ($alert_file eq "") {
    print "Warning! AlertFile is undefined.. Assuming /var/log/snort.alert\n";
    $alert_file="/var/log/snort.alert";
  }
  if ($hostipaddr eq "") {
    print "Warning! HostIpAddr is undefined! Attempting to guess..\n";
    $hostipaddr = &get_ip($interface);
    print "Got it.. your HostIpAddr is $hostipaddr\n";
  } 
  if ($ignorefile eq "") {
    print "Warning! IgnoreFile is undefined.. going with default ignore list (hostname and gateway)!\n";
  }
  if ($hostgatewaybyte eq "") {
    print "Warning! HostGatewayByte is undefined.. gateway will not be in ignore list!\n";
  }
  if ($ipchains_path eq "") {
    print "Warning! ipchainsPath is undefined.. Using default of /sbin/ipchains\n";
  }
  if ($logfile eq "") {
    print "Warning! LogFile is undefined.. Assuming debug mode, output to STDOUT\n";
    $opt_d = 1;
  }
  if (! -w $logfile) {
    print "Warning! Logfile is not writeable! Engaging debug mode, output to STDOUT\n";
    $opt_d = 1;
  }
}


sub write_log {
  my $message = $_[0];
  if (defined($opt_d)) {  # we are in debug mode, and not daemonized
    print STDOUT $message;
  } else {
    open (LOG, ">>$logfile");
    print LOG $message;
    close (LOG);
  }
}



sub daemonize {
  my ($home);
 
  if (fork()) {
  # parent
    exit(0);
  } else {
    # child
    &write_log ("Guardian process id $$\n");
    $home = (getpwuid($>))[7] || die "No home directory!\n";
    chdir($home);                   # go to my homedir
    setpgrp(0,0);                   # become process leader
 
    close(STDOUT);
    close(STDIN);
    close(STDERR);
    print "Testing...\n";
  }
}                                              

sub get_ip {
  my ($interface) = $_[0];
  my $ip;
  open (IFCONFIG, "/sbin/ifconfig $interface |");
  while (<IFCONFIG>) {
    if (/inet addr:(\d+\.\d+\.\d+\.\d+)/) { 
      $ip = $1;
    }
  }
  close (IFCONFIG);
  if ($ip eq "") { die "Couldn't figure out the ip address\n"; }
  $ip;
}
