from math import cos, sin
import random, pygame
import data
from OpenGL.GL import *
import random
import settings


class SnowParticles:
    def __init__(self, x, y, direction, numparticles):
        self.x = x
        self.y = y

        self.particles = set()

        for i in xrange(numparticles):
            dx, dy = direction
            dx += (random.random() -1) * 50
            dy += (random.random() -1) * 50
            self.particles.add(((0,0), (dx,dy), 10))

    def run(self, timestep):
        old_particles = self.particles
        self.particles = set()
        for (x,y), (mx,my), life_left in old_particles:
            dx = self.x+x
            dy = self.y+y

            if life_left: opc = life_left/5.0
            else:         opc = 0

            glPushMatrix()
            glColor4f(1, 1, 1, opc)
            glTranslatef(dx, dy, 0)
            data.snowparticle.render()
            glPopMatrix()

            x += mx*timestep
            y -= my*timestep
            life_left -= 1
            if life_left > 0:
                self.particles.add(((x,y), (mx,my), life_left))

        if self.particles:
            return True
        else: return False


class Snowball:
    @classmethod
    def throw_at_target(cls, penguin, target_penguin):
        """
        Starts the snowball with being thrown as a specified target, with
        random accuracy.
        """
        x, y = penguin.x*32, penguin.y*32

        if penguin.x <= target_penguin.x + 3 and penguin.x >= target_penguin.x - 3\
        and penguin.y <= target_penguin.y + 3 and penguin.y >= target_penguin.y - 3:
            t_x_t = target_penguin.x
            t_y_t = target_penguin.y
        else:
            t_x_t = random.randint(target_penguin.x-1,target_penguin.x+1)
            t_y_t = random.randint(target_penguin.y-1,target_penguin.y+1)
        t_x = t_x_t*32+random.randint(0, 20)
        t_y = t_y_t*32+random.randint(0, 20)
        return cls(x,y,t_x,t_y,penguin)


    def __init__(self, x, y, t_x, t_y, penguin=None):
        self.x, self.y = self.start_x, self.start_y = x, y
        self.t_x, self.t_y = t_x, t_y

        self.speed = .15
        self.y_offset = 0

        self.dist_x = self.t_x - self.x
        self.dist_y = self.t_y - self.y

        self.dist = (self.dist_x**2 + self.dist_y**2)**.5
        #self.remaining_dist = -self.dist/2
        self.total_time = self.dist/self.speed

        self.height = ((self.dist/2)/10)**2

        self.start_time = data.get_ticks()

        self.penguin = penguin

    def move(self):
        time_diff = data.get_ticks()-self.start_time
        to_move = time_diff*self.speed

        mx = (to_move*self.dist_x)/self.dist
        my = (to_move*self.dist_y)/self.dist

        self.x = self.start_x + mx
        self.y = self.start_y + my

        offset = -((to_move-self.dist/2)/10)**2 + self.height
        #print offset
        #print self.height, self.dist, to_move
        self.y_offset = offset/2

        if data.get_ticks() - self.start_time >= self.total_time:
            # Snowball reached dest.
            t_x_t = self.t_x // 32
            t_y_t = self.t_y // 32

            tile = data.map.tiles[(t_x_t,t_y_t)]

            vw = data.view.w
            vh = data.view.h
            hit = 1
            if tile.resource:
                hit = 0
            else:
                for u in data.map.unit_nodes.get_objs_around_tile((t_x_t,t_y_t)):
                    #if u.player is not self.player:
                    if u.warmth > 0:
                        if u.state != "inbuilding":
                            v = u.detect_hit(self, t_x_t,t_y_t)
                            if v == 2: hit = 2

            if hit != 2 and int(settings.get_option("snowballdetail")) >= 2:
                if tile.type == "snow":
                    data.snowballimprents.add(self.x, self.y)
                else:
                    data.snowball_ice_imprents.add(self.x, self.y)

            if self.x > data.view.x and self.x < data.view.x+vw\
                    and self.y > data.view.y and self.y < data.view.y+vh:
                y = self.dist_y / 4.0
                x = self.dist_x / 4.0
                if hit == 2:
                    x = -x
                    particles = random.randint(10,15)
                else:
                    particles = random.randint(5,8)

                if int(settings.get_option("snowballdetail")) == 3:
                    data.particles.add(SnowParticles(self.x, self.y, (x,-y), particles))

            return True
        return False
