from __future__ import division
import random
from cStringIO import StringIO
from struct import pack, calcsize

from OpenGL.GL import *

import data


class Terrain(object):
    def __init__(self, image):
        #self.image = image
        #self.vsize = (self.image.size[0]+1, self.image.size[1]+1)
        self.vsize = (data.map.size[0]+1, data.map.size[1]+1)
        #self.vertexes = ((c_int*2)*(self.vsize[0]*self.vsize[1])))()
        #self.texcoords = ((c_float*2)*(self.vsize[0]*self.vsize[1])))()
        #self.colors = ((c_float*4)*(self.vsize[0]*self.vsize[1])))()

        pos_s = StringIO()
        tex_s = StringIO()
        color_s = StringIO()




        tsize = 256

        for vy in xrange(self.vsize[1]):
            for vx in xrange(self.vsize[0]):
                #i = self.vsize[0]*vy + vx
                pos_s.write(pack("ii", vx*32, vy*32))
                tex_s.write(pack("ff", vx*32/tsize, vy*32/tsize))
                total = 0
                num = 0
                for key in [(vx,vy), (vx-1, vy), (vx-1, vy-1), (vx, vy-1)]:
                    try:
                        tile = data.map.tiles[key]
                        if tile.type == "ice":
                            total += 1
                        num += 1
                    except KeyError: pass
                alpha = total/num
                if alpha == .5:
                    alpha += random.random()*.8-.4
                color_s.write(pack('ffff', 1.0, 1.0, 1.0, alpha))

        self.vertex_data = pos_s.getvalue()
        self.color_data = color_s.getvalue()
        self.tex_data = tex_s.getvalue()

        self.row_indexes = []
        for y in range(self.vsize[1]-1):
            index_s = StringIO()
            for x in range(self.vsize[0]):
                index_s.write(pack("II", y*self.vsize[0] + x,
                        (y+1)*self.vsize[0] + x))
            self.row_indexes.append(index_s.getvalue())


    def draw(self, range_x, range_y):
        start_x = int(max(range_x[0]*2, 0))
        end_x = int(min(range_x[1]*2+1, self.vsize[1]*2))
        start_y = int(max(range_y[0], 0))
        end_y = int(min(range_y[1]+1,self.vsize[1]-1))

        glEnableClientState(GL_VERTEX_ARRAY)
        glEnableClientState(GL_COLOR_ARRAY)
        glEnableClientState(GL_TEXTURE_COORD_ARRAY)

        glVertexPointer( 2, GL_INT, 0, self.vertex_data)
        glColorPointer(4, GL_FLOAT, 0, self.color_data)
        glTexCoordPointer(2, GL_FLOAT, 0, self.tex_data)

        s = calcsize("I")
        for y in range(start_y, end_y):
            glDrawElements(GL_QUAD_STRIP, end_x - start_x, GL_UNSIGNED_INT,
                    self.row_indexes[y][start_x*s:end_x*s])

        glDisableClientState(GL_VERTEX_ARRAY)
        glDisableClientState(GL_COLOR_ARRAY)
        glDisableClientState(GL_TEXTURE_COORD_ARRAY)
